/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

/*
 * AutoupdatePanel.java
 *
 * Created on Jul 2, 2009, 6:52:07 PM
 */

package org.netbeans.modules.bugtracking.commons;

import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Stupka
 */
public class AutoupdatePanel extends javax.swing.JPanel {
    private final AutoupdateSupport support;

    @NbBundle.Messages({"LBL_DontShow=Don't show this message again",
                        "# {0} - pluginName", "TXT_text="
                                               + "The {0} server you are trying to access has a higher "
                                               + "version than the one supported by NetBeans. "
                                               + "Do you want to download an update from the NetBeans Update Center?"})            
    /** Creates new form AutoupdatePanel */
    public AutoupdatePanel(AutoupdateSupport support) {
        initComponents();
        txtTextArea.setText(Bundle.TXT_text(support.getPluginName()));
        dontShowCheckBox.setText(Bundle.LBL_DontShow());
        this.support = support;
        dontShowCheckBox.setSelected(!support.getCheckUpdates());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        txtTextArea = new javax.swing.JTextArea();

        jScrollPane1.setBorder(null);

        txtTextArea.setEditable(false);
        txtTextArea.setBackground(javax.swing.UIManager.getDefaults().getColor("Panel.background"));
        txtTextArea.setColumns(20);
        txtTextArea.setLineWrap(true);
        txtTextArea.setRows(5);
        txtTextArea.setWrapStyleWord(true);
        jScrollPane1.setViewportView(txtTextArea);

        dontShowCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dontShowCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 409, Short.MAX_VALUE)
                    .addComponent(dontShowCheckBox))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 86, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(dontShowCheckBox)
                .addContainerGap(21, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void dontShowCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dontShowCheckBoxActionPerformed
        support.setCheckUpdates(!dontShowCheckBox.isSelected());
    }//GEN-LAST:event_dontShowCheckBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JCheckBox dontShowCheckBox = new javax.swing.JCheckBox();
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea txtTextArea;
    // End of variables declaration//GEN-END:variables

}
