/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToMasterTbl
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readBasisSet(data, elementList, optimize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        output.append("!\n!\t\t" + this.mTitle + " BASIS\n!\n");
        output.append("NAME=\"" + this.mTitle + "\"\n");
        String contractionType = root.getChildText("contractionType", BSEProperties.mEmslNs);
        if (contractionType == null) {
            output.append("GENR=F\n");
        } else if (contractionType.equalsIgnoreCase("segmented")) {
            output.append("GENR=F\n");
        } else if (contractionType.equalsIgnoreCase("general")) {
            output.append("GENR=T\n");
        } else {
            if (!contractionType.equalsIgnoreCase("uncontracted")) throw new FormatException("Contraction Type [" + contractionType + "] was not recognized!");
            output.append("GENR=F\n");
        }
        String basisSetType = root.getChildText("basisSetType", BSEProperties.mEmslNs);
        if (basisSetType == null) {
            throw new FormatException("Failed to parse element basisSetType!");
        }
        String category = "ORBITAL";
        if (basisSetType.equalsIgnoreCase("ecporb")) {
            category = "ECP";
        } else if (basisSetType.equalsIgnoreCase("dftorb")) {
            category = "DFTORB";
        } else if (basisSetType.equalsIgnoreCase("dftxfit")) {
            category = "DFTXFIT";
        } else if (basisSetType.equalsIgnoreCase("dftcfit")) {
            category = "DFTCFIT";
        } else if (basisSetType.equalsIgnoreCase("periodic")) {
            category = "PERIODIC";
        } else if (basisSetType.equalsIgnoreCase("polarization") || basisSetType.equalsIgnoreCase("diffuse") || basisSetType.equalsIgnoreCase("tight") || basisSetType.equalsIgnoreCase("rydberg")) {
            category = "AUXILIARY";
        } else if (basisSetType.equalsIgnoreCase("pople") || basisSetType.equalsIgnoreCase("other_segmented") || basisSetType.equalsIgnoreCase("correlation_consistent") || basisSetType.equalsIgnoreCase("other_generally_contracted")) {
            category = "ORBITAL";
        }
        output.append("CATEGORY=" + category + "\n");
        String typeAbstract = root.getChildText("abstract", BSEProperties.mDctNs);
        if (typeAbstract == null) {
            typeAbstract = "undefined";
        } else if (typeAbstract.compareTo("null") == 0) {
            typeAbstract = "undefined";
        }
        output.append("TYPE=\"" + typeAbstract + "\"\n");
        String descInfo = root.getChildText("description", BSEProperties.mDcNs);
        output.append("INFO=\n\"" + descInfo + "\"\n");
        Element pbsLink = root.getChild("primaryBasisSetLink", BSEProperties.mEmslNs);
        if (pbsLink != null) {
            String pbsHREF = pbsLink.getAttributeValue("href", BSEProperties.mXlinkNs);
            if (pbsHREF == null || !pbsHREF.endsWith(".xml")) throw new FormatException("Could not determine BAS link file!");
            String bsFile = pbsHREF.substring(0, pbsHREF.indexOf(".xml"));
            output.append("FILE=\"" + bsFile + ".BAS\"\n");
        } else {
            output.append("FILE=\"" + this.mTitle + ".BAS\"\n");
        }
        List bsLinks = root.getChildren("basisSetLink", BSEProperties.mEmslNs);
        Iterator iLinks = bsLinks.iterator();
        int fileIdx = 2;
        while (iLinks.hasNext()) {
            Element bsLink = (Element)iLinks.next();
            String bsHREF = bsLink.getAttributeValue("href", BSEProperties.mXlinkNs);
            if (bsHREF == null || !bsHREF.endsWith(".xml")) {
                throw new FormatException("Could not determine ECP link file!");
            }
            String bsFile = bsHREF.substring(0, bsHREF.indexOf(".xml"));
            output.append("FIL" + fileIdx + "=\"" + bsFile + ".BAS\"\n");
            ++fileIdx;
        }
        Element epLink = root.getChild("effectivePotentialsLink", BSEProperties.mEmslNs);
        if (epLink != null) {
            String epHREF = epLink.getAttributeValue("href", BSEProperties.mXlinkNs);
            if (epHREF == null || !epHREF.endsWith("-ECP.xml")) throw new FormatException("Could not determine ECP link file!");
            String ecpFile = epHREF.substring(0, epHREF.indexOf("-ECP.xml"));
            output.append("ECPFILE=\"" + ecpFile + ".POT\"\n");
        }
        List dftLinks = root.getChildren("dftFittingLink", BSEProperties.mEmslNs);
        for (Element dftLink : dftLinks) {
            String dftHREF = dftLink.getAttributeValue("href", BSEProperties.mXlinkNs);
            if (!dftHREF.endsWith(".xml")) throw new FormatException("Could not determine dft link file!");
            String dftFile = dftHREF.substring(0, dftHREF.indexOf(".xml"));
            if (dftFile.indexOf("COU") > -1) {
                output.append("COUFILE=\"" + dftFile + ".BAS\"\n");
                continue;
            }
            if (dftFile.indexOf("EXC") <= -1) throw new FormatException("Could not determine dft link file type!");
            output.append("EXCFILE=\"" + dftFile + ".BAS\"\n");
        }
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
    }
}

