#include "common/scummsys.h"

// In this file, the TYPO tag is used when a typo is fixed in a piece of text, or when
// text is changed to match the audio.

namespace StarTrek {

extern const char *const g_gameStrings[] = {
	NULL,
	"",
	"Dialog error",
	"Animation error",

	"Capt. Kirk",
	"Mr. Spock",
	"Dr. McCoy",
	"Lt. Uhura",
	"Mr. Scott",
	"Mr. Sulu",
	"Mr. Chekov",

	"Ensign Everts",
	"Prel. Angiven",
	"Sign",
	"Klingon",
	"Brother Kandrey",
	"Brother Stephen",
	"Brother Chub",
	"Brother Roberts",
	"Brother Grisnash",
	"Nauian",
	"Ship's Computer",

	"Lt. Christensen",
	"Crewman Simpson",
	"Elasi Guard",
	"Elasi Clansman",
	"Elasi Cereth",
	"Masada Crewman",

	"Lt. Ferris",
	"Computer",
	"Dr. Marcus",
	"Dr. Cheever",
	"Preax",

	"Lt. Buchert",
	"Harry Mudd",

	"Lt. Stragey",
	"Quetzecoatl",
	"Tlaoxac",

	"Ensign Bennie",
	"Vlict",
	"Klingon Guard",
	"Entity",
	"Bialbi",
	"A Voice Speaks",
	"Light of War",
	"Light of Knowledge",
	"Light of Travel",

	"Ensign Mosher",

	"Ensign Kije",
	"*Capt. Patterson*",
	"*Commander Andrade*",
	"Elasi Captain",
	"Elasi Weapons Master",
	"Elasi Crewman",
	"Brittany Marata",

	"#BRID\\BRIDU146#Nothing to report, Captain.",

	"#GENE\\G_014#This person's dead, Jim.",
	"#GENE\\G_024#Fascinating.",
	"#GENE\\G_043#Ouch! Watch it with that thing!",

	"#GENE\\GENER004#Game Over",

	"#COMP\\COMPA180#Orbit Stabilized. Warning Cancelled.",
	"#COMP\\COMPA185#Please select an impedence.",
	"#COMP\\COMPA186#Ammonia",
	"#COMP\\COMPA187#Di-hydrogen Oxide",
	"#COMP\\COMPA189#Nitrous Oxide",
	"#COMP\\COMPA190#Oroborus Virus",
	"#COMP\\COMPA191#Exit Database",
	"#COMP\\COMPA193#TLTDH Gas",
	"#COMP\\COMPU181#Warning. Orbital Decay is now irreversible. Abandon Ship. Abandon Ship.",
	"#COMP\\COMPU182#Warning. Orbital decay detected. Warning.",
	"#COMP\\COMPU186#Ammonia: a colorless pungent compound NH3, a common byproduct of metabolism in carbon-based lifeforms. Liquid or gaseous at 1 atm. Compounds widely used in agricultural, medical and industrial applications.",
	"#COMP\\COMPU187#Di-hydrogen Oxide: a colorless, tasteless, nonflammable compound HO- water. Liquid, solid, or gaseous at 1 atm. Temperature scales defined in most humanoid cultures by state-shift of pure water.",
	"#COMP\\COMPU188#Dr. Marcus' Log, Supplemental: Continued testing of the Oroborus Virus confirms its potential harmful effects on Romulan/Vulcan humanoids. As soon as the spill has been cleaned up, we will sterilize both labs and purge the circulation system to make sure no traces of the virus will remain viable. Then all research files must be erased -- we must leave no chance that this terrible accident will ever be repeated.",
	"#COMP\\COMPU189#Nitrous Oxide: a colorless nonflammable compound NO, gaseous at 1 atm and temperatures within the human norm. Early anesthetic among humans, in whom it produces laughter, feelings of exhiliration, euphoria; sometimes leading to unconsciousness.",
	"#COMP\\COMPU190#Oroborus virus: Atypical growth patterns for L-Type virus. Opportunistic pneumococcal mimic affecting Romulo-Vulcan genotype. Etiology: contact or airborne vector with alveoli microcollapse involvement immediately upon exposure. Tissue dehydration follows pneumal flooding. Mortality: 0.6 in 1.0 stardates, 1.0 within 2.0 stardates Treatment: none. Named for the mythic worldsnake that swallows its own tail.",
	"#COMP\\COMPU192#Please select subject file...",
	"#COMP\\COMPU193#TLTDH gas: The chemical compound tantalum bi-lithium thalo-dihydroxide. Colorless, odorless, nonflammable gaseous at 1 atm and temperatures within the human norm. Early anesthetic among Vulcans and Romulans, in whom it produces laughter, feelings of exhiliration, euphoria; sometimes leading to unconsciousness. In post-industrial/pre-spaceflight era, a social problem evolved when crude TLTDH became popular to \"cook up\" from non-conductive tantalo-lithial compounds commonly used as electrical insulation.",

	"#DEM0\\DEM0N009#Spock raises an eyebrow.",	// kept because it's used as an enhancement in mudd1
	"All mining equipment use this road.",

	"#DEM1\\DEM1_F23#Federation Scum!",

	"#DEM3\\DEM3_019#He's dead, Jim...",

	"#DEM3\\DEM3_A32#Aieeee!",
	"#DEM3\\DEM3_B32#Aieeeee.",
	"#DEM3\\DEM3_F21#Oh, thank you, kind souls, for saving my life. Let me rest here for a little before returning to report this miracle to Prelate Angiven.",

	"#TUG0\\TUG0_F30#I suppose I should be grateful to see anyone after that. I thought I was dead.",
	"#TUG0\\TUG0_F31#Thank you, Doctor. Be careful, Captain, the Elasi like to set boobytraps. if you need any equipment I've got my tools in this workspace.",
	"#TUG0\\TUG0_S06#Aye Captain.",
	"#TUG0\\TUG0_S11#Captain, you're alive!",

	//"#TUG1\\TUG1_007#The force field is interfering too much to get an accurate reading, Jim.", // TYPO
	"#TUG1\\TUG1_011#I strongly recommend that we keep our silence, Captain. The Elasi are quite capable of tracing any communication from within this vessel.",

	"#TUG2\\TUG2_004#A medium strength phaser bomb. The brig force field would contain the explosion but it would kill the crew members within the cell. I recommend that we find a way of disarming it, Captain.",
	"#TUG2\\TUG2_007#Captain, the switch has been booby-trapped to detonate a bomb, presumably inside the brig somewhere.",
	"#TUG2\\TUG2_010#I don't like the looks of this, Jim.",
	"#TUG2\\TUG2_011#I don't operate on bombs, Jim, unless you like big explosions.",
	"#TUG2\\TUG2_015#The crew is tired and has elevated signs from extreme stress, but they will survive.",
	"#TUG2\\TUG2_016#The pirates won't wake for a while, but they are going to be quite unhappy when they do. I recommend that we not be here when they awake.",
	"#TUG2\\TUG2_019#They're all dead, Jim. What in God's name were you thinking?",
	"#TUG2\\TUG2J001#Don't you know any better?",
	"#TUG2\\TUG2J002#What kind of idiot are you?",
	"#TUG2\\TUG2J003#I recommend extreme caution, Captain. We must be ready to expect anything.",
	"Snip...snip...snip.",

	"#TUG3\\TUG3_F27#Foolhardy words, Kirk. You have underestimated me at every turn.",
	"#TUG3\\TUG3_S07#Aye, Captain.",
	"#TUG3\\TUG3_S08#Aye, Captain.",

	"#LOV0\\LOV0_005#Doctor, you may be interested in the medical data file appended to the log.",
	"#LOV0\\LOV0_011#Hee hee hee hee...",
	"#LOV0\\LOV0_012#I think we're all feeling just woooonderful!",
	"#LOV0\\LOV0_013#I'm a little teapot short and stout...",
	"#LOV0\\LOV0_014#I'm floating up and up and up...",
	"#LOV0\\LOV0_015#I'm so happy, I want to hug the world!",
	"#LOV0\\LOV0_016#Ooka! Ooka! Ooka!",
	"#LOV0\\LOV0_017#Row, row, row, your boat. Aww, come on Spock.",
	"#LOV0\\LOV0_019#Spock, ol' buddy, ol' friend, you look soo funny standing there!",
	"#LOV0\\LOV0_020#The hills are alive... With the sounds of...",
	"#LOV0\\LOV0_021#The moon in June's a boon to tunes... er, something like that.",
	"#LOV0\\LOV0_022#This is how I want to feel all the time!",
	"#LOV0\\LOV0_025#How many Admirals does it take to wire in a logic transmogrifier?",
	"#LOV0\\LOV0_026#I don't believe you'd behave like this if you could avoid it.",
	"#LOV0\\LOV0_029#Please, gentlemen, try to control yourselves",
	"#LOV0\\LOV0_030#That is not logical, Captain.",
	"#LOV0\\LOV0_033#Try taking deep breaths to clear your heads.",
	"#LOV0\\LOV0_039#Hee hee hee hee...",
	"#LOV0\\LOV0_040#I think we're all feeling just woooonderful!",
	"#LOV0\\LOV0_041#I'm a little teapot short and stout...",
	"#LOV0\\LOV0_042#I'm floating up and up and up...",
	"#LOV0\\LOV0_043#I'm so happy, I want to hug the world!",
	"#LOV0\\LOV0_045#Ooka! Ooka! Ooka!",
	"#LOV0\\LOV0_046#Row, row, row, your boat. Aww, come on Spock.",
	"#LOV0\\LOV0_047#Spock, ol' buddy, ol' friend, you look soo funny standing there!",
	"#LOV0\\LOV0_048#The hills are alive... With the sounds of...",
	"#LOV0\\LOV0_050#This is how I want to feel all the time!",
	"#LOV0\\LOV0_101#Fascinating. I am experiencing an urge to laugh.",
	"#LOV0\\LOV0_102#I am a Vulcan. I must resist these unchecked emotions.",
	"#LOV0\\LOV0_103#Logic... What happened to my logic?", // TYPO
	"#LOV0\\LOV0_104#Jim, is this how you feel on shore leave?",
	"#LOV0\\LOV0_105#I remember my mother trying to tell me jokes when I was a child. Now, I finally understand them.",
	"#LOV0\\LOV0_106#Romulan laughing gas. My father would never approve.",
	"#LOV0\\LOV0_107#Why do they call you \"Bones\", doctor?",
	"#LOV0\\LOV0_124#I'm trying to be patient, Captain.",
	"#LOV1\\LOV1_010#I'm picking up some strange, airborne virus. I can't identify it without more information.",
	"#LOV1\\LOV1N007#Done.",

	//"#LOV0\\LOV0_103#Logic... What happened to my logic?", // TYPO
	//"#LOV2\\LOV2_034#I don't think that's useful in your experiment, Doctor.", // TYPO (in audio filename)
	//"#LOV2\\LOV2_039#This does not appear to provide us with anything useful.", // TYPO (in audio filename)
	//"#LOV2\\LOV2N010#Lt. Ferris is carefully watching the hallway.", // TYPO
	//"#LOV2\\LOV2N036#You retrieve the Oroborus virus culture.", // TYPO
	//"#LOV2\\LOV2N037#You retrieve the Oroborus virus cure sample.", // TYPO
	//"#LOV3\\LOV3N000#All readings are normal.", // TYPO: audio filename was wrong
	"#LOV2\\LOV2N005#A loud hissing fills the room.",
	"#LOV2\\LOV2N007#Gas feed is off.",
	"#LOV3\\LOV3NA08#With a hiss, the Romulan Laughing Gas billows down the vent. Things are strangely quiet below.",
	"#LOV3\\LOV3NA09#With a hiss, the Romulan Laughing Gas billows down the vent. You hear the muffled sounds through the vent of hearty Romulan laughter, followed by the dull thud of bodies hitting the deck.",
	"#LOV3\\LOV3NA20#This is a service access panel, permitting used-up or worn materials to be replaced.",
	"#LOV3\\LOV3NA21#This is a vent shaft that leads to the lower level.",
	"#LOV3\\LOV3NA22#This is an engineering access panel, allowing repairs to be made to the interior wiring in the equipment.",
	"#LOV3\\LOV3NA23#This is the engineering center for the ARK7 space station.",
	"#LOV3\\LOV3NJ32#You attach the antigrav unit to the gas tank. It can be moved freely.",
	"#LOV5\\LOV5_015#He's already cured, Jim.",
	"#LOV5\\LOV5_019#I don't have the proper medicine to cure him, Jim.",
	"#LOV5\\LOV5_027#Finally, a human response!",
	"#LOV5\\LOV5_030#There. You're now cured.",
	"#LOV5\\LOV5_038#Thank you, Doctor.",
	"(Raises an eyebrow)", // NOTE: no corresponding audio


	"#LOVA\\LOVA_100#He's dead, Jim.",
	"#LOVA\\LOVA_F01#He's been cured of the Oroborus virus.",
	"#LOVA\\LOVA_F02#I'm picking up some kind of virus. I can't identify it without more information.",
	"#LOVA\\LOVA_F03#He's infected with the virus, Jim.",
	"#LOVA\\LOVA_F04#The virus affects the Romulan-Vulcan genotype, Jim.",
	"#LOVA\\LOVA_F07#All lifesigns are normal.",
	"#LOVA\\LOVA_F08#It's what I was afraid of, Jim. I think Spock is getting worse.", // TYPO
	"#LOVA\\LOVA_F10#He has weak vital signs.",
	"#LOVA\\LOVA_F54#The virus has spread to me, Captain. I suggest you concentrate your efforts on the problem.",
	"#LOVA\\LOVA_F55#Jim, we need to synthesize more to make the serum before we can use it.", // TYPO


	"#MUD0\\MUD0_001#Kirk to Enterprise...",
	"#MUD0\\MUD0_002#Well! Now I think we know why the Elasi pirates were so interested in finding out where Mudd was getting these!",
	"#MUD0\\MUD0_003#Bones, Federation law is clear on this. Federation law protects everyone, even Harry Mudd. ",
	"#MUD0\\MUD0_004#Don't push your luck, Harry. ",
	"#MUD0\\MUD0_005#Harry, as official representatives of the Federation, and of Starfleet, we recognize your rights to legitimate salvage.  Need I say more?  ",
	"#MUD0\\MUD0_006#I see, Harry. Well, we'll look around here while the Enterprise remains close by.",
	"#MUD0\\MUD0_007#It was a rhetorical question, Harry. ",
	"#MUD0\\MUD0_008#No Lieutenant, that was Horatio Jones, but Harry Mudd is worse.",
	"#MUD0\\MUD0_009#Well, you're terrible trouble to me, Harry. Tell me what this is all about.",
	"#MUD0\\MUD0_010#Why do I have the feeling that I am about to have a bad day? ",
	"#MUD0\\MUD0_011#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#MUD0\\MUD0_012#These lenses were definitely not made to correct the aliens' vision. Mudd might've been able to sell these among humans as magnifiers, but these people must have had another use for them.",
	"#MUD0\\MUD0_013#These lenses are finely made magnifiers, but I can't help but wonder if that's what the aliens really used them for. ",
	"#MUD0\\MUD0_014#About as much as the Klingons are devoted to pacifism... ",
	"#MUD0\\MUD0_015#For once Spock, I couldn't have said it better myself. ",
	"#MUD0\\MUD0_016#Jim? You can't seriously be thinking of helping Mudd after all he's done. ",
	"#MUD0\\MUD0_017#Then something went wrong, right?",
	"#MUD0\\MUD0_018#Life support down to 25%, Captain.",
	"#MUD0\\MUD0_019#Life support down to 50%, Captain.",
	"#MUD0\\MUD0_020#Life support down to 75%, Captain.",
	"#MUD0\\MUD0_021#These are computer memory transfer media, probably designed for use with the alien computer system.",
	"#MUD0\\MUD0_022#Given the past record of Harry Mudd, Captain, I strongly recommend that you do not trust him. ",
	"#MUD0\\MUD0_023#I am. Your record is that of a greedy, amoral, sociopathic fraud who preys upon human emotion, most notably, gullibility. ", // TYPO (gullability)
	"#MUD0\\MUD0_024#There was the time that you tried to commandeer the Enterprise to sell wives to miners, and then there was the time you stole the Enterprise to exchange us for androids who were holding you prisoner... ",
	"#MUD0\\MUD0_025#Kirk, after all we've been through you wouldn't shoot me would you?",
	"#MUD0\\MUD0_026#Actually no, Doctor, not then. I'd started offering a few other little items I found -- Mudd's Limited coffee substitute -- a great little specialty item; lenses to a firm packaging BuildYerOwn telescope kits; a collection of novelty paints -- things like that.  All of a sudden, the Elasi pirates are asking for me in every quadrant, and wanting to know where I'm getting my goods!",
	"#MUD0\\MUD0_027#And we all know how devoted I am to Federation law. ",
	"#MUD0\\MUD0_028#I happened upon this ship not long ago, and dutifully registered it as salvage, mind you!  In the hold here, I discovered one of these devices -- in that box over there. When I tried one on a wall, it floated off the grease and dirt -- perfect for cleaning, near as I could see. I peddled a few of these Mudd's Miracle De-Grimers and everything was going perfectly well.",
	"#MUD0\\MUD0_029#I understand perfectly, Captain -- Carry on, Captain.",
	"#MUD0\\MUD0_030#It's a system that cost a gambler his life, boy. He crawled up to me and whispered it with his dying breath, and it can be yours for a mere... 200 credits. ",
	"#MUD0\\MUD0_031#Kirk! Now that we're together... ",
	"#MUD0\\MUD0_032#Kirk, my friend! When have I ever given you the slightest bit of trouble? ",
	"#MUD0\\MUD0_033#Look around all you like, Captain, but I'll be keeping an eye on you.  I've registered this derelict as my salvage, and I don't want you running off with all my prizes! ",
	"#MUD0\\MUD0_034#Mr. Spock! Whatever gave you that impression! I thought Vulcans were supposed to be logical. ",
	"#MUD0\\MUD0_035#Perhaps there have been a few minor misunderstandings... ",
	"#MUD0\\MUD0_036#Starfleet! You're all the same. No sense of adventure! ",
	"#MUD0\\MUD0_037#Welcome, Captain Kirk! So glad you're here. The Elasi have been terrible trouble to me.",
	"#MUD0\\MUD0_038#Why I've never been so insulted in all my life! ",
	"#MUD0\\MUD0_039#Didn't Mudd bring those tribbles on board the Enterprise?",
	"#MUD0\\MUD0_040#So you say you know how to break the gambling machines on Curalon IV? ",
	"#MUD0\\MUD0_041#Sorry Mr. Mudd. My mother didn't raise any fools in her family. ",
	"#MUD0\\MUD0N000#A small energy device with a flanged opening at the front, about the size of one's thumbnail.",
	"#MUD0\\MUD0N001#Dr. McCoy looks like he would like to violate the Hippocratic Oath on Harry Mudd, but you know he won't. ",
	"#MUD0\\MUD0N002#Dust and grease lifts off the surface, leaving this item clean as new.",
	"#MUD0\\MUD0N003#Harcourt Fenton Mudd. Of course, he's going to be honest and fair with you... ",
	"#MUD0\\MUD0N004#James T. Kirk looks rather exasperated right now. ",
	"#MUD0\\MUD0N005#Lieutenant Buchert is standing around, watching everyone else converse with Harry Mudd. ",
	"#MUD0\\MUD0N006#Life support fails completely and you fall unconscious.",
	"#MUD0\\MUD0N007#Mr. Spock is as close to annoyed as a Vulcan can get. ",
	"#MUD0\\MUD0N008#Odd-looking contraptions small enough to hold in one hand.",
	"#MUD0\\MUD0N009#The atmosphere in the ship has dropped below the level needed to sustain life. You drop to unconsciousness and slowly die.",
	"#MUD0\\MUD0N010#There are shiny, multi-sided, spherical objects in this box.",
	"#MUD0\\MUD0N011#These two things fit together like they were made for each other.",
	"#MUD0\\MUD0N012#This container holds bricks of what might have been preprocessed food -- a long time ago.",
	"#MUD0\\MUD0N013#This container holds small mechanical components unfamiliar to you.",
	"#MUD0\\MUD0N014#This lense, about the size of one's thumbnail, magnifies like a fine optical glass.  ",
	"#MUD0\\MUD0N015#This storage bay is stockpiled with all manner of goods.",
	"#MUD0\\MUD0N016#You already have that.",
	"#MUD0\\MUD0N017#You can't take that.",
	"#MUD0\\MUD0N019#This place is cluttered with stored goods of every sort. It would take an army of workers weeks to examine every container and determine what is inside.",


	"#MUD1\\MUD1_001#Kirk to Enterprise...",
	"#MUD1\\MUD1_002#Well, now! I think we know why the Elasi pirates were so interested in finding out where Mudd was getting these!",
	"#MUD1\\MUD1_003#I agree that we should take it aboard the Enterprise.  ",
	"#MUD1\\MUD1_004#I don't think we should tinker with technology we don't understand, Spock. And I'm surprised you'd suggest such a thing.",
	"#MUD1\\MUD1_005#I know, Bones. ",
	"#MUD1\\MUD1_006#I wonder what's happening on the Enterprise right now. ",
	"#MUD1\\MUD1_007#I'll try to raise the ship... Kirk to Enterprise, Kirk to Enterprise...",
	"#MUD1\\MUD1_008#If the Elasi gets hold of this, they'll make Mudd seem like a perfect caretaker by comparison. ",
	"#MUD1\\MUD1_009#That machinery in the middle of the room, however, is like nothing I recognize -- and I thought I'd seen just about everything.",
	"#MUD1\\MUD1_010#A weapons-delivery system.  It appears to be an accessory tied directly to the alien equivalent of our ship's phasers and photon torpedoes.",
	"#MUD1\\MUD1_011#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#MUD1\\MUD1_012#I wonder where that Mudd has gone. I wouldn't let him out of my sight... mind you, I'm not too crazy about having him in my sight either. ",
	"#MUD1\\MUD1_013#Scotty will take good care of it, Jim. He has before. ",
	"#MUD1\\MUD1_014#It seems to be part of the loading system for the weapon. It is also fully functional.",
	"#MUD1\\MUD1_015#The control panel has power running to it, Captain.",
	"#MUD1\\MUD1_016#The device has been unloaded, Captain.",
	"#MUD1\\MUD1_017#The device has finished loading, Captain.",
	"#MUD1\\MUD1_019#A most interesting technology, Captain.",
	"#MUD1\\MUD1_020#Evidently these are more than theoretical, Lt. Buchert.  The energy initially released is infinitesimally small but boosts itself until the power finally released is comparable to our photon torpedoes.",
	"#MUD1\\MUD1_021#However, I've already examined the weapons console and the main weapons battery on this ship was completely destroyed in the action which made her a derelict.",
	"#MUD1\\MUD1_022#I believe, Captain, that this weapon must be hooked up through the main weapons battery.",
	"#MUD1\\MUD1_023#Mr. Scott would have to go over this thoroughly, but I would recommend we try to take this weapon with us to the Enterprise.",
	"#MUD1\\MUD1_024#The machinery to deliver these cartridges would be an engineering feat as well, Captain.",
	"#MUD1\\MUD1_025#Unique, Captain.  I believe these are self-referencing packed-quantum cartridges.  ",
	"#MUD1\\MUD1_026#It looks to me like these people knew how to defend themselves, Captain.",
	"#MUD1\\MUD1_027#Powerboosters!  I've read about those --  but they're just theoretical.",
	"#MUD1\\MUD1_028#The technical journals discussing the possibilities indicated it would create a weapon of greater range than those we have now, if not a greater punch.  ",
	"#MUD1\\MUD1N000#A large claw-like device hanging from the ceiling.",
	"#MUD1\\MUD1N001#A red triangular button.",
	"#MUD1\\MUD1N002#A row of unmarked cylindrical containers.",
	"#MUD1\\MUD1N003#An elaborate piece of alien-looking machinery.",
	"#MUD1\\MUD1N004#Dust and grease lifts off the surface, leaving this item clean as new.",
	"#MUD1\\MUD1N005#James T. Kirk, dwarfed by the technology that surrounds him. ",
	"#MUD1\\MUD1N006#Lieutenant Buchert, waiting for a chance to perform his duty. ",
	"#MUD1\\MUD1N007#Life support fails completely and you fall unconscious.",
	"#MUD1\\MUD1N008#McCoy is scowling, probably from your meeting with Harcourt Fenton Mudd. ",
	"#MUD1\\MUD1N009#Mr. Spock is looking forward to the moment that he can sit down at the main computer and analyze the findings of this mission. ",
	"#MUD1\\MUD1N010#The atmosphere in the ship has dropped below the level needed to sustain life. You drop to unconsciousness and slowly die.",
	"#MUD1\\MUD1N011#The room reminds you of the weapons-room of some old-style warships from the early days of starfaring.",
	"#MUD1\\MUD1N012#These cylinders have fallen down from the rest.",
	"#MUD1\\MUD1N013#These two things fit together like they were made for each other.",
	"#MUD1\\MUD1N014#This is much too heavy to lift.",
	"#MUD1\\MUD1N015#Three triangular blue buttons.",
	"#MUD1\\MUD1N016#Two yellow triangular buttons.",


	"#MUD2\\MUD2_001#Spock, see if you can outflank him...",
	"#MUD2\\MUD2_002#Well, now! I think we know why the Elasi pirates were so interested in finding out where Mudd was getting these!", // TYPO
	"#MUD2\\MUD2_003#Almost worth a try. Bones? ",
	"#MUD2\\MUD2_004#Do they pose any threat to us, Doctor?",
	"#MUD2\\MUD2_005#Harry! Calm down Harry, it's only us! ",
	"#MUD2\\MUD2_006#Harry, when did you become a comedian? ",
	"#MUD2\\MUD2_007#I can't think of anything we did that was THAT bad. ",
	"#MUD2\\MUD2_008#There's not much I wouldn't do to not have to deal with Mudd. ",
	"#MUD2\\MUD2_009#Kirk to Enterprise ... Kirk to Enterprise.", // TYPO
	"#MUD2\\MUD2_010#Sometimes I wish I had become an archeology professor instead of a Starfleet Captain. ",
	"#MUD2\\MUD2_011#Sorry if I was bothering you. I was just silently cursing the day I met Harry Mudd. ",
	"#MUD2\\MUD2_012#All yours now, Doctor McCoy.",
	"#MUD2\\MUD2_013#He's showing definite signs of hallucination and a marked increase in adrenalin. I would recommend extreme caution in handling him.",
	"#MUD2\\MUD2_014#I feel sure that these would have been used here, but I don't understand enough of the alien's thinking to make it work.", // TYPO
	"#MUD2\\MUD2_015#I need to understand more about the aliens before I can make this bed and its instrumentation function.",
	"#MUD2\\MUD2_016#I'm not fast enough to get him with a tranquilizer hypo, Jim!",
	"#MUD2\\MUD2_018#Jim, these look like the capsules we might use in a hypo.  I wouldn't recommend experimenting with them, though. Alien physiology or not, you can never be sure what unusual chemicals will do to the human body.",
	"#MUD2\\MUD2_019#None seems likely to have any effect on human -- or Vulcan -- physiology. To be on the safe side, though, I wouldn't recommend taking a snootful from one of the capsules!",
	"#MUD2\\MUD2_020#The capsules slide into the machinery on the bed exactly as they're designed to.",
	"#MUD2\\MUD2_021#The volatile chemicals have evaporated over the time the derelict hung in space. I need to refill the capsule-dispenser for the bed to activate and effect a cure on our friend Harry, here.",
	"#MUD2\\MUD2_022#This is no time for a nap!", // TYPO
	"#MUD2\\MUD2_023#We can't get near that equipment with mudd going nuts over there, Jim.",
	"#MUD2\\MUD2_024#We won't be able to operate any of this equipment unless we can learn more about the aliens, Jim.",
	"#MUD2\\MUD2_025#Are you religious, Jim? Is Harry Mudd a divine punishment for anything we did wrong? ",
	"#MUD2\\MUD2_026#Deleterious effects.  I guess I don't even need my tricorder to know that.",
	"#MUD2\\MUD2_027#He's delirious Jim. Actually, it's kinda funny. ",
	"#MUD2\\MUD2_028#I think I liked him better when he was less delirious. ",
	"#MUD2\\MUD2_029#I'm telling the program our physiology is not the same as the aliens' physiology.  Don't want it to try to cure us of being human!",
	"#MUD2\\MUD2_030#It would be interesting to analyze them back aboard the Enterprise, but these are probably vaccines, medicines, and research viruses.",
	"#MUD2\\MUD2_031#If we can get him on one of the beds, and get it active, I think he can be cured.  Otherwise, he's likely to become increasingly violent.",
	"#MUD2\\MUD2_032#Jim, that doesn't look good at all...  Harry, let me take a look at you and check whether that had some deleterious effect...",
	"#MUD2\\MUD2_033#Okay, Harry, you should start to feel better in a few minutes. Just lie there quietly until you feel like moving.",
	"#MUD2\\MUD2_034#Particularly when we're talking about Harry Mudd...",
	"#MUD2\\MUD2_035#Well, he got one thing right. ",
	"#MUD2\\MUD2_036#Who knows what effect a phaser might have on him with all those chemicals in his system? We must find another way to handle this. ",
	"#MUD2\\MUD2_037#This room closely resembles the Enterprise sickbay.  The beds are powered, as is the central post console. ",
	"#MUD2\\MUD2_038#It would appear that the accident has made Harry Mudd even less logical than before. ",
	"#MUD2\\MUD2_039#That would be too much to hope for, would it not, Doctor?",
	"#MUD2\\MUD2_040#You look troubled, Captain.",
	"#MUD2\\MUD2_042#Ahh, I feel faster -- smarter -- strong enough to take you all on! You're really lizard men wearing human masks -- his is coming off -- Hahahahahah!",
	"#MUD2\\MUD2_043#I know you for what you really are!  I'll tell the whole world, and then where will you be!",
	"#MUD2\\MUD2_044#Why C-c-Captain!",
	"#MUD2\\MUD2_045#*Groan.*  Give me something for this headache, Doc. A herd of Hamali tree-elephants landed behind my eyeballs and did a mating dance...",
	"#MUD2\\MUD2_046#Argh! My most dire enemies have found me! ",
	"#MUD2\\MUD2_047#Kirk, you sound as though you aren't happy to see me! After all we've been through together, I thought we had built a genuine bond of camraderie, two men fighting side by side against impossible odds! ",
	"#MUD2\\MUD2_048#No! You're going to sell me to space aliens! Use my brain as a weapon to destroy the human race! And here I am, willing to help out in a good cause... ",
	"#MUD2\\MUD2_049#No!  You're all space aliens!  You're little grey men from inside the hollow earth!  You want to experiment on my body parts!  Stay away from me!",
	"#MUD2\\MUD2_050#Stay away from me!>",
	"#MUD2\\MUD2_051#You'll mind control me, kidnap my children!  Dissect my dog!",
	"#MUD2\\MUD2_052#He's unnaturally strong, Captain!  I can't take him down!",
	"#MUD2\\MUD2_053#I don't think the phaser will have the usual effect, Captain.... we'll have to think of something else!",
	"#MUD2\\MUD2_054#Captain, count your blessings! We haven't met any salt vampires, deranged computers, blood-draining clouds, cell imploding sirens, Greek gods, or any of the other things people keep telling me about in security. ",
	"#MUD2\\MUD2_055#Sir, I can phaser him. A stun setting would just leave him queasy. ",
	"#MUD2\\MUD2N000#Dr. McCoy, who isn't arguing as much with Spock as usual. ",
	"#MUD2\\MUD2N001#Dust and grease lifts off the surface, leaving this item clean as new.",
	"#MUD2\\MUD2N002#Harcourt Fenton Mudd. Three of the most prominent psychologists in the galaxy became famous by publishing case studies in sociopathy about him. ",
	"#MUD2\\MUD2N003#James Kirk, the paragon of a Starfleet captain, feels nothing like a paragon right now. ",
	"#MUD2\\MUD2N004#Lieutenant Buchert. His is not to reason why. His is to obey orders and stay alert. ",
	"#MUD2\\MUD2N005#Life support fails completely and you fall unconscious.",
	"#MUD2\\MUD2N006#Mr. Spock, your loyal science officer. ",
	"#MUD2\\MUD2N007#Padded inclines resembling a bed.",
	"#MUD2\\MUD2N008#Small containers of oddly-colored liquids.",
	"#MUD2\\MUD2N009#The atmosphere in the ship has dropped below the level needed to sustain life. You drop to unconsciousness and slowly die.",
	"#MUD2\\MUD2N010#These two things fit together like they were made for each other.",
	"#MUD2\\MUD2N011#This seems to be the main monitoring station for the beds. Above it is some sort of dispensary.",


	"#MUD3\\MUD3_002#Harry! Look what you've done! ",
	"#MUD3\\MUD3_003#Kirk to Enterprise...",
	"#MUD3\\MUD3_005#At ease, lieutenant. He's not worth it. ",
	"#MUD3\\MUD3_006#At least our life support system isn't dependent on the alien computer.",
	"#MUD3\\MUD3_007#By all means, Spock.",
	"#MUD3\\MUD3_008#But their essence, their souls -- are gone, Spock.",
	"#MUD3\\MUD3_009#Get away from that this instant, Harry, or I'll shoot you where you stand.",
	"#MUD3\\MUD3_010#Help yourself, Harry. Knowledge is for everyone.",
	"#MUD3\\MUD3_011#It would be nice to think that after all the stunts that Harry has pulled, that he would do something right for a change. ", // TYPO
	"#MUD3\\MUD3_012#Spock, we're talking about Harry Mudd. He was probably trying to download it so he could sell it to the highest bidder.",
	"#MUD3\\MUD3_013#Teeny bit clumsy? Mudd, you're a disgrace to the entire human race! ",
	"#MUD3\\MUD3_014#This technology is unbelievable, Mr. Spock. I've never seen anything like it. ",
	"#MUD3\\MUD3_015#With the Enterprise out of range, that's not an option, Mr. Spock. What else can you do?", // TYPO
	"#MUD3\\MUD3_016#You better believe it, lieutenant. ",
	"#MUD3\\MUD3_017#Apparently an information data screen, something like the display readers on the Enterprise.",
	"#MUD3\\MUD3_018#Both our tricorders are now working on basic processing of the aliens' computer data system.  The tricorders are not the equal of the Universal Translator, but we should be able to retrieve basic information and get an insight into their culture and lifesystems. I don't believe we could have gotten even this far, had we not deduced their fixation on base-6 mathematics and esthetics.",
	"#MUD3\\MUD3_019#Captain, it was not logical to allow Harry Mudd to get within one hundred meters of this room. ",
	"#MUD3\\MUD3_020#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#MUD3\\MUD3_021#Not my area of expertise, I'm afraid.",
	"#MUD3\\MUD3_022#That would be quite a find, Jim. This is an alien race unknown to us, and they are certain to have knowledge new to us.", // TYPO
	"#MUD3\\MUD3_023#This equipment's way out of my league, Jim. ",
	"#MUD3\\MUD3_024#And instead, he wiped the memory. That knowledge was priceless!",
	"#MUD3\\MUD3_025#If you're incapable of emotion, how do you know what \"awe\" is, Spock? ",
	"#MUD3\\MUD3_026#Interesting data here about the six-eyed vision processing in the brain. Their eyesight must have been excellent, and almost 300 degrees around.",
	"#MUD3\\MUD3_027#Look at their physiology, Jim -- I think this explains the L'Shaians' fascination with threes and sixes.",
	"#MUD3\\MUD3_028#Medical knowledge is comprehensive, and lifespan is extended considerably over archaic expectations, with maintenance of quality of life.",
	"#MUD3\\MUD3_029#Mudd! Don't you realize what you've done! That knowledge was irreplaceable! You just burned down the galactic equivalent of the Library of Alexandria! Millions of lives might have been saved by the knowledge you destroyed! ",
	"#MUD3\\MUD3_030#Mudd! If I were to perform an autopsy on you right now, I might be able to find a cure for stupidity! ",
	"#MUD3\\MUD3_031#Mudd, do you know what you just did!? That knowledge was priceless -- and you've just destroyed it forever!!",
	"#MUD3\\MUD3_032#To say nothing of fulfilling our mandate to seek out new life and new civilizations...",
	"#MUD3\\MUD3_033#You can't be serious, Spock! ",
	"#MUD3\\MUD3_034#I believe I have downloaded enough information to our tricorders to enable operation of most of the ship's controls, Captain.",
	"#MUD3\\MUD3_035#I believe I have retrieved as much data as I can, Captain.",
	"#MUD3\\MUD3_036#I believe I've extracted a copy of the main databank, Captain.",
	"#MUD3\\MUD3_037#I would suggest, Captain, that the controls to this screen are elsewhere in this room.",
	"#MUD3\\MUD3_038#The data viewscreen is operational. The information selectors are controlled from the console platform.",
	"#MUD3\\MUD3_039#The tricorder's entire sensor and data processing capabilities are presently occupied with decipherment of the ship's library.",
	"#MUD3\\MUD3_040#The tricorders are again available for general use. The alien ship's computer data is now accessible from the ship's library.",
	"#MUD3\\MUD3_041#This platform contains the control console for the ship's computer library. Data may be accessed by using this console.",
	"#MUD3\\MUD3_042#This platform contains the control console for what appears to be the information center of the ship -- the computer library, if you will. It appears functional, but incomprehensible without some better understanding of the aliens who built it.",
	"#MUD3\\MUD3_043#This seems to activate the ship's computer bank control node. Given the aliens' predilection for multiples of 3, it may be possible to use our tricorders to decipher the information carried in these data banks.",
	"#MUD3\\MUD3_044#This seems to activate the ship's computer bank control node. I lack sufficient information to commence data retrieval, however.  Simply put, without some understanding of the aliens' mindset, there's no place to start.",
	"#MUD3\\MUD3_046#I believe I can produce a picture of a member of their race, Captain.",
	"#MUD3\\MUD3_047#I believe if Dr. McCoy and I conjoin our two tricorders, we may be able to process enough sample data to get a basic understanding of the aliens' computer system. This will completely tie up both our tricorders for an extended amount of time, however.",
	"#MUD3\\MUD3_048#I believe, Captain, that the basic functions of the ship remain, even now.  This is the library module -- the art, history, and cultural memory of the aliens are gone, but the mechanical necessities of sick bay, engineering, and sensors continue to work.",
	"#MUD3\\MUD3_049#I have found an entry on an experimental long-range weapon booster, recently installed, named the Whyos weapon. It does not alter the power of the primary weapons systems, but it does increase the range at which those weapons are effective.",
	"#MUD3\\MUD3_050#I'm receiving data now, Captain. Most internal and external functions are controlled from the bridge. These include Engineering, Navigation, Communications, and Sensors. Weapons functions are controlled from the weapons room.", // TYPO
	"#MUD3\\MUD3_051#Illogical, Captain.  This race has been extinct for millenia.",
	"#MUD3\\MUD3_052#It appears our good friend Harry Mudd has crashed the main computers. I doubt if it was a very easy thing to manage.",
	"#MUD3\\MUD3_053#It should be no surprise that physiology affects mind and behavior. I would say a six-fingered, six-eyed people would naturally develop their sciences and arts around base-six numerical systems, just as I observed on the bridge.",
	"#MUD3\\MUD3_054#Not all topics will necessarily be available, Captain. Nor do I believe we can get full details on all data -- the tricorders could only do so much processing. It would be worth our effort to locate the central databanks for delivery to the Kornephoros Life Sciences University, I believe.",
	"#MUD3\\MUD3_055#This is a major archeological find, Captain. I believe the galaxy may actually have cause to thank Harry Mudd. ",
	"#MUD3\\MUD3_056#Were the Universal Translator available, this would be simple.",
	"#MUD3\\MUD3_057#It is indeed impressive Captain. If I were capable of emotion, I would be in awe of this place. ",
	"#MUD3\\MUD3_058#How dare you, Kirk! I have half a mind to sue for defamation of character... ",
	"#MUD3\\MUD3_059#Kirk! Get this muscle-bound clod away from me. I'm allergic to violence! ",
	"#MUD3\\MUD3_060#Kirk, look what you made me do! You and your clumsy Starfleet... ",
	"#MUD3\\MUD3_061#Now see here, Dr. McCoy! Don't blame me if Kirk's bellowing causes me to be a teeny bit clumsy... ",
	"#MUD3\\MUD3_062#Now, you aren't... I mean.... Kirk! ",
	"#MUD3\\MUD3_063#Ooops!",
	"#MUD3\\MUD3_064#Whatever you say, Captain!",
	"#MUD3\\MUD3_065#Why, Captain! I see you got this machine to work -- I tried to get it up and running for the longest time.",
	"#MUD3\\MUD3_066#Why, Kirk, I didn't think you had it in you. Thank you!",
	"#MUD3\\MUD3_067#Captain, I think I understand why you dislike this Mudd guy so much. ",
	"#MUD3\\MUD3_068#Not my area of expertise, I'm afraid.",
	"#MUD3\\MUD3_069#Captain, I think Mr. Mudd looks like he's getting out of control... ",
	"#MUD3\\MUD3_070#Captain, does this mean that I'm a part of a major archeological discovery? ",
	"#MUD3\\MUD3_071#I don't see why you're complaining about this Mudd guy. Who knows what advances we could get from all this knowledge? ",
	"#MUD3\\MUD3N000#Databanks erased.",
	"#MUD3\\MUD3N001#Dust and grease lifts off the surface, leaving this item clean as new.",
	"#MUD3\\MUD3N002#Even Spock is visibly disturbed by Mudd's carelessness. ",
	"#MUD3\\MUD3N003#Harry Mudd hopes he can make it back to his ship and get away in one piece. ",
	"#MUD3\\MUD3N004#Kirk is dismayed by the destruction he has seen. ",
	"#MUD3\\MUD3N005#Kirk is silently worried about what is happening back on the Enterprise. ",
	"#MUD3\\MUD3N006#Lieutenant Buchert is not at all happy with Harcourt Fenton Mudd. ",
	"#MUD3\\MUD3N007#Lieutenant Buchert seems to have limitless energy. It makes you feel old just watching him. ",
	"#MUD3\\MUD3N008#Life support fails completely and you fall unconscious.",
	"#MUD3\\MUD3N009#McCoy is aghast at this turn of events. ",
	"#MUD3\\MUD3N010#McCoy is his usual crusty old self. ",
	"#MUD3\\MUD3N011#Nothing happens.",
	"#MUD3\\MUD3N012#Sometimes you wonder if Spock will ever show emotion. ",
	"#MUD3\\MUD3N013#The atmosphere in the ship has dropped below the level needed to sustain life. You drop to unconsciousness and slowly die.",
	"#MUD3\\MUD3N014#The computer has nothing to write to the spheroid.",
	"#MUD3\\MUD3N015#The sphere in the middle of this console appears to be some sort of control mechanism.",
	"#MUD3\\MUD3N016#These two things fit together like they were made for each other.",
	"#MUD3\\MUD3N017#This might be a data screen of some kind.",
	"#MUD3\\MUD3N018#You already have a doover.",
	"#MUD3\\MUD3N019#You can't seem to make this work.",
	"#MUD3\\MUD3N020#You download major portions of the alien library onto the yellow spheroid.",
	"(Raises eyebrow)", // Custom


	"#MUD4\\MUD4_001#Bring us home, Mr. Scott.",
	"#MUD4\\MUD4_002#<<Communications>>",
	"#MUD4\\MUD4_003#<<Done>>",
	"#MUD4\\MUD4_004#I guess the universe looks about like it did the last time we saw it.",
	"#MUD4\\MUD4_005#I'm speechless, Mr. Spock. Words cannot adequately describe this place. ",
	"#MUD4\\MUD4_006#Mr. Spock, come take a look at this. This is evidently the main bridge. What do you make of it?",
	"#MUD4\\MUD4_007#<<View Screen>>",
	"#MUD4\\MUD4_008#Did you know Stella's still looking for you? What's it worth to you for me not to tell her where to find you, Harry?", // TYPO
	"#MUD4\\MUD4_009#Don't rush off, Harry. There's still a few things we need to discuss.",
	"#MUD4\\MUD4_010#Five of each.",
	"#MUD4\\MUD4_011#Five. Remember, I could confiscate your entire stock as illegal goods.  You might get it back through the courts... in a few years.",
	"#MUD4\\MUD4_012#For free?",
	"#MUD4\\MUD4_013#Go on, Mr. Spock.",
	"#MUD4\\MUD4_014#I was sure you wouldn't miss them, Harry. The Patent Authority wants these properly registered and I'm sure you want to do the right thing.",
	"#MUD4\\MUD4_015#In spite of Harry Mudd... ",
	"#MUD4\\MUD4_016#In such a hurry? And Stella said she was dropping everything to meet you here.",
	"#MUD4\\MUD4_017#Just like you were kidding about this ship registered as a worthless derelict. You are going to change that, aren't you?  Matter of fact, I think it would be just the thing for you to turn it over lock stock and barrel to the Kornephorous University.",
	"#MUD4\\MUD4_018#Kirk to Enterprise ... Kirk to Enterprise.", // TYPO: used in MUD4 and LOVE mission; the text was different in LOVE, not matching with audio.
	"#MUD4\\MUD4_019#Later, Mr. Scott.",
	"#MUD4\\MUD4_020#New developments, Mr. Scott?",
	"#MUD4\\MUD4_021#No, Harry, we're going to let you keep them to sell to the Elasi at incredible profits, so they can use them against Federation authorites.",
	"#MUD4\\MUD4_022#No, I need to have a word with Harry Mudd before we go.",
	"#MUD4\\MUD4_023#No, I need to have a word with Harry Mudd before we go.",
	"#MUD4\\MUD4_024#No, we want to look around some more. We'll call you on this channel when we're ready.",
	"#MUD4\\MUD4_025#Scotty!  Report!",
	"#MUD4\\MUD4_026#Tell me why I shouldn't arrest you on the spot, just on general principles?",
	"#MUD4\\MUD4_027#The local star seems to be acting up. Will there be a problem with the transporter? I want you to beam up the landing party, and I also want you to lock onto and beam aboard an alien mechanism we came across.",
	"#MUD4\\MUD4_028#The local star seems to be acting up.  Will there be a problem with the transporter?",
	"#MUD4\\MUD4_029#I would suggest, Captain, we take him up on his offer.",
	"#MUD4\\MUD4_030#Very well, Harry. You're off scot free... this time. But if you don't upload that data immediately, your measly little scoutship will be experiencing some difficulties maintaining flight capabilities.",
	"#MUD4\\MUD4_031#What else can you determine at this stage, Mr. Spock?",
	"#MUD4\\MUD4_032#When we meet, Harry, it always means trouble.",
	"#MUD4\\MUD4_033#Yes, bring us home, Mr. Scott.",
	"#MUD4\\MUD4_034#You destroyed the only known records of a lost race. That's a punishable offense.",
	"#MUD4\\MUD4_035#You have no idea what a great bargain it is, Mudd.",
	"#MUD4\\MUD4_036#You made a backup?",
	"#MUD4\\MUD4_037#You were selling high-technology weapons to terrorists and known criminals.",
	"#MUD4\\MUD4_038#<<Sensors>>",
	"#MUD4\\MUD4_039#<<Navigation>>",
	"#MUD4\\MUD4_040#<<Engineering>>",
	"#MUD4\\MUD4_041#<<Done>>",
	"#MUD4\\MUD4_042#Evidently the aliens' bridge, their centralized control. A closer look may provide more information.",
	"#MUD4\\MUD4_043#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#MUD4\\MUD4_045#I can't make anything of these controls.",
	"#MUD4\\MUD4_046#To boldly go, where no man has gone before... we're here, Jim. ",
	"#MUD4\\MUD4_047#Speak of the devil, where is that little angel? ",
	"#MUD4\\MUD4_048#This shouldn't be surprising -- after all, there are two stations.",
	"#MUD4\\MUD4_049#I think this is the secondary station.",
	"#MUD4\\MUD4_050#It appears to be a view screen much like the one on board the Enterprise.",
	"#MUD4\\MUD4_051#It is a multi-bit, compact doover with its own dracktar traction unit and clamp kit.",
	"#MUD4\\MUD4_052#Thanks to the library computer data, limited though it is, these primary controls give me access to...",
	"#MUD4\\MUD4_053#The Enterprise is in combat with a number of Elasi pirate ships half a parsec toward the neutron star sector. I read debris identifiable with the pirates, but they continue to harass the Enterprise.",
	"#MUD4\\MUD4_054#The Enterprise is out of range for this equipment, under the conditions of static created by the neutron star.",
	"#MUD4\\MUD4_055#The computer reports this ship is incapable of navigating anywhere at all without major repairs. We are definitely dead in space until the Enterprise returns, Captain.",
	"#MUD4\\MUD4_056#The engine pods are damaged but still generating power, Captain.",
	"#MUD4\\MUD4_057#This appears to be the primary control panel. Perhaps you would be better equipped to man this station, Captain.",
	"#MUD4\\MUD4_058#This is the secondary station. With the limited understanding we now have of the library computer data, these controls can now be activated. Available are... ",
	"#MUD4\\MUD4_059#That may be, Doctor, but if you will recall, all the Enterprise's different stations link into the same computer network bank and...",
	"#MUD4\\MUD4_060#These people have a fixation for the number six, and even divisors and multiplicands thereof: threes and twelves in particular. I believe this may be the necessary first clue to understanding the aliens.",
	"#MUD4\\MUD4_061#This is clearly the control center for the ship, Captain. I cannot deduce much information, but I do observe two things.",
	"#MUD4\\MUD4_062#This station definitely is configured differently from the one beside me.",
	"#MUD4\\MUD4_063#We have done quite well so far, Captain. ",
	"#MUD4\\MUD4_064#Because I am going to turn over a selection of samples to the Kornephorous Life Sciences University?",
	"#MUD4\\MUD4_065#Captain Kirk! I seem to be missing a Miracle De-Grimer! Surely you're not stooping to thievery, are you, Captain?",
	"#MUD4\\MUD4_066#Captain Kirk! I was hoping to see you. I'm leaving soon and wanted to say thanks for the escort. Ta-ta, and I hope we never have to cross paths again, Captain.",
	"#MUD4\\MUD4_067#Captain!! Two.",
	"#MUD4\\MUD4_068#Consider it done. You have my word, Captain. Now I'm going to pick up just a few things. Insignificant things, really! Then I'll be gone. Farewell, Captain! May your path be always trouble-free, until we meet again.",
	"#MUD4\\MUD4_069#I understand. No problem. Adieu, Captain!",
	"#MUD4\\MUD4_070#Uh...  of course. One of everything I've found here.",
	"#MUD4\\MUD4_071#Well, Captain, I did manage to take a download of the computer before I accidentally damaged it. If you'll just let me go back to my ship, I can upload it to the Enterprise's computers from there.",
	"#MUD4\\MUD4_072#What! Where's the profit in that, Captain?",
	"#MUD4\\MUD4_073#You drive a hard bargain, Captain. It's a deal.",
	"#MUD4\\MUD4_074#You're. Kidding. Are you kidding, Captain?",
	"#MUD4\\MUD4_075#I don't believe this is the weapons center, Captain. There appears to be one, but it's evidently located elsewhere on the ship.  I can't make anything more of these controls.",
	"#MUD4\\MUD4_076#This may have been their bridge, but this sure doesn't look like the Enterprise. ",
	"#MUD4\\MUD4_A29#Very well, bring us home, Mr. Scott.",
	"#MUD4\\MUD4_S02#The Elasi pirates have been driven off, Captain. We have damage, and injuries among the crew. We just arrived back here a few minutes ago, and we've been trying to raise you on the communicators.",
	"#MUD4\\MUD4_S03#The neutron star is causing more and more problems, Captain.  I would recommend beaming over at your earliest possible convenience.",
	"#MUD4\\MUD4_S04#We can do it, Captain, no problem. At least right now, but the situation is only going to get worse. Are you ready to beam over now?",
	"#MUD4\\MUD4N000#A control console from which operators run the ship.",
	"#MUD4\\MUD4N001#Dr. McCoy is still frowning. ",
	"#MUD4\\MUD4N002#Dust and grease lifts off the surface, leaving this item clean as new.",
	"#MUD4\\MUD4N003#James T. Kirk, Captain of the USS Enterprise. ",
	"#MUD4\\MUD4N004#Lieutenant Buchert looks intensely at these controls, and suppresses a childlike impulse to touch them. ",
	"#MUD4\\MUD4N005#Life support fails completely and you fall unconscious.",
	"#MUD4\\MUD4N006#Mr. Spock, Vulcan's finest contribution to Starfleet. ",
	"#MUD4\\MUD4N007#The atmosphere in the ship has dropped below the level needed to sustain life. You drop to unconsciousness and slowly die.",
	"#MUD4\\MUD4N008#The starfield is the same one you saw from the bridge of the Enterprise, with the binary stars swinging majestically past each other.",
	"#MUD4\\MUD4N009#These two things fit together like they were made for each other.",
	"#MUD4\\MUD4N011#This appears to be some sort of engineering instrument. ",
	"#MUD4\\MUD4N012#You already have a doover.",
	"#MUD4\\MUD4N013#You see a plain grey screen.",


	"#MUD5\\MUD5_001#I suspect that's a blessing in disguise, Mr. Spock!",
	"#MUD5\\MUD5_002#Just think of it, Spock. An advanced civilization, with powerful technology and nearly unlimited knowledge, and yet all of that didn't save them. ",
	"#MUD5\\MUD5_003#Kirk to Enterprise...",
	"#MUD5\\MUD5_004#Let's hope there isn't too much for you to do back at the Enterprise. ",
	"#MUD5\\MUD5_005#Mudd! I oughta...",
	"#MUD5\\MUD5_006#No, Harry, but I figure it's probably where you'll find your lost marbles.",
	"#MUD5\\MUD5_007#That was a close one. Too close! If I ever get my hands on that no good Mudd I'll...",
	"#MUD5\\MUD5_009#Will wonders never cease.",
	"#MUD5\\MUD5_010#Yes, I've got it but you can't have it.",
	"#MUD5\\MUD5_011#An unusual matter-anti-matter engine, reminiscent of the designs created by the hoopooin of Seginus IV.",
	"#MUD5\\MUD5_012#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#MUD5\\MUD5_013#Our lives won't be worth a plugged nickel if we don't get that makeshift life support generator back in working order!",
	"#MUD5\\MUD5_014#This life support generator is an unreliable model at the best of times.  Tinkering with it is a gamble with your life!",
	"#MUD5\\MUD5_015#Do you really think there's anything on Mudd's ship we need, Captain?  I don't.",
	"#MUD5\\MUD5_016#Spock! Meaningless conversation is one of life's great pleasures. ",
	"#MUD5\\MUD5_017#Well Jim, as long as we don't strangle Harry Mudd, I can't see very much for me to do on this mission. ",
	"#MUD5\\MUD5_018#You know, lieutenant, they say if you can't say anything good about a person, you shouldn't say anything at all. In that case, I've got a lot I shouldn't say about Harry Mudd. ",
	"#MUD5\\MUD5_019#The life support generator is malfunctioning. Repairs must be made soon or the atmosphere will fall below the level required to sustain us, Captain.",
	"#MUD5\\MUD5_020#The life support system must be repaired soon. Readings indicate the environment is dropping quickly.",
	"#MUD5\\MUD5_021#This \"Sav-a-Ship\" life support generator has seen a great deal of use.  It was never a reliable model, being prone to breakdown without warning.  It is, however, properly connected, with warning alarms for temperature, atmosphere, and radiation.",
	"#MUD5\\MUD5_022#This room appears to have been the alien ship's engine pod. A ship-to-ship access hatch and a temporary life support generator are evidently recent additions.",
	"#MUD5\\MUD5_023#This seems to be a crane of some sort, Captain. Currently, no power is running to it.",
	"#MUD5\\MUD5_024#As one would expect, Mr. Mudd has sealed the hatch with his personal code. We cannot enter his ship, Captain.",
	"#MUD5\\MUD5_025#Captain, the Gomuchi-Grindrod Salvage Hatch is designed to withstand low power phaser blasts.  However, I would not trust the integrity of the ship's hull were we to increase phaser power to open this hatch.",
	"#MUD5\\MUD5_026#Evidently Mr. Mudd was unwilling to pay the price for a reliable salvage model.",
	"#MUD5\\MUD5_027#I doubt there's anything on Mudd's ship we require, Captain.",
	"#MUD5\\MUD5_028#I would not suggest we take the time to seek him. This emergency could occur again. I would suggest we hasten our departure.", // TYPO
	"#MUD5\\MUD5_030#In this case, I agree with the good doctor.",
	"#MUD5\\MUD5_031#It appears that Harry Mudd managed to emplace this access hatch without significantly damaging the alien ship.",
	"#MUD5\\MUD5_032#It is a sobering thought, Captain. ",
	"#MUD5\\MUD5_033#Unlike humans, I do not decrease my efficiency with meaningless dialogue. ",
	"#MUD5\\MUD5_034#Captain, you wouldn't have seen my Multipurpose Doover anywhere? I need to, uh, fix something.",
	"#MUD5\\MUD5_035#Oh! Was there a problem?",
	"#MUD5\\MUD5_036#Sorry, no time to chat. I'm a busy man you know.",
	"#MUD5\\MUD5_037#You really can be a headache, Captain. Maybe I can find a spare somewhere else. Good lu...I mean goodbye.",
	"#MUD5\\MUD5_038#Captain, I'm not feeling well. Without life support, we can't remain here much longer.",
	"#MUD5\\MUD5_039#Captain, I don't think we can open this hatch with phasers, and still depend on the integrity of the ship's hull to hold atmosphere.",
	"#MUD5\\MUD5_040#When we get back to the Enterprise, you're going to have to tell me everything you know about this Mudd guy. ",
	"#MUD5\\MUD5N000#A large claw-like device hangs from the ceiling.",
	"#MUD5\\MUD5N001#Dust and grease lifts off the surface, leaving this item clean as new.",
	"#MUD5\\MUD5N002#James T. Kirk. Exploring the unknown is one of the few pleasures that the burden of command allows him. ",
	"#MUD5\\MUD5N003#Lieutenant Buchert watches and says nothing. He's the strong, silent type. ",
	"#MUD5\\MUD5N004#McCoy glances back and forth, looking for a sign of Harry Mudd. ",
	"#MUD5\\MUD5N005#Spock continues to examine the equipment with a scientist's eye. ",
	"#MUD5\\MUD5N006#Tall, transparent columns run through the ceiling. Energy crackles in between the duo-decahedrons inside them.",
	"#MUD5\\MUD5N007#The atmosphere in the ship has dropped below the level needed to sustain life. You drop to unconsciousness and slowly die.",
	"#MUD5\\MUD5N008#There seems to be something wrong with the life support generator.",
	"#MUD5\\MUD5N009#These two things fit together like they were made for each other.",
	"#MUD5\\MUD5N010#This door leads back to the main cargo bay.",
	"#MUD5\\MUD5N011#A salvage lock hatch, a common type used to link a derelict to the ship doing the salvaging.",
	"#MUD5\\MUD5N012#A \"Sav-a-Ship\" emergency life support generator, generally used for temporary life support during evacuation of small damaged ships.",
	"#MUD5\\MUD5N105#Life support fails completely and you fall unconscious.",


	"#FEA0\\FEA0_002#And exactly what would you have done with them? Entering Klingon space for anything puts the peace in peril.",
	"#FEA0\\FEA0_003#And then your followers were destroyed because when white men arrived on that continent, they were believed to be you in your promised return. Your people perverted your teachings, then were destroyed by it.",
	"#FEA0\\FEA0_004#Damned right the results were swift. The Klingons have been raiding colonies looking for you.",
	"#FEA0\\FEA0_005#Ha! You mean your followers love pieces! They slaughtered other believers hoping you'd return.",
	"#FEA0\\FEA0_006#I am Captain James T. Kirk of the Starship Enterprise. Did you know the Klingons are looking for you?",
	"#FEA0\\FEA0_007#I am Captain James T. Kirk of the Starship Enterprise. What did you do to get the Klingons so upset?",
	"#FEA0\\FEA0_008#Listen, the Klingons are ripping colonies apart to find you, so stop this nonsense. This is serious.",
	"#FEA0\\FEA0_009#Listen, Mister, any missions conducted within Klingon space fully jeopardize the peace.",
	"#FEA0\\FEA0_010#Quetzecoatl? How fitting you would name yourself after one of the most bloody-handed gods in Earth's history.",
	"#FEA0\\FEA0_011#We're not your children and we don't appreciate this wild goose chase you've forced us into.",
	"#FEA0\\FEA0_012#Whatever you did has them very upset. They're raiding worlds looking for you.",
	"#FEA0\\FEA0_013#Your followers regularly sacrificed other believers to you after you left, offering you their still-beating hearts.",
	"#FEA0\\FEA0_014#Your people? We represent all of the Earth's people and we certainly do not recognize you.",
	"#FEA0\\FEA0_015#He appears human... All life signs are normal, but I'm getting strange energy readings near the base of his pituitary gland.",
	"#FEA0\\FEA0_016#Ouch!",
	"#FEA0\\FEA0_017#Jim, that man is dressed in ancient Aztec clothing.",
	"#FEA0\\FEA0_018#What do you know about Earth culture? He looks like an ancient Aztec!",
	"#FEA0\\FEA0_019#I am picking up multiple life forms in the surrounding region, Captain.",
	"#FEA0\\FEA0_020#I am picking up strange energy readings from the alien.  Perhaps Doctor McCoy could provide better data.",
	"#FEA0\\FEA0_021#I believe you are mistaken, doctor. His clothing bears a distinct resemblance to fashions of a much later period.",
	"#FEA0\\FEA0_022#The humanoid's adornments appear similar to those worn by leaders of Earth's early 20th century inhabitants of the South American continent.",
	"#FEA0\\FEA0_023#I'm just a security officer, sir.",
	"#FEA0\\FEA0_024#I am Quetzecoatl. I elevated a civilization on your world from barbarism to sentience. You are a perversion of that process. Be gone!",
	"#FEA0\\FEA0_025#You dare fire at a god?",
	"#FEA0\\FEA0_026#Bloody-handed? My people love peace!",
	"#FEA0\\FEA0_027#Foul lying creatures, my gift was wasted upon you! Begone.",
	"#FEA0\\FEA0_028#Greetings, my children. I can barely imagine that you have come so far.",
	"#FEA0\\FEA0_029#Impossible! You must be lying!",
	"#FEA0\\FEA0_030#Jeopardize the peace? Hardly. Peace is what I preach. I am Quetzecoatl, as you well know from the proud history of your world.",
	"#FEA0\\FEA0_031#Quaint expression. I have done nothing to anger them. I did with them what I have done with everyone.",
	"#FEA0\\FEA0_032#The Klingons? Amazing! This is the first time one of my missions has produced results so swiftly.",
	"#FEA0\\FEA0_033#Who are you? I know you come from Terrasol, but you are not of my people. What goes on here?",
	"#FEA0\\FEA0_101#No, you must be lying. They could not be raiding if they are looking for me. Violence was not the message of any of my missions. I, Quetzecoatl, preach universal brotherhood and peace.",
	"#FEA0\\FEA0_108#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#FEA0\\FEA0N000#Feral red eyes glare out of the dark at you.",
	"#FEA0\\FEA0N001#It looks like the jungle has grown up into a small hut.",
	"#FEA0\\FEA0N002#Lt. Stragey is carefully eyeing the humanoid.",
	"#FEA0\\FEA0N003#Luminescent insects swarm near a large tree.",
	"#FEA0\\FEA0N004#McCoy is fidgeting around.",
	"#FEA0\\FEA0N005#Spock is analyzing the surroundings.",
	"#FEA0\\FEA0N006#The log appears sturdy enough to cross.",
	"#FEA0\\FEA0N007#The moon of Digifal. Legend says that the gods of good and evil fortune live there and will glance back at those who look at them, and either a miracle or a catastrophe will soon befall those who gaze upon it.",
	"#FEA0\\FEA0N008#There is a tall, slender, dark haired man looking intently at you.",
	"#FEA0\\FEA0N009#You see dense vegetation in all directions.",


	"#FEA1\\FEA1_001#We wouldn't want to bleed all over Dr. McCoy now, would we?",
	"#FEA1\\FEA1_002#Well, yes.",
	"#FEA1\\FEA1_003#A pile of small igneous rocks, Captain.",
	"#FEA1\\FEA1_004#And get my fingers taken off by some alien reptile? You've got to be joking.",
	"#FEA1\\FEA1_005#Are you nuts? There's no way I'm touching any damned snake!",
	"#FEA1\\FEA1_006#Do I look like Houdini to you? I'm afraid you're going to have to pull the rabbit out of the hat on this one.",
	"#FEA1\\FEA1_007#Does it look sick to you, Captain?",
	"#FEA1\\FEA1_008#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#FEA1\\FEA1_009#Hey! What was that for?",
	"#FEA1\\FEA1_010#I'm not putting my fingers in there, Jim.",
	"#FEA1\\FEA1_011#It's a damned hole with a snake in it.",
	"#FEA1\\FEA1_012#It's a damned hole.",
	"#FEA1\\FEA1_013#It's bad enough that you put me in the damn transporter, now you want me to break my neck climbing that?!",
	"#FEA1\\FEA1_014#It's moss. Anyone got any rolling stones?",
	"#FEA1\\FEA1_015#No toxic reaction. It appears to be ordinary, except for this resin.",
	"#FEA1\\FEA1_017#Didn't they have baseball on Vulcan? Show us your fastball, Jim.",
	"#FEA1\\FEA1_018#Especially that green Vulcan blood. The last thing I need is a pint of T-Negative blood all over my uniform.",
	"#FEA1\\FEA1_019#It's a damned snake! Do you know what snakebite does? It can ruin your whole day.",
	"#FEA1\\FEA1_020#It's bad enough being around pointy-eared Vulcans, now I have to listen to ensigns who think they can do my job!",
	"#FEA1\\FEA1_021#Probability? That was a perfect pitch if I ever saw one.",
	"#FEA1\\FEA1_022#The bite wasn't serious Captain. He'll be fine, but I would like to get him to sickbay in case there's some alien infection.",
	"#FEA1\\FEA1_023#Fascinating. Our communicators have apparently been rendered ineffective.",
	"#FEA1\\FEA1_024#I am picking up residual energy readings from the area where the alien's projection was.",
	"#FEA1\\FEA1_025#I can not reach the snake, Captain.",
	"#FEA1\\FEA1_026#I realize that humans form emotional bonds with pets, but I recommend tribbles.",
	"#FEA1\\FEA1_027#I see no logic in searching an empty hole, Captain.",
	"#FEA1\\FEA1_028#It is logical that an entity that professes to teach peace would render our phasers inoperative.",
	"#FEA1\\FEA1_029#It looks like a Zamphorian pit snake. A rather common species in this region, noted by galactic herpatologists for their quickness. It is not venomous or dangerous to humans. ",
	"#FEA1\\FEA1_030#It would appear that this is where the snake lives, Captain. It is currently inside.",
	"#FEA1\\FEA1_031#It would appear that this is where the snake lives, Captain.",
	"#FEA1\\FEA1_032#Thank you, Captain, but I assure you that I was giving this situation my fullest attention.",
	"#FEA1\\FEA1_033#The resin does not seem to have any unusual properties.",
	"#FEA1\\FEA1_034#The snake has gone back into the hole, Captain.",
	"#FEA1\\FEA1_035#The snake is too quick to be easily grabbed before it retreats, Captain.", // TYPO
	"#FEA1\\FEA1_037#This isn't very logical, but as you are human, it is quite understandable.", // TYPO
	"#FEA1\\FEA1_038#This variety of moss seems to leave a very sticky resin behind. Perhaps to trap the large amounts of pollen from the plants on the surface, and use it as a secondary food source.",
	"#FEA1\\FEA1_039#This vine is not likely to support our weight by itself, Captain. You would have to find some way to reinforce it.",
	"#FEA1\\FEA1_040#Those vines would be useful to escape, if we could reach them.",
	"#FEA1\\FEA1_041#A fascinating specimen, Captain, but I would be careful handling it. From the looks of it, it may have a nasty bite.", // TYPO
	"#FEA1\\FEA1_042#Fascinating. It did appear to knock the vine down near to the point where one of us can reach it.",
	"#FEA1\\FEA1_043#The probability of getting the vine on the second try was only 36.53%. Well done, Captain.",
	"#FEA1\\FEA1_044#We are not likely to find a way out of this pit with humor, doctor. I suggest you concentrate your efforts to the problem at hand.",
	"#FEA1\\FEA1_045#I'm glad I was taught pain-nullification techniques.",
	"#FEA1\\FEA1_046#It doesn't seem to want to be grabbed, sir. It just slithers back to its hole.",
	"#FEA1\\FEA1_047#It's coming out again, sir.",
	"#FEA1\\FEA1_048#No enemies in sight, but supplies could be a problem if we don't get out.",
	"#FEA1\\FEA1_049#Sure is sticky sir. I can't see much use in it.",
	"#FEA1\\FEA1_050#That's something of a runt, Captain. You should've seen this Rigilian python that Cadet Tyrli put in the shower at the Academy. Twenty meters long!",
	"#FEA1\\FEA1_051#The hole is empty, sir.",
	"#FEA1\\FEA1_052#There's no way that we're getting up that way, Captain.  The vine is too weak.",
	"#FEA1\\FEA1_053#All Right! We're on our way!",
	"#FEA1\\FEA1_054#Baseball? No one plays that anymore. Good try though, sir.",
	"#FEA1\\FEA1_055#Do they always argue like this, Captain?",
	"#FEA1\\FEA1_056#Doctors! It'll take more than a couple of scratches to put me out action, sir.",
	"#FEA1\\FEA1_057#You clearly are not the inheritors of the noble Aztec world.  What you have said has greatly disturbed me. You should not lie so. You shall remain here until you have learned the error of angering Quetzecoatl!",
	"#FEA1\\FEA1_A46#There is not enough support, Captain.",
	"#FEA1\\FEA1_F25#What on Earth are you doing with that slithering thing!",
	"#FEA1\\FEA1N000#Feral red eyes glare out of the dark at you.",
	"#FEA1\\FEA1N001#James T. Kirk does not seem very happy with his current predicament.",
	"#FEA1\\FEA1N002#Lt. Stragey is carefully examining the pit.",
	"#FEA1\\FEA1N003#McCoy is examining the floor of the pit.",
	"#FEA1\\FEA1N004#Spock is carefully examining the pit.",
	"#FEA1\\FEA1N005#The hole is already blocked.",
	"#FEA1\\FEA1N006#The rock is a bit stickier.",
	"#FEA1\\FEA1N007#The snake darts back into its hole before you can catch it.",
	"#FEA1\\FEA1N008#The vine is attached to a tree above you.",
	"#FEA1\\FEA1N009#The vine is not within reach.",
	"#FEA1\\FEA1N010#The vine will not support you.",
	"#FEA1\\FEA1N011#There are rocks here, quite suitable for picking up and throwing.",
	"#FEA1\\FEA1N012#There are several loose vines hanging over the side of the pit, out of reach. This is one of them.",
	"#FEA1\\FEA1N013#There is a light suspended from above by a chain.",
	"#FEA1\\FEA1N014#There is a tiny hole in the wall at this point. Certainly no human could crawl through here.",
	"#FEA1\\FEA1N015#There is a vine hanging down into the pit.",
	"#FEA1\\FEA1N016#This moss is covered with a very sticky substance.",
	"#FEA1\\FEA1N017#This particular snake doesn't seem to like your company, and moves whenever you get near it.",
	"#FEA1\\FEA1N018#With no where for the snake to go, you easliy capture it.",
	"#FEA1\\FEA1N019#You already have rocks.",
	"#FEA1\\FEA1N020#You are in a deep pit. It is a long, hard climb to the top.",
	"#FEA1\\FEA1N021#You cannot reach it from where you are.",
	"#FEA1\\FEA1N022#You pick up some rocks from the pile.",


	"#FEA2\\FEA2_001#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#FEA2\\FEA2_002#Nothing interesting in this neck of the woods, Jim.",
	"#FEA2\\FEA2_003#They're dead, Jim.",
	"#FEA2\\FEA2_004#This jungle is sure lush, Jim. Speaking of lush, I could use a nice saurian brandy about now.",
	"#FEA2\\FEA2_005#Really? Tell me more about your childhood Lieutenant...",
	"#FEA2\\FEA2_006#Fascinating. Our communicators have apparently been rendered ineffective.",
	"#FEA2\\FEA2_007#I am reading a life form to the west. It appears to be humanoid.",
	"#FEA2\\FEA2_008#Staying in this overgrown region could prove quite dangerous. I suggest we continue, Captain.",
	"#FEA2\\FEA2_009#I feel like someone is watching us, Captain.",
	"#FEA2\\FEA2_010#You know, I always wanted to go swinging on a vine through a jungle. Just like in some old books I read when I was a kid.",
	"#FEA2\\FEA2N000#A vine hangs from the trees.",
	"#FEA2\\FEA2N001#Feral red eyes glare out of the dark at you.",
	"#FEA2\\FEA2N002#Kirk is wondering what he said that made Quetzecoatl so angry...",
	"#FEA2\\FEA2N003#Lt. Stragey appears fascinated by the vines hanging from the trees.",
	"#FEA2\\FEA2N004#McCoy is filled with premonitions of injury and death. Why else would they have brought him along?",
	"#FEA2\\FEA2N005#Spock is examining the surrounding terrain for signs of danger. Anything else would be illogical.",
	"#FEA2\\FEA2N006#This great tree has been in this jungle for centuries.",
	"#FEA2\\FEA2N007#Trees to the left of you! Trees to the right of you! Into the valley of trees raced the landing party!",
	"#FEA2\\FEA2N008#You are in a densely vegetated area. The overgrowth blocks your view in all directions.",


	"#FEA3\\FEA3_001#Well, does anyone have any suggestions?",
	"#FEA3\\FEA3_002#Great Tlaoxac, I do not understand. Quetzecoatl says that his is the way of peace, yet you wish blood to be shed?",
	"#FEA3\\FEA3_003#It is urgent that we speak to Quetzecoatl. His life may depend on it. Please stand aside and let us pass?",
	"#FEA3\\FEA3_004#An intriguing solution Captain, but it is unlikely that he will accept green blood as a proper sacrifice.",
	"#FEA3\\FEA3_005#Did you ever get the feeling that people don't like you?",
	"#FEA3\\FEA3_006#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#FEA3\\FEA3_007#Get that thing away from me!",
	"#FEA3\\FEA3_008#He dropped a knife, Jim!",
	"#FEA3\\FEA3_009#He's out cold, Jim.I don't think we'll have any more trouble from him.",
	"#FEA3\\FEA3_010#He's unconscious, Jim.",
	"#FEA3\\FEA3_011#Hey! What do you think you're doing?",
	"#FEA3\\FEA3_012#Jim, he'll be up in about a half hour. If I wake him now he's liable to retalliate for your thoughtless actions.", // TYPO
	"#FEA3\\FEA3_013#These lamps are made up of insects much like fireflies, Jim.",
	"#FEA3\\FEA3_014#Well, either this Aztec is a real flesh and blood human being, or I'm going to be retired as soon as I get back to the Enterprise.",
	"#FEA3\\FEA3_015#Damn. He noticed.",
	"#FEA3\\FEA3_016#Isn't that what they said to David before he fought Goliath?",
	"#FEA3\\FEA3_017#Well, then send in David!",
	"#FEA3\\FEA3_018#What about your famous nerve pinch?",
	"#FEA3\\FEA3_019#Fascinating. These lights are actually swarms of bio-luminescent insects. I wonder how they are controlled.",
	"#FEA3\\FEA3_020#Interesting. From the angle of its fangs and the shape of its mouth, it might have had the ability to inject its prey with venom at one time.", // TYPO
	"#FEA3\\FEA3_021#Nothing unusual here, Captain.",
	"#FEA3\\FEA3_022#Perhaps our host will be more reasonable now. I recommend trying to locate him, Captain.",
	"#FEA3\\FEA3_023#Still inoperative, Captain.",
	"#FEA3\\FEA3_024#Still inoperative, Captain.",
	"#FEA3\\FEA3_025#That is not a logical act, Captain.",
	"#FEA3\\FEA3_026#Captain, I do not think that I can defeat him in personal combat.",
	"#FEA3\\FEA3_027#Doctor, may I remind you that David defeated Goliath?",
	"#FEA3\\FEA3_028#It is unlikely to work on a man of that size, doctor.",
	"#FEA3\\FEA3_029#All right! Time for some action. Let me show you how we did it at the Acad... uh, Captain, do you realize how BIG this guy is?",
	"#FEA3\\FEA3_030#sHe's dead, Jim!", // TYPO
	"#FEA3\\FEA3_031#I'm really not that anxious to get a good look at it, sir.",
	"#FEA3\\FEA3_032#Nice planet. I kinda like it.",
	"#FEA3\\FEA3_033#Ouch, sir.",
	"#FEA3\\FEA3_034#Well, there is a doctor here, so I guess it's all right. They never told me I'd be doing this at the Academy.",
	"#FEA3\\FEA3_035#Get back! You may not pass until you prove your worthiness.",
	"#FEA3\\FEA3_036#I am Tlaoxac, priest of Quetzecoatl. Only one who knows his ways may approach his holy ground.",
	"#FEA3\\FEA3_037#I do not understand your words, but it does not matter. You may not pass until blood is shed.",
	"#FEA3\\FEA3_038#I will not listen to your deceitful ways.",
	"#FEA3\\FEA3_039#Indeed you know the ways of Quetzecoatl But only a man of courage, one who will shed blood will pass.",
	"#FEA3\\FEA3_040#None can threaten the great Quetzecoatl! You lie! Truly you do not serve the serpent-god. You may not pass!",
	"#FEA3\\FEA3_041#None shall pass until blood is shed.", // TYPO
	"#FEA3\\FEA3_042#Nonetheless, that is what must be done. Only men of courage are allowed into his presence.",
	"#FEA3\\FEA3_043#Self-sacrifice is the noblest quality of humanity. You may go. Beware the monster in the water. You may have my knife to defend yourself.",
	"#FEA3\\FEA3_044#You are truly a noble man, unlike the coward who was not capable of shedding his own blood. You may pass, but beware the man in the golden robe. He may lead you to your death. Use this knife to defend yourself.",
	"#FEA3\\FEA3N000#McCoy seems rather nervous.",
	"#FEA3\\FEA3N001#Primitive lights illuminate this savage scene.",
	"#FEA3\\FEA3N002#Spock looks small compared to the great warrior.",
	"#FEA3\\FEA3N003#The aztec warrior lies on the ground unconcious.",
	"#FEA3\\FEA3N004#The snake enjoys snacking on you.",
	"#FEA3\\FEA3N005#This was once a living member of your crew.",
	"#FEA3\\FEA3N006#Tloaxac falls to the ground unconscious.",
	"#FEA3\\FEA3N007#Towering over your security officer, holding a great spear in his huge hands, the great warrior Tlaoxac will let no one pass him.",
	"#FEA3\\FEA3N010#You pick up the beautifully crafted knife.",
	"#FEA3\\FEA3N011#You see a jewel encrusted, gold colored knife.",
	"#FEA3\\FEA3N012#Your security officer looks at you for orders and, perhaps, inspiration.",


	"#FEA4\\FEA4_001#A swarm of fireflies, Jim.",
	"#FEA4\\FEA4_002#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#FEA4\\FEA4_003#I would strongly recommend against touching these, Jim. They are highly toxic.",
	"#FEA4\\FEA4_004#It's getting a little cool out here. Keep warm. I don't want a bunch of sick crewmen when we get back to the ship. If we ever do get back to the ship.",
	"#FEA4\\FEA4_005#Still out, Jim.",
	"#FEA4\\FEA4_006#You're looking a little pale, Jim.",
	"#FEA4\\FEA4_007#Fascinating. The trees are able to grow very close together in this forest, Captain.",
	"#FEA4\\FEA4_008#I am reading a life form to the west, Captain.",
	"#FEA4\\FEA4_009#It vaguely resembles the Terran Spanish Bayonette. The edges of the leaf are razor sharp and secrete a poisonous resin.",
	"#FEA4\\FEA4_010#Small colonies of bio-luminescent insects, Captain.",
	"#FEA4\\FEA4_011#They are not currently operational, Captain.",
	"#FEA4\\FEA4_012#Tralxacian mushrooms. Their spores are highly toxic and are released if they are disturbed.",
	"#FEA4\\FEA4_013#Does every planetside mission have this much adventure, Captain? Mind you, I can't say Mr. Quetzecoatl is making a very good impression on me...",
	"#FEA4\\FEA4N000#A large fern fans the pathway.",
	"#FEA4\\FEA4N001#Below this rock is a large growth of mushrooms.",
	"#FEA4\\FEA4N002#Familiar glowing spheres light the path.",
	"#FEA4\\FEA4N003#Feral red eyes glare out of the dark at you.",
	"#FEA4\\FEA4N004#James T. Kirk realizes that every step increases their danger.",
	"#FEA4\\FEA4N005#Lt. Stragey smiles as he strolls down the path.",
	"#FEA4\\FEA4N006#McCoy doesn't want to be bothered right now.",
	"#FEA4\\FEA4N007#Mr. Spock analyzes the surroundings.",
	"#FEA4\\FEA4N008#You are in a dark forest. You can hear the flow of water to the northwest.",


	"#FEA5\\FEA5_001#This is a very finely crafted knife.",
	"#FEA5\\FEA5_002#Captain, I believe it would be suicide to try crossing the log while the creature is near.",
	"#FEA5\\FEA5_003#Captain, I do not believe that my service to Starfleet includes, as humans say, 'throwing my life away'.",
	"#FEA5\\FEA5_004#Captain, I would recommend using something to cut the plant. There are numerous small thorns along the stem.",
	"#FEA5\\FEA5_005#Captain, it would not be wise to cross while the creature is near.",
	"#FEA5\\FEA5_006#Due to the small size of the knife, I doubt it would harm such a large creature.",
	"#FEA5\\FEA5_007#Anyone for a campfire?",
	"#FEA5\\FEA5_008#Captain, I'll declare you unfit to command if you keep this up!",
	"#FEA5\\FEA5_009#Damn! That's gonna hurt Jim. Take a look at those thorns. You might try cutting that with something.", // TYPO
	"#FEA5\\FEA5_010#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#FEA5\\FEA5_011#I'm not reading that creature anymore, Jim.",
	"#FEA5\\FEA5_013#It's some kind of squid, and it doesn't look very friendly.",
	"#FEA5\\FEA5_014#Jim! There's some kind of an aquatic creature down there.",
	"#FEA5\\FEA5_015#Jim, that's ludicrous!",
	"#FEA5\\FEA5_016#Jim, we've been friends a long time, but... I mean... you're not serious?",
	"#FEA5\\FEA5_018#Jim, with our phasers not working, we may need that knife to protect ourselves!", // TYPO
	"#FEA5\\FEA5_019#This planet is starting to get to me. I'm sure something just hit me.",
	"#FEA5\\FEA5_020#You weren't a snake handler in your previous life were you? I don't like snakes.", // TYPO
	"#FEA5\\FEA5_021#Good throw, Captain. However, I think the creature was merely startled. It may return in a little while.",
	"#FEA5\\FEA5_022#I recommend caution here, Captain.",
	"#FEA5\\FEA5_023#It appears that the leaves are slightly toxic. I would not recommend touching it for an extended amount of time, Captain.",
	"#FEA5\\FEA5_024#It is some kind of mollusk; the river seems to be its home, and it is carnivorous, eating land and river based forms of life.",
	"#FEA5\\FEA5_025#It would appear that the plant secretes a chemical that is a natural repellent to the creature. It has retreated far down stream, Captain.",
	"#FEA5\\FEA5_026#Nothing unusual here, Captain.",
	"#FEA5\\FEA5_027#Please stop that Captain. I have enough distractions from Dr. McCoy.",
	"#FEA5\\FEA5_028#Still inoperative, Captain.",
	"#FEA5\\FEA5_029#Thank you Captain, but Vulcans do not use knives.",
	"#FEA5\\FEA5_030#The tricorder registers a lifeform, a large marine creature, lurking just below the surface of the water.",
	"#FEA5\\FEA5_031#The tricorder shows nothing unusual, Captain. The creature is still down stream.",
	"#FEA5\\FEA5_032#Was there a reason for that, Captain?",
	"#FEA5\\FEA5_033#Captain, perhaps I should try to cross first.",
	"#FEA5\\FEA5_034#I'll give it a try, Captain.",
	"#FEA5\\FEA5_035#It looks like that plant fights back sir. You might want to use something to cut it loose.",
	"#FEA5\\FEA5_036#Reminds me of a planet I was stationed on once. The native girls were real friendly. Ensign Shou had his bachelor party there, great time. You ever been to Omicron Draconis, Captain?",
	"#FEA5\\FEA5_037#Sir, I finished second in my weight class in wrestling at the Academy, but I don't think that thing's in my weight class.",
	"#FEA5\\FEA5_038#Sir, you dropped your rock.",
	"#FEA5\\FEA5_039#Thanks Captain, but I can take care of myself. I finished second in my weight class in wrestling at the Academy. You keep the knife.",
	"#FEA5\\FEA5_040#You're weird, sir.",
	"#FEA5\\FEA5N000#A pair of eyes are all that you can see of the rest of this creature. Most of it is hidden beneath the murky water.",
	"#FEA5\\FEA5N001#Captain Kirk is looking at the big creature in the water.",
	"#FEA5\\FEA5N002#Dr. McCoy is looking at the big creature in the water.",
	"#FEA5\\FEA5N003#He will not do that.",
	"#FEA5\\FEA5N004#Lt. Stragey is looking at the big creature in the water.",
	"#FEA5\\FEA5N005#Luminescent insects swarm near a large tree.",
	"#FEA5\\FEA5N006#Mr. Spock is looking ahead to a cave opening on the other side of the log.",
	"#FEA5\\FEA5N007#The log looks quite old but sturdy.",
	"#FEA5\\FEA5N008#The plant is tough. You will need something sharp to cut it.",
	"#FEA5\\FEA5N009#The river water is too muddy to get an idea of its depth or what may be beneath the surface.",
	"#FEA5\\FEA5N010#The snake bites you.",
	"#FEA5\\FEA5N011#The snake disapears beneath the surface of the water.",
	"#FEA5\\FEA5N012#There is a slow muddy river blocking your path. A strong thick log serves as a footbridge. The river is unmoving, and the heat and stillness are oppressive.",
	"#FEA5\\FEA5N013#There seems to be a lit cave beyond the log.",
	"#FEA5\\FEA5N014#This plant has a rather thick stem and prickly leaves.", // TYPO
	"#FEA5\\FEA5N015#You already have a piece of the plant.",


	"#FEA6\\FEA6_001#I think I can get it with a few more blows.",
	"#FEA6\\FEA6_002#Have you ever made it up the face of Half Dome, Lieutenant?",
	"#FEA6\\FEA6_003#Perhaps we should hold onto that hope, Mr. Spock, that a civilised being will not kill for trivial motives.",
	"#FEA6\\FEA6_004#Sometimes I feel like I'm the Captain of a nursery school.",
	"#FEA6\\FEA6_005#That creature was quite real Mr. Spock. We will discuss this with our host, when we see him.",
	"#FEA6\\FEA6_006#Then, gentlemen, I would advise you to stop arguing.",
	"#FEA6\\FEA6_007#Unfortunately, human history is full of people who did not practice what they preached. Quetzecoatl is just one in a long line of them.",
	"#FEA6\\FEA6_008#Will you two morons stop arguing just once!",
	"#FEA6\\FEA6_009#Damn it Jim, I'm a surgeon not a geologist.",
	"#FEA6\\FEA6_011#Everyone is healthy, Jim, there's no need for the medical kit here.",
	"#FEA6\\FEA6_012#It would appear that our tentacled friend wants dessert. You can't go back that way, unless you enjoy being eaten.",
	"#FEA6\\FEA6_013#I've lost any appetite I may have had for squid, Jim.", // TYPO
	"#FEA6\\FEA6_014#Jim! Going back across that river would be insane.",
	"#FEA6\\FEA6_015#Well, they're not organic. What did you think they were, calcified tribbles?",
	"#FEA6\\FEA6_016#Captains and security officers. They don't realize how fragile the human body can be.",
	"#FEA6\\FEA6_017#Well isn't this just great!", // TYPO
	"#FEA6\\FEA6_018#Fascinating. These rocks are limestone, but contain an unusually high content of heavy metals. There are dilithium crystals here, but in a very raw form.",
	"#FEA6\\FEA6_019#I fail to see any logic in that action, Captain. It may also cause stalactites to fall.", // TYPO
	"#FEA6\\FEA6_020#I would suggest using something to pry that loose, Captain.",
	"#FEA6\\FEA6_021#It is unwise to use a rock here, Captain.",
	"#FEA6\\FEA6_022#My tricorder indicates unusual energy patterns in this direction, Captain.",
	"#FEA6\\FEA6_023#Still inoperative, Captain.",
	"#FEA6\\FEA6_024#The creature is still there, Captain.",
	"#FEA6\\FEA6_025#These stalactites were made from limestone deposits. They took millennia to form.",
	"#FEA6\\FEA6_026#These stalagmites were made from limestone deposits. They took millennia to form.",
	"#FEA6\\FEA6_027#This appears to be a formation of raw dilithium crystals, Captain.",
	"#FEA6\\FEA6_028#This illogical action would only dull the knife.",
	"#FEA6\\FEA6_029#Agreed, Captain.",
	"#FEA6\\FEA6_030#This whole experience feels like a test. The equivalent of 20th Century earth lab rats running through a maze.",
	"#FEA6\\FEA6_031#I would wait until we meet him before judging him, Captain.",
	"#FEA6\\FEA6_032#Captain, I cannot speak for Dr. McCoy, but my intelligence quotient is far higher than humans...",
	"#FEA6\\FEA6_033#Doctor, I would point out that your voice could also trigger such a collapse.",
	"#FEA6\\FEA6_034#I should warn you that the stalactites could collapse quite easily. Any sudden motion could cause large quantities of stalactites to fall on us.",
	"#FEA6\\FEA6_035#I would suggest we continue on, Captain. It would not be logical to endanger ourselves by remaining here.",
	"#FEA6\\FEA6_036#It would seem to be a prudent course of action Captain, if Doctor McCoy would agree.",
	"#FEA6\\FEA6_037#Really? That's fascinating Captain.",
	"#FEA6\\FEA6_038#There is a contradiction, Captain. If Quetzecoatl is really an entity of peace, then Lt. Stragey should not have died.",
	"#FEA6\\FEA6_039#Captain, have we done something wrong?",
	"#FEA6\\FEA6_040#I don't think I'll be able to get a good grip sir. You might try prying it loose.",
	"#FEA6\\FEA6_041#If we ever get back to Earth, one hundred credits says I'll beat you.",
	"#FEA6\\FEA6_042#Reminds me of some spelunking I did on Hades IV. Ever do any climbing, Captain?",
	"#FEA6\\FEA6_043#Sure we do. That's the challenge.",
	"#FEA6\\FEA6N000#A stalagtite breaks through and falls. You are mortally injured and die.", // TYPO
	"#FEA6\\FEA6N001#An interesting, but useless, manuever.",
	"#FEA6\\FEA6N002#As usual, Dr. McCoy looks annoyed by the mission. ",
	"#FEA6\\FEA6N003#Darkness, leading into the unknown.",
	"#FEA6\\FEA6N004#However, a strange force envelopes your body...",
	"#FEA6\\FEA6N005#It is a large cluster of crystals.",
	"#FEA6\\FEA6N006#It's Game Over man...",
	"#FEA6\\FEA6N007#James Kirk remembers the last time he was in a cave, and is glad that this one seems more peaceful.",
	"#FEA6\\FEA6N008#Lieutenant Stragey looks nervously at the stalactites hovering precariously above you.",
	"#FEA6\\FEA6N009#Nothing happens.",
	"#FEA6\\FEA6N010#Nothing happens.",
	"#FEA6\\FEA6N011#Spock is his usual stoic self.",
	"#FEA6\\FEA6N012#Stalactites descend from the ceiling.",
	"#FEA6\\FEA6N013#Stalagmites rise from the floor of the cave.",
	"#FEA6\\FEA6N014#They appear to be ordinary rocks. Spock's tricorder might say otherwise.",
	"#FEA6\\FEA6N015#This is one place where dilithium crystals don't seem to be very useful.",
	"#FEA6\\FEA6N016#This is the way that you entered the cave. If you leave this way, the tentacled creature that attacked you will probably try to get a second course for its dinner.", // TYPO
	"#FEA6\\FEA6N017#You have one dilithium crystal, in raw form.",
	"#FEA6\\FEA6N020#You will need something to pry it loose.",
	"#FEA6\\FEA6N028#You manage to pry loose one dilithium crystal.",
	"#FEA6\\FEA6N029#You scratch your initials. No dilithium crystals were found.",


	"#FEA7\\FEA7_001#Scotty, five to beam up.",
	"#FEA7\\FEA7_002#Scotty, four to beam up.",
	"#FEA7\\FEA7_003#You've got to do it, Bones! If the Klingons realize he's no longer a threat to them, perhaps we can avoid a war!",
	"#FEA7\\FEA7_004#Absolutely. Your best intentions were changed by the imperfect humans that you left in charge after you departed. Such is the way of our race, I'm afraid.",
	"#FEA7\\FEA7_005#I've had it up to here with so-called superior beings terrorizing my crew because we're so 'primitive'. Maybe you should see how primitive you are before you go around testing others.",
	"#FEA7\\FEA7_006#One thing first. If you're so peaceful, how come the Aztecs were so violent and agressive?",
	"#FEA7\\FEA7_007#The Federation is not in the business of lying, mister.",
	"#FEA7\\FEA7_008#We're a technologically advanced starfaring race, what do you think? That we wouldn't have made progress in medicine?",
	"#FEA7\\FEA7_009#With Dr. McCoy, I sometimes wonder, but yes, I would say we have made considerable advances.",
	"#FEA7\\FEA7_010#Yes, I guess we do. Go on.",
	"#FEA7\\FEA7_011#Yes, why do you ask?",
	"#FEA7\\FEA7_012#You messed up in a big way. Perhaps you should try following the Prime Directive. It changed our lives.",
	"#FEA7\\FEA7_013#Jim, I'll try, but the physiology is completely alien...",
	"#FEA7\\FEA7_014#You show great wisdom, sir. But your statement implies that you wish to change your condition.",
	"#FEA7\\FEA7_015#At the top of my spine is a gland not found in your species. This is the seat of my power. I wish you to remove it, thereby making me a mortal.",
	"#FEA7\\FEA7_016#First, I have one question...",
	"#FEA7\\FEA7_017#I am sorry you had to go through this ordeal. It was not meant for you to die.",
	"#FEA7\\FEA7_018#I sense truth in this. Perhaps this is what happened to my children on the Klingon world of Hrakkour, which would explain why they are searching for me. I have clearly abused the power that was given me long ago.",
	"#FEA7\\FEA7_019#I tried to teach them the concept of self-sacrifice. It would appear they did not completely understand my teachings.",
	"#FEA7\\FEA7_020#I was not aware you had been tested before. My apologies.",
	"#FEA7\\FEA7_021#I was particularly impressed by the sacrifice made by Lt. Stragey. Of course, I gave him back his life. He is now safely aboard your vessel.",
	"#FEA7\\FEA7_022#I watched as you worked through the problems I set in your path. you are a valiant, intelligent species.",
	"#FEA7\\FEA7_023#I would have been more impressed had you found a less violent solution. My children are dear to me. Even so, few choices remain to me.",
	"#FEA7\\FEA7_024#Indeed. If my mission of peace was overthrown, then I am no longer worthy of my power. Tell me, has your species made progress in the medical arts?",
	"#FEA7\\FEA7_025#Of course, how foolish of me. Still, there are cultures where medical knowledge is considered a sign of weakness. Warrior cultures, where nothing matters but physical strength. Survival of the foolish.",
	"#FEA7\\FEA7_026#Ours is an intensely curious race, Captain. My brothers and I have raised children on a thousand worlds, loved them, watched them grow, only to see them become separated from us by the passage of time. It is sad and lonely process, one which I shall not repeat again. I am no longer worthy of my gift.",
	"#FEA7\\FEA7_027#Please sit down. We have much to discuss.",
	"#FEA7\\FEA7_028#Then I shall ask to make use of your advances.",
	"#FEA7\\FEA7_029#You are clearly not the liars I thought you to be. Were you telling me the truth about my disciples? That they became ruthless savages?",
	"#FEA7\\FEA7_030#Your harshness is unwarranted, but I sense truth in this. Perhaps this is what happened to my children on the Klingon world of Hrakkour, which would explain why they are searching for me. I have clearly abused the power that was given me long ago.",


	"#TRI0\\TRI0_001#I want your word of honor, Vlict, that Quetzecoatl will not be harmed while we take these tests.",
	"#TRI0\\TRI0_002#I've faced Klingons, both in personal and ship-to-ship combat. Your own records will confirm this. If I'm not worthy of their honors, why didn't they kill me?",
	"#TRI0\\TRI0_003#Then the Klingon Empire is wrong.",
	"#TRI0\\TRI0_004#Those are serious charges, Vlict. Should he not be tried by a Klingon High Court?",
	"#TRI0\\TRI0_006#By our standards, he would rank among the greatest heroes of the Federation: Gandhi, Surak, M'lelto-jhi, Shanarda. We will not abandon him.",
	"#TRI0\\TRI0_007#Ensign!",
	"#TRI0\\TRI0_008#Fine. Can we get this over with? I've got shore leave scheduled on Ryza next week.",
	"#TRI0\\TRI0_009#Give me an opportunity. If I succeed, Quetzecoatl goes free.",
	"#TRI0\\TRI0_010#Guess I can't argue with you. Pleasant conquests, admiral.",
	"#TRI0\\TRI0_011#I'm a warrior, Vlict! I hereby intervene for him and demand the honors and responsibilities of a warrior's trial!",
	"#TRI0\\TRI0_013#I'm James T. Kirk. I'm more worthy than you'll ever be, and I have girlfriends on fifty planets who will vouch for that!",
	"#TRI0\\TRI0_014#If it means that I can prevent you from murdering an ancient and blameless creature, yes. And I'm prepared to back it up.",
	"#TRI0\\TRI0_015#Oh well. I'm afraid you're on your own, Quetzecoatl.",
	"#TRI0\\TRI0_016#Stick around, Vlict. There are more surprises awaiting you.",
	"#TRI0\\TRI0_017#Then a Klingon can thrive on the conflict between his inner nature and his philosophy. Clearly, the people of Hrakkour did that.",
	"#TRI0\\TRI0_018#Then this trial is a mockery for the entire galaxy to see!",
	"#TRI0\\TRI0_019#There's nothing less appealing than a gloating Klingon, Vlict. Let's get this trial under way.",
	"#TRI0\\TRI0_020#This is a matter for a philosophical debate, not a trial! The state has no right to interfere in a person's conscience.",
	"#TRI0\\TRI0_021#Why does every Klingon tell me they expected to meet me in battle? You really have a one-track mind!",
	"#TRI0\\TRI0_022#You will act with the discipline of a Federation officer, Ensign, or you will return to the Enterprise. Do I make myself clear?",
	"#TRI0\\TRI0_023#You're going to kill this old man because he encouraged non-violence? The Federation cannot accept this.",
	"#TRI0\\TRI0_024#Any hostile action here may result in the destruction of the Enterprise.",
	"#TRI0\\TRI0_025#Captain, I estimate the odds of this court acquitting Quetzecoatl at 0.086 percent.",
	"#TRI0\\TRI0_026#Captain, may I remind you that we are deep in Klingon space? If we attack them here, they may respond by destroying the Enterprise.",
	"#TRI0\\TRI0_027#Damn it Jim, I'm a doctor not a arbitrator.",
	"#TRI0\\TRI0_028#Damn it, Jim!  I use my hands to save lives not take them.",
	"#TRI0\\TRI0_029#He's still weak from the operation.",
	"#TRI0\\TRI0_030#One healthy adult klingon male.",
	"#TRI0\\TRI0_031#I've got nothing to say to you, Jim.",
	"#TRI0\\TRI0_034#Nobody needs healing, Jim, but you will if they harm my patient.",
	"#TRI0\\TRI0_035#Nothing of interest.",
	"#TRI0\\TRI0_036#Don't be a fool, Jim! We can't risk the Enterprise! We've already signed one person's death warrant!", // TYPO
	"#TRI0\\TRI0_037#Low level radiation, within safety limits. But you wouldn't want to spend more than a few days here.",
	"#TRI0\\TRI0_038#Nothing of interest.",
	"#TRI0\\TRI0_039#Children should not even play at war. To prepare them to kill is barbaric.",
	"#TRI0\\TRI0_040#I have failed. Death is what I deserve.",
	"#TRI0\\TRI0_041#I offered them insights into the philosophy of peace and cooperation. They chose to follow it of their own free will.",
	"#TRI0\\TRI0_042#I'm frightened, Captain, but if I am to die, then I shall die well.",
	"#TRI0\\TRI0_043#A Federation officer, claiming the rights of a Klingon warrior? How dare you insult me, Kirk!",
	"#TRI0\\TRI0_044#As for you Kirk, I expected a more forceful response. I had heard you were a worthy opponent. Instead, I see a cringing coward. Leave this place, Kirk. You dishonor it.",
	"#TRI0\\TRI0_045#Ha! Ha! You have never encountered Klingon women, Captain. But that was the response of a true warrior. You have earned my respect. I shall give you and your companions a chance to defend the traitor.",
	"#TRI0\\TRI0_046#He has admitted guilt. You have surrendered him to Klingon law. Can you deny that this was a fair trial?",
	"#TRI0\\TRI0_047#He has not demonstrated honor, Kirk! Only a proven warrior may be tried in High Court! Principles of honor are not applicable to his defense!",
	"#TRI0\\TRI0_048#How typical of the Federation, to judge every other species as morally inferior. Your rhetoric is not welcome here!",
	"#TRI0\\TRI0_049#I hereby sentence K'etz'coatl to a coward's death.",
	"#TRI0\\TRI0_050#K'etz'koatl, you encouraged the colony to destroy its weapons. You even encouraged them to hold their children from our traditional military ceremonies.",
	"#TRI0\\TRI0_051#Only the greatest warriors of old could say such a thing and expect to live! Do you think yourself worthy enough to walk in their footsteps?",
	"#TRI0\\TRI0_052#Pacifism is utterly alien to our people. It would be as though he preached a doctrine of suicide in direct contradiction of the will to live. Honorable men thrive in war and conflict -- cowards seek to avoid conflict.",
	"#TRI0\\TRI0_053#So Kirk, we finally meet. I had thought it would be in battle, but the universe holds many surprises.",
	"#TRI0\\TRI0_054#So be it. This begins the trial of the entity K'etz'koatl, who is charged with impersonating a klingon, stirring dissent, encouraging cowardice, and treason in the highest degree.",
	"#TRI0\\TRI0_055#Stories of your impudence are not exaggerated. You shall have your chance. It is a pity we will not meet again, Captain.",
	"#TRI0\\TRI0_056#That oversight, Kirk, is easily rectified.",
	"#TRI0\\TRI0_057#The Klingon Empire will not tolerate dissent.",
	"#TRI0\\TRI0_058#The prisoner and his witnesses will stand forth, so the trial may begin!",
	"#TRI0\\TRI0_059#To counsel it is to counsel cowardice. To counsel it is to abandon all honor! This is treason, for all to see! The penalty for treason in this system is death! Do you accept your sentence?",
	"#TRI0\\TRI0_060#Very well. You have my word. Captain Kallarax, transport them to the Test of Life.",
	"#TRI0\\TRI0_061#You and your three companions may face the tests that we set for the defender. Then we shall see if you are as worthy as a Klingon!",
	"#TRI0\\TRI0_062#You will not speak unless the court requests it, Kirk!",
	"#TRI0\\TRI0_063#Awaiting your orders, sir!",
	"#TRI0\\TRI0_064#But I did, sir. Lieutenant Hildebrandt is a third dan in karate. Toughest fighter I've ever known...",
	"#TRI0\\TRI0_065#Who are you calling a weakling? I've had tougher girlfriends than you, pal!",
	"#TRI0\\TRI0_066#Yes sir.",
	"#TRI0\\TRI0_F24#How amusing. Federation weaklings.",
	"#TRI0\\TRI0N000#A Klingon guard. A big Klingon guard. A big Klingon guard with his disruptor ready to fire on anyone who gives him trouble.",
	"#TRI0\\TRI0N001#Admiral Vlict, commander of the Klingon flagship K'lirta.",
	"#TRI0\\TRI0N002#Dr. McCoy glares angrily at Kirk. It is obvious he does not like seeing his patient handed over to the Klingons.",
	"#TRI0\\TRI0N003#Ensign Bennie stares around the Klingon court, distrusting everything he sees.",
	"#TRI0\\TRI0N004#James T. Kirk, trapped in a situation he cannot win, forced to watch a travesty of justice... or is he?",
	"#TRI0\\TRI0N005#Mr. Spock looks stoically at the klingon bench. Expecting to win this case would be illogical.",
	"#TRI0\\TRI0N006#This bench is marked with the symbol of the Klingon Court of High Justice, the two Triangles of Words and Blood, linked together.",
	"#TRI0\\TRI0N007#This city was destroyed by heavy bombardment and intense doses of neutrino rays that killed all known forms of life on this planet.",
	"#TRI0\\TRI0N008#This is the famous seal of the Klingon Empire.",
	"#TRI0\\TRI0N009#Your new found friend looks rather frightened right now, and you don't blame him.",
	"#TRI0\\TRI0U075#Uhura here. Captain, there's a force field over the planet. We will not be able to beam you aboard.",


	"#TRI1\\TRI1_002#Affirmative, Uhura.",
	"#TRI1\\TRI1_003#Affirmative.",
	"#TRI1\\TRI1_004#Beam us to Vlict's position.",
	"#TRI1\\TRI1_005#Beam us back to the Enterprise. Kirk out.",
	"#TRI1\\TRI1_006#I want that door open.",
	"#TRI1\\TRI1_007#I somehow doubt that Vlict intends for us to survive this, whatever the outcome. We're the only thing that stands between him and the killing of Quetzecoatl that he can justify.",
	"#TRI1\\TRI1_008#Negative. Transmit the door entry code only.",
	"#TRI1\\TRI1_009#Negative.",
	"#TRI1\\TRI1_010#That's not true, Ensign. However, I suspect that Vlict's attack on Hrakkour exceeded his orders. He needs Quetzecoatl as a scapegoat, and he needs a fair trial to avoid an inquiry of his own actions.",
	"#TRI1\\TRI1_011#Uhura, prepare to receive a tricorder message. There is a door with an entry coder here; try to analyze the circuits and let the main computer crack the code.",
	"#TRI1\\TRI1_012#This creature is composed of electrical fields. I would not recommend approaching it. A metal projectile might disrupt its fields and render it harmless.",
	"#TRI1\\TRI1_013#A Klingon entry door, slightly antiquated.",
	"#TRI1\\TRI1_014#An entry coder for the door, keyed to a number sequence. The tricorder is unable to determine the code, but can scan the mechanism.",
	"#TRI1\\TRI1_015#Captain, I would strongly recommend against disturbing the rod. It could result in awakening the creature or possibly electrocuting you.",
	"#TRI1\\TRI1_016#Do you know what ten million volts can do to a man? It can ruin his whole damn day.",
	"#TRI1\\TRI1_017#Does not register as a known life form.",
	"#TRI1\\TRI1_018#Find someone else to be a volunteer. I've retired.",
	"#TRI1\\TRI1_019#How could you do it, Jim? I spent hours trying to save his life, and you just gave him away in seconds to the Klingons!",
	"#TRI1\\TRI1_020#I don't know the code.",
	"#TRI1\\TRI1_021#Jim! Are you mad? that's our only way out!",
	"#TRI1\\TRI1_022#One Male Human, average physical condition.",
	"#TRI1\\TRI1_023#He's a Male Human, excellent physical condition.",
	"#TRI1\\TRI1_024#Male Human, good physical condition.",
	"#TRI1\\TRI1_025#One male Human-Vulcan hybrid. Excellent physical condition.", // TYPO
	"#TRI1\\TRI1_026#Nobody needs healing, Jim, but you will if they harm my patient.",
	"#TRI1\\TRI1_027#Ouch!",
	"#TRI1\\TRI1_029#This is not in my field of expertise.",
	"#TRI1\\TRI1_030#This is not in my field of expertise.",
	"#TRI1\\TRI1_031#What the blazes do you want me to do on a rock?",
	"#TRI1\\TRI1_032#A test of courage? That is the Klingon way.",
	"#TRI1\\TRI1_033#I'll bet it'll be mad.",
	"#TRI1\\TRI1_034#Shut up Spock!",
	"#TRI1\\TRI1_035#I do not understand the desired course of action.",
	"#TRI1\\TRI1_036#If you will observe the position of the creature, Captain, I think that you will find that it prevents access to the keypad.",
	"#TRI1\\TRI1_037#Ouch!",
	"#TRI1\\TRI1_038#The door is already open Captain.",
	"#TRI1\\TRI1_039#The odds of surviving contact with the creature are too small to calculate.",
	"#TRI1\\TRI1_040#There is a high probability that shooting the door would be hasardous to our wellbeing.",
	"#TRI1\\TRI1_041#These wooden rods are support beams that were not placed.",
	"#TRI1\\TRI1_042#This rock has a high iron content.",
	"#TRI1\\TRI1_043#This wall was carved from the natural rock.",
	"#TRI1\\TRI1_044#We do not know the code, Captain.",
	"#TRI1\\TRI1_045#As I suspected, Captain. The creature is in stasis. It should awaken in 3.48 days.",
	"#TRI1\\TRI1_046#Captain, I have calculated the odds of surviving this at...",
	"#TRI1\\TRI1_047#Not much is known about Hrakkour, Ensign. This would appear to be some sort of a mining installation; that creature might be a native lifeform.",
	"#TRI1\\TRI1_048#Captain, my instructor at the Academy always told me that if you don't know what you're going to do with your phaser, you shouldn't draw it.", // TYPO
	"#TRI1\\TRI1_049#Do you want me to arrest it, interrogate it, or beat it up, Captain?",
	"#TRI1\\TRI1_050#I refuse, Captain, on the grounds that it might eliminate me.",
	"#TRI1\\TRI1_051#I refuse, Captain, on the grounds that it might eliminate me.",
	"#TRI1\\TRI1_052#Ouch!",
	"#TRI1\\TRI1_053#You handled those Klingons well, sir. We've got them on the run now.",
	"#TRI1\\TRI1_054#You want me to smash it? But that's our only way out of here.",
	"#TRI1\\TRI1_055#And our deaths will be the only way he can get it. Great.",
	"#TRI1\\TRI1_056#What is this place?",
	"#TRI1\\TRI1_057#Why should he worry about justification, Captain? He's a Klingon. Murder is as natural to them as breathing!",
	"#TRI1\\TRI1_J00#Why do I have the feeling that I'm about to have a bad day?",
	"#TRI1\\TRI1N000#A field of static lightning. It seems to be moving in a purposeful manner.",
	"#TRI1\\TRI1N001#A slightly antiquated Klingon door, opened by a keycode entry.",
	"#TRI1\\TRI1N002#A slightly antiquated Klingon lock-mechanism.",
	"#TRI1\\TRI1N003#James T. Kirk, hero of the galaxy!",
	"#TRI1\\TRI1N004#No effect.",
	"#TRI1\\TRI1N005#No effect.",
	"#TRI1\\TRI1N006#The floor is incomplete, made of unrefined, natural rock.",
	"#TRI1\\TRI1N007#The melted rock is cooling, but still remains in a molten state.",
	"#TRI1\\TRI1N008#The wall is resistant to phaser fire.",
	"#TRI1\\TRI1N009#These wooden rods are support beams that were not placed.",
	"#TRI1\\TRI1N011#This section of wall was carved by some sort of plasma field.",
	"#TRI1\\TRI1N012#You burn one of the rods.",
	"#TRI1\\TRI1N013#You coat the rod with molten iron. It hardens quickly.",
	"#TRI1\\TRI1N014#You melt some of the rock.",
	"#TRI1\\TRI1N015#Your ever dependable crewman, Ensign Bennie.",
	"#TRI1\\TRI1N016#Your ever emotional friend, Dr. McCoy.",
	"#TRI1\\TRI1N017#Your ever logical friend, Spock.",
	"#TRI1\\TRI1U068#Nothing else to report Captain.",
	"#TRI1\\TRI1U079#Affirmative sir. We will transmit code when you activate the keycode. Uhura out.",
	"#TRI1\\TRI1U080#Affirmative, sir.",
	"#TRI1\\TRI1U086#Captain, there is a force field between us and the planet.",
	"#TRI1\\TRI1U090#Do you wish to be beamed up now Captain?",
	"#TRI1\\TRI1U095#Good luck, Captain.",
	"#TRI1\\TRI1U098#Keep us informed, we'll help you all we can. We can analyze any data you gather through the main computer.",
	"#TRI1\\TRI1U101#Scan complete. Main computer has the code. We also read an anomaly. Something else has tapped into the keycode. Shall I analyze?",
	"#TRI1\\TRI1U102#Sir, we have a secondary code that is nested in the Klingon program. Computer is unable to analyze its function. Shall we broadcast it to you when you activate the keypad?",
	"#TRI1\\TRI1U106#We have your position at approximately thirty meters beneath the surface of Hrakkour, in what appears to be the ruins of an archeological dig.",
	"Zzzt! Sptttz! Zzzt! Tttt!",
	"Clunk.",


	"#SFX\\QUIET#Zzzzzzzzzzzmmmm.",
	"#TRI2\\TRI2_001#This reminds me of an old practical joke that Finnegan played on me back at the Academy.",
	"#TRI2\\TRI2_002#...some kind of energy source a few meters from our position. We know.",
	"#TRI2\\TRI2_003#Beam us back to the Enterprise. Kirk out.",
	"#TRI2\\TRI2_004#Beam us to Vlict's position.",
	"#TRI2\\TRI2_005#I don't know, Ensign.",
	"#TRI2\\TRI2_006#Keep working on it, but don't try to beam us up unless I give the signal.",
	"#TRI2\\TRI2_007#Negative.",
	"#TRI2\\TRI2_008#Whatever it is, we have to find a way to get by it.",
	"#TRI2\\TRI2_009#Extreme increase in energy level, Captain. It absorbed the phaser fire. An unexpected reaction is occuring, high levels of lethal radiation are being produced.",
	"#TRI2\\TRI2_010#Do you want me to hit my head against it?",
	"#TRI2\\TRI2_011#It does not register as a life form.",
	"#TRI2\\TRI2_012#I'm not touching some damned ball of energy!",
	"#TRI2\\TRI2_013#If you hadn't been so damned anxious to give my patient to the Klingons, we wouldn't be in this mess.",
	"#TRI2\\TRI2_014#One Male Human, average physical condition.",
	"#TRI2\\TRI2_015#He's a male Human, excellent physical condition.", // TYPO
	"#TRI2\\TRI2_016#Male Human, good physical condition.",
	"#TRI2\\TRI2_017#One male Human-Vulcan hybrid. Excellent physical condition.", // TYPO
	"#TRI2\\TRI2_018#Nobody needs healing, Jim, but you will if they harm my patient.",
	"#TRI2\\TRI2_019#Fascinating. It would appear that Vlict sent us into this place in the hope that we would be killed.",
	"#TRI2\\TRI2_020#Fascinating. These automatons are not stable.",
	"#TRI2\\TRI2_021#Fascinating. These automatons are not stable.",
	"#TRI2\\TRI2_022#I do not understand the desired course of action.",
	"#TRI2\\TRI2_023#Marked increase in energy level, Captain. It absorbed the phaser fire. No appreciable increase in mass.",
	"#TRI2\\TRI2_024#The automaton is emitting a protective force field, Captain. We cannot proceed further without rendering it inoperative.",
	"#TRI2\\TRI2_025#The automaton's energy level has increased slightly. It absorbed the phaser fire. No appreciable increase in mass.",
	"#TRI2\\TRI2_026#The ball of energy is an automaton, Captain. It is an artificial construct, programmed to block any movements; I can detect no other function or intelligence.",
	"#TRI2\\TRI2_027#These walls were carved from the natural rock of the cavern.",
	"#TRI2\\TRI2_028#This automaton is generating a force field, Captain. I am physically incapable of touching it.",
	"#TRI2\\TRI2_029#This wall was carved from the natural rock of a cavern.",
	"#TRI2\\TRI2_030#I believe Ensign, that this energy sphere is some sort of automaton, programmed to block our movements.",
	"#TRI2\\TRI2_031#I refuse, Captain, on the grounds that it might incinerate me.",
	"#TRI2\\TRI2_032#Uh, pardon sir?",
	"#TRI2\\TRI2_033#We're not going to get out of this alive, are we Captain?",
	"#TRI2\\TRI2_034#Captain, what is that thing?",
	"#TRI2\\TRI2_F11#This automaton is generating a force field, Captain. I am physically incapable of touching it.",
	"#TRI2\\TRI2N000#A pulsing globe of energy.",
	"#TRI2\\TRI2N001#Commander Spock, a patient and thoughtful Federation first officer.",
	"#TRI2\\TRI2N002#Ensign Bennie, faithful and true security officer.",
	"#TRI2\\TRI2N003#James T. Kirk, a rather frustated Federation starship captain.",
	"#TRI2\\TRI2N004#Klingon insignia.",
	"#TRI2\\TRI2N005#Leads back to the room where the Electrical creature was.",
	"#TRI2\\TRI2N006#Leonard McCoy, a crusty country doctor, and Starfleet's finest surgeon.",
	"#TRI2\\TRI2N007#Rock wall. Looks like it was carved from stone by Klingon heavy mining equipment.",
	"#TRI2\\TRI2N008#The walls are resistant to phaser fire.",
	"#TRI2\\TRI2U074#Please keep in contact with us. We'll keep you informed if further developments occur. Uhura out.",
	"#TRI2\\TRI2U081#By the way, sensors indicate...",
	"#TRI2\\TRI2U087#Captain, there is still a barrier between us and the planet. Mr. Scott thinks there might be a way to break through it, and he's working on it now, but the Klingons won't like it.",
	"#TRI2\\TRI2U091#Do you wish to be beamed up now Captain?",
	"#TRI2\\TRI2U104#Understood, Captain.",


	"#TRI3\\TRI3_001#This is too easy. I don't like it.",
	"#TRI3\\TRI3_002#Beam us directly to the Enterprise.",
	"#TRI3\\TRI3_003#Beam us directly to Vlict's position.",
	"#TRI3\\TRI3_004#Deaths, Bones. Our deaths.",
	"#TRI3\\TRI3_005#I don't like it. This was too easy.",
	"#TRI3\\TRI3_006#We'll call you if we want to transport. Kirk out.",
	"#TRI3\\TRI3_007#We're fine, lieutenant.",
	"#TRI3\\TRI3_008#Captain, Starfleet protocol requires that the commanding officer lead in hazardous situations.",
	"#TRI3\\TRI3_009#Approximately thirty Klingons, within 500 meters of the opening, no closer than 200 meters.",
	"#TRI3\\TRI3_010#Damn it Jim, I'm a Doctor, not a structural Engineer!",
	"#TRI3\\TRI3_011#He's out like a light, Jim. There are hibernating Arcturian sloth-tigers that will get up more quickly than this guy.",
	"#TRI3\\TRI3_012#I believe that you have seniority, Jim.",
	"#TRI3\\TRI3_013#One Male Human, average physical condition.", // TYPO
	"#TRI3\\TRI3_014#He's a Male Human, excellent physical condition.", // TYPO
	"#TRI3\\TRI3_015#Male Human, good physical condition.", // TYPO
	"#TRI3\\TRI3_016#One Male Human-Vulcan hybrid. Excellent physical condition.", // TYPO
	"#TRI3\\TRI3_017#Nobody needs healing, Jim, but you will if they harm my patient.",
	"#TRI3\\TRI3_018#Well, maybe I've been too hard on you, Jim. I'm sorry.",
	"#TRI3\\TRI3_019#Easy! Are you out of your mind?",
	"#TRI3\\TRI3_020#Electrical monsters, things that explode when you phaser them, what else does he want?",
	"#TRI3\\TRI3_021#I do not understand the desired course of action.",
	"#TRI3\\TRI3_022#I recommend caution, Captain.",
	"#TRI3\\TRI3_023#Reading a high energy build-up; there is a Klingon explosive device present five point three meters outside the cavern! It could be detonated at any moment!",
	"#TRI3\\TRI3_024#This wall was carved from the natural rock of a cavern.",
	"#TRI3\\TRI3_025#Admiral Vlict has a reputation for thoroughness, Doctor. If he means to kill us, we can expect more than we've encountered.",
	"#TRI3\\TRI3_026#How hard do you want me to hit it, sir.",
	"#TRI3\\TRI3_027#No sir. I insist that you have the honor of leading us to victory.",
	"#TRI3\\TRI3_028#What are waiting for, sir? Shouldn't we just get out of here?",
	"#TRI3\\TRI3_029#When I get out of this, I am going to have the best shore leave in Starfleet history!",
	"#TRI3\\TRI3_030#Daylight!  We're almost there! We've beaten them!",
	"#TRI3\\TRI3_103#Beam us back to the Enterprise. Kirk out.",
	"#TRI3\\TRI3_104#Beam us to Vlict's position.",
	"#TRI3\\TRI3_107#Negative.",
	"#TRI3\\TRI3N000#Captain James Tiberius Kirk, deep in thought.",
	"#TRI3\\TRI3N001#Doctor Leonard McCoy, a rather disgruntled surgeon.",
	"#TRI3\\TRI3N002#Ensign Bennie, who wishes that he was back at the Academy right now...",
	"#TRI3\\TRI3N003#No gunslinging allowed, space cowboy.",
	"#TRI3\\TRI3N004#Spock, one of the foremost science officers in Starfleet.",
	"#TRI3\\TRI3N005#The exit to this particular complex. You hope.",
	"#TRI3\\TRI3N006#The wall is resistant to phaser fire.",
	"#TRI3\\TRI3N007#The wall of this corridor.",
	"#TRI3\\TRI3U067#Captain, we're still working on breaching the force field. We will let you know when we're ready to beam you out.",
	"#TRI3\\TRI3U080#Affirmative, sir.",
	"#TRI3\\TRI3U084#Captain, our sensors have picked up phaser fire! Are you all right? Captain, please come in!", // TYPO
	"#TRI3\\TRI3U089#Do you wish to be beamed up now Captain?",
	"#TRI3\\TRI3U099#Mr. Scott has found a way to breach the force field!",


	"#TRI4\\TRI4_001#Admiral, one day the weaklings are going to surprise the Hell out of you.",
	"#TRI4\\TRI4_002#Do Klingons believe in ghosts?",
	"#TRI4\\TRI4_003#I don't want it to end like this.", // TYPO
	"#TRI4\\TRI4_004#I don't really give a damn.",
	"#TRI4\\TRI4_005#I won't let you. I chal...",
	"#TRI4\\TRI4_006#I'm sorry we couldn't do more.",
	"#TRI4\\TRI4_007#I'm sorry we couldn't do more.",
	"#TRI4\\TRI4_008#Justice?",
	"#TRI4\\TRI4_009#Maybe you aren't as good as you think you are.",
	"#TRI4\\TRI4_010#No it isn't.",
	"#TRI4\\TRI4_011#Nothing you have done has been honorable, Vlict! One day, everyone in the Klingon empire will know it too. Perhaps one day even you will realize it.",
	"#TRI4\\TRI4_012#Scotty, beam us up.",
	"#TRI4\\TRI4_013#Then you admit that it was you, and not Quetzecoatl who was responsible for the death of Hrakkour.",
	"#TRI4\\TRI4_014#Then you admit this trial is a sham! A charade!",
	"#TRI4\\TRI4_015#Then you will not object to presenting the orders from the Klingon Council authorizing mass murder on Hrakkour.",
	"#TRI4\\TRI4_016#We beat you, Vlict. Unless you free Quetzecoatl, you will lose your honor!",
	"#TRI4\\TRI4_017#What!",
	"#TRI4\\TRI4_018#As we say on Earth, Vlict, nature beat me to it.",
	"#TRI4\\TRI4_019#Did you listen to anything he said? One day, in spite of people like you, the Klingons will know peace. I hope I live to see that day.",
	"#TRI4\\TRI4_020#Farewell my friend. Vlict, if you respect honor, you will make it quick and painless.", // TYPO
	"#TRI4\\TRI4_021#He knows more about courage than you or your Empire will ever know.",
	"#TRI4\\TRI4_022#Honor? Give me a break, Vlict! You were trying to kill us!",
	"#TRI4\\TRI4_023#How can a liar like you even say the word \"honor\" without blushing?",
	"#TRI4\\TRI4_024#How can you call him a traitor without giving him a fair trial!", // TYPO
	"#TRI4\\TRI4_025#I do not know if you are a praying man, Vlict. If I were you, I would not want to meet me again.",
	"#TRI4\\TRI4_026#If you kill him, the Empire will learn that you betrayed them by destroying Hrakkour.",
	"#TRI4\\TRI4_027#Isn't it time that we stopped playing games, Vlict?",
	"#TRI4\\TRI4_028#Shut up Vlict.",
	"#TRI4\\TRI4_029#Then you have my deepest respect. I am sorry I cannot do more for you.",
	"#TRI4\\TRI4_030#There's a time to fight for what you believe, and a time to die for it. I hope you chose the right time, Quetzecoatl.",
	"#TRI4\\TRI4_031#Vlict is right, Quetzecoatl. This is suicide. It is a cowardly action.",
	"#TRI4\\TRI4_032#You didn't say I wasn't allowed to use my ship's computer. If you didn't explain the rules clearly, whose fault is that?",
	"#TRI4\\TRI4_033#You don't lie very well, do you?",
	"#TRI4\\TRI4_034#You lost, Vlict. I beat your test. Release Quetzecoatl and let us go!",
	"#TRI4\\TRI4_036#Jim! You can't let him do this!",
	"#TRI4\\TRI4_037#You never had any intention of letting Quetzecoatl live!",
	"#TRI4\\TRI4_038#He is correct, Captain.",
	"#TRI4\\TRI4_039#I believe that the use of guile, to do what the enemy does not expect, is considered very honorable by the Klingons.", // TYPO
	"#TRI4\\TRI4_040#As do I. My only regret is that I did not get to know you better. If only a part of what you are is because you learned from the mistakes of my acolytes, my work was not in vain.",
	"#TRI4\\TRI4_041#But before I die, I believe that Klingon law allows me to make a public statement.",
	"#TRI4\\TRI4_042#Captain, I do not see any successful resolution to this, except with my death. Dying to prevent conflict would give it meaning.",
	"#TRI4\\TRI4_043#Captain, I taught others self-sacrifice. Now I must practice what I preached. It is the only way to atone for my crimes.",
	"#TRI4\\TRI4_044#Captain, I thank you for your efforts on my behalf, but it is over.",
	"#TRI4\\TRI4_045#Captain, I thank you for your efforts on my behalf, but it is over.",
	"#TRI4\\TRI4_046#Captain, I thank you for your efforts on my behalf, but it is over.",
	"#TRI4\\TRI4_047#I know Captain. But it's better this way.",
	"#TRI4\\TRI4_048#I know Captain.",
	"#TRI4\\TRI4_049#I know, Captain.",
	"#TRI4\\TRI4_050#I, who was once immortal, know that truth is the only true immortal. You can kill people, cultures, even gods, but the truth will always survive.",
	"#TRI4\\TRI4_051#Intelligent beings are not meant to be caged, either by tyranny, or barbarism. Those who try doom themselves to failure.",
	"#TRI4\\TRI4_052#No captain. Let there be an end to this violence. I will not allow any more blood to be shed, save my own. I taught the doctrine of self-sacrifice, and I shall die of it.",
	"#TRI4\\TRI4_053#Once a culture has tasted peace, it will not desire anything else, because peace is better than war, love is better than hate, and creation is better than destruction. This is Truth.",
	"#TRI4\\TRI4_054#A coward's attitude. He shames this soil.",
	"#TRI4\\TRI4_055#As judge, I determine what is fair and what is unfair, Kirk! The trial is at an end. The verdict is guilty.",
	"#TRI4\\TRI4_056#As long as the Federation continues to foster such weaklings, the triumph of the Klingon Empire is assured.",
	"#TRI4\\TRI4_057#Do not threaten me, Kirk! If you expect the Empire to believe you instead of me, you are greatly mistaken.", // TYPO
	"#TRI4\\TRI4_058#Do you think that you can make a fool of me, Kirk!",
	"#TRI4\\TRI4_059#Go back to your Federation, Kirk!",
	"#TRI4\\TRI4_060#How dare you lecture me on points of honor! I, the most decorated warrior in the entire empire! I, who took the dishonored trash of my homeworld and destroyed it with a fist of steel!",
	"#TRI4\\TRI4_061#How dare you! The test was supposed to take place without interference from your ship. You have shown all lack of honor.",
	"#TRI4\\TRI4_062#I am tired of this posturing, Kirk. You know what the verdict is. Go back to your ship.",
	"#TRI4\\TRI4_063#I shall agree to it, Captain. Until we meet again.",
	"#TRI4\\TRI4_064#If I had been trying to murder you, Kirk, you would have surely died.",
	"#TRI4\\TRI4_065#If I was not bound by the Organian treaty, you would be a dead man now, Kirk! Perhaps one day, I shall not be bound by it.",
	"#TRI4\\TRI4_066#Of course it was, you fool! Did you honestly expect us to act with kindness to traitors? You fought a battle that you could not win, and fought it very well. Go home, Kirk.",
	"#TRI4\\TRI4_067#Perhaps because Klingons do not blush. You've lost, Kirk. Go home.",
	"#TRI4\\TRI4_068#Return to your ship, Kirk. The trial is over.",
	"#TRI4\\TRI4_069#Such threats, Kirk, will only increase my longing for the experience.",
	"#TRI4\\TRI4_070#The death ceremony shall take place aboard the K'lirta. I trust you are satisfied that justice has been done.",
	"#TRI4\\TRI4_071#The trial is over! He is guilty. Durn, carry out the sentence!",
	"#TRI4\\TRI4_072#Those who lose honor lose life, Kirk! It is the Klingon way!",
	"#TRI4\\TRI4_073#To allow a traitor to live would dishonor me. I will not live with such a stain on my honor.",
	"#TRI4\\TRI4_074#To free a traitor is to lose all honor, Kirk! He is sentenced to die!",
	"#TRI4\\TRI4_075#Very well. The trial is over. K'etz'koatl is sentenced to death.",
	"#TRI4\\TRI4_076#You humans have an excellent imagination, but a poor grasp of reality.",


	"#TRI5\\TRI5_001#Obviously, they want us to place the gems in the holes, but which one...",
	"#TRI5\\TRI5_002#Gentlemen, I suggest we start trying to find out what this is. I have a feeling we've come some place Vlict wasn't expecting us to go.",
	"#TRI5\\TRI5_003#Hoist on your own petard, eh, Vlict? Do you want me to help you?",
	"#TRI5\\TRI5_004#I do not see what can be served by more killing.",
	"#TRI5\\TRI5_005#I fear that politics will make it impossible. Your planet is in Klingon space. But I don't understand why the Klingons never detected you.",
	"#TRI5\\TRI5_006#If I have your word that Quetzecoatl goes free, I'm willing to intervene to save you.",
	"#TRI5\\TRI5_007#If I have your word that Quetzecoatl goes free, I'm willing to intervene to save you.",
	"#TRI5\\TRI5_008#You tried to send me to my death. Now you can rot as you get what you deserve.",
	"#TRI5\\TRI5_009#You tried to eliminate me. Now you can rot as you get what you deserve.",
	"#TRI5\\TRI5_010#Captain, it seems to be some sort of interface device, but I do not know how to activate it.",
	"#TRI5\\TRI5_011#Jim, I have no idea what it is. Why don't you try asking Spock.",
	"#TRI5\\TRI5_012#Nobody needs healing, Jim, but you will if they harm my patient.",
	"#TRI5\\TRI5_013#We've got to get out of here, Jim!",
	"#TRI5\\TRI5_014#Even I can see that, you pointy-eared freak!",
	"#TRI5\\TRI5_015#He really doesn't have a likable personality, does he?",
	"#TRI5\\TRI5_016#I suspect Captain, that the machinery is activated by placing the gems in the proper slots. We should determine a system for this.",
	"#TRI5\\TRI5_017#This is not Klingon technology, Captain.",
	"#TRI5\\TRI5_018#Kirk!",
	"#TRI5\\TRI5_019#Agreed!",
	"#TRI5\\TRI5_020#Kirk! This is your doing!",
	"#TRI5\\TRI5_021#Rrrrr. Very well. I agree to your terms.",
	"#TRI5\\TRI5_022#You have no right to try me!",
	"#TRI5\\TRI5_023#You want me to beg like a weakling child cowering before his betters!",
	"#TRI5\\TRI5_024#This is Bialbi, the most advanced lifeform on this world. Thank you for informing us of the situation. It shall be resolved.",
	"#TRI5\\TRI5_025#A life for a life is a just bargain. But his crimes are beyond count.",
	"#TRI5\\TRI5_026#Admiral Vlict, the entity Quetzecoatl shall be set free. If you ever return to this sector, the sentence shall be carried out. No Klingon vessel may ever return to this world.",
	"#TRI5\\TRI5_027#Admiral Vlict, this is the defensive system of Hrakkour. You have engaged in genocidal activities on this world. Have you anything to say before your sentence is passed?",
	"#TRI5\\TRI5_028#As for you, Captain, you may return. I find your social development most pleasing.",
	"#TRI5\\TRI5_029#I have as much right as you to conduct trials on this planet. You showed no justice to your victim. The penalty for injustice is death.",
	"#TRI5\\TRI5_030#Idealism! An advanced concept! Naive, perhaps, but charming in its simplicity.",
	"#TRI5\\TRI5_031#No, Admiral, it is not, but that will suffice as a final public statement. The sentence is banishment, to you and all members of your crew who were involved in this action.",
	"#TRI5\\TRI5_032#Now, you may go. Heed my warning Vlict. I shall not be merciful a second time.",
	"#TRI5\\TRI5_033#Their archeological digs did come close, Captain, but I am very elusive. I waited and monitored the situation and chose to reveal myself to you.",
	"#TRI5\\TRI5_034#You will be returned to your ship, Captain. As will the creature who was unfairly punished. You need not witness the Klingon's punishment.",
	"#TRI5\\TRI5_035#Not primed for neural interlink.",
	"#TRI5\\TRI5_036#Alien vessels scanned.",
	"#TRI5\\TRI5_037#Integrator now active",
	"#TRI5\\TRI5_038#Telepathic entry codes required for greater than level One functions. Neural interlink at the integrator, and use the main index code of my light.", // TYPO
	"#TRI5\\TRI5_039#That combination is restricted to higher order functions. Neural interlink required.",
	"#TRI5\\TRI5_040#This is Bialbi, High Mentalic of Hrakkour. For defense, use the light of war. For information, use my light. For transportation, use the light of travel. Sequences are keyed by combinations of crystals.",
	"#TRI5\\TRI5_041#To use any light, the first crystal must correspond to the color of the light.",
	"#TRI5\\TRI5_042#Force field blocks trans-system transport. Transport aborted. Use defense systems to eliminate alien vessels.",
	"#TRI5\\TRI5_043#That destination no longer exists. Transport abandoned.",
	"#TRI5\\TRI5_044#There is damage in the archive section due to a recent neutrino burst. Transport aborted.",
	"#TRI5\\TRI5_045#There is no battle site at present to which to transport you.", // TYPO
	"#TRI5\\TRI5_046#We can transport you only in proximity of nearest humanoid life. Transport imminent.",
	"#TRI5\\TRI5_047#Alien vessels scanned.",
	"#TRI5\\TRI5_048#Breach of protocol. Alien invasion imminent. Internal security activated.",
	"#TRI5\\TRI5_049#Internal defenses off line. Failsafes cancelled.",
	"#TRI5\\TRI5_050#Planetary defenses revived. All alien vessels in orbit destroyed.",
	"#TRI5\\TRI5_051#I guess I should've taken a few more science courses at the Academy.",
	"#TRI5\\TRI5_052#What is this place?",
	"#TRI5\\TRI5N002#A platform emitting a beam of light.", // TYPO
	"#TRI5\\TRI5N004#A strange yellow light.",
	"#TRI5\\TRI5N005#James T. Kirk, hero of the galaxy!",
	"#TRI5\\TRI5N006#Openings on the platform. Place something in these holes?",
	"#TRI5\\TRI5N007#Your communicator is not working.",
	"#TRI5\\TRI5N008#Your ever emotional friend, Dr. McCoy.",
	"#TRI5\\TRI5N009#Your ever logical friend, Spock.",
	"#TRI5\\TRI5N010#Your ever nervous crewman, Ensign Bennie.",
	"#TRI5\\TRI5N011#Your phaser is not working.",
	"#TRI5\\TRI5N012#Your tricorder's recording functions are working, but it does not seem to be able to analyze.",
	"#TRI5\\TRI5N013#This large gem appears to be a ruby of unusual size. This is obviously artificial.",
	"#TRI5\\TRI5N014#This large gem appears to be a ruby of unusual size. This is obviously artificial.",
	"#TRI5\\TRI5N015#This large gem appears to be a ruby of unusual size. This is obviously artificial.",
	"#TRI5\\TRI5N016#This large gem appears to be a sapphire of unusual size. This is obviously artificial.", // TYPO
	"#TRI5\\TRI5N017#This large gem appears to be a sapphire of unusual size. This is obviously artificial.", // TYPO
	"#TRI5\\TRI5N018#This large gem appears to be a sapphire of unusual size. This is obviously artificial.", // TYPO
	"#TRI5\\TRI5N019#This large gem appears to be an emerald of unusual size. This is obviously artificial.", // TYPO
	"#TRI5\\TRI5N020#This large gem appears to be an emerald of unusual size. This is obviously artificial.", // TYPO
	"#TRI5\\TRI5N021#This large gem appears to be an emerald of unusual size. This is obviously artificial.", // TYPO


	"#SIN0\\SIN0_001#Good Mr. Scott. I'll keep you posted. Kirk out.",
	"#SIN0\\SIN0_002#Let me know if things change. Kirk out.",
	"#SIN0\\SIN0_003#Mr. Scott?",
	"#SIN0\\SIN0_004#Scotty, report on the transporter problem.",
	"#SIN0\\SIN0_005#That will still give us plenty of time, Scotty.",
	"#SIN0\\SIN0_006#That's what we're here to find out. The unknown.",
	"#SIN0\\SIN0_007#We didn't notice anything beaming down.",
	"#SIN0\\SIN0_008#Which means that this moon might still be inhabited, Mr. Spock.",
	"#SIN0\\SIN0_009#Aside from the security door on what should be a lifeless planetoid, this place is unremarkable.",
	"#SIN0\\SIN0_010#It's what I was afraid of, Jim. The thin atmosphere of this moon doesn't provide enough protection from cosmic rays. We shouldn't stay here any more than a few hours.",
	"#SIN0\\SIN0_011#The atmosphere is breathable, Jim, but hardly nourishing. We should either get inside or go back to the ship.",
	"#SIN0\\SIN0_012#There's not much I can do for cosmic radiation. It's best if we find some cover indoors.",
	"#SIN0\\SIN0_013#Do you have Vulcan blood ensign?",
	"#SIN0\\SIN0_014#I never realized the Orions ever got past decadence... They hadn't the last time I was there.",
	"#SIN0\\SIN0_015#These stones resemble those on Earth, on Easter Island.",
	"#SIN0\\SIN0_016#I cannot get readings from this range, Captain. But if we do not hurry there will be nothing left to get a reading on.",
	"#SIN0\\SIN0_017#The rocks have a high quantity of Tri-Phosphorate Silver in them.",
	"#SIN0\\SIN0_018#Unremarkable except for low grade power emanations from the door area.",
	"#SIN0\\SIN0_019#As expected Captain. The source of power emanations lies beyond that door.",
	"#SIN0\\SIN0_020#Large quantities of atmosphere are being circulated through these rocks. I would guess there are storage units within this satellite which are constantly replacing the atmosphere that is lost because of this moon's weak gravity.",
	"#SIN0\\SIN0_021#Stone monoliths of faces are a common artistic expression in evolving cultures...",
	"#SIN0\\SIN0_022#Unknown, ensign.",
	"#SIN0\\SIN0_023#We have detected no signs of life, Captain, but the possibility does exist.",
	"#SIN0\\SIN0_024#Area secure, Captain.",
	"#SIN0\\SIN0_025#A power source that has lasted millenia and endured major catastrophes. That's fascinating, Mr. Spock.",
	"#SIN0\\SIN0_026#How can there be an atmosphere on a moon of this size?",
	"#SIN0\\SIN0_027#Like the faces on Vandu II. Even the animal face art of the Orion Post-Decadence Movement is similar.",
	"#SIN0\\SIN0_028#No, sir.",
	"#SIN0\\SIN0_S01#No change Captain. Although why it happened is about as clear as a foggy night in Glasgow.",
	"#SIN0\\SIN0_S48#Aye. We've had some slight problems with the transporters.",
	"#SIN0\\SIN0_S49#I know. I have the lads in Engineering doing a complete overhaul of the ship's systems.",
	"#SIN0\\SIN0_S50#Just a glitch in the main transporter program. Mr. Kyle is loading a back-up, and we're performing tests. The transporters will be down for about an hour.",
	"#SIN0\\SIN0N000#Dr. Leonard McCoy, knowing that they aren't likely to encounter any medical problems, is rather annoyed about being dragged yet again into the transporter.",
	"#SIN0\\SIN0N001#Ensign Mosher seems to be rather curious about the planet's technology.",
	"#SIN0\\SIN0N002#James T. Kirk, worried about the safety of the people of Proxtrey.",
	"#SIN0\\SIN0N003#Mr. Spock looks forward to examining the technology of this ancient culture.",
	"#SIN0\\SIN0N004#Ten thousand points of light are visible to the naked eye through the thin atmosphere of this moon.",
	"#SIN0\\SIN0N005#The heavy-duty security door is now open.",
	"#SIN0\\SIN0N006#There are many rocks here.",
	"#SIN0\\SIN0N007#This is the planet Proxtrey, currently six hundred thousand kilometers from this moon.",
	"#SIN0\\SIN0N008#This looks like a heavy-duty security door built into the side of a hill on this moon.",
	"#SIN0\\SIN0N009#This moon has a thin but breathable atmosphere.",
	"#SIN0\\SIN0N010#You retrieve a rock.",
	"#SIN0\\SIN0N011#These stones look like faces.",
	"#SIN0\\SIN0U069#Nothing new to report Captain.",
	"#SIN0\\SIN0U082#Captain, Mr. Scott wishes to speak with you.",


	"#SIN1\\SIN1_001#Spock, see what you can do with that lock.",
	"#SIN1\\SIN1_002#Check her record, Mr. Scott. She was in the top ten percent of her class in computer systems analysis.",
	"#SIN1\\SIN1_003#Isolate that virus. That's your number one priority.",
	"#SIN1\\SIN1_004#Just do your best, Scotty. Kirk out.",
	"#SIN1\\SIN1_005#There goes our back-up plan. Do what you can, Mr. Scott.",
	"#SIN1\\SIN1_006#Well, we won't be able to phaser any outbound missiles.",
	"#SIN1\\SIN1_007#What is it, Scotty?",
	"#SIN1\\SIN1_008#Your situation, Mr. Scott?",
	"#SIN1\\SIN1_009#A security lock, Captain.",
	"#SIN1\\SIN1_010#A working display panel, Captain.",
	"#SIN1\\SIN1_011#Ah, that worked. I see you deduced that 10200, in the Lucrs base three was equal to their sacred number 99.",
	"#SIN1\\SIN1_012#Damn it, Jim. I'm a doctor, not a locksmith!",
	"#SIN1\\SIN1_013#No appreciable cosmic radiation damage. Yet.",
	"#SIN1\\SIN1_014#There's not much I can do for cosmic radiation. It's best if we find some cover indoors.",
	"#SIN1\\SIN1_015#We should stay inside as much as possible. We must try to protect ourselves from the cosmic radiation.",
	"#SIN1\\SIN1_016#It would be useless Captain. The door could easily withstand our phaser fire.",
	"#SIN1\\SIN1_017#That did not seem to work, Captain. Perhaps we should try a number that had some significance to them. Remember they were very superstitious.",
	"#SIN1\\SIN1_018#That prompted a response, Captain. 01210 is 100 in base four, a number the Sofs regarded as sacred.",
	"#SIN1\\SIN1_019#The door still appears to be in operating condition.",
	"#SIN1\\SIN1_020#The origin point for the broadcast Uhura monitored was approximately fifty meters beyond this door.",
	"#SIN1\\SIN1_021#There is power running to the keypad.",
	"#SIN1\\SIN1_022#This appears to be a dust-covered lens of some sort.",
	"#SIN1\\SIN1_023#This is the focal lense for an anti-intruder laser.",
	"#SIN1\\SIN1_024#Unremarkable.",
	"#SIN1\\SIN1_025#We should carefully consider everything we know about this culture before taking action.",
	"#SIN1\\SIN1_026#From what we know about the Lucrs, they had an affinity for size. Their machines weren't just equipment; they were also monuments.",
	"#SIN1\\SIN1_027#It appears that our mission has increased in importance.",
	"#SIN1\\SIN1_028#I'm just a security officer, Sir.",
	"#SIN1\\SIN1_029#I can believe that.",
	"#SIN1\\SIN1_030#This door is huge. If they were humanoid, they could have been giants...",
	"#SIN1\\SIN1_S10#Captain, I'm afraid we've got a wee problem here.",
	"#SIN1\\SIN1_S17#That it is, Captain. We'll keep you informed. Scott out.",
	"#SIN1\\SIN1_S18#There is some sort of virus in the main computer. Our phasers and tractor beams have been disabled, and there's no way we're getting them back in three hours.",
	"#SIN1\\SIN1_S20#We'll find that virus soon Captain, or I'm an Englishman.",
	"#SIN1\\SIN1_S51#We're still looking for the virus, Captain. I even have Lieutenant Uhura looking through the computer system. I never realized the lass was so good with them.",
	"#SIN1\\SIN1_S85#Aye, I will Captain. I may yet have a trick or two that I can pull, but don't count on any miracles.",
	"#SIN1\\SIN1N000#A lens sits above the doorway, but is it mere decoration?",
	"#SIN1\\SIN1N001#Built into the rock is a very large door.",
	"#SIN1\\SIN1N002#Ensign Mosher is glad to be a member of this landing party, at least for now.",
	"#SIN1\\SIN1N003#It looks like some sort of display panel.",
	"#SIN1\\SIN1N004#It never ceases to amaze you how passive Spock can be, even in the presence of extraordinary wonders.",
	"#SIN1\\SIN1N005#James T. Kirk, A man with a problem. A big problem that is getting bigger.",
	"#SIN1\\SIN1N006#McCoy is examining himself for cosmic radiation sickness symptoms.",
	"#SIN1\\SIN1N007#Meteorites have hit this door and left it undamaged. What are you going to do with a rock?",
	"#SIN1\\SIN1N008#The doorway into the complex is huge.",
	"#SIN1\\SIN1N009#This appears to be some sort of security lock.",
	"#SIN1\\SIN1N010#This heavy-duty door has taken numerous micrometeorite strikes but still appears solid.",
	"#SIN1\\SIN1N011#This is a keypad that looks functional.",
	"#SIN1\\SIN1U070#Nothing new to report Captain.",


	"#SIN2\\SIN2_001#Spock, see what you can do with that lock.",
	"#SIN2\\SIN2_002#Spock, see what you can do with this.",
	"#SIN2\\SIN2_003#The Lucrs did not seem to have a problem with security.",
	"#SIN2\\SIN2_004#Keep working at it, Uhura. Kirk out.",
	"#SIN2\\SIN2_005#Report, Scotty. How are things going?",
	"#SIN2\\SIN2_006#Scotty, any progress on the phasers?",
	"#SIN2\\SIN2_007#Spock is right, Bones. Spock, what are the chances that we could decode the transmission and send a stop code to the base?",
	"#SIN2\\SIN2_008#Well done, Uhura.",
	"#SIN2\\SIN2_009#A computer terminal, Captain. It uses the lucr alphabet. I think I can decipher it.",
	"#SIN2\\SIN2_010#Fascinating. If the Federation language studies were correct, the ideograph for the word \"Scythe\" in the Lucrs language is the 17th symbol in their alphabet. That corresponds with 122 in base 3.",
	"#SIN2\\SIN2_012#Damn it Jim, I'm a surgeon not an alien computer science specialist.", // TYPO
	"#SIN2\\SIN2_013#I think Spock would have a better chance at cracking that, Jim.",
	"#SIN2\\SIN2_014#We're safe from the cosmic radiation, Jim.",
	"#SIN2\\SIN2_015#22%? That's very low -- hardly something to brag about.",
	"#SIN2\\SIN2_016#At least we won't have to worry about suffocating.",
	"#SIN2\\SIN2_017#By then, Proxtrey could be a dead planet.",
	"#SIN2\\SIN2_019#Finally, someone who appreciates me!",
	"#SIN2\\SIN2_020#Jim, let's return to the ship and blast this place to destroy its weapons.",
	"#SIN2\\SIN2_021#So why has the base been activated again?",
	"#SIN2\\SIN2_022#Spock!",
	"#SIN2\\SIN2_023#This place does seem to provide protection against cosmic rays.",
	"#SIN2\\SIN2_024#That did not work, Captain. It is probable this lock also uses a number of some significance.",
	"#SIN2\\SIN2_025#The door will easily withstand our phasers, Captain.",
	"#SIN2\\SIN2_026#The interior of the security lock is unremarkable and well preserved.",
	"#SIN2\\SIN2_027#This door is similar to the one on the outside of the securelock except that it has not weathered over the years. Electrical panels indicate the keypad on the right controls the door.",
	"#SIN2\\SIN2_028#This keypad is fully functional and controls the door. Its entry code is in base three.",
	"#SIN2\\SIN2_029#1.327 million to one, provided the archaeological studies about Lucrs languages are correct. Our other option is to get into this base and see if we can bring the computers down.",
	"#SIN2\\SIN2_030#Actually, Ensign, they differ from your culture only in that their language was explicit in their expressions of dominance and submission, rather than implied.",
	"#SIN2\\SIN2_031#Because it does not recognize them, it assumes the Sofs are still active.",
	"#SIN2\\SIN2_032#Doctor, in base 3, 22/100 is equivalent to 8 out of 9 or 88%. I would think that quite satisfactory given this base's probable mission of destroying the Sof forces on Proxtrey.",
	"#SIN2\\SIN2_033#Doctor, this moon is a god to the people down there. If we destroy it we will violate the Prime Directive.",
	"#SIN2\\SIN2_034#Given the damage to the moon, its slow rotation and orbit, it has never realized the war is over. On this pass, for the first time, it has detected radio-wave transmissions from Proxtrey.",
	"#SIN2\\SIN2_035#If the Lucrs built this base with a clock that told the time by measuring the moon's rotational speed or the gravitational forces generated by Proxtrey and the sun, the computer may have calculated only a week of time has passed since its first action. I might be able to learn more with another look at the console.",
	"#SIN2\\SIN2_037#In Trinary or Decimal?",
	"#SIN2\\SIN2_038#Its transmission to the planet, I would assume, was some sort of a check beacon to see if it should continue its mission.",
	"#SIN2\\SIN2_039#My tricorder is picking up large supplies of frozen oxygen, nitrogen, and carbon dioxide beneath the surface. Enough to last many centuries.",
	"#SIN2\\SIN2_040#One Sof strike did, in fact, hit the moon and deflected it from its orbit. It has been dormant since then.",
	"#SIN2\\SIN2_041#The Sofs managed to infiltrate the base. however, their actions triggered Scythe's auto-attack mechanisms, and initiated a holocaust that nearly annihilated the planet. ",
	"#SIN2\\SIN2_042#The console reports the following: ",
	"#SIN2\\SIN2_043#There is a substantial amount of data here, but in summary, Scythe was created by the Lucrs as a launching platform for missiles to keep the Sofs subjugated to their influence.",
	"#SIN2\\SIN2_044#Welcome to Orbital Missile Base. Codename: Scythe. This base has been operational for the past week. It has completed 1 successful fire mission. Estimation of success is at 22/100.",
	"#SIN2\\SIN2_045#I think Mr. Spock would have a better idea of how to operate that, Captain.",
	"#SIN2\\SIN2_046#I'm just a security officer, Sir.",
	"#SIN2\\SIN2_047#We appear to be in some type of Security Lock. No defensive systems are apparent here, but considering the size of the doors, they probably don't need them!",
	"#SIN2\\SIN2_048#Dominance seemed to be very important to these people. No wonder the Lucr were so war-like.",
	"#SIN2\\SIN2_049#I don't see why they bothered putting an atmosphere here, Captain. There hasn't even been bacteria here in centuries, let alone humanoids.",
	"#SIN2\\SIN2_050#It says the base has been operational for a week, but this has been here for a thousand years.",
	"#SIN2\\SIN2_F12#This says: \"Dominant People only to dominate things beyond >,<these Submissive Walls\". My guess is that only authorized personnel were allowed beyond this door.",
	"#SIN2\\SIN2_F26#Computer science sounds more like medicine every day.",
	"#SIN2\\SIN2_S05#About as badly as a kilt in a blast furnace, Captain. Wait a minute, Lieutenant Uhura has some news for you.",
	"#SIN2\\SIN2_S16#Sorry Captain, but we cannot do that. We don't have phasers for at least eight more hours.",
	"#SIN2\\SIN2N000#A computer terminal. Each word in the Lucr language has three aspects, Submissive, Neutral, and Aggressive, to supply connotation to their language.",
	"#SIN2\\SIN2N001#A keypad, in base three.",
	"#SIN2\\SIN2N002#Ensign Mosher is scanning the area for potentially hostile lifeforms.",
	"#SIN2\\SIN2N003#James Kirk. The burden of command is quite heavy at times.",
	"#SIN2\\SIN2N004#McCoy wishes this place was less... technological.",
	"#SIN2\\SIN2N005#Spock looks at the equipment and raises an eyebrow.",
	"#SIN2\\SIN2N006#This looks like some kind of security lock with heavy duty doors on both ends.",
	"#SIN2\\SIN2N007#You see another chamber.",
	"#SIN2\\SIN2N008#The door has some strange writing on it.",
	"#SIN2\\SIN2U085#The virus came from our sensor sweep of the moon's computers. We believe we have analyzed the memory sectors it attacked.",
	"#SIN2\\SIN2U096#If we had a doctor as good with computers as you are with patients, we'd be having a lot fewer problems.", // TYPO
	"#SIN2\\SIN2U097#I wish I could take credit for it. It was Mr. Kyle who found the pattern. We are attacking it with anti-virus programs.",


	"#SIN3\\SIN3_001#Spock, why don't you check out those laser drill controls.",
	"#SIN3\\SIN3_002#You're right. This is a mess.",
	"#SIN3\\SIN3_003#A storage box of some kind. I detect no dangerous substances.",
	"#SIN3\\SIN3_004#Captain, nothing can be gained by trying to force it around.",
	"#SIN3\\SIN3_005#Captain, the machine requests the proper coordinates before it may perform this operation.",
	"#SIN3\\SIN3_006#Captain, the template would be damaged by direct fire from the laser.",
	"#SIN3\\SIN3_007#Captain, with the 3KAg content of the surface rocks and the Tricorder scan of the pattern inside the lock, I believe the laser drill can be used to fashion the ID card needed to open the sealed door in the other chamber.",
	"#SIN3\\SIN3_008#All readings are normal. The structure seems to be protecting us from the cosmic rays.",
	"#SIN3\\SIN3_009#I'm too attached to my head to stick it in front of the laser that made this cave.",
	"#SIN3\\SIN3_010#We're safe from the cosmic radiation, Jim.",
	"#SIN3\\SIN3_011#Why was I even brought down on this mission, Jim? I'm a doctor, not a welder!",
	"#SIN3\\SIN3_012#Can't say I like the decor.",
	"#SIN3\\SIN3_013#I can see why.",
	"#SIN3\\SIN3_014#This is one heck of a museum, Ensign.",
	"#SIN3\\SIN3_015#I used the keycard pattern, scanned from the lock, to program the drill. It should now be able to make a template of the keycard in the rock.",
	"#SIN3\\SIN3_016#The drill is unremarkable except its aiming component is corroded and frozen in place.",
	"#SIN3\\SIN3_017#The mineshaft was drilled out of the lunar rock by a laser device similar to the one mounted in the ceiling.",
	"#SIN3\\SIN3_018#These are display panels for the laser drill. They are still functional.",
	"#SIN3\\SIN3_019#This is the laser drill's control panel. It is functional and power is flowing to it.",
	"#SIN3\\SIN3_020#This technology is cruder and less efficient than the rest of the complex, Captain.",
	"#SIN3\\SIN3_021#Too high a setting, Captain. The laser drill vaporized the rock.",
	"#SIN3\\SIN3_022#Unlike the mineral samples on the surface, the rocks here do not contain any unusual trace elements.",
	"#SIN3\\SIN3_023#Unlike the surface rocks, the ore here is unremarkable.",
	"#SIN3\\SIN3_024#The Lucrs did not leave behind many examples of their architecture.",
	"#SIN3\\SIN3_025#Uh, what do you want me to do with it, Sir?",
	"#SIN3\\SIN3_026#Looks like a museum piece to me, Captain.",
	"#SIN3\\SIN3_027#Still a mess, though.",
	"#SIN3\\SIN3N000#A closed box sits on the floor.",
	"#SIN3\\SIN3N001#Dr. McCoy again wonders why he even came along.",
	"#SIN3\\SIN3N002#Ensign Mosher scouts for signs of trouble, as well as glancing at the great-looking laser drill!",
	"#SIN3\\SIN3N003#James T. Kirk, Captain of the USS Enterprise.",
	"#SIN3\\SIN3N004#Mr. Spock puzzles over the illogical design of some of these circuits.",
	"#SIN3\\SIN3N005#The box is empty.",
	"#SIN3\\SIN3N006#The laser drill has cut a template for the keycard in the stone.",
	"#SIN3\\SIN3N007#These are display panels for the laser drill.",
	"#SIN3\\SIN3N008#This box contains old wire and connectors.",
	"#SIN3\\SIN3N009#This is a high powered item that will cause irrevocable damage if you use it in this manner.",
	"#SIN3\\SIN3N010#This is a keycard made from the tri-phosphorate silver rock.", // TYPO
	"#SIN3\\SIN3N011#This is a laser drill control panel.",
	"#SIN3\\SIN3N012#This is an ancient laser drill.",
	"#SIN3\\SIN3N013#This room looks like it was once used for some type of mining operation.",
	"#SIN3\\SIN3N014#You have placed the rocks onto the pattern.",
	"#SIN3\\SIN3U072#Nothing new to report Captain.",
	"Laser Setting: 001",
	"Laser Setting: 010",
	"Laser Setting: 100",
	"cancel",


	"#SIN4\\SIN4_001#At least the Enterprise is safe.",
	"#SIN4\\SIN4_002#Right now, I'll take anything that works. Kirk out.",
	"#SIN4\\SIN4_003#The Klingons aren't going to be happy to learn that they helped us. How about the phasers and tractor beams?",
	"#SIN4\\SIN4_004#Then we're just going to have to prevent that.",
	"#SIN4\\SIN4_005#Understood. The ball is in our court. We'll give it our best shot. Kirk out.",
	"#SIN4\\SIN4_006#We're making our way through. Keep your fingers crossed, lieutenant.",
	"#SIN4\\SIN4_007#Well done, Uhura!",
	"#SIN4\\SIN4_008#Captain, if you destroy the lock, there will be no way to open the door.",
	"#SIN4\\SIN4_009#Captain, the door is heavily shielded. Our phasers will have a negligible effect.",
	"#SIN4\\SIN4_010#Captain, with the 3KAg content of the surface rocks and the Tricorder scan of the pattern inside the lock, I believe the laser drill can be used to fashion the ID card needed to open this door.",
	"#SIN4\\SIN4_011#Circuits and atmosphere pumps are hidden in the walls.",
	"#SIN4\\SIN4_012#All readings are normal. The structure seems to be protecting us from the cosmic rays.",
	"#SIN4\\SIN4_013#My fingers don't fit Jim.",
	"#SIN4\\SIN4_014#We're safe from the cosmic radiation, Jim.",
	"#SIN4\\SIN4_015#When I retire from Starfleet, I'm going to write one heck of an autobiography.",
	"#SIN4\\SIN4_016#What do you want me to do, kick it down?",
	"#SIN4\\SIN4_017#That way I can finally get someone to listen to me!",
	"#SIN4\\SIN4_018#My fingers are too large to fit into the slot.",
	"#SIN4\\SIN4_019#Please allow me to concentrate, Captain.",
	"#SIN4\\SIN4_020#This panel has a slot in it rather than a keypad. The slot bears traces of Tri-Phosphorate Silver, and power is currently running to it. I am recording the pattern of this lock into my tricorder.",
	"#SIN4\\SIN4_021#This panel requires a coded identification key to get it open.",
	"#SIN4\\SIN4_022#Very odd, Captain. There was a power surge to the panel just after the rock struck it. Probably 3KAg dust getting into the slot. ",
	"#SIN4\\SIN4_023#We must find a way to bypass its lock system.", // TYPO
	"#SIN4\\SIN4_024#Fascinating, doctor. I look forward to reading it.",
	"#SIN4\\SIN4_025#Fascinating, lieutenant.",
	"#SIN4\\SIN4_026#Indeed, Ensign. And considerably thinner. A remarkable achievement in metallurgical engineering.",
	"#SIN4\\SIN4_027#This door is made from remarkably dense alloys. Even our most powerful phaser rifle or welder would not be able to penetrate it.",
	"#SIN4\\SIN4_028#Unless the computers decide to send more powerful viruses to the Enterprise.",
	"#SIN4\\SIN4_029#I don't think a hand phaser is going to cut through that, Sir.",
	"#SIN4\\SIN4_030#I don't think my phaser will do a lot of good Sir.",
	"#SIN4\\SIN4_031#This machinery is incredible. Are all your landing missions this much fun? I might never leave this place!",
	"#SIN4\\SIN4_032#The thing must be almost as tough as a starship hull!",
	"#SIN4\\SIN4N000#Although centuries old, these lights still provide illumination for this complex.",
	"#SIN4\\SIN4N001#As soon as this mission is over, Ensign Mosher is going to write his sister, who serves onboard Pegasus Science Station, and gloat about everything he's seen.",
	"#SIN4\\SIN4N002#James Kirk seems relieved by the good news from his ship.",
	"#SIN4\\SIN4N003#So far, this mission has been boring, from a medical standpoint.",
	"#SIN4\\SIN4N004#Spock, deep in thought, analyzes the Lucr computers.",
	"#SIN4\\SIN4N005#There are a few stress fractures on this beam, but it still looks to be quite sturdy.",
	"#SIN4\\SIN4N006#There is already a card in the lock.",
	"#SIN4\\SIN4N007#This door appears to be very solid.",
	"#SIN4\\SIN4N008#This door leads to another chamber.",
	"#SIN4\\SIN4N009#This doorway leads back to the security lock and outside.",
	"#SIN4\\SIN4N010#This doorway leads to another area of the complex.",
	"#SIN4\\SIN4N011#This panel is designed to receive an ID card to make the door open.",
	"#SIN4\\SIN4N012#The Panel is undamaged.",
	"#SIN4\\SIN4N013#You are in a corridor that connects to three other chambers.",
	"#SIN4\\SIN4U073#Nothing new to report Captain.",
	"#SIN4\\SIN4U088#Captain, we have a cure for the computer virus!",
	"#SIN4\\SIN4U100#No change, Captain. Any progress on the planet?",
	"#SIN4\\SIN4U103#I modified K'trhra-C to exclusively attack the Lucr virus. They annihilated each other, Captain.",
	"#SIN4\\SIN4U105#We could destroy some missiles manually, but if this complex decides to launch more than ten missiles at a time...",
	"#SIN4\\SIN4U107#We may get the tractor beams on-line in time, Captain. I'm afraid even the back-up phaser transmission codes were affected. ",
	"#SIN4\\SIN4U83B#Captain, we'll help you all we can.",


	"#SIN5\\SIN5_001#Hmmmm... This computer doesn't have a keyboard.",
	"#SIN5\\SIN5_002#I don't have anything to say right now, Bones.",
	"#SIN5\\SIN5_003#Mr. Spock, why don't you take a look at those computers.",
	"#SIN5\\SIN5_004#Mr. Spock, why don't you take a look at those computers.",
	"#SIN5\\SIN5_005#Bring us home.",
	"#SIN5\\SIN5_006#Can you reprogram the Lucrs computer to give us that time, Mr. Spock?",
	"#SIN5\\SIN5_007#If we could only bridge them...",
	"#SIN5\\SIN5_008#Kirk to Enterprise. how are the transporters, Scotty?",
	"#SIN5\\SIN5_009#Let's just find a way to stop this from happening again.",
	"#SIN5\\SIN5_010#Sometimes it's useful to confront the dark side of our nature, that which we might become.",
	"#SIN5\\SIN5_011#Well, gentlemen. Here's one fire we can put out. Let's go to work.",
	"#SIN5\\SIN5_012#A crude Uranium 235 nuclear device with Lithium - Beryllium shells to increase heavy particle fallout.",
	"#SIN5\\SIN5_013#All three of the computers in this room are fully operational.",
	"#SIN5\\SIN5_014#All readings are normal. The structure seems to be protecting us from the cosmic rays.",
	"#SIN5\\SIN5_015#Jim, I don't know anything about these things! Why don't you ask your science officer.",
	"#SIN5\\SIN5_016#Thank goodness. I was worried there might be a radiation leak, but there's no sign of any.", // TYPO
	"#SIN5\\SIN5_017#We're safe from the cosmic radiation, Jim.",
	"#SIN5\\SIN5_018#I wish I hadn't seen any of this.",
	"#SIN5\\SIN5_019#There's nothing constructive about this place, Spock! It's an obscenity!",
	"#SIN5\\SIN5_020#They report different optimum launch times. Which is right?",
	"#SIN5\\SIN5_021#Too bad old Omega here couldn't just take a sick day and miss the firing.",
	"#SIN5\\SIN5_022#Unbelievable, isn't it? Putting this much time and effort into building devices to kill people.",
	"#SIN5\\SIN5_023#Who needs efficiency, when the end of the world is everywhere around here!",
	"#SIN5\\SIN5_024#Readings indicate an extremely high radiation level beyond those doors. It would be fatal to proceed beyond them.",
	"#SIN5\\SIN5_025#The launched missiles will run out of fuel before they reach Proxtrey. They will drift into the sun and burn up.",
	"#SIN5\\SIN5_026#This appears to be the brain of Scythe. There are two identical but isolated computers that communicate with a third which controls the launch of missiles.",
	"#SIN5\\SIN5_027#This computer cannot be accessed directly. It is controlled by the other two computers.",
	"#SIN5\\SIN5_028#This computer directly controls the missile launch system. There is no way to interface with it directly, but the other two computers are accessible.",
	"#SIN5\\SIN5_029#This computer is functional and performing an average .75 million operations per second.",
	"#SIN5\\SIN5_030#This computer is functional and performing an average 1.2 million operations per second.",
	"#SIN5\\SIN5_031#A great waste, doctor. A technologically advanced society, an advanced culture...",
	"#SIN5\\SIN5_032#Because the two machines are isolated, the virus did not spread from one to the other.",
	"#SIN5\\SIN5_033#Curb your emotions, doctor. They serve no constructive purpose here. ",
	"#SIN5\\SIN5_034#For people with emotions, Ensign, there are many things that can cause hatreds. And each new hatred breeds more hatred, and makes the path of peace harder to find.",
	"#SIN5\\SIN5_035#Given the elliptical orbit and the range at which they will pass Proxtrey, the Omega unit is correct, but the window is very narrow. A variation of minutes will mean the missiles run out of fuel and fall harmlessly into the sun.",
	"#SIN5\\SIN5_036#It appears they are out of sync, Captain. I have to assume the Alpha Unit has a virus which is using up an incredible amount of computing time.",
	"#SIN5\\SIN5_037#Reprogramming an old Alien computer is not simple, Captain. The odds against success are 10221 to 1 against.",
	"#SIN5\\SIN5_038#These warheads are not a very efficient delivery system, Captain.",
	"#SIN5\\SIN5_039#Welcome to Scythe Operations Center, Alpha Unit. Estimated time to optimal launch range is 3.21 hours adjusted.",
	"#SIN5\\SIN5_040#Welcome to Scythe Operations Center, Omega Unit. Estimated time to optimal launch range is 1.31 hours adjusted.",
	"#SIN5\\SIN5_041#Welcome to Scythe Operations Center, Omega Unit. Estimated time to optimal launch range is 1.54 hours adjusted.",
	"#SIN5\\SIN5_042#Sir, I don't think I'm qualified for that assignment. Mr. Spock would be a better choice, I think.",
	"#SIN5\\SIN5_043#The stun setting won't work, Sir!",
	"#SIN5\\SIN5_044#Captain, something is wrong with the computers. They may be twins, but they are not identical.",
	"#SIN5\\SIN5_045#It's easy to say when you're not involved personally, Mr. Spock. But when people have treated you like a second class being because you are different, hate can become the only thing they can't take away from you. That is what started most of the firestorms of history.",
	"#SIN5\\SIN5_046#No intruders, Captain. I think everyone died a long, long time ago. I wonder what caused it.",
	"#SIN5\\SIN5_S19#They're operational again, Captain. We're ready to bring you back at any time.",
	"#SIN5\\SIN5N000#Captain James T. Kirk, fingering his communicator, wonders if anything else is happening aboard his ship.",
	"#SIN5\\SIN5N001#Dr. McCoy takes several deep sighs and closes his eyes.",
	"#SIN5\\SIN5N002#Ensign Mosher awaits orders.",
	"#SIN5\\SIN5N003#Missiles of death and destruction. The Lucr believed that you could never have enough of them.",
	"#SIN5\\SIN5N004#The connector snaps into place.",
	"#SIN5\\SIN5N005#The control center for the base. Computers and nuclear missiles fill the room.",
	"#SIN5\\SIN5N006#These instruments of war make Spock uncomfortable, but he says nothing.",
	"#SIN5\\SIN5N007#These lights are still operational after centuries.",
	"#SIN5\\SIN5N008#This computer controls the launch of missiles. It is directly controlled by the other computers.",
	"#SIN5\\SIN5N009#This computer is marked with the first letter of the Lucr alphabet.",
	"#SIN5\\SIN5N010#This computer is marked with the last letter of the Lucr alphabet.",
	"#SIN5\\SIN5N011#This door is marked with a radiation hazard symbol.",
	"#SIN5\\SIN5N012#Computer consoles do not take well to phasering. Sparks fly and, in a defensive maneuver prompted by this attack from within, the base launches a full spread of nuclear missiles at the Enterprise.", // TYPO
	"#SIN5\\SIN5N013#History will not be kind to you. Better luck next time.",


	"#VEN0\\VEN0_001#Dick Patterson and I weren't exactly friends, but this...",
	"#VEN0\\VEN0_002#Any idea of which one it was?",
	"#VEN0\\VEN0_003#Can you bring him back?",
	"#VEN0\\VEN0_004#Dick Patterson was never one for making long speeches.",
	"#VEN0\\VEN0_005#Do the sensors read any other ships in the sector?",
	"#VEN0\\VEN0_006#I don't know, Bones. We're too far from the Klingon and Romulan borders for it to be one of their ships.",
	"#VEN0\\VEN0_007#It's a mess, Scotty. Life support's functioning, but that's about it.",
	"#VEN0\\VEN0_008#Kirk Here. What is it, Scotty?",
	"#VEN0\\VEN0_009#Mr. Scott, we will continue here. Assist the trade ship and return here. If we need assistance, we will contact you.",
	"#VEN0\\VEN0_010#Well, Gentlemen. Let's see if we can reestablish power.",
	"#VEN0\\VEN0_011#Yes, Scotty. Just don't take too long. Kirk out.",
	"#VEN0\\VEN0_012#Captain, I believe we have exhausted all our options concerning data retrieval here on the bridge.",
	"#VEN0\\VEN0_013#Captain, these phasers are not configured for fine cutting. We could cause extensive damage.",
	"#VEN0\\VEN0_014#What kind of a butcher would do this sort of thing?",
	"#VEN0\\VEN0_015#I'm a doctor, not a civil engineer!",
	"#VEN0\\VEN0_016#They're dead, Jim. All of them.", // TYPO (for only some rooms this text appears in)
	"#VEN0\\VEN0_017#Jim, don't forget, there's another survivor on board. We've got to find him!",
	"#VEN0\\VEN0_018#My God, Jim. What kind of butcher would do something like this?",
	"#VEN0\\VEN0_019#Punctured lung, nerve damage, brain damage, fractured arm and ribs; it's a miracle he lasted as long as he did. He's not coming back, Jim.",
	"#VEN0\\VEN0_020#Someone must have tampered with the computer records!",
	"#VEN0\\VEN0_021#Thanks for the dissertation, Spock.",
	"#VEN0\\VEN0_022#We're too late. This man must have just died a few moments ago.",
	"#VEN0\\VEN0_023#I recommend checking as many of the logs and sensor records as possible.",
	"#VEN0\\VEN0_024#The controls have been totally destroyed. Undoubtedly due to circuit overloads caused by the battle.",
	"#VEN0\\VEN0_025#There are no more computer entries accessible from this station.",
	"#VEN0\\VEN0_026#There are no more log entries.",
	"#VEN0\\VEN0_027#Tricorder readings indicate that the ship is running on minimal battery power. Only life support and essential systems are currently running.",
	"#VEN0\\VEN0_028#Captain, records indicate that this ship was attacked by a Constitution-class Starship.",
	"#VEN0\\VEN0_029#I am reading a record of the transponder signal. NCC-1701. It's the Enterprise, Captain.",
	"#VEN0\\VEN0_030#I've done a primary scan of the Republic's systems. Main and auxiliary power is out. Life support is stable. I also read that communications are operable.",
	"#VEN0\\VEN0_031#May I remind you, Doctor, that the main computer of a Constitution class starship has safeguards against such an intrusion. Furthermore, I do not see any discrepancies in any of the files that I am able to access.",
	"#VEN0\\VEN0_32#My tricorder has picked up the final entry of the Republic.",
	"#VEN0\\VEN0_033#That's all there is, Captain.",
	"#VEN0\\VEN0_034#This is a standard Tritanium/Duranium support beam. Tricorder readings indicate that although it has experienced enough tensile stress to push it from one side of its mooring, it has not elastically deformed beyond its ability to support a compressive load.",
	"#VEN0\\VEN0_035#We are under attack. Our sensors are inoperative. We're trying to get shields up. Our rear deflector's down. It appears our enemy is a Constitution class starship. We have tried to defend ourselves. We've hailed them, but no response.",
	"#VEN0\\VEN0_036#I feel sick.",
	"#VEN0\\VEN0_037#I think I remember seeing a ton of these at spacedock 4.",
	"#VEN0\\VEN0_038#There is no response, Captain. The controls are completely dead.",
	"#VEN0\\VEN0_039#Besides the trade wessel, this sector is clear, Sir.",
	"#VEN0\\VEN0_S12#Enterprise to Captain Kirk.",
	"#VEN0\\VEN0_S15#Should we beam you back, Captain?",
	"#VEN0\\VEN0_S52#We've picked up a distress signal. It appears a trading vessel is having a wee bit of trouble with their warp drive. What condition is the Republic in?",
	"#VEN0\\VEN0_S54#You sure you'll be all right, Captain?",
	"#VEN0\\VEN0N000#A common Tritanium/Duranium support beam which has snapped away from the hull.",
	"#VEN0\\VEN0N001#Captain James T. Kirk. This is not one of the best days of his life.",
	"#VEN0\\VEN0N002#Dr. Leonard McCoy. You have rarely seen him as shaken as he is now.",
	"#VEN0\\VEN0N003#Ensign Kije, who wishes that Lieutenant Stackpole had drawn this assignment.",
	"#VEN0\\VEN0N004#Here is the body of Captain Patterson of the Republic. He didn't die without a fight.",
	"#VEN0\\VEN0N005#Main computer banks. They appear to have been damaged.",
	"#VEN0\\VEN0N006#Mr. Spock, awaiting orders.",
	"#VEN0\\VEN0N007#The molecular saw easily cuts through the beam, separating it from the hull.",
	"#VEN0\\VEN0N008#The support beam has already been detached from the hull.",
	"#VEN0\\VEN0N009#The support beam is still attached to the hull.",
	"#VEN0\\VEN0N010#The viewscreen is not functioning.",
	"#VEN0\\VEN0N011#These are the helm controls for the Republic. They are currently inactive.",
	"#VEN0\\VEN0N012#These are the navigation controls for the Republic. They are currently inactive.",
	"#VEN0\\VEN0N013#This beam has been detached from the hull.",
	"#VEN0\\VEN0N015#This is is the Captain's chair, where the Captain's log is stored.",
	"#VEN0\\VEN0N016#This man is dead.",
	"#VEN0\\VEN0N017#This person is dead.",
	"#VEN0\\VEN0N018#You are in what's left of the bridge of the U.S.S. Republic.",
	"#VEN0\\VEN0N019#You pick up the beam. It's a little heavy, but you manage it.",


	"#VEN1\\VEN1_001#I wonder if anything will be working in Auxilary Control.",
	"#VEN1\\VEN1_002#You'll get your chance, Bones. I promise.",
	"#VEN1\\VEN1_004#I'd like to meet the people responsible for this and give them a piece of my mind.",
	"#VEN1\\VEN1_005#Too bad you can't say the same for the crew.",
	"#VEN1\\VEN1_006#Initial scans show that the gear mechanism is currently jammed with metallic debris.",
	"#VEN1\\VEN1_007#Readings of the door indicate a jam in the gear mechanism.",
	"#VEN1\\VEN1_008#That may not be wise, Captain. It could damage the entire door assembly in its weakened condition.",
	"#VEN1\\VEN1_009#The gear mechanism is now cleared.",
	"#VEN1\\VEN1_010#The gears are moving freely and are completely operative.",
	"#VEN1\\VEN1_011#The vent is far too small for any one of us to fit through. It is also blocked point three meters inside the duct.",
	"#VEN1\\VEN1_012#This is a molecular saw, Captain. It is used for precision cutting. My tricorder reads that the power cells are fully charged.",
	"#VEN1\\VEN1_013#The Starfleet Engineers did their work well Captain. A surprising amount of the ship is intact.",
	"#VEN1\\VEN1_014#Tricorder indicates that the panel is currently sealed by Federation standard molecular bonding cement.",
	"#VEN1\\VEN1_015#From my lessons at the Academy, sir, we were told that a standard issue Federation phaser does not have enough power to cut through a security door such as this one.",
	"#VEN1\\VEN1_016#I'm not in a talking mood right now, sir.",
	"#VEN1\\VEN1_F33#The panel is open.",
	"#VEN1\\VEN1N000#A knot of debris is jamming the gear mechanism.",
	"#VEN1\\VEN1N001#A Molecular Saw. The 23rd century equivalent of a hacksaw.",
	"#VEN1\\VEN1N002#Captain Kirk hopes that he will never see the day when the Enterprise is this badly battered.",
	"#VEN1\\VEN1N003#Irritated by the emotions of the humans that are accompanying him, Spock does his best to keep his mind on the problems at hand.",
	"#VEN1\\VEN1N004#Leonard McCoy wishes he were back on the Enterprise.",
	"#VEN1\\VEN1N005#Kije wishes that everyone would stop fidgeting. It's making him nervous.",
	"#VEN1\\VEN1N006#The debris is jammed in too tight.",
	"#VEN1\\VEN1N007#The door is jammed shut.",
	"#VEN1\\VEN1N008#The drill easily breaks through the seal of the panel.",
	"#VEN1\\VEN1N009#The drill is not powerful enough to cut through the debris.",
	"#VEN1\\VEN1N010#The gear mechanism for the door is now fully functional.",
	"#VEN1\\VEN1N011#The gears are completely cleared of debris.",
	"#VEN1\\VEN1N012#The Hypo is empty.",
	"#VEN1\\VEN1N013#The molecular saw is much too large for the panel.",
	"#VEN1\\VEN1N014#The molecular saw will not penetrate a security door.",
	"#VEN1\\VEN1N015#The oil seeps into and loosens the debris.",
	"#VEN1\\VEN1N016#The panel has been fastened shut with some kind of sealant.",
	"#VEN1\\VEN1N017#The panel opens easily.",
	"#VEN1\\VEN1N018#The saw is too bulky to reach the jammed debris.",
	"#VEN1\\VEN1N019#There appears to be debris jammed in the gear mechanism.",
	"#VEN1\\VEN1N020#This corridor leads to auxiliary control. It is a real mess.",
	"#VEN1\\VEN1N021#This door leads to auxiliary control.",
	"#VEN1\\VEN1N022#This is the maintenance panel for the auxiliary control room door.",
	"#VEN1\\VEN1N023#You retrieve the molecular saw.",


	"#VEN2\\VEN2_001#Mr. Spock, what is the condition of the fire control system?",
	"#VEN2\\VEN2_002#Mr. Spock, what is the status of the ship's computer?",
	"#VEN2\\VEN2_003#Spock, what is the situation with the impulse engines?",
	"#VEN2\\VEN2_004#We don't have much time for talk. The Elasi are known for their punctuality.",
	"#VEN2\\VEN2_005#What a mess. I wonder what we can do to fix this.",
	"#VEN2\\VEN2_006#I assume, since you haven't blasted us to bits, you want something.",
	"#VEN2\\VEN2_007#I don't know, Bones.",
	"#VEN2\\VEN2_008#I see your point.",
	"#VEN2\\VEN2_009#I'm not one to overlook strategic implications, Mr. Spock, but we can save that for another time.",
	"#VEN2\\VEN2_010#It was a setup?!",
	"#VEN2\\VEN2_011#It will take time. The controls are smashed, and the main computer's badly damaged. It will take hours to get power to the computer banks.",
	"#VEN2\\VEN2_012#Just try and get it. You can't threaten me!",
	"#VEN2\\VEN2_013#No, Ensign. It looks like the Elasi have been doing some business with them. Scotty, beam us back. We need to find that ship that attacked the Republic.",
	"#VEN2\\VEN2_014#Not too soon, I hope.",
	"#VEN2\\VEN2_015#Not yet. We're having trouble accessing all the data files.",
	"#VEN2\\VEN2_016#Put it on Screen, Spock.",
	"#VEN2\\VEN2_017#Spock, just tell me if they will help.",
	"#VEN2\\VEN2_018#Spock, what about the Fusion Power Pack? Could we use it to power the transporter?",
	"#VEN2\\VEN2_019#That ship was cloaked!",
	"#VEN2\\VEN2_020#The Masada, I presume. You want the locations of all your imprisoned comrades?",
	"#VEN2\\VEN2_021#The Republic will fall apart if you fire on us. Then you'll never get the data.",
	"#VEN2\\VEN2_022#Thirty minutes, then. Kirk out.",
	"#VEN2\\VEN2_023#Umm, well...",
	"#VEN2\\VEN2_024#We don't have several days, Mr. Spock.",
	"#VEN2\\VEN2_025#We'll comply. Kirk out.",
	"#VEN2\\VEN2_026#We're fine, lieutenant.",
	"#VEN2\\VEN2_027#What do you want?",
	"#VEN2\\VEN2_028#Yes, Uhura, Just wanted a status report. Kirk out.",
	"#VEN2\\VEN2_029#Yes, we have. You'll have to beam over and get it, though. The computer's subspace transmitter is out.",
	"#VEN2\\VEN2_030#Both Tricorders are rigged into the main computer's central processing unit. We now have enough computational power to control a single ship's system.",
	"#VEN2\\VEN2_031#Captain, I recommend we wait until we have restored power before I hook up the tricorders to the main computer. We may need them in engineering first.",
	"#VEN2\\VEN2_032#Captain, I suggest we try to raise the shields.",
	"#VEN2\\VEN2_033#Captain, I suggest we try to raise the shields.",
	"#VEN2\\VEN2_034#Captain, the elasi can surely detect the lowering of our shields. They will undoubtedly try to board us if we lower them.",
	"#VEN2\\VEN2_035#Captain, the elasi can surely detect the lowering of our shields. They will undoubtedly try to board us if we lower them.",
	"#VEN2\\VEN2_036#Captain, the torpedo loading system is malfunctioning. To clear it, we will have to physically examine the mechanism. Currently, all turbolift access to the torpedo bay is blocked by a hull breach. Fortunately, it is highly unlikely that we will need this ship's weapons systems.",
	"#VEN2\\VEN2_037#Captain, the torpedo loading system is malfunctioning. To clear it, we will have to physically examine the mechanism. Currently, all turbolift access to the torpedo bay is blocked by a hull breach. It is imperative that we get the weapons on-line.",
	"#VEN2\\VEN2_038#I'm a doctor, not a computer scientist!",
	"#VEN2\\VEN2_039#I'm glad this isn't the Enterprise.",
	"#VEN2\\VEN2_040#Jim, since we do not have what they want, I don't think it is a good idea to contact them until we are able to defend ourselves.",
	"#VEN2\\VEN2_041#Cloaked Elasi. I wonder who the old friend they mentioned is?",
	"#VEN2\\VEN2_042#Is that all you can say?",
	"#VEN2\\VEN2_043#Jim, do we really need a lesson in starship engineering?",
	"#VEN2\\VEN2_044#Shut up, Spock!",
	"#VEN2\\VEN2_045#That's just great, Spock. We don't exactly carry an M-5 computer in our inventory.",
	"#VEN2\\VEN2_046#I have memorized all pertinent data, Captain. there is no need to reexamine the journals.",
	"#VEN2\\VEN2_047#It would not be prudent to remove the tricorder at this time, Captain. Doing so will cause the shields to shut down and allow the elasi to beam a boarding party over.",
	"#VEN2\\VEN2_048#Lowering shields and allocating power to photon torpedo systems. Torpedo is loaded and ready.",
	"#VEN2\\VEN2_050#Photon torpedoes are loaded and ready to be fired.", // TYPO
	"#VEN2\\VEN2_051#Power is available, but the main computer is too badly damaged to actively control the power circuits.",
	"#VEN2\\VEN2_052#Sensors indicate that the Elasi Ship has lowered its shields. I suggest we prepare your surprise soon, Captain. They will beam over any moment.",
	"#VEN2\\VEN2_053#That would be unwise, Captain. I thought our plan was to surprise the Elasi.",
	"#VEN2\\VEN2_054#The elasi ship's shield are still raised, captain. A single photon hit will have a negligible effect on the ship.",
	"#VEN2\\VEN2_055#The impulse engines are back on-line, but we have no way of directing power to the weapons system.",
	"#VEN2\\VEN2_056#The impulse power allocation controls are functional, but there is no power available, Captain.",
	"#VEN2\\VEN2_057#The main computer is too badly damaged to actively control the power circuits.",
	"#VEN2\\VEN2_058#The torpedo warning systems are showing a malfunction in the torpedo loading bay.",
	"#VEN2\\VEN2_059#The tricorders are currently operating at 12.69 percent less than normal computing efficiency.",
	"#VEN2\\VEN2_060#The unit doesn't generate enough power to run any of the major systems. Main or Auxiliary power is required for that, Captain.",
	"#VEN2\\VEN2_061#There are no more log decks, Captain.",
	"#VEN2\\VEN2_062#There currently is no power being allocated to the weapons system. Even if there were a power source, the damage to the main computer is enough to prevent power allocation to that system.",
	"#VEN2\\VEN2_063#There is currently no power to be allocated from the engines.",
	"#VEN2\\VEN2_064#There is no power allocated to the weapons system, Captain.",
	"#VEN2\\VEN2_065#There is no power allocated to the weapons system.",
	"#VEN2\\VEN2_066#They are jamming all frequencies, Captain. We will not be able to contact the Enterprise.",
	"#VEN2\\VEN2_067#This input/output slot for the record decks is still functional, Captain.",
	"#VEN2\\VEN2_068#Weapons control is functioning properly, however, there appears to be a jam in the primary loading mechanism.",
	"#VEN2\\VEN2_069#With impulse power online and the tricorders performing computer control, I can divert power to...",
	"#VEN2\\VEN2_070#Captain, I have examined the Engineering Journals. According to chapter eighteen, we can run...",
	"#VEN2\\VEN2_071#Captain, I suggest we try to raise the shields.",
	"#VEN2\\VEN2_072#Captain, the main computer is far beyond...",
	"#VEN2\\VEN2_073#Captain, we are being hailed by the Elasi Captain.",
	"#VEN2\\VEN2_074#Correct, Doctor. However, there may be another alternative. Linked tricorders, along with the circuits in the data reader, should have the processing power necessary to control a single starship system.",
	"#VEN2\\VEN2_075#Fascinating. A cloaked Elasi.",
	"#VEN2\\VEN2_076#Fascinating.",
	"#VEN2\\VEN2_077#I believe so, Captain. It would require a connection to the transporter circuits in the main control console.",
	"#VEN2\\VEN2_078#That is beyond the Elasi's capabilities, Ensign.",
	"#VEN2\\VEN2_079#There is extensive damage to the main processing unit of the ship's computer. It will take several days at a starbase to repair.",
	"#VEN2\\VEN2_080#Unless we can find a suitable computational alternative, there will be no way to control the ship's systems.",
	"#VEN2\\VEN2_081#Why, yes, Captain.",
	"#VEN2\\VEN2_082#Captain's log, stardate 6087.6. The Republic is currently approaching the Vardaine system. Sensors have detected unusual energy fluctuations near one of the Vardainian moons. Starfleet has ordered us to investigate.",
	"#VEN2\\VEN2_083#Captain's log, stardate 6087.8. We are under attack by two unidentified ships. I don't know how they could have approached undetected. They must have some kind of cloaking device, although there are no reports of Romulans in this sector.",
	"#VEN2\\VEN2_084#Captain's log, stardate 6088.1. We have successfully driven off our assailants. Major damage has been sustained by our warp engines. Communications has reported that U.S.S. Enterprise is in sector. I requested Mr. Scott's assistance in repairing damage to the Republic. With luck, we will be fully operational in a couple of days.",
	"#VEN2\\VEN2_085#Captain, the Elasi will surely fire upon us if we raise our shields.",
	"#VEN2\\VEN2_086#If there's anything I can do, sir, just ask.",
	"#VEN2\\VEN2_087#Power allocated to transporter systems, sir.",
	"#VEN2\\VEN2_088#Power allocated to weapons systems, Captain.",
	"#VEN2\\VEN2_089#Power has already been allocated to the shields, sir.",
	"#VEN2\\VEN2_090#Power has already been allocated to the transporter systems, Captain.",
	"#VEN2\\VEN2_091#Power has already been allocated to the weapons, Sir.",
	"#VEN2\\VEN2_092#Shields are up, sir.",
	"#VEN2\\VEN2_093#Captain, Look! An Elasi ship!",
	"#VEN2\\VEN2_094#Captain, do you suppose the Elasi might have used cloaking technology to project a false image, of a ship the Republic would trust?",
	"#VEN2\\VEN2_096#Thank goodness for parallel processing. I don't know what computers could do without it.",
	"#VEN2\\VEN2_097#Captain's log, stardate 6088.5. First Officer Andrade commanding. The Enterprise has unexplicably opened fire upon us. Captain Patterson has been mortally wounded. We have sustained major damage to all systems. Impulse power is out. We cannot understand why...",
	"#VEN2\\VEN2_098#What are you stalling for? Lower your shields.",
	"#VEN2\\VEN2_099#Can't threaten you?! As you said, I can blow you to bits!",
	"#VEN2\\VEN2_100#You better step on it, Kirk! You only have a few minutes left!",
	"#VEN2\\VEN2_101#Activate cloaking device! Kirk, until we meet again.",
	"#VEN2\\VEN2_102#All right, Kirk. We'll do it your way. I would rather not kill you. Besides, there's an old friend that wants to meet you. I give you thirty minutes. And remember, no tricks.",
	"#VEN2\\VEN2_103#I can see why they made you Captain!",
	"#VEN2\\VEN2_104#Kirk! I should have known you'd try something underhanded like this. Weaponsmaster, fire all weapons on the Republic!",
	"#VEN2\\VEN2_105#Maybe I should just pump a few torpedoes into your shields and check it out for myself.",
	"#VEN2\\VEN2_106#Watch yourself, Captain. It may be sooner than you realize.",
	"#VEN2\\VEN2_107#We finally meet in person, Captain Kirk. So where is the data I requested?",
	"#VEN2\\VEN2_108#Well, Captain Kirk, I trust you and your valiant crew have retrieved the data I requested?",
	"#VEN2\\VEN2_109#Well, if it isn't Captain Kirk. Fancy meeting you out here all alone in such a shabby starship.",
	"#VEN2\\VEN2_110#What? You mean you were deliberately wasting my time? Guards, take them back to the ship! I'll think of a suitable punishment for them later.",
	"#VEN2\\VEN2_111#Why, yes I do. It seems you failed to give one of my associates some rather important information.",
	"#VEN2\\VEN2_112#Yes, Kirk. The Republic's computers will have the data just as your Enterprise would. I give you one minute to comply.",
	"#VEN2\\VEN2_113#You should be more civil considering your Enterprise is far away on a mercy mission helping that poor trader.",
	"#VEN2\\VEN2_114#How convenient, Kirk. We'll beam over, but no tricks. My sensors read that only your shields have power. Lower them now!",
	"#VEN2\\VEN2_115#Sir, we picked up another ship nearby and we came as fast as we could. It appeared to cloak. Were you attacked by Romulans?",
	"#VEN2\\VEN2_ELA#Contact Elasi Ship.",
	"#VEN2\\VEN2_ENT#Contact Enterprise.",
	"#VEN2\\VEN2_F28#Captain, the Enterprise is coming on high speed approach!",
	"#VEN2\\VEN2_F29#We can't, Captain. All weapons systems off-line!",
	"#VEN2\\VEN2_F35#This is the photon torpedo launching control.",
	"#VEN2\\VEN2_S09#Aye, Captain.",
	"#VEN2\\VEN2_SHI#Shields",
	"#VEN2\\VEN2_TRA#Transporter Circuits",
	"#VEN2\\VEN2_WEA#Weapons",
	"#VEN2\\VEN2N000#A red flashing light is currently indicating a jam in the torpedo loading mechanism.",
	"#VEN2\\VEN2N001#All indicators are dead.",
	"#VEN2\\VEN2N002#An Elasi frigate is visible on the viewscreen. Though silent now, you know it is ready to attack at a moment's notice.",
	"#VEN2\\VEN2N003#Damage from the battle has disabled the ship's main computer.",
	"#VEN2\\VEN2N004#Ensign Kije doesn't see the need for a security escort.",
	"#VEN2\\VEN2N005#Indicators currently show all power diverted to the shields.",
	"#VEN2\\VEN2N006#Indicators currently show all power diverted to transporter systems.",
	"#VEN2\\VEN2N007#Indicators currently show all power diverted to weapons control.",
	"#VEN2\\VEN2N008#Indicators currently show no power output from the impulse engines.",
	"#VEN2\\VEN2N009#Indicators show impulse power online, but no power allocated to any systems.",
	"#VEN2\\VEN2N010#Kirk is dismayed by the damage that was done to Auxiliary Control.",
	"#VEN2\\VEN2N011#McCoy is fidgeting around.",
	"#VEN2\\VEN2N012#McCoy wishes that Mr. Scott were here.",
	"#VEN2\\VEN2N013#Medical Tricorder taken.",
	"#VEN2\\VEN2N015#Science Tricorder taken.",
	"#VEN2\\VEN2N016#Spock crudely attaches the medical tricorder to the computer console.",
	"#VEN2\\VEN2N017#Spock crudely attaches the science tricorder to the computer console.",
	"#VEN2\\VEN2N018#Spock is analyzing the surroundings.",
	"#VEN2\\VEN2N019#Spock wishes that Mr. Scott were here.",
	"#VEN2\\VEN2N020#Status indicator show that the torpedo tubes are currently empty.",
	"#VEN2\\VEN2N021#Status indicators show that photon torpedo number one and is loaded and ready to be fired.",
	"#VEN2\\VEN2N022#The auxiliary control room viewscreen is still operating. It is displaying a view of empty space.",
	"#VEN2\\VEN2N023#The medical tricorder is crudely wired into the computer console.",
	"#VEN2\\VEN2N024#The medical tricorder is currently wired into the computer console.",
	"#VEN2\\VEN2N025#The science and medical tricorders are jury-rigged to the remains of the Republic computer system.",
	"#VEN2\\VEN2N027#The science tricorder is currently wired into the computer console.",
	"#VEN2\\VEN2N028#There is no response.",
	"#VEN2\\VEN2N029#These are Federation standard record decks.",
	"#VEN2\\VEN2N030#These are the auxiliary helm and navigation controls for the Republic. Though they are intact, the ship is in no condition to move under her own power.",
	"#VEN2\\VEN2N031#This is a standard input/output slot for record decks.",
	"#VEN2\\VEN2N032#This is the auxiliary ship damage display. Red flashing damage indicators dominate its surface.",
	"#VEN2\\VEN2N033#This is the fire control for the photon torpedoes. ",
	"#VEN2\\VEN2N034#This is the impulse power allocation control.",
	"#VEN2\\VEN2N035#This is the Republic's Auxiliary Control Room. It appears to be in better shape than the main bridge.",
	"#VEN2\\VEN2N038#You are in a typical starship corridor.",
	"#VEN2\\VEN2N039#You take the record decks.",
	"#VEN2\\VEN2U093#Enterprise here. We're still tracking the distress call. Are you all right, Sir?",
	"#VEN2\\VEN2U094#Enterprise to Captain Kirk. Are you safe, sir?",
	"Hail Elasi",
	"Hail Enterprise",
	"cancel",


	"#VEN3\\VEN3_001#I wish I were a poet. I wish I had the words to match how this makes me feel. These people were Starfleet officers, giving their lives to explore the cosmos. I wish I knew some eulogy that did them justice.",
	"#VEN3\\VEN3_002#Captain, using the stun setting is most illogical.",
	"#VEN3\\VEN3_003#Damn this tricorder. Why couldn't one of them be alive?",
	"#VEN3\\VEN3_004#I'm a doctor, not a coal miner.",
	"#VEN3\\VEN3_005#A poor choice of words, Ensign.",
	"#VEN3\\VEN3_006#I thought you were a science officer, not a tour guide.",
	"#VEN3\\VEN3_007#The beam is supporting the ceiling, Captain.",
	"#VEN3\\VEN3_008#The debris appears quite unstable. Any disturbances may trigger an avalanche of debris to fall.",
	"#VEN3\\VEN3_009#The debris is highly unstable, Captain. I recommend we try to find a support of some kind to secure the ceiling.",
	"#VEN3\\VEN3_010#The molecular saw is too fine of a cutting tool to be of any use in clearing the debris.",
	"#VEN3\\VEN3_011#There is too much debris to remove by hand.",
	"#VEN3\\VEN3_012#Turbolift ahead, Captain.",
	"#VEN3\\VEN3_013#Captain, it is critical that we gain access to this turbolift. It is our only means of exploring the rest of this ship.",
	"#VEN3\\VEN3_014#Captain, the support beam for the ceiling is damaged here. There will be no way to safely clear out the debris without a replacement.",
	"#VEN3\\VEN3_015#The ceiling appears stable. We should now be able to use Turbolift 2, Captain.",
	"#VEN3\\VEN3_016#It will take us forever to dig through all that, sir.",
	"#VEN3\\VEN3_017#Sir, I really don't think we should try and mess with that debris. We may bring the whole thing down on us.",
	"#VEN3\\VEN3_018#Be careful, Captain. This ship is a death trap.",
	"#VEN3\\VEN3N000#Kije struggles with emotions he never knew he had.",
	"#VEN3\\VEN3N001#Kirk is increasingly distressed by what he has seen.",
	"#VEN3\\VEN3N002#McCoy examines his tricorder, knowing that his hopes are not going to be fulfilled.",
	"#VEN3\\VEN3N003#One of the many battered corridors of the U.S.S. Republic. It has seen better days. Much better days.",
	"#VEN3\\VEN3N004#Spock says nothing, but this tragedy stirs something in his Vulcan soul.",
	"#VEN3\\VEN3N005#The crewman's death was pointless. Just like too many deaths in human history.",
	"#VEN3\\VEN3N006#The debris is blocking the Turbolift doors.",
	"#VEN3\\VEN3N007#The support beam appears to have stabilized the ceiling.",
	"#VEN3\\VEN3N009#There is a twisted mess of wire and metal falling from the gaping hole in the ceiling. It is blocking access to turbolift 2.",
	"#VEN3\\VEN3N010#There is far too much debris to be cleared by hand.",
	"#VEN3\\VEN3N011#This door leads to Sickbay.",
	"#VEN3\\VEN3N012#This door leads to TurboLift 2.",
	"#VEN3\\VEN3N013#This is a length of heavy duty insulated power cable.",
	"#VEN3\\VEN3N014#You have taken the cable.",


	"#VEN4\\VEN4_001#Do what you can, Bones. I need to find out what happened here.",
	"#VEN4\\VEN4_002#You always hope the instruments are wrong...that you'll find someone alive.",
	"#VEN4\\VEN4_003#It wasn't the Enterprise, Marata!",
	"#VEN4\\VEN4_004#Marata, what happened?",
	"#VEN4\\VEN4_005#I can't believe it. That's Brittany Marata. I knew her from my Academy days. We studied alien history together.",
	"#VEN4\\VEN4_006#What about the Enterprise?",
	"#VEN4\\VEN4_007#He's dead, Jim. I can't bring him back.",
	"#VEN4\\VEN4_008#That will accomplish nothing, Jim.",
	"#VEN4\\VEN4_009#She's in bad shape, Jim. I've tried to stabilize her, but it doesn't look good.",
	"#VEN4\\VEN4_010#She's in no condition to talk right now.",
	"#VEN4\\VEN4_011#She's suffering from severe trauma and internal bleeding. I'll see what I can do.",
	"#VEN4\\VEN4_012#That won't bring her back. She's gone.",
	"#VEN4\\VEN4_013#There's nothing more I can do for her, Jim.",
	"#VEN4\\VEN4_014#At least she's still alive, although just barely.",
	"#VEN4\\VEN4_015#Life support must have gone down during the fight. Most of the people died from shock before the back-up systems came on line.",
	"#VEN4\\VEN4_016#There's nothing more I can do.", // TYPO (in some rooms, this has "Jim..." at the start of the text, though not in VENG4 itself)
	"#VEN4\\VEN4_017#I believe nothing needs to be said, Captain.",
	"#VEN4\\VEN4_018#An interesting hypothesis, doctor. Had Mr. Scott been present, he might have been able to verify it.",
	"#VEN4\\VEN4_019#No... you won't get us...",
	"#VEN4\\VEN4_020#They said it was the Enterprise...They had visual confirmation...",
	"#VEN4\\VEN4_021#You killed us, Jim. We were friends for... I trusted ...",
	"#VEN4\\VEN4_022#Captain, did I ever mention how much I hate hospitals?",
	"#VEN4\\VEN4N000#A very concerned Doctor Leonard McCoy.",
	"#VEN4\\VEN4N001#A very unhappy looking Ensign Kije.",
	"#VEN4\\VEN4N002#James T. Kirk, in total confusion at the moment.",
	"#VEN4\\VEN4N003#Mr. Spock, looking pensive as usual.",
	"#VEN4\\VEN4N004#Seeing Brittany in this condition stirs you on to find the culprits responsible for this injustice.",
	"#VEN4\\VEN4N005#The medical scanner has registered the death of Brittany Marata.",
	"#VEN4\\VEN4N006#The medical scanner is monitoring the woman's condition.",
	"#VEN4\\VEN4N007#The woman in this sickbed is alive, barely.",
	"#VEN4\\VEN4N008#This door leads back to the corridor and turbolifts.",
	"#VEN4\\VEN4N009#This door leads back to the corridor, and turbolifts 1 and 2.",
	"#VEN4\\VEN4N010#This is an empty hypodermic injector.",
	"#VEN4\\VEN4N011#This is the Republic's sickbay. Fortunately, power is still functioning here.",
	"#VEN4\\VEN4N012#This medical drill fires a microscopic phaser beam.",
	"#VEN4\\VEN4N013#This monitor has recorded the death of a patient.",
	"#VEN4\\VEN4N014#Yet another crewman of the Republic whose life was unfairly abbreviated.",
	"#VEN4\\VEN4N015#You pick up the empty hypodermic injector.",
	"#VEN4\\VEN4N016#You retrieve the medical drill.",
	"#VEN4\\VEN4N017#You see the dead body of Brittany. Her life was cut short and you won't stop until you find the persons responsible.",


	"#VEN5\\VEN5_001#We must complete our mission, gentlemen.",
	"#VEN5\\VEN5_002#Is the fire in danger of spreading, spock?",
	"#VEN5\\VEN5_003#Thank you, Spock, I think we get the point.",
	"#VEN5\\VEN5_004#A standard portable fusion power pack. It is fully functional, Captain.",
	"#VEN5\\VEN5_005#Captain, I'm picking up a functioning energy source in the immediate vicinity.",
	"#VEN5\\VEN5_006#I can't say that I'm very talkative right now.",
	"#VEN5\\VEN5_007#Jim, are you mad? Put that phaser away. You almost killed us once already.",
	"#VEN5\\VEN5_008#No lifeforms present, Jim. I'm picking up some kind of energy reading, though.",
	"#VEN5\\VEN5_009#One of those fusion power packs, Jim. What do you want me to do with it?",
	"#VEN5\\VEN5_010#A few centimeters lower with that phaser and half this section would be history, not to mention us...",
	"#VEN5\\VEN5_011#Oh, my God, Jim! Is that what I think it is?",
	"#VEN5\\VEN5_012#I am picking up a high energy power source somewhere under the debris. I recommend caution, Captain.",
	"#VEN5\\VEN5_013#The stun setting would be ineffective, Captain.",
	"#VEN5\\VEN5_015#Captain, it is unadvisable to approach too closely. There is an open fire nearby.",
	"#VEN5\\VEN5_016#No, Captain. There is an inadequate supply of flammable material. It will eventually burn itself out.",
	"#VEN5\\VEN5_017#This corridor seems to have been particularly damaged. There have been hull breaches on the deck below.",
	"#VEN5\\VEN5_018#Yes, Doctor. It is a portable fusion power pack.",
	"#VEN5\\VEN5_019#Actually, Doctor, three point two centimeters. And based on our proximity to the explosion, and the angle of the beam...",
	"#VEN5\\VEN5_R19#Is there a question, Captain?",
	"#VEN5\\VEN5_R20#I will monitor the situation, Mr. Spock. I can use the distraction.",
	"#VEN5\\VEN5N000#A look of terror is still etched on the face of this crewman.",
	"#VEN5\\VEN5N001#A rather large pile of debris.",
	"#VEN5\\VEN5N002#A resolute Mr. Spock.",
	"#VEN5\\VEN5N003#A sad but determined James T. Kirk.",
	"#VEN5\\VEN5N004#Dr. McCoy avoids the glances of his crewmates.",
	"#VEN5\\VEN5N005#Ensign Kije, learning that Starfleet isn't always very pleasant.",
	"#VEN5\\VEN5N006#This corridor leads to the Republic's Engineering section.",
	"#VEN5\\VEN5N007#This door leads to main engineering.",
	"#VEN5\\VEN5N008#These ladders are used when turbolifts are unavailable. Unfortunately, it is blocked by debris and a small, smoldering fire.",
	"#VEN5\\VEN5N009#This is the most powerful portable energy storage device ever developed by man. It is used to provide temporary power to small systems when Main or Auxiliary power is unavailable.",
	"#VEN5\\VEN5N010#You pick up the portable Fusion power pack.",


	"#VEN6\\VEN6_001#Can we re-route the power lines?",
	"#VEN6\\VEN6_002#Go ahead and adjust the settings, Spock.",
	"#VEN6\\VEN6_003#Spock?",
	"#VEN6\\VEN6_005#This reminds me of a poem I read when I was a child. \"I am Ozymandius, King of Kings, look upon my works, ye mighty, and despair.\"", // TYPO
	"#VEN6\\VEN6_006#Captain, the energy output of the Fusion Power pack is insufficient to power any of the major ship's systems.",
	"#VEN6\\VEN6_007#Captain, this is the fusion mixture regulator for the impulse engines. There is currently no power running to it.",
	"#VEN6\\VEN6_008#Remind me to compliment Mr. Scott on the efficiency of his engineering section.",
	"#VEN6\\VEN6_009#You have good reason to despair, here, Jim.",
	"#VEN6\\VEN6_010#Impulse power is functioning, Captain.",
	"#VEN6\\VEN6_011#It is illogical to use this machine before we have something connected to it.",
	"#VEN6\\VEN6_012#The impedance is correctly set, Captain. Changing the setting could be dangerous.",
	"#VEN6\\VEN6_013#The regulator is fully operating from the power tap run from the impulse engines. We can allocate power to ship's systems in Auxiliary Control.",
	"#VEN6\\VEN6_014#There has been a .0003 degradation in hull integrity in the last hour. There should be no danger, Captain.",
	"#VEN6\\VEN6_015#This is an engineering circuit junction box. It is used for temporary re-routing of power. Without using one of these devices set to the proper impedance, an overload can occur.",
	"#VEN6\\VEN6_016#Captain, the information obtained from the engineering journals indicates the correct impedance setting to be nineteen thousand ohms.",
	"#VEN6\\VEN6_017#Captain, the wrong setting on this particular device may cause the fusion reactors to melt down. We will have to do some research to determine the correct setting.",
	"#VEN6\\VEN6_018#Given that Mr. Scott has received a Starfleet Citation on five occasions for efficiency, I do not see the logic in your suggestion, Doctor.",
	"#VEN6\\VEN6_019#Power has now been restored, Captain.",
	"#VEN6\\VEN6_020#The impulse engines are intact, Captain. We could use the fusion reactors from the impulse engines to restore power, but the lines have been severed to the power regulator.",
	"#VEN6\\VEN6_021#These journals may prove useful in our attempt to reestablish power. A functioning computer terminal will allow us to examine them.",
	"#VEN6\\VEN6_022#We should be able to, Captain, if we can find a suitable supply of power cable. We will need to route the power through a junction box so we can set an impedance level. A direct connection to the regulator would cause an overload.",
	"#VEN6\\VEN6_023#Tragic, Captain. This is one of the greatest disasters in Starfleet history.",
	"#VEN6\\VEN6N000#Kije fidgets nervously.",
	"#VEN6\\VEN6N001#Kirk wonders if the landing party has overlooked anything.",
	"#VEN6\\VEN6N002#McCoy wonders when it will be his turn to die in the line of duty.",
	"#VEN6\\VEN6N003#Spock glances at his tricorder, making certain the superstructure of the Republic is stable.",
	"#VEN6\\VEN6N005#The closet opens revealing a library of engineering technical journals.",
	"#VEN6\\VEN6N006#The hypo is already filled with oil.",
	"#VEN6\\VEN6N007#The hypo is now filled with multipurpose oil.",
	"#VEN6\\VEN6N008#The oil canister is bolted to the hull and can't be taken.",
	"#VEN6\\VEN6N009#These are the controls to the Republic's impulse engines.",
	"#VEN6\\VEN6N010#These are the impulse engines for the Republic.",
	"#VEN6\\VEN6N011#This is a canister of high grade multipurpose oil. Very useful for lubricating machinery.",
	"#VEN6\\VEN6N012#This is a junction box used for temporary re-routing of engineering circuits.",
	"#VEN6\\VEN6N013#This is a length of heavy duty insulated power cable.",
	"#VEN6\\VEN6N015#This is a standard storage closet.",
	"#VEN6\\VEN6N016#This is the emergency power input port for the fusion mixture regulator.",
	"#VEN6\\VEN6N017#This is the fusion mixture regulator for the Republic's impulse engines.",
	"#VEN6\\VEN6N018#This port is used to connect emergency power from the impulse engines to other systems if dedicated lines are damaged.",
	"#VEN6\\VEN6N019#This was the engineering section of the U.S.S. Republic.",
	"#VEN6\\VEN6N020#You connect a length of cable between the impulse engine and the junction box.",
	"#VEN6\\VEN6N022#You connect a length of cable between the regulator circuits and the junction box.",
	"#VEN6\\VEN6N024#You take the engineering technical journals.",
	"#VEN6\\VEN6N025#This is a library of engineering technical journals.",


	"#VEN7\\VEN7_001#I haven't seen anything this bad since I was aboard the Farragut, and this vampire cloud...",
	"#VEN7\\VEN7_003#Captain, please be careful. The floor in that area is very unstable and might collapse from our added weight.",
	"#VEN7\\VEN7_005#I do not see the need for conversation, Captain. Humans have an irrational enjoyment of endless discourse.",
	"#VEN7\\VEN7_006#It appears to be a section from a coolant exhaust port. I would not recommend too close of an inspection, Captain. The floor could collapse from our added weight.",
	"#VEN7\\VEN7_007#It does get better than this, doesn't it Captain?",
	"#VEN7\\VEN7N000#A corpse is half-buried under the debris.",
	"#VEN7\\VEN7N001#A large piece of equipment has fallen through the ceiling. The area looks extremely unstable. fortunately, the entry to the transporter room is near.",
	"#VEN7\\VEN7N002#Ensign Kije.",
	"#VEN7\\VEN7N003#James T. Kirk.",
	"#VEN7\\VEN7N004#Leonard McCoy.",
	"#VEN7\\VEN7N005#Mister Spock.",
	"#VEN7\\VEN7N006#This corridor leads to the transporter room.",
	"#VEN7\\VEN7N007#This door leads to the transporter room.",
	"#VEN7\\VEN7N008#This is a length of heavy duty insulated power cable.",
	"#VEN7\\VEN7N009#You pick up a length of cable.",


	"#VEN8\\VEN8_001#Let's get back to auxiliary control and give them our... information.",
	"#VEN8\\VEN8_002#Now, let's give the Elasi something to remember us by.",
	"#VEN8\\VEN8_003#Spock, please check out the transporter.",
	"#VEN8\\VEN8_004#Spock, please check out the transporter.",
	"#VEN8\\VEN8_005#This is it. We know what we have to do.",
	"#VEN8\\VEN8_006#This room's in pretty good condition compared to the rest of the ship.",
	"#VEN8\\VEN8_007#Beam him back, Spock.",
	"#VEN8\\VEN8_008#Do it, Ensign.  We'll just have to gamble that the system doesn't jam again.",
	"#VEN8\\VEN8_009#Do it, Spock.",
	"#VEN8\\VEN8_010#Ensign Kije, I want you to beam into the torpedo bay and unjam the loading mechanism. If you don't succeed, we'll all be on permanent shoreleave in an Elasi jail.",
	"#VEN8\\VEN8_011#Spock, would it be possible to connect the fusion power pack directly into the transporter power circuits?",
	"#VEN8\\VEN8_012#What's causing the malfunction in the loading mechanism?",
	"#VEN8\\VEN8_013#Captain, there are no coordinates set for the transporter.",
	"#VEN8\\VEN8_014#Captain, there is no power allocated to the transporter.",
	"#VEN8\\VEN8_015#Captain, there is no power allocated to the transporter.",
	"#VEN8\\VEN8_016#Don't look at me, Jim. You know how much I hate that thing.",
	"#VEN8\\VEN8_018#Oh, great, my favorite place in the ship. Wouldn't you know it would be in the best shape.",
	"#VEN8\\VEN8_020#Shall we give the Elasi our transmission, Jim?",
	"#VEN8\\VEN8_021#We don't have much time!",
	"#VEN8\\VEN8_023#No, you did \"well\", ensign.",
	"#VEN8\\VEN8_024#I recommend I stay behind, Captain. If there is a problem with the transporter, I am the most qualified to repair it.",
	"#VEN8\\VEN8_025#Surprisingly, the transporter controls have escaped damage.",
	"#VEN8\\VEN8_026#The impulse engines are not generating any power for this system.",
	"#VEN8\\VEN8_027#The impulse engines are not generating any power for this system.",
	"#VEN8\\VEN8_028#The transporter pads seem intact, Captain.",
	"#VEN8\\VEN8_029#This is the only access to the torpedo bay, Captain.",
	"#VEN8\\VEN8_030#This unit is fully functional. But I do not see the logic in using it at this time, Captain. The Enterprise is out of range for transport.",
	"#VEN8\\VEN8_031#Transporter systems are operational, Captain. Coordinates have been set to the Photon Torpedo Loading bay.",
	"#VEN8\\VEN8_032#A very efficient job, Captain.",
	"#VEN8\\VEN8_033#Fascinating. It can be done. However, the transporter will only be able to transport a single person.",
	"#VEN8\\VEN8_034#I did good, didn't I sir?",
	"#VEN8\\VEN8_035#I'll do my best, Sir.",
	"#VEN8\\VEN8_036#I'm a security officer, not a grammarian.",
	"#VEN8\\VEN8_037#I've reached the torpedo loading bay, Captain. It's not too badly damaged, fortunately.", // TYPO
	"#VEN8\\VEN8_038#The door's open, Captain. I'm ready to transport back.",
	"#VEN8\\VEN8_039#The inner loading door is stuck in the closed position. I can force it open, but when the loading cycle is begun, the room will lose pressure.  We won't be able to beam back here again.",
	"#VEN8\\VEN8_040#I have a bad feeling about this place.",
	"#VEN8\\VEN8_041#Ready for your orders, sir.",
	"#VEN8\\VEN8_042#There is no need to go back to the torpedo bay, Captain. I can assure you that it is unjammed.",
	"#VEN8\\VEN8N000#Kije is eager to perform his duties.",
	"#VEN8\\VEN8N001#Kirk is extremely worried.",
	"#VEN8\\VEN8N003#The former transporter chief of the U.S.S. Republic.",
	"#VEN8\\VEN8N004#The Fusion power pack is rigged into the transporter power circuits.",
	"#VEN8\\VEN8N005#The transporter room appears to have escaped serious damage.",
	"#VEN8\\VEN8N006#These are the power conduits for the transporter system.",
	"#VEN8\\VEN8N007#These controls set the coordinates for the transporter.",
	"#VEN8\\VEN8N008#These sliders activate the transporter systems.",
	"#VEN8\\VEN8N009#This door leads back to the corridor and turbolift 2.",
	"#VEN8\\VEN8N010#This is the transporter chamber. The pads do not seem to be damaged.",


	"#VENA\\VENA_F32#The landing party has been taken captive by the Elasi, and you know Starfleet does not negotiate with terrorists. As you look forward to a long captivity you wonder who will take command of the Enterprise. Better luck next time.",
	"#VENA\\VENA_F34#Captain, it would be unwise to use your phaser considering the already extensive damage sustained by the Republic.",
	"#VENA\\VENA_F40#The Elasi fire photon torpedoes. The Republic has been destroyed.",
	"#VENA\\VENA_F41#Kirk out.",


	"#sfx\\spokcoff#cough... cough...",
	"#SFX\\STATICU1#Ent... neu ... trans...",
};

} // End of namespace StarTrek
