/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.sikuli.guide.AnnotationRectangle;
import org.sikuli.guide.AnnotationToolTip;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.SikuliAction;
import org.sikuli.script.SikuliActionListener;
import org.sikuli.script.SikuliActionManager;

public class SikuliActionScreenshotLogger
implements SikuliActionListener {
    int _counter = 0;
    String _outputPath = ".";
    Dimension neighborhoodSize = null;

    public String getOutputPath() {
        return this._outputPath;
    }

    public void setOutputPath(String string) {
        this._outputPath = string;
    }

    public SikuliActionScreenshotLogger() {
        SikuliActionManager.getInstance().addListener((SikuliActionListener)this);
    }

    void drawTarget(Graphics graphics, Location location) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
        int n = location.x;
        int n2 = location.y;
        graphics2D.setColor(Color.red);
        Color[] colorArray = new Color[]{Color.red, Color.white, Color.red};
        int[] nArray = new int[]{5, 3, 1};
        for (int i = 0; i < 3; ++i) {
            int n3 = nArray[i];
            Color color = colorArray[i];
            graphics2D.setColor(color);
            graphics2D.fillOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
        }
    }

    void drawAction(Graphics graphics, String string, Match match) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AnnotationRectangle annotationRectangle = new AnnotationRectangle(match.getRect());
        annotationRectangle.paintAnnotation(graphics2D);
        Location location = match.getBottomLeft();
        AnnotationToolTip annotationToolTip = new AnnotationToolTip(string, (Point)location);
        annotationToolTip.paintAnnotation(graphics2D);
        this.drawTarget(graphics2D, match.getTarget());
    }

    public void targetClicked(SikuliAction sikuliAction) {
        BufferedImage bufferedImage = sikuliAction.getScreenImage().getImage();
        Match match = sikuliAction.getMatch();
        this.drawAction(bufferedImage.getGraphics(), "click", match);
        this.saveActionImage(bufferedImage);
    }

    public void targetDoubleClicked(SikuliAction sikuliAction) {
        BufferedImage bufferedImage = sikuliAction.getScreenImage().getImage();
        Match match = sikuliAction.getMatch();
        this.drawAction(bufferedImage.getGraphics(), "double-click", match);
        this.saveActionImage(bufferedImage);
    }

    public void targetRightClicked(SikuliAction sikuliAction) {
        BufferedImage bufferedImage = sikuliAction.getScreenImage().getImage();
        Match match = sikuliAction.getMatch();
        this.drawAction(bufferedImage.getGraphics(), "right-click", match);
        this.saveActionImage(bufferedImage);
    }

    void saveActionImage(BufferedImage bufferedImage) {
        String string = "yyyyddhhmmss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        String string2 = simpleDateFormat.format(new Date());
        try {
            String string3 = this._outputPath + File.separator + this._counter + "_" + string2 + ".png";
            File file = new File(string3);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            ++this._counter;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

