9.3 マルチ・ライブループ

# マルチ・ライブループ

次のライブループを考えていきましょう。

```
live_loop :foo do
  play 50
  sleep 1
end
```

なぜ': foo’という名前をつける必要があるか疑問をもつかもしれません。この名前は、
このライブループが他のすべてのライブループと異なっていることを示すために重要です。

*同じ名前で実行中の2つのライブループが存在することはできません*。

これは、複数同時にライブループを実行したい場合、それぞれに異なる名前を付ける必要があることを意味します。

```
live_loop :foo do
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end

live_loop :bar do
  sample :bd_haus
  sleep 0.5
end
```

各ライブループを個別に変更し更新できます。そしてすべてちゃんと動作します。

## ライブループの同期

既に気づいているかもしれませんが、ライブループは、以前にみてきたスレッドのcueの
メカニズムを使用して自動的に動作します。
ライブループがループするたびに、それが新しい名前を持つライブループの`cue`eventを生成します。
従って、`cue`をきっかけに何も停止せずにサウンドのループを同期させることができます。

この同期のとれたコードを考えてみましょう。

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.4
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

それを停止することなくタイミングと同期を修正することができるかを見てみましょう。
まずは、`foo`ループ内の`sleep`の要素を0.5に変えてみましょう。

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

まだ終了することはできません。あなたは調子がまったく合っていないことに気付くでしょう。 
これはループがずれているからです。 他と同期するように、それを修理していきましょう。

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sync :foo
  sample :bd_haus
  sleep 1
end
```

うわー、すべてを停止することなくすべてが完璧に同期しました。

いまから、ライブループを使用したライブコーディングを始めましょう！