/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef SCREENLOCKUI_H
#define SCREENLOCKUI_H

#include "titlelabel.h"
#include "settinggroup.h"
#include "flowlayout.h"
#include "switchwidget.h"
#include "comboxwidget.h"
#include "pushbuttonwidget.h"
#include <QProcess>
#include "pictureunit.h"
#include <QHBoxLayout>
#include <QWidget>

class ScreenlockUi : public QWidget
{
    Q_OBJECT
public:
    ScreenlockUi();
    ~ScreenlockUi();
    void setShowOnLogin(bool b);
    void setPicture(const QString &data);
    void setPictures(const QStringList &picturePathList, const QStringList &sourcePathList);
    void createPictureUnit(const QPixmap &pixmap, const QString &filename, const bool &clicked);
    void resetClickedPic();

private:
    void initUi();
    void initScreenLock();
    void initRelateSet();
    void initSignals();
    void initLeavLockStatus();
    bool hasBluetoothAdapter();
    bool isBluetoothPowered();
    bool getLeavLockOn();
    QString getLeaveLockDev();
    QMap<QString, QString> getBtPairedDevices();

private slots:
    void addPairedDev(QString dev, bool paired);
    void powerChanged(bool powered);
    void setLeaveLock(bool on);
    void defaultAdapterChanged(QString address);
    void adapterAdded(QString address);
    void adapterRemoved(QString address);

private:
    QVBoxLayout *uiLayout         = nullptr;
    QVBoxLayout *screenlockLayout = nullptr;
    QVBoxLayout *relateLayout     = nullptr;

private:
    TitleLabel   *wallpaperTitleLabel = nullptr;
    UkccFrame    *previewFrame        = nullptr;
    QHBoxLayout  *previewLayout       = nullptr;
    QLabel       *previewLabel        = nullptr;
    SettingGroup *centerGroup         = nullptr;
    SwitchWidget *showPicWidget       = nullptr;
    SwitchWidget *btLeaveLockWidget   = nullptr;
    ComboxWidget *bluetoothWidget     = nullptr;
    PushButtonWidget *setBtWidget     = nullptr;
    UkccFrame    *noBtWidget          = nullptr;
    UkccFrame    *picBtnFrame         = nullptr;
    QVBoxLayout  *picBtnLayout        = nullptr;
    UkccFrame    *pictureFrame        = nullptr;
    FlowLayout   *pictureLayout       = nullptr;
    UkccFrame    *bottomFrame         = nullptr;
    QHBoxLayout  *bottomLayout        = nullptr;
    QPushButton  *localBtn            = nullptr;
    QPushButton  *onlineBtn           = nullptr;
    QPushButton  *resetBtn            = nullptr;

private:
    TitleLabel       *relateTitleLabel  = nullptr;
    SettingGroup     *relatedGroup      = nullptr;
    PushButtonWidget *monitorWidget     = nullptr;
    PushButtonWidget *screensaverWidget = nullptr;

private:
    PictureUnit *prePictureUnit = nullptr;
    bool        canLeaveLock    = false;
    QString     currentFile;
    QString     lockdev;

Q_SIGNALS:
    void showOnLoginChanged(const bool &b);
    void pictureChanged(const QString &picture);
    void localButtonClicked();
    void onlineButtonClicked();
    void resetButtonClicked();
    void toSetMonitor();
    void toSetScreensaver();
};


#endif // SCREENLOCKUI_H
