target=matrice,proba,stable

\precision{1000}
\computeanswer{yes}

/* Construction de la matrice de transition T*/
\real{p1=randint(1..99)/100}
\real{p2=randint(1..99)/100}
\real{q1=1-\p1}
\real{q2=1-\p2}
\matrix{T=\q1,\p1
\p2,\q2}

/* Dessin du graphe*/
\text{graphe=
xrange -8,8
yrange -3,3
circle -4,0, 16,black
circle 4,0, 16,black
text black,-4.1,0.2,,1
text black,3.9,0.2,,2
arc -5,0, 2,2, 35,335,blue
arc 5,0, 2,2, 215,515,blue
arc 0,0, 8,3.5, 15,165,blue
arc 0,0, 8,3.5, 205,345,blue
arrow -4.2,0.55,-4,0.35,10,blue
arrow 4.2,-0.55,4,-0.35,10,blue
arrow 3.8,0.45,3.9,0.35,10,blue
arrow -3.8,-0.45,-3.9,-0.35,10,blue
text navy, -0.2,2.5,,\p1
text navy, -0.2,-2,,\p2
text navy, -7.2,0.1,,\q1
text navy, 6.2,0.1,,\q2
}
\text{dessin = draw(400,150
\graphe)}

#if #TARGET(matrice)
\title{Matrice de transition}
\text{rlist=r1,r2,r3,r4}
\steps{\rlist}
\text{enonce=Donner la matrice de transition du graphe probabiliste suivant :}
\text{accolg=draw(25,50
xrange -1,2
yrange -1.1,1.2
arc 0,0, 1,2, 100,260,black)}
\text{accold=draw(25,50
xrange -1,2
yrange -1.1,1.2
arc 0,0, 1,2, 260,100,black)}

#elif #TARGET(stable)
\title{Etat stable}
\real{mu1=\p2/(\p1+\p2)}
\real{mu2=\p1/(\p1+\p2)}
\text{enonce=L'volution de l'tat d'un systme entre deux units de temps 
n et n+1 est dcrit par le graphe probabiliste ci-dessous.<br> 
Dterminer l'tat stable du systme.}
\text{rlist=r1,r2}
\steps{\rlist}
#elif #TARGET(proba)
\title{Etat d'un systme}
\integer{n0=randint(0..10)} /*choix des instants pour la question*/
\integer{dn=randint(2..5)}
\integer{n1=\n0+\dn}        
\integer{e0=random(1,2)} /*choix des etats pour la question*/
\integer{e1=random(1,2)}
/* Calcul de la loi a l'instant n1*/
\real{som=\p1+\p2}
\real{aux=(1-\som)^\dn}
\real{v11=(\p1*\aux+\p2)/\som}
\real{v12=(-\p1*\aux+\p1)/\som}
\real{v21=(-\p2*\aux+\p2)/\som}
\real{v22=(\p2*\aux+\p1)/\som}
\matrix{Tn=\v11,\v12
\v21,\v22}
/* Choix de la question*/
\integer{c=random(1,2)} 
\if{\c=1}{
\real{res=\Tn[\e0;\e1]}
\text{enonce=L'volution de l'tat d'un systme entre deux units de temps n et n+1 est dcrit par le graphe probabiliste ci-dessous.<br> 
On sait qu' l'instant \n0, le systme est dans l'tat \e0. 
Dterminer la probabilit que le systme se trouve dans l'tat \e1  l'instant \n1.} 
}
{
  \integer{L1=randint(1..99)}
  \integer{L2=100-\L1}
  \matrix{Vn=pari(Tn=Mat([\Tn]);v=[\L1/100,\L2/100]*Tn;print(v))}
  \if{\e0=1}{\text{h1=\L1}}
                 {\text{h1=\L2} }
  \real{res= \Vn[1;\e1]}
 \text{enonce=L'volution de l'tat d'un systme entre deux units de temps n et n+1 est dcrit par le graphe probabiliste ci-dessous.<br> 
On suppose  qu' l'instant \n0, le systme a \h1 % de chance de se trouver dans l'tat \e0. 
Dterminer la probabilit que le systme se trouve dans l'tat \e1  l'instant \n1.} 
}
#endif


\statement{\enonce
<center><img src=\dessin></center>

#if #TARGET(matrice)
<p>
La matrice de transition est :
<table align="center" border=0>
<tr><td rowspan="4"> <img src=\accolg></td><td></td><td></td><td rowspan="4"> <img src=\accold></td></tr>
<td align="center"> \embed{\rlist[1],4} </td>
<td align="center"> \embed{\rlist[2],4} </td><td rowspan="4"> </tr>
  <tr><td align="center"> \embed{\rlist[3],4} </td>
<td align="center"> \embed{\rlist[4],4} </td>  </tr> 
<tr> <td></td><td></td></tr>
 </table></p>
#elif #TARGET(stable)
L'tat probabiliste stable est : 
<table align="center" border=0>
<tr><td align="center">&#40; \embed{\rlist[1],4} </td>
<td align="center"> \embed{\rlist[2],4} &#41;</td> </tr>
 </table></p>
#endif
}

/*Analyse des rponses*/

#if #TARGET(matrice)
\answer{}{\T[1;1]}{type=numeric}{weight=\poids1}
\answer{}{\T[1;2]}{type=numeric}{weight=\poids1}
\answer{}{\T[2;1]}{type=numeric}{weight=\poids1}
\answer{}{\T[2;2]}{type=numeric}{weight=\poids1}
#elif #TARGET(proba)
\answer{Probabilit}{\res}{type=numeric}
#elif #TARGET(stable)
\answer{}{\mu1}{type=numeric}{weight=\poids1}
\answer{}{\mu2}{type=numeric}{weight=\poids1}
#endif
#if #TARGET(matrice)
\feedback{1=1}{<font color=green>La matrice de transition est \([\T]\)</font>}
#elif  #TARGET(stable)
\feedback{1=1}{<font color=green>L'tat probabiliste stable  est \([\mu1,\mu2]\)</font>}
#endif 
