/**
 * Difference.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente la difference de deux ensembles.
 *
 * @author Nicolae
 */
public class Difference extends DefaultSet {

	private Set A;
	private Set B;
	
	/**
	 * Cache le constructor standard.
	 */
	private Difference() {}
	
	
	/**
	 * Constructor qui initialise les deux ensembles.
	 *
	 * @param A ensemble.
	 * @param B ensemble.
	 */
	public Difference(Set A, Set B) {
		this.A = A;
		this.B = B;
	}
	
	public boolean contains(double re, double im) {
		return A.contains(re, im) && ! B.contains(re, im);
	}

}
