Entity Creation
===============

This document describes the circumstances in which fundamental state entities
are created, from the perspective of the CLI.

juju deploy
-----------

The `juju deploy` command always creates services, may create relations, and
may also create units and machines.

  * New services can always be added.
  * If the created service's charm defines any peer relations, a (runtime) peer
    relation will be created for each. BUG: this is not done in the same
    transaction as service creation; a connection failure at the wrong time
    will create a broken and unfixable service (because peer relations cannot
    be manipulated via the CLI).
  * If the created service's charm is not subordinate, some number of units will
    be created; this number is controlled via the "--num-units" parameter which
    defaults to 1.
  * If units were created, machines may also be created, as below.


juju add-unit
-------------

The `juju add-unit` command applies only to principal services. It always
creates units, and may create machines. Different providers assign units to
machines in different ways, and so machine creation can vary: for example, the
ec2 provider creates a new machine for each unit that cannot be placed on an
existing machine without assigned units.

  * New units can only be added to Alive services.


juju add-relation
-----------------

The `juju add-relation` command creates relations, and may -- if the relation
has container scope, by virtue of one or more endpoints having container scope
-- indirectly cause the creation of subordinate units. Subordinate units are in
fact created by principal unit agents, at the point when they enter scope of a
container-scoped relation and find that no suitable subordinate already exists.

  * New relations can only be added between Alive services.
  * New subordinate units will only be added as a consequence of an Alive
    principal unit's participation in an Alive relation (implying an Alive
    subordinate service).
