/* SPDX-License-Identifier: GPL-2.0+
 * Microchip Sparx5 SerDes driver
 *
 * Copyright (c) 2020 Microchip Technology Inc.
 */

/* This file is autogenerated by cml-utils 2020-11-16 13:11:27 +0100.
 * Commit ID: 13bdf073131d8bf40c54901df6988ae4e9c8f29f
 */

#ifndef _SPARX5_SERDES_REGS_H_
#define _SPARX5_SERDES_REGS_H_

#include <linux/bitfield.h>
#include <linux/types.h>
#include <linux/bug.h>

enum sparx5_serdes_target {
	TARGET_SD10G_LANE = 200,
	TARGET_SD25G_LANE = 212,
	TARGET_SD6G_LANE = 233,
	TARGET_SD_CMU = 248,
	TARGET_SD_CMU_CFG = 262,
	TARGET_SD_LANE = 276,
	TARGET_SD_LANE_25G = 301,
	NUM_TARGETS = 332
};

#define __REG(...)    __VA_ARGS__

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_01 */
#define SD10G_LANE_LANE_01(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 4, 0, 1, 4)

#define SD10G_LANE_LANE_01_CFG_PMA_TX_CK_BITWIDTH_2_0 GENMASK(2, 0)
#define SD10G_LANE_LANE_01_CFG_PMA_TX_CK_BITWIDTH_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_01_CFG_PMA_TX_CK_BITWIDTH_2_0, x)
#define SD10G_LANE_LANE_01_CFG_PMA_TX_CK_BITWIDTH_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_01_CFG_PMA_TX_CK_BITWIDTH_2_0, x)

#define SD10G_LANE_LANE_01_CFG_RXDET_EN          BIT(4)
#define SD10G_LANE_LANE_01_CFG_RXDET_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_01_CFG_RXDET_EN, x)
#define SD10G_LANE_LANE_01_CFG_RXDET_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_01_CFG_RXDET_EN, x)

#define SD10G_LANE_LANE_01_CFG_RXDET_STR         BIT(5)
#define SD10G_LANE_LANE_01_CFG_RXDET_STR_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_01_CFG_RXDET_STR, x)
#define SD10G_LANE_LANE_01_CFG_RXDET_STR_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_01_CFG_RXDET_STR, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_02 */
#define SD10G_LANE_LANE_02(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 8, 0, 1, 4)

#define SD10G_LANE_LANE_02_CFG_EN_ADV            BIT(0)
#define SD10G_LANE_LANE_02_CFG_EN_ADV_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_02_CFG_EN_ADV, x)
#define SD10G_LANE_LANE_02_CFG_EN_ADV_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_02_CFG_EN_ADV, x)

#define SD10G_LANE_LANE_02_CFG_EN_MAIN           BIT(1)
#define SD10G_LANE_LANE_02_CFG_EN_MAIN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_02_CFG_EN_MAIN, x)
#define SD10G_LANE_LANE_02_CFG_EN_MAIN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_02_CFG_EN_MAIN, x)

#define SD10G_LANE_LANE_02_CFG_EN_DLY            BIT(2)
#define SD10G_LANE_LANE_02_CFG_EN_DLY_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_02_CFG_EN_DLY, x)
#define SD10G_LANE_LANE_02_CFG_EN_DLY_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_02_CFG_EN_DLY, x)

#define SD10G_LANE_LANE_02_CFG_EN_DLY2           BIT(3)
#define SD10G_LANE_LANE_02_CFG_EN_DLY2_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_02_CFG_EN_DLY2, x)
#define SD10G_LANE_LANE_02_CFG_EN_DLY2_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_02_CFG_EN_DLY2, x)

#define SD10G_LANE_LANE_02_CFG_TAP_ADV_3_0       GENMASK(7, 4)
#define SD10G_LANE_LANE_02_CFG_TAP_ADV_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_02_CFG_TAP_ADV_3_0, x)
#define SD10G_LANE_LANE_02_CFG_TAP_ADV_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_02_CFG_TAP_ADV_3_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_03 */
#define SD10G_LANE_LANE_03(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 12, 0, 1, 4)

#define SD10G_LANE_LANE_03_CFG_TAP_MAIN          BIT(0)
#define SD10G_LANE_LANE_03_CFG_TAP_MAIN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_03_CFG_TAP_MAIN, x)
#define SD10G_LANE_LANE_03_CFG_TAP_MAIN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_03_CFG_TAP_MAIN, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_04 */
#define SD10G_LANE_LANE_04(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 16, 0, 1, 4)

#define SD10G_LANE_LANE_04_CFG_TAP_DLY_4_0       GENMASK(4, 0)
#define SD10G_LANE_LANE_04_CFG_TAP_DLY_4_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_04_CFG_TAP_DLY_4_0, x)
#define SD10G_LANE_LANE_04_CFG_TAP_DLY_4_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_04_CFG_TAP_DLY_4_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_06 */
#define SD10G_LANE_LANE_06(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 24, 0, 1, 4)

#define SD10G_LANE_LANE_06_CFG_PD_DRIVER         BIT(0)
#define SD10G_LANE_LANE_06_CFG_PD_DRIVER_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_06_CFG_PD_DRIVER, x)
#define SD10G_LANE_LANE_06_CFG_PD_DRIVER_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_06_CFG_PD_DRIVER, x)

#define SD10G_LANE_LANE_06_CFG_PD_CLK            BIT(1)
#define SD10G_LANE_LANE_06_CFG_PD_CLK_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_06_CFG_PD_CLK, x)
#define SD10G_LANE_LANE_06_CFG_PD_CLK_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_06_CFG_PD_CLK, x)

#define SD10G_LANE_LANE_06_CFG_PD_CML            BIT(2)
#define SD10G_LANE_LANE_06_CFG_PD_CML_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_06_CFG_PD_CML, x)
#define SD10G_LANE_LANE_06_CFG_PD_CML_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_06_CFG_PD_CML, x)

#define SD10G_LANE_LANE_06_CFG_TX2RX_LP_EN       BIT(3)
#define SD10G_LANE_LANE_06_CFG_TX2RX_LP_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_06_CFG_TX2RX_LP_EN, x)
#define SD10G_LANE_LANE_06_CFG_TX2RX_LP_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_06_CFG_TX2RX_LP_EN, x)

#define SD10G_LANE_LANE_06_CFG_RX2TX_LP_EN       BIT(4)
#define SD10G_LANE_LANE_06_CFG_RX2TX_LP_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_06_CFG_RX2TX_LP_EN, x)
#define SD10G_LANE_LANE_06_CFG_RX2TX_LP_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_06_CFG_RX2TX_LP_EN, x)

#define SD10G_LANE_LANE_06_CFG_EN_PREEMPH        BIT(5)
#define SD10G_LANE_LANE_06_CFG_EN_PREEMPH_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_06_CFG_EN_PREEMPH, x)
#define SD10G_LANE_LANE_06_CFG_EN_PREEMPH_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_06_CFG_EN_PREEMPH, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_0B */
#define SD10G_LANE_LANE_0B(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 44, 0, 1, 4)

#define SD10G_LANE_LANE_0B_CFG_EQ_RES_3_0        GENMASK(3, 0)
#define SD10G_LANE_LANE_0B_CFG_EQ_RES_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0B_CFG_EQ_RES_3_0, x)
#define SD10G_LANE_LANE_0B_CFG_EQ_RES_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0B_CFG_EQ_RES_3_0, x)

#define SD10G_LANE_LANE_0B_CFG_PD_CTLE           BIT(4)
#define SD10G_LANE_LANE_0B_CFG_PD_CTLE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0B_CFG_PD_CTLE, x)
#define SD10G_LANE_LANE_0B_CFG_PD_CTLE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0B_CFG_PD_CTLE, x)

#define SD10G_LANE_LANE_0B_CFG_CTLE_TP_EN        BIT(5)
#define SD10G_LANE_LANE_0B_CFG_CTLE_TP_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0B_CFG_CTLE_TP_EN, x)
#define SD10G_LANE_LANE_0B_CFG_CTLE_TP_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0B_CFG_CTLE_TP_EN, x)

#define SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_AFE  BIT(6)
#define SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_AFE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_AFE, x)
#define SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_AFE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_AFE, x)

#define SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_SQ   BIT(7)
#define SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_SQ_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_SQ, x)
#define SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_SQ_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0B_CFG_RESETB_OSCAL_SQ, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_0C */
#define SD10G_LANE_LANE_0C(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 48, 0, 1, 4)

#define SD10G_LANE_LANE_0C_CFG_OSCAL_AFE         BIT(0)
#define SD10G_LANE_LANE_0C_CFG_OSCAL_AFE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_OSCAL_AFE, x)
#define SD10G_LANE_LANE_0C_CFG_OSCAL_AFE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_OSCAL_AFE, x)

#define SD10G_LANE_LANE_0C_CFG_OSCAL_SQ          BIT(1)
#define SD10G_LANE_LANE_0C_CFG_OSCAL_SQ_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_OSCAL_SQ, x)
#define SD10G_LANE_LANE_0C_CFG_OSCAL_SQ_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_OSCAL_SQ, x)

#define SD10G_LANE_LANE_0C_CFG_OSDAC_2X_AFE      BIT(2)
#define SD10G_LANE_LANE_0C_CFG_OSDAC_2X_AFE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_OSDAC_2X_AFE, x)
#define SD10G_LANE_LANE_0C_CFG_OSDAC_2X_AFE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_OSDAC_2X_AFE, x)

#define SD10G_LANE_LANE_0C_CFG_OSDAC_2X_SQ       BIT(3)
#define SD10G_LANE_LANE_0C_CFG_OSDAC_2X_SQ_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_OSDAC_2X_SQ, x)
#define SD10G_LANE_LANE_0C_CFG_OSDAC_2X_SQ_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_OSDAC_2X_SQ, x)

#define SD10G_LANE_LANE_0C_CFG_PD_OSDAC_AFE      BIT(4)
#define SD10G_LANE_LANE_0C_CFG_PD_OSDAC_AFE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_PD_OSDAC_AFE, x)
#define SD10G_LANE_LANE_0C_CFG_PD_OSDAC_AFE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_PD_OSDAC_AFE, x)

#define SD10G_LANE_LANE_0C_CFG_PD_OSDAC_SQ       BIT(5)
#define SD10G_LANE_LANE_0C_CFG_PD_OSDAC_SQ_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_PD_OSDAC_SQ, x)
#define SD10G_LANE_LANE_0C_CFG_PD_OSDAC_SQ_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_PD_OSDAC_SQ, x)

#define SD10G_LANE_LANE_0C_CFG_PD_RX_LS          BIT(6)
#define SD10G_LANE_LANE_0C_CFG_PD_RX_LS_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_PD_RX_LS, x)
#define SD10G_LANE_LANE_0C_CFG_PD_RX_LS_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_PD_RX_LS, x)

#define SD10G_LANE_LANE_0C_CFG_RX_PCIE_GEN12     BIT(7)
#define SD10G_LANE_LANE_0C_CFG_RX_PCIE_GEN12_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0C_CFG_RX_PCIE_GEN12, x)
#define SD10G_LANE_LANE_0C_CFG_RX_PCIE_GEN12_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0C_CFG_RX_PCIE_GEN12, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_0D */
#define SD10G_LANE_LANE_0D(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 52, 0, 1, 4)

#define SD10G_LANE_LANE_0D_CFG_CTLE_M_THR_1_0    GENMASK(1, 0)
#define SD10G_LANE_LANE_0D_CFG_CTLE_M_THR_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0D_CFG_CTLE_M_THR_1_0, x)
#define SD10G_LANE_LANE_0D_CFG_CTLE_M_THR_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0D_CFG_CTLE_M_THR_1_0, x)

#define SD10G_LANE_LANE_0D_CFG_EQR_BYP           BIT(4)
#define SD10G_LANE_LANE_0D_CFG_EQR_BYP_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0D_CFG_EQR_BYP, x)
#define SD10G_LANE_LANE_0D_CFG_EQR_BYP_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0D_CFG_EQR_BYP, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_0E */
#define SD10G_LANE_LANE_0E(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 56, 0, 1, 4)

#define SD10G_LANE_LANE_0E_CFG_EQC_FORCE_3_0     GENMASK(3, 0)
#define SD10G_LANE_LANE_0E_CFG_EQC_FORCE_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0E_CFG_EQC_FORCE_3_0, x)
#define SD10G_LANE_LANE_0E_CFG_EQC_FORCE_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0E_CFG_EQC_FORCE_3_0, x)

#define SD10G_LANE_LANE_0E_CFG_RXLB_EN           BIT(4)
#define SD10G_LANE_LANE_0E_CFG_RXLB_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0E_CFG_RXLB_EN, x)
#define SD10G_LANE_LANE_0E_CFG_RXLB_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0E_CFG_RXLB_EN, x)

#define SD10G_LANE_LANE_0E_CFG_TXLB_EN           BIT(5)
#define SD10G_LANE_LANE_0E_CFG_TXLB_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0E_CFG_TXLB_EN, x)
#define SD10G_LANE_LANE_0E_CFG_TXLB_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0E_CFG_TXLB_EN, x)

#define SD10G_LANE_LANE_0E_CFG_SUM_SETCM_EN      BIT(6)
#define SD10G_LANE_LANE_0E_CFG_SUM_SETCM_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0E_CFG_SUM_SETCM_EN, x)
#define SD10G_LANE_LANE_0E_CFG_SUM_SETCM_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0E_CFG_SUM_SETCM_EN, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_0F */
#define SD10G_LANE_LANE_0F(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 60, 0, 1, 4)

#define SD10G_LANE_LANE_0F_R_CDR_M_GEN1_7_0      GENMASK(7, 0)
#define SD10G_LANE_LANE_0F_R_CDR_M_GEN1_7_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_0F_R_CDR_M_GEN1_7_0, x)
#define SD10G_LANE_LANE_0F_R_CDR_M_GEN1_7_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_0F_R_CDR_M_GEN1_7_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_13 */
#define SD10G_LANE_LANE_13(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 76, 0, 1, 4)

#define SD10G_LANE_LANE_13_CFG_DCDR_PD           BIT(0)
#define SD10G_LANE_LANE_13_CFG_DCDR_PD_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_13_CFG_DCDR_PD, x)
#define SD10G_LANE_LANE_13_CFG_DCDR_PD_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_13_CFG_DCDR_PD, x)

#define SD10G_LANE_LANE_13_CFG_PHID_1T           BIT(1)
#define SD10G_LANE_LANE_13_CFG_PHID_1T_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_13_CFG_PHID_1T, x)
#define SD10G_LANE_LANE_13_CFG_PHID_1T_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_13_CFG_PHID_1T, x)

#define SD10G_LANE_LANE_13_CFG_CDRCK_EN          BIT(2)
#define SD10G_LANE_LANE_13_CFG_CDRCK_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_13_CFG_CDRCK_EN, x)
#define SD10G_LANE_LANE_13_CFG_CDRCK_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_13_CFG_CDRCK_EN, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_14 */
#define SD10G_LANE_LANE_14(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 80, 0, 1, 4)

#define SD10G_LANE_LANE_14_CFG_PI_EXT_DAC_7_0    GENMASK(7, 0)
#define SD10G_LANE_LANE_14_CFG_PI_EXT_DAC_7_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_14_CFG_PI_EXT_DAC_7_0, x)
#define SD10G_LANE_LANE_14_CFG_PI_EXT_DAC_7_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_14_CFG_PI_EXT_DAC_7_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_15 */
#define SD10G_LANE_LANE_15(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 84, 0, 1, 4)

#define SD10G_LANE_LANE_15_CFG_PI_EXT_DAC_15_8   GENMASK(7, 0)
#define SD10G_LANE_LANE_15_CFG_PI_EXT_DAC_15_8_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_15_CFG_PI_EXT_DAC_15_8, x)
#define SD10G_LANE_LANE_15_CFG_PI_EXT_DAC_15_8_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_15_CFG_PI_EXT_DAC_15_8, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_16 */
#define SD10G_LANE_LANE_16(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 88, 0, 1, 4)

#define SD10G_LANE_LANE_16_CFG_PI_EXT_DAC_23_16  GENMASK(7, 0)
#define SD10G_LANE_LANE_16_CFG_PI_EXT_DAC_23_16_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_16_CFG_PI_EXT_DAC_23_16, x)
#define SD10G_LANE_LANE_16_CFG_PI_EXT_DAC_23_16_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_16_CFG_PI_EXT_DAC_23_16, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_1A */
#define SD10G_LANE_LANE_1A(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 104, 0, 1, 4)

#define SD10G_LANE_LANE_1A_CFG_PI_R_SCAN_EN      BIT(0)
#define SD10G_LANE_LANE_1A_CFG_PI_R_SCAN_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_1A_CFG_PI_R_SCAN_EN, x)
#define SD10G_LANE_LANE_1A_CFG_PI_R_SCAN_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_1A_CFG_PI_R_SCAN_EN, x)

#define SD10G_LANE_LANE_1A_CFG_PI_EN             BIT(1)
#define SD10G_LANE_LANE_1A_CFG_PI_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_1A_CFG_PI_EN, x)
#define SD10G_LANE_LANE_1A_CFG_PI_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_1A_CFG_PI_EN, x)

#define SD10G_LANE_LANE_1A_CFG_PI_DFE_EN         BIT(2)
#define SD10G_LANE_LANE_1A_CFG_PI_DFE_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_1A_CFG_PI_DFE_EN, x)
#define SD10G_LANE_LANE_1A_CFG_PI_DFE_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_1A_CFG_PI_DFE_EN, x)

#define SD10G_LANE_LANE_1A_CFG_PI_STEPS          BIT(3)
#define SD10G_LANE_LANE_1A_CFG_PI_STEPS_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_1A_CFG_PI_STEPS, x)
#define SD10G_LANE_LANE_1A_CFG_PI_STEPS_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_1A_CFG_PI_STEPS, x)

#define SD10G_LANE_LANE_1A_CFG_PI_FLOOP_STEPS_1_0 GENMASK(5, 4)
#define SD10G_LANE_LANE_1A_CFG_PI_FLOOP_STEPS_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_1A_CFG_PI_FLOOP_STEPS_1_0, x)
#define SD10G_LANE_LANE_1A_CFG_PI_FLOOP_STEPS_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_1A_CFG_PI_FLOOP_STEPS_1_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_22 */
#define SD10G_LANE_LANE_22(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 136, 0, 1, 4)

#define SD10G_LANE_LANE_22_CFG_DFETAP_EN_5_1     GENMASK(4, 0)
#define SD10G_LANE_LANE_22_CFG_DFETAP_EN_5_1_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_22_CFG_DFETAP_EN_5_1, x)
#define SD10G_LANE_LANE_22_CFG_DFETAP_EN_5_1_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_22_CFG_DFETAP_EN_5_1, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_23 */
#define SD10G_LANE_LANE_23(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 140, 0, 1, 4)

#define SD10G_LANE_LANE_23_CFG_DFE_PD            BIT(0)
#define SD10G_LANE_LANE_23_CFG_DFE_PD_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_23_CFG_DFE_PD, x)
#define SD10G_LANE_LANE_23_CFG_DFE_PD_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_23_CFG_DFE_PD, x)

#define SD10G_LANE_LANE_23_CFG_EN_DFEDIG         BIT(1)
#define SD10G_LANE_LANE_23_CFG_EN_DFEDIG_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_23_CFG_EN_DFEDIG, x)
#define SD10G_LANE_LANE_23_CFG_EN_DFEDIG_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_23_CFG_EN_DFEDIG, x)

#define SD10G_LANE_LANE_23_CFG_DFECK_EN          BIT(2)
#define SD10G_LANE_LANE_23_CFG_DFECK_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_23_CFG_DFECK_EN, x)
#define SD10G_LANE_LANE_23_CFG_DFECK_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_23_CFG_DFECK_EN, x)

#define SD10G_LANE_LANE_23_CFG_ERRAMP_PD         BIT(3)
#define SD10G_LANE_LANE_23_CFG_ERRAMP_PD_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_23_CFG_ERRAMP_PD, x)
#define SD10G_LANE_LANE_23_CFG_ERRAMP_PD_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_23_CFG_ERRAMP_PD, x)

#define SD10G_LANE_LANE_23_CFG_DFEDIG_M_2_0      GENMASK(6, 4)
#define SD10G_LANE_LANE_23_CFG_DFEDIG_M_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_23_CFG_DFEDIG_M_2_0, x)
#define SD10G_LANE_LANE_23_CFG_DFEDIG_M_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_23_CFG_DFEDIG_M_2_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_24 */
#define SD10G_LANE_LANE_24(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 144, 0, 1, 4)

#define SD10G_LANE_LANE_24_CFG_PI_BW_GEN1_3_0    GENMASK(3, 0)
#define SD10G_LANE_LANE_24_CFG_PI_BW_GEN1_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_24_CFG_PI_BW_GEN1_3_0, x)
#define SD10G_LANE_LANE_24_CFG_PI_BW_GEN1_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_24_CFG_PI_BW_GEN1_3_0, x)

#define SD10G_LANE_LANE_24_CFG_PI_BW_GEN2_3_0    GENMASK(7, 4)
#define SD10G_LANE_LANE_24_CFG_PI_BW_GEN2_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_24_CFG_PI_BW_GEN2_3_0, x)
#define SD10G_LANE_LANE_24_CFG_PI_BW_GEN2_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_24_CFG_PI_BW_GEN2_3_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_26 */
#define SD10G_LANE_LANE_26(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 152, 0, 1, 4)

#define SD10G_LANE_LANE_26_CFG_ISCAN_EXT_DAC_7_0 GENMASK(7, 0)
#define SD10G_LANE_LANE_26_CFG_ISCAN_EXT_DAC_7_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_26_CFG_ISCAN_EXT_DAC_7_0, x)
#define SD10G_LANE_LANE_26_CFG_ISCAN_EXT_DAC_7_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_26_CFG_ISCAN_EXT_DAC_7_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_2F */
#define SD10G_LANE_LANE_2F(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 188, 0, 1, 4)

#define SD10G_LANE_LANE_2F_CFG_VGA_CP_2_0        GENMASK(2, 0)
#define SD10G_LANE_LANE_2F_CFG_VGA_CP_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_2F_CFG_VGA_CP_2_0, x)
#define SD10G_LANE_LANE_2F_CFG_VGA_CP_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_2F_CFG_VGA_CP_2_0, x)

#define SD10G_LANE_LANE_2F_CFG_VGA_CTRL_3_0      GENMASK(7, 4)
#define SD10G_LANE_LANE_2F_CFG_VGA_CTRL_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_2F_CFG_VGA_CTRL_3_0, x)
#define SD10G_LANE_LANE_2F_CFG_VGA_CTRL_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_2F_CFG_VGA_CTRL_3_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_30 */
#define SD10G_LANE_LANE_30(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 192, 0, 1, 4)

#define SD10G_LANE_LANE_30_CFG_SUMMER_EN         BIT(0)
#define SD10G_LANE_LANE_30_CFG_SUMMER_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_30_CFG_SUMMER_EN, x)
#define SD10G_LANE_LANE_30_CFG_SUMMER_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_30_CFG_SUMMER_EN, x)

#define SD10G_LANE_LANE_30_CFG_RXDIV_SEL_2_0     GENMASK(6, 4)
#define SD10G_LANE_LANE_30_CFG_RXDIV_SEL_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_30_CFG_RXDIV_SEL_2_0, x)
#define SD10G_LANE_LANE_30_CFG_RXDIV_SEL_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_30_CFG_RXDIV_SEL_2_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_31 */
#define SD10G_LANE_LANE_31(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 196, 0, 1, 4)

#define SD10G_LANE_LANE_31_CFG_PI_RSTN           BIT(0)
#define SD10G_LANE_LANE_31_CFG_PI_RSTN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_31_CFG_PI_RSTN, x)
#define SD10G_LANE_LANE_31_CFG_PI_RSTN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_31_CFG_PI_RSTN, x)

#define SD10G_LANE_LANE_31_CFG_CDR_RSTN          BIT(1)
#define SD10G_LANE_LANE_31_CFG_CDR_RSTN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_31_CFG_CDR_RSTN, x)
#define SD10G_LANE_LANE_31_CFG_CDR_RSTN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_31_CFG_CDR_RSTN, x)

#define SD10G_LANE_LANE_31_CFG_RSTN_DFEDIG       BIT(2)
#define SD10G_LANE_LANE_31_CFG_RSTN_DFEDIG_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_31_CFG_RSTN_DFEDIG, x)
#define SD10G_LANE_LANE_31_CFG_RSTN_DFEDIG_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_31_CFG_RSTN_DFEDIG, x)

#define SD10G_LANE_LANE_31_CFG_CTLE_RSTN         BIT(3)
#define SD10G_LANE_LANE_31_CFG_CTLE_RSTN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_31_CFG_CTLE_RSTN, x)
#define SD10G_LANE_LANE_31_CFG_CTLE_RSTN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_31_CFG_CTLE_RSTN, x)

#define SD10G_LANE_LANE_31_CFG_RSTN_DIV5_8       BIT(4)
#define SD10G_LANE_LANE_31_CFG_RSTN_DIV5_8_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_31_CFG_RSTN_DIV5_8, x)
#define SD10G_LANE_LANE_31_CFG_RSTN_DIV5_8_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_31_CFG_RSTN_DIV5_8, x)

#define SD10G_LANE_LANE_31_CFG_R50_EN            BIT(5)
#define SD10G_LANE_LANE_31_CFG_R50_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_31_CFG_R50_EN, x)
#define SD10G_LANE_LANE_31_CFG_R50_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_31_CFG_R50_EN, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_32 */
#define SD10G_LANE_LANE_32(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 200, 0, 1, 4)

#define SD10G_LANE_LANE_32_CFG_ITX_IPCLK_BASE_1_0 GENMASK(1, 0)
#define SD10G_LANE_LANE_32_CFG_ITX_IPCLK_BASE_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_32_CFG_ITX_IPCLK_BASE_1_0, x)
#define SD10G_LANE_LANE_32_CFG_ITX_IPCLK_BASE_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_32_CFG_ITX_IPCLK_BASE_1_0, x)

#define SD10G_LANE_LANE_32_CFG_ITX_IPCML_BASE_1_0 GENMASK(5, 4)
#define SD10G_LANE_LANE_32_CFG_ITX_IPCML_BASE_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_32_CFG_ITX_IPCML_BASE_1_0, x)
#define SD10G_LANE_LANE_32_CFG_ITX_IPCML_BASE_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_32_CFG_ITX_IPCML_BASE_1_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_33 */
#define SD10G_LANE_LANE_33(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 204, 0, 1, 4)

#define SD10G_LANE_LANE_33_CFG_ITX_IPDRIVER_BASE_2_0 GENMASK(2, 0)
#define SD10G_LANE_LANE_33_CFG_ITX_IPDRIVER_BASE_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_33_CFG_ITX_IPDRIVER_BASE_2_0, x)
#define SD10G_LANE_LANE_33_CFG_ITX_IPDRIVER_BASE_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_33_CFG_ITX_IPDRIVER_BASE_2_0, x)

#define SD10G_LANE_LANE_33_CFG_ITX_IPPREEMP_BASE_1_0 GENMASK(5, 4)
#define SD10G_LANE_LANE_33_CFG_ITX_IPPREEMP_BASE_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_33_CFG_ITX_IPPREEMP_BASE_1_0, x)
#define SD10G_LANE_LANE_33_CFG_ITX_IPPREEMP_BASE_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_33_CFG_ITX_IPPREEMP_BASE_1_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_35 */
#define SD10G_LANE_LANE_35(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 212, 0, 1, 4)

#define SD10G_LANE_LANE_35_CFG_TXRATE_1_0        GENMASK(1, 0)
#define SD10G_LANE_LANE_35_CFG_TXRATE_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_35_CFG_TXRATE_1_0, x)
#define SD10G_LANE_LANE_35_CFG_TXRATE_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_35_CFG_TXRATE_1_0, x)

#define SD10G_LANE_LANE_35_CFG_RXRATE_1_0        GENMASK(5, 4)
#define SD10G_LANE_LANE_35_CFG_RXRATE_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_35_CFG_RXRATE_1_0, x)
#define SD10G_LANE_LANE_35_CFG_RXRATE_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_35_CFG_RXRATE_1_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_36 */
#define SD10G_LANE_LANE_36(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 216, 0, 1, 4)

#define SD10G_LANE_LANE_36_CFG_PREDRV_SLEWRATE_1_0 GENMASK(1, 0)
#define SD10G_LANE_LANE_36_CFG_PREDRV_SLEWRATE_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_36_CFG_PREDRV_SLEWRATE_1_0, x)
#define SD10G_LANE_LANE_36_CFG_PREDRV_SLEWRATE_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_36_CFG_PREDRV_SLEWRATE_1_0, x)

#define SD10G_LANE_LANE_36_CFG_EID_LP            BIT(4)
#define SD10G_LANE_LANE_36_CFG_EID_LP_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_36_CFG_EID_LP, x)
#define SD10G_LANE_LANE_36_CFG_EID_LP_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_36_CFG_EID_LP, x)

#define SD10G_LANE_LANE_36_CFG_EN_PREDRV_EMPH    BIT(5)
#define SD10G_LANE_LANE_36_CFG_EN_PREDRV_EMPH_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_36_CFG_EN_PREDRV_EMPH, x)
#define SD10G_LANE_LANE_36_CFG_EN_PREDRV_EMPH_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_36_CFG_EN_PREDRV_EMPH, x)

#define SD10G_LANE_LANE_36_CFG_PRBS_SEL          BIT(6)
#define SD10G_LANE_LANE_36_CFG_PRBS_SEL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_36_CFG_PRBS_SEL, x)
#define SD10G_LANE_LANE_36_CFG_PRBS_SEL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_36_CFG_PRBS_SEL, x)

#define SD10G_LANE_LANE_36_CFG_PRBS_SETB         BIT(7)
#define SD10G_LANE_LANE_36_CFG_PRBS_SETB_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_36_CFG_PRBS_SETB, x)
#define SD10G_LANE_LANE_36_CFG_PRBS_SETB_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_36_CFG_PRBS_SETB, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_37 */
#define SD10G_LANE_LANE_37(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 220, 0, 1, 4)

#define SD10G_LANE_LANE_37_CFG_RXDET_COMP_PD     BIT(0)
#define SD10G_LANE_LANE_37_CFG_RXDET_COMP_PD_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_37_CFG_RXDET_COMP_PD, x)
#define SD10G_LANE_LANE_37_CFG_RXDET_COMP_PD_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_37_CFG_RXDET_COMP_PD, x)

#define SD10G_LANE_LANE_37_CFG_PD_RX_CKTREE      BIT(1)
#define SD10G_LANE_LANE_37_CFG_PD_RX_CKTREE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_37_CFG_PD_RX_CKTREE, x)
#define SD10G_LANE_LANE_37_CFG_PD_RX_CKTREE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_37_CFG_PD_RX_CKTREE, x)

#define SD10G_LANE_LANE_37_CFG_TXSWING_HALF      BIT(2)
#define SD10G_LANE_LANE_37_CFG_TXSWING_HALF_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_37_CFG_TXSWING_HALF, x)
#define SD10G_LANE_LANE_37_CFG_TXSWING_HALF_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_37_CFG_TXSWING_HALF, x)

#define SD10G_LANE_LANE_37_CFG_IP_PRE_BASE_1_0   GENMASK(5, 4)
#define SD10G_LANE_LANE_37_CFG_IP_PRE_BASE_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_37_CFG_IP_PRE_BASE_1_0, x)
#define SD10G_LANE_LANE_37_CFG_IP_PRE_BASE_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_37_CFG_IP_PRE_BASE_1_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_39 */
#define SD10G_LANE_LANE_39(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 228, 0, 1, 4)

#define SD10G_LANE_LANE_39_CFG_RXFILT_Y_2_0      GENMASK(2, 0)
#define SD10G_LANE_LANE_39_CFG_RXFILT_Y_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_39_CFG_RXFILT_Y_2_0, x)
#define SD10G_LANE_LANE_39_CFG_RXFILT_Y_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_39_CFG_RXFILT_Y_2_0, x)

#define SD10G_LANE_LANE_39_CFG_RX_SSC_LH         BIT(4)
#define SD10G_LANE_LANE_39_CFG_RX_SSC_LH_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_39_CFG_RX_SSC_LH, x)
#define SD10G_LANE_LANE_39_CFG_RX_SSC_LH_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_39_CFG_RX_SSC_LH, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_3A */
#define SD10G_LANE_LANE_3A(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 232, 0, 1, 4)

#define SD10G_LANE_LANE_3A_CFG_MP_MIN_3_0        GENMASK(3, 0)
#define SD10G_LANE_LANE_3A_CFG_MP_MIN_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_3A_CFG_MP_MIN_3_0, x)
#define SD10G_LANE_LANE_3A_CFG_MP_MIN_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_3A_CFG_MP_MIN_3_0, x)

#define SD10G_LANE_LANE_3A_CFG_MP_MAX_3_0        GENMASK(7, 4)
#define SD10G_LANE_LANE_3A_CFG_MP_MAX_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_3A_CFG_MP_MAX_3_0, x)
#define SD10G_LANE_LANE_3A_CFG_MP_MAX_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_3A_CFG_MP_MAX_3_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_3C */
#define SD10G_LANE_LANE_3C(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 240, 0, 1, 4)

#define SD10G_LANE_LANE_3C_CFG_DIS_ACC           BIT(0)
#define SD10G_LANE_LANE_3C_CFG_DIS_ACC_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_3C_CFG_DIS_ACC, x)
#define SD10G_LANE_LANE_3C_CFG_DIS_ACC_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_3C_CFG_DIS_ACC, x)

#define SD10G_LANE_LANE_3C_CFG_DIS_2NDORDER      BIT(1)
#define SD10G_LANE_LANE_3C_CFG_DIS_2NDORDER_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_3C_CFG_DIS_2NDORDER, x)
#define SD10G_LANE_LANE_3C_CFG_DIS_2NDORDER_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_3C_CFG_DIS_2NDORDER, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_40 */
#define SD10G_LANE_LANE_40(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 256, 0, 1, 4)

#define SD10G_LANE_LANE_40_CFG_LANE_RESERVE_7_0  GENMASK(7, 0)
#define SD10G_LANE_LANE_40_CFG_LANE_RESERVE_7_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_40_CFG_LANE_RESERVE_7_0, x)
#define SD10G_LANE_LANE_40_CFG_LANE_RESERVE_7_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_40_CFG_LANE_RESERVE_7_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_41 */
#define SD10G_LANE_LANE_41(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 260, 0, 1, 4)

#define SD10G_LANE_LANE_41_CFG_LANE_RESERVE_15_8 GENMASK(7, 0)
#define SD10G_LANE_LANE_41_CFG_LANE_RESERVE_15_8_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_41_CFG_LANE_RESERVE_15_8, x)
#define SD10G_LANE_LANE_41_CFG_LANE_RESERVE_15_8_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_41_CFG_LANE_RESERVE_15_8, x)

/*      SD10G_LANE_TARGET:LANE_GRP_0:LANE_42 */
#define SD10G_LANE_LANE_42(t)     __REG(TARGET_SD10G_LANE, t, 12, 0, 0, 1, 288, 264, 0, 1, 4)

#define SD10G_LANE_LANE_42_CFG_CDR_KF_GEN1_2_0   GENMASK(2, 0)
#define SD10G_LANE_LANE_42_CFG_CDR_KF_GEN1_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_42_CFG_CDR_KF_GEN1_2_0, x)
#define SD10G_LANE_LANE_42_CFG_CDR_KF_GEN1_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_42_CFG_CDR_KF_GEN1_2_0, x)

#define SD10G_LANE_LANE_42_CFG_CDR_KF_GEN2_2_0   GENMASK(6, 4)
#define SD10G_LANE_LANE_42_CFG_CDR_KF_GEN2_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_42_CFG_CDR_KF_GEN2_2_0, x)
#define SD10G_LANE_LANE_42_CFG_CDR_KF_GEN2_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_42_CFG_CDR_KF_GEN2_2_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_1:LANE_48 */
#define SD10G_LANE_LANE_48(t)     __REG(TARGET_SD10G_LANE, t, 12, 288, 0, 1, 40, 0, 0, 1, 4)

#define SD10G_LANE_LANE_48_CFG_ALOS_THR_3_0      GENMASK(3, 0)
#define SD10G_LANE_LANE_48_CFG_ALOS_THR_3_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_48_CFG_ALOS_THR_3_0, x)
#define SD10G_LANE_LANE_48_CFG_ALOS_THR_3_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_48_CFG_ALOS_THR_3_0, x)

#define SD10G_LANE_LANE_48_CFG_AUX_RXCK_SEL      BIT(4)
#define SD10G_LANE_LANE_48_CFG_AUX_RXCK_SEL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_48_CFG_AUX_RXCK_SEL, x)
#define SD10G_LANE_LANE_48_CFG_AUX_RXCK_SEL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_48_CFG_AUX_RXCK_SEL, x)

#define SD10G_LANE_LANE_48_CFG_CLK_ENQ           BIT(5)
#define SD10G_LANE_LANE_48_CFG_CLK_ENQ_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_48_CFG_CLK_ENQ, x)
#define SD10G_LANE_LANE_48_CFG_CLK_ENQ_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_48_CFG_CLK_ENQ, x)

/*      SD10G_LANE_TARGET:LANE_GRP_1:LANE_50 */
#define SD10G_LANE_LANE_50(t)     __REG(TARGET_SD10G_LANE, t, 12, 288, 0, 1, 40, 32, 0, 1, 4)

#define SD10G_LANE_LANE_50_CFG_SSC_PI_STEP_1_0   GENMASK(1, 0)
#define SD10G_LANE_LANE_50_CFG_SSC_PI_STEP_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_50_CFG_SSC_PI_STEP_1_0, x)
#define SD10G_LANE_LANE_50_CFG_SSC_PI_STEP_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_50_CFG_SSC_PI_STEP_1_0, x)

#define SD10G_LANE_LANE_50_CFG_SSC_RESETB        BIT(4)
#define SD10G_LANE_LANE_50_CFG_SSC_RESETB_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_50_CFG_SSC_RESETB, x)
#define SD10G_LANE_LANE_50_CFG_SSC_RESETB_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_50_CFG_SSC_RESETB, x)

#define SD10G_LANE_LANE_50_CFG_SSC_RTL_CLK_SEL   BIT(5)
#define SD10G_LANE_LANE_50_CFG_SSC_RTL_CLK_SEL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_50_CFG_SSC_RTL_CLK_SEL, x)
#define SD10G_LANE_LANE_50_CFG_SSC_RTL_CLK_SEL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_50_CFG_SSC_RTL_CLK_SEL, x)

#define SD10G_LANE_LANE_50_CFG_AUX_TXCK_SEL      BIT(6)
#define SD10G_LANE_LANE_50_CFG_AUX_TXCK_SEL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_50_CFG_AUX_TXCK_SEL, x)
#define SD10G_LANE_LANE_50_CFG_AUX_TXCK_SEL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_50_CFG_AUX_TXCK_SEL, x)

#define SD10G_LANE_LANE_50_CFG_JT_EN             BIT(7)
#define SD10G_LANE_LANE_50_CFG_JT_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_50_CFG_JT_EN, x)
#define SD10G_LANE_LANE_50_CFG_JT_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_50_CFG_JT_EN, x)

/*      SD10G_LANE_TARGET:LANE_GRP_2:LANE_52 */
#define SD10G_LANE_LANE_52(t)     __REG(TARGET_SD10G_LANE, t, 12, 328, 0, 1, 24, 0, 0, 1, 4)

#define SD10G_LANE_LANE_52_CFG_IBIAS_TUNE_RESERVE_5_0 GENMASK(5, 0)
#define SD10G_LANE_LANE_52_CFG_IBIAS_TUNE_RESERVE_5_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_52_CFG_IBIAS_TUNE_RESERVE_5_0, x)
#define SD10G_LANE_LANE_52_CFG_IBIAS_TUNE_RESERVE_5_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_52_CFG_IBIAS_TUNE_RESERVE_5_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_4:LANE_83 */
#define SD10G_LANE_LANE_83(t)     __REG(TARGET_SD10G_LANE, t, 12, 464, 0, 1, 112, 60, 0, 1, 4)

#define SD10G_LANE_LANE_83_R_TX_BIT_REVERSE      BIT(0)
#define SD10G_LANE_LANE_83_R_TX_BIT_REVERSE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_83_R_TX_BIT_REVERSE, x)
#define SD10G_LANE_LANE_83_R_TX_BIT_REVERSE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_83_R_TX_BIT_REVERSE, x)

#define SD10G_LANE_LANE_83_R_TX_POL_INV          BIT(1)
#define SD10G_LANE_LANE_83_R_TX_POL_INV_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_83_R_TX_POL_INV, x)
#define SD10G_LANE_LANE_83_R_TX_POL_INV_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_83_R_TX_POL_INV, x)

#define SD10G_LANE_LANE_83_R_RX_BIT_REVERSE      BIT(2)
#define SD10G_LANE_LANE_83_R_RX_BIT_REVERSE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_83_R_RX_BIT_REVERSE, x)
#define SD10G_LANE_LANE_83_R_RX_BIT_REVERSE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_83_R_RX_BIT_REVERSE, x)

#define SD10G_LANE_LANE_83_R_RX_POL_INV          BIT(3)
#define SD10G_LANE_LANE_83_R_RX_POL_INV_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_83_R_RX_POL_INV, x)
#define SD10G_LANE_LANE_83_R_RX_POL_INV_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_83_R_RX_POL_INV, x)

#define SD10G_LANE_LANE_83_R_DFE_RSTN            BIT(4)
#define SD10G_LANE_LANE_83_R_DFE_RSTN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_83_R_DFE_RSTN, x)
#define SD10G_LANE_LANE_83_R_DFE_RSTN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_83_R_DFE_RSTN, x)

#define SD10G_LANE_LANE_83_R_CDR_RSTN            BIT(5)
#define SD10G_LANE_LANE_83_R_CDR_RSTN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_83_R_CDR_RSTN, x)
#define SD10G_LANE_LANE_83_R_CDR_RSTN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_83_R_CDR_RSTN, x)

#define SD10G_LANE_LANE_83_R_CTLE_RSTN           BIT(6)
#define SD10G_LANE_LANE_83_R_CTLE_RSTN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_83_R_CTLE_RSTN, x)
#define SD10G_LANE_LANE_83_R_CTLE_RSTN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_83_R_CTLE_RSTN, x)

/*      SD10G_LANE_TARGET:LANE_GRP_5:LANE_93 */
#define SD10G_LANE_LANE_93(t)     __REG(TARGET_SD10G_LANE, t, 12, 576, 0, 1, 64, 12, 0, 1, 4)

#define SD10G_LANE_LANE_93_R_RXEI_FIFO_RST_EN    BIT(0)
#define SD10G_LANE_LANE_93_R_RXEI_FIFO_RST_EN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_RXEI_FIFO_RST_EN, x)
#define SD10G_LANE_LANE_93_R_RXEI_FIFO_RST_EN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_RXEI_FIFO_RST_EN, x)

#define SD10G_LANE_LANE_93_R_DWIDTHCTRL_FROM_HWT BIT(1)
#define SD10G_LANE_LANE_93_R_DWIDTHCTRL_FROM_HWT_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_DWIDTHCTRL_FROM_HWT, x)
#define SD10G_LANE_LANE_93_R_DWIDTHCTRL_FROM_HWT_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_DWIDTHCTRL_FROM_HWT, x)

#define SD10G_LANE_LANE_93_R_DIS_RESTORE_DFE     BIT(2)
#define SD10G_LANE_LANE_93_R_DIS_RESTORE_DFE_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_DIS_RESTORE_DFE, x)
#define SD10G_LANE_LANE_93_R_DIS_RESTORE_DFE_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_DIS_RESTORE_DFE, x)

#define SD10G_LANE_LANE_93_R_EN_RATECHG_CTRL     BIT(3)
#define SD10G_LANE_LANE_93_R_EN_RATECHG_CTRL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_EN_RATECHG_CTRL, x)
#define SD10G_LANE_LANE_93_R_EN_RATECHG_CTRL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_EN_RATECHG_CTRL, x)

#define SD10G_LANE_LANE_93_R_REG_MANUAL          BIT(4)
#define SD10G_LANE_LANE_93_R_REG_MANUAL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_REG_MANUAL, x)
#define SD10G_LANE_LANE_93_R_REG_MANUAL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_REG_MANUAL, x)

#define SD10G_LANE_LANE_93_R_AUXCKSEL_FROM_HWT   BIT(5)
#define SD10G_LANE_LANE_93_R_AUXCKSEL_FROM_HWT_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_AUXCKSEL_FROM_HWT, x)
#define SD10G_LANE_LANE_93_R_AUXCKSEL_FROM_HWT_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_AUXCKSEL_FROM_HWT, x)

#define SD10G_LANE_LANE_93_R_LANE_ID_FROM_HWT    BIT(6)
#define SD10G_LANE_LANE_93_R_LANE_ID_FROM_HWT_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_LANE_ID_FROM_HWT, x)
#define SD10G_LANE_LANE_93_R_LANE_ID_FROM_HWT_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_LANE_ID_FROM_HWT, x)

#define SD10G_LANE_LANE_93_R_RX_PCIE_GEN12_FROM_HWT BIT(7)
#define SD10G_LANE_LANE_93_R_RX_PCIE_GEN12_FROM_HWT_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_93_R_RX_PCIE_GEN12_FROM_HWT, x)
#define SD10G_LANE_LANE_93_R_RX_PCIE_GEN12_FROM_HWT_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_93_R_RX_PCIE_GEN12_FROM_HWT, x)

/*      SD10G_LANE_TARGET:LANE_GRP_5:LANE_94 */
#define SD10G_LANE_LANE_94(t)     __REG(TARGET_SD10G_LANE, t, 12, 576, 0, 1, 64, 16, 0, 1, 4)

#define SD10G_LANE_LANE_94_R_DWIDTHCTRL_2_0      GENMASK(2, 0)
#define SD10G_LANE_LANE_94_R_DWIDTHCTRL_2_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_94_R_DWIDTHCTRL_2_0, x)
#define SD10G_LANE_LANE_94_R_DWIDTHCTRL_2_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_94_R_DWIDTHCTRL_2_0, x)

#define SD10G_LANE_LANE_94_R_ISCAN_REG           BIT(4)
#define SD10G_LANE_LANE_94_R_ISCAN_REG_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_94_R_ISCAN_REG, x)
#define SD10G_LANE_LANE_94_R_ISCAN_REG_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_94_R_ISCAN_REG, x)

#define SD10G_LANE_LANE_94_R_TXEQ_REG            BIT(5)
#define SD10G_LANE_LANE_94_R_TXEQ_REG_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_94_R_TXEQ_REG, x)
#define SD10G_LANE_LANE_94_R_TXEQ_REG_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_94_R_TXEQ_REG, x)

#define SD10G_LANE_LANE_94_R_MISC_REG            BIT(6)
#define SD10G_LANE_LANE_94_R_MISC_REG_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_94_R_MISC_REG, x)
#define SD10G_LANE_LANE_94_R_MISC_REG_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_94_R_MISC_REG, x)

#define SD10G_LANE_LANE_94_R_SWING_REG           BIT(7)
#define SD10G_LANE_LANE_94_R_SWING_REG_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_94_R_SWING_REG, x)
#define SD10G_LANE_LANE_94_R_SWING_REG_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_94_R_SWING_REG, x)

/*      SD10G_LANE_TARGET:LANE_GRP_5:LANE_9E */
#define SD10G_LANE_LANE_9E(t)     __REG(TARGET_SD10G_LANE, t, 12, 576, 0, 1, 64, 56, 0, 1, 4)

#define SD10G_LANE_LANE_9E_R_RXEQ_REG            BIT(0)
#define SD10G_LANE_LANE_9E_R_RXEQ_REG_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_9E_R_RXEQ_REG, x)
#define SD10G_LANE_LANE_9E_R_RXEQ_REG_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_9E_R_RXEQ_REG, x)

#define SD10G_LANE_LANE_9E_R_AUTO_RST_TREE_PD_MAN BIT(1)
#define SD10G_LANE_LANE_9E_R_AUTO_RST_TREE_PD_MAN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_9E_R_AUTO_RST_TREE_PD_MAN, x)
#define SD10G_LANE_LANE_9E_R_AUTO_RST_TREE_PD_MAN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_9E_R_AUTO_RST_TREE_PD_MAN, x)

#define SD10G_LANE_LANE_9E_R_EN_AUTO_CDR_RSTN    BIT(2)
#define SD10G_LANE_LANE_9E_R_EN_AUTO_CDR_RSTN_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_9E_R_EN_AUTO_CDR_RSTN, x)
#define SD10G_LANE_LANE_9E_R_EN_AUTO_CDR_RSTN_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_9E_R_EN_AUTO_CDR_RSTN, x)

/*      SD10G_LANE_TARGET:LANE_GRP_6:LANE_A1 */
#define SD10G_LANE_LANE_A1(t)     __REG(TARGET_SD10G_LANE, t, 12, 640, 0, 1, 128, 4, 0, 1, 4)

#define SD10G_LANE_LANE_A1_R_PMA_TXCK_DIV_SEL_1_0 GENMASK(1, 0)
#define SD10G_LANE_LANE_A1_R_PMA_TXCK_DIV_SEL_1_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_A1_R_PMA_TXCK_DIV_SEL_1_0, x)
#define SD10G_LANE_LANE_A1_R_PMA_TXCK_DIV_SEL_1_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_A1_R_PMA_TXCK_DIV_SEL_1_0, x)

#define SD10G_LANE_LANE_A1_R_SSC_FROM_HWT        BIT(4)
#define SD10G_LANE_LANE_A1_R_SSC_FROM_HWT_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_A1_R_SSC_FROM_HWT, x)
#define SD10G_LANE_LANE_A1_R_SSC_FROM_HWT_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_A1_R_SSC_FROM_HWT, x)

#define SD10G_LANE_LANE_A1_R_CDR_FROM_HWT        BIT(5)
#define SD10G_LANE_LANE_A1_R_CDR_FROM_HWT_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_A1_R_CDR_FROM_HWT, x)
#define SD10G_LANE_LANE_A1_R_CDR_FROM_HWT_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_A1_R_CDR_FROM_HWT, x)

#define SD10G_LANE_LANE_A1_R_PCLK_GATING_FROM_HWT BIT(6)
#define SD10G_LANE_LANE_A1_R_PCLK_GATING_FROM_HWT_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_A1_R_PCLK_GATING_FROM_HWT, x)
#define SD10G_LANE_LANE_A1_R_PCLK_GATING_FROM_HWT_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_A1_R_PCLK_GATING_FROM_HWT, x)

#define SD10G_LANE_LANE_A1_R_PCLK_GATING         BIT(7)
#define SD10G_LANE_LANE_A1_R_PCLK_GATING_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_A1_R_PCLK_GATING, x)
#define SD10G_LANE_LANE_A1_R_PCLK_GATING_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_A1_R_PCLK_GATING, x)

/*      SD10G_LANE_TARGET:LANE_GRP_6:LANE_A2 */
#define SD10G_LANE_LANE_A2(t)     __REG(TARGET_SD10G_LANE, t, 12, 640, 0, 1, 128, 8, 0, 1, 4)

#define SD10G_LANE_LANE_A2_R_PCS2PMA_PHYMODE_4_0 GENMASK(4, 0)
#define SD10G_LANE_LANE_A2_R_PCS2PMA_PHYMODE_4_0_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_A2_R_PCS2PMA_PHYMODE_4_0, x)
#define SD10G_LANE_LANE_A2_R_PCS2PMA_PHYMODE_4_0_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_A2_R_PCS2PMA_PHYMODE_4_0, x)

/*      SD10G_LANE_TARGET:LANE_GRP_8:LANE_DF */
#define SD10G_LANE_LANE_DF(t)     __REG(TARGET_SD10G_LANE, t, 12, 832, 0, 1, 84, 60, 0, 1, 4)

#define SD10G_LANE_LANE_DF_LOL_UDL               BIT(0)
#define SD10G_LANE_LANE_DF_LOL_UDL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_DF_LOL_UDL, x)
#define SD10G_LANE_LANE_DF_LOL_UDL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_DF_LOL_UDL, x)

#define SD10G_LANE_LANE_DF_LOL                   BIT(1)
#define SD10G_LANE_LANE_DF_LOL_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_DF_LOL, x)
#define SD10G_LANE_LANE_DF_LOL_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_DF_LOL, x)

#define SD10G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED BIT(2)
#define SD10G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED, x)
#define SD10G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED, x)

#define SD10G_LANE_LANE_DF_SQUELCH               BIT(3)
#define SD10G_LANE_LANE_DF_SQUELCH_SET(x)\
	FIELD_PREP(SD10G_LANE_LANE_DF_SQUELCH, x)
#define SD10G_LANE_LANE_DF_SQUELCH_GET(x)\
	FIELD_GET(SD10G_LANE_LANE_DF_SQUELCH, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_09 */
#define SD25G_LANE_CMU_09(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 36, 0, 1, 4)

#define SD25G_LANE_CMU_09_CFG_REFCK_TERM_EN      BIT(0)
#define SD25G_LANE_CMU_09_CFG_REFCK_TERM_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_09_CFG_REFCK_TERM_EN, x)
#define SD25G_LANE_CMU_09_CFG_REFCK_TERM_EN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_09_CFG_REFCK_TERM_EN, x)

#define SD25G_LANE_CMU_09_CFG_EN_DUMMY           BIT(1)
#define SD25G_LANE_CMU_09_CFG_EN_DUMMY_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_09_CFG_EN_DUMMY, x)
#define SD25G_LANE_CMU_09_CFG_EN_DUMMY_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_09_CFG_EN_DUMMY, x)

#define SD25G_LANE_CMU_09_CFG_PLL_LOS_SET        BIT(2)
#define SD25G_LANE_CMU_09_CFG_PLL_LOS_SET_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_09_CFG_PLL_LOS_SET, x)
#define SD25G_LANE_CMU_09_CFG_PLL_LOS_SET_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_09_CFG_PLL_LOS_SET, x)

#define SD25G_LANE_CMU_09_CFG_CTRL_LOGIC_PD      BIT(3)
#define SD25G_LANE_CMU_09_CFG_CTRL_LOGIC_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_09_CFG_CTRL_LOGIC_PD, x)
#define SD25G_LANE_CMU_09_CFG_CTRL_LOGIC_PD_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_09_CFG_CTRL_LOGIC_PD, x)

#define SD25G_LANE_CMU_09_CFG_PLL_TP_SEL_1_0     GENMASK(5, 4)
#define SD25G_LANE_CMU_09_CFG_PLL_TP_SEL_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_09_CFG_PLL_TP_SEL_1_0, x)
#define SD25G_LANE_CMU_09_CFG_PLL_TP_SEL_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_09_CFG_PLL_TP_SEL_1_0, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_0B */
#define SD25G_LANE_CMU_0B(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 44, 0, 1, 4)

#define SD25G_LANE_CMU_0B_CFG_FORCE_RX_FILT      BIT(0)
#define SD25G_LANE_CMU_0B_CFG_FORCE_RX_FILT_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_FORCE_RX_FILT, x)
#define SD25G_LANE_CMU_0B_CFG_FORCE_RX_FILT_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_FORCE_RX_FILT, x)

#define SD25G_LANE_CMU_0B_CFG_DISLOL             BIT(1)
#define SD25G_LANE_CMU_0B_CFG_DISLOL_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_DISLOL, x)
#define SD25G_LANE_CMU_0B_CFG_DISLOL_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_DISLOL, x)

#define SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN_EN BIT(2)
#define SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN_EN, x)
#define SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN_EN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN_EN, x)

#define SD25G_LANE_CMU_0B_CFG_VCO_CAL_RESETN     BIT(3)
#define SD25G_LANE_CMU_0B_CFG_VCO_CAL_RESETN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_VCO_CAL_RESETN, x)
#define SD25G_LANE_CMU_0B_CFG_VCO_CAL_RESETN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_VCO_CAL_RESETN, x)

#define SD25G_LANE_CMU_0B_CFG_VFILT2PAD          BIT(4)
#define SD25G_LANE_CMU_0B_CFG_VFILT2PAD_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_VFILT2PAD, x)
#define SD25G_LANE_CMU_0B_CFG_VFILT2PAD_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_VFILT2PAD, x)

#define SD25G_LANE_CMU_0B_CFG_DISLOS             BIT(5)
#define SD25G_LANE_CMU_0B_CFG_DISLOS_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_DISLOS, x)
#define SD25G_LANE_CMU_0B_CFG_DISLOS_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_DISLOS, x)

#define SD25G_LANE_CMU_0B_CFG_DCLOL              BIT(6)
#define SD25G_LANE_CMU_0B_CFG_DCLOL_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_DCLOL, x)
#define SD25G_LANE_CMU_0B_CFG_DCLOL_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_DCLOL, x)

#define SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN    BIT(7)
#define SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN, x)
#define SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0B_CFG_RST_TREE_PD_MAN, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_0C */
#define SD25G_LANE_CMU_0C(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 48, 0, 1, 4)

#define SD25G_LANE_CMU_0C_CFG_PLL_LOL_SET        BIT(0)
#define SD25G_LANE_CMU_0C_CFG_PLL_LOL_SET_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0C_CFG_PLL_LOL_SET, x)
#define SD25G_LANE_CMU_0C_CFG_PLL_LOL_SET_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0C_CFG_PLL_LOL_SET, x)

#define SD25G_LANE_CMU_0C_CFG_EN_TX_CK_DN        BIT(1)
#define SD25G_LANE_CMU_0C_CFG_EN_TX_CK_DN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0C_CFG_EN_TX_CK_DN, x)
#define SD25G_LANE_CMU_0C_CFG_EN_TX_CK_DN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0C_CFG_EN_TX_CK_DN, x)

#define SD25G_LANE_CMU_0C_CFG_VCO_PD             BIT(2)
#define SD25G_LANE_CMU_0C_CFG_VCO_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0C_CFG_VCO_PD, x)
#define SD25G_LANE_CMU_0C_CFG_VCO_PD_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0C_CFG_VCO_PD, x)

#define SD25G_LANE_CMU_0C_CFG_EN_TX_CK_UP        BIT(3)
#define SD25G_LANE_CMU_0C_CFG_EN_TX_CK_UP_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0C_CFG_EN_TX_CK_UP, x)
#define SD25G_LANE_CMU_0C_CFG_EN_TX_CK_UP_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0C_CFG_EN_TX_CK_UP, x)

#define SD25G_LANE_CMU_0C_CFG_VCO_DIV_MODE_1_0   GENMASK(5, 4)
#define SD25G_LANE_CMU_0C_CFG_VCO_DIV_MODE_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0C_CFG_VCO_DIV_MODE_1_0, x)
#define SD25G_LANE_CMU_0C_CFG_VCO_DIV_MODE_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0C_CFG_VCO_DIV_MODE_1_0, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_0D */
#define SD25G_LANE_CMU_0D(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 52, 0, 1, 4)

#define SD25G_LANE_CMU_0D_CFG_CK_TREE_PD         BIT(0)
#define SD25G_LANE_CMU_0D_CFG_CK_TREE_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0D_CFG_CK_TREE_PD, x)
#define SD25G_LANE_CMU_0D_CFG_CK_TREE_PD_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0D_CFG_CK_TREE_PD, x)

#define SD25G_LANE_CMU_0D_CFG_EN_RX_CK_DN        BIT(1)
#define SD25G_LANE_CMU_0D_CFG_EN_RX_CK_DN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0D_CFG_EN_RX_CK_DN, x)
#define SD25G_LANE_CMU_0D_CFG_EN_RX_CK_DN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0D_CFG_EN_RX_CK_DN, x)

#define SD25G_LANE_CMU_0D_CFG_EN_RX_CK_UP        BIT(2)
#define SD25G_LANE_CMU_0D_CFG_EN_RX_CK_UP_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0D_CFG_EN_RX_CK_UP, x)
#define SD25G_LANE_CMU_0D_CFG_EN_RX_CK_UP_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0D_CFG_EN_RX_CK_UP, x)

#define SD25G_LANE_CMU_0D_CFG_VCO_CAL_BYP        BIT(3)
#define SD25G_LANE_CMU_0D_CFG_VCO_CAL_BYP_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0D_CFG_VCO_CAL_BYP, x)
#define SD25G_LANE_CMU_0D_CFG_VCO_CAL_BYP_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0D_CFG_VCO_CAL_BYP, x)

#define SD25G_LANE_CMU_0D_CFG_PRE_DIVSEL_1_0     GENMASK(5, 4)
#define SD25G_LANE_CMU_0D_CFG_PRE_DIVSEL_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0D_CFG_PRE_DIVSEL_1_0, x)
#define SD25G_LANE_CMU_0D_CFG_PRE_DIVSEL_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0D_CFG_PRE_DIVSEL_1_0, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_0E */
#define SD25G_LANE_CMU_0E(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 56, 0, 1, 4)

#define SD25G_LANE_CMU_0E_CFG_SEL_DIV_3_0        GENMASK(3, 0)
#define SD25G_LANE_CMU_0E_CFG_SEL_DIV_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0E_CFG_SEL_DIV_3_0, x)
#define SD25G_LANE_CMU_0E_CFG_SEL_DIV_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0E_CFG_SEL_DIV_3_0, x)

#define SD25G_LANE_CMU_0E_CFG_PMAA_CENTR_CK_PD   BIT(4)
#define SD25G_LANE_CMU_0E_CFG_PMAA_CENTR_CK_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_0E_CFG_PMAA_CENTR_CK_PD, x)
#define SD25G_LANE_CMU_0E_CFG_PMAA_CENTR_CK_PD_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_0E_CFG_PMAA_CENTR_CK_PD, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_13 */
#define SD25G_LANE_CMU_13(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 76, 0, 1, 4)

#define SD25G_LANE_CMU_13_CFG_PLL_RESERVE_3_0    GENMASK(3, 0)
#define SD25G_LANE_CMU_13_CFG_PLL_RESERVE_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_13_CFG_PLL_RESERVE_3_0, x)
#define SD25G_LANE_CMU_13_CFG_PLL_RESERVE_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_13_CFG_PLL_RESERVE_3_0, x)

#define SD25G_LANE_CMU_13_CFG_JT_EN              BIT(4)
#define SD25G_LANE_CMU_13_CFG_JT_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_13_CFG_JT_EN, x)
#define SD25G_LANE_CMU_13_CFG_JT_EN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_13_CFG_JT_EN, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_18 */
#define SD25G_LANE_CMU_18(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 96, 0, 1, 4)

#define SD25G_LANE_CMU_18_R_PLL_RSTN             BIT(0)
#define SD25G_LANE_CMU_18_R_PLL_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_18_R_PLL_RSTN, x)
#define SD25G_LANE_CMU_18_R_PLL_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_18_R_PLL_RSTN, x)

#define SD25G_LANE_CMU_18_R_PLL_LOL_SET          BIT(1)
#define SD25G_LANE_CMU_18_R_PLL_LOL_SET_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_18_R_PLL_LOL_SET, x)
#define SD25G_LANE_CMU_18_R_PLL_LOL_SET_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_18_R_PLL_LOL_SET, x)

#define SD25G_LANE_CMU_18_R_PLL_LOS_SET          BIT(2)
#define SD25G_LANE_CMU_18_R_PLL_LOS_SET_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_18_R_PLL_LOS_SET, x)
#define SD25G_LANE_CMU_18_R_PLL_LOS_SET_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_18_R_PLL_LOS_SET, x)

#define SD25G_LANE_CMU_18_R_PLL_TP_SEL_1_0       GENMASK(5, 4)
#define SD25G_LANE_CMU_18_R_PLL_TP_SEL_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_18_R_PLL_TP_SEL_1_0, x)
#define SD25G_LANE_CMU_18_R_PLL_TP_SEL_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_18_R_PLL_TP_SEL_1_0, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_19 */
#define SD25G_LANE_CMU_19(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 100, 0, 1, 4)

#define SD25G_LANE_CMU_19_R_CK_RESETB            BIT(0)
#define SD25G_LANE_CMU_19_R_CK_RESETB_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_19_R_CK_RESETB, x)
#define SD25G_LANE_CMU_19_R_CK_RESETB_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_19_R_CK_RESETB, x)

#define SD25G_LANE_CMU_19_R_PLL_DLOL_EN          BIT(1)
#define SD25G_LANE_CMU_19_R_PLL_DLOL_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_19_R_PLL_DLOL_EN, x)
#define SD25G_LANE_CMU_19_R_PLL_DLOL_EN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_19_R_PLL_DLOL_EN, x)

/*      SD25G_TARGET:CMU_GRP_0:CMU_1A */
#define SD25G_LANE_CMU_1A(t)      __REG(TARGET_SD25G_LANE, t, 8, 0, 0, 1, 132, 104, 0, 1, 4)

#define SD25G_LANE_CMU_1A_R_DWIDTHCTRL_2_0       GENMASK(2, 0)
#define SD25G_LANE_CMU_1A_R_DWIDTHCTRL_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_1A_R_DWIDTHCTRL_2_0, x)
#define SD25G_LANE_CMU_1A_R_DWIDTHCTRL_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_1A_R_DWIDTHCTRL_2_0, x)

#define SD25G_LANE_CMU_1A_R_DWIDTHCTRL_FROM_HWT  BIT(4)
#define SD25G_LANE_CMU_1A_R_DWIDTHCTRL_FROM_HWT_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_1A_R_DWIDTHCTRL_FROM_HWT, x)
#define SD25G_LANE_CMU_1A_R_DWIDTHCTRL_FROM_HWT_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_1A_R_DWIDTHCTRL_FROM_HWT, x)

#define SD25G_LANE_CMU_1A_R_MASK_EI_SOURCE       BIT(5)
#define SD25G_LANE_CMU_1A_R_MASK_EI_SOURCE_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_1A_R_MASK_EI_SOURCE, x)
#define SD25G_LANE_CMU_1A_R_MASK_EI_SOURCE_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_1A_R_MASK_EI_SOURCE, x)

#define SD25G_LANE_CMU_1A_R_REG_MANUAL           BIT(6)
#define SD25G_LANE_CMU_1A_R_REG_MANUAL_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_1A_R_REG_MANUAL, x)
#define SD25G_LANE_CMU_1A_R_REG_MANUAL_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_1A_R_REG_MANUAL, x)

/*      SD25G_TARGET:CMU_GRP_1:CMU_2A */
#define SD25G_LANE_CMU_2A(t)      __REG(TARGET_SD25G_LANE, t, 8, 132, 0, 1, 124, 36, 0, 1, 4)

#define SD25G_LANE_CMU_2A_R_DBG_SEL_1_0          GENMASK(1, 0)
#define SD25G_LANE_CMU_2A_R_DBG_SEL_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_2A_R_DBG_SEL_1_0, x)
#define SD25G_LANE_CMU_2A_R_DBG_SEL_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_2A_R_DBG_SEL_1_0, x)

#define SD25G_LANE_CMU_2A_R_DBG_LINK_LANE        BIT(4)
#define SD25G_LANE_CMU_2A_R_DBG_LINK_LANE_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_2A_R_DBG_LINK_LANE, x)
#define SD25G_LANE_CMU_2A_R_DBG_LINK_LANE_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_2A_R_DBG_LINK_LANE, x)

#define SD25G_LANE_CMU_2A_R_DBG_LOL_STATUS       BIT(5)
#define SD25G_LANE_CMU_2A_R_DBG_LOL_STATUS_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_2A_R_DBG_LOL_STATUS, x)
#define SD25G_LANE_CMU_2A_R_DBG_LOL_STATUS_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_2A_R_DBG_LOL_STATUS, x)

/*      SD25G_TARGET:CMU_GRP_1:CMU_30 */
#define SD25G_LANE_CMU_30(t)      __REG(TARGET_SD25G_LANE, t, 8, 132, 0, 1, 124, 60, 0, 1, 4)

#define SD25G_LANE_CMU_30_R_TXFIFO_CK_DIV_PMAD_2_0 GENMASK(2, 0)
#define SD25G_LANE_CMU_30_R_TXFIFO_CK_DIV_PMAD_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_30_R_TXFIFO_CK_DIV_PMAD_2_0, x)
#define SD25G_LANE_CMU_30_R_TXFIFO_CK_DIV_PMAD_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_30_R_TXFIFO_CK_DIV_PMAD_2_0, x)

#define SD25G_LANE_CMU_30_R_RXFIFO_CK_DIV_PMAD_2_0 GENMASK(6, 4)
#define SD25G_LANE_CMU_30_R_RXFIFO_CK_DIV_PMAD_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_30_R_RXFIFO_CK_DIV_PMAD_2_0, x)
#define SD25G_LANE_CMU_30_R_RXFIFO_CK_DIV_PMAD_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_30_R_RXFIFO_CK_DIV_PMAD_2_0, x)

/*      SD25G_TARGET:CMU_GRP_1:CMU_31 */
#define SD25G_LANE_CMU_31(t)      __REG(TARGET_SD25G_LANE, t, 8, 132, 0, 1, 124, 64, 0, 1, 4)

#define SD25G_LANE_CMU_31_CFG_COMMON_RESERVE_7_0 GENMASK(7, 0)
#define SD25G_LANE_CMU_31_CFG_COMMON_RESERVE_7_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_31_CFG_COMMON_RESERVE_7_0, x)
#define SD25G_LANE_CMU_31_CFG_COMMON_RESERVE_7_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_31_CFG_COMMON_RESERVE_7_0, x)

/*      SD25G_TARGET:CMU_GRP_2:CMU_40 */
#define SD25G_LANE_CMU_40(t)      __REG(TARGET_SD25G_LANE, t, 8, 256, 0, 1, 512, 0, 0, 1, 4)

#define SD25G_LANE_CMU_40_L0_CFG_CKSKEW_CTRL     BIT(0)
#define SD25G_LANE_CMU_40_L0_CFG_CKSKEW_CTRL_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_40_L0_CFG_CKSKEW_CTRL, x)
#define SD25G_LANE_CMU_40_L0_CFG_CKSKEW_CTRL_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_40_L0_CFG_CKSKEW_CTRL, x)

#define SD25G_LANE_CMU_40_L0_CFG_ISCAN_HOLD      BIT(1)
#define SD25G_LANE_CMU_40_L0_CFG_ISCAN_HOLD_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_40_L0_CFG_ISCAN_HOLD, x)
#define SD25G_LANE_CMU_40_L0_CFG_ISCAN_HOLD_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_40_L0_CFG_ISCAN_HOLD, x)

#define SD25G_LANE_CMU_40_L0_CFG_PD_CLK          BIT(2)
#define SD25G_LANE_CMU_40_L0_CFG_PD_CLK_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_40_L0_CFG_PD_CLK, x)
#define SD25G_LANE_CMU_40_L0_CFG_PD_CLK_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_40_L0_CFG_PD_CLK, x)

#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_EN        BIT(3)
#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_40_L0_CFG_TXCAL_EN, x)
#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_EN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_40_L0_CFG_TXCAL_EN, x)

#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_MAN_EN    BIT(4)
#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_MAN_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_40_L0_CFG_TXCAL_MAN_EN, x)
#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_MAN_EN_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_40_L0_CFG_TXCAL_MAN_EN, x)

#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_RST       BIT(5)
#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_RST_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_40_L0_CFG_TXCAL_RST, x)
#define SD25G_LANE_CMU_40_L0_CFG_TXCAL_RST_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_40_L0_CFG_TXCAL_RST, x)

/*      SD25G_TARGET:CMU_GRP_2:CMU_45 */
#define SD25G_LANE_CMU_45(t)      __REG(TARGET_SD25G_LANE, t, 8, 256, 0, 1, 512, 20, 0, 1, 4)

#define SD25G_LANE_CMU_45_L0_CFG_TX_RESERVE_7_0  GENMASK(7, 0)
#define SD25G_LANE_CMU_45_L0_CFG_TX_RESERVE_7_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_45_L0_CFG_TX_RESERVE_7_0, x)
#define SD25G_LANE_CMU_45_L0_CFG_TX_RESERVE_7_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_45_L0_CFG_TX_RESERVE_7_0, x)

/*      SD25G_TARGET:CMU_GRP_2:CMU_46 */
#define SD25G_LANE_CMU_46(t)      __REG(TARGET_SD25G_LANE, t, 8, 256, 0, 1, 512, 24, 0, 1, 4)

#define SD25G_LANE_CMU_46_L0_CFG_TX_RESERVE_15_8 GENMASK(7, 0)
#define SD25G_LANE_CMU_46_L0_CFG_TX_RESERVE_15_8_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_46_L0_CFG_TX_RESERVE_15_8, x)
#define SD25G_LANE_CMU_46_L0_CFG_TX_RESERVE_15_8_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_46_L0_CFG_TX_RESERVE_15_8, x)

/*      SD25G_TARGET:CMU_GRP_3:CMU_C0 */
#define SD25G_LANE_CMU_C0(t)      __REG(TARGET_SD25G_LANE, t, 8, 768, 0, 1, 252, 0, 0, 1, 4)

#define SD25G_LANE_CMU_C0_READ_VCO_CTUNE_3_0     GENMASK(3, 0)
#define SD25G_LANE_CMU_C0_READ_VCO_CTUNE_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_C0_READ_VCO_CTUNE_3_0, x)
#define SD25G_LANE_CMU_C0_READ_VCO_CTUNE_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_C0_READ_VCO_CTUNE_3_0, x)

#define SD25G_LANE_CMU_C0_PLL_LOL_UDL            BIT(4)
#define SD25G_LANE_CMU_C0_PLL_LOL_UDL_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_C0_PLL_LOL_UDL, x)
#define SD25G_LANE_CMU_C0_PLL_LOL_UDL_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_C0_PLL_LOL_UDL, x)

/*      SD25G_TARGET:CMU_GRP_4:CMU_FF */
#define SD25G_LANE_CMU_FF(t)      __REG(TARGET_SD25G_LANE, t, 8, 1020, 0, 1, 4, 0, 0, 1, 4)

#define SD25G_LANE_CMU_FF_REGISTER_TABLE_INDEX   GENMASK(7, 0)
#define SD25G_LANE_CMU_FF_REGISTER_TABLE_INDEX_SET(x)\
	FIELD_PREP(SD25G_LANE_CMU_FF_REGISTER_TABLE_INDEX, x)
#define SD25G_LANE_CMU_FF_REGISTER_TABLE_INDEX_GET(x)\
	FIELD_GET(SD25G_LANE_CMU_FF_REGISTER_TABLE_INDEX, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_00 */
#define SD25G_LANE_LANE_00(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 0, 0, 1, 4)

#define SD25G_LANE_LANE_00_LN_CFG_ITX_VC_DRIVER_3_0 GENMASK(3, 0)
#define SD25G_LANE_LANE_00_LN_CFG_ITX_VC_DRIVER_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_00_LN_CFG_ITX_VC_DRIVER_3_0, x)
#define SD25G_LANE_LANE_00_LN_CFG_ITX_VC_DRIVER_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_00_LN_CFG_ITX_VC_DRIVER_3_0, x)

#define SD25G_LANE_LANE_00_LN_CFG_ITX_IPCML_BASE_1_0 GENMASK(5, 4)
#define SD25G_LANE_LANE_00_LN_CFG_ITX_IPCML_BASE_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_00_LN_CFG_ITX_IPCML_BASE_1_0, x)
#define SD25G_LANE_LANE_00_LN_CFG_ITX_IPCML_BASE_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_00_LN_CFG_ITX_IPCML_BASE_1_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_01 */
#define SD25G_LANE_LANE_01(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 4, 0, 1, 4)

#define SD25G_LANE_LANE_01_LN_CFG_ITX_IPDRIVER_BASE_2_0 GENMASK(2, 0)
#define SD25G_LANE_LANE_01_LN_CFG_ITX_IPDRIVER_BASE_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_01_LN_CFG_ITX_IPDRIVER_BASE_2_0, x)
#define SD25G_LANE_LANE_01_LN_CFG_ITX_IPDRIVER_BASE_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_01_LN_CFG_ITX_IPDRIVER_BASE_2_0, x)

#define SD25G_LANE_LANE_01_LN_CFG_TX_PREDIV_1_0  GENMASK(5, 4)
#define SD25G_LANE_LANE_01_LN_CFG_TX_PREDIV_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_01_LN_CFG_TX_PREDIV_1_0, x)
#define SD25G_LANE_LANE_01_LN_CFG_TX_PREDIV_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_01_LN_CFG_TX_PREDIV_1_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_03 */
#define SD25G_LANE_LANE_03(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 12, 0, 1, 4)

#define SD25G_LANE_LANE_03_LN_CFG_TAP_DLY_4_0    GENMASK(4, 0)
#define SD25G_LANE_LANE_03_LN_CFG_TAP_DLY_4_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_03_LN_CFG_TAP_DLY_4_0, x)
#define SD25G_LANE_LANE_03_LN_CFG_TAP_DLY_4_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_03_LN_CFG_TAP_DLY_4_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_04 */
#define SD25G_LANE_LANE_04(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 16, 0, 1, 4)

#define SD25G_LANE_LANE_04_LN_CFG_TX2RX_LP_EN    BIT(0)
#define SD25G_LANE_LANE_04_LN_CFG_TX2RX_LP_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_04_LN_CFG_TX2RX_LP_EN, x)
#define SD25G_LANE_LANE_04_LN_CFG_TX2RX_LP_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_04_LN_CFG_TX2RX_LP_EN, x)

#define SD25G_LANE_LANE_04_LN_CFG_RX2TX_LP_EN    BIT(1)
#define SD25G_LANE_LANE_04_LN_CFG_RX2TX_LP_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_04_LN_CFG_RX2TX_LP_EN, x)
#define SD25G_LANE_LANE_04_LN_CFG_RX2TX_LP_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_04_LN_CFG_RX2TX_LP_EN, x)

#define SD25G_LANE_LANE_04_LN_CFG_PD_CML         BIT(2)
#define SD25G_LANE_LANE_04_LN_CFG_PD_CML_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_04_LN_CFG_PD_CML, x)
#define SD25G_LANE_LANE_04_LN_CFG_PD_CML_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_04_LN_CFG_PD_CML, x)

#define SD25G_LANE_LANE_04_LN_CFG_PD_CLK         BIT(3)
#define SD25G_LANE_LANE_04_LN_CFG_PD_CLK_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_04_LN_CFG_PD_CLK, x)
#define SD25G_LANE_LANE_04_LN_CFG_PD_CLK_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_04_LN_CFG_PD_CLK, x)

#define SD25G_LANE_LANE_04_LN_CFG_PD_DRIVER      BIT(4)
#define SD25G_LANE_LANE_04_LN_CFG_PD_DRIVER_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_04_LN_CFG_PD_DRIVER, x)
#define SD25G_LANE_LANE_04_LN_CFG_PD_DRIVER_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_04_LN_CFG_PD_DRIVER, x)

#define SD25G_LANE_LANE_04_LN_CFG_TAP_MAIN       BIT(5)
#define SD25G_LANE_LANE_04_LN_CFG_TAP_MAIN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_04_LN_CFG_TAP_MAIN, x)
#define SD25G_LANE_LANE_04_LN_CFG_TAP_MAIN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_04_LN_CFG_TAP_MAIN, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_05 */
#define SD25G_LANE_LANE_05(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 20, 0, 1, 4)

#define SD25G_LANE_LANE_05_LN_CFG_TAP_DLY2_3_0   GENMASK(3, 0)
#define SD25G_LANE_LANE_05_LN_CFG_TAP_DLY2_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_05_LN_CFG_TAP_DLY2_3_0, x)
#define SD25G_LANE_LANE_05_LN_CFG_TAP_DLY2_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_05_LN_CFG_TAP_DLY2_3_0, x)

#define SD25G_LANE_LANE_05_LN_CFG_BW_1_0         GENMASK(5, 4)
#define SD25G_LANE_LANE_05_LN_CFG_BW_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_05_LN_CFG_BW_1_0, x)
#define SD25G_LANE_LANE_05_LN_CFG_BW_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_05_LN_CFG_BW_1_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_06 */
#define SD25G_LANE_LANE_06(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 24, 0, 1, 4)

#define SD25G_LANE_LANE_06_LN_CFG_EN_MAIN        BIT(0)
#define SD25G_LANE_LANE_06_LN_CFG_EN_MAIN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_06_LN_CFG_EN_MAIN, x)
#define SD25G_LANE_LANE_06_LN_CFG_EN_MAIN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_06_LN_CFG_EN_MAIN, x)

#define SD25G_LANE_LANE_06_LN_CFG_TAP_ADV_3_0    GENMASK(7, 4)
#define SD25G_LANE_LANE_06_LN_CFG_TAP_ADV_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_06_LN_CFG_TAP_ADV_3_0, x)
#define SD25G_LANE_LANE_06_LN_CFG_TAP_ADV_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_06_LN_CFG_TAP_ADV_3_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_07 */
#define SD25G_LANE_LANE_07(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 28, 0, 1, 4)

#define SD25G_LANE_LANE_07_LN_CFG_EN_ADV         BIT(0)
#define SD25G_LANE_LANE_07_LN_CFG_EN_ADV_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_07_LN_CFG_EN_ADV, x)
#define SD25G_LANE_LANE_07_LN_CFG_EN_ADV_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_07_LN_CFG_EN_ADV, x)

#define SD25G_LANE_LANE_07_LN_CFG_EN_DLY2        BIT(1)
#define SD25G_LANE_LANE_07_LN_CFG_EN_DLY2_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_07_LN_CFG_EN_DLY2, x)
#define SD25G_LANE_LANE_07_LN_CFG_EN_DLY2_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_07_LN_CFG_EN_DLY2, x)

#define SD25G_LANE_LANE_07_LN_CFG_EN_DLY         BIT(2)
#define SD25G_LANE_LANE_07_LN_CFG_EN_DLY_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_07_LN_CFG_EN_DLY, x)
#define SD25G_LANE_LANE_07_LN_CFG_EN_DLY_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_07_LN_CFG_EN_DLY, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_09 */
#define SD25G_LANE_LANE_09(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 36, 0, 1, 4)

#define SD25G_LANE_LANE_09_LN_CFG_TXCAL_VALID_SEL_3_0 GENMASK(3, 0)
#define SD25G_LANE_LANE_09_LN_CFG_TXCAL_VALID_SEL_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_09_LN_CFG_TXCAL_VALID_SEL_3_0, x)
#define SD25G_LANE_LANE_09_LN_CFG_TXCAL_VALID_SEL_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_09_LN_CFG_TXCAL_VALID_SEL_3_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_0A */
#define SD25G_LANE_LANE_0A(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 40, 0, 1, 4)

#define SD25G_LANE_LANE_0A_LN_CFG_TXCAL_SHIFT_CODE_5_0 GENMASK(5, 0)
#define SD25G_LANE_LANE_0A_LN_CFG_TXCAL_SHIFT_CODE_5_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0A_LN_CFG_TXCAL_SHIFT_CODE_5_0, x)
#define SD25G_LANE_LANE_0A_LN_CFG_TXCAL_SHIFT_CODE_5_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0A_LN_CFG_TXCAL_SHIFT_CODE_5_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_0B */
#define SD25G_LANE_LANE_0B(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 44, 0, 1, 4)

#define SD25G_LANE_LANE_0B_LN_CFG_TXCAL_MAN_EN   BIT(0)
#define SD25G_LANE_LANE_0B_LN_CFG_TXCAL_MAN_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0B_LN_CFG_TXCAL_MAN_EN, x)
#define SD25G_LANE_LANE_0B_LN_CFG_TXCAL_MAN_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0B_LN_CFG_TXCAL_MAN_EN, x)

#define SD25G_LANE_LANE_0B_LN_CFG_TXCAL_RST      BIT(1)
#define SD25G_LANE_LANE_0B_LN_CFG_TXCAL_RST_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0B_LN_CFG_TXCAL_RST, x)
#define SD25G_LANE_LANE_0B_LN_CFG_TXCAL_RST_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0B_LN_CFG_TXCAL_RST, x)

#define SD25G_LANE_LANE_0B_LN_CFG_QUAD_MAN_1_0   GENMASK(5, 4)
#define SD25G_LANE_LANE_0B_LN_CFG_QUAD_MAN_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0B_LN_CFG_QUAD_MAN_1_0, x)
#define SD25G_LANE_LANE_0B_LN_CFG_QUAD_MAN_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0B_LN_CFG_QUAD_MAN_1_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_0C */
#define SD25G_LANE_LANE_0C(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 48, 0, 1, 4)

#define SD25G_LANE_LANE_0C_LN_CFG_PMA_TX_CK_BITWIDTH_2_0 GENMASK(2, 0)
#define SD25G_LANE_LANE_0C_LN_CFG_PMA_TX_CK_BITWIDTH_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0C_LN_CFG_PMA_TX_CK_BITWIDTH_2_0, x)
#define SD25G_LANE_LANE_0C_LN_CFG_PMA_TX_CK_BITWIDTH_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0C_LN_CFG_PMA_TX_CK_BITWIDTH_2_0, x)

#define SD25G_LANE_LANE_0C_LN_CFG_TXCAL_EN       BIT(4)
#define SD25G_LANE_LANE_0C_LN_CFG_TXCAL_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0C_LN_CFG_TXCAL_EN, x)
#define SD25G_LANE_LANE_0C_LN_CFG_TXCAL_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0C_LN_CFG_TXCAL_EN, x)

#define SD25G_LANE_LANE_0C_LN_CFG_RXTERM_PD      BIT(5)
#define SD25G_LANE_LANE_0C_LN_CFG_RXTERM_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0C_LN_CFG_RXTERM_PD, x)
#define SD25G_LANE_LANE_0C_LN_CFG_RXTERM_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0C_LN_CFG_RXTERM_PD, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_0D */
#define SD25G_LANE_LANE_0D(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 52, 0, 1, 4)

#define SD25G_LANE_LANE_0D_LN_CFG_RXTERM_2_0     GENMASK(2, 0)
#define SD25G_LANE_LANE_0D_LN_CFG_RXTERM_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0D_LN_CFG_RXTERM_2_0, x)
#define SD25G_LANE_LANE_0D_LN_CFG_RXTERM_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0D_LN_CFG_RXTERM_2_0, x)

#define SD25G_LANE_LANE_0D_LN_CFG_RSTN_DIV5_8    BIT(4)
#define SD25G_LANE_LANE_0D_LN_CFG_RSTN_DIV5_8_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0D_LN_CFG_RSTN_DIV5_8, x)
#define SD25G_LANE_LANE_0D_LN_CFG_RSTN_DIV5_8_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0D_LN_CFG_RSTN_DIV5_8, x)

#define SD25G_LANE_LANE_0D_LN_CFG_SUMMER_EN      BIT(5)
#define SD25G_LANE_LANE_0D_LN_CFG_SUMMER_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0D_LN_CFG_SUMMER_EN, x)
#define SD25G_LANE_LANE_0D_LN_CFG_SUMMER_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0D_LN_CFG_SUMMER_EN, x)

#define SD25G_LANE_LANE_0D_LN_CFG_DMUX_PD        BIT(6)
#define SD25G_LANE_LANE_0D_LN_CFG_DMUX_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0D_LN_CFG_DMUX_PD, x)
#define SD25G_LANE_LANE_0D_LN_CFG_DMUX_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0D_LN_CFG_DMUX_PD, x)

#define SD25G_LANE_LANE_0D_LN_CFG_DFECK_EN       BIT(7)
#define SD25G_LANE_LANE_0D_LN_CFG_DFECK_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0D_LN_CFG_DFECK_EN, x)
#define SD25G_LANE_LANE_0D_LN_CFG_DFECK_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0D_LN_CFG_DFECK_EN, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_0E */
#define SD25G_LANE_LANE_0E(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 56, 0, 1, 4)

#define SD25G_LANE_LANE_0E_LN_CFG_ISCAN_EN       BIT(0)
#define SD25G_LANE_LANE_0E_LN_CFG_ISCAN_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0E_LN_CFG_ISCAN_EN, x)
#define SD25G_LANE_LANE_0E_LN_CFG_ISCAN_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0E_LN_CFG_ISCAN_EN, x)

#define SD25G_LANE_LANE_0E_LN_CFG_DMUX_CLK_PD    BIT(1)
#define SD25G_LANE_LANE_0E_LN_CFG_DMUX_CLK_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0E_LN_CFG_DMUX_CLK_PD, x)
#define SD25G_LANE_LANE_0E_LN_CFG_DMUX_CLK_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0E_LN_CFG_DMUX_CLK_PD, x)

#define SD25G_LANE_LANE_0E_LN_CFG_EN_DFEDIG      BIT(2)
#define SD25G_LANE_LANE_0E_LN_CFG_EN_DFEDIG_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0E_LN_CFG_EN_DFEDIG, x)
#define SD25G_LANE_LANE_0E_LN_CFG_EN_DFEDIG_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0E_LN_CFG_EN_DFEDIG, x)

#define SD25G_LANE_LANE_0E_LN_CFG_DFEDIG_M_2_0   GENMASK(6, 4)
#define SD25G_LANE_LANE_0E_LN_CFG_DFEDIG_M_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0E_LN_CFG_DFEDIG_M_2_0, x)
#define SD25G_LANE_LANE_0E_LN_CFG_DFEDIG_M_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0E_LN_CFG_DFEDIG_M_2_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_0F */
#define SD25G_LANE_LANE_0F(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 60, 0, 1, 4)

#define SD25G_LANE_LANE_0F_LN_CFG_DFETAP_EN_5_1  GENMASK(4, 0)
#define SD25G_LANE_LANE_0F_LN_CFG_DFETAP_EN_5_1_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_0F_LN_CFG_DFETAP_EN_5_1, x)
#define SD25G_LANE_LANE_0F_LN_CFG_DFETAP_EN_5_1_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_0F_LN_CFG_DFETAP_EN_5_1, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_18 */
#define SD25G_LANE_LANE_18(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 96, 0, 1, 4)

#define SD25G_LANE_LANE_18_LN_CFG_CDRCK_EN       BIT(0)
#define SD25G_LANE_LANE_18_LN_CFG_CDRCK_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_18_LN_CFG_CDRCK_EN, x)
#define SD25G_LANE_LANE_18_LN_CFG_CDRCK_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_18_LN_CFG_CDRCK_EN, x)

#define SD25G_LANE_LANE_18_LN_CFG_ADD_VOLT       BIT(1)
#define SD25G_LANE_LANE_18_LN_CFG_ADD_VOLT_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_18_LN_CFG_ADD_VOLT, x)
#define SD25G_LANE_LANE_18_LN_CFG_ADD_VOLT_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_18_LN_CFG_ADD_VOLT, x)

#define SD25G_LANE_LANE_18_LN_CFG_MAN_VOLT_EN    BIT(2)
#define SD25G_LANE_LANE_18_LN_CFG_MAN_VOLT_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_18_LN_CFG_MAN_VOLT_EN, x)
#define SD25G_LANE_LANE_18_LN_CFG_MAN_VOLT_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_18_LN_CFG_MAN_VOLT_EN, x)

#define SD25G_LANE_LANE_18_LN_CFG_ERRAMP_PD      BIT(3)
#define SD25G_LANE_LANE_18_LN_CFG_ERRAMP_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_18_LN_CFG_ERRAMP_PD, x)
#define SD25G_LANE_LANE_18_LN_CFG_ERRAMP_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_18_LN_CFG_ERRAMP_PD, x)

#define SD25G_LANE_LANE_18_LN_CFG_RXDIV_SEL_2_0  GENMASK(6, 4)
#define SD25G_LANE_LANE_18_LN_CFG_RXDIV_SEL_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_18_LN_CFG_RXDIV_SEL_2_0, x)
#define SD25G_LANE_LANE_18_LN_CFG_RXDIV_SEL_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_18_LN_CFG_RXDIV_SEL_2_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_19 */
#define SD25G_LANE_LANE_19(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 100, 0, 1, 4)

#define SD25G_LANE_LANE_19_LN_CFG_DCDR_PD        BIT(0)
#define SD25G_LANE_LANE_19_LN_CFG_DCDR_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_DCDR_PD, x)
#define SD25G_LANE_LANE_19_LN_CFG_DCDR_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_DCDR_PD, x)

#define SD25G_LANE_LANE_19_LN_CFG_ECDR_PD        BIT(1)
#define SD25G_LANE_LANE_19_LN_CFG_ECDR_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_ECDR_PD, x)
#define SD25G_LANE_LANE_19_LN_CFG_ECDR_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_ECDR_PD, x)

#define SD25G_LANE_LANE_19_LN_CFG_ISCAN_SEL      BIT(2)
#define SD25G_LANE_LANE_19_LN_CFG_ISCAN_SEL_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_ISCAN_SEL, x)
#define SD25G_LANE_LANE_19_LN_CFG_ISCAN_SEL_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_ISCAN_SEL, x)

#define SD25G_LANE_LANE_19_LN_CFG_TXLB_EN        BIT(3)
#define SD25G_LANE_LANE_19_LN_CFG_TXLB_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_TXLB_EN, x)
#define SD25G_LANE_LANE_19_LN_CFG_TXLB_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_TXLB_EN, x)

#define SD25G_LANE_LANE_19_LN_CFG_RX_REG_PU      BIT(4)
#define SD25G_LANE_LANE_19_LN_CFG_RX_REG_PU_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_RX_REG_PU, x)
#define SD25G_LANE_LANE_19_LN_CFG_RX_REG_PU_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_RX_REG_PU, x)

#define SD25G_LANE_LANE_19_LN_CFG_RX_REG_BYP     BIT(5)
#define SD25G_LANE_LANE_19_LN_CFG_RX_REG_BYP_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_RX_REG_BYP, x)
#define SD25G_LANE_LANE_19_LN_CFG_RX_REG_BYP_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_RX_REG_BYP, x)

#define SD25G_LANE_LANE_19_LN_CFG_PD_RMS_DET     BIT(6)
#define SD25G_LANE_LANE_19_LN_CFG_PD_RMS_DET_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_PD_RMS_DET, x)
#define SD25G_LANE_LANE_19_LN_CFG_PD_RMS_DET_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_PD_RMS_DET, x)

#define SD25G_LANE_LANE_19_LN_CFG_PD_CTLE        BIT(7)
#define SD25G_LANE_LANE_19_LN_CFG_PD_CTLE_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_19_LN_CFG_PD_CTLE, x)
#define SD25G_LANE_LANE_19_LN_CFG_PD_CTLE_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_19_LN_CFG_PD_CTLE, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_1A */
#define SD25G_LANE_LANE_1A(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 104, 0, 1, 4)

#define SD25G_LANE_LANE_1A_LN_CFG_CTLE_TP_EN     BIT(0)
#define SD25G_LANE_LANE_1A_LN_CFG_CTLE_TP_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1A_LN_CFG_CTLE_TP_EN, x)
#define SD25G_LANE_LANE_1A_LN_CFG_CTLE_TP_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1A_LN_CFG_CTLE_TP_EN, x)

#define SD25G_LANE_LANE_1A_LN_CFG_CDR_KF_2_0     GENMASK(6, 4)
#define SD25G_LANE_LANE_1A_LN_CFG_CDR_KF_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1A_LN_CFG_CDR_KF_2_0, x)
#define SD25G_LANE_LANE_1A_LN_CFG_CDR_KF_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1A_LN_CFG_CDR_KF_2_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_1B */
#define SD25G_LANE_LANE_1B(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 108, 0, 1, 4)

#define SD25G_LANE_LANE_1B_LN_CFG_CDR_M_7_0      GENMASK(7, 0)
#define SD25G_LANE_LANE_1B_LN_CFG_CDR_M_7_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1B_LN_CFG_CDR_M_7_0, x)
#define SD25G_LANE_LANE_1B_LN_CFG_CDR_M_7_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1B_LN_CFG_CDR_M_7_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_1C */
#define SD25G_LANE_LANE_1C(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 112, 0, 1, 4)

#define SD25G_LANE_LANE_1C_LN_CFG_CDR_RSTN       BIT(0)
#define SD25G_LANE_LANE_1C_LN_CFG_CDR_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1C_LN_CFG_CDR_RSTN, x)
#define SD25G_LANE_LANE_1C_LN_CFG_CDR_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1C_LN_CFG_CDR_RSTN, x)

#define SD25G_LANE_LANE_1C_LN_CFG_DFE_PD         BIT(1)
#define SD25G_LANE_LANE_1C_LN_CFG_DFE_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1C_LN_CFG_DFE_PD, x)
#define SD25G_LANE_LANE_1C_LN_CFG_DFE_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1C_LN_CFG_DFE_PD, x)

#define SD25G_LANE_LANE_1C_LN_CFG_DFEDMX_PD      BIT(2)
#define SD25G_LANE_LANE_1C_LN_CFG_DFEDMX_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1C_LN_CFG_DFEDMX_PD, x)
#define SD25G_LANE_LANE_1C_LN_CFG_DFEDMX_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1C_LN_CFG_DFEDMX_PD, x)

#define SD25G_LANE_LANE_1C_LN_CFG_EQC_FORCE_3_0  GENMASK(7, 4)
#define SD25G_LANE_LANE_1C_LN_CFG_EQC_FORCE_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1C_LN_CFG_EQC_FORCE_3_0, x)
#define SD25G_LANE_LANE_1C_LN_CFG_EQC_FORCE_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1C_LN_CFG_EQC_FORCE_3_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_1D */
#define SD25G_LANE_LANE_1D(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 116, 0, 1, 4)

#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_EXT_OVR  BIT(0)
#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_EXT_OVR_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_ISCAN_EXT_OVR, x)
#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_EXT_OVR_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_ISCAN_EXT_OVR, x)

#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_HOLD     BIT(1)
#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_HOLD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_ISCAN_HOLD, x)
#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_HOLD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_ISCAN_HOLD, x)

#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_RSTN     BIT(2)
#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_ISCAN_RSTN, x)
#define SD25G_LANE_LANE_1D_LN_CFG_ISCAN_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_ISCAN_RSTN, x)

#define SD25G_LANE_LANE_1D_LN_CFG_AGC_ADPT_BYP   BIT(3)
#define SD25G_LANE_LANE_1D_LN_CFG_AGC_ADPT_BYP_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_AGC_ADPT_BYP, x)
#define SD25G_LANE_LANE_1D_LN_CFG_AGC_ADPT_BYP_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_AGC_ADPT_BYP, x)

#define SD25G_LANE_LANE_1D_LN_CFG_PHID_1T        BIT(4)
#define SD25G_LANE_LANE_1D_LN_CFG_PHID_1T_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_PHID_1T, x)
#define SD25G_LANE_LANE_1D_LN_CFG_PHID_1T_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_PHID_1T, x)

#define SD25G_LANE_LANE_1D_LN_CFG_PI_DFE_EN      BIT(5)
#define SD25G_LANE_LANE_1D_LN_CFG_PI_DFE_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_PI_DFE_EN, x)
#define SD25G_LANE_LANE_1D_LN_CFG_PI_DFE_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_PI_DFE_EN, x)

#define SD25G_LANE_LANE_1D_LN_CFG_PI_EXT_OVR     BIT(6)
#define SD25G_LANE_LANE_1D_LN_CFG_PI_EXT_OVR_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_PI_EXT_OVR, x)
#define SD25G_LANE_LANE_1D_LN_CFG_PI_EXT_OVR_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_PI_EXT_OVR, x)

#define SD25G_LANE_LANE_1D_LN_CFG_PI_HOLD        BIT(7)
#define SD25G_LANE_LANE_1D_LN_CFG_PI_HOLD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1D_LN_CFG_PI_HOLD, x)
#define SD25G_LANE_LANE_1D_LN_CFG_PI_HOLD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1D_LN_CFG_PI_HOLD, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_1E */
#define SD25G_LANE_LANE_1E(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 120, 0, 1, 4)

#define SD25G_LANE_LANE_1E_LN_CFG_PI_STEPS_1_0   GENMASK(1, 0)
#define SD25G_LANE_LANE_1E_LN_CFG_PI_STEPS_1_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1E_LN_CFG_PI_STEPS_1_0, x)
#define SD25G_LANE_LANE_1E_LN_CFG_PI_STEPS_1_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1E_LN_CFG_PI_STEPS_1_0, x)

#define SD25G_LANE_LANE_1E_LN_CFG_RXLB_EN        BIT(4)
#define SD25G_LANE_LANE_1E_LN_CFG_RXLB_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1E_LN_CFG_RXLB_EN, x)
#define SD25G_LANE_LANE_1E_LN_CFG_RXLB_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1E_LN_CFG_RXLB_EN, x)

#define SD25G_LANE_LANE_1E_LN_CFG_SUM_SETCM_EN   BIT(5)
#define SD25G_LANE_LANE_1E_LN_CFG_SUM_SETCM_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1E_LN_CFG_SUM_SETCM_EN, x)
#define SD25G_LANE_LANE_1E_LN_CFG_SUM_SETCM_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1E_LN_CFG_SUM_SETCM_EN, x)

#define SD25G_LANE_LANE_1E_LN_CFG_R_OFFSET_DIR   BIT(6)
#define SD25G_LANE_LANE_1E_LN_CFG_R_OFFSET_DIR_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1E_LN_CFG_R_OFFSET_DIR, x)
#define SD25G_LANE_LANE_1E_LN_CFG_R_OFFSET_DIR_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1E_LN_CFG_R_OFFSET_DIR, x)

#define SD25G_LANE_LANE_1E_LN_CFG_PMAD_CK_PD     BIT(7)
#define SD25G_LANE_LANE_1E_LN_CFG_PMAD_CK_PD_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_1E_LN_CFG_PMAD_CK_PD, x)
#define SD25G_LANE_LANE_1E_LN_CFG_PMAD_CK_PD_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_1E_LN_CFG_PMAD_CK_PD, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_21 */
#define SD25G_LANE_LANE_21(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 132, 0, 1, 4)

#define SD25G_LANE_LANE_21_LN_CFG_VGA_CTRL_BYP_4_0 GENMASK(4, 0)
#define SD25G_LANE_LANE_21_LN_CFG_VGA_CTRL_BYP_4_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_21_LN_CFG_VGA_CTRL_BYP_4_0, x)
#define SD25G_LANE_LANE_21_LN_CFG_VGA_CTRL_BYP_4_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_21_LN_CFG_VGA_CTRL_BYP_4_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_22 */
#define SD25G_LANE_LANE_22(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 136, 0, 1, 4)

#define SD25G_LANE_LANE_22_LN_CFG_EQR_FORCE_3_0  GENMASK(3, 0)
#define SD25G_LANE_LANE_22_LN_CFG_EQR_FORCE_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_22_LN_CFG_EQR_FORCE_3_0, x)
#define SD25G_LANE_LANE_22_LN_CFG_EQR_FORCE_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_22_LN_CFG_EQR_FORCE_3_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_25 */
#define SD25G_LANE_LANE_25(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 148, 0, 1, 4)

#define SD25G_LANE_LANE_25_LN_CFG_INIT_POS_ISCAN_6_0 GENMASK(6, 0)
#define SD25G_LANE_LANE_25_LN_CFG_INIT_POS_ISCAN_6_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_25_LN_CFG_INIT_POS_ISCAN_6_0, x)
#define SD25G_LANE_LANE_25_LN_CFG_INIT_POS_ISCAN_6_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_25_LN_CFG_INIT_POS_ISCAN_6_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_26 */
#define SD25G_LANE_LANE_26(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 152, 0, 1, 4)

#define SD25G_LANE_LANE_26_LN_CFG_INIT_POS_IPI_6_0 GENMASK(6, 0)
#define SD25G_LANE_LANE_26_LN_CFG_INIT_POS_IPI_6_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_26_LN_CFG_INIT_POS_IPI_6_0, x)
#define SD25G_LANE_LANE_26_LN_CFG_INIT_POS_IPI_6_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_26_LN_CFG_INIT_POS_IPI_6_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_28 */
#define SD25G_LANE_LANE_28(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 160, 0, 1, 4)

#define SD25G_LANE_LANE_28_LN_CFG_ISCAN_MODE_EN  BIT(0)
#define SD25G_LANE_LANE_28_LN_CFG_ISCAN_MODE_EN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_28_LN_CFG_ISCAN_MODE_EN, x)
#define SD25G_LANE_LANE_28_LN_CFG_ISCAN_MODE_EN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_28_LN_CFG_ISCAN_MODE_EN, x)

#define SD25G_LANE_LANE_28_LN_CFG_RX_SSC_LH      BIT(1)
#define SD25G_LANE_LANE_28_LN_CFG_RX_SSC_LH_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_28_LN_CFG_RX_SSC_LH, x)
#define SD25G_LANE_LANE_28_LN_CFG_RX_SSC_LH_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_28_LN_CFG_RX_SSC_LH, x)

#define SD25G_LANE_LANE_28_LN_CFG_FIGMERIT_SEL   BIT(2)
#define SD25G_LANE_LANE_28_LN_CFG_FIGMERIT_SEL_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_28_LN_CFG_FIGMERIT_SEL, x)
#define SD25G_LANE_LANE_28_LN_CFG_FIGMERIT_SEL_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_28_LN_CFG_FIGMERIT_SEL, x)

#define SD25G_LANE_LANE_28_LN_CFG_RX_SUBRATE_2_0 GENMASK(6, 4)
#define SD25G_LANE_LANE_28_LN_CFG_RX_SUBRATE_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_28_LN_CFG_RX_SUBRATE_2_0, x)
#define SD25G_LANE_LANE_28_LN_CFG_RX_SUBRATE_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_28_LN_CFG_RX_SUBRATE_2_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_2B */
#define SD25G_LANE_LANE_2B(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 172, 0, 1, 4)

#define SD25G_LANE_LANE_2B_LN_CFG_PI_BW_3_0      GENMASK(3, 0)
#define SD25G_LANE_LANE_2B_LN_CFG_PI_BW_3_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2B_LN_CFG_PI_BW_3_0, x)
#define SD25G_LANE_LANE_2B_LN_CFG_PI_BW_3_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2B_LN_CFG_PI_BW_3_0, x)

#define SD25G_LANE_LANE_2B_LN_CFG_RSTN_DMUX_SUBR BIT(4)
#define SD25G_LANE_LANE_2B_LN_CFG_RSTN_DMUX_SUBR_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2B_LN_CFG_RSTN_DMUX_SUBR, x)
#define SD25G_LANE_LANE_2B_LN_CFG_RSTN_DMUX_SUBR_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2B_LN_CFG_RSTN_DMUX_SUBR, x)

#define SD25G_LANE_LANE_2B_LN_CFG_RSTN_TXDUPU    BIT(5)
#define SD25G_LANE_LANE_2B_LN_CFG_RSTN_TXDUPU_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2B_LN_CFG_RSTN_TXDUPU, x)
#define SD25G_LANE_LANE_2B_LN_CFG_RSTN_TXDUPU_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2B_LN_CFG_RSTN_TXDUPU, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_2C */
#define SD25G_LANE_LANE_2C(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 176, 0, 1, 4)

#define SD25G_LANE_LANE_2C_LN_CFG_TX_SUBRATE_2_0 GENMASK(2, 0)
#define SD25G_LANE_LANE_2C_LN_CFG_TX_SUBRATE_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2C_LN_CFG_TX_SUBRATE_2_0, x)
#define SD25G_LANE_LANE_2C_LN_CFG_TX_SUBRATE_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2C_LN_CFG_TX_SUBRATE_2_0, x)

#define SD25G_LANE_LANE_2C_LN_CFG_DIS_2NDORDER   BIT(4)
#define SD25G_LANE_LANE_2C_LN_CFG_DIS_2NDORDER_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2C_LN_CFG_DIS_2NDORDER, x)
#define SD25G_LANE_LANE_2C_LN_CFG_DIS_2NDORDER_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2C_LN_CFG_DIS_2NDORDER, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_2D */
#define SD25G_LANE_LANE_2D(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 180, 0, 1, 4)

#define SD25G_LANE_LANE_2D_LN_CFG_ALOS_THR_2_0   GENMASK(2, 0)
#define SD25G_LANE_LANE_2D_LN_CFG_ALOS_THR_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2D_LN_CFG_ALOS_THR_2_0, x)
#define SD25G_LANE_LANE_2D_LN_CFG_ALOS_THR_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2D_LN_CFG_ALOS_THR_2_0, x)

#define SD25G_LANE_LANE_2D_LN_CFG_SAT_CNTSEL_2_0 GENMASK(6, 4)
#define SD25G_LANE_LANE_2D_LN_CFG_SAT_CNTSEL_2_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2D_LN_CFG_SAT_CNTSEL_2_0, x)
#define SD25G_LANE_LANE_2D_LN_CFG_SAT_CNTSEL_2_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2D_LN_CFG_SAT_CNTSEL_2_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_2E */
#define SD25G_LANE_LANE_2E(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 184, 0, 1, 4)

#define SD25G_LANE_LANE_2E_LN_CFG_EN_FAST_ISCAN  BIT(0)
#define SD25G_LANE_LANE_2E_LN_CFG_EN_FAST_ISCAN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_EN_FAST_ISCAN, x)
#define SD25G_LANE_LANE_2E_LN_CFG_EN_FAST_ISCAN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_EN_FAST_ISCAN, x)

#define SD25G_LANE_LANE_2E_LN_CFG_DIS_SQ         BIT(1)
#define SD25G_LANE_LANE_2E_LN_CFG_DIS_SQ_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_DIS_SQ, x)
#define SD25G_LANE_LANE_2E_LN_CFG_DIS_SQ_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_DIS_SQ, x)

#define SD25G_LANE_LANE_2E_LN_CFG_PD_SQ          BIT(2)
#define SD25G_LANE_LANE_2E_LN_CFG_PD_SQ_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_PD_SQ, x)
#define SD25G_LANE_LANE_2E_LN_CFG_PD_SQ_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_PD_SQ, x)

#define SD25G_LANE_LANE_2E_LN_CFG_DIS_ALOS       BIT(3)
#define SD25G_LANE_LANE_2E_LN_CFG_DIS_ALOS_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_DIS_ALOS, x)
#define SD25G_LANE_LANE_2E_LN_CFG_DIS_ALOS_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_DIS_ALOS, x)

#define SD25G_LANE_LANE_2E_LN_CFG_RESETN_AGC     BIT(4)
#define SD25G_LANE_LANE_2E_LN_CFG_RESETN_AGC_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_RESETN_AGC, x)
#define SD25G_LANE_LANE_2E_LN_CFG_RESETN_AGC_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_RESETN_AGC, x)

#define SD25G_LANE_LANE_2E_LN_CFG_RSTN_DFEDIG    BIT(5)
#define SD25G_LANE_LANE_2E_LN_CFG_RSTN_DFEDIG_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_RSTN_DFEDIG, x)
#define SD25G_LANE_LANE_2E_LN_CFG_RSTN_DFEDIG_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_RSTN_DFEDIG, x)

#define SD25G_LANE_LANE_2E_LN_CFG_PI_RSTN        BIT(6)
#define SD25G_LANE_LANE_2E_LN_CFG_PI_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_PI_RSTN, x)
#define SD25G_LANE_LANE_2E_LN_CFG_PI_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_PI_RSTN, x)

#define SD25G_LANE_LANE_2E_LN_CFG_CTLE_RSTN      BIT(7)
#define SD25G_LANE_LANE_2E_LN_CFG_CTLE_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_2E_LN_CFG_CTLE_RSTN, x)
#define SD25G_LANE_LANE_2E_LN_CFG_CTLE_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_2E_LN_CFG_CTLE_RSTN, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_40 */
#define SD25G_LANE_LANE_40(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 256, 0, 1, 4)

#define SD25G_LANE_LANE_40_LN_R_TX_BIT_REVERSE   BIT(0)
#define SD25G_LANE_LANE_40_LN_R_TX_BIT_REVERSE_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_40_LN_R_TX_BIT_REVERSE, x)
#define SD25G_LANE_LANE_40_LN_R_TX_BIT_REVERSE_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_40_LN_R_TX_BIT_REVERSE, x)

#define SD25G_LANE_LANE_40_LN_R_TX_POL_INV       BIT(1)
#define SD25G_LANE_LANE_40_LN_R_TX_POL_INV_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_40_LN_R_TX_POL_INV, x)
#define SD25G_LANE_LANE_40_LN_R_TX_POL_INV_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_40_LN_R_TX_POL_INV, x)

#define SD25G_LANE_LANE_40_LN_R_RX_BIT_REVERSE   BIT(2)
#define SD25G_LANE_LANE_40_LN_R_RX_BIT_REVERSE_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_40_LN_R_RX_BIT_REVERSE, x)
#define SD25G_LANE_LANE_40_LN_R_RX_BIT_REVERSE_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_40_LN_R_RX_BIT_REVERSE, x)

#define SD25G_LANE_LANE_40_LN_R_RX_POL_INV       BIT(3)
#define SD25G_LANE_LANE_40_LN_R_RX_POL_INV_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_40_LN_R_RX_POL_INV, x)
#define SD25G_LANE_LANE_40_LN_R_RX_POL_INV_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_40_LN_R_RX_POL_INV, x)

#define SD25G_LANE_LANE_40_LN_R_CDR_RSTN         BIT(4)
#define SD25G_LANE_LANE_40_LN_R_CDR_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_40_LN_R_CDR_RSTN, x)
#define SD25G_LANE_LANE_40_LN_R_CDR_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_40_LN_R_CDR_RSTN, x)

#define SD25G_LANE_LANE_40_LN_R_DFE_RSTN         BIT(5)
#define SD25G_LANE_LANE_40_LN_R_DFE_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_40_LN_R_DFE_RSTN, x)
#define SD25G_LANE_LANE_40_LN_R_DFE_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_40_LN_R_DFE_RSTN, x)

#define SD25G_LANE_LANE_40_LN_R_CTLE_RSTN        BIT(6)
#define SD25G_LANE_LANE_40_LN_R_CTLE_RSTN_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_40_LN_R_CTLE_RSTN, x)
#define SD25G_LANE_LANE_40_LN_R_CTLE_RSTN_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_40_LN_R_CTLE_RSTN, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_42 */
#define SD25G_LANE_LANE_42(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 264, 0, 1, 4)

#define SD25G_LANE_LANE_42_LN_CFG_TX_RESERVE_7_0 GENMASK(7, 0)
#define SD25G_LANE_LANE_42_LN_CFG_TX_RESERVE_7_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_42_LN_CFG_TX_RESERVE_7_0, x)
#define SD25G_LANE_LANE_42_LN_CFG_TX_RESERVE_7_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_42_LN_CFG_TX_RESERVE_7_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_43 */
#define SD25G_LANE_LANE_43(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 268, 0, 1, 4)

#define SD25G_LANE_LANE_43_LN_CFG_TX_RESERVE_15_8 GENMASK(7, 0)
#define SD25G_LANE_LANE_43_LN_CFG_TX_RESERVE_15_8_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_43_LN_CFG_TX_RESERVE_15_8, x)
#define SD25G_LANE_LANE_43_LN_CFG_TX_RESERVE_15_8_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_43_LN_CFG_TX_RESERVE_15_8, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_44 */
#define SD25G_LANE_LANE_44(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 272, 0, 1, 4)

#define SD25G_LANE_LANE_44_LN_CFG_RX_RESERVE_7_0 GENMASK(7, 0)
#define SD25G_LANE_LANE_44_LN_CFG_RX_RESERVE_7_0_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_44_LN_CFG_RX_RESERVE_7_0, x)
#define SD25G_LANE_LANE_44_LN_CFG_RX_RESERVE_7_0_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_44_LN_CFG_RX_RESERVE_7_0, x)

/*      SD25G_TARGET:LANE_GRP_0:LANE_45 */
#define SD25G_LANE_LANE_45(t)     __REG(TARGET_SD25G_LANE, t, 8, 1024, 0, 1, 768, 276, 0, 1, 4)

#define SD25G_LANE_LANE_45_LN_CFG_RX_RESERVE_15_8 GENMASK(7, 0)
#define SD25G_LANE_LANE_45_LN_CFG_RX_RESERVE_15_8_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_45_LN_CFG_RX_RESERVE_15_8, x)
#define SD25G_LANE_LANE_45_LN_CFG_RX_RESERVE_15_8_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_45_LN_CFG_RX_RESERVE_15_8, x)

/*      SD25G_TARGET:LANE_GRP_1:LANE_DE */
#define SD25G_LANE_LANE_DE(t)     __REG(TARGET_SD25G_LANE, t, 8, 1792, 0, 1, 128, 120, 0, 1, 4)

#define SD25G_LANE_LANE_DE_LN_LOL_UDL            BIT(0)
#define SD25G_LANE_LANE_DE_LN_LOL_UDL_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_DE_LN_LOL_UDL, x)
#define SD25G_LANE_LANE_DE_LN_LOL_UDL_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_DE_LN_LOL_UDL, x)

#define SD25G_LANE_LANE_DE_LN_LOL                BIT(1)
#define SD25G_LANE_LANE_DE_LN_LOL_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_DE_LN_LOL, x)
#define SD25G_LANE_LANE_DE_LN_LOL_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_DE_LN_LOL, x)

#define SD25G_LANE_LANE_DE_LN_PMA2PCS_RXEI_FILTERED BIT(2)
#define SD25G_LANE_LANE_DE_LN_PMA2PCS_RXEI_FILTERED_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_DE_LN_PMA2PCS_RXEI_FILTERED, x)
#define SD25G_LANE_LANE_DE_LN_PMA2PCS_RXEI_FILTERED_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_DE_LN_PMA2PCS_RXEI_FILTERED, x)

#define SD25G_LANE_LANE_DE_LN_PMA_RXEI           BIT(3)
#define SD25G_LANE_LANE_DE_LN_PMA_RXEI_SET(x)\
	FIELD_PREP(SD25G_LANE_LANE_DE_LN_PMA_RXEI, x)
#define SD25G_LANE_LANE_DE_LN_PMA_RXEI_GET(x)\
	FIELD_GET(SD25G_LANE_LANE_DE_LN_PMA_RXEI, x)

/*      SD10G_LANE_TARGET:LANE_GRP_8:LANE_DF */
#define SD6G_LANE_LANE_DF(t)      __REG(TARGET_SD6G_LANE, t, 13, 832, 0, 1, 84, 60, 0, 1, 4)

#define SD6G_LANE_LANE_DF_LOL_UDL                BIT(0)
#define SD6G_LANE_LANE_DF_LOL_UDL_SET(x)\
	FIELD_PREP(SD6G_LANE_LANE_DF_LOL_UDL, x)
#define SD6G_LANE_LANE_DF_LOL_UDL_GET(x)\
	FIELD_GET(SD6G_LANE_LANE_DF_LOL_UDL, x)

#define SD6G_LANE_LANE_DF_LOL                    BIT(1)
#define SD6G_LANE_LANE_DF_LOL_SET(x)\
	FIELD_PREP(SD6G_LANE_LANE_DF_LOL, x)
#define SD6G_LANE_LANE_DF_LOL_GET(x)\
	FIELD_GET(SD6G_LANE_LANE_DF_LOL, x)

#define SD6G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED  BIT(2)
#define SD6G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED_SET(x)\
	FIELD_PREP(SD6G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED, x)
#define SD6G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED_GET(x)\
	FIELD_GET(SD6G_LANE_LANE_DF_PMA2PCS_RXEI_FILTERED, x)

#define SD6G_LANE_LANE_DF_SQUELCH                BIT(3)
#define SD6G_LANE_LANE_DF_SQUELCH_SET(x)\
	FIELD_PREP(SD6G_LANE_LANE_DF_SQUELCH, x)
#define SD6G_LANE_LANE_DF_SQUELCH_GET(x)\
	FIELD_GET(SD6G_LANE_LANE_DF_SQUELCH, x)

/*      SD10G_CMU_TARGET:CMU_GRP_0:CMU_00 */
#define SD_CMU_CMU_00(t)          __REG(TARGET_SD_CMU, t, 14, 0, 0, 1, 20, 0, 0, 1, 4)

#define SD_CMU_CMU_00_R_HWT_SIMULATION_MODE      BIT(0)
#define SD_CMU_CMU_00_R_HWT_SIMULATION_MODE_SET(x)\
	FIELD_PREP(SD_CMU_CMU_00_R_HWT_SIMULATION_MODE, x)
#define SD_CMU_CMU_00_R_HWT_SIMULATION_MODE_GET(x)\
	FIELD_GET(SD_CMU_CMU_00_R_HWT_SIMULATION_MODE, x)

#define SD_CMU_CMU_00_CFG_PLL_LOL_SET            BIT(1)
#define SD_CMU_CMU_00_CFG_PLL_LOL_SET_SET(x)\
	FIELD_PREP(SD_CMU_CMU_00_CFG_PLL_LOL_SET, x)
#define SD_CMU_CMU_00_CFG_PLL_LOL_SET_GET(x)\
	FIELD_GET(SD_CMU_CMU_00_CFG_PLL_LOL_SET, x)

#define SD_CMU_CMU_00_CFG_PLL_LOS_SET            BIT(2)
#define SD_CMU_CMU_00_CFG_PLL_LOS_SET_SET(x)\
	FIELD_PREP(SD_CMU_CMU_00_CFG_PLL_LOS_SET, x)
#define SD_CMU_CMU_00_CFG_PLL_LOS_SET_GET(x)\
	FIELD_GET(SD_CMU_CMU_00_CFG_PLL_LOS_SET, x)

#define SD_CMU_CMU_00_CFG_PLL_TP_SEL_1_0         GENMASK(5, 4)
#define SD_CMU_CMU_00_CFG_PLL_TP_SEL_1_0_SET(x)\
	FIELD_PREP(SD_CMU_CMU_00_CFG_PLL_TP_SEL_1_0, x)
#define SD_CMU_CMU_00_CFG_PLL_TP_SEL_1_0_GET(x)\
	FIELD_GET(SD_CMU_CMU_00_CFG_PLL_TP_SEL_1_0, x)

/*      SD10G_CMU_TARGET:CMU_GRP_1:CMU_05 */
#define SD_CMU_CMU_05(t)          __REG(TARGET_SD_CMU, t, 14, 20, 0, 1, 72, 0, 0, 1, 4)

#define SD_CMU_CMU_05_CFG_REFCK_TERM_EN          BIT(0)
#define SD_CMU_CMU_05_CFG_REFCK_TERM_EN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_05_CFG_REFCK_TERM_EN, x)
#define SD_CMU_CMU_05_CFG_REFCK_TERM_EN_GET(x)\
	FIELD_GET(SD_CMU_CMU_05_CFG_REFCK_TERM_EN, x)

#define SD_CMU_CMU_05_CFG_BIAS_TP_SEL_1_0        GENMASK(5, 4)
#define SD_CMU_CMU_05_CFG_BIAS_TP_SEL_1_0_SET(x)\
	FIELD_PREP(SD_CMU_CMU_05_CFG_BIAS_TP_SEL_1_0, x)
#define SD_CMU_CMU_05_CFG_BIAS_TP_SEL_1_0_GET(x)\
	FIELD_GET(SD_CMU_CMU_05_CFG_BIAS_TP_SEL_1_0, x)

/*      SD10G_CMU_TARGET:CMU_GRP_1:CMU_06 */
#define SD_CMU_CMU_06(t) \
	__REG(TARGET_SD_CMU, t, 14, 20, 0, 1, 72, 4, 0, 1, 4)

#define SD_CMU_CMU_06_CFG_DISLOS                 BIT(0)
#define SD_CMU_CMU_06_CFG_DISLOS_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_DISLOS, x)
#define SD_CMU_CMU_06_CFG_DISLOS_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_DISLOS, x)

#define SD_CMU_CMU_06_CFG_DISLOL                 BIT(1)
#define SD_CMU_CMU_06_CFG_DISLOL_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_DISLOL, x)
#define SD_CMU_CMU_06_CFG_DISLOL_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_DISLOL, x)

#define SD_CMU_CMU_06_CFG_DCLOL                  BIT(2)
#define SD_CMU_CMU_06_CFG_DCLOL_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_DCLOL, x)
#define SD_CMU_CMU_06_CFG_DCLOL_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_DCLOL, x)

#define SD_CMU_CMU_06_CFG_FORCE_RX_FILT          BIT(3)
#define SD_CMU_CMU_06_CFG_FORCE_RX_FILT_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_FORCE_RX_FILT, x)
#define SD_CMU_CMU_06_CFG_FORCE_RX_FILT_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_FORCE_RX_FILT, x)

#define SD_CMU_CMU_06_CFG_CTRL_LOGIC_PD          BIT(4)
#define SD_CMU_CMU_06_CFG_CTRL_LOGIC_PD_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_CTRL_LOGIC_PD, x)
#define SD_CMU_CMU_06_CFG_CTRL_LOGIC_PD_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_CTRL_LOGIC_PD, x)

#define SD_CMU_CMU_06_CFG_VCO_PD                 BIT(5)
#define SD_CMU_CMU_06_CFG_VCO_PD_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_VCO_PD, x)
#define SD_CMU_CMU_06_CFG_VCO_PD_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_VCO_PD, x)

#define SD_CMU_CMU_06_CFG_VCO_CAL_RESETN         BIT(6)
#define SD_CMU_CMU_06_CFG_VCO_CAL_RESETN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_VCO_CAL_RESETN, x)
#define SD_CMU_CMU_06_CFG_VCO_CAL_RESETN_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_VCO_CAL_RESETN, x)

#define SD_CMU_CMU_06_CFG_VCO_CAL_BYP            BIT(7)
#define SD_CMU_CMU_06_CFG_VCO_CAL_BYP_SET(x)\
	FIELD_PREP(SD_CMU_CMU_06_CFG_VCO_CAL_BYP, x)
#define SD_CMU_CMU_06_CFG_VCO_CAL_BYP_GET(x)\
	FIELD_GET(SD_CMU_CMU_06_CFG_VCO_CAL_BYP, x)

/*      SD10G_CMU_TARGET:CMU_GRP_1:CMU_08 */
#define SD_CMU_CMU_08(t) \
	__REG(TARGET_SD_CMU, t, 14, 20, 0, 1, 72, 12, 0, 1, 4)

#define SD_CMU_CMU_08_CFG_VFILT2PAD              BIT(0)
#define SD_CMU_CMU_08_CFG_VFILT2PAD_SET(x)\
	FIELD_PREP(SD_CMU_CMU_08_CFG_VFILT2PAD, x)
#define SD_CMU_CMU_08_CFG_VFILT2PAD_GET(x)\
	FIELD_GET(SD_CMU_CMU_08_CFG_VFILT2PAD, x)

#define SD_CMU_CMU_08_CFG_EN_DUMMY               BIT(1)
#define SD_CMU_CMU_08_CFG_EN_DUMMY_SET(x)\
	FIELD_PREP(SD_CMU_CMU_08_CFG_EN_DUMMY, x)
#define SD_CMU_CMU_08_CFG_EN_DUMMY_GET(x)\
	FIELD_GET(SD_CMU_CMU_08_CFG_EN_DUMMY, x)

#define SD_CMU_CMU_08_CFG_CK_TREE_PD             BIT(2)
#define SD_CMU_CMU_08_CFG_CK_TREE_PD_SET(x)\
	FIELD_PREP(SD_CMU_CMU_08_CFG_CK_TREE_PD, x)
#define SD_CMU_CMU_08_CFG_CK_TREE_PD_GET(x)\
	FIELD_GET(SD_CMU_CMU_08_CFG_CK_TREE_PD, x)

#define SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN        BIT(3)
#define SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN, x)
#define SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN_GET(x)\
	FIELD_GET(SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN, x)

#define SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN_EN     BIT(4)
#define SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN_EN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN_EN, x)
#define SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN_EN_GET(x)\
	FIELD_GET(SD_CMU_CMU_08_CFG_RST_TREE_PD_MAN_EN, x)

/*      SD10G_CMU_TARGET:CMU_GRP_1:CMU_09 */
#define SD_CMU_CMU_09(t)          __REG(TARGET_SD_CMU, t, 14, 20, 0, 1, 72, 16, 0, 1, 4)

#define SD_CMU_CMU_09_CFG_EN_TX_CK_UP            BIT(0)
#define SD_CMU_CMU_09_CFG_EN_TX_CK_UP_SET(x)\
	FIELD_PREP(SD_CMU_CMU_09_CFG_EN_TX_CK_UP, x)
#define SD_CMU_CMU_09_CFG_EN_TX_CK_UP_GET(x)\
	FIELD_GET(SD_CMU_CMU_09_CFG_EN_TX_CK_UP, x)

#define SD_CMU_CMU_09_CFG_EN_TX_CK_DN            BIT(1)
#define SD_CMU_CMU_09_CFG_EN_TX_CK_DN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_09_CFG_EN_TX_CK_DN, x)
#define SD_CMU_CMU_09_CFG_EN_TX_CK_DN_GET(x)\
	FIELD_GET(SD_CMU_CMU_09_CFG_EN_TX_CK_DN, x)

#define SD_CMU_CMU_09_CFG_SW_8G                  BIT(4)
#define SD_CMU_CMU_09_CFG_SW_8G_SET(x)\
	FIELD_PREP(SD_CMU_CMU_09_CFG_SW_8G, x)
#define SD_CMU_CMU_09_CFG_SW_8G_GET(x)\
	FIELD_GET(SD_CMU_CMU_09_CFG_SW_8G, x)

#define SD_CMU_CMU_09_CFG_SW_10G                 BIT(5)
#define SD_CMU_CMU_09_CFG_SW_10G_SET(x)\
	FIELD_PREP(SD_CMU_CMU_09_CFG_SW_10G, x)
#define SD_CMU_CMU_09_CFG_SW_10G_GET(x)\
	FIELD_GET(SD_CMU_CMU_09_CFG_SW_10G, x)

/*      SD10G_CMU_TARGET:CMU_GRP_1:CMU_0D */
#define SD_CMU_CMU_0D(t)          __REG(TARGET_SD_CMU, t, 14, 20, 0, 1, 72, 32, 0, 1, 4)

#define SD_CMU_CMU_0D_CFG_PD_DIV64               BIT(0)
#define SD_CMU_CMU_0D_CFG_PD_DIV64_SET(x)\
	FIELD_PREP(SD_CMU_CMU_0D_CFG_PD_DIV64, x)
#define SD_CMU_CMU_0D_CFG_PD_DIV64_GET(x)\
	FIELD_GET(SD_CMU_CMU_0D_CFG_PD_DIV64, x)

#define SD_CMU_CMU_0D_CFG_PD_DIV66               BIT(1)
#define SD_CMU_CMU_0D_CFG_PD_DIV66_SET(x)\
	FIELD_PREP(SD_CMU_CMU_0D_CFG_PD_DIV66, x)
#define SD_CMU_CMU_0D_CFG_PD_DIV66_GET(x)\
	FIELD_GET(SD_CMU_CMU_0D_CFG_PD_DIV66, x)

#define SD_CMU_CMU_0D_CFG_PMA_TX_CK_PD           BIT(2)
#define SD_CMU_CMU_0D_CFG_PMA_TX_CK_PD_SET(x)\
	FIELD_PREP(SD_CMU_CMU_0D_CFG_PMA_TX_CK_PD, x)
#define SD_CMU_CMU_0D_CFG_PMA_TX_CK_PD_GET(x)\
	FIELD_GET(SD_CMU_CMU_0D_CFG_PMA_TX_CK_PD, x)

#define SD_CMU_CMU_0D_CFG_JC_BYP                 BIT(3)
#define SD_CMU_CMU_0D_CFG_JC_BYP_SET(x)\
	FIELD_PREP(SD_CMU_CMU_0D_CFG_JC_BYP, x)
#define SD_CMU_CMU_0D_CFG_JC_BYP_GET(x)\
	FIELD_GET(SD_CMU_CMU_0D_CFG_JC_BYP, x)

#define SD_CMU_CMU_0D_CFG_REFCK_PD               BIT(4)
#define SD_CMU_CMU_0D_CFG_REFCK_PD_SET(x)\
	FIELD_PREP(SD_CMU_CMU_0D_CFG_REFCK_PD, x)
#define SD_CMU_CMU_0D_CFG_REFCK_PD_GET(x)\
	FIELD_GET(SD_CMU_CMU_0D_CFG_REFCK_PD, x)

/*      SD10G_CMU_TARGET:CMU_GRP_3:CMU_1B */
#define SD_CMU_CMU_1B(t)          __REG(TARGET_SD_CMU, t, 14, 104, 0, 1, 20, 4, 0, 1, 4)

#define SD_CMU_CMU_1B_CFG_RESERVE_7_0            GENMASK(7, 0)
#define SD_CMU_CMU_1B_CFG_RESERVE_7_0_SET(x)\
	FIELD_PREP(SD_CMU_CMU_1B_CFG_RESERVE_7_0, x)
#define SD_CMU_CMU_1B_CFG_RESERVE_7_0_GET(x)\
	FIELD_GET(SD_CMU_CMU_1B_CFG_RESERVE_7_0, x)

/*      SD10G_CMU_TARGET:CMU_GRP_4:CMU_1F */
#define SD_CMU_CMU_1F(t)          __REG(TARGET_SD_CMU, t, 14, 124, 0, 1, 68, 0, 0, 1, 4)

#define SD_CMU_CMU_1F_CFG_BIAS_DN_EN             BIT(0)
#define SD_CMU_CMU_1F_CFG_BIAS_DN_EN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_1F_CFG_BIAS_DN_EN, x)
#define SD_CMU_CMU_1F_CFG_BIAS_DN_EN_GET(x)\
	FIELD_GET(SD_CMU_CMU_1F_CFG_BIAS_DN_EN, x)

#define SD_CMU_CMU_1F_CFG_BIAS_UP_EN             BIT(1)
#define SD_CMU_CMU_1F_CFG_BIAS_UP_EN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_1F_CFG_BIAS_UP_EN, x)
#define SD_CMU_CMU_1F_CFG_BIAS_UP_EN_GET(x)\
	FIELD_GET(SD_CMU_CMU_1F_CFG_BIAS_UP_EN, x)

#define SD_CMU_CMU_1F_CFG_IC2IP_N                BIT(2)
#define SD_CMU_CMU_1F_CFG_IC2IP_N_SET(x)\
	FIELD_PREP(SD_CMU_CMU_1F_CFG_IC2IP_N, x)
#define SD_CMU_CMU_1F_CFG_IC2IP_N_GET(x)\
	FIELD_GET(SD_CMU_CMU_1F_CFG_IC2IP_N, x)

#define SD_CMU_CMU_1F_CFG_VTUNE_SEL              BIT(3)
#define SD_CMU_CMU_1F_CFG_VTUNE_SEL_SET(x)\
	FIELD_PREP(SD_CMU_CMU_1F_CFG_VTUNE_SEL, x)
#define SD_CMU_CMU_1F_CFG_VTUNE_SEL_GET(x)\
	FIELD_GET(SD_CMU_CMU_1F_CFG_VTUNE_SEL, x)

/*      SD10G_CMU_TARGET:CMU_GRP_5:CMU_30 */
#define SD_CMU_CMU_30(t)          __REG(TARGET_SD_CMU, t, 14, 192, 0, 1, 72, 0, 0, 1, 4)

#define SD_CMU_CMU_30_R_PLL_DLOL_EN              BIT(0)
#define SD_CMU_CMU_30_R_PLL_DLOL_EN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_30_R_PLL_DLOL_EN, x)
#define SD_CMU_CMU_30_R_PLL_DLOL_EN_GET(x)\
	FIELD_GET(SD_CMU_CMU_30_R_PLL_DLOL_EN, x)

/*      SD10G_CMU_TARGET:CMU_GRP_6:CMU_44 */
#define SD_CMU_CMU_44(t)          __REG(TARGET_SD_CMU, t, 14, 264, 0, 1, 632, 8, 0, 1, 4)

#define SD_CMU_CMU_44_R_PLL_RSTN                 BIT(0)
#define SD_CMU_CMU_44_R_PLL_RSTN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_44_R_PLL_RSTN, x)
#define SD_CMU_CMU_44_R_PLL_RSTN_GET(x)\
	FIELD_GET(SD_CMU_CMU_44_R_PLL_RSTN, x)

#define SD_CMU_CMU_44_R_CK_RESETB                BIT(1)
#define SD_CMU_CMU_44_R_CK_RESETB_SET(x)\
	FIELD_PREP(SD_CMU_CMU_44_R_CK_RESETB, x)
#define SD_CMU_CMU_44_R_CK_RESETB_GET(x)\
	FIELD_GET(SD_CMU_CMU_44_R_CK_RESETB, x)

/*      SD10G_CMU_TARGET:CMU_GRP_6:CMU_45 */
#define SD_CMU_CMU_45(t)          __REG(TARGET_SD_CMU, t, 14, 264, 0, 1, 632, 12, 0, 1, 4)

#define SD_CMU_CMU_45_R_EN_RATECHG_CTRL          BIT(0)
#define SD_CMU_CMU_45_R_EN_RATECHG_CTRL_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_R_EN_RATECHG_CTRL, x)
#define SD_CMU_CMU_45_R_EN_RATECHG_CTRL_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_R_EN_RATECHG_CTRL, x)

#define SD_CMU_CMU_45_R_DWIDTHCTRL_FROM_HWT      BIT(1)
#define SD_CMU_CMU_45_R_DWIDTHCTRL_FROM_HWT_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_R_DWIDTHCTRL_FROM_HWT, x)
#define SD_CMU_CMU_45_R_DWIDTHCTRL_FROM_HWT_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_R_DWIDTHCTRL_FROM_HWT, x)

#define SD_CMU_CMU_45_RESERVED                   BIT(2)
#define SD_CMU_CMU_45_RESERVED_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_RESERVED, x)
#define SD_CMU_CMU_45_RESERVED_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_RESERVED, x)

#define SD_CMU_CMU_45_R_REFCK_SSC_EN_FROM_HWT    BIT(3)
#define SD_CMU_CMU_45_R_REFCK_SSC_EN_FROM_HWT_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_R_REFCK_SSC_EN_FROM_HWT, x)
#define SD_CMU_CMU_45_R_REFCK_SSC_EN_FROM_HWT_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_R_REFCK_SSC_EN_FROM_HWT, x)

#define SD_CMU_CMU_45_RESERVED_2                 BIT(4)
#define SD_CMU_CMU_45_RESERVED_2_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_RESERVED_2, x)
#define SD_CMU_CMU_45_RESERVED_2_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_RESERVED_2, x)

#define SD_CMU_CMU_45_R_LINK_BUF_EN_FROM_HWT     BIT(5)
#define SD_CMU_CMU_45_R_LINK_BUF_EN_FROM_HWT_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_R_LINK_BUF_EN_FROM_HWT, x)
#define SD_CMU_CMU_45_R_LINK_BUF_EN_FROM_HWT_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_R_LINK_BUF_EN_FROM_HWT, x)

#define SD_CMU_CMU_45_R_BIAS_EN_FROM_HWT         BIT(6)
#define SD_CMU_CMU_45_R_BIAS_EN_FROM_HWT_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_R_BIAS_EN_FROM_HWT, x)
#define SD_CMU_CMU_45_R_BIAS_EN_FROM_HWT_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_R_BIAS_EN_FROM_HWT, x)

#define SD_CMU_CMU_45_R_AUTO_RST_TREE_PD_MAN     BIT(7)
#define SD_CMU_CMU_45_R_AUTO_RST_TREE_PD_MAN_SET(x)\
	FIELD_PREP(SD_CMU_CMU_45_R_AUTO_RST_TREE_PD_MAN, x)
#define SD_CMU_CMU_45_R_AUTO_RST_TREE_PD_MAN_GET(x)\
	FIELD_GET(SD_CMU_CMU_45_R_AUTO_RST_TREE_PD_MAN, x)

/*      SD10G_CMU_TARGET:CMU_GRP_6:CMU_47 */
#define SD_CMU_CMU_47(t)          __REG(TARGET_SD_CMU, t, 14, 264, 0, 1, 632, 20, 0, 1, 4)

#define SD_CMU_CMU_47_R_PCS2PMA_PHYMODE_4_0      GENMASK(4, 0)
#define SD_CMU_CMU_47_R_PCS2PMA_PHYMODE_4_0_SET(x)\
	FIELD_PREP(SD_CMU_CMU_47_R_PCS2PMA_PHYMODE_4_0, x)
#define SD_CMU_CMU_47_R_PCS2PMA_PHYMODE_4_0_GET(x)\
	FIELD_GET(SD_CMU_CMU_47_R_PCS2PMA_PHYMODE_4_0, x)

/*      SD10G_CMU_TARGET:CMU_GRP_7:CMU_E0 */
#define SD_CMU_CMU_E0(t)          __REG(TARGET_SD_CMU, t, 14, 896, 0, 1, 8, 0, 0, 1, 4)

#define SD_CMU_CMU_E0_READ_VCO_CTUNE_3_0         GENMASK(3, 0)
#define SD_CMU_CMU_E0_READ_VCO_CTUNE_3_0_SET(x)\
	FIELD_PREP(SD_CMU_CMU_E0_READ_VCO_CTUNE_3_0, x)
#define SD_CMU_CMU_E0_READ_VCO_CTUNE_3_0_GET(x)\
	FIELD_GET(SD_CMU_CMU_E0_READ_VCO_CTUNE_3_0, x)

#define SD_CMU_CMU_E0_PLL_LOL_UDL                BIT(4)
#define SD_CMU_CMU_E0_PLL_LOL_UDL_SET(x)\
	FIELD_PREP(SD_CMU_CMU_E0_PLL_LOL_UDL, x)
#define SD_CMU_CMU_E0_PLL_LOL_UDL_GET(x)\
	FIELD_GET(SD_CMU_CMU_E0_PLL_LOL_UDL, x)

/*      SD_CMU_TARGET:SD_CMU_CFG:SD_CMU_CFG */
#define SD_CMU_CFG_SD_CMU_CFG(t)  __REG(TARGET_SD_CMU_CFG, t, 14, 0, 0, 1, 8, 0, 0, 1, 4)

#define SD_CMU_CFG_SD_CMU_CFG_CMU_RST            BIT(0)
#define SD_CMU_CFG_SD_CMU_CFG_CMU_RST_SET(x)\
	FIELD_PREP(SD_CMU_CFG_SD_CMU_CFG_CMU_RST, x)
#define SD_CMU_CFG_SD_CMU_CFG_CMU_RST_GET(x)\
	FIELD_GET(SD_CMU_CFG_SD_CMU_CFG_CMU_RST, x)

#define SD_CMU_CFG_SD_CMU_CFG_EXT_CFG_RST        BIT(1)
#define SD_CMU_CFG_SD_CMU_CFG_EXT_CFG_RST_SET(x)\
	FIELD_PREP(SD_CMU_CFG_SD_CMU_CFG_EXT_CFG_RST, x)
#define SD_CMU_CFG_SD_CMU_CFG_EXT_CFG_RST_GET(x)\
	FIELD_GET(SD_CMU_CFG_SD_CMU_CFG_EXT_CFG_RST, x)

/*      SD_LANE_TARGET:SD_RESET:SD_SER_RST */
#define SD_LANE_SD_SER_RST(t)     __REG(TARGET_SD_LANE, t, 25, 0, 0, 1, 8, 0, 0, 1, 4)

#define SD_LANE_SD_SER_RST_SER_RST               BIT(0)
#define SD_LANE_SD_SER_RST_SER_RST_SET(x)\
	FIELD_PREP(SD_LANE_SD_SER_RST_SER_RST, x)
#define SD_LANE_SD_SER_RST_SER_RST_GET(x)\
	FIELD_GET(SD_LANE_SD_SER_RST_SER_RST, x)

/*      SD_LANE_TARGET:SD_RESET:SD_DES_RST */
#define SD_LANE_SD_DES_RST(t)     __REG(TARGET_SD_LANE, t, 25, 0, 0, 1, 8, 4, 0, 1, 4)

#define SD_LANE_SD_DES_RST_DES_RST               BIT(0)
#define SD_LANE_SD_DES_RST_DES_RST_SET(x)\
	FIELD_PREP(SD_LANE_SD_DES_RST_DES_RST, x)
#define SD_LANE_SD_DES_RST_DES_RST_GET(x)\
	FIELD_GET(SD_LANE_SD_DES_RST_DES_RST, x)

/*      SD_LANE_TARGET:SD_LANE_CFG_STAT:SD_LANE_CFG */
#define SD_LANE_SD_LANE_CFG(t)    __REG(TARGET_SD_LANE, t, 25, 8, 0, 1, 8, 0, 0, 1, 4)

#define SD_LANE_SD_LANE_CFG_MACRO_RST            BIT(0)
#define SD_LANE_SD_LANE_CFG_MACRO_RST_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_CFG_MACRO_RST, x)
#define SD_LANE_SD_LANE_CFG_MACRO_RST_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_CFG_MACRO_RST, x)

#define SD_LANE_SD_LANE_CFG_EXT_CFG_RST          BIT(1)
#define SD_LANE_SD_LANE_CFG_EXT_CFG_RST_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_CFG_EXT_CFG_RST, x)
#define SD_LANE_SD_LANE_CFG_EXT_CFG_RST_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_CFG_EXT_CFG_RST, x)

#define SD_LANE_SD_LANE_CFG_TX_REF_SEL           GENMASK(5, 4)
#define SD_LANE_SD_LANE_CFG_TX_REF_SEL_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_CFG_TX_REF_SEL, x)
#define SD_LANE_SD_LANE_CFG_TX_REF_SEL_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_CFG_TX_REF_SEL, x)

#define SD_LANE_SD_LANE_CFG_RX_REF_SEL           GENMASK(7, 6)
#define SD_LANE_SD_LANE_CFG_RX_REF_SEL_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_CFG_RX_REF_SEL, x)
#define SD_LANE_SD_LANE_CFG_RX_REF_SEL_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_CFG_RX_REF_SEL, x)

#define SD_LANE_SD_LANE_CFG_LANE_RST             BIT(8)
#define SD_LANE_SD_LANE_CFG_LANE_RST_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_CFG_LANE_RST, x)
#define SD_LANE_SD_LANE_CFG_LANE_RST_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_CFG_LANE_RST, x)

#define SD_LANE_SD_LANE_CFG_LANE_TX_RST          BIT(9)
#define SD_LANE_SD_LANE_CFG_LANE_TX_RST_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_CFG_LANE_TX_RST, x)
#define SD_LANE_SD_LANE_CFG_LANE_TX_RST_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_CFG_LANE_TX_RST, x)

#define SD_LANE_SD_LANE_CFG_LANE_RX_RST          BIT(10)
#define SD_LANE_SD_LANE_CFG_LANE_RX_RST_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_CFG_LANE_RX_RST, x)
#define SD_LANE_SD_LANE_CFG_LANE_RX_RST_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_CFG_LANE_RX_RST, x)

/*      SD_LANE_TARGET:SD_LANE_CFG_STAT:SD_LANE_STAT */
#define SD_LANE_SD_LANE_STAT(t)   __REG(TARGET_SD_LANE, t, 25, 8, 0, 1, 8, 4, 0, 1, 4)

#define SD_LANE_SD_LANE_STAT_PMA_RST_DONE        BIT(0)
#define SD_LANE_SD_LANE_STAT_PMA_RST_DONE_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_STAT_PMA_RST_DONE, x)
#define SD_LANE_SD_LANE_STAT_PMA_RST_DONE_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_STAT_PMA_RST_DONE, x)

#define SD_LANE_SD_LANE_STAT_DFE_RST_DONE        BIT(1)
#define SD_LANE_SD_LANE_STAT_DFE_RST_DONE_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_STAT_DFE_RST_DONE, x)
#define SD_LANE_SD_LANE_STAT_DFE_RST_DONE_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_STAT_DFE_RST_DONE, x)

#define SD_LANE_SD_LANE_STAT_DBG_OBS             GENMASK(31, 16)
#define SD_LANE_SD_LANE_STAT_DBG_OBS_SET(x)\
	FIELD_PREP(SD_LANE_SD_LANE_STAT_DBG_OBS, x)
#define SD_LANE_SD_LANE_STAT_DBG_OBS_GET(x)\
	FIELD_GET(SD_LANE_SD_LANE_STAT_DBG_OBS, x)

/*      SD_LANE_TARGET:SD_PWR_CFG:QUIET_MODE_6G */
#define SD_LANE_QUIET_MODE_6G(t) \
	__REG(TARGET_SD_LANE, t, 25, 24, 0, 1, 8, 4, 0, 1, 4)

#define SD_LANE_QUIET_MODE_6G_QUIET_MODE         GENMASK(24, 0)
#define SD_LANE_QUIET_MODE_6G_QUIET_MODE_SET(x)\
	FIELD_PREP(SD_LANE_QUIET_MODE_6G_QUIET_MODE, x)
#define SD_LANE_QUIET_MODE_6G_QUIET_MODE_GET(x)\
	FIELD_GET(SD_LANE_QUIET_MODE_6G_QUIET_MODE, x)

/*      SD_LANE_TARGET:CFG_STAT_FX100:MISC */
#define SD_LANE_MISC(t)           __REG(TARGET_SD_LANE, t, 25, 56, 0, 1, 56, 0, 0, 1, 4)

#define SD_LANE_MISC_SD_125_RST_DIS              BIT(0)
#define SD_LANE_MISC_SD_125_RST_DIS_SET(x)\
	FIELD_PREP(SD_LANE_MISC_SD_125_RST_DIS, x)
#define SD_LANE_MISC_SD_125_RST_DIS_GET(x)\
	FIELD_GET(SD_LANE_MISC_SD_125_RST_DIS, x)

#define SD_LANE_MISC_RX_ENA                      BIT(1)
#define SD_LANE_MISC_RX_ENA_SET(x)\
	FIELD_PREP(SD_LANE_MISC_RX_ENA, x)
#define SD_LANE_MISC_RX_ENA_GET(x)\
	FIELD_GET(SD_LANE_MISC_RX_ENA, x)

#define SD_LANE_MISC_MUX_ENA                     BIT(2)
#define SD_LANE_MISC_MUX_ENA_SET(x)\
	FIELD_PREP(SD_LANE_MISC_MUX_ENA, x)
#define SD_LANE_MISC_MUX_ENA_GET(x)\
	FIELD_GET(SD_LANE_MISC_MUX_ENA, x)

#define SD_LANE_MISC_CORE_CLK_FREQ               GENMASK(5, 4)
#define SD_LANE_MISC_CORE_CLK_FREQ_SET(x)\
	FIELD_PREP(SD_LANE_MISC_CORE_CLK_FREQ, x)
#define SD_LANE_MISC_CORE_CLK_FREQ_GET(x)\
	FIELD_GET(SD_LANE_MISC_CORE_CLK_FREQ, x)

/*      SD_LANE_TARGET:CFG_STAT_FX100:M_STAT_MISC */
#define SD_LANE_M_STAT_MISC(t)    __REG(TARGET_SD_LANE, t, 25, 56, 0, 1, 56, 36, 0, 1, 4)

#define SD_LANE_M_STAT_MISC_M_RIS_EDGE_PTR_ADJ_SUM GENMASK(21, 0)
#define SD_LANE_M_STAT_MISC_M_RIS_EDGE_PTR_ADJ_SUM_SET(x)\
	FIELD_PREP(SD_LANE_M_STAT_MISC_M_RIS_EDGE_PTR_ADJ_SUM, x)
#define SD_LANE_M_STAT_MISC_M_RIS_EDGE_PTR_ADJ_SUM_GET(x)\
	FIELD_GET(SD_LANE_M_STAT_MISC_M_RIS_EDGE_PTR_ADJ_SUM, x)

#define SD_LANE_M_STAT_MISC_M_LOCK_CNT           GENMASK(31, 24)
#define SD_LANE_M_STAT_MISC_M_LOCK_CNT_SET(x)\
	FIELD_PREP(SD_LANE_M_STAT_MISC_M_LOCK_CNT, x)
#define SD_LANE_M_STAT_MISC_M_LOCK_CNT_GET(x)\
	FIELD_GET(SD_LANE_M_STAT_MISC_M_LOCK_CNT, x)

/*      SD25G_CFG_TARGET:SD_RESET:SD_SER_RST */
#define SD_LANE_25G_SD_SER_RST(t) __REG(TARGET_SD_LANE_25G, t, 8, 0, 0, 1, 8, 0, 0, 1, 4)

#define SD_LANE_25G_SD_SER_RST_SER_RST           BIT(0)
#define SD_LANE_25G_SD_SER_RST_SER_RST_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_SER_RST_SER_RST, x)
#define SD_LANE_25G_SD_SER_RST_SER_RST_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_SER_RST_SER_RST, x)

/*      SD25G_CFG_TARGET:SD_RESET:SD_DES_RST */
#define SD_LANE_25G_SD_DES_RST(t) __REG(TARGET_SD_LANE_25G, t, 8, 0, 0, 1, 8, 4, 0, 1, 4)

#define SD_LANE_25G_SD_DES_RST_DES_RST           BIT(0)
#define SD_LANE_25G_SD_DES_RST_DES_RST_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_DES_RST_DES_RST, x)
#define SD_LANE_25G_SD_DES_RST_DES_RST_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_DES_RST_DES_RST, x)

/*      SD25G_CFG_TARGET:SD_LANE_CFG_STAT:SD_LANE_CFG */
#define SD_LANE_25G_SD_LANE_CFG(t) __REG(TARGET_SD_LANE_25G, t, 8, 8, 0, 1, 12, 0, 0, 1, 4)

#define SD_LANE_25G_SD_LANE_CFG_MACRO_RST        BIT(0)
#define SD_LANE_25G_SD_LANE_CFG_MACRO_RST_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_MACRO_RST, x)
#define SD_LANE_25G_SD_LANE_CFG_MACRO_RST_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_MACRO_RST, x)

#define SD_LANE_25G_SD_LANE_CFG_EXT_CFG_RST      BIT(1)
#define SD_LANE_25G_SD_LANE_CFG_EXT_CFG_RST_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_EXT_CFG_RST, x)
#define SD_LANE_25G_SD_LANE_CFG_EXT_CFG_RST_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_EXT_CFG_RST, x)

#define SD_LANE_25G_SD_LANE_CFG_HWT_MULTI_LANE_MODE BIT(4)
#define SD_LANE_25G_SD_LANE_CFG_HWT_MULTI_LANE_MODE_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_HWT_MULTI_LANE_MODE, x)
#define SD_LANE_25G_SD_LANE_CFG_HWT_MULTI_LANE_MODE_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_HWT_MULTI_LANE_MODE, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_PHYMODE  GENMASK(7, 5)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_PHYMODE_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_PHYMODE, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_PHYMODE_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_PHYMODE, x)

#define SD_LANE_25G_SD_LANE_CFG_LANE_RST         BIT(8)
#define SD_LANE_25G_SD_LANE_CFG_LANE_RST_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_LANE_RST, x)
#define SD_LANE_25G_SD_LANE_CFG_LANE_RST_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_LANE_RST, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_ADV       BIT(9)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_ADV_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_EN_ADV, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_ADV_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_EN_ADV, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_MAIN      BIT(10)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_MAIN_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_EN_MAIN, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_MAIN_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_EN_MAIN, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_DLY       BIT(11)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_DLY_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_EN_DLY, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_DLY_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_EN_DLY, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_ADV      GENMASK(15, 12)
#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_ADV_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_TAP_ADV, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_ADV_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_TAP_ADV, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_MAIN     BIT(16)
#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_MAIN_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_TAP_MAIN, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_MAIN_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_TAP_MAIN, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_DLY      GENMASK(21, 17)
#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_DLY_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_TAP_DLY, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_TAP_DLY_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_TAP_DLY, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_ISCAN_EN     BIT(22)
#define SD_LANE_25G_SD_LANE_CFG_PCS_ISCAN_EN_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_ISCAN_EN, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_ISCAN_EN_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_ISCAN_EN, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_FAST_ISCAN BIT(23)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_FAST_ISCAN_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS_EN_FAST_ISCAN, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS_EN_FAST_ISCAN_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS_EN_FAST_ISCAN, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXSWING  BIT(24)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXSWING_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXSWING, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXSWING_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXSWING, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXEI     BIT(25)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXEI_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXEI, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXEI_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXEI, x)

#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXMARGIN GENMASK(28, 26)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXMARGIN_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXMARGIN, x)
#define SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXMARGIN_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG_PCS2PMA_TXMARGIN, x)

/*      SD25G_CFG_TARGET:SD_LANE_CFG_STAT:SD_LANE_CFG2 */
#define SD_LANE_25G_SD_LANE_CFG2(t) __REG(TARGET_SD_LANE_25G, t, 8, 8, 0, 1, 12, 4, 0, 1, 4)

#define SD_LANE_25G_SD_LANE_CFG2_DATA_WIDTH_SEL  GENMASK(2, 0)
#define SD_LANE_25G_SD_LANE_CFG2_DATA_WIDTH_SEL_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_DATA_WIDTH_SEL, x)
#define SD_LANE_25G_SD_LANE_CFG2_DATA_WIDTH_SEL_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_DATA_WIDTH_SEL, x)

#define SD_LANE_25G_SD_LANE_CFG2_PMA_TXCK_SEL    GENMASK(5, 3)
#define SD_LANE_25G_SD_LANE_CFG2_PMA_TXCK_SEL_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_PMA_TXCK_SEL, x)
#define SD_LANE_25G_SD_LANE_CFG2_PMA_TXCK_SEL_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_PMA_TXCK_SEL, x)

#define SD_LANE_25G_SD_LANE_CFG2_PMA_RXDIV_SEL   GENMASK(8, 6)
#define SD_LANE_25G_SD_LANE_CFG2_PMA_RXDIV_SEL_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_PMA_RXDIV_SEL, x)
#define SD_LANE_25G_SD_LANE_CFG2_PMA_RXDIV_SEL_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_PMA_RXDIV_SEL, x)

#define SD_LANE_25G_SD_LANE_CFG2_PCS2PMA_TX_SPEED GENMASK(10, 9)
#define SD_LANE_25G_SD_LANE_CFG2_PCS2PMA_TX_SPEED_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_PCS2PMA_TX_SPEED, x)
#define SD_LANE_25G_SD_LANE_CFG2_PCS2PMA_TX_SPEED_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_PCS2PMA_TX_SPEED, x)

#define SD_LANE_25G_SD_LANE_CFG2_TXFIFO_CK_DIV   GENMASK(13, 11)
#define SD_LANE_25G_SD_LANE_CFG2_TXFIFO_CK_DIV_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_TXFIFO_CK_DIV, x)
#define SD_LANE_25G_SD_LANE_CFG2_TXFIFO_CK_DIV_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_TXFIFO_CK_DIV, x)

#define SD_LANE_25G_SD_LANE_CFG2_RXFIFO_CK_DIV   GENMASK(16, 14)
#define SD_LANE_25G_SD_LANE_CFG2_RXFIFO_CK_DIV_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_RXFIFO_CK_DIV, x)
#define SD_LANE_25G_SD_LANE_CFG2_RXFIFO_CK_DIV_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_RXFIFO_CK_DIV, x)

#define SD_LANE_25G_SD_LANE_CFG2_HWT_VCO_DIV_SEL GENMASK(19, 17)
#define SD_LANE_25G_SD_LANE_CFG2_HWT_VCO_DIV_SEL_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_HWT_VCO_DIV_SEL, x)
#define SD_LANE_25G_SD_LANE_CFG2_HWT_VCO_DIV_SEL_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_HWT_VCO_DIV_SEL, x)

#define SD_LANE_25G_SD_LANE_CFG2_HWT_CFG_SEL_DIV GENMASK(23, 20)
#define SD_LANE_25G_SD_LANE_CFG2_HWT_CFG_SEL_DIV_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_HWT_CFG_SEL_DIV, x)
#define SD_LANE_25G_SD_LANE_CFG2_HWT_CFG_SEL_DIV_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_HWT_CFG_SEL_DIV, x)

#define SD_LANE_25G_SD_LANE_CFG2_HWT_PRE_DIVSEL  GENMASK(25, 24)
#define SD_LANE_25G_SD_LANE_CFG2_HWT_PRE_DIVSEL_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_HWT_PRE_DIVSEL, x)
#define SD_LANE_25G_SD_LANE_CFG2_HWT_PRE_DIVSEL_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_HWT_PRE_DIVSEL, x)

#define SD_LANE_25G_SD_LANE_CFG2_TXRATE_SEL      GENMASK(28, 26)
#define SD_LANE_25G_SD_LANE_CFG2_TXRATE_SEL_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_TXRATE_SEL, x)
#define SD_LANE_25G_SD_LANE_CFG2_TXRATE_SEL_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_TXRATE_SEL, x)

#define SD_LANE_25G_SD_LANE_CFG2_RXRATE_SEL      GENMASK(31, 29)
#define SD_LANE_25G_SD_LANE_CFG2_RXRATE_SEL_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_CFG2_RXRATE_SEL, x)
#define SD_LANE_25G_SD_LANE_CFG2_RXRATE_SEL_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_CFG2_RXRATE_SEL, x)

/*      SD25G_CFG_TARGET:SD_LANE_CFG_STAT:SD_LANE_STAT */
#define SD_LANE_25G_SD_LANE_STAT(t) __REG(TARGET_SD_LANE_25G, t, 8, 8, 0, 1, 12, 8, 0, 1, 4)

#define SD_LANE_25G_SD_LANE_STAT_PMA_RST_DONE    BIT(0)
#define SD_LANE_25G_SD_LANE_STAT_PMA_RST_DONE_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_STAT_PMA_RST_DONE, x)
#define SD_LANE_25G_SD_LANE_STAT_PMA_RST_DONE_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_STAT_PMA_RST_DONE, x)

#define SD_LANE_25G_SD_LANE_STAT_LANE_RST_DONE   BIT(1)
#define SD_LANE_25G_SD_LANE_STAT_LANE_RST_DONE_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_STAT_LANE_RST_DONE, x)
#define SD_LANE_25G_SD_LANE_STAT_LANE_RST_DONE_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_STAT_LANE_RST_DONE, x)

#define SD_LANE_25G_SD_LANE_STAT_DBG_OBS         GENMASK(31, 16)
#define SD_LANE_25G_SD_LANE_STAT_DBG_OBS_SET(x)\
	FIELD_PREP(SD_LANE_25G_SD_LANE_STAT_DBG_OBS, x)
#define SD_LANE_25G_SD_LANE_STAT_DBG_OBS_GET(x)\
	FIELD_GET(SD_LANE_25G_SD_LANE_STAT_DBG_OBS, x)

/*      SD25G_CFG_TARGET:SD_PWR_CFG:QUIET_MODE_6G */
#define SD_LANE_25G_QUIET_MODE_6G(t) \
	__REG(TARGET_SD_LANE_25G, t, 8, 28, 0, 1, 8, 4, 0, 1, 4)

#define SD_LANE_25G_QUIET_MODE_6G_QUIET_MODE     GENMASK(24, 0)
#define SD_LANE_25G_QUIET_MODE_6G_QUIET_MODE_SET(x)\
	FIELD_PREP(SD_LANE_25G_QUIET_MODE_6G_QUIET_MODE, x)
#define SD_LANE_25G_QUIET_MODE_6G_QUIET_MODE_GET(x)\
	FIELD_GET(SD_LANE_25G_QUIET_MODE_6G_QUIET_MODE, x)

#endif /* _SPARX5_SERDES_REGS_H_ */
