; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+experimental-zfh \
; RUN:   -verify-machineinstrs -target-abi ilp32f | \
; RUN:   FileCheck -check-prefix=RV32IZFH %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d \
; RUN:   -mattr=+experimental-zfh -verify-machineinstrs -target-abi ilp32d | \
; RUN:   FileCheck -check-prefix=RV32IDZFH %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+experimental-zfh \
; RUN:   -verify-machineinstrs -target-abi lp64f | \
; RUN:   FileCheck -check-prefix=RV64IZFH %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+d \
; RUN:   -mattr=+experimental-zfh -verify-machineinstrs -target-abi lp64d | \
; RUN:   FileCheck -check-prefix=RV64IDZFH %s

declare half @llvm.sqrt.f16(half)

define half @sqrt_f16(half %a) nounwind {
; RV32IZFH-LABEL: sqrt_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fsqrt.h fa0, fa0
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: sqrt_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fsqrt.h fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: sqrt_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fsqrt.h fa0, fa0
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: sqrt_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fsqrt.h fa0, fa0
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.sqrt.f16(half %a)
  ret half %1
}

declare half @llvm.fma.f16(half, half, half)

define half @fma_f16(half %a, half %b, half %c) nounwind {
; RV32IZFH-LABEL: fma_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: fma_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fma_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fma_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.fma.f16(half %a, half %b, half %c)
  ret half %1
}

declare half @llvm.fmuladd.f16(half, half, half)

define half @fmuladd_f16(half %a, half %b, half %c) nounwind {
; RV32IZFH-LABEL: fmuladd_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: fmuladd_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fmuladd_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fmuladd_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmadd.h fa0, fa0, fa1, fa2
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.fmuladd.f16(half %a, half %b, half %c)
  ret half %1
}

declare half @llvm.fabs.f16(half)

define half @fabs_f16(half %a) nounwind {
; RV32IZFH-LABEL: fabs_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fabs.h fa0, fa0
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: fabs_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fabs.h fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fabs_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fabs.h fa0, fa0
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fabs_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fabs.h fa0, fa0
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.fabs.f16(half %a)
  ret half %1
}

declare half @llvm.minnum.f16(half, half)

define half @minnum_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: minnum_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: minnum_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: minnum_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: minnum_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmin.h fa0, fa0, fa1
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.minnum.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.maxnum.f16(half, half)

define half @maxnum_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: maxnum_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: maxnum_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: maxnum_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: maxnum_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fmax.h fa0, fa0, fa1
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.maxnum.f16(half %a, half %b)
  ret half %1
}

declare half @llvm.copysign.f16(half, half)

define half @copysign_f16(half %a, half %b) nounwind {
; RV32IZFH-LABEL: copysign_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: copysign_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: copysign_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: copysign_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fsgnj.h fa0, fa0, fa1
; RV64IDZFH-NEXT:    ret
  %1 = call half @llvm.copysign.f16(half %a, half %b)
  ret half %1
}

declare iXLen @llvm.lrint.iXLen.f16(float)

define iXLen @lrint_f16(float %a) nounwind {
; RV32IZFH-LABEL: lrint_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.s a0, fa0
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: lrint_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.w.s a0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: lrint_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.s a0, fa0
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: lrint_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.l.s a0, fa0
; RV64IDZFH-NEXT:    ret
  %1 = call iXLen @llvm.lrint.iXLen.f16(float %a)
  ret iXLen %1
}

declare iXLen @llvm.lround.iXLen.f16(float)

define iXLen @lround_f16(float %a) nounwind {
; RV32IZFH-LABEL: lround_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.s a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: lround_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.w.s a0, fa0, rmm
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: lround_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.s a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: lround_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.l.s a0, fa0, rmm
; RV64IDZFH-NEXT:    ret
  %1 = call iXLen @llvm.lround.iXLen.f16(float %a)
  ret iXLen %1
}

declare i64 @llvm.llrint.i64.f16(float)

define i64 @llrint_f16(float %a) nounwind {
; RV32IZFH-LABEL: llrint_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    call llrintf@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: llrint_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -16
; RV32IDZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    call llrintf@plt
; RV32IDZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 16
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: llrint_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.s a0, fa0
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: llrint_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.l.s a0, fa0
; RV64IDZFH-NEXT:    ret
  %1 = call i64 @llvm.llrint.i64.f16(float %a)
  ret i64 %1
}

declare i64 @llvm.llround.i64.f16(float)

define i64 @llround_f16(float %a) nounwind {
; RV32IZFH-LABEL: llround_f16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    call llroundf@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV32IDZFH-LABEL: llround_f16:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -16
; RV32IDZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    call llroundf@plt
; RV32IDZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 16
; RV32IDZFH-NEXT:    ret
;
; RV64IZFH-LABEL: llround_f16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.s a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: llround_f16:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.l.s a0, fa0, rmm
; RV64IDZFH-NEXT:    ret
  %1 = call i64 @llvm.llround.i64.f16(float %a)
  ret i64 %1
}
