; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instsimplify < %s | FileCheck %s

declare double @llvm.log2.f64(double)
declare double @llvm.pow.f64(double, double)

define double @log2_pow2(double %x) {
; CHECK-LABEL: @log2_pow2(
; CHECK-NEXT:    [[TMP:%.*]] = call double @llvm.pow.f64(double 2.000000e+00, double [[X:%.*]])
; CHECK-NEXT:    [[TMP1:%.*]] = call double @llvm.log2.f64(double [[TMP]])
; CHECK-NEXT:    ret double [[TMP1]]
;
  %tmp = call double @llvm.pow.f64(double 2.000000e+00, double %x)
  %tmp1 = call double @llvm.log2.f64(double %tmp)
  ret double %tmp1
}

define double @log2_strict_pow2_reassoc(double %x) {
; CHECK-LABEL: @log2_strict_pow2_reassoc(
; CHECK-NEXT:    [[TMP:%.*]] = call reassoc double @llvm.pow.f64(double 2.000000e+00, double [[X:%.*]])
; CHECK-NEXT:    [[TMP1:%.*]] = call double @llvm.log2.f64(double [[TMP]])
; CHECK-NEXT:    ret double [[TMP1]]
;
  %tmp = call reassoc double @llvm.pow.f64(double 2.000000e+00, double %x)
  %tmp1 = call double @llvm.log2.f64(double %tmp)
  ret double %tmp1
}

define double @log2_reassoc_pow2_strict(double %x) {
; CHECK-LABEL: @log2_reassoc_pow2_strict(
; CHECK-NEXT:    ret double [[X:%.*]]
;
  %tmp = call double @llvm.pow.f64(double 2.000000e+00, double %x)
  %tmp1 = call reassoc double @llvm.log2.f64(double %tmp)
  ret double %tmp1
}

define double @log2_pow2_reassoc(double %x) {
; CHECK-LABEL: @log2_pow2_reassoc(
; CHECK-NEXT:    ret double [[X:%.*]]
;
  %tmp = call reassoc double @llvm.pow.f64(double 2.000000e+00, double %x)
  %tmp1 = call reassoc double @llvm.log2.f64(double %tmp)
  ret double %tmp1
}
