// RUN: llvm-mc -triple x86_64-unknown-unknown -mcpu=knl -mattr=+avx512vl --show-encoding %s | FileCheck %s

// CHECK: vaddpd %xmm19, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xa1,0x95,0x00,0x58,0xe3]
          vaddpd %xmm19, %xmm29, %xmm20

// CHECK: vaddpd %xmm19, %xmm29, %xmm20 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x95,0x07,0x58,0xe3]
          vaddpd %xmm19, %xmm29, %xmm20 {%k7}

// CHECK: vaddpd %xmm19, %xmm29, %xmm20 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x95,0x87,0x58,0xe3]
          vaddpd %xmm19, %xmm29, %xmm20 {%k7} {z}

// CHECK: vaddpd (%rcx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x58,0x21]
          vaddpd (%rcx), %xmm29, %xmm20

// CHECK: vaddpd 291(%rax,%r14,8), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xa1,0x95,0x00,0x58,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vaddpd 291(%rax,%r14,8), %xmm29, %xmm20

// CHECK: vaddpd (%rcx){1to2}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x58,0x21]
          vaddpd (%rcx){1to2}, %xmm29, %xmm20

// CHECK: vaddpd 2032(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x58,0x62,0x7f]
          vaddpd 2032(%rdx), %xmm29, %xmm20

// CHECK: vaddpd 2048(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x58,0xa2,0x00,0x08,0x00,0x00]
          vaddpd 2048(%rdx), %xmm29, %xmm20

// CHECK: vaddpd -2048(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x58,0x62,0x80]
          vaddpd -2048(%rdx), %xmm29, %xmm20

// CHECK: vaddpd -2064(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x58,0xa2,0xf0,0xf7,0xff,0xff]
          vaddpd -2064(%rdx), %xmm29, %xmm20

// CHECK: vaddpd 1016(%rdx){1to2}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x58,0x62,0x7f]
          vaddpd 1016(%rdx){1to2}, %xmm29, %xmm20

// CHECK: vaddpd 1024(%rdx){1to2}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x58,0xa2,0x00,0x04,0x00,0x00]
          vaddpd 1024(%rdx){1to2}, %xmm29, %xmm20

// CHECK: vaddpd -1024(%rdx){1to2}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x58,0x62,0x80]
          vaddpd -1024(%rdx){1to2}, %xmm29, %xmm20

// CHECK: vaddpd -1032(%rdx){1to2}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x58,0xa2,0xf8,0xfb,0xff,0xff]
          vaddpd -1032(%rdx){1to2}, %xmm29, %xmm20

// CHECK: vaddpd %ymm26, %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x01,0xad,0x20,0x58,0xe2]
          vaddpd %ymm26, %ymm26, %ymm28

// CHECK: vaddpd %ymm26, %ymm26, %ymm28 {%k1}
// CHECK:  encoding: [0x62,0x01,0xad,0x21,0x58,0xe2]
          vaddpd %ymm26, %ymm26, %ymm28 {%k1}

// CHECK: vaddpd %ymm26, %ymm26, %ymm28 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0xad,0xa1,0x58,0xe2]
          vaddpd %ymm26, %ymm26, %ymm28 {%k1} {z}

// CHECK: vaddpd (%rcx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0x58,0x21]
          vaddpd (%rcx), %ymm26, %ymm28

// CHECK: vaddpd 291(%rax,%r14,8), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x21,0xad,0x20,0x58,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vaddpd 291(%rax,%r14,8), %ymm26, %ymm28

// CHECK: vaddpd (%rcx){1to4}, %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0x58,0x21]
          vaddpd (%rcx){1to4}, %ymm26, %ymm28

// CHECK: vaddpd 4064(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0x58,0x62,0x7f]
          vaddpd 4064(%rdx), %ymm26, %ymm28

// CHECK: vaddpd 4096(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0x58,0xa2,0x00,0x10,0x00,0x00]
          vaddpd 4096(%rdx), %ymm26, %ymm28

// CHECK: vaddpd -4096(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0x58,0x62,0x80]
          vaddpd -4096(%rdx), %ymm26, %ymm28

// CHECK: vaddpd -4128(%rdx), %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0x58,0xa2,0xe0,0xef,0xff,0xff]
          vaddpd -4128(%rdx), %ymm26, %ymm28

// CHECK: vaddpd 1016(%rdx){1to4}, %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0x58,0x62,0x7f]
          vaddpd 1016(%rdx){1to4}, %ymm26, %ymm28

// CHECK: vaddpd 1024(%rdx){1to4}, %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0x58,0xa2,0x00,0x04,0x00,0x00]
          vaddpd 1024(%rdx){1to4}, %ymm26, %ymm28

// CHECK: vaddpd -1024(%rdx){1to4}, %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0x58,0x62,0x80]
          vaddpd -1024(%rdx){1to4}, %ymm26, %ymm28

// CHECK: vaddpd -1032(%rdx){1to4}, %ymm26, %ymm28
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0x58,0xa2,0xf8,0xfb,0xff,0xff]
          vaddpd -1032(%rdx){1to4}, %ymm26, %ymm28

// CHECK: vaddps %xmm27, %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x01,0x64,0x00,0x58,0xc3]
          vaddps %xmm27, %xmm19, %xmm24

// CHECK: vaddps %xmm27, %xmm19, %xmm24 {%k4}
// CHECK:  encoding: [0x62,0x01,0x64,0x04,0x58,0xc3]
          vaddps %xmm27, %xmm19, %xmm24 {%k4}

// CHECK: vaddps %xmm27, %xmm19, %xmm24 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0x64,0x84,0x58,0xc3]
          vaddps %xmm27, %xmm19, %xmm24 {%k4} {z}

// CHECK: vaddps (%rcx), %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x00,0x58,0x01]
          vaddps (%rcx), %xmm19, %xmm24

// CHECK: vaddps 291(%rax,%r14,8), %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x21,0x64,0x00,0x58,0x84,0xf0,0x23,0x01,0x00,0x00]
          vaddps 291(%rax,%r14,8), %xmm19, %xmm24

// CHECK: vaddps (%rcx){1to4}, %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x10,0x58,0x01]
          vaddps (%rcx){1to4}, %xmm19, %xmm24

// CHECK: vaddps 2032(%rdx), %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x00,0x58,0x42,0x7f]
          vaddps 2032(%rdx), %xmm19, %xmm24

// CHECK: vaddps 2048(%rdx), %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x00,0x58,0x82,0x00,0x08,0x00,0x00]
          vaddps 2048(%rdx), %xmm19, %xmm24

// CHECK: vaddps -2048(%rdx), %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x00,0x58,0x42,0x80]
          vaddps -2048(%rdx), %xmm19, %xmm24

// CHECK: vaddps -2064(%rdx), %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x00,0x58,0x82,0xf0,0xf7,0xff,0xff]
          vaddps -2064(%rdx), %xmm19, %xmm24

// CHECK: vaddps 508(%rdx){1to4}, %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x10,0x58,0x42,0x7f]
          vaddps 508(%rdx){1to4}, %xmm19, %xmm24

// CHECK: vaddps 512(%rdx){1to4}, %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x10,0x58,0x82,0x00,0x02,0x00,0x00]
          vaddps 512(%rdx){1to4}, %xmm19, %xmm24

// CHECK: vaddps -512(%rdx){1to4}, %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x10,0x58,0x42,0x80]
          vaddps -512(%rdx){1to4}, %xmm19, %xmm24

// CHECK: vaddps -516(%rdx){1to4}, %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x61,0x64,0x10,0x58,0x82,0xfc,0xfd,0xff,0xff]
          vaddps -516(%rdx){1to4}, %xmm19, %xmm24

// CHECK: vaddps %ymm20, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x21,0x2c,0x20,0x58,0xcc]
          vaddps %ymm20, %ymm26, %ymm25

// CHECK: vaddps %ymm20, %ymm26, %ymm25 {%k4}
// CHECK:  encoding: [0x62,0x21,0x2c,0x24,0x58,0xcc]
          vaddps %ymm20, %ymm26, %ymm25 {%k4}

// CHECK: vaddps %ymm20, %ymm26, %ymm25 {%k4} {z}
// CHECK:  encoding: [0x62,0x21,0x2c,0xa4,0x58,0xcc]
          vaddps %ymm20, %ymm26, %ymm25 {%k4} {z}

// CHECK: vaddps (%rcx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x58,0x09]
          vaddps (%rcx), %ymm26, %ymm25

// CHECK: vaddps 291(%rax,%r14,8), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x21,0x2c,0x20,0x58,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vaddps 291(%rax,%r14,8), %ymm26, %ymm25

// CHECK: vaddps (%rcx){1to8}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x58,0x09]
          vaddps (%rcx){1to8}, %ymm26, %ymm25

// CHECK: vaddps 4064(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x58,0x4a,0x7f]
          vaddps 4064(%rdx), %ymm26, %ymm25

// CHECK: vaddps 4096(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x58,0x8a,0x00,0x10,0x00,0x00]
          vaddps 4096(%rdx), %ymm26, %ymm25

// CHECK: vaddps -4096(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x58,0x4a,0x80]
          vaddps -4096(%rdx), %ymm26, %ymm25

// CHECK: vaddps -4128(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x58,0x8a,0xe0,0xef,0xff,0xff]
          vaddps -4128(%rdx), %ymm26, %ymm25

// CHECK: vaddps 508(%rdx){1to8}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x58,0x4a,0x7f]
          vaddps 508(%rdx){1to8}, %ymm26, %ymm25

// CHECK: vaddps 512(%rdx){1to8}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x58,0x8a,0x00,0x02,0x00,0x00]
          vaddps 512(%rdx){1to8}, %ymm26, %ymm25

// CHECK: vaddps -512(%rdx){1to8}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x58,0x4a,0x80]
          vaddps -512(%rdx){1to8}, %ymm26, %ymm25

// CHECK: vaddps -516(%rdx){1to8}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x58,0x8a,0xfc,0xfd,0xff,0xff]
          vaddps -516(%rdx){1to8}, %ymm26, %ymm25

// CHECK: vbroadcastsd (%rcx), %ymm22
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x19,0x31]
          vbroadcastsd (%rcx), %ymm22

// CHECK: vbroadcastsd (%rcx), %ymm22 {%k5}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x2d,0x19,0x31]
          vbroadcastsd (%rcx), %ymm22 {%k5}

// CHECK: vbroadcastsd (%rcx), %ymm22 {%k5} {z}
// CHECK:  encoding: [0x62,0xe2,0xfd,0xad,0x19,0x31]
          vbroadcastsd (%rcx), %ymm22 {%k5} {z}

// CHECK: vbroadcastsd 291(%rax,%r14,8), %ymm22
// CHECK:  encoding: [0x62,0xa2,0xfd,0x28,0x19,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastsd 291(%rax,%r14,8), %ymm22

// CHECK: vbroadcastsd 1016(%rdx), %ymm22
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x19,0x72,0x7f]
          vbroadcastsd 1016(%rdx), %ymm22

// CHECK: vbroadcastsd 1024(%rdx), %ymm22
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x19,0xb2,0x00,0x04,0x00,0x00]
          vbroadcastsd 1024(%rdx), %ymm22

// CHECK: vbroadcastsd -1024(%rdx), %ymm22
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x19,0x72,0x80]
          vbroadcastsd -1024(%rdx), %ymm22

// CHECK: vbroadcastsd -1032(%rdx), %ymm22
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x19,0xb2,0xf8,0xfb,0xff,0xff]
          vbroadcastsd -1032(%rdx), %ymm22

// CHECK: vbroadcastsd %xmm17, %ymm19
// CHECK:  encoding: [0x62,0xa2,0xfd,0x28,0x19,0xd9]
          vbroadcastsd %xmm17, %ymm19

// CHECK: vbroadcastsd %xmm17, %ymm19 {%k6}
// CHECK:  encoding: [0x62,0xa2,0xfd,0x2e,0x19,0xd9]
          vbroadcastsd %xmm17, %ymm19 {%k6}

// CHECK: vbroadcastsd %xmm17, %ymm19 {%k6} {z}
// CHECK:  encoding: [0x62,0xa2,0xfd,0xae,0x19,0xd9]
          vbroadcastsd %xmm17, %ymm19 {%k6} {z}

// CHECK: vbroadcastss (%rcx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x18,0x29]
          vbroadcastss (%rcx), %xmm21

// CHECK: vbroadcastss (%rcx), %xmm21 {%k2}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x0a,0x18,0x29]
          vbroadcastss (%rcx), %xmm21 {%k2}

// CHECK: vbroadcastss (%rcx), %xmm21 {%k2} {z}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x8a,0x18,0x29]
          vbroadcastss (%rcx), %xmm21 {%k2} {z}

// CHECK: vbroadcastss 291(%rax,%r14,8), %xmm21
// CHECK:  encoding: [0x62,0xa2,0x7d,0x08,0x18,0xac,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastss 291(%rax,%r14,8), %xmm21

// CHECK: vbroadcastss 508(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x18,0x6a,0x7f]
          vbroadcastss 508(%rdx), %xmm21

// CHECK: vbroadcastss 512(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x18,0xaa,0x00,0x02,0x00,0x00]
          vbroadcastss 512(%rdx), %xmm21

// CHECK: vbroadcastss -512(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x18,0x6a,0x80]
          vbroadcastss -512(%rdx), %xmm21

// CHECK: vbroadcastss -516(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x18,0xaa,0xfc,0xfd,0xff,0xff]
          vbroadcastss -516(%rdx), %xmm21

// CHECK: vbroadcastss (%rcx), %ymm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x18,0x31]
          vbroadcastss (%rcx), %ymm30

// CHECK: vbroadcastss (%rcx), %ymm30 {%k1}
// CHECK:  encoding: [0x62,0x62,0x7d,0x29,0x18,0x31]
          vbroadcastss (%rcx), %ymm30 {%k1}

// CHECK: vbroadcastss (%rcx), %ymm30 {%k1} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xa9,0x18,0x31]
          vbroadcastss (%rcx), %ymm30 {%k1} {z}

// CHECK: vbroadcastss 291(%rax,%r14,8), %ymm30
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x18,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vbroadcastss 291(%rax,%r14,8), %ymm30

// CHECK: vbroadcastss 508(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x18,0x72,0x7f]
          vbroadcastss 508(%rdx), %ymm30

// CHECK: vbroadcastss 512(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x18,0xb2,0x00,0x02,0x00,0x00]
          vbroadcastss 512(%rdx), %ymm30

// CHECK: vbroadcastss -512(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x18,0x72,0x80]
          vbroadcastss -512(%rdx), %ymm30

// CHECK: vbroadcastss -516(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x18,0xb2,0xfc,0xfd,0xff,0xff]
          vbroadcastss -516(%rdx), %ymm30

// CHECK: vbroadcastss %xmm24, %xmm24
// CHECK:  encoding: [0x62,0x02,0x7d,0x08,0x18,0xc0]
          vbroadcastss %xmm24, %xmm24

// CHECK: vbroadcastss %xmm24, %xmm24 {%k2}
// CHECK:  encoding: [0x62,0x02,0x7d,0x0a,0x18,0xc0]
          vbroadcastss %xmm24, %xmm24 {%k2}

// CHECK: vbroadcastss %xmm24, %xmm24 {%k2} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0x8a,0x18,0xc0]
          vbroadcastss %xmm24, %xmm24 {%k2} {z}

// CHECK: vbroadcastss %xmm28, %ymm24
// CHECK:  encoding: [0x62,0x02,0x7d,0x28,0x18,0xc4]
          vbroadcastss %xmm28, %ymm24

// CHECK: vbroadcastss %xmm28, %ymm24 {%k6}
// CHECK:  encoding: [0x62,0x02,0x7d,0x2e,0x18,0xc4]
          vbroadcastss %xmm28, %ymm24 {%k6}

// CHECK: vbroadcastss %xmm28, %ymm24 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0xae,0x18,0xc4]
          vbroadcastss %xmm28, %ymm24 {%k6} {z}

// CHECK: vdivpd %xmm27, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0x81,0xed,0x00,0x5e,0xdb]
          vdivpd %xmm27, %xmm18, %xmm19

// CHECK: vdivpd %xmm27, %xmm18, %xmm19 {%k3}
// CHECK:  encoding: [0x62,0x81,0xed,0x03,0x5e,0xdb]
          vdivpd %xmm27, %xmm18, %xmm19 {%k3}

// CHECK: vdivpd %xmm27, %xmm18, %xmm19 {%k3} {z}
// CHECK:  encoding: [0x62,0x81,0xed,0x83,0x5e,0xdb]
          vdivpd %xmm27, %xmm18, %xmm19 {%k3} {z}

// CHECK: vdivpd (%rcx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x5e,0x19]
          vdivpd (%rcx), %xmm18, %xmm19

// CHECK: vdivpd 291(%rax,%r14,8), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xa1,0xed,0x00,0x5e,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vdivpd 291(%rax,%r14,8), %xmm18, %xmm19

// CHECK: vdivpd (%rcx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x5e,0x19]
          vdivpd (%rcx){1to2}, %xmm18, %xmm19

// CHECK: vdivpd 2032(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x5e,0x5a,0x7f]
          vdivpd 2032(%rdx), %xmm18, %xmm19

// CHECK: vdivpd 2048(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x5e,0x9a,0x00,0x08,0x00,0x00]
          vdivpd 2048(%rdx), %xmm18, %xmm19

// CHECK: vdivpd -2048(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x5e,0x5a,0x80]
          vdivpd -2048(%rdx), %xmm18, %xmm19

// CHECK: vdivpd -2064(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x00,0x5e,0x9a,0xf0,0xf7,0xff,0xff]
          vdivpd -2064(%rdx), %xmm18, %xmm19

// CHECK: vdivpd 1016(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x5e,0x5a,0x7f]
          vdivpd 1016(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vdivpd 1024(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x5e,0x9a,0x00,0x04,0x00,0x00]
          vdivpd 1024(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vdivpd -1024(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x5e,0x5a,0x80]
          vdivpd -1024(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vdivpd -1032(%rdx){1to2}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0xed,0x10,0x5e,0x9a,0xf8,0xfb,0xff,0xff]
          vdivpd -1032(%rdx){1to2}, %xmm18, %xmm19

// CHECK: vdivpd %ymm28, %ymm24, %ymm23
// CHECK:  encoding: [0x62,0x81,0xbd,0x20,0x5e,0xfc]
          vdivpd %ymm28, %ymm24, %ymm23

// CHECK: vdivpd %ymm28, %ymm24, %ymm23 {%k6}
// CHECK:  encoding: [0x62,0x81,0xbd,0x26,0x5e,0xfc]
          vdivpd %ymm28, %ymm24, %ymm23 {%k6}

// CHECK: vdivpd %ymm28, %ymm24, %ymm23 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0xbd,0xa6,0x5e,0xfc]
          vdivpd %ymm28, %ymm24, %ymm23 {%k6} {z}

// CHECK: vdivpd (%rcx), %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5e,0x39]
          vdivpd (%rcx), %ymm24, %ymm23

// CHECK: vdivpd 291(%rax,%r14,8), %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xa1,0xbd,0x20,0x5e,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vdivpd 291(%rax,%r14,8), %ymm24, %ymm23

// CHECK: vdivpd (%rcx){1to4}, %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5e,0x39]
          vdivpd (%rcx){1to4}, %ymm24, %ymm23

// CHECK: vdivpd 4064(%rdx), %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5e,0x7a,0x7f]
          vdivpd 4064(%rdx), %ymm24, %ymm23

// CHECK: vdivpd 4096(%rdx), %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5e,0xba,0x00,0x10,0x00,0x00]
          vdivpd 4096(%rdx), %ymm24, %ymm23

// CHECK: vdivpd -4096(%rdx), %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5e,0x7a,0x80]
          vdivpd -4096(%rdx), %ymm24, %ymm23

// CHECK: vdivpd -4128(%rdx), %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5e,0xba,0xe0,0xef,0xff,0xff]
          vdivpd -4128(%rdx), %ymm24, %ymm23

// CHECK: vdivpd 1016(%rdx){1to4}, %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5e,0x7a,0x7f]
          vdivpd 1016(%rdx){1to4}, %ymm24, %ymm23

// CHECK: vdivpd 1024(%rdx){1to4}, %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5e,0xba,0x00,0x04,0x00,0x00]
          vdivpd 1024(%rdx){1to4}, %ymm24, %ymm23

// CHECK: vdivpd -1024(%rdx){1to4}, %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5e,0x7a,0x80]
          vdivpd -1024(%rdx){1to4}, %ymm24, %ymm23

// CHECK: vdivpd -1032(%rdx){1to4}, %ymm24, %ymm23
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5e,0xba,0xf8,0xfb,0xff,0xff]
          vdivpd -1032(%rdx){1to4}, %ymm24, %ymm23

// CHECK: vdivps %xmm26, %xmm24, %xmm17
// CHECK:  encoding: [0x62,0x81,0x3c,0x00,0x5e,0xca]
          vdivps %xmm26, %xmm24, %xmm17

// CHECK: vdivps %xmm26, %xmm24, %xmm17 {%k2}
// CHECK:  encoding: [0x62,0x81,0x3c,0x02,0x5e,0xca]
          vdivps %xmm26, %xmm24, %xmm17 {%k2}

// CHECK: vdivps %xmm26, %xmm24, %xmm17 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x3c,0x82,0x5e,0xca]
          vdivps %xmm26, %xmm24, %xmm17 {%k2} {z}

// CHECK: vdivps (%rcx), %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x00,0x5e,0x09]
          vdivps (%rcx), %xmm24, %xmm17

// CHECK: vdivps 291(%rax,%r14,8), %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x3c,0x00,0x5e,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vdivps 291(%rax,%r14,8), %xmm24, %xmm17

// CHECK: vdivps (%rcx){1to4}, %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x10,0x5e,0x09]
          vdivps (%rcx){1to4}, %xmm24, %xmm17

// CHECK: vdivps 2032(%rdx), %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x00,0x5e,0x4a,0x7f]
          vdivps 2032(%rdx), %xmm24, %xmm17

// CHECK: vdivps 2048(%rdx), %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x00,0x5e,0x8a,0x00,0x08,0x00,0x00]
          vdivps 2048(%rdx), %xmm24, %xmm17

// CHECK: vdivps -2048(%rdx), %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x00,0x5e,0x4a,0x80]
          vdivps -2048(%rdx), %xmm24, %xmm17

// CHECK: vdivps -2064(%rdx), %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x00,0x5e,0x8a,0xf0,0xf7,0xff,0xff]
          vdivps -2064(%rdx), %xmm24, %xmm17

// CHECK: vdivps 508(%rdx){1to4}, %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x10,0x5e,0x4a,0x7f]
          vdivps 508(%rdx){1to4}, %xmm24, %xmm17

// CHECK: vdivps 512(%rdx){1to4}, %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x10,0x5e,0x8a,0x00,0x02,0x00,0x00]
          vdivps 512(%rdx){1to4}, %xmm24, %xmm17

// CHECK: vdivps -512(%rdx){1to4}, %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x10,0x5e,0x4a,0x80]
          vdivps -512(%rdx){1to4}, %xmm24, %xmm17

// CHECK: vdivps -516(%rdx){1to4}, %xmm24, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x3c,0x10,0x5e,0x8a,0xfc,0xfd,0xff,0xff]
          vdivps -516(%rdx){1to4}, %xmm24, %xmm17

// CHECK: vdivps %ymm17, %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xa1,0x24,0x20,0x5e,0xc9]
          vdivps %ymm17, %ymm27, %ymm17

// CHECK: vdivps %ymm17, %ymm27, %ymm17 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x24,0x26,0x5e,0xc9]
          vdivps %ymm17, %ymm27, %ymm17 {%k6}

// CHECK: vdivps %ymm17, %ymm27, %ymm17 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x24,0xa6,0x5e,0xc9]
          vdivps %ymm17, %ymm27, %ymm17 {%k6} {z}

// CHECK: vdivps (%rcx), %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x20,0x5e,0x09]
          vdivps (%rcx), %ymm27, %ymm17

// CHECK: vdivps 291(%rax,%r14,8), %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xa1,0x24,0x20,0x5e,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vdivps 291(%rax,%r14,8), %ymm27, %ymm17

// CHECK: vdivps (%rcx){1to8}, %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x30,0x5e,0x09]
          vdivps (%rcx){1to8}, %ymm27, %ymm17

// CHECK: vdivps 4064(%rdx), %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x20,0x5e,0x4a,0x7f]
          vdivps 4064(%rdx), %ymm27, %ymm17

// CHECK: vdivps 4096(%rdx), %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x20,0x5e,0x8a,0x00,0x10,0x00,0x00]
          vdivps 4096(%rdx), %ymm27, %ymm17

// CHECK: vdivps -4096(%rdx), %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x20,0x5e,0x4a,0x80]
          vdivps -4096(%rdx), %ymm27, %ymm17

// CHECK: vdivps -4128(%rdx), %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x20,0x5e,0x8a,0xe0,0xef,0xff,0xff]
          vdivps -4128(%rdx), %ymm27, %ymm17

// CHECK: vdivps 508(%rdx){1to8}, %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x30,0x5e,0x4a,0x7f]
          vdivps 508(%rdx){1to8}, %ymm27, %ymm17

// CHECK: vdivps 512(%rdx){1to8}, %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x30,0x5e,0x8a,0x00,0x02,0x00,0x00]
          vdivps 512(%rdx){1to8}, %ymm27, %ymm17

// CHECK: vdivps -512(%rdx){1to8}, %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x30,0x5e,0x4a,0x80]
          vdivps -512(%rdx){1to8}, %ymm27, %ymm17

// CHECK: vdivps -516(%rdx){1to8}, %ymm27, %ymm17
// CHECK:  encoding: [0x62,0xe1,0x24,0x30,0x5e,0x8a,0xfc,0xfd,0xff,0xff]
          vdivps -516(%rdx){1to8}, %ymm27, %ymm17

// CHECK: vmaxpd %xmm23, %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x95,0x00,0x5f,0xcf]
          vmaxpd %xmm23, %xmm29, %xmm17

// CHECK: vmaxpd %xmm23, %xmm29, %xmm17 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x95,0x06,0x5f,0xcf]
          vmaxpd %xmm23, %xmm29, %xmm17 {%k6}

// CHECK: vmaxpd %xmm23, %xmm29, %xmm17 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x95,0x86,0x5f,0xcf]
          vmaxpd %xmm23, %xmm29, %xmm17 {%k6} {z}

// CHECK: vmaxpd (%rcx), %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x5f,0x09]
          vmaxpd (%rcx), %xmm29, %xmm17

// CHECK: vmaxpd 291(%rax,%r14,8), %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x95,0x00,0x5f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmaxpd 291(%rax,%r14,8), %xmm29, %xmm17

// CHECK: vmaxpd (%rcx){1to2}, %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x5f,0x09]
          vmaxpd (%rcx){1to2}, %xmm29, %xmm17

// CHECK: vmaxpd 2032(%rdx), %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x5f,0x4a,0x7f]
          vmaxpd 2032(%rdx), %xmm29, %xmm17

// CHECK: vmaxpd 2048(%rdx), %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x5f,0x8a,0x00,0x08,0x00,0x00]
          vmaxpd 2048(%rdx), %xmm29, %xmm17

// CHECK: vmaxpd -2048(%rdx), %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x5f,0x4a,0x80]
          vmaxpd -2048(%rdx), %xmm29, %xmm17

// CHECK: vmaxpd -2064(%rdx), %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x00,0x5f,0x8a,0xf0,0xf7,0xff,0xff]
          vmaxpd -2064(%rdx), %xmm29, %xmm17

// CHECK: vmaxpd 1016(%rdx){1to2}, %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x5f,0x4a,0x7f]
          vmaxpd 1016(%rdx){1to2}, %xmm29, %xmm17

// CHECK: vmaxpd 1024(%rdx){1to2}, %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x5f,0x8a,0x00,0x04,0x00,0x00]
          vmaxpd 1024(%rdx){1to2}, %xmm29, %xmm17

// CHECK: vmaxpd -1024(%rdx){1to2}, %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x5f,0x4a,0x80]
          vmaxpd -1024(%rdx){1to2}, %xmm29, %xmm17

// CHECK: vmaxpd -1032(%rdx){1to2}, %xmm29, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x95,0x10,0x5f,0x8a,0xf8,0xfb,0xff,0xff]
          vmaxpd -1032(%rdx){1to2}, %xmm29, %xmm17

// CHECK: vmaxpd %ymm24, %ymm24, %ymm21
// CHECK:  encoding: [0x62,0x81,0xbd,0x20,0x5f,0xe8]
          vmaxpd %ymm24, %ymm24, %ymm21

// CHECK: vmaxpd %ymm24, %ymm24, %ymm21 {%k1}
// CHECK:  encoding: [0x62,0x81,0xbd,0x21,0x5f,0xe8]
          vmaxpd %ymm24, %ymm24, %ymm21 {%k1}

// CHECK: vmaxpd %ymm24, %ymm24, %ymm21 {%k1} {z}
// CHECK:  encoding: [0x62,0x81,0xbd,0xa1,0x5f,0xe8]
          vmaxpd %ymm24, %ymm24, %ymm21 {%k1} {z}

// CHECK: vmaxpd (%rcx), %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5f,0x29]
          vmaxpd (%rcx), %ymm24, %ymm21

// CHECK: vmaxpd 291(%rax,%r14,8), %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xa1,0xbd,0x20,0x5f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmaxpd 291(%rax,%r14,8), %ymm24, %ymm21

// CHECK: vmaxpd (%rcx){1to4}, %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5f,0x29]
          vmaxpd (%rcx){1to4}, %ymm24, %ymm21

// CHECK: vmaxpd 4064(%rdx), %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5f,0x6a,0x7f]
          vmaxpd 4064(%rdx), %ymm24, %ymm21

// CHECK: vmaxpd 4096(%rdx), %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5f,0xaa,0x00,0x10,0x00,0x00]
          vmaxpd 4096(%rdx), %ymm24, %ymm21

// CHECK: vmaxpd -4096(%rdx), %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5f,0x6a,0x80]
          vmaxpd -4096(%rdx), %ymm24, %ymm21

// CHECK: vmaxpd -4128(%rdx), %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x20,0x5f,0xaa,0xe0,0xef,0xff,0xff]
          vmaxpd -4128(%rdx), %ymm24, %ymm21

// CHECK: vmaxpd 1016(%rdx){1to4}, %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5f,0x6a,0x7f]
          vmaxpd 1016(%rdx){1to4}, %ymm24, %ymm21

// CHECK: vmaxpd 1024(%rdx){1to4}, %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5f,0xaa,0x00,0x04,0x00,0x00]
          vmaxpd 1024(%rdx){1to4}, %ymm24, %ymm21

// CHECK: vmaxpd -1024(%rdx){1to4}, %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5f,0x6a,0x80]
          vmaxpd -1024(%rdx){1to4}, %ymm24, %ymm21

// CHECK: vmaxpd -1032(%rdx){1to4}, %ymm24, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xbd,0x30,0x5f,0xaa,0xf8,0xfb,0xff,0xff]
          vmaxpd -1032(%rdx){1to4}, %ymm24, %ymm21

// CHECK: vmaxps %xmm19, %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x21,0x5c,0x00,0x5f,0xc3]
          vmaxps %xmm19, %xmm20, %xmm24

// CHECK: vmaxps %xmm19, %xmm20, %xmm24 {%k6}
// CHECK:  encoding: [0x62,0x21,0x5c,0x06,0x5f,0xc3]
          vmaxps %xmm19, %xmm20, %xmm24 {%k6}

// CHECK: vmaxps %xmm19, %xmm20, %xmm24 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0x5c,0x86,0x5f,0xc3]
          vmaxps %xmm19, %xmm20, %xmm24 {%k6} {z}

// CHECK: vmaxps (%rcx), %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x00,0x5f,0x01]
          vmaxps (%rcx), %xmm20, %xmm24

// CHECK: vmaxps 291(%rax,%r14,8), %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x21,0x5c,0x00,0x5f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmaxps 291(%rax,%r14,8), %xmm20, %xmm24

// CHECK: vmaxps (%rcx){1to4}, %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x10,0x5f,0x01]
          vmaxps (%rcx){1to4}, %xmm20, %xmm24

// CHECK: vmaxps 2032(%rdx), %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x00,0x5f,0x42,0x7f]
          vmaxps 2032(%rdx), %xmm20, %xmm24

// CHECK: vmaxps 2048(%rdx), %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x00,0x5f,0x82,0x00,0x08,0x00,0x00]
          vmaxps 2048(%rdx), %xmm20, %xmm24

// CHECK: vmaxps -2048(%rdx), %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x00,0x5f,0x42,0x80]
          vmaxps -2048(%rdx), %xmm20, %xmm24

// CHECK: vmaxps -2064(%rdx), %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x00,0x5f,0x82,0xf0,0xf7,0xff,0xff]
          vmaxps -2064(%rdx), %xmm20, %xmm24

// CHECK: vmaxps 508(%rdx){1to4}, %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x10,0x5f,0x42,0x7f]
          vmaxps 508(%rdx){1to4}, %xmm20, %xmm24

// CHECK: vmaxps 512(%rdx){1to4}, %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x10,0x5f,0x82,0x00,0x02,0x00,0x00]
          vmaxps 512(%rdx){1to4}, %xmm20, %xmm24

// CHECK: vmaxps -512(%rdx){1to4}, %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x10,0x5f,0x42,0x80]
          vmaxps -512(%rdx){1to4}, %xmm20, %xmm24

// CHECK: vmaxps -516(%rdx){1to4}, %xmm20, %xmm24
// CHECK:  encoding: [0x62,0x61,0x5c,0x10,0x5f,0x82,0xfc,0xfd,0xff,0xff]
          vmaxps -516(%rdx){1to4}, %xmm20, %xmm24

// CHECK: vmaxps %ymm17, %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xa1,0x74,0x20,0x5f,0xd9]
          vmaxps %ymm17, %ymm17, %ymm19

// CHECK: vmaxps %ymm17, %ymm17, %ymm19 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x74,0x23,0x5f,0xd9]
          vmaxps %ymm17, %ymm17, %ymm19 {%k3}

// CHECK: vmaxps %ymm17, %ymm17, %ymm19 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x74,0xa3,0x5f,0xd9]
          vmaxps %ymm17, %ymm17, %ymm19 {%k3} {z}

// CHECK: vmaxps (%rcx), %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x20,0x5f,0x19]
          vmaxps (%rcx), %ymm17, %ymm19

// CHECK: vmaxps 291(%rax,%r14,8), %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xa1,0x74,0x20,0x5f,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmaxps 291(%rax,%r14,8), %ymm17, %ymm19

// CHECK: vmaxps (%rcx){1to8}, %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x30,0x5f,0x19]
          vmaxps (%rcx){1to8}, %ymm17, %ymm19

// CHECK: vmaxps 4064(%rdx), %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x20,0x5f,0x5a,0x7f]
          vmaxps 4064(%rdx), %ymm17, %ymm19

// CHECK: vmaxps 4096(%rdx), %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x20,0x5f,0x9a,0x00,0x10,0x00,0x00]
          vmaxps 4096(%rdx), %ymm17, %ymm19

// CHECK: vmaxps -4096(%rdx), %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x20,0x5f,0x5a,0x80]
          vmaxps -4096(%rdx), %ymm17, %ymm19

// CHECK: vmaxps -4128(%rdx), %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x20,0x5f,0x9a,0xe0,0xef,0xff,0xff]
          vmaxps -4128(%rdx), %ymm17, %ymm19

// CHECK: vmaxps 508(%rdx){1to8}, %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x30,0x5f,0x5a,0x7f]
          vmaxps 508(%rdx){1to8}, %ymm17, %ymm19

// CHECK: vmaxps 512(%rdx){1to8}, %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x30,0x5f,0x9a,0x00,0x02,0x00,0x00]
          vmaxps 512(%rdx){1to8}, %ymm17, %ymm19

// CHECK: vmaxps -512(%rdx){1to8}, %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x30,0x5f,0x5a,0x80]
          vmaxps -512(%rdx){1to8}, %ymm17, %ymm19

// CHECK: vmaxps -516(%rdx){1to8}, %ymm17, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x74,0x30,0x5f,0x9a,0xfc,0xfd,0xff,0xff]
          vmaxps -516(%rdx){1to8}, %ymm17, %ymm19

// CHECK: vminpd %xmm19, %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x21,0xe5,0x00,0x5d,0xdb]
          vminpd %xmm19, %xmm19, %xmm27

// CHECK: vminpd %xmm19, %xmm19, %xmm27 {%k6}
// CHECK:  encoding: [0x62,0x21,0xe5,0x06,0x5d,0xdb]
          vminpd %xmm19, %xmm19, %xmm27 {%k6}

// CHECK: vminpd %xmm19, %xmm19, %xmm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0xe5,0x86,0x5d,0xdb]
          vminpd %xmm19, %xmm19, %xmm27 {%k6} {z}

// CHECK: vminpd (%rcx), %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x00,0x5d,0x19]
          vminpd (%rcx), %xmm19, %xmm27

// CHECK: vminpd 291(%rax,%r14,8), %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x21,0xe5,0x00,0x5d,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vminpd 291(%rax,%r14,8), %xmm19, %xmm27

// CHECK: vminpd (%rcx){1to2}, %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x10,0x5d,0x19]
          vminpd (%rcx){1to2}, %xmm19, %xmm27

// CHECK: vminpd 2032(%rdx), %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x00,0x5d,0x5a,0x7f]
          vminpd 2032(%rdx), %xmm19, %xmm27

// CHECK: vminpd 2048(%rdx), %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x00,0x5d,0x9a,0x00,0x08,0x00,0x00]
          vminpd 2048(%rdx), %xmm19, %xmm27

// CHECK: vminpd -2048(%rdx), %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x00,0x5d,0x5a,0x80]
          vminpd -2048(%rdx), %xmm19, %xmm27

// CHECK: vminpd -2064(%rdx), %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x00,0x5d,0x9a,0xf0,0xf7,0xff,0xff]
          vminpd -2064(%rdx), %xmm19, %xmm27

// CHECK: vminpd 1016(%rdx){1to2}, %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x10,0x5d,0x5a,0x7f]
          vminpd 1016(%rdx){1to2}, %xmm19, %xmm27

// CHECK: vminpd 1024(%rdx){1to2}, %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x10,0x5d,0x9a,0x00,0x04,0x00,0x00]
          vminpd 1024(%rdx){1to2}, %xmm19, %xmm27

// CHECK: vminpd -1024(%rdx){1to2}, %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x10,0x5d,0x5a,0x80]
          vminpd -1024(%rdx){1to2}, %xmm19, %xmm27

// CHECK: vminpd -1032(%rdx){1to2}, %xmm19, %xmm27
// CHECK:  encoding: [0x62,0x61,0xe5,0x10,0x5d,0x9a,0xf8,0xfb,0xff,0xff]
          vminpd -1032(%rdx){1to2}, %xmm19, %xmm27

// CHECK: vminpd %ymm23, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x5d,0xc7]
          vminpd %ymm23, %ymm29, %ymm24

// CHECK: vminpd %ymm23, %ymm29, %ymm24 {%k6}
// CHECK:  encoding: [0x62,0x21,0x95,0x26,0x5d,0xc7]
          vminpd %ymm23, %ymm29, %ymm24 {%k6}

// CHECK: vminpd %ymm23, %ymm29, %ymm24 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0x95,0xa6,0x5d,0xc7]
          vminpd %ymm23, %ymm29, %ymm24 {%k6} {z}

// CHECK: vminpd (%rcx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x5d,0x01]
          vminpd (%rcx), %ymm29, %ymm24

// CHECK: vminpd 291(%rax,%r14,8), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x21,0x95,0x20,0x5d,0x84,0xf0,0x23,0x01,0x00,0x00]
          vminpd 291(%rax,%r14,8), %ymm29, %ymm24

// CHECK: vminpd (%rcx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x5d,0x01]
          vminpd (%rcx){1to4}, %ymm29, %ymm24

// CHECK: vminpd 4064(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x5d,0x42,0x7f]
          vminpd 4064(%rdx), %ymm29, %ymm24

// CHECK: vminpd 4096(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x5d,0x82,0x00,0x10,0x00,0x00]
          vminpd 4096(%rdx), %ymm29, %ymm24

// CHECK: vminpd -4096(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x5d,0x42,0x80]
          vminpd -4096(%rdx), %ymm29, %ymm24

// CHECK: vminpd -4128(%rdx), %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x20,0x5d,0x82,0xe0,0xef,0xff,0xff]
          vminpd -4128(%rdx), %ymm29, %ymm24

// CHECK: vminpd 1016(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x5d,0x42,0x7f]
          vminpd 1016(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vminpd 1024(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x5d,0x82,0x00,0x04,0x00,0x00]
          vminpd 1024(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vminpd -1024(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x5d,0x42,0x80]
          vminpd -1024(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vminpd -1032(%rdx){1to4}, %ymm29, %ymm24
// CHECK:  encoding: [0x62,0x61,0x95,0x30,0x5d,0x82,0xf8,0xfb,0xff,0xff]
          vminpd -1032(%rdx){1to4}, %ymm29, %ymm24

// CHECK: vminps %xmm23, %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x5c,0x00,0x5d,0xcf]
          vminps %xmm23, %xmm20, %xmm17

// CHECK: vminps %xmm23, %xmm20, %xmm17 {%k1}
// CHECK:  encoding: [0x62,0xa1,0x5c,0x01,0x5d,0xcf]
          vminps %xmm23, %xmm20, %xmm17 {%k1}

// CHECK: vminps %xmm23, %xmm20, %xmm17 {%k1} {z}
// CHECK:  encoding: [0x62,0xa1,0x5c,0x81,0x5d,0xcf]
          vminps %xmm23, %xmm20, %xmm17 {%k1} {z}

// CHECK: vminps (%rcx), %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x00,0x5d,0x09]
          vminps (%rcx), %xmm20, %xmm17

// CHECK: vminps 291(%rax,%r14,8), %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xa1,0x5c,0x00,0x5d,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vminps 291(%rax,%r14,8), %xmm20, %xmm17

// CHECK: vminps (%rcx){1to4}, %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x10,0x5d,0x09]
          vminps (%rcx){1to4}, %xmm20, %xmm17

// CHECK: vminps 2032(%rdx), %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x00,0x5d,0x4a,0x7f]
          vminps 2032(%rdx), %xmm20, %xmm17

// CHECK: vminps 2048(%rdx), %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x00,0x5d,0x8a,0x00,0x08,0x00,0x00]
          vminps 2048(%rdx), %xmm20, %xmm17

// CHECK: vminps -2048(%rdx), %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x00,0x5d,0x4a,0x80]
          vminps -2048(%rdx), %xmm20, %xmm17

// CHECK: vminps -2064(%rdx), %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x00,0x5d,0x8a,0xf0,0xf7,0xff,0xff]
          vminps -2064(%rdx), %xmm20, %xmm17

// CHECK: vminps 508(%rdx){1to4}, %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x10,0x5d,0x4a,0x7f]
          vminps 508(%rdx){1to4}, %xmm20, %xmm17

// CHECK: vminps 512(%rdx){1to4}, %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x10,0x5d,0x8a,0x00,0x02,0x00,0x00]
          vminps 512(%rdx){1to4}, %xmm20, %xmm17

// CHECK: vminps -512(%rdx){1to4}, %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x10,0x5d,0x4a,0x80]
          vminps -512(%rdx){1to4}, %xmm20, %xmm17

// CHECK: vminps -516(%rdx){1to4}, %xmm20, %xmm17
// CHECK:  encoding: [0x62,0xe1,0x5c,0x10,0x5d,0x8a,0xfc,0xfd,0xff,0xff]
          vminps -516(%rdx){1to4}, %xmm20, %xmm17

// CHECK: vminps %ymm21, %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x21,0x3c,0x20,0x5d,0xc5]
          vminps %ymm21, %ymm24, %ymm24

// CHECK: vminps %ymm21, %ymm24, %ymm24 {%k3}
// CHECK:  encoding: [0x62,0x21,0x3c,0x23,0x5d,0xc5]
          vminps %ymm21, %ymm24, %ymm24 {%k3}

// CHECK: vminps %ymm21, %ymm24, %ymm24 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0x3c,0xa3,0x5d,0xc5]
          vminps %ymm21, %ymm24, %ymm24 {%k3} {z}

// CHECK: vminps (%rcx), %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x20,0x5d,0x01]
          vminps (%rcx), %ymm24, %ymm24

// CHECK: vminps 291(%rax,%r14,8), %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x21,0x3c,0x20,0x5d,0x84,0xf0,0x23,0x01,0x00,0x00]
          vminps 291(%rax,%r14,8), %ymm24, %ymm24

// CHECK: vminps (%rcx){1to8}, %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x30,0x5d,0x01]
          vminps (%rcx){1to8}, %ymm24, %ymm24

// CHECK: vminps 4064(%rdx), %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x20,0x5d,0x42,0x7f]
          vminps 4064(%rdx), %ymm24, %ymm24

// CHECK: vminps 4096(%rdx), %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x20,0x5d,0x82,0x00,0x10,0x00,0x00]
          vminps 4096(%rdx), %ymm24, %ymm24

// CHECK: vminps -4096(%rdx), %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x20,0x5d,0x42,0x80]
          vminps -4096(%rdx), %ymm24, %ymm24

// CHECK: vminps -4128(%rdx), %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x20,0x5d,0x82,0xe0,0xef,0xff,0xff]
          vminps -4128(%rdx), %ymm24, %ymm24

// CHECK: vminps 508(%rdx){1to8}, %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x30,0x5d,0x42,0x7f]
          vminps 508(%rdx){1to8}, %ymm24, %ymm24

// CHECK: vminps 512(%rdx){1to8}, %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x30,0x5d,0x82,0x00,0x02,0x00,0x00]
          vminps 512(%rdx){1to8}, %ymm24, %ymm24

// CHECK: vminps -512(%rdx){1to8}, %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x30,0x5d,0x42,0x80]
          vminps -512(%rdx){1to8}, %ymm24, %ymm24

// CHECK: vminps -516(%rdx){1to8}, %ymm24, %ymm24
// CHECK:  encoding: [0x62,0x61,0x3c,0x30,0x5d,0x82,0xfc,0xfd,0xff,0xff]
          vminps -516(%rdx){1to8}, %ymm24, %ymm24

// CHECK: vmovapd %xmm21, %xmm21
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x28,0xed]
          vmovapd %xmm21, %xmm21

// CHECK: vmovapd %xmm21, %xmm21 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x0b,0x28,0xed]
          vmovapd %xmm21, %xmm21 {%k3}

// CHECK: vmovapd %xmm21, %xmm21 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x8b,0x28,0xed]
          vmovapd %xmm21, %xmm21 {%k3} {z}

// CHECK: vmovapd (%rcx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x28,0x29]
          vmovapd (%rcx), %xmm21

// CHECK: vmovapd 291(%rax,%r14,8), %xmm21
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x28,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovapd 291(%rax,%r14,8), %xmm21

// CHECK: vmovapd 2032(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x28,0x6a,0x7f]
          vmovapd 2032(%rdx), %xmm21

// CHECK: vmovapd 2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x28,0xaa,0x00,0x08,0x00,0x00]
          vmovapd 2048(%rdx), %xmm21

// CHECK: vmovapd -2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x28,0x6a,0x80]
          vmovapd -2048(%rdx), %xmm21

// CHECK: vmovapd -2064(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x28,0xaa,0xf0,0xf7,0xff,0xff]
          vmovapd -2064(%rdx), %xmm21

// CHECK: vmovapd %ymm17, %ymm18
// CHECK:  encoding: [0x62,0xa1,0xfd,0x28,0x28,0xd1]
          vmovapd %ymm17, %ymm18

// CHECK: vmovapd %ymm17, %ymm18 {%k2}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x2a,0x28,0xd1]
          vmovapd %ymm17, %ymm18 {%k2}

// CHECK: vmovapd %ymm17, %ymm18 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0xfd,0xaa,0x28,0xd1]
          vmovapd %ymm17, %ymm18 {%k2} {z}

// CHECK: vmovapd (%rcx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x28,0x11]
          vmovapd (%rcx), %ymm18

// CHECK: vmovapd 291(%rax,%r14,8), %ymm18
// CHECK:  encoding: [0x62,0xa1,0xfd,0x28,0x28,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovapd 291(%rax,%r14,8), %ymm18

// CHECK: vmovapd 4064(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x28,0x52,0x7f]
          vmovapd 4064(%rdx), %ymm18

// CHECK: vmovapd 4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x28,0x92,0x00,0x10,0x00,0x00]
          vmovapd 4096(%rdx), %ymm18

// CHECK: vmovapd -4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x28,0x52,0x80]
          vmovapd -4096(%rdx), %ymm18

// CHECK: vmovapd -4128(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x28,0x92,0xe0,0xef,0xff,0xff]
          vmovapd -4128(%rdx), %ymm18

// CHECK: vmovaps %xmm29, %xmm22
// CHECK:  encoding: [0x62,0x81,0x7c,0x08,0x28,0xf5]
          vmovaps %xmm29, %xmm22

// CHECK: vmovaps %xmm29, %xmm22 {%k1}
// CHECK:  encoding: [0x62,0x81,0x7c,0x09,0x28,0xf5]
          vmovaps %xmm29, %xmm22 {%k1}

// CHECK: vmovaps %xmm29, %xmm22 {%k1} {z}
// CHECK:  encoding: [0x62,0x81,0x7c,0x89,0x28,0xf5]
          vmovaps %xmm29, %xmm22 {%k1} {z}

// CHECK: vmovaps (%rcx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x28,0x31]
          vmovaps (%rcx), %xmm22

// CHECK: vmovaps 291(%rax,%r14,8), %xmm22
// CHECK:  encoding: [0x62,0xa1,0x7c,0x08,0x28,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovaps 291(%rax,%r14,8), %xmm22

// CHECK: vmovaps 2032(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x28,0x72,0x7f]
          vmovaps 2032(%rdx), %xmm22

// CHECK: vmovaps 2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x28,0xb2,0x00,0x08,0x00,0x00]
          vmovaps 2048(%rdx), %xmm22

// CHECK: vmovaps -2048(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x28,0x72,0x80]
          vmovaps -2048(%rdx), %xmm22

// CHECK: vmovaps -2064(%rdx), %xmm22
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x28,0xb2,0xf0,0xf7,0xff,0xff]
          vmovaps -2064(%rdx), %xmm22

// CHECK: vmovaps %ymm28, %ymm25
// CHECK:  encoding: [0x62,0x01,0x7c,0x28,0x28,0xcc]
          vmovaps %ymm28, %ymm25

// CHECK: vmovaps %ymm28, %ymm25 {%k3}
// CHECK:  encoding: [0x62,0x01,0x7c,0x2b,0x28,0xcc]
          vmovaps %ymm28, %ymm25 {%k3}

// CHECK: vmovaps %ymm28, %ymm25 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0x7c,0xab,0x28,0xcc]
          vmovaps %ymm28, %ymm25 {%k3} {z}

// CHECK: vmovaps (%rcx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x28,0x09]
          vmovaps (%rcx), %ymm25

// CHECK: vmovaps 291(%rax,%r14,8), %ymm25
// CHECK:  encoding: [0x62,0x21,0x7c,0x28,0x28,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovaps 291(%rax,%r14,8), %ymm25

// CHECK: vmovaps 4064(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x28,0x4a,0x7f]
          vmovaps 4064(%rdx), %ymm25

// CHECK: vmovaps 4096(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x28,0x8a,0x00,0x10,0x00,0x00]
          vmovaps 4096(%rdx), %ymm25

// CHECK: vmovaps -4096(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x28,0x4a,0x80]
          vmovaps -4096(%rdx), %ymm25

// CHECK: vmovaps -4128(%rdx), %ymm25
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x28,0x8a,0xe0,0xef,0xff,0xff]
          vmovaps -4128(%rdx), %ymm25

// CHECK: vmovdqa32 %xmm24, %xmm21
// CHECK:  encoding: [0x62,0x81,0x7d,0x08,0x6f,0xe8]
          vmovdqa32 %xmm24, %xmm21

// CHECK: vmovdqa32 %xmm24, %xmm21 {%k6}
// CHECK:  encoding: [0x62,0x81,0x7d,0x0e,0x6f,0xe8]
          vmovdqa32 %xmm24, %xmm21 {%k6}

// CHECK: vmovdqa32 %xmm24, %xmm21 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0x7d,0x8e,0x6f,0xe8]
          vmovdqa32 %xmm24, %xmm21 {%k6} {z}

// CHECK: vmovdqa32 (%rcx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x6f,0x29]
          vmovdqa32 (%rcx), %xmm21

// CHECK: vmovdqa32 291(%rax,%r14,8), %xmm21
// CHECK:  encoding: [0x62,0xa1,0x7d,0x08,0x6f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 291(%rax,%r14,8), %xmm21

// CHECK: vmovdqa32 2032(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x6f,0x6a,0x7f]
          vmovdqa32 2032(%rdx), %xmm21

// CHECK: vmovdqa32 2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x6f,0xaa,0x00,0x08,0x00,0x00]
          vmovdqa32 2048(%rdx), %xmm21

// CHECK: vmovdqa32 -2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x6f,0x6a,0x80]
          vmovdqa32 -2048(%rdx), %xmm21

// CHECK: vmovdqa32 -2064(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0x6f,0xaa,0xf0,0xf7,0xff,0xff]
          vmovdqa32 -2064(%rdx), %xmm21

// CHECK: vmovdqa32 %ymm28, %ymm24
// CHECK:  encoding: [0x62,0x01,0x7d,0x28,0x6f,0xc4]
          vmovdqa32 %ymm28, %ymm24

// CHECK: vmovdqa32 %ymm28, %ymm24 {%k5}
// CHECK:  encoding: [0x62,0x01,0x7d,0x2d,0x6f,0xc4]
          vmovdqa32 %ymm28, %ymm24 {%k5}

// CHECK: vmovdqa32 %ymm28, %ymm24 {%k5} {z}
// CHECK:  encoding: [0x62,0x01,0x7d,0xad,0x6f,0xc4]
          vmovdqa32 %ymm28, %ymm24 {%k5} {z}

// CHECK: vmovdqa32 (%rcx), %ymm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x6f,0x01]
          vmovdqa32 (%rcx), %ymm24

// CHECK: vmovdqa32 291(%rax,%r14,8), %ymm24
// CHECK:  encoding: [0x62,0x21,0x7d,0x28,0x6f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 291(%rax,%r14,8), %ymm24

// CHECK: vmovdqa32 4064(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x6f,0x42,0x7f]
          vmovdqa32 4064(%rdx), %ymm24

// CHECK: vmovdqa32 4096(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x6f,0x82,0x00,0x10,0x00,0x00]
          vmovdqa32 4096(%rdx), %ymm24

// CHECK: vmovdqa32 -4096(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x6f,0x42,0x80]
          vmovdqa32 -4096(%rdx), %ymm24

// CHECK: vmovdqa32 -4128(%rdx), %ymm24
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x6f,0x82,0xe0,0xef,0xff,0xff]
          vmovdqa32 -4128(%rdx), %ymm24

// CHECK: vmovdqa64 %xmm24, %xmm27
// CHECK:  encoding: [0x62,0x01,0xfd,0x08,0x6f,0xd8]
          vmovdqa64 %xmm24, %xmm27

// CHECK: vmovdqa64 %xmm24, %xmm27 {%k5}
// CHECK:  encoding: [0x62,0x01,0xfd,0x0d,0x6f,0xd8]
          vmovdqa64 %xmm24, %xmm27 {%k5}

// CHECK: vmovdqa64 %xmm24, %xmm27 {%k5} {z}
// CHECK:  encoding: [0x62,0x01,0xfd,0x8d,0x6f,0xd8]
          vmovdqa64 %xmm24, %xmm27 {%k5} {z}

// CHECK: vmovdqa64 (%rcx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x6f,0x19]
          vmovdqa64 (%rcx), %xmm27

// CHECK: vmovdqa64 291(%rax,%r14,8), %xmm27
// CHECK:  encoding: [0x62,0x21,0xfd,0x08,0x6f,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 291(%rax,%r14,8), %xmm27

// CHECK: vmovdqa64 2032(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x6f,0x5a,0x7f]
          vmovdqa64 2032(%rdx), %xmm27

// CHECK: vmovdqa64 2048(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x6f,0x9a,0x00,0x08,0x00,0x00]
          vmovdqa64 2048(%rdx), %xmm27

// CHECK: vmovdqa64 -2048(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x6f,0x5a,0x80]
          vmovdqa64 -2048(%rdx), %xmm27

// CHECK: vmovdqa64 -2064(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x6f,0x9a,0xf0,0xf7,0xff,0xff]
          vmovdqa64 -2064(%rdx), %xmm27

// CHECK: vmovdqa64 %ymm29, %ymm30
// CHECK:  encoding: [0x62,0x01,0xfd,0x28,0x6f,0xf5]
          vmovdqa64 %ymm29, %ymm30

// CHECK: vmovdqa64 %ymm29, %ymm30 {%k3}
// CHECK:  encoding: [0x62,0x01,0xfd,0x2b,0x6f,0xf5]
          vmovdqa64 %ymm29, %ymm30 {%k3}

// CHECK: vmovdqa64 %ymm29, %ymm30 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0xfd,0xab,0x6f,0xf5]
          vmovdqa64 %ymm29, %ymm30 {%k3} {z}

// CHECK: vmovdqa64 (%rcx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x6f,0x31]
          vmovdqa64 (%rcx), %ymm30

// CHECK: vmovdqa64 291(%rax,%r14,8), %ymm30
// CHECK:  encoding: [0x62,0x21,0xfd,0x28,0x6f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 291(%rax,%r14,8), %ymm30

// CHECK: vmovdqa64 4064(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x6f,0x72,0x7f]
          vmovdqa64 4064(%rdx), %ymm30

// CHECK: vmovdqa64 4096(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x6f,0xb2,0x00,0x10,0x00,0x00]
          vmovdqa64 4096(%rdx), %ymm30

// CHECK: vmovdqa64 -4096(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x6f,0x72,0x80]
          vmovdqa64 -4096(%rdx), %ymm30

// CHECK: vmovdqa64 -4128(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x6f,0xb2,0xe0,0xef,0xff,0xff]
          vmovdqa64 -4128(%rdx), %ymm30

// CHECK: vmovdqu32 %xmm19, %xmm29
// CHECK:  encoding: [0x62,0x21,0x7e,0x08,0x6f,0xeb]
          vmovdqu32 %xmm19, %xmm29

// CHECK: vmovdqu32 %xmm19, %xmm29 {%k6}
// CHECK:  encoding: [0x62,0x21,0x7e,0x0e,0x6f,0xeb]
          vmovdqu32 %xmm19, %xmm29 {%k6}

// CHECK: vmovdqu32 %xmm19, %xmm29 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0x7e,0x8e,0x6f,0xeb]
          vmovdqu32 %xmm19, %xmm29 {%k6} {z}

// CHECK: vmovdqu32 (%rcx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7e,0x08,0x6f,0x29]
          vmovdqu32 (%rcx), %xmm29

// CHECK: vmovdqu32 291(%rax,%r14,8), %xmm29
// CHECK:  encoding: [0x62,0x21,0x7e,0x08,0x6f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 291(%rax,%r14,8), %xmm29

// CHECK: vmovdqu32 2032(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7e,0x08,0x6f,0x6a,0x7f]
          vmovdqu32 2032(%rdx), %xmm29

// CHECK: vmovdqu32 2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7e,0x08,0x6f,0xaa,0x00,0x08,0x00,0x00]
          vmovdqu32 2048(%rdx), %xmm29

// CHECK: vmovdqu32 -2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7e,0x08,0x6f,0x6a,0x80]
          vmovdqu32 -2048(%rdx), %xmm29

// CHECK: vmovdqu32 -2064(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0x7e,0x08,0x6f,0xaa,0xf0,0xf7,0xff,0xff]
          vmovdqu32 -2064(%rdx), %xmm29

// CHECK: vmovdqu32 %ymm18, %ymm17
// CHECK:  encoding: [0x62,0xa1,0x7e,0x28,0x6f,0xca]
          vmovdqu32 %ymm18, %ymm17

// CHECK: vmovdqu32 %ymm18, %ymm17 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x7e,0x2b,0x6f,0xca]
          vmovdqu32 %ymm18, %ymm17 {%k3}

// CHECK: vmovdqu32 %ymm18, %ymm17 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x7e,0xab,0x6f,0xca]
          vmovdqu32 %ymm18, %ymm17 {%k3} {z}

// CHECK: vmovdqu32 (%rcx), %ymm17
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x6f,0x09]
          vmovdqu32 (%rcx), %ymm17

// CHECK: vmovdqu32 291(%rax,%r14,8), %ymm17
// CHECK:  encoding: [0x62,0xa1,0x7e,0x28,0x6f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 291(%rax,%r14,8), %ymm17

// CHECK: vmovdqu32 4064(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x6f,0x4a,0x7f]
          vmovdqu32 4064(%rdx), %ymm17

// CHECK: vmovdqu32 4096(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x6f,0x8a,0x00,0x10,0x00,0x00]
          vmovdqu32 4096(%rdx), %ymm17

// CHECK: vmovdqu32 -4096(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x6f,0x4a,0x80]
          vmovdqu32 -4096(%rdx), %ymm17

// CHECK: vmovdqu32 -4128(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x6f,0x8a,0xe0,0xef,0xff,0xff]
          vmovdqu32 -4128(%rdx), %ymm17

// CHECK: vmovdqu64 %xmm19, %xmm24
// CHECK:  encoding: [0x62,0x21,0xfe,0x08,0x6f,0xc3]
          vmovdqu64 %xmm19, %xmm24

// CHECK: vmovdqu64 %xmm19, %xmm24 {%k5}
// CHECK:  encoding: [0x62,0x21,0xfe,0x0d,0x6f,0xc3]
          vmovdqu64 %xmm19, %xmm24 {%k5}

// CHECK: vmovdqu64 %xmm19, %xmm24 {%k5} {z}
// CHECK:  encoding: [0x62,0x21,0xfe,0x8d,0x6f,0xc3]
          vmovdqu64 %xmm19, %xmm24 {%k5} {z}

// CHECK: vmovdqu64 (%rcx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x08,0x6f,0x01]
          vmovdqu64 (%rcx), %xmm24

// CHECK: vmovdqu64 291(%rax,%r14,8), %xmm24
// CHECK:  encoding: [0x62,0x21,0xfe,0x08,0x6f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 291(%rax,%r14,8), %xmm24

// CHECK: vmovdqu64 2032(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x08,0x6f,0x42,0x7f]
          vmovdqu64 2032(%rdx), %xmm24

// CHECK: vmovdqu64 2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x08,0x6f,0x82,0x00,0x08,0x00,0x00]
          vmovdqu64 2048(%rdx), %xmm24

// CHECK: vmovdqu64 -2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x08,0x6f,0x42,0x80]
          vmovdqu64 -2048(%rdx), %xmm24

// CHECK: vmovdqu64 -2064(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfe,0x08,0x6f,0x82,0xf0,0xf7,0xff,0xff]
          vmovdqu64 -2064(%rdx), %xmm24

// CHECK: vmovdqu64 %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x21,0xfe,0x28,0x6f,0xed]
          vmovdqu64 %ymm21, %ymm29

// CHECK: vmovdqu64 %ymm21, %ymm29 {%k3}
// CHECK:  encoding: [0x62,0x21,0xfe,0x2b,0x6f,0xed]
          vmovdqu64 %ymm21, %ymm29 {%k3}

// CHECK: vmovdqu64 %ymm21, %ymm29 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0xfe,0xab,0x6f,0xed]
          vmovdqu64 %ymm21, %ymm29 {%k3} {z}

// CHECK: vmovdqu64 (%rcx), %ymm29
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x6f,0x29]
          vmovdqu64 (%rcx), %ymm29

// CHECK: vmovdqu64 291(%rax,%r14,8), %ymm29
// CHECK:  encoding: [0x62,0x21,0xfe,0x28,0x6f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 291(%rax,%r14,8), %ymm29

// CHECK: vmovdqu64 4064(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x6f,0x6a,0x7f]
          vmovdqu64 4064(%rdx), %ymm29

// CHECK: vmovdqu64 4096(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x6f,0xaa,0x00,0x10,0x00,0x00]
          vmovdqu64 4096(%rdx), %ymm29

// CHECK: vmovdqu64 -4096(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x6f,0x6a,0x80]
          vmovdqu64 -4096(%rdx), %ymm29

// CHECK: vmovdqu64 -4128(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x61,0xfe,0x28,0x6f,0xaa,0xe0,0xef,0xff,0xff]
          vmovdqu64 -4128(%rdx), %ymm29

// CHECK: vmovntdq %xmm22, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0xe7,0x31]
          vmovntdq %xmm22, (%rcx)

// CHECK: vmovntdq %xmm22, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7d,0x08,0xe7,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovntdq %xmm22, 291(%rax,%r14,8)

// CHECK: vmovntdq %xmm22, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0xe7,0x72,0x7f]
          vmovntdq %xmm22, 2032(%rdx)

// CHECK: vmovntdq %xmm22, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0xe7,0xb2,0x00,0x08,0x00,0x00]
          vmovntdq %xmm22, 2048(%rdx)

// CHECK: vmovntdq %xmm22, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0xe7,0x72,0x80]
          vmovntdq %xmm22, -2048(%rdx)

// CHECK: vmovntdq %xmm22, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x08,0xe7,0xb2,0xf0,0xf7,0xff,0xff]
          vmovntdq %xmm22, -2064(%rdx)

// CHECK: vmovntdq %ymm19, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0xe7,0x19]
          vmovntdq %ymm19, (%rcx)

// CHECK: vmovntdq %ymm19, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7d,0x28,0xe7,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovntdq %ymm19, 291(%rax,%r14,8)

// CHECK: vmovntdq %ymm19, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0xe7,0x5a,0x7f]
          vmovntdq %ymm19, 4064(%rdx)

// CHECK: vmovntdq %ymm19, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0xe7,0x9a,0x00,0x10,0x00,0x00]
          vmovntdq %ymm19, 4096(%rdx)

// CHECK: vmovntdq %ymm19, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0xe7,0x5a,0x80]
          vmovntdq %ymm19, -4096(%rdx)

// CHECK: vmovntdq %ymm19, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7d,0x28,0xe7,0x9a,0xe0,0xef,0xff,0xff]
          vmovntdq %ymm19, -4128(%rdx)

// CHECK: vmovntdqa (%rcx), %xmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x2a,0x01]
          vmovntdqa (%rcx), %xmm24

// CHECK: vmovntdqa 291(%rax,%r14,8), %xmm24
// CHECK:  encoding: [0x62,0x22,0x7d,0x08,0x2a,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovntdqa 291(%rax,%r14,8), %xmm24

// CHECK: vmovntdqa 2032(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x2a,0x42,0x7f]
          vmovntdqa 2032(%rdx), %xmm24

// CHECK: vmovntdqa 2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x2a,0x82,0x00,0x08,0x00,0x00]
          vmovntdqa 2048(%rdx), %xmm24

// CHECK: vmovntdqa -2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x2a,0x42,0x80]
          vmovntdqa -2048(%rdx), %xmm24

// CHECK: vmovntdqa -2064(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x2a,0x82,0xf0,0xf7,0xff,0xff]
          vmovntdqa -2064(%rdx), %xmm24

// CHECK: vmovntdqa (%rcx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x2a,0x21]
          vmovntdqa (%rcx), %ymm28

// CHECK: vmovntdqa 291(%rax,%r14,8), %ymm28
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x2a,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovntdqa 291(%rax,%r14,8), %ymm28

// CHECK: vmovntdqa 4064(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x2a,0x62,0x7f]
          vmovntdqa 4064(%rdx), %ymm28

// CHECK: vmovntdqa 4096(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x2a,0xa2,0x00,0x10,0x00,0x00]
          vmovntdqa 4096(%rdx), %ymm28

// CHECK: vmovntdqa -4096(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x2a,0x62,0x80]
          vmovntdqa -4096(%rdx), %ymm28

// CHECK: vmovntdqa -4128(%rdx), %ymm28
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x2a,0xa2,0xe0,0xef,0xff,0xff]
          vmovntdqa -4128(%rdx), %ymm28

// CHECK: vmovntpd %xmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2b,0x09]
          vmovntpd %xmm17, (%rcx)

// CHECK: vmovntpd %xmm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x2b,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovntpd %xmm17, 291(%rax,%r14,8)

// CHECK: vmovntpd %xmm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2b,0x4a,0x7f]
          vmovntpd %xmm17, 2032(%rdx)

// CHECK: vmovntpd %xmm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2b,0x8a,0x00,0x08,0x00,0x00]
          vmovntpd %xmm17, 2048(%rdx)

// CHECK: vmovntpd %xmm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2b,0x4a,0x80]
          vmovntpd %xmm17, -2048(%rdx)

// CHECK: vmovntpd %xmm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x2b,0x8a,0xf0,0xf7,0xff,0xff]
          vmovntpd %xmm17, -2064(%rdx)

// CHECK: vmovntpd %ymm27, (%rcx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x2b,0x19]
          vmovntpd %ymm27, (%rcx)

// CHECK: vmovntpd %ymm27, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0xfd,0x28,0x2b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovntpd %ymm27, 291(%rax,%r14,8)

// CHECK: vmovntpd %ymm27, 4064(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x2b,0x5a,0x7f]
          vmovntpd %ymm27, 4064(%rdx)

// CHECK: vmovntpd %ymm27, 4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x2b,0x9a,0x00,0x10,0x00,0x00]
          vmovntpd %ymm27, 4096(%rdx)

// CHECK: vmovntpd %ymm27, -4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x2b,0x5a,0x80]
          vmovntpd %ymm27, -4096(%rdx)

// CHECK: vmovntpd %ymm27, -4128(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x2b,0x9a,0xe0,0xef,0xff,0xff]
          vmovntpd %ymm27, -4128(%rdx)

// CHECK: vmovntps %xmm26, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x2b,0x11]
          vmovntps %xmm26, (%rcx)

// CHECK: vmovntps %xmm26, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7c,0x08,0x2b,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovntps %xmm26, 291(%rax,%r14,8)

// CHECK: vmovntps %xmm26, 2032(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x2b,0x52,0x7f]
          vmovntps %xmm26, 2032(%rdx)

// CHECK: vmovntps %xmm26, 2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x2b,0x92,0x00,0x08,0x00,0x00]
          vmovntps %xmm26, 2048(%rdx)

// CHECK: vmovntps %xmm26, -2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x2b,0x52,0x80]
          vmovntps %xmm26, -2048(%rdx)

// CHECK: vmovntps %xmm26, -2064(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x2b,0x92,0xf0,0xf7,0xff,0xff]
          vmovntps %xmm26, -2064(%rdx)

// CHECK: vmovntps %ymm28, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x2b,0x21]
          vmovntps %ymm28, (%rcx)

// CHECK: vmovntps %ymm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7c,0x28,0x2b,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovntps %ymm28, 291(%rax,%r14,8)

// CHECK: vmovntps %ymm28, 4064(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x2b,0x62,0x7f]
          vmovntps %ymm28, 4064(%rdx)

// CHECK: vmovntps %ymm28, 4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x2b,0xa2,0x00,0x10,0x00,0x00]
          vmovntps %ymm28, 4096(%rdx)

// CHECK: vmovntps %ymm28, -4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x2b,0x62,0x80]
          vmovntps %ymm28, -4096(%rdx)

// CHECK: vmovntps %ymm28, -4128(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x2b,0xa2,0xe0,0xef,0xff,0xff]
          vmovntps %ymm28, -4128(%rdx)

// CHECK: vmovupd %xmm22, %xmm24
// CHECK:  encoding: [0x62,0x21,0xfd,0x08,0x10,0xc6]
          vmovupd %xmm22, %xmm24

// CHECK: vmovupd %xmm22, %xmm24 {%k6}
// CHECK:  encoding: [0x62,0x21,0xfd,0x0e,0x10,0xc6]
          vmovupd %xmm22, %xmm24 {%k6}

// CHECK: vmovupd %xmm22, %xmm24 {%k6} {z}
// CHECK:  encoding: [0x62,0x21,0xfd,0x8e,0x10,0xc6]
          vmovupd %xmm22, %xmm24 {%k6} {z}

// CHECK: vmovupd (%rcx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x10,0x01]
          vmovupd (%rcx), %xmm24

// CHECK: vmovupd 291(%rax,%r14,8), %xmm24
// CHECK:  encoding: [0x62,0x21,0xfd,0x08,0x10,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovupd 291(%rax,%r14,8), %xmm24

// CHECK: vmovupd 2032(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x10,0x42,0x7f]
          vmovupd 2032(%rdx), %xmm24

// CHECK: vmovupd 2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x10,0x82,0x00,0x08,0x00,0x00]
          vmovupd 2048(%rdx), %xmm24

// CHECK: vmovupd -2048(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x10,0x42,0x80]
          vmovupd -2048(%rdx), %xmm24

// CHECK: vmovupd -2064(%rdx), %xmm24
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x10,0x82,0xf0,0xf7,0xff,0xff]
          vmovupd -2064(%rdx), %xmm24

// CHECK: vmovupd %ymm25, %ymm30
// CHECK:  encoding: [0x62,0x01,0xfd,0x28,0x10,0xf1]
          vmovupd %ymm25, %ymm30

// CHECK: vmovupd %ymm25, %ymm30 {%k7}
// CHECK:  encoding: [0x62,0x01,0xfd,0x2f,0x10,0xf1]
          vmovupd %ymm25, %ymm30 {%k7}

// CHECK: vmovupd %ymm25, %ymm30 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0xfd,0xaf,0x10,0xf1]
          vmovupd %ymm25, %ymm30 {%k7} {z}

// CHECK: vmovupd (%rcx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x10,0x31]
          vmovupd (%rcx), %ymm30

// CHECK: vmovupd 291(%rax,%r14,8), %ymm30
// CHECK:  encoding: [0x62,0x21,0xfd,0x28,0x10,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovupd 291(%rax,%r14,8), %ymm30

// CHECK: vmovupd 4064(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x10,0x72,0x7f]
          vmovupd 4064(%rdx), %ymm30

// CHECK: vmovupd 4096(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x10,0xb2,0x00,0x10,0x00,0x00]
          vmovupd 4096(%rdx), %ymm30

// CHECK: vmovupd -4096(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x10,0x72,0x80]
          vmovupd -4096(%rdx), %ymm30

// CHECK: vmovupd -4128(%rdx), %ymm30
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x10,0xb2,0xe0,0xef,0xff,0xff]
          vmovupd -4128(%rdx), %ymm30

// CHECK: vmovups %xmm29, %xmm20
// CHECK:  encoding: [0x62,0x81,0x7c,0x08,0x10,0xe5]
          vmovups %xmm29, %xmm20

// CHECK: vmovups %xmm29, %xmm20 {%k6}
// CHECK:  encoding: [0x62,0x81,0x7c,0x0e,0x10,0xe5]
          vmovups %xmm29, %xmm20 {%k6}

// CHECK: vmovups %xmm29, %xmm20 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0x7c,0x8e,0x10,0xe5]
          vmovups %xmm29, %xmm20 {%k6} {z}

// CHECK: vmovups (%rcx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x10,0x21]
          vmovups (%rcx), %xmm20

// CHECK: vmovups 291(%rax,%r14,8), %xmm20
// CHECK:  encoding: [0x62,0xa1,0x7c,0x08,0x10,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovups 291(%rax,%r14,8), %xmm20

// CHECK: vmovups 2032(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x10,0x62,0x7f]
          vmovups 2032(%rdx), %xmm20

// CHECK: vmovups 2048(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x10,0xa2,0x00,0x08,0x00,0x00]
          vmovups 2048(%rdx), %xmm20

// CHECK: vmovups -2048(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x10,0x62,0x80]
          vmovups -2048(%rdx), %xmm20

// CHECK: vmovups -2064(%rdx), %xmm20
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x10,0xa2,0xf0,0xf7,0xff,0xff]
          vmovups -2064(%rdx), %xmm20

// CHECK: vmovups %ymm26, %ymm21
// CHECK:  encoding: [0x62,0x81,0x7c,0x28,0x10,0xea]
          vmovups %ymm26, %ymm21

// CHECK: vmovups %ymm26, %ymm21 {%k6}
// CHECK:  encoding: [0x62,0x81,0x7c,0x2e,0x10,0xea]
          vmovups %ymm26, %ymm21 {%k6}

// CHECK: vmovups %ymm26, %ymm21 {%k6} {z}
// CHECK:  encoding: [0x62,0x81,0x7c,0xae,0x10,0xea]
          vmovups %ymm26, %ymm21 {%k6} {z}

// CHECK: vmovups (%rcx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x10,0x29]
          vmovups (%rcx), %ymm21

// CHECK: vmovups 291(%rax,%r14,8), %ymm21
// CHECK:  encoding: [0x62,0xa1,0x7c,0x28,0x10,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovups 291(%rax,%r14,8), %ymm21

// CHECK: vmovups 4064(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x10,0x6a,0x7f]
          vmovups 4064(%rdx), %ymm21

// CHECK: vmovups 4096(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x10,0xaa,0x00,0x10,0x00,0x00]
          vmovups 4096(%rdx), %ymm21

// CHECK: vmovups -4096(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x10,0x6a,0x80]
          vmovups -4096(%rdx), %ymm21

// CHECK: vmovups -4128(%rdx), %ymm21
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x10,0xaa,0xe0,0xef,0xff,0xff]
          vmovups -4128(%rdx), %ymm21

// CHECK: vmulpd %xmm26, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0x81,0xf5,0x00,0x59,0xca]
          vmulpd %xmm26, %xmm17, %xmm17

// CHECK: vmulpd %xmm26, %xmm17, %xmm17 {%k7}
// CHECK:  encoding: [0x62,0x81,0xf5,0x07,0x59,0xca]
          vmulpd %xmm26, %xmm17, %xmm17 {%k7}

// CHECK: vmulpd %xmm26, %xmm17, %xmm17 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0xf5,0x87,0x59,0xca]
          vmulpd %xmm26, %xmm17, %xmm17 {%k7} {z}

// CHECK: vmulpd (%rcx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x00,0x59,0x09]
          vmulpd (%rcx), %xmm17, %xmm17

// CHECK: vmulpd 291(%rax,%r14,8), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xa1,0xf5,0x00,0x59,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmulpd 291(%rax,%r14,8), %xmm17, %xmm17

// CHECK: vmulpd (%rcx){1to2}, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x10,0x59,0x09]
          vmulpd (%rcx){1to2}, %xmm17, %xmm17

// CHECK: vmulpd 2032(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x00,0x59,0x4a,0x7f]
          vmulpd 2032(%rdx), %xmm17, %xmm17

// CHECK: vmulpd 2048(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x00,0x59,0x8a,0x00,0x08,0x00,0x00]
          vmulpd 2048(%rdx), %xmm17, %xmm17

// CHECK: vmulpd -2048(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x00,0x59,0x4a,0x80]
          vmulpd -2048(%rdx), %xmm17, %xmm17

// CHECK: vmulpd -2064(%rdx), %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x00,0x59,0x8a,0xf0,0xf7,0xff,0xff]
          vmulpd -2064(%rdx), %xmm17, %xmm17

// CHECK: vmulpd 1016(%rdx){1to2}, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x10,0x59,0x4a,0x7f]
          vmulpd 1016(%rdx){1to2}, %xmm17, %xmm17

// CHECK: vmulpd 1024(%rdx){1to2}, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x10,0x59,0x8a,0x00,0x04,0x00,0x00]
          vmulpd 1024(%rdx){1to2}, %xmm17, %xmm17

// CHECK: vmulpd -1024(%rdx){1to2}, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x10,0x59,0x4a,0x80]
          vmulpd -1024(%rdx){1to2}, %xmm17, %xmm17

// CHECK: vmulpd -1032(%rdx){1to2}, %xmm17, %xmm17
// CHECK:  encoding: [0x62,0xe1,0xf5,0x10,0x59,0x8a,0xf8,0xfb,0xff,0xff]
          vmulpd -1032(%rdx){1to2}, %xmm17, %xmm17

// CHECK: vmulpd %ymm27, %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x01,0xa5,0x20,0x59,0xcb]
          vmulpd %ymm27, %ymm27, %ymm25

// CHECK: vmulpd %ymm27, %ymm27, %ymm25 {%k3}
// CHECK:  encoding: [0x62,0x01,0xa5,0x23,0x59,0xcb]
          vmulpd %ymm27, %ymm27, %ymm25 {%k3}

// CHECK: vmulpd %ymm27, %ymm27, %ymm25 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0xa5,0xa3,0x59,0xcb]
          vmulpd %ymm27, %ymm27, %ymm25 {%k3} {z}

// CHECK: vmulpd (%rcx), %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x20,0x59,0x09]
          vmulpd (%rcx), %ymm27, %ymm25

// CHECK: vmulpd 291(%rax,%r14,8), %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x21,0xa5,0x20,0x59,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmulpd 291(%rax,%r14,8), %ymm27, %ymm25

// CHECK: vmulpd (%rcx){1to4}, %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x30,0x59,0x09]
          vmulpd (%rcx){1to4}, %ymm27, %ymm25

// CHECK: vmulpd 4064(%rdx), %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x20,0x59,0x4a,0x7f]
          vmulpd 4064(%rdx), %ymm27, %ymm25

// CHECK: vmulpd 4096(%rdx), %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x20,0x59,0x8a,0x00,0x10,0x00,0x00]
          vmulpd 4096(%rdx), %ymm27, %ymm25

// CHECK: vmulpd -4096(%rdx), %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x20,0x59,0x4a,0x80]
          vmulpd -4096(%rdx), %ymm27, %ymm25

// CHECK: vmulpd -4128(%rdx), %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x20,0x59,0x8a,0xe0,0xef,0xff,0xff]
          vmulpd -4128(%rdx), %ymm27, %ymm25

// CHECK: vmulpd 1016(%rdx){1to4}, %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x30,0x59,0x4a,0x7f]
          vmulpd 1016(%rdx){1to4}, %ymm27, %ymm25

// CHECK: vmulpd 1024(%rdx){1to4}, %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x30,0x59,0x8a,0x00,0x04,0x00,0x00]
          vmulpd 1024(%rdx){1to4}, %ymm27, %ymm25

// CHECK: vmulpd -1024(%rdx){1to4}, %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x30,0x59,0x4a,0x80]
          vmulpd -1024(%rdx){1to4}, %ymm27, %ymm25

// CHECK: vmulpd -1032(%rdx){1to4}, %ymm27, %ymm25
// CHECK:  encoding: [0x62,0x61,0xa5,0x30,0x59,0x8a,0xf8,0xfb,0xff,0xff]
          vmulpd -1032(%rdx){1to4}, %ymm27, %ymm25

// CHECK: vmulps %xmm21, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x21,0x74,0x00,0x59,0xed]
          vmulps %xmm21, %xmm17, %xmm29

// CHECK: vmulps %xmm21, %xmm17, %xmm29 {%k2}
// CHECK:  encoding: [0x62,0x21,0x74,0x02,0x59,0xed]
          vmulps %xmm21, %xmm17, %xmm29 {%k2}

// CHECK: vmulps %xmm21, %xmm17, %xmm29 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x74,0x82,0x59,0xed]
          vmulps %xmm21, %xmm17, %xmm29 {%k2} {z}

// CHECK: vmulps (%rcx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x59,0x29]
          vmulps (%rcx), %xmm17, %xmm29

// CHECK: vmulps 291(%rax,%r14,8), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x21,0x74,0x00,0x59,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmulps 291(%rax,%r14,8), %xmm17, %xmm29

// CHECK: vmulps (%rcx){1to4}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x59,0x29]
          vmulps (%rcx){1to4}, %xmm17, %xmm29

// CHECK: vmulps 2032(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x59,0x6a,0x7f]
          vmulps 2032(%rdx), %xmm17, %xmm29

// CHECK: vmulps 2048(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x59,0xaa,0x00,0x08,0x00,0x00]
          vmulps 2048(%rdx), %xmm17, %xmm29

// CHECK: vmulps -2048(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x59,0x6a,0x80]
          vmulps -2048(%rdx), %xmm17, %xmm29

// CHECK: vmulps -2064(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x00,0x59,0xaa,0xf0,0xf7,0xff,0xff]
          vmulps -2064(%rdx), %xmm17, %xmm29

// CHECK: vmulps 508(%rdx){1to4}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x59,0x6a,0x7f]
          vmulps 508(%rdx){1to4}, %xmm17, %xmm29

// CHECK: vmulps 512(%rdx){1to4}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x59,0xaa,0x00,0x02,0x00,0x00]
          vmulps 512(%rdx){1to4}, %xmm17, %xmm29

// CHECK: vmulps -512(%rdx){1to4}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x59,0x6a,0x80]
          vmulps -512(%rdx){1to4}, %xmm17, %xmm29

// CHECK: vmulps -516(%rdx){1to4}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0x74,0x10,0x59,0xaa,0xfc,0xfd,0xff,0xff]
          vmulps -516(%rdx){1to4}, %xmm17, %xmm29

// CHECK: vmulps %ymm28, %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x01,0x2c,0x20,0x59,0xf4]
          vmulps %ymm28, %ymm26, %ymm30

// CHECK: vmulps %ymm28, %ymm26, %ymm30 {%k3}
// CHECK:  encoding: [0x62,0x01,0x2c,0x23,0x59,0xf4]
          vmulps %ymm28, %ymm26, %ymm30 {%k3}

// CHECK: vmulps %ymm28, %ymm26, %ymm30 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0x2c,0xa3,0x59,0xf4]
          vmulps %ymm28, %ymm26, %ymm30 {%k3} {z}

// CHECK: vmulps (%rcx), %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x59,0x31]
          vmulps (%rcx), %ymm26, %ymm30

// CHECK: vmulps 291(%rax,%r14,8), %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x21,0x2c,0x20,0x59,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmulps 291(%rax,%r14,8), %ymm26, %ymm30

// CHECK: vmulps (%rcx){1to8}, %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x59,0x31]
          vmulps (%rcx){1to8}, %ymm26, %ymm30

// CHECK: vmulps 4064(%rdx), %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x59,0x72,0x7f]
          vmulps 4064(%rdx), %ymm26, %ymm30

// CHECK: vmulps 4096(%rdx), %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x59,0xb2,0x00,0x10,0x00,0x00]
          vmulps 4096(%rdx), %ymm26, %ymm30

// CHECK: vmulps -4096(%rdx), %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x59,0x72,0x80]
          vmulps -4096(%rdx), %ymm26, %ymm30

// CHECK: vmulps -4128(%rdx), %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x20,0x59,0xb2,0xe0,0xef,0xff,0xff]
          vmulps -4128(%rdx), %ymm26, %ymm30

// CHECK: vmulps 508(%rdx){1to8}, %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x59,0x72,0x7f]
          vmulps 508(%rdx){1to8}, %ymm26, %ymm30

// CHECK: vmulps 512(%rdx){1to8}, %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x59,0xb2,0x00,0x02,0x00,0x00]
          vmulps 512(%rdx){1to8}, %ymm26, %ymm30

// CHECK: vmulps -512(%rdx){1to8}, %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x59,0x72,0x80]
          vmulps -512(%rdx){1to8}, %ymm26, %ymm30

// CHECK: vmulps -516(%rdx){1to8}, %ymm26, %ymm30
// CHECK:  encoding: [0x62,0x61,0x2c,0x30,0x59,0xb2,0xfc,0xfd,0xff,0xff]
          vmulps -516(%rdx){1to8}, %ymm26, %ymm30

// CHECK: vpaddd %xmm26, %xmm19, %xmm21
// CHECK:  encoding: [0x62,0x81,0x65,0x00,0xfe,0xea]
          vpaddd %xmm26, %xmm19, %xmm21

// CHECK: vpaddd %xmm26, %xmm19, %xmm21 {%k5}
// CHECK:  encoding: [0x62,0x81,0x65,0x05,0xfe,0xea]
          vpaddd %xmm26, %xmm19, %xmm21 {%k5}

// CHECK: vpaddd %xmm26, %xmm19, %xmm21 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0x65,0x85,0xfe,0xea]
          vpaddd %xmm26, %xmm19, %xmm21 {%k5} {z}

// CHECK: vpaddd (%rcx), %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x00,0xfe,0x29]
          vpaddd (%rcx), %xmm19, %xmm21

// CHECK: vpaddd 291(%rax,%r14,8), %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xa1,0x65,0x00,0xfe,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpaddd 291(%rax,%r14,8), %xmm19, %xmm21

// CHECK: vpaddd (%rcx){1to4}, %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x10,0xfe,0x29]
          vpaddd (%rcx){1to4}, %xmm19, %xmm21

// CHECK: vpaddd 2032(%rdx), %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x00,0xfe,0x6a,0x7f]
          vpaddd 2032(%rdx), %xmm19, %xmm21

// CHECK: vpaddd 2048(%rdx), %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x00,0xfe,0xaa,0x00,0x08,0x00,0x00]
          vpaddd 2048(%rdx), %xmm19, %xmm21

// CHECK: vpaddd -2048(%rdx), %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x00,0xfe,0x6a,0x80]
          vpaddd -2048(%rdx), %xmm19, %xmm21

// CHECK: vpaddd -2064(%rdx), %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x00,0xfe,0xaa,0xf0,0xf7,0xff,0xff]
          vpaddd -2064(%rdx), %xmm19, %xmm21

// CHECK: vpaddd 508(%rdx){1to4}, %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x10,0xfe,0x6a,0x7f]
          vpaddd 508(%rdx){1to4}, %xmm19, %xmm21

// CHECK: vpaddd 512(%rdx){1to4}, %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x10,0xfe,0xaa,0x00,0x02,0x00,0x00]
          vpaddd 512(%rdx){1to4}, %xmm19, %xmm21

// CHECK: vpaddd -512(%rdx){1to4}, %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x10,0xfe,0x6a,0x80]
          vpaddd -512(%rdx){1to4}, %xmm19, %xmm21

// CHECK: vpaddd -516(%rdx){1to4}, %xmm19, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x65,0x10,0xfe,0xaa,0xfc,0xfd,0xff,0xff]
          vpaddd -516(%rdx){1to4}, %xmm19, %xmm21

// CHECK: vpaddd %ymm17, %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x21,0x45,0x20,0xfe,0xe9]
          vpaddd %ymm17, %ymm23, %ymm29

// CHECK: vpaddd %ymm17, %ymm23, %ymm29 {%k5}
// CHECK:  encoding: [0x62,0x21,0x45,0x25,0xfe,0xe9]
          vpaddd %ymm17, %ymm23, %ymm29 {%k5}

// CHECK: vpaddd %ymm17, %ymm23, %ymm29 {%k5} {z}
// CHECK:  encoding: [0x62,0x21,0x45,0xa5,0xfe,0xe9]
          vpaddd %ymm17, %ymm23, %ymm29 {%k5} {z}

// CHECK: vpaddd (%rcx), %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x20,0xfe,0x29]
          vpaddd (%rcx), %ymm23, %ymm29

// CHECK: vpaddd 291(%rax,%r14,8), %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x21,0x45,0x20,0xfe,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpaddd 291(%rax,%r14,8), %ymm23, %ymm29

// CHECK: vpaddd (%rcx){1to8}, %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x30,0xfe,0x29]
          vpaddd (%rcx){1to8}, %ymm23, %ymm29

// CHECK: vpaddd 4064(%rdx), %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x20,0xfe,0x6a,0x7f]
          vpaddd 4064(%rdx), %ymm23, %ymm29

// CHECK: vpaddd 4096(%rdx), %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x20,0xfe,0xaa,0x00,0x10,0x00,0x00]
          vpaddd 4096(%rdx), %ymm23, %ymm29

// CHECK: vpaddd -4096(%rdx), %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x20,0xfe,0x6a,0x80]
          vpaddd -4096(%rdx), %ymm23, %ymm29

// CHECK: vpaddd -4128(%rdx), %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x20,0xfe,0xaa,0xe0,0xef,0xff,0xff]
          vpaddd -4128(%rdx), %ymm23, %ymm29

// CHECK: vpaddd 508(%rdx){1to8}, %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x30,0xfe,0x6a,0x7f]
          vpaddd 508(%rdx){1to8}, %ymm23, %ymm29

// CHECK: vpaddd 512(%rdx){1to8}, %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x30,0xfe,0xaa,0x00,0x02,0x00,0x00]
          vpaddd 512(%rdx){1to8}, %ymm23, %ymm29

// CHECK: vpaddd -512(%rdx){1to8}, %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x30,0xfe,0x6a,0x80]
          vpaddd -512(%rdx){1to8}, %ymm23, %ymm29

// CHECK: vpaddd -516(%rdx){1to8}, %ymm23, %ymm29
// CHECK:  encoding: [0x62,0x61,0x45,0x30,0xfe,0xaa,0xfc,0xfd,0xff,0xff]
          vpaddd -516(%rdx){1to8}, %ymm23, %ymm29

// CHECK: vpaddq %xmm26, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x01,0xf5,0x00,0xd4,0xea]
          vpaddq %xmm26, %xmm17, %xmm29

// CHECK: vpaddq %xmm26, %xmm17, %xmm29 {%k2}
// CHECK:  encoding: [0x62,0x01,0xf5,0x02,0xd4,0xea]
          vpaddq %xmm26, %xmm17, %xmm29 {%k2}

// CHECK: vpaddq %xmm26, %xmm17, %xmm29 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0xf5,0x82,0xd4,0xea]
          vpaddq %xmm26, %xmm17, %xmm29 {%k2} {z}

// CHECK: vpaddq (%rcx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xd4,0x29]
          vpaddq (%rcx), %xmm17, %xmm29

// CHECK: vpaddq 291(%rax,%r14,8), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x21,0xf5,0x00,0xd4,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpaddq 291(%rax,%r14,8), %xmm17, %xmm29

// CHECK: vpaddq (%rcx){1to2}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xd4,0x29]
          vpaddq (%rcx){1to2}, %xmm17, %xmm29

// CHECK: vpaddq 2032(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xd4,0x6a,0x7f]
          vpaddq 2032(%rdx), %xmm17, %xmm29

// CHECK: vpaddq 2048(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xd4,0xaa,0x00,0x08,0x00,0x00]
          vpaddq 2048(%rdx), %xmm17, %xmm29

// CHECK: vpaddq -2048(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xd4,0x6a,0x80]
          vpaddq -2048(%rdx), %xmm17, %xmm29

// CHECK: vpaddq -2064(%rdx), %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xd4,0xaa,0xf0,0xf7,0xff,0xff]
          vpaddq -2064(%rdx), %xmm17, %xmm29

// CHECK: vpaddq 1016(%rdx){1to2}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xd4,0x6a,0x7f]
          vpaddq 1016(%rdx){1to2}, %xmm17, %xmm29

// CHECK: vpaddq 1024(%rdx){1to2}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xd4,0xaa,0x00,0x04,0x00,0x00]
          vpaddq 1024(%rdx){1to2}, %xmm17, %xmm29

// CHECK: vpaddq -1024(%rdx){1to2}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xd4,0x6a,0x80]
          vpaddq -1024(%rdx){1to2}, %xmm17, %xmm29

// CHECK: vpaddq -1032(%rdx){1to2}, %xmm17, %xmm29
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xd4,0xaa,0xf8,0xfb,0xff,0xff]
          vpaddq -1032(%rdx){1to2}, %xmm17, %xmm29

// CHECK: vpaddq %ymm18, %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xa1,0xb5,0x20,0xd4,0xe2]
          vpaddq %ymm18, %ymm25, %ymm20

// CHECK: vpaddq %ymm18, %ymm25, %ymm20 {%k6}
// CHECK:  encoding: [0x62,0xa1,0xb5,0x26,0xd4,0xe2]
          vpaddq %ymm18, %ymm25, %ymm20 {%k6}

// CHECK: vpaddq %ymm18, %ymm25, %ymm20 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0xb5,0xa6,0xd4,0xe2]
          vpaddq %ymm18, %ymm25, %ymm20 {%k6} {z}

// CHECK: vpaddq (%rcx), %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x20,0xd4,0x21]
          vpaddq (%rcx), %ymm25, %ymm20

// CHECK: vpaddq 291(%rax,%r14,8), %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xa1,0xb5,0x20,0xd4,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpaddq 291(%rax,%r14,8), %ymm25, %ymm20

// CHECK: vpaddq (%rcx){1to4}, %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x30,0xd4,0x21]
          vpaddq (%rcx){1to4}, %ymm25, %ymm20

// CHECK: vpaddq 4064(%rdx), %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x20,0xd4,0x62,0x7f]
          vpaddq 4064(%rdx), %ymm25, %ymm20

// CHECK: vpaddq 4096(%rdx), %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x20,0xd4,0xa2,0x00,0x10,0x00,0x00]
          vpaddq 4096(%rdx), %ymm25, %ymm20

// CHECK: vpaddq -4096(%rdx), %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x20,0xd4,0x62,0x80]
          vpaddq -4096(%rdx), %ymm25, %ymm20

// CHECK: vpaddq -4128(%rdx), %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x20,0xd4,0xa2,0xe0,0xef,0xff,0xff]
          vpaddq -4128(%rdx), %ymm25, %ymm20

// CHECK: vpaddq 1016(%rdx){1to4}, %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x30,0xd4,0x62,0x7f]
          vpaddq 1016(%rdx){1to4}, %ymm25, %ymm20

// CHECK: vpaddq 1024(%rdx){1to4}, %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x30,0xd4,0xa2,0x00,0x04,0x00,0x00]
          vpaddq 1024(%rdx){1to4}, %ymm25, %ymm20

// CHECK: vpaddq -1024(%rdx){1to4}, %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x30,0xd4,0x62,0x80]
          vpaddq -1024(%rdx){1to4}, %ymm25, %ymm20

// CHECK: vpaddq -1032(%rdx){1to4}, %ymm25, %ymm20
// CHECK:  encoding: [0x62,0xe1,0xb5,0x30,0xd4,0xa2,0xf8,0xfb,0xff,0xff]
          vpaddq -1032(%rdx){1to4}, %ymm25, %ymm20

// CHECK: vpandd %xmm18, %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x21,0x2d,0x00,0xdb,0xc2]
          vpandd %xmm18, %xmm26, %xmm24

// CHECK: vpandd %xmm18, %xmm26, %xmm24 {%k2}
// CHECK:  encoding: [0x62,0x21,0x2d,0x02,0xdb,0xc2]
          vpandd %xmm18, %xmm26, %xmm24 {%k2}

// CHECK: vpandd %xmm18, %xmm26, %xmm24 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x2d,0x82,0xdb,0xc2]
          vpandd %xmm18, %xmm26, %xmm24 {%k2} {z}

// CHECK: vpandd (%rcx), %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xdb,0x01]
          vpandd (%rcx), %xmm26, %xmm24

// CHECK: vpandd 291(%rax,%r14,8), %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x21,0x2d,0x00,0xdb,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpandd 291(%rax,%r14,8), %xmm26, %xmm24

// CHECK: vpandd (%rcx){1to4}, %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x10,0xdb,0x01]
          vpandd (%rcx){1to4}, %xmm26, %xmm24

// CHECK: vpandd 2032(%rdx), %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xdb,0x42,0x7f]
          vpandd 2032(%rdx), %xmm26, %xmm24

// CHECK: vpandd 2048(%rdx), %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xdb,0x82,0x00,0x08,0x00,0x00]
          vpandd 2048(%rdx), %xmm26, %xmm24

// CHECK: vpandd -2048(%rdx), %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xdb,0x42,0x80]
          vpandd -2048(%rdx), %xmm26, %xmm24

// CHECK: vpandd -2064(%rdx), %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x00,0xdb,0x82,0xf0,0xf7,0xff,0xff]
          vpandd -2064(%rdx), %xmm26, %xmm24

// CHECK: vpandd 508(%rdx){1to4}, %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x10,0xdb,0x42,0x7f]
          vpandd 508(%rdx){1to4}, %xmm26, %xmm24

// CHECK: vpandd 512(%rdx){1to4}, %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x10,0xdb,0x82,0x00,0x02,0x00,0x00]
          vpandd 512(%rdx){1to4}, %xmm26, %xmm24

// CHECK: vpandd -512(%rdx){1to4}, %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x10,0xdb,0x42,0x80]
          vpandd -512(%rdx){1to4}, %xmm26, %xmm24

// CHECK: vpandd -516(%rdx){1to4}, %xmm26, %xmm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x10,0xdb,0x82,0xfc,0xfd,0xff,0xff]
          vpandd -516(%rdx){1to4}, %xmm26, %xmm24

// CHECK: vpandd %ymm20, %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xa1,0x55,0x20,0xdb,0xd4]
          vpandd %ymm20, %ymm21, %ymm18

// CHECK: vpandd %ymm20, %ymm21, %ymm18 {%k3}
// CHECK:  encoding: [0x62,0xa1,0x55,0x23,0xdb,0xd4]
          vpandd %ymm20, %ymm21, %ymm18 {%k3}

// CHECK: vpandd %ymm20, %ymm21, %ymm18 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0x55,0xa3,0xdb,0xd4]
          vpandd %ymm20, %ymm21, %ymm18 {%k3} {z}

// CHECK: vpandd (%rcx), %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xdb,0x11]
          vpandd (%rcx), %ymm21, %ymm18

// CHECK: vpandd 291(%rax,%r14,8), %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xa1,0x55,0x20,0xdb,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpandd 291(%rax,%r14,8), %ymm21, %ymm18

// CHECK: vpandd (%rcx){1to8}, %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x30,0xdb,0x11]
          vpandd (%rcx){1to8}, %ymm21, %ymm18

// CHECK: vpandd 4064(%rdx), %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xdb,0x52,0x7f]
          vpandd 4064(%rdx), %ymm21, %ymm18

// CHECK: vpandd 4096(%rdx), %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xdb,0x92,0x00,0x10,0x00,0x00]
          vpandd 4096(%rdx), %ymm21, %ymm18

// CHECK: vpandd -4096(%rdx), %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xdb,0x52,0x80]
          vpandd -4096(%rdx), %ymm21, %ymm18

// CHECK: vpandd -4128(%rdx), %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x20,0xdb,0x92,0xe0,0xef,0xff,0xff]
          vpandd -4128(%rdx), %ymm21, %ymm18

// CHECK: vpandd 508(%rdx){1to8}, %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x30,0xdb,0x52,0x7f]
          vpandd 508(%rdx){1to8}, %ymm21, %ymm18

// CHECK: vpandd 512(%rdx){1to8}, %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x30,0xdb,0x92,0x00,0x02,0x00,0x00]
          vpandd 512(%rdx){1to8}, %ymm21, %ymm18

// CHECK: vpandd -512(%rdx){1to8}, %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x30,0xdb,0x52,0x80]
          vpandd -512(%rdx){1to8}, %ymm21, %ymm18

// CHECK: vpandd -516(%rdx){1to8}, %ymm21, %ymm18
// CHECK:  encoding: [0x62,0xe1,0x55,0x30,0xdb,0x92,0xfc,0xfd,0xff,0xff]
          vpandd -516(%rdx){1to8}, %ymm21, %ymm18

// CHECK: vpandnd %xmm22, %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x21,0x75,0x00,0xdf,0xc6]
          vpandnd %xmm22, %xmm17, %xmm24

// CHECK: vpandnd %xmm22, %xmm17, %xmm24 {%k2}
// CHECK:  encoding: [0x62,0x21,0x75,0x02,0xdf,0xc6]
          vpandnd %xmm22, %xmm17, %xmm24 {%k2}

// CHECK: vpandnd %xmm22, %xmm17, %xmm24 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0x75,0x82,0xdf,0xc6]
          vpandnd %xmm22, %xmm17, %xmm24 {%k2} {z}

// CHECK: vpandnd (%rcx), %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xdf,0x01]
          vpandnd (%rcx), %xmm17, %xmm24

// CHECK: vpandnd 291(%rax,%r14,8), %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x21,0x75,0x00,0xdf,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpandnd 291(%rax,%r14,8), %xmm17, %xmm24

// CHECK: vpandnd (%rcx){1to4}, %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x10,0xdf,0x01]
          vpandnd (%rcx){1to4}, %xmm17, %xmm24

// CHECK: vpandnd 2032(%rdx), %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xdf,0x42,0x7f]
          vpandnd 2032(%rdx), %xmm17, %xmm24

// CHECK: vpandnd 2048(%rdx), %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xdf,0x82,0x00,0x08,0x00,0x00]
          vpandnd 2048(%rdx), %xmm17, %xmm24

// CHECK: vpandnd -2048(%rdx), %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xdf,0x42,0x80]
          vpandnd -2048(%rdx), %xmm17, %xmm24

// CHECK: vpandnd -2064(%rdx), %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x00,0xdf,0x82,0xf0,0xf7,0xff,0xff]
          vpandnd -2064(%rdx), %xmm17, %xmm24

// CHECK: vpandnd 508(%rdx){1to4}, %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x10,0xdf,0x42,0x7f]
          vpandnd 508(%rdx){1to4}, %xmm17, %xmm24

// CHECK: vpandnd 512(%rdx){1to4}, %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x10,0xdf,0x82,0x00,0x02,0x00,0x00]
          vpandnd 512(%rdx){1to4}, %xmm17, %xmm24

// CHECK: vpandnd -512(%rdx){1to4}, %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x10,0xdf,0x42,0x80]
          vpandnd -512(%rdx){1to4}, %xmm17, %xmm24

// CHECK: vpandnd -516(%rdx){1to4}, %xmm17, %xmm24
// CHECK:  encoding: [0x62,0x61,0x75,0x10,0xdf,0x82,0xfc,0xfd,0xff,0xff]
          vpandnd -516(%rdx){1to4}, %xmm17, %xmm24

// CHECK: vpandnd %ymm17, %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xa1,0x25,0x20,0xdf,0xd9]
          vpandnd %ymm17, %ymm27, %ymm19

// CHECK: vpandnd %ymm17, %ymm27, %ymm19 {%k2}
// CHECK:  encoding: [0x62,0xa1,0x25,0x22,0xdf,0xd9]
          vpandnd %ymm17, %ymm27, %ymm19 {%k2}

// CHECK: vpandnd %ymm17, %ymm27, %ymm19 {%k2} {z}
// CHECK:  encoding: [0x62,0xa1,0x25,0xa2,0xdf,0xd9]
          vpandnd %ymm17, %ymm27, %ymm19 {%k2} {z}

// CHECK: vpandnd (%rcx), %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x20,0xdf,0x19]
          vpandnd (%rcx), %ymm27, %ymm19

// CHECK: vpandnd 291(%rax,%r14,8), %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xa1,0x25,0x20,0xdf,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpandnd 291(%rax,%r14,8), %ymm27, %ymm19

// CHECK: vpandnd (%rcx){1to8}, %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x30,0xdf,0x19]
          vpandnd (%rcx){1to8}, %ymm27, %ymm19

// CHECK: vpandnd 4064(%rdx), %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x20,0xdf,0x5a,0x7f]
          vpandnd 4064(%rdx), %ymm27, %ymm19

// CHECK: vpandnd 4096(%rdx), %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x20,0xdf,0x9a,0x00,0x10,0x00,0x00]
          vpandnd 4096(%rdx), %ymm27, %ymm19

// CHECK: vpandnd -4096(%rdx), %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x20,0xdf,0x5a,0x80]
          vpandnd -4096(%rdx), %ymm27, %ymm19

// CHECK: vpandnd -4128(%rdx), %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x20,0xdf,0x9a,0xe0,0xef,0xff,0xff]
          vpandnd -4128(%rdx), %ymm27, %ymm19

// CHECK: vpandnd 508(%rdx){1to8}, %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x30,0xdf,0x5a,0x7f]
          vpandnd 508(%rdx){1to8}, %ymm27, %ymm19

// CHECK: vpandnd 512(%rdx){1to8}, %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x30,0xdf,0x9a,0x00,0x02,0x00,0x00]
          vpandnd 512(%rdx){1to8}, %ymm27, %ymm19

// CHECK: vpandnd -512(%rdx){1to8}, %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x30,0xdf,0x5a,0x80]
          vpandnd -512(%rdx){1to8}, %ymm27, %ymm19

// CHECK: vpandnd -516(%rdx){1to8}, %ymm27, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x25,0x30,0xdf,0x9a,0xfc,0xfd,0xff,0xff]
          vpandnd -516(%rdx){1to8}, %ymm27, %ymm19

// CHECK: vpandnq %xmm20, %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xa1,0x9d,0x00,0xdf,0xfc]
          vpandnq %xmm20, %xmm28, %xmm23

// CHECK: vpandnq %xmm20, %xmm28, %xmm23 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x9d,0x07,0xdf,0xfc]
          vpandnq %xmm20, %xmm28, %xmm23 {%k7}

// CHECK: vpandnq %xmm20, %xmm28, %xmm23 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x9d,0x87,0xdf,0xfc]
          vpandnq %xmm20, %xmm28, %xmm23 {%k7} {z}

// CHECK: vpandnq (%rcx), %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xdf,0x39]
          vpandnq (%rcx), %xmm28, %xmm23

// CHECK: vpandnq 291(%rax,%r14,8), %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xa1,0x9d,0x00,0xdf,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpandnq 291(%rax,%r14,8), %xmm28, %xmm23

// CHECK: vpandnq (%rcx){1to2}, %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xdf,0x39]
          vpandnq (%rcx){1to2}, %xmm28, %xmm23

// CHECK: vpandnq 2032(%rdx), %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xdf,0x7a,0x7f]
          vpandnq 2032(%rdx), %xmm28, %xmm23

// CHECK: vpandnq 2048(%rdx), %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xdf,0xba,0x00,0x08,0x00,0x00]
          vpandnq 2048(%rdx), %xmm28, %xmm23

// CHECK: vpandnq -2048(%rdx), %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xdf,0x7a,0x80]
          vpandnq -2048(%rdx), %xmm28, %xmm23

// CHECK: vpandnq -2064(%rdx), %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xdf,0xba,0xf0,0xf7,0xff,0xff]
          vpandnq -2064(%rdx), %xmm28, %xmm23

// CHECK: vpandnq 1016(%rdx){1to2}, %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xdf,0x7a,0x7f]
          vpandnq 1016(%rdx){1to2}, %xmm28, %xmm23

// CHECK: vpandnq 1024(%rdx){1to2}, %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xdf,0xba,0x00,0x04,0x00,0x00]
          vpandnq 1024(%rdx){1to2}, %xmm28, %xmm23

// CHECK: vpandnq -1024(%rdx){1to2}, %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xdf,0x7a,0x80]
          vpandnq -1024(%rdx){1to2}, %xmm28, %xmm23

// CHECK: vpandnq -1032(%rdx){1to2}, %xmm28, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xdf,0xba,0xf8,0xfb,0xff,0xff]
          vpandnq -1032(%rdx){1to2}, %xmm28, %xmm23

// CHECK: vpandnq %ymm28, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x01,0xdd,0x20,0xdf,0xec]
          vpandnq %ymm28, %ymm20, %ymm29

// CHECK: vpandnq %ymm28, %ymm20, %ymm29 {%k1}
// CHECK:  encoding: [0x62,0x01,0xdd,0x21,0xdf,0xec]
          vpandnq %ymm28, %ymm20, %ymm29 {%k1}

// CHECK: vpandnq %ymm28, %ymm20, %ymm29 {%k1} {z}
// CHECK:  encoding: [0x62,0x01,0xdd,0xa1,0xdf,0xec]
          vpandnq %ymm28, %ymm20, %ymm29 {%k1} {z}

// CHECK: vpandnq (%rcx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xdf,0x29]
          vpandnq (%rcx), %ymm20, %ymm29

// CHECK: vpandnq 291(%rax,%r14,8), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x21,0xdd,0x20,0xdf,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpandnq 291(%rax,%r14,8), %ymm20, %ymm29

// CHECK: vpandnq (%rcx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xdf,0x29]
          vpandnq (%rcx){1to4}, %ymm20, %ymm29

// CHECK: vpandnq 4064(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xdf,0x6a,0x7f]
          vpandnq 4064(%rdx), %ymm20, %ymm29

// CHECK: vpandnq 4096(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xdf,0xaa,0x00,0x10,0x00,0x00]
          vpandnq 4096(%rdx), %ymm20, %ymm29

// CHECK: vpandnq -4096(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xdf,0x6a,0x80]
          vpandnq -4096(%rdx), %ymm20, %ymm29

// CHECK: vpandnq -4128(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xdf,0xaa,0xe0,0xef,0xff,0xff]
          vpandnq -4128(%rdx), %ymm20, %ymm29

// CHECK: vpandnq 1016(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xdf,0x6a,0x7f]
          vpandnq 1016(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpandnq 1024(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xdf,0xaa,0x00,0x04,0x00,0x00]
          vpandnq 1024(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpandnq -1024(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xdf,0x6a,0x80]
          vpandnq -1024(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpandnq -1032(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xdf,0xaa,0xf8,0xfb,0xff,0xff]
          vpandnq -1032(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpandq %xmm25, %xmm19, %xmm22
// CHECK:  encoding: [0x62,0x81,0xe5,0x00,0xdb,0xf1]
          vpandq %xmm25, %xmm19, %xmm22

// CHECK: vpandq %xmm25, %xmm19, %xmm22 {%k5}
// CHECK:  encoding: [0x62,0x81,0xe5,0x05,0xdb,0xf1]
          vpandq %xmm25, %xmm19, %xmm22 {%k5}

// CHECK: vpandq %xmm25, %xmm19, %xmm22 {%k5} {z}
// CHECK:  encoding: [0x62,0x81,0xe5,0x85,0xdb,0xf1]
          vpandq %xmm25, %xmm19, %xmm22 {%k5} {z}

// CHECK: vpandq (%rcx), %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x00,0xdb,0x31]
          vpandq (%rcx), %xmm19, %xmm22

// CHECK: vpandq 291(%rax,%r14,8), %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xa1,0xe5,0x00,0xdb,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpandq 291(%rax,%r14,8), %xmm19, %xmm22

// CHECK: vpandq (%rcx){1to2}, %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x10,0xdb,0x31]
          vpandq (%rcx){1to2}, %xmm19, %xmm22

// CHECK: vpandq 2032(%rdx), %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x00,0xdb,0x72,0x7f]
          vpandq 2032(%rdx), %xmm19, %xmm22

// CHECK: vpandq 2048(%rdx), %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x00,0xdb,0xb2,0x00,0x08,0x00,0x00]
          vpandq 2048(%rdx), %xmm19, %xmm22

// CHECK: vpandq -2048(%rdx), %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x00,0xdb,0x72,0x80]
          vpandq -2048(%rdx), %xmm19, %xmm22

// CHECK: vpandq -2064(%rdx), %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x00,0xdb,0xb2,0xf0,0xf7,0xff,0xff]
          vpandq -2064(%rdx), %xmm19, %xmm22

// CHECK: vpandq 1016(%rdx){1to2}, %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x10,0xdb,0x72,0x7f]
          vpandq 1016(%rdx){1to2}, %xmm19, %xmm22

// CHECK: vpandq 1024(%rdx){1to2}, %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x10,0xdb,0xb2,0x00,0x04,0x00,0x00]
          vpandq 1024(%rdx){1to2}, %xmm19, %xmm22

// CHECK: vpandq -1024(%rdx){1to2}, %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x10,0xdb,0x72,0x80]
          vpandq -1024(%rdx){1to2}, %xmm19, %xmm22

// CHECK: vpandq -1032(%rdx){1to2}, %xmm19, %xmm22
// CHECK:  encoding: [0x62,0xe1,0xe5,0x10,0xdb,0xb2,0xf8,0xfb,0xff,0xff]
          vpandq -1032(%rdx){1to2}, %xmm19, %xmm22

// CHECK: vpandq %ymm24, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x01,0xad,0x20,0xdb,0xc8]
          vpandq %ymm24, %ymm26, %ymm25

// CHECK: vpandq %ymm24, %ymm26, %ymm25 {%k7}
// CHECK:  encoding: [0x62,0x01,0xad,0x27,0xdb,0xc8]
          vpandq %ymm24, %ymm26, %ymm25 {%k7}

// CHECK: vpandq %ymm24, %ymm26, %ymm25 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0xad,0xa7,0xdb,0xc8]
          vpandq %ymm24, %ymm26, %ymm25 {%k7} {z}

// CHECK: vpandq (%rcx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0xdb,0x09]
          vpandq (%rcx), %ymm26, %ymm25

// CHECK: vpandq 291(%rax,%r14,8), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x21,0xad,0x20,0xdb,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpandq 291(%rax,%r14,8), %ymm26, %ymm25

// CHECK: vpandq (%rcx){1to4}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0xdb,0x09]
          vpandq (%rcx){1to4}, %ymm26, %ymm25

// CHECK: vpandq 4064(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0xdb,0x4a,0x7f]
          vpandq 4064(%rdx), %ymm26, %ymm25

// CHECK: vpandq 4096(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0xdb,0x8a,0x00,0x10,0x00,0x00]
          vpandq 4096(%rdx), %ymm26, %ymm25

// CHECK: vpandq -4096(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0xdb,0x4a,0x80]
          vpandq -4096(%rdx), %ymm26, %ymm25

// CHECK: vpandq -4128(%rdx), %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x20,0xdb,0x8a,0xe0,0xef,0xff,0xff]
          vpandq -4128(%rdx), %ymm26, %ymm25

// CHECK: vpandq 1016(%rdx){1to4}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0xdb,0x4a,0x7f]
          vpandq 1016(%rdx){1to4}, %ymm26, %ymm25

// CHECK: vpandq 1024(%rdx){1to4}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0xdb,0x8a,0x00,0x04,0x00,0x00]
          vpandq 1024(%rdx){1to4}, %ymm26, %ymm25

// CHECK: vpandq -1024(%rdx){1to4}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0xdb,0x4a,0x80]
          vpandq -1024(%rdx){1to4}, %ymm26, %ymm25

// CHECK: vpandq -1032(%rdx){1to4}, %ymm26, %ymm25
// CHECK:  encoding: [0x62,0x61,0xad,0x30,0xdb,0x8a,0xf8,0xfb,0xff,0xff]
          vpandq -1032(%rdx){1to4}, %ymm26, %ymm25

// CHECK: vpbroadcastd %eax, %xmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x7c,0xf0]
          vpbroadcastd %eax, %xmm22

// CHECK: vpbroadcastd %eax, %xmm22 {%k5}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x0d,0x7c,0xf0]
          vpbroadcastd %eax, %xmm22 {%k5}

// CHECK: vpbroadcastd %eax, %xmm22 {%k5} {z}
// CHECK:  encoding: [0x62,0xe2,0x7d,0x8d,0x7c,0xf0]
          vpbroadcastd %eax, %xmm22 {%k5} {z}

// CHECK: vpbroadcastd %ebp, %xmm22
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x7c,0xf5]
          vpbroadcastd %ebp, %xmm22

// CHECK: vpbroadcastd %r13d, %xmm22
// CHECK:  encoding: [0x62,0xc2,0x7d,0x08,0x7c,0xf5]
          vpbroadcastd %r13d, %xmm22

// CHECK: vpbroadcastd %eax, %ymm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x7c,0xc8]
          vpbroadcastd %eax, %ymm25

// CHECK: vpbroadcastd %eax, %ymm25 {%k5}
// CHECK:  encoding: [0x62,0x62,0x7d,0x2d,0x7c,0xc8]
          vpbroadcastd %eax, %ymm25 {%k5}

// CHECK: vpbroadcastd %eax, %ymm25 {%k5} {z}
// CHECK:  encoding: [0x62,0x62,0x7d,0xad,0x7c,0xc8]
          vpbroadcastd %eax, %ymm25 {%k5} {z}

// CHECK: vpbroadcastd %ebp, %ymm25
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x7c,0xcd]
          vpbroadcastd %ebp, %ymm25

// CHECK: vpbroadcastd %r13d, %ymm25
// CHECK:  encoding: [0x62,0x42,0x7d,0x28,0x7c,0xcd]
          vpbroadcastd %r13d, %ymm25

// CHECK: vpbroadcastq %rax, %xmm22
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x7c,0xf0]
          vpbroadcastq %rax, %xmm22

// CHECK: vpbroadcastq %rax, %xmm22 {%k2}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x0a,0x7c,0xf0]
          vpbroadcastq %rax, %xmm22 {%k2}

// CHECK: vpbroadcastq %rax, %xmm22 {%k2} {z}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x8a,0x7c,0xf0]
          vpbroadcastq %rax, %xmm22 {%k2} {z}

// CHECK: vpbroadcastq %r8, %xmm22
// CHECK:  encoding: [0x62,0xc2,0xfd,0x08,0x7c,0xf0]
          vpbroadcastq %r8, %xmm22

// CHECK: vpbroadcastq %rax, %ymm19
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x7c,0xd8]
          vpbroadcastq %rax, %ymm19

// CHECK: vpbroadcastq %rax, %ymm19 {%k5}
// CHECK:  encoding: [0x62,0xe2,0xfd,0x2d,0x7c,0xd8]
          vpbroadcastq %rax, %ymm19 {%k5}

// CHECK: vpbroadcastq %rax, %ymm19 {%k5} {z}
// CHECK:  encoding: [0x62,0xe2,0xfd,0xad,0x7c,0xd8]
          vpbroadcastq %rax, %ymm19 {%k5} {z}

// CHECK: vpbroadcastq %r8, %ymm19
// CHECK:  encoding: [0x62,0xc2,0xfd,0x28,0x7c,0xd8]
          vpbroadcastq %r8, %ymm19

// CHECK: vpcmpd $171, %xmm20, %xmm23, %k4
// CHECK:  encoding: [0x62,0xb3,0x45,0x00,0x1f,0xe4,0xab]
          vpcmpd $171, %xmm20, %xmm23, %k4

// CHECK: vpcmpd $171, %xmm20, %xmm23, %k4 {%k1}
// CHECK:  encoding: [0x62,0xb3,0x45,0x01,0x1f,0xe4,0xab]
          vpcmpd $171, %xmm20, %xmm23, %k4 {%k1}

// CHECK: vpcmpd $123, %xmm20, %xmm23, %k4
// CHECK:  encoding: [0x62,0xb3,0x45,0x00,0x1f,0xe4,0x7b]
          vpcmpd $123, %xmm20, %xmm23, %k4

// CHECK: vpcmpd $123, (%rcx), %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x00,0x1f,0x21,0x7b]
          vpcmpd $123, (%rcx), %xmm23, %k4

// CHECK: vpcmpd $123, 291(%rax,%r14,8), %xmm23, %k4
// CHECK:  encoding: [0x62,0xb3,0x45,0x00,0x1f,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpd $123, 291(%rax,%r14,8), %xmm23, %k4

// CHECK: vpcmpd $123, (%rcx){1to4}, %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x10,0x1f,0x21,0x7b]
          vpcmpd $123, (%rcx){1to4}, %xmm23, %k4

// CHECK: vpcmpd $123, 2032(%rdx), %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x00,0x1f,0x62,0x7f,0x7b]
          vpcmpd $123, 2032(%rdx), %xmm23, %k4

// CHECK: vpcmpd $123, 2048(%rdx), %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x00,0x1f,0xa2,0x00,0x08,0x00,0x00,0x7b]
          vpcmpd $123, 2048(%rdx), %xmm23, %k4

// CHECK: vpcmpd $123, -2048(%rdx), %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x00,0x1f,0x62,0x80,0x7b]
          vpcmpd $123, -2048(%rdx), %xmm23, %k4

// CHECK: vpcmpd $123, -2064(%rdx), %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x00,0x1f,0xa2,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpd $123, -2064(%rdx), %xmm23, %k4

// CHECK: vpcmpd $123, 508(%rdx){1to4}, %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x10,0x1f,0x62,0x7f,0x7b]
          vpcmpd $123, 508(%rdx){1to4}, %xmm23, %k4

// CHECK: vpcmpd $123, 512(%rdx){1to4}, %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x10,0x1f,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vpcmpd $123, 512(%rdx){1to4}, %xmm23, %k4

// CHECK: vpcmpd $123, -512(%rdx){1to4}, %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x10,0x1f,0x62,0x80,0x7b]
          vpcmpd $123, -512(%rdx){1to4}, %xmm23, %k4

// CHECK: vpcmpd $123, -516(%rdx){1to4}, %xmm23, %k4
// CHECK:  encoding: [0x62,0xf3,0x45,0x10,0x1f,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpd $123, -516(%rdx){1to4}, %xmm23, %k4

// CHECK: vpcmpd $171, %ymm19, %ymm24, %k4
// CHECK:  encoding: [0x62,0xb3,0x3d,0x20,0x1f,0xe3,0xab]
          vpcmpd $171, %ymm19, %ymm24, %k4

// CHECK: vpcmpd $171, %ymm19, %ymm24, %k4 {%k3}
// CHECK:  encoding: [0x62,0xb3,0x3d,0x23,0x1f,0xe3,0xab]
          vpcmpd $171, %ymm19, %ymm24, %k4 {%k3}

// CHECK: vpcmpd $123, %ymm19, %ymm24, %k4
// CHECK:  encoding: [0x62,0xb3,0x3d,0x20,0x1f,0xe3,0x7b]
          vpcmpd $123, %ymm19, %ymm24, %k4

// CHECK: vpcmpd $123, (%rcx), %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x20,0x1f,0x21,0x7b]
          vpcmpd $123, (%rcx), %ymm24, %k4

// CHECK: vpcmpd $123, 291(%rax,%r14,8), %ymm24, %k4
// CHECK:  encoding: [0x62,0xb3,0x3d,0x20,0x1f,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpd $123, 291(%rax,%r14,8), %ymm24, %k4

// CHECK: vpcmpd $123, (%rcx){1to8}, %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x30,0x1f,0x21,0x7b]
          vpcmpd $123, (%rcx){1to8}, %ymm24, %k4

// CHECK: vpcmpd $123, 4064(%rdx), %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x20,0x1f,0x62,0x7f,0x7b]
          vpcmpd $123, 4064(%rdx), %ymm24, %k4

// CHECK: vpcmpd $123, 4096(%rdx), %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x20,0x1f,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vpcmpd $123, 4096(%rdx), %ymm24, %k4

// CHECK: vpcmpd $123, -4096(%rdx), %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x20,0x1f,0x62,0x80,0x7b]
          vpcmpd $123, -4096(%rdx), %ymm24, %k4

// CHECK: vpcmpd $123, -4128(%rdx), %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x20,0x1f,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpd $123, -4128(%rdx), %ymm24, %k4

// CHECK: vpcmpd $123, 508(%rdx){1to8}, %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x30,0x1f,0x62,0x7f,0x7b]
          vpcmpd $123, 508(%rdx){1to8}, %ymm24, %k4

// CHECK: vpcmpd $123, 512(%rdx){1to8}, %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x30,0x1f,0xa2,0x00,0x02,0x00,0x00,0x7b]
          vpcmpd $123, 512(%rdx){1to8}, %ymm24, %k4

// CHECK: vpcmpd $123, -512(%rdx){1to8}, %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x30,0x1f,0x62,0x80,0x7b]
          vpcmpd $123, -512(%rdx){1to8}, %ymm24, %k4

// CHECK: vpcmpd $123, -516(%rdx){1to8}, %ymm24, %k4
// CHECK:  encoding: [0x62,0xf3,0x3d,0x30,0x1f,0xa2,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpd $123, -516(%rdx){1to8}, %ymm24, %k4

// CHECK: vpcmpeqd %xmm24, %xmm29, %k3
// CHECK:  encoding: [0x62,0x91,0x15,0x00,0x76,0xd8]
          vpcmpeqd %xmm24, %xmm29, %k3

// CHECK: vpcmpeqd %xmm24, %xmm29, %k3 {%k5}
// CHECK:  encoding: [0x62,0x91,0x15,0x05,0x76,0xd8]
          vpcmpeqd %xmm24, %xmm29, %k3 {%k5}

// CHECK: vpcmpeqd (%rcx), %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x76,0x19]
          vpcmpeqd (%rcx), %xmm29, %k3

// CHECK: vpcmpeqd 291(%rax,%r14,8), %xmm29, %k3
// CHECK:  encoding: [0x62,0xb1,0x15,0x00,0x76,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqd 291(%rax,%r14,8), %xmm29, %k3

// CHECK: vpcmpeqd (%rcx){1to4}, %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x76,0x19]
          vpcmpeqd (%rcx){1to4}, %xmm29, %k3

// CHECK: vpcmpeqd 2032(%rdx), %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x76,0x5a,0x7f]
          vpcmpeqd 2032(%rdx), %xmm29, %k3

// CHECK: vpcmpeqd 2048(%rdx), %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x76,0x9a,0x00,0x08,0x00,0x00]
          vpcmpeqd 2048(%rdx), %xmm29, %k3

// CHECK: vpcmpeqd -2048(%rdx), %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x76,0x5a,0x80]
          vpcmpeqd -2048(%rdx), %xmm29, %k3

// CHECK: vpcmpeqd -2064(%rdx), %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x76,0x9a,0xf0,0xf7,0xff,0xff]
          vpcmpeqd -2064(%rdx), %xmm29, %k3

// CHECK: vpcmpeqd 508(%rdx){1to4}, %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x76,0x5a,0x7f]
          vpcmpeqd 508(%rdx){1to4}, %xmm29, %k3

// CHECK: vpcmpeqd 512(%rdx){1to4}, %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x76,0x9a,0x00,0x02,0x00,0x00]
          vpcmpeqd 512(%rdx){1to4}, %xmm29, %k3

// CHECK: vpcmpeqd -512(%rdx){1to4}, %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x76,0x5a,0x80]
          vpcmpeqd -512(%rdx){1to4}, %xmm29, %k3

// CHECK: vpcmpeqd -516(%rdx){1to4}, %xmm29, %k3
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x76,0x9a,0xfc,0xfd,0xff,0xff]
          vpcmpeqd -516(%rdx){1to4}, %xmm29, %k3

// CHECK: vpcmpeqd %ymm20, %ymm26, %k5
// CHECK:  encoding: [0x62,0xb1,0x2d,0x20,0x76,0xec]
          vpcmpeqd %ymm20, %ymm26, %k5

// CHECK: vpcmpeqd %ymm20, %ymm26, %k5 {%k5}
// CHECK:  encoding: [0x62,0xb1,0x2d,0x25,0x76,0xec]
          vpcmpeqd %ymm20, %ymm26, %k5 {%k5}

// CHECK: vpcmpeqd (%rcx), %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x20,0x76,0x29]
          vpcmpeqd (%rcx), %ymm26, %k5

// CHECK: vpcmpeqd 291(%rax,%r14,8), %ymm26, %k5
// CHECK:  encoding: [0x62,0xb1,0x2d,0x20,0x76,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqd 291(%rax,%r14,8), %ymm26, %k5

// CHECK: vpcmpeqd (%rcx){1to8}, %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x30,0x76,0x29]
          vpcmpeqd (%rcx){1to8}, %ymm26, %k5

// CHECK: vpcmpeqd 4064(%rdx), %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x20,0x76,0x6a,0x7f]
          vpcmpeqd 4064(%rdx), %ymm26, %k5

// CHECK: vpcmpeqd 4096(%rdx), %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x20,0x76,0xaa,0x00,0x10,0x00,0x00]
          vpcmpeqd 4096(%rdx), %ymm26, %k5

// CHECK: vpcmpeqd -4096(%rdx), %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x20,0x76,0x6a,0x80]
          vpcmpeqd -4096(%rdx), %ymm26, %k5

// CHECK: vpcmpeqd -4128(%rdx), %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x20,0x76,0xaa,0xe0,0xef,0xff,0xff]
          vpcmpeqd -4128(%rdx), %ymm26, %k5

// CHECK: vpcmpeqd 508(%rdx){1to8}, %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x30,0x76,0x6a,0x7f]
          vpcmpeqd 508(%rdx){1to8}, %ymm26, %k5

// CHECK: vpcmpeqd 512(%rdx){1to8}, %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x30,0x76,0xaa,0x00,0x02,0x00,0x00]
          vpcmpeqd 512(%rdx){1to8}, %ymm26, %k5

// CHECK: vpcmpeqd -512(%rdx){1to8}, %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x30,0x76,0x6a,0x80]
          vpcmpeqd -512(%rdx){1to8}, %ymm26, %k5

// CHECK: vpcmpeqd -516(%rdx){1to8}, %ymm26, %k5
// CHECK:  encoding: [0x62,0xf1,0x2d,0x30,0x76,0xaa,0xfc,0xfd,0xff,0xff]
          vpcmpeqd -516(%rdx){1to8}, %ymm26, %k5

// CHECK: vpcmpeqq %xmm29, %xmm20, %k3
// CHECK:  encoding: [0x62,0x92,0xdd,0x00,0x29,0xdd]
          vpcmpeqq %xmm29, %xmm20, %k3

// CHECK: vpcmpeqq %xmm29, %xmm20, %k3 {%k3}
// CHECK:  encoding: [0x62,0x92,0xdd,0x03,0x29,0xdd]
          vpcmpeqq %xmm29, %xmm20, %k3 {%k3}

// CHECK: vpcmpeqq (%rcx), %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0x29,0x19]
          vpcmpeqq (%rcx), %xmm20, %k3

// CHECK: vpcmpeqq 291(%rax,%r14,8), %xmm20, %k3
// CHECK:  encoding: [0x62,0xb2,0xdd,0x00,0x29,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqq 291(%rax,%r14,8), %xmm20, %k3

// CHECK: vpcmpeqq (%rcx){1to2}, %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x10,0x29,0x19]
          vpcmpeqq (%rcx){1to2}, %xmm20, %k3

// CHECK: vpcmpeqq 2032(%rdx), %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0x29,0x5a,0x7f]
          vpcmpeqq 2032(%rdx), %xmm20, %k3

// CHECK: vpcmpeqq 2048(%rdx), %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0x29,0x9a,0x00,0x08,0x00,0x00]
          vpcmpeqq 2048(%rdx), %xmm20, %k3

// CHECK: vpcmpeqq -2048(%rdx), %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0x29,0x5a,0x80]
          vpcmpeqq -2048(%rdx), %xmm20, %k3

// CHECK: vpcmpeqq -2064(%rdx), %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x00,0x29,0x9a,0xf0,0xf7,0xff,0xff]
          vpcmpeqq -2064(%rdx), %xmm20, %k3

// CHECK: vpcmpeqq 1016(%rdx){1to2}, %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x10,0x29,0x5a,0x7f]
          vpcmpeqq 1016(%rdx){1to2}, %xmm20, %k3

// CHECK: vpcmpeqq 1024(%rdx){1to2}, %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x10,0x29,0x9a,0x00,0x04,0x00,0x00]
          vpcmpeqq 1024(%rdx){1to2}, %xmm20, %k3

// CHECK: vpcmpeqq -1024(%rdx){1to2}, %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x10,0x29,0x5a,0x80]
          vpcmpeqq -1024(%rdx){1to2}, %xmm20, %k3

// CHECK: vpcmpeqq -1032(%rdx){1to2}, %xmm20, %k3
// CHECK:  encoding: [0x62,0xf2,0xdd,0x10,0x29,0x9a,0xf8,0xfb,0xff,0xff]
          vpcmpeqq -1032(%rdx){1to2}, %xmm20, %k3

// CHECK: vpcmpeqq %ymm23, %ymm30, %k5
// CHECK:  encoding: [0x62,0xb2,0x8d,0x20,0x29,0xef]
          vpcmpeqq %ymm23, %ymm30, %k5

// CHECK: vpcmpeqq %ymm23, %ymm30, %k5 {%k6}
// CHECK:  encoding: [0x62,0xb2,0x8d,0x26,0x29,0xef]
          vpcmpeqq %ymm23, %ymm30, %k5 {%k6}

// CHECK: vpcmpeqq (%rcx), %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x20,0x29,0x29]
          vpcmpeqq (%rcx), %ymm30, %k5

// CHECK: vpcmpeqq 291(%rax,%r14,8), %ymm30, %k5
// CHECK:  encoding: [0x62,0xb2,0x8d,0x20,0x29,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpcmpeqq 291(%rax,%r14,8), %ymm30, %k5

// CHECK: vpcmpeqq (%rcx){1to4}, %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x30,0x29,0x29]
          vpcmpeqq (%rcx){1to4}, %ymm30, %k5

// CHECK: vpcmpeqq 4064(%rdx), %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x20,0x29,0x6a,0x7f]
          vpcmpeqq 4064(%rdx), %ymm30, %k5

// CHECK: vpcmpeqq 4096(%rdx), %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x20,0x29,0xaa,0x00,0x10,0x00,0x00]
          vpcmpeqq 4096(%rdx), %ymm30, %k5

// CHECK: vpcmpeqq -4096(%rdx), %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x20,0x29,0x6a,0x80]
          vpcmpeqq -4096(%rdx), %ymm30, %k5

// CHECK: vpcmpeqq -4128(%rdx), %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x20,0x29,0xaa,0xe0,0xef,0xff,0xff]
          vpcmpeqq -4128(%rdx), %ymm30, %k5

// CHECK: vpcmpeqq 1016(%rdx){1to4}, %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x30,0x29,0x6a,0x7f]
          vpcmpeqq 1016(%rdx){1to4}, %ymm30, %k5

// CHECK: vpcmpeqq 1024(%rdx){1to4}, %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x30,0x29,0xaa,0x00,0x04,0x00,0x00]
          vpcmpeqq 1024(%rdx){1to4}, %ymm30, %k5

// CHECK: vpcmpeqq -1024(%rdx){1to4}, %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x30,0x29,0x6a,0x80]
          vpcmpeqq -1024(%rdx){1to4}, %ymm30, %k5

// CHECK: vpcmpeqq -1032(%rdx){1to4}, %ymm30, %k5
// CHECK:  encoding: [0x62,0xf2,0x8d,0x30,0x29,0xaa,0xf8,0xfb,0xff,0xff]
          vpcmpeqq -1032(%rdx){1to4}, %ymm30, %k5

// CHECK: vpcmpgtd %xmm20, %xmm29, %k4
// CHECK:  encoding: [0x62,0xb1,0x15,0x00,0x66,0xe4]
          vpcmpgtd %xmm20, %xmm29, %k4

// CHECK: vpcmpgtd %xmm20, %xmm29, %k4 {%k2}
// CHECK:  encoding: [0x62,0xb1,0x15,0x02,0x66,0xe4]
          vpcmpgtd %xmm20, %xmm29, %k4 {%k2}

// CHECK: vpcmpgtd (%rcx), %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x66,0x21]
          vpcmpgtd (%rcx), %xmm29, %k4

// CHECK: vpcmpgtd 291(%rax,%r14,8), %xmm29, %k4
// CHECK:  encoding: [0x62,0xb1,0x15,0x00,0x66,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtd 291(%rax,%r14,8), %xmm29, %k4

// CHECK: vpcmpgtd (%rcx){1to4}, %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x66,0x21]
          vpcmpgtd (%rcx){1to4}, %xmm29, %k4

// CHECK: vpcmpgtd 2032(%rdx), %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x66,0x62,0x7f]
          vpcmpgtd 2032(%rdx), %xmm29, %k4

// CHECK: vpcmpgtd 2048(%rdx), %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x66,0xa2,0x00,0x08,0x00,0x00]
          vpcmpgtd 2048(%rdx), %xmm29, %k4

// CHECK: vpcmpgtd -2048(%rdx), %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x66,0x62,0x80]
          vpcmpgtd -2048(%rdx), %xmm29, %k4

// CHECK: vpcmpgtd -2064(%rdx), %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x00,0x66,0xa2,0xf0,0xf7,0xff,0xff]
          vpcmpgtd -2064(%rdx), %xmm29, %k4

// CHECK: vpcmpgtd 508(%rdx){1to4}, %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x66,0x62,0x7f]
          vpcmpgtd 508(%rdx){1to4}, %xmm29, %k4

// CHECK: vpcmpgtd 512(%rdx){1to4}, %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x66,0xa2,0x00,0x02,0x00,0x00]
          vpcmpgtd 512(%rdx){1to4}, %xmm29, %k4

// CHECK: vpcmpgtd -512(%rdx){1to4}, %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x66,0x62,0x80]
          vpcmpgtd -512(%rdx){1to4}, %xmm29, %k4

// CHECK: vpcmpgtd -516(%rdx){1to4}, %xmm29, %k4
// CHECK:  encoding: [0x62,0xf1,0x15,0x10,0x66,0xa2,0xfc,0xfd,0xff,0xff]
          vpcmpgtd -516(%rdx){1to4}, %xmm29, %k4

// CHECK: vpcmpgtd %ymm17, %ymm22, %k2
// CHECK:  encoding: [0x62,0xb1,0x4d,0x20,0x66,0xd1]
          vpcmpgtd %ymm17, %ymm22, %k2

// CHECK: vpcmpgtd %ymm17, %ymm22, %k2 {%k1}
// CHECK:  encoding: [0x62,0xb1,0x4d,0x21,0x66,0xd1]
          vpcmpgtd %ymm17, %ymm22, %k2 {%k1}

// CHECK: vpcmpgtd (%rcx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x20,0x66,0x11]
          vpcmpgtd (%rcx), %ymm22, %k2

// CHECK: vpcmpgtd 291(%rax,%r14,8), %ymm22, %k2
// CHECK:  encoding: [0x62,0xb1,0x4d,0x20,0x66,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtd 291(%rax,%r14,8), %ymm22, %k2

// CHECK: vpcmpgtd (%rcx){1to8}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x30,0x66,0x11]
          vpcmpgtd (%rcx){1to8}, %ymm22, %k2

// CHECK: vpcmpgtd 4064(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x20,0x66,0x52,0x7f]
          vpcmpgtd 4064(%rdx), %ymm22, %k2

// CHECK: vpcmpgtd 4096(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x20,0x66,0x92,0x00,0x10,0x00,0x00]
          vpcmpgtd 4096(%rdx), %ymm22, %k2

// CHECK: vpcmpgtd -4096(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x20,0x66,0x52,0x80]
          vpcmpgtd -4096(%rdx), %ymm22, %k2

// CHECK: vpcmpgtd -4128(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x20,0x66,0x92,0xe0,0xef,0xff,0xff]
          vpcmpgtd -4128(%rdx), %ymm22, %k2

// CHECK: vpcmpgtd 508(%rdx){1to8}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x30,0x66,0x52,0x7f]
          vpcmpgtd 508(%rdx){1to8}, %ymm22, %k2

// CHECK: vpcmpgtd 512(%rdx){1to8}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x30,0x66,0x92,0x00,0x02,0x00,0x00]
          vpcmpgtd 512(%rdx){1to8}, %ymm22, %k2

// CHECK: vpcmpgtd -512(%rdx){1to8}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x30,0x66,0x52,0x80]
          vpcmpgtd -512(%rdx){1to8}, %ymm22, %k2

// CHECK: vpcmpgtd -516(%rdx){1to8}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf1,0x4d,0x30,0x66,0x92,0xfc,0xfd,0xff,0xff]
          vpcmpgtd -516(%rdx){1to8}, %ymm22, %k2

// CHECK: vpcmpgtq %xmm25, %xmm30, %k3
// CHECK:  encoding: [0x62,0x92,0x8d,0x00,0x37,0xd9]
          vpcmpgtq %xmm25, %xmm30, %k3

// CHECK: vpcmpgtq %xmm25, %xmm30, %k3 {%k6}
// CHECK:  encoding: [0x62,0x92,0x8d,0x06,0x37,0xd9]
          vpcmpgtq %xmm25, %xmm30, %k3 {%k6}

// CHECK: vpcmpgtq (%rcx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x00,0x37,0x19]
          vpcmpgtq (%rcx), %xmm30, %k3

// CHECK: vpcmpgtq 291(%rax,%r14,8), %xmm30, %k3
// CHECK:  encoding: [0x62,0xb2,0x8d,0x00,0x37,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtq 291(%rax,%r14,8), %xmm30, %k3

// CHECK: vpcmpgtq (%rcx){1to2}, %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x10,0x37,0x19]
          vpcmpgtq (%rcx){1to2}, %xmm30, %k3

// CHECK: vpcmpgtq 2032(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x00,0x37,0x5a,0x7f]
          vpcmpgtq 2032(%rdx), %xmm30, %k3

// CHECK: vpcmpgtq 2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x00,0x37,0x9a,0x00,0x08,0x00,0x00]
          vpcmpgtq 2048(%rdx), %xmm30, %k3

// CHECK: vpcmpgtq -2048(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x00,0x37,0x5a,0x80]
          vpcmpgtq -2048(%rdx), %xmm30, %k3

// CHECK: vpcmpgtq -2064(%rdx), %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x00,0x37,0x9a,0xf0,0xf7,0xff,0xff]
          vpcmpgtq -2064(%rdx), %xmm30, %k3

// CHECK: vpcmpgtq 1016(%rdx){1to2}, %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x10,0x37,0x5a,0x7f]
          vpcmpgtq 1016(%rdx){1to2}, %xmm30, %k3

// CHECK: vpcmpgtq 1024(%rdx){1to2}, %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x10,0x37,0x9a,0x00,0x04,0x00,0x00]
          vpcmpgtq 1024(%rdx){1to2}, %xmm30, %k3

// CHECK: vpcmpgtq -1024(%rdx){1to2}, %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x10,0x37,0x5a,0x80]
          vpcmpgtq -1024(%rdx){1to2}, %xmm30, %k3

// CHECK: vpcmpgtq -1032(%rdx){1to2}, %xmm30, %k3
// CHECK:  encoding: [0x62,0xf2,0x8d,0x10,0x37,0x9a,0xf8,0xfb,0xff,0xff]
          vpcmpgtq -1032(%rdx){1to2}, %xmm30, %k3

// CHECK: vpcmpgtq %ymm20, %ymm22, %k2
// CHECK:  encoding: [0x62,0xb2,0xcd,0x20,0x37,0xd4]
          vpcmpgtq %ymm20, %ymm22, %k2

// CHECK: vpcmpgtq %ymm20, %ymm22, %k2 {%k1}
// CHECK:  encoding: [0x62,0xb2,0xcd,0x21,0x37,0xd4]
          vpcmpgtq %ymm20, %ymm22, %k2 {%k1}

// CHECK: vpcmpgtq (%rcx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x20,0x37,0x11]
          vpcmpgtq (%rcx), %ymm22, %k2

// CHECK: vpcmpgtq 291(%rax,%r14,8), %ymm22, %k2
// CHECK:  encoding: [0x62,0xb2,0xcd,0x20,0x37,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpcmpgtq 291(%rax,%r14,8), %ymm22, %k2

// CHECK: vpcmpgtq (%rcx){1to4}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x30,0x37,0x11]
          vpcmpgtq (%rcx){1to4}, %ymm22, %k2

// CHECK: vpcmpgtq 4064(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x20,0x37,0x52,0x7f]
          vpcmpgtq 4064(%rdx), %ymm22, %k2

// CHECK: vpcmpgtq 4096(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x20,0x37,0x92,0x00,0x10,0x00,0x00]
          vpcmpgtq 4096(%rdx), %ymm22, %k2

// CHECK: vpcmpgtq -4096(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x20,0x37,0x52,0x80]
          vpcmpgtq -4096(%rdx), %ymm22, %k2

// CHECK: vpcmpgtq -4128(%rdx), %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x20,0x37,0x92,0xe0,0xef,0xff,0xff]
          vpcmpgtq -4128(%rdx), %ymm22, %k2

// CHECK: vpcmpgtq 1016(%rdx){1to4}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x30,0x37,0x52,0x7f]
          vpcmpgtq 1016(%rdx){1to4}, %ymm22, %k2

// CHECK: vpcmpgtq 1024(%rdx){1to4}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x30,0x37,0x92,0x00,0x04,0x00,0x00]
          vpcmpgtq 1024(%rdx){1to4}, %ymm22, %k2

// CHECK: vpcmpgtq -1024(%rdx){1to4}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x30,0x37,0x52,0x80]
          vpcmpgtq -1024(%rdx){1to4}, %ymm22, %k2

// CHECK: vpcmpgtq -1032(%rdx){1to4}, %ymm22, %k2
// CHECK:  encoding: [0x62,0xf2,0xcd,0x30,0x37,0x92,0xf8,0xfb,0xff,0xff]
          vpcmpgtq -1032(%rdx){1to4}, %ymm22, %k2

// CHECK: vpcmpq $171, %xmm24, %xmm27, %k5
// CHECK:  encoding: [0x62,0x93,0xa5,0x00,0x1f,0xe8,0xab]
          vpcmpq $171, %xmm24, %xmm27, %k5

// CHECK: vpcmpq $171, %xmm24, %xmm27, %k5 {%k7}
// CHECK:  encoding: [0x62,0x93,0xa5,0x07,0x1f,0xe8,0xab]
          vpcmpq $171, %xmm24, %xmm27, %k5 {%k7}

// CHECK: vpcmpq $123, %xmm24, %xmm27, %k5
// CHECK:  encoding: [0x62,0x93,0xa5,0x00,0x1f,0xe8,0x7b]
          vpcmpq $123, %xmm24, %xmm27, %k5

// CHECK: vpcmpq $123, (%rcx), %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x1f,0x29,0x7b]
          vpcmpq $123, (%rcx), %xmm27, %k5

// CHECK: vpcmpq $123, 291(%rax,%r14,8), %xmm27, %k5
// CHECK:  encoding: [0x62,0xb3,0xa5,0x00,0x1f,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpq $123, 291(%rax,%r14,8), %xmm27, %k5

// CHECK: vpcmpq $123, (%rcx){1to2}, %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x10,0x1f,0x29,0x7b]
          vpcmpq $123, (%rcx){1to2}, %xmm27, %k5

// CHECK: vpcmpq $123, 2032(%rdx), %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x1f,0x6a,0x7f,0x7b]
          vpcmpq $123, 2032(%rdx), %xmm27, %k5

// CHECK: vpcmpq $123, 2048(%rdx), %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x1f,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vpcmpq $123, 2048(%rdx), %xmm27, %k5

// CHECK: vpcmpq $123, -2048(%rdx), %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x1f,0x6a,0x80,0x7b]
          vpcmpq $123, -2048(%rdx), %xmm27, %k5

// CHECK: vpcmpq $123, -2064(%rdx), %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x00,0x1f,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpq $123, -2064(%rdx), %xmm27, %k5

// CHECK: vpcmpq $123, 1016(%rdx){1to2}, %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x10,0x1f,0x6a,0x7f,0x7b]
          vpcmpq $123, 1016(%rdx){1to2}, %xmm27, %k5

// CHECK: vpcmpq $123, 1024(%rdx){1to2}, %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x10,0x1f,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vpcmpq $123, 1024(%rdx){1to2}, %xmm27, %k5

// CHECK: vpcmpq $123, -1024(%rdx){1to2}, %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x10,0x1f,0x6a,0x80,0x7b]
          vpcmpq $123, -1024(%rdx){1to2}, %xmm27, %k5

// CHECK: vpcmpq $123, -1032(%rdx){1to2}, %xmm27, %k5
// CHECK:  encoding: [0x62,0xf3,0xa5,0x10,0x1f,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpq $123, -1032(%rdx){1to2}, %xmm27, %k5

// CHECK: vpcmpq $171, %ymm19, %ymm26, %k4
// CHECK:  encoding: [0x62,0xb3,0xad,0x20,0x1f,0xe3,0xab]
          vpcmpq $171, %ymm19, %ymm26, %k4

// CHECK: vpcmpq $171, %ymm19, %ymm26, %k4 {%k6}
// CHECK:  encoding: [0x62,0xb3,0xad,0x26,0x1f,0xe3,0xab]
          vpcmpq $171, %ymm19, %ymm26, %k4 {%k6}

// CHECK: vpcmpq $123, %ymm19, %ymm26, %k4
// CHECK:  encoding: [0x62,0xb3,0xad,0x20,0x1f,0xe3,0x7b]
          vpcmpq $123, %ymm19, %ymm26, %k4

// CHECK: vpcmpq $123, (%rcx), %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x1f,0x21,0x7b]
          vpcmpq $123, (%rcx), %ymm26, %k4

// CHECK: vpcmpq $123, 291(%rax,%r14,8), %ymm26, %k4
// CHECK:  encoding: [0x62,0xb3,0xad,0x20,0x1f,0xa4,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpq $123, 291(%rax,%r14,8), %ymm26, %k4

// CHECK: vpcmpq $123, (%rcx){1to4}, %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x30,0x1f,0x21,0x7b]
          vpcmpq $123, (%rcx){1to4}, %ymm26, %k4

// CHECK: vpcmpq $123, 4064(%rdx), %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x1f,0x62,0x7f,0x7b]
          vpcmpq $123, 4064(%rdx), %ymm26, %k4

// CHECK: vpcmpq $123, 4096(%rdx), %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x1f,0xa2,0x00,0x10,0x00,0x00,0x7b]
          vpcmpq $123, 4096(%rdx), %ymm26, %k4

// CHECK: vpcmpq $123, -4096(%rdx), %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x1f,0x62,0x80,0x7b]
          vpcmpq $123, -4096(%rdx), %ymm26, %k4

// CHECK: vpcmpq $123, -4128(%rdx), %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x20,0x1f,0xa2,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpq $123, -4128(%rdx), %ymm26, %k4

// CHECK: vpcmpq $123, 1016(%rdx){1to4}, %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x30,0x1f,0x62,0x7f,0x7b]
          vpcmpq $123, 1016(%rdx){1to4}, %ymm26, %k4

// CHECK: vpcmpq $123, 1024(%rdx){1to4}, %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x30,0x1f,0xa2,0x00,0x04,0x00,0x00,0x7b]
          vpcmpq $123, 1024(%rdx){1to4}, %ymm26, %k4

// CHECK: vpcmpq $123, -1024(%rdx){1to4}, %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x30,0x1f,0x62,0x80,0x7b]
          vpcmpq $123, -1024(%rdx){1to4}, %ymm26, %k4

// CHECK: vpcmpq $123, -1032(%rdx){1to4}, %ymm26, %k4
// CHECK:  encoding: [0x62,0xf3,0xad,0x30,0x1f,0xa2,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpq $123, -1032(%rdx){1to4}, %ymm26, %k4

// CHECK: vpcmpud $171, %xmm21, %xmm22, %k3
// CHECK:  encoding: [0x62,0xb3,0x4d,0x00,0x1e,0xdd,0xab]
          vpcmpud $171, %xmm21, %xmm22, %k3

// CHECK: vpcmpud $171, %xmm21, %xmm22, %k3 {%k1}
// CHECK:  encoding: [0x62,0xb3,0x4d,0x01,0x1e,0xdd,0xab]
          vpcmpud $171, %xmm21, %xmm22, %k3 {%k1}

// CHECK: vpcmpud $123, %xmm21, %xmm22, %k3
// CHECK:  encoding: [0x62,0xb3,0x4d,0x00,0x1e,0xdd,0x7b]
          vpcmpud $123, %xmm21, %xmm22, %k3

// CHECK: vpcmpud $123, (%rcx), %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x1e,0x19,0x7b]
          vpcmpud $123, (%rcx), %xmm22, %k3

// CHECK: vpcmpud $123, 291(%rax,%r14,8), %xmm22, %k3
// CHECK:  encoding: [0x62,0xb3,0x4d,0x00,0x1e,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpud $123, 291(%rax,%r14,8), %xmm22, %k3

// CHECK: vpcmpud $123, (%rcx){1to4}, %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x10,0x1e,0x19,0x7b]
          vpcmpud $123, (%rcx){1to4}, %xmm22, %k3

// CHECK: vpcmpud $123, 2032(%rdx), %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x1e,0x5a,0x7f,0x7b]
          vpcmpud $123, 2032(%rdx), %xmm22, %k3

// CHECK: vpcmpud $123, 2048(%rdx), %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x1e,0x9a,0x00,0x08,0x00,0x00,0x7b]
          vpcmpud $123, 2048(%rdx), %xmm22, %k3

// CHECK: vpcmpud $123, -2048(%rdx), %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x1e,0x5a,0x80,0x7b]
          vpcmpud $123, -2048(%rdx), %xmm22, %k3

// CHECK: vpcmpud $123, -2064(%rdx), %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x00,0x1e,0x9a,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpud $123, -2064(%rdx), %xmm22, %k3

// CHECK: vpcmpud $123, 508(%rdx){1to4}, %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x10,0x1e,0x5a,0x7f,0x7b]
          vpcmpud $123, 508(%rdx){1to4}, %xmm22, %k3

// CHECK: vpcmpud $123, 512(%rdx){1to4}, %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x10,0x1e,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vpcmpud $123, 512(%rdx){1to4}, %xmm22, %k3

// CHECK: vpcmpud $123, -512(%rdx){1to4}, %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x10,0x1e,0x5a,0x80,0x7b]
          vpcmpud $123, -512(%rdx){1to4}, %xmm22, %k3

// CHECK: vpcmpud $123, -516(%rdx){1to4}, %xmm22, %k3
// CHECK:  encoding: [0x62,0xf3,0x4d,0x10,0x1e,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpud $123, -516(%rdx){1to4}, %xmm22, %k3

// CHECK: vpcmpud $171, %ymm20, %ymm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x0d,0x20,0x1e,0xdc,0xab]
          vpcmpud $171, %ymm20, %ymm30, %k3

// CHECK: vpcmpud $171, %ymm20, %ymm30, %k3 {%k6}
// CHECK:  encoding: [0x62,0xb3,0x0d,0x26,0x1e,0xdc,0xab]
          vpcmpud $171, %ymm20, %ymm30, %k3 {%k6}

// CHECK: vpcmpud $123, %ymm20, %ymm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x0d,0x20,0x1e,0xdc,0x7b]
          vpcmpud $123, %ymm20, %ymm30, %k3

// CHECK: vpcmpud $123, (%rcx), %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x20,0x1e,0x19,0x7b]
          vpcmpud $123, (%rcx), %ymm30, %k3

// CHECK: vpcmpud $123, 291(%rax,%r14,8), %ymm30, %k3
// CHECK:  encoding: [0x62,0xb3,0x0d,0x20,0x1e,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpud $123, 291(%rax,%r14,8), %ymm30, %k3

// CHECK: vpcmpud $123, (%rcx){1to8}, %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x30,0x1e,0x19,0x7b]
          vpcmpud $123, (%rcx){1to8}, %ymm30, %k3

// CHECK: vpcmpud $123, 4064(%rdx), %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x20,0x1e,0x5a,0x7f,0x7b]
          vpcmpud $123, 4064(%rdx), %ymm30, %k3

// CHECK: vpcmpud $123, 4096(%rdx), %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x20,0x1e,0x9a,0x00,0x10,0x00,0x00,0x7b]
          vpcmpud $123, 4096(%rdx), %ymm30, %k3

// CHECK: vpcmpud $123, -4096(%rdx), %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x20,0x1e,0x5a,0x80,0x7b]
          vpcmpud $123, -4096(%rdx), %ymm30, %k3

// CHECK: vpcmpud $123, -4128(%rdx), %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x20,0x1e,0x9a,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpud $123, -4128(%rdx), %ymm30, %k3

// CHECK: vpcmpud $123, 508(%rdx){1to8}, %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x30,0x1e,0x5a,0x7f,0x7b]
          vpcmpud $123, 508(%rdx){1to8}, %ymm30, %k3

// CHECK: vpcmpud $123, 512(%rdx){1to8}, %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x30,0x1e,0x9a,0x00,0x02,0x00,0x00,0x7b]
          vpcmpud $123, 512(%rdx){1to8}, %ymm30, %k3

// CHECK: vpcmpud $123, -512(%rdx){1to8}, %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x30,0x1e,0x5a,0x80,0x7b]
          vpcmpud $123, -512(%rdx){1to8}, %ymm30, %k3

// CHECK: vpcmpud $123, -516(%rdx){1to8}, %ymm30, %k3
// CHECK:  encoding: [0x62,0xf3,0x0d,0x30,0x1e,0x9a,0xfc,0xfd,0xff,0xff,0x7b]
          vpcmpud $123, -516(%rdx){1to8}, %ymm30, %k3

// CHECK: vpcmpuq $171, %xmm28, %xmm28, %k5
// CHECK:  encoding: [0x62,0x93,0x9d,0x00,0x1e,0xec,0xab]
          vpcmpuq $171, %xmm28, %xmm28, %k5

// CHECK: vpcmpuq $171, %xmm28, %xmm28, %k5 {%k4}
// CHECK:  encoding: [0x62,0x93,0x9d,0x04,0x1e,0xec,0xab]
          vpcmpuq $171, %xmm28, %xmm28, %k5 {%k4}

// CHECK: vpcmpuq $123, %xmm28, %xmm28, %k5
// CHECK:  encoding: [0x62,0x93,0x9d,0x00,0x1e,0xec,0x7b]
          vpcmpuq $123, %xmm28, %xmm28, %k5

// CHECK: vpcmpuq $123, (%rcx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x1e,0x29,0x7b]
          vpcmpuq $123, (%rcx), %xmm28, %k5

// CHECK: vpcmpuq $123, 291(%rax,%r14,8), %xmm28, %k5
// CHECK:  encoding: [0x62,0xb3,0x9d,0x00,0x1e,0xac,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpuq $123, 291(%rax,%r14,8), %xmm28, %k5

// CHECK: vpcmpuq $123, (%rcx){1to2}, %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x10,0x1e,0x29,0x7b]
          vpcmpuq $123, (%rcx){1to2}, %xmm28, %k5

// CHECK: vpcmpuq $123, 2032(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x1e,0x6a,0x7f,0x7b]
          vpcmpuq $123, 2032(%rdx), %xmm28, %k5

// CHECK: vpcmpuq $123, 2048(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x1e,0xaa,0x00,0x08,0x00,0x00,0x7b]
          vpcmpuq $123, 2048(%rdx), %xmm28, %k5

// CHECK: vpcmpuq $123, -2048(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x1e,0x6a,0x80,0x7b]
          vpcmpuq $123, -2048(%rdx), %xmm28, %k5

// CHECK: vpcmpuq $123, -2064(%rdx), %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x00,0x1e,0xaa,0xf0,0xf7,0xff,0xff,0x7b]
          vpcmpuq $123, -2064(%rdx), %xmm28, %k5

// CHECK: vpcmpuq $123, 1016(%rdx){1to2}, %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x10,0x1e,0x6a,0x7f,0x7b]
          vpcmpuq $123, 1016(%rdx){1to2}, %xmm28, %k5

// CHECK: vpcmpuq $123, 1024(%rdx){1to2}, %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x10,0x1e,0xaa,0x00,0x04,0x00,0x00,0x7b]
          vpcmpuq $123, 1024(%rdx){1to2}, %xmm28, %k5

// CHECK: vpcmpuq $123, -1024(%rdx){1to2}, %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x10,0x1e,0x6a,0x80,0x7b]
          vpcmpuq $123, -1024(%rdx){1to2}, %xmm28, %k5

// CHECK: vpcmpuq $123, -1032(%rdx){1to2}, %xmm28, %k5
// CHECK:  encoding: [0x62,0xf3,0x9d,0x10,0x1e,0xaa,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpuq $123, -1032(%rdx){1to2}, %xmm28, %k5

// CHECK: vpcmpuq $171, %ymm26, %ymm22, %k3
// CHECK:  encoding: [0x62,0x93,0xcd,0x20,0x1e,0xda,0xab]
          vpcmpuq $171, %ymm26, %ymm22, %k3

// CHECK: vpcmpuq $171, %ymm26, %ymm22, %k3 {%k3}
// CHECK:  encoding: [0x62,0x93,0xcd,0x23,0x1e,0xda,0xab]
          vpcmpuq $171, %ymm26, %ymm22, %k3 {%k3}

// CHECK: vpcmpuq $123, %ymm26, %ymm22, %k3
// CHECK:  encoding: [0x62,0x93,0xcd,0x20,0x1e,0xda,0x7b]
          vpcmpuq $123, %ymm26, %ymm22, %k3

// CHECK: vpcmpuq $123, (%rcx), %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x20,0x1e,0x19,0x7b]
          vpcmpuq $123, (%rcx), %ymm22, %k3

// CHECK: vpcmpuq $123, 291(%rax,%r14,8), %ymm22, %k3
// CHECK:  encoding: [0x62,0xb3,0xcd,0x20,0x1e,0x9c,0xf0,0x23,0x01,0x00,0x00,0x7b]
          vpcmpuq $123, 291(%rax,%r14,8), %ymm22, %k3

// CHECK: vpcmpuq $123, (%rcx){1to4}, %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x30,0x1e,0x19,0x7b]
          vpcmpuq $123, (%rcx){1to4}, %ymm22, %k3

// CHECK: vpcmpuq $123, 4064(%rdx), %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x20,0x1e,0x5a,0x7f,0x7b]
          vpcmpuq $123, 4064(%rdx), %ymm22, %k3

// CHECK: vpcmpuq $123, 4096(%rdx), %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x20,0x1e,0x9a,0x00,0x10,0x00,0x00,0x7b]
          vpcmpuq $123, 4096(%rdx), %ymm22, %k3

// CHECK: vpcmpuq $123, -4096(%rdx), %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x20,0x1e,0x5a,0x80,0x7b]
          vpcmpuq $123, -4096(%rdx), %ymm22, %k3

// CHECK: vpcmpuq $123, -4128(%rdx), %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x20,0x1e,0x9a,0xe0,0xef,0xff,0xff,0x7b]
          vpcmpuq $123, -4128(%rdx), %ymm22, %k3

// CHECK: vpcmpuq $123, 1016(%rdx){1to4}, %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x30,0x1e,0x5a,0x7f,0x7b]
          vpcmpuq $123, 1016(%rdx){1to4}, %ymm22, %k3

// CHECK: vpcmpuq $123, 1024(%rdx){1to4}, %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x30,0x1e,0x9a,0x00,0x04,0x00,0x00,0x7b]
          vpcmpuq $123, 1024(%rdx){1to4}, %ymm22, %k3

// CHECK: vpcmpuq $123, -1024(%rdx){1to4}, %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x30,0x1e,0x5a,0x80,0x7b]
          vpcmpuq $123, -1024(%rdx){1to4}, %ymm22, %k3

// CHECK: vpcmpuq $123, -1032(%rdx){1to4}, %ymm22, %k3
// CHECK:  encoding: [0x62,0xf3,0xcd,0x30,0x1e,0x9a,0xf8,0xfb,0xff,0xff,0x7b]
          vpcmpuq $123, -1032(%rdx){1to4}, %ymm22, %k3

// CHECK: vpmaxsd %xmm26, %xmm22, %xmm19
// CHECK:  encoding: [0x62,0x82,0x4d,0x00,0x3d,0xda]
          vpmaxsd %xmm26, %xmm22, %xmm19

// CHECK: vpmaxsd %xmm26, %xmm22, %xmm19 {%k2}
// CHECK:  encoding: [0x62,0x82,0x4d,0x02,0x3d,0xda]
          vpmaxsd %xmm26, %xmm22, %xmm19 {%k2}

// CHECK: vpmaxsd %xmm26, %xmm22, %xmm19 {%k2} {z}
// CHECK:  encoding: [0x62,0x82,0x4d,0x82,0x3d,0xda]
          vpmaxsd %xmm26, %xmm22, %xmm19 {%k2} {z}

// CHECK: vpmaxsd (%rcx), %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x3d,0x19]
          vpmaxsd (%rcx), %xmm22, %xmm19

// CHECK: vpmaxsd 291(%rax,%r14,8), %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xa2,0x4d,0x00,0x3d,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsd 291(%rax,%r14,8), %xmm22, %xmm19

// CHECK: vpmaxsd (%rcx){1to4}, %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x10,0x3d,0x19]
          vpmaxsd (%rcx){1to4}, %xmm22, %xmm19

// CHECK: vpmaxsd 2032(%rdx), %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x3d,0x5a,0x7f]
          vpmaxsd 2032(%rdx), %xmm22, %xmm19

// CHECK: vpmaxsd 2048(%rdx), %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x3d,0x9a,0x00,0x08,0x00,0x00]
          vpmaxsd 2048(%rdx), %xmm22, %xmm19

// CHECK: vpmaxsd -2048(%rdx), %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x3d,0x5a,0x80]
          vpmaxsd -2048(%rdx), %xmm22, %xmm19

// CHECK: vpmaxsd -2064(%rdx), %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x00,0x3d,0x9a,0xf0,0xf7,0xff,0xff]
          vpmaxsd -2064(%rdx), %xmm22, %xmm19

// CHECK: vpmaxsd 508(%rdx){1to4}, %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x10,0x3d,0x5a,0x7f]
          vpmaxsd 508(%rdx){1to4}, %xmm22, %xmm19

// CHECK: vpmaxsd 512(%rdx){1to4}, %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x10,0x3d,0x9a,0x00,0x02,0x00,0x00]
          vpmaxsd 512(%rdx){1to4}, %xmm22, %xmm19

// CHECK: vpmaxsd -512(%rdx){1to4}, %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x10,0x3d,0x5a,0x80]
          vpmaxsd -512(%rdx){1to4}, %xmm22, %xmm19

// CHECK: vpmaxsd -516(%rdx){1to4}, %xmm22, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x10,0x3d,0x9a,0xfc,0xfd,0xff,0xff]
          vpmaxsd -516(%rdx){1to4}, %xmm22, %xmm19

// CHECK: vpmaxsd %ymm23, %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x22,0x3d,0x20,0x3d,0xdf]
          vpmaxsd %ymm23, %ymm24, %ymm27

// CHECK: vpmaxsd %ymm23, %ymm24, %ymm27 {%k6}
// CHECK:  encoding: [0x62,0x22,0x3d,0x26,0x3d,0xdf]
          vpmaxsd %ymm23, %ymm24, %ymm27 {%k6}

// CHECK: vpmaxsd %ymm23, %ymm24, %ymm27 {%k6} {z}
// CHECK:  encoding: [0x62,0x22,0x3d,0xa6,0x3d,0xdf]
          vpmaxsd %ymm23, %ymm24, %ymm27 {%k6} {z}

// CHECK: vpmaxsd (%rcx), %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x20,0x3d,0x19]
          vpmaxsd (%rcx), %ymm24, %ymm27

// CHECK: vpmaxsd 291(%rax,%r14,8), %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x22,0x3d,0x20,0x3d,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsd 291(%rax,%r14,8), %ymm24, %ymm27

// CHECK: vpmaxsd (%rcx){1to8}, %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x30,0x3d,0x19]
          vpmaxsd (%rcx){1to8}, %ymm24, %ymm27

// CHECK: vpmaxsd 4064(%rdx), %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x20,0x3d,0x5a,0x7f]
          vpmaxsd 4064(%rdx), %ymm24, %ymm27

// CHECK: vpmaxsd 4096(%rdx), %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x20,0x3d,0x9a,0x00,0x10,0x00,0x00]
          vpmaxsd 4096(%rdx), %ymm24, %ymm27

// CHECK: vpmaxsd -4096(%rdx), %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x20,0x3d,0x5a,0x80]
          vpmaxsd -4096(%rdx), %ymm24, %ymm27

// CHECK: vpmaxsd -4128(%rdx), %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x20,0x3d,0x9a,0xe0,0xef,0xff,0xff]
          vpmaxsd -4128(%rdx), %ymm24, %ymm27

// CHECK: vpmaxsd 508(%rdx){1to8}, %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x30,0x3d,0x5a,0x7f]
          vpmaxsd 508(%rdx){1to8}, %ymm24, %ymm27

// CHECK: vpmaxsd 512(%rdx){1to8}, %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x30,0x3d,0x9a,0x00,0x02,0x00,0x00]
          vpmaxsd 512(%rdx){1to8}, %ymm24, %ymm27

// CHECK: vpmaxsd -512(%rdx){1to8}, %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x30,0x3d,0x5a,0x80]
          vpmaxsd -512(%rdx){1to8}, %ymm24, %ymm27

// CHECK: vpmaxsd -516(%rdx){1to8}, %ymm24, %ymm27
// CHECK:  encoding: [0x62,0x62,0x3d,0x30,0x3d,0x9a,0xfc,0xfd,0xff,0xff]
          vpmaxsd -516(%rdx){1to8}, %ymm24, %ymm27

// CHECK: vpmaxsq %xmm25, %xmm23, %xmm23
// CHECK:  encoding: [0x62,0x82,0xc5,0x00,0x3d,0xf9]
          vpmaxsq %xmm25, %xmm23, %xmm23

// CHECK: vpmaxsq %xmm25, %xmm23, %xmm23 {%k2}
// CHECK:  encoding: [0x62,0x82,0xc5,0x02,0x3d,0xf9]
          vpmaxsq %xmm25, %xmm23, %xmm23 {%k2}

// CHECK: vpmaxsq %xmm25, %xmm23, %xmm23 {%k2} {z}
// CHECK:  encoding: [0x62,0x82,0xc5,0x82,0x3d,0xf9]
          vpmaxsq %xmm25, %xmm23, %xmm23 {%k2} {z}

// CHECK: vpmaxsq (%rcx), %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x00,0x3d,0x39]
          vpmaxsq (%rcx), %xmm23, %xmm23

// CHECK: vpmaxsq 291(%rax,%r14,8), %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xa2,0xc5,0x00,0x3d,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsq 291(%rax,%r14,8), %xmm23, %xmm23

// CHECK: vpmaxsq (%rcx){1to2}, %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x10,0x3d,0x39]
          vpmaxsq (%rcx){1to2}, %xmm23, %xmm23

// CHECK: vpmaxsq 2032(%rdx), %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x00,0x3d,0x7a,0x7f]
          vpmaxsq 2032(%rdx), %xmm23, %xmm23

// CHECK: vpmaxsq 2048(%rdx), %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x00,0x3d,0xba,0x00,0x08,0x00,0x00]
          vpmaxsq 2048(%rdx), %xmm23, %xmm23

// CHECK: vpmaxsq -2048(%rdx), %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x00,0x3d,0x7a,0x80]
          vpmaxsq -2048(%rdx), %xmm23, %xmm23

// CHECK: vpmaxsq -2064(%rdx), %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x00,0x3d,0xba,0xf0,0xf7,0xff,0xff]
          vpmaxsq -2064(%rdx), %xmm23, %xmm23

// CHECK: vpmaxsq 1016(%rdx){1to2}, %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x10,0x3d,0x7a,0x7f]
          vpmaxsq 1016(%rdx){1to2}, %xmm23, %xmm23

// CHECK: vpmaxsq 1024(%rdx){1to2}, %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x10,0x3d,0xba,0x00,0x04,0x00,0x00]
          vpmaxsq 1024(%rdx){1to2}, %xmm23, %xmm23

// CHECK: vpmaxsq -1024(%rdx){1to2}, %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x10,0x3d,0x7a,0x80]
          vpmaxsq -1024(%rdx){1to2}, %xmm23, %xmm23

// CHECK: vpmaxsq -1032(%rdx){1to2}, %xmm23, %xmm23
// CHECK:  encoding: [0x62,0xe2,0xc5,0x10,0x3d,0xba,0xf8,0xfb,0xff,0xff]
          vpmaxsq -1032(%rdx){1to2}, %xmm23, %xmm23

// CHECK: vpmaxsq %ymm25, %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x02,0xdd,0x20,0x3d,0xf1]
          vpmaxsq %ymm25, %ymm20, %ymm30

// CHECK: vpmaxsq %ymm25, %ymm20, %ymm30 {%k6}
// CHECK:  encoding: [0x62,0x02,0xdd,0x26,0x3d,0xf1]
          vpmaxsq %ymm25, %ymm20, %ymm30 {%k6}

// CHECK: vpmaxsq %ymm25, %ymm20, %ymm30 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0xdd,0xa6,0x3d,0xf1]
          vpmaxsq %ymm25, %ymm20, %ymm30 {%k6} {z}

// CHECK: vpmaxsq (%rcx), %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x20,0x3d,0x31]
          vpmaxsq (%rcx), %ymm20, %ymm30

// CHECK: vpmaxsq 291(%rax,%r14,8), %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x22,0xdd,0x20,0x3d,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxsq 291(%rax,%r14,8), %ymm20, %ymm30

// CHECK: vpmaxsq (%rcx){1to4}, %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x30,0x3d,0x31]
          vpmaxsq (%rcx){1to4}, %ymm20, %ymm30

// CHECK: vpmaxsq 4064(%rdx), %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x20,0x3d,0x72,0x7f]
          vpmaxsq 4064(%rdx), %ymm20, %ymm30

// CHECK: vpmaxsq 4096(%rdx), %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x20,0x3d,0xb2,0x00,0x10,0x00,0x00]
          vpmaxsq 4096(%rdx), %ymm20, %ymm30

// CHECK: vpmaxsq -4096(%rdx), %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x20,0x3d,0x72,0x80]
          vpmaxsq -4096(%rdx), %ymm20, %ymm30

// CHECK: vpmaxsq -4128(%rdx), %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x20,0x3d,0xb2,0xe0,0xef,0xff,0xff]
          vpmaxsq -4128(%rdx), %ymm20, %ymm30

// CHECK: vpmaxsq 1016(%rdx){1to4}, %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x30,0x3d,0x72,0x7f]
          vpmaxsq 1016(%rdx){1to4}, %ymm20, %ymm30

// CHECK: vpmaxsq 1024(%rdx){1to4}, %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x30,0x3d,0xb2,0x00,0x04,0x00,0x00]
          vpmaxsq 1024(%rdx){1to4}, %ymm20, %ymm30

// CHECK: vpmaxsq -1024(%rdx){1to4}, %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x30,0x3d,0x72,0x80]
          vpmaxsq -1024(%rdx){1to4}, %ymm20, %ymm30

// CHECK: vpmaxsq -1032(%rdx){1to4}, %ymm20, %ymm30
// CHECK:  encoding: [0x62,0x62,0xdd,0x30,0x3d,0xb2,0xf8,0xfb,0xff,0xff]
          vpmaxsq -1032(%rdx){1to4}, %ymm20, %ymm30

// CHECK: vpmaxud %xmm19, %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xa2,0x75,0x00,0x3f,0xeb]
          vpmaxud %xmm19, %xmm17, %xmm21

// CHECK: vpmaxud %xmm19, %xmm17, %xmm21 {%k7}
// CHECK:  encoding: [0x62,0xa2,0x75,0x07,0x3f,0xeb]
          vpmaxud %xmm19, %xmm17, %xmm21 {%k7}

// CHECK: vpmaxud %xmm19, %xmm17, %xmm21 {%k7} {z}
// CHECK:  encoding: [0x62,0xa2,0x75,0x87,0x3f,0xeb]
          vpmaxud %xmm19, %xmm17, %xmm21 {%k7} {z}

// CHECK: vpmaxud (%rcx), %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x00,0x3f,0x29]
          vpmaxud (%rcx), %xmm17, %xmm21

// CHECK: vpmaxud 291(%rax,%r14,8), %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xa2,0x75,0x00,0x3f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpmaxud 291(%rax,%r14,8), %xmm17, %xmm21

// CHECK: vpmaxud (%rcx){1to4}, %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x10,0x3f,0x29]
          vpmaxud (%rcx){1to4}, %xmm17, %xmm21

// CHECK: vpmaxud 2032(%rdx), %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x00,0x3f,0x6a,0x7f]
          vpmaxud 2032(%rdx), %xmm17, %xmm21

// CHECK: vpmaxud 2048(%rdx), %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x00,0x3f,0xaa,0x00,0x08,0x00,0x00]
          vpmaxud 2048(%rdx), %xmm17, %xmm21

// CHECK: vpmaxud -2048(%rdx), %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x00,0x3f,0x6a,0x80]
          vpmaxud -2048(%rdx), %xmm17, %xmm21

// CHECK: vpmaxud -2064(%rdx), %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x00,0x3f,0xaa,0xf0,0xf7,0xff,0xff]
          vpmaxud -2064(%rdx), %xmm17, %xmm21

// CHECK: vpmaxud 508(%rdx){1to4}, %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x10,0x3f,0x6a,0x7f]
          vpmaxud 508(%rdx){1to4}, %xmm17, %xmm21

// CHECK: vpmaxud 512(%rdx){1to4}, %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x10,0x3f,0xaa,0x00,0x02,0x00,0x00]
          vpmaxud 512(%rdx){1to4}, %xmm17, %xmm21

// CHECK: vpmaxud -512(%rdx){1to4}, %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x10,0x3f,0x6a,0x80]
          vpmaxud -512(%rdx){1to4}, %xmm17, %xmm21

// CHECK: vpmaxud -516(%rdx){1to4}, %xmm17, %xmm21
// CHECK:  encoding: [0x62,0xe2,0x75,0x10,0x3f,0xaa,0xfc,0xfd,0xff,0xff]
          vpmaxud -516(%rdx){1to4}, %xmm17, %xmm21

// CHECK: vpmaxud %ymm23, %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x22,0x45,0x20,0x3f,0xe7]
          vpmaxud %ymm23, %ymm23, %ymm28

// CHECK: vpmaxud %ymm23, %ymm23, %ymm28 {%k7}
// CHECK:  encoding: [0x62,0x22,0x45,0x27,0x3f,0xe7]
          vpmaxud %ymm23, %ymm23, %ymm28 {%k7}

// CHECK: vpmaxud %ymm23, %ymm23, %ymm28 {%k7} {z}
// CHECK:  encoding: [0x62,0x22,0x45,0xa7,0x3f,0xe7]
          vpmaxud %ymm23, %ymm23, %ymm28 {%k7} {z}

// CHECK: vpmaxud (%rcx), %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x20,0x3f,0x21]
          vpmaxud (%rcx), %ymm23, %ymm28

// CHECK: vpmaxud 291(%rax,%r14,8), %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x22,0x45,0x20,0x3f,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxud 291(%rax,%r14,8), %ymm23, %ymm28

// CHECK: vpmaxud (%rcx){1to8}, %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x30,0x3f,0x21]
          vpmaxud (%rcx){1to8}, %ymm23, %ymm28

// CHECK: vpmaxud 4064(%rdx), %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x20,0x3f,0x62,0x7f]
          vpmaxud 4064(%rdx), %ymm23, %ymm28

// CHECK: vpmaxud 4096(%rdx), %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x20,0x3f,0xa2,0x00,0x10,0x00,0x00]
          vpmaxud 4096(%rdx), %ymm23, %ymm28

// CHECK: vpmaxud -4096(%rdx), %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x20,0x3f,0x62,0x80]
          vpmaxud -4096(%rdx), %ymm23, %ymm28

// CHECK: vpmaxud -4128(%rdx), %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x20,0x3f,0xa2,0xe0,0xef,0xff,0xff]
          vpmaxud -4128(%rdx), %ymm23, %ymm28

// CHECK: vpmaxud 508(%rdx){1to8}, %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x30,0x3f,0x62,0x7f]
          vpmaxud 508(%rdx){1to8}, %ymm23, %ymm28

// CHECK: vpmaxud 512(%rdx){1to8}, %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x30,0x3f,0xa2,0x00,0x02,0x00,0x00]
          vpmaxud 512(%rdx){1to8}, %ymm23, %ymm28

// CHECK: vpmaxud -512(%rdx){1to8}, %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x30,0x3f,0x62,0x80]
          vpmaxud -512(%rdx){1to8}, %ymm23, %ymm28

// CHECK: vpmaxud -516(%rdx){1to8}, %ymm23, %ymm28
// CHECK:  encoding: [0x62,0x62,0x45,0x30,0x3f,0xa2,0xfc,0xfd,0xff,0xff]
          vpmaxud -516(%rdx){1to8}, %ymm23, %ymm28

// CHECK: vpmaxuq %xmm25, %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x02,0xad,0x00,0x3f,0xd1]
          vpmaxuq %xmm25, %xmm26, %xmm26

// CHECK: vpmaxuq %xmm25, %xmm26, %xmm26 {%k7}
// CHECK:  encoding: [0x62,0x02,0xad,0x07,0x3f,0xd1]
          vpmaxuq %xmm25, %xmm26, %xmm26 {%k7}

// CHECK: vpmaxuq %xmm25, %xmm26, %xmm26 {%k7} {z}
// CHECK:  encoding: [0x62,0x02,0xad,0x87,0x3f,0xd1]
          vpmaxuq %xmm25, %xmm26, %xmm26 {%k7} {z}

// CHECK: vpmaxuq (%rcx), %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0x3f,0x11]
          vpmaxuq (%rcx), %xmm26, %xmm26

// CHECK: vpmaxuq 291(%rax,%r14,8), %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x22,0xad,0x00,0x3f,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpmaxuq 291(%rax,%r14,8), %xmm26, %xmm26

// CHECK: vpmaxuq (%rcx){1to2}, %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x10,0x3f,0x11]
          vpmaxuq (%rcx){1to2}, %xmm26, %xmm26

// CHECK: vpmaxuq 2032(%rdx), %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0x3f,0x52,0x7f]
          vpmaxuq 2032(%rdx), %xmm26, %xmm26

// CHECK: vpmaxuq 2048(%rdx), %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0x3f,0x92,0x00,0x08,0x00,0x00]
          vpmaxuq 2048(%rdx), %xmm26, %xmm26

// CHECK: vpmaxuq -2048(%rdx), %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0x3f,0x52,0x80]
          vpmaxuq -2048(%rdx), %xmm26, %xmm26

// CHECK: vpmaxuq -2064(%rdx), %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x00,0x3f,0x92,0xf0,0xf7,0xff,0xff]
          vpmaxuq -2064(%rdx), %xmm26, %xmm26

// CHECK: vpmaxuq 1016(%rdx){1to2}, %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x10,0x3f,0x52,0x7f]
          vpmaxuq 1016(%rdx){1to2}, %xmm26, %xmm26

// CHECK: vpmaxuq 1024(%rdx){1to2}, %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x10,0x3f,0x92,0x00,0x04,0x00,0x00]
          vpmaxuq 1024(%rdx){1to2}, %xmm26, %xmm26

// CHECK: vpmaxuq -1024(%rdx){1to2}, %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x10,0x3f,0x52,0x80]
          vpmaxuq -1024(%rdx){1to2}, %xmm26, %xmm26

// CHECK: vpmaxuq -1032(%rdx){1to2}, %xmm26, %xmm26
// CHECK:  encoding: [0x62,0x62,0xad,0x10,0x3f,0x92,0xf8,0xfb,0xff,0xff]
          vpmaxuq -1032(%rdx){1to2}, %xmm26, %xmm26

// CHECK: vpmaxuq %ymm20, %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x22,0xf5,0x20,0x3f,0xf4]
          vpmaxuq %ymm20, %ymm17, %ymm30

// CHECK: vpmaxuq %ymm20, %ymm17, %ymm30 {%k4}
// CHECK:  encoding: [0x62,0x22,0xf5,0x24,0x3f,0xf4]
          vpmaxuq %ymm20, %ymm17, %ymm30 {%k4}

// CHECK: vpmaxuq %ymm20, %ymm17, %ymm30 {%k4} {z}
// CHECK:  encoding: [0x62,0x22,0xf5,0xa4,0x3f,0xf4]
          vpmaxuq %ymm20, %ymm17, %ymm30 {%k4} {z}

// CHECK: vpmaxuq (%rcx), %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x20,0x3f,0x31]
          vpmaxuq (%rcx), %ymm17, %ymm30

// CHECK: vpmaxuq 291(%rax,%r14,8), %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x22,0xf5,0x20,0x3f,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpmaxuq 291(%rax,%r14,8), %ymm17, %ymm30

// CHECK: vpmaxuq (%rcx){1to4}, %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x30,0x3f,0x31]
          vpmaxuq (%rcx){1to4}, %ymm17, %ymm30

// CHECK: vpmaxuq 4064(%rdx), %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x20,0x3f,0x72,0x7f]
          vpmaxuq 4064(%rdx), %ymm17, %ymm30

// CHECK: vpmaxuq 4096(%rdx), %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x20,0x3f,0xb2,0x00,0x10,0x00,0x00]
          vpmaxuq 4096(%rdx), %ymm17, %ymm30

// CHECK: vpmaxuq -4096(%rdx), %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x20,0x3f,0x72,0x80]
          vpmaxuq -4096(%rdx), %ymm17, %ymm30

// CHECK: vpmaxuq -4128(%rdx), %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x20,0x3f,0xb2,0xe0,0xef,0xff,0xff]
          vpmaxuq -4128(%rdx), %ymm17, %ymm30

// CHECK: vpmaxuq 1016(%rdx){1to4}, %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x30,0x3f,0x72,0x7f]
          vpmaxuq 1016(%rdx){1to4}, %ymm17, %ymm30

// CHECK: vpmaxuq 1024(%rdx){1to4}, %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x30,0x3f,0xb2,0x00,0x04,0x00,0x00]
          vpmaxuq 1024(%rdx){1to4}, %ymm17, %ymm30

// CHECK: vpmaxuq -1024(%rdx){1to4}, %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x30,0x3f,0x72,0x80]
          vpmaxuq -1024(%rdx){1to4}, %ymm17, %ymm30

// CHECK: vpmaxuq -1032(%rdx){1to4}, %ymm17, %ymm30
// CHECK:  encoding: [0x62,0x62,0xf5,0x30,0x3f,0xb2,0xf8,0xfb,0xff,0xff]
          vpmaxuq -1032(%rdx){1to4}, %ymm17, %ymm30

// CHECK: vpminsd %xmm17, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x22,0x55,0x00,0x39,0xe9]
          vpminsd %xmm17, %xmm21, %xmm29

// CHECK: vpminsd %xmm17, %xmm21, %xmm29 {%k4}
// CHECK:  encoding: [0x62,0x22,0x55,0x04,0x39,0xe9]
          vpminsd %xmm17, %xmm21, %xmm29 {%k4}

// CHECK: vpminsd %xmm17, %xmm21, %xmm29 {%k4} {z}
// CHECK:  encoding: [0x62,0x22,0x55,0x84,0x39,0xe9]
          vpminsd %xmm17, %xmm21, %xmm29 {%k4} {z}

// CHECK: vpminsd (%rcx), %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x00,0x39,0x29]
          vpminsd (%rcx), %xmm21, %xmm29

// CHECK: vpminsd 291(%rax,%r14,8), %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x22,0x55,0x00,0x39,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpminsd 291(%rax,%r14,8), %xmm21, %xmm29

// CHECK: vpminsd (%rcx){1to4}, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x10,0x39,0x29]
          vpminsd (%rcx){1to4}, %xmm21, %xmm29

// CHECK: vpminsd 2032(%rdx), %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x00,0x39,0x6a,0x7f]
          vpminsd 2032(%rdx), %xmm21, %xmm29

// CHECK: vpminsd 2048(%rdx), %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x00,0x39,0xaa,0x00,0x08,0x00,0x00]
          vpminsd 2048(%rdx), %xmm21, %xmm29

// CHECK: vpminsd -2048(%rdx), %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x00,0x39,0x6a,0x80]
          vpminsd -2048(%rdx), %xmm21, %xmm29

// CHECK: vpminsd -2064(%rdx), %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x00,0x39,0xaa,0xf0,0xf7,0xff,0xff]
          vpminsd -2064(%rdx), %xmm21, %xmm29

// CHECK: vpminsd 508(%rdx){1to4}, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x10,0x39,0x6a,0x7f]
          vpminsd 508(%rdx){1to4}, %xmm21, %xmm29

// CHECK: vpminsd 512(%rdx){1to4}, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x10,0x39,0xaa,0x00,0x02,0x00,0x00]
          vpminsd 512(%rdx){1to4}, %xmm21, %xmm29

// CHECK: vpminsd -512(%rdx){1to4}, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x10,0x39,0x6a,0x80]
          vpminsd -512(%rdx){1to4}, %xmm21, %xmm29

// CHECK: vpminsd -516(%rdx){1to4}, %xmm21, %xmm29
// CHECK:  encoding: [0x62,0x62,0x55,0x10,0x39,0xaa,0xfc,0xfd,0xff,0xff]
          vpminsd -516(%rdx){1to4}, %xmm21, %xmm29

// CHECK: vpminsd %ymm25, %ymm26, %ymm19
// CHECK:  encoding: [0x62,0x82,0x2d,0x20,0x39,0xd9]
          vpminsd %ymm25, %ymm26, %ymm19

// CHECK: vpminsd %ymm25, %ymm26, %ymm19 {%k7}
// CHECK:  encoding: [0x62,0x82,0x2d,0x27,0x39,0xd9]
          vpminsd %ymm25, %ymm26, %ymm19 {%k7}

// CHECK: vpminsd %ymm25, %ymm26, %ymm19 {%k7} {z}
// CHECK:  encoding: [0x62,0x82,0x2d,0xa7,0x39,0xd9]
          vpminsd %ymm25, %ymm26, %ymm19 {%k7} {z}

// CHECK: vpminsd (%rcx), %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x39,0x19]
          vpminsd (%rcx), %ymm26, %ymm19

// CHECK: vpminsd 291(%rax,%r14,8), %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xa2,0x2d,0x20,0x39,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminsd 291(%rax,%r14,8), %ymm26, %ymm19

// CHECK: vpminsd (%rcx){1to8}, %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x39,0x19]
          vpminsd (%rcx){1to8}, %ymm26, %ymm19

// CHECK: vpminsd 4064(%rdx), %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x39,0x5a,0x7f]
          vpminsd 4064(%rdx), %ymm26, %ymm19

// CHECK: vpminsd 4096(%rdx), %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x39,0x9a,0x00,0x10,0x00,0x00]
          vpminsd 4096(%rdx), %ymm26, %ymm19

// CHECK: vpminsd -4096(%rdx), %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x39,0x5a,0x80]
          vpminsd -4096(%rdx), %ymm26, %ymm19

// CHECK: vpminsd -4128(%rdx), %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x39,0x9a,0xe0,0xef,0xff,0xff]
          vpminsd -4128(%rdx), %ymm26, %ymm19

// CHECK: vpminsd 508(%rdx){1to8}, %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x39,0x5a,0x7f]
          vpminsd 508(%rdx){1to8}, %ymm26, %ymm19

// CHECK: vpminsd 512(%rdx){1to8}, %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x39,0x9a,0x00,0x02,0x00,0x00]
          vpminsd 512(%rdx){1to8}, %ymm26, %ymm19

// CHECK: vpminsd -512(%rdx){1to8}, %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x39,0x5a,0x80]
          vpminsd -512(%rdx){1to8}, %ymm26, %ymm19

// CHECK: vpminsd -516(%rdx){1to8}, %ymm26, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x39,0x9a,0xfc,0xfd,0xff,0xff]
          vpminsd -516(%rdx){1to8}, %ymm26, %ymm19

// CHECK: vpminsq %xmm18, %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xa2,0xbd,0x00,0x39,0xda]
          vpminsq %xmm18, %xmm24, %xmm19

// CHECK: vpminsq %xmm18, %xmm24, %xmm19 {%k6}
// CHECK:  encoding: [0x62,0xa2,0xbd,0x06,0x39,0xda]
          vpminsq %xmm18, %xmm24, %xmm19 {%k6}

// CHECK: vpminsq %xmm18, %xmm24, %xmm19 {%k6} {z}
// CHECK:  encoding: [0x62,0xa2,0xbd,0x86,0x39,0xda]
          vpminsq %xmm18, %xmm24, %xmm19 {%k6} {z}

// CHECK: vpminsq (%rcx), %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x00,0x39,0x19]
          vpminsq (%rcx), %xmm24, %xmm19

// CHECK: vpminsq 291(%rax,%r14,8), %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xa2,0xbd,0x00,0x39,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminsq 291(%rax,%r14,8), %xmm24, %xmm19

// CHECK: vpminsq (%rcx){1to2}, %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x10,0x39,0x19]
          vpminsq (%rcx){1to2}, %xmm24, %xmm19

// CHECK: vpminsq 2032(%rdx), %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x00,0x39,0x5a,0x7f]
          vpminsq 2032(%rdx), %xmm24, %xmm19

// CHECK: vpminsq 2048(%rdx), %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x00,0x39,0x9a,0x00,0x08,0x00,0x00]
          vpminsq 2048(%rdx), %xmm24, %xmm19

// CHECK: vpminsq -2048(%rdx), %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x00,0x39,0x5a,0x80]
          vpminsq -2048(%rdx), %xmm24, %xmm19

// CHECK: vpminsq -2064(%rdx), %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x00,0x39,0x9a,0xf0,0xf7,0xff,0xff]
          vpminsq -2064(%rdx), %xmm24, %xmm19

// CHECK: vpminsq 1016(%rdx){1to2}, %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x10,0x39,0x5a,0x7f]
          vpminsq 1016(%rdx){1to2}, %xmm24, %xmm19

// CHECK: vpminsq 1024(%rdx){1to2}, %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x10,0x39,0x9a,0x00,0x04,0x00,0x00]
          vpminsq 1024(%rdx){1to2}, %xmm24, %xmm19

// CHECK: vpminsq -1024(%rdx){1to2}, %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x10,0x39,0x5a,0x80]
          vpminsq -1024(%rdx){1to2}, %xmm24, %xmm19

// CHECK: vpminsq -1032(%rdx){1to2}, %xmm24, %xmm19
// CHECK:  encoding: [0x62,0xe2,0xbd,0x10,0x39,0x9a,0xf8,0xfb,0xff,0xff]
          vpminsq -1032(%rdx){1to2}, %xmm24, %xmm19

// CHECK: vpminsq %ymm28, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x02,0x95,0x20,0x39,0xcc]
          vpminsq %ymm28, %ymm29, %ymm25

// CHECK: vpminsq %ymm28, %ymm29, %ymm25 {%k6}
// CHECK:  encoding: [0x62,0x02,0x95,0x26,0x39,0xcc]
          vpminsq %ymm28, %ymm29, %ymm25 {%k6}

// CHECK: vpminsq %ymm28, %ymm29, %ymm25 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0x95,0xa6,0x39,0xcc]
          vpminsq %ymm28, %ymm29, %ymm25 {%k6} {z}

// CHECK: vpminsq (%rcx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x20,0x39,0x09]
          vpminsq (%rcx), %ymm29, %ymm25

// CHECK: vpminsq 291(%rax,%r14,8), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x22,0x95,0x20,0x39,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpminsq 291(%rax,%r14,8), %ymm29, %ymm25

// CHECK: vpminsq (%rcx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x30,0x39,0x09]
          vpminsq (%rcx){1to4}, %ymm29, %ymm25

// CHECK: vpminsq 4064(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x20,0x39,0x4a,0x7f]
          vpminsq 4064(%rdx), %ymm29, %ymm25

// CHECK: vpminsq 4096(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x20,0x39,0x8a,0x00,0x10,0x00,0x00]
          vpminsq 4096(%rdx), %ymm29, %ymm25

// CHECK: vpminsq -4096(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x20,0x39,0x4a,0x80]
          vpminsq -4096(%rdx), %ymm29, %ymm25

// CHECK: vpminsq -4128(%rdx), %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x20,0x39,0x8a,0xe0,0xef,0xff,0xff]
          vpminsq -4128(%rdx), %ymm29, %ymm25

// CHECK: vpminsq 1016(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x30,0x39,0x4a,0x7f]
          vpminsq 1016(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vpminsq 1024(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x30,0x39,0x8a,0x00,0x04,0x00,0x00]
          vpminsq 1024(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vpminsq -1024(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x30,0x39,0x4a,0x80]
          vpminsq -1024(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vpminsq -1032(%rdx){1to4}, %ymm29, %ymm25
// CHECK:  encoding: [0x62,0x62,0x95,0x30,0x39,0x8a,0xf8,0xfb,0xff,0xff]
          vpminsq -1032(%rdx){1to4}, %ymm29, %ymm25

// CHECK: vpminud %xmm17, %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xa2,0x45,0x00,0x3b,0xd1]
          vpminud %xmm17, %xmm23, %xmm18

// CHECK: vpminud %xmm17, %xmm23, %xmm18 {%k3}
// CHECK:  encoding: [0x62,0xa2,0x45,0x03,0x3b,0xd1]
          vpminud %xmm17, %xmm23, %xmm18 {%k3}

// CHECK: vpminud %xmm17, %xmm23, %xmm18 {%k3} {z}
// CHECK:  encoding: [0x62,0xa2,0x45,0x83,0x3b,0xd1]
          vpminud %xmm17, %xmm23, %xmm18 {%k3} {z}

// CHECK: vpminud (%rcx), %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x00,0x3b,0x11]
          vpminud (%rcx), %xmm23, %xmm18

// CHECK: vpminud 291(%rax,%r14,8), %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xa2,0x45,0x00,0x3b,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpminud 291(%rax,%r14,8), %xmm23, %xmm18

// CHECK: vpminud (%rcx){1to4}, %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x10,0x3b,0x11]
          vpminud (%rcx){1to4}, %xmm23, %xmm18

// CHECK: vpminud 2032(%rdx), %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x00,0x3b,0x52,0x7f]
          vpminud 2032(%rdx), %xmm23, %xmm18

// CHECK: vpminud 2048(%rdx), %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x00,0x3b,0x92,0x00,0x08,0x00,0x00]
          vpminud 2048(%rdx), %xmm23, %xmm18

// CHECK: vpminud -2048(%rdx), %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x00,0x3b,0x52,0x80]
          vpminud -2048(%rdx), %xmm23, %xmm18

// CHECK: vpminud -2064(%rdx), %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x00,0x3b,0x92,0xf0,0xf7,0xff,0xff]
          vpminud -2064(%rdx), %xmm23, %xmm18

// CHECK: vpminud 508(%rdx){1to4}, %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x10,0x3b,0x52,0x7f]
          vpminud 508(%rdx){1to4}, %xmm23, %xmm18

// CHECK: vpminud 512(%rdx){1to4}, %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x10,0x3b,0x92,0x00,0x02,0x00,0x00]
          vpminud 512(%rdx){1to4}, %xmm23, %xmm18

// CHECK: vpminud -512(%rdx){1to4}, %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x10,0x3b,0x52,0x80]
          vpminud -512(%rdx){1to4}, %xmm23, %xmm18

// CHECK: vpminud -516(%rdx){1to4}, %xmm23, %xmm18
// CHECK:  encoding: [0x62,0xe2,0x45,0x10,0x3b,0x92,0xfc,0xfd,0xff,0xff]
          vpminud -516(%rdx){1to4}, %xmm23, %xmm18

// CHECK: vpminud %ymm19, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xa2,0x4d,0x20,0x3b,0xdb]
          vpminud %ymm19, %ymm22, %ymm19

// CHECK: vpminud %ymm19, %ymm22, %ymm19 {%k3}
// CHECK:  encoding: [0x62,0xa2,0x4d,0x23,0x3b,0xdb]
          vpminud %ymm19, %ymm22, %ymm19 {%k3}

// CHECK: vpminud %ymm19, %ymm22, %ymm19 {%k3} {z}
// CHECK:  encoding: [0x62,0xa2,0x4d,0xa3,0x3b,0xdb]
          vpminud %ymm19, %ymm22, %ymm19 {%k3} {z}

// CHECK: vpminud (%rcx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3b,0x19]
          vpminud (%rcx), %ymm22, %ymm19

// CHECK: vpminud 291(%rax,%r14,8), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xa2,0x4d,0x20,0x3b,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpminud 291(%rax,%r14,8), %ymm22, %ymm19

// CHECK: vpminud (%rcx){1to8}, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x30,0x3b,0x19]
          vpminud (%rcx){1to8}, %ymm22, %ymm19

// CHECK: vpminud 4064(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3b,0x5a,0x7f]
          vpminud 4064(%rdx), %ymm22, %ymm19

// CHECK: vpminud 4096(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3b,0x9a,0x00,0x10,0x00,0x00]
          vpminud 4096(%rdx), %ymm22, %ymm19

// CHECK: vpminud -4096(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3b,0x5a,0x80]
          vpminud -4096(%rdx), %ymm22, %ymm19

// CHECK: vpminud -4128(%rdx), %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x20,0x3b,0x9a,0xe0,0xef,0xff,0xff]
          vpminud -4128(%rdx), %ymm22, %ymm19

// CHECK: vpminud 508(%rdx){1to8}, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x30,0x3b,0x5a,0x7f]
          vpminud 508(%rdx){1to8}, %ymm22, %ymm19

// CHECK: vpminud 512(%rdx){1to8}, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x30,0x3b,0x9a,0x00,0x02,0x00,0x00]
          vpminud 512(%rdx){1to8}, %ymm22, %ymm19

// CHECK: vpminud -512(%rdx){1to8}, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x30,0x3b,0x5a,0x80]
          vpminud -512(%rdx){1to8}, %ymm22, %ymm19

// CHECK: vpminud -516(%rdx){1to8}, %ymm22, %ymm19
// CHECK:  encoding: [0x62,0xe2,0x4d,0x30,0x3b,0x9a,0xfc,0xfd,0xff,0xff]
          vpminud -516(%rdx){1to8}, %ymm22, %ymm19

// CHECK: vpminuq %xmm23, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x22,0xcd,0x00,0x3b,0xe7]
          vpminuq %xmm23, %xmm22, %xmm28

// CHECK: vpminuq %xmm23, %xmm22, %xmm28 {%k4}
// CHECK:  encoding: [0x62,0x22,0xcd,0x04,0x3b,0xe7]
          vpminuq %xmm23, %xmm22, %xmm28 {%k4}

// CHECK: vpminuq %xmm23, %xmm22, %xmm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x22,0xcd,0x84,0x3b,0xe7]
          vpminuq %xmm23, %xmm22, %xmm28 {%k4} {z}

// CHECK: vpminuq (%rcx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x3b,0x21]
          vpminuq (%rcx), %xmm22, %xmm28

// CHECK: vpminuq 291(%rax,%r14,8), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x22,0xcd,0x00,0x3b,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpminuq 291(%rax,%r14,8), %xmm22, %xmm28

// CHECK: vpminuq (%rcx){1to2}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x10,0x3b,0x21]
          vpminuq (%rcx){1to2}, %xmm22, %xmm28

// CHECK: vpminuq 2032(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x3b,0x62,0x7f]
          vpminuq 2032(%rdx), %xmm22, %xmm28

// CHECK: vpminuq 2048(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x3b,0xa2,0x00,0x08,0x00,0x00]
          vpminuq 2048(%rdx), %xmm22, %xmm28

// CHECK: vpminuq -2048(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x3b,0x62,0x80]
          vpminuq -2048(%rdx), %xmm22, %xmm28

// CHECK: vpminuq -2064(%rdx), %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x00,0x3b,0xa2,0xf0,0xf7,0xff,0xff]
          vpminuq -2064(%rdx), %xmm22, %xmm28

// CHECK: vpminuq 1016(%rdx){1to2}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x10,0x3b,0x62,0x7f]
          vpminuq 1016(%rdx){1to2}, %xmm22, %xmm28

// CHECK: vpminuq 1024(%rdx){1to2}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x10,0x3b,0xa2,0x00,0x04,0x00,0x00]
          vpminuq 1024(%rdx){1to2}, %xmm22, %xmm28

// CHECK: vpminuq -1024(%rdx){1to2}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x10,0x3b,0x62,0x80]
          vpminuq -1024(%rdx){1to2}, %xmm22, %xmm28

// CHECK: vpminuq -1032(%rdx){1to2}, %xmm22, %xmm28
// CHECK:  encoding: [0x62,0x62,0xcd,0x10,0x3b,0xa2,0xf8,0xfb,0xff,0xff]
          vpminuq -1032(%rdx){1to2}, %xmm22, %xmm28

// CHECK: vpminuq %ymm23, %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x22,0xd5,0x20,0x3b,0xef]
          vpminuq %ymm23, %ymm21, %ymm29

// CHECK: vpminuq %ymm23, %ymm21, %ymm29 {%k5}
// CHECK:  encoding: [0x62,0x22,0xd5,0x25,0x3b,0xef]
          vpminuq %ymm23, %ymm21, %ymm29 {%k5}

// CHECK: vpminuq %ymm23, %ymm21, %ymm29 {%k5} {z}
// CHECK:  encoding: [0x62,0x22,0xd5,0xa5,0x3b,0xef]
          vpminuq %ymm23, %ymm21, %ymm29 {%k5} {z}

// CHECK: vpminuq (%rcx), %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x20,0x3b,0x29]
          vpminuq (%rcx), %ymm21, %ymm29

// CHECK: vpminuq 291(%rax,%r14,8), %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x22,0xd5,0x20,0x3b,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpminuq 291(%rax,%r14,8), %ymm21, %ymm29

// CHECK: vpminuq (%rcx){1to4}, %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x30,0x3b,0x29]
          vpminuq (%rcx){1to4}, %ymm21, %ymm29

// CHECK: vpminuq 4064(%rdx), %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x20,0x3b,0x6a,0x7f]
          vpminuq 4064(%rdx), %ymm21, %ymm29

// CHECK: vpminuq 4096(%rdx), %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x20,0x3b,0xaa,0x00,0x10,0x00,0x00]
          vpminuq 4096(%rdx), %ymm21, %ymm29

// CHECK: vpminuq -4096(%rdx), %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x20,0x3b,0x6a,0x80]
          vpminuq -4096(%rdx), %ymm21, %ymm29

// CHECK: vpminuq -4128(%rdx), %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x20,0x3b,0xaa,0xe0,0xef,0xff,0xff]
          vpminuq -4128(%rdx), %ymm21, %ymm29

// CHECK: vpminuq 1016(%rdx){1to4}, %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x30,0x3b,0x6a,0x7f]
          vpminuq 1016(%rdx){1to4}, %ymm21, %ymm29

// CHECK: vpminuq 1024(%rdx){1to4}, %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x30,0x3b,0xaa,0x00,0x04,0x00,0x00]
          vpminuq 1024(%rdx){1to4}, %ymm21, %ymm29

// CHECK: vpminuq -1024(%rdx){1to4}, %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x30,0x3b,0x6a,0x80]
          vpminuq -1024(%rdx){1to4}, %ymm21, %ymm29

// CHECK: vpminuq -1032(%rdx){1to4}, %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x62,0xd5,0x30,0x3b,0xaa,0xf8,0xfb,0xff,0xff]
          vpminuq -1032(%rdx){1to4}, %ymm21, %ymm29

// CHECK: vpmulld %xmm24, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x02,0x65,0x00,0x40,0xc8]
          vpmulld %xmm24, %xmm19, %xmm25

// CHECK: vpmulld %xmm24, %xmm19, %xmm25 {%k6}
// CHECK:  encoding: [0x62,0x02,0x65,0x06,0x40,0xc8]
          vpmulld %xmm24, %xmm19, %xmm25 {%k6}

// CHECK: vpmulld %xmm24, %xmm19, %xmm25 {%k6} {z}
// CHECK:  encoding: [0x62,0x02,0x65,0x86,0x40,0xc8]
          vpmulld %xmm24, %xmm19, %xmm25 {%k6} {z}

// CHECK: vpmulld (%rcx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x00,0x40,0x09]
          vpmulld (%rcx), %xmm19, %xmm25

// CHECK: vpmulld 291(%rax,%r14,8), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x22,0x65,0x00,0x40,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vpmulld 291(%rax,%r14,8), %xmm19, %xmm25

// CHECK: vpmulld (%rcx){1to4}, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x10,0x40,0x09]
          vpmulld (%rcx){1to4}, %xmm19, %xmm25

// CHECK: vpmulld 2032(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x00,0x40,0x4a,0x7f]
          vpmulld 2032(%rdx), %xmm19, %xmm25

// CHECK: vpmulld 2048(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x00,0x40,0x8a,0x00,0x08,0x00,0x00]
          vpmulld 2048(%rdx), %xmm19, %xmm25

// CHECK: vpmulld -2048(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x00,0x40,0x4a,0x80]
          vpmulld -2048(%rdx), %xmm19, %xmm25

// CHECK: vpmulld -2064(%rdx), %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x00,0x40,0x8a,0xf0,0xf7,0xff,0xff]
          vpmulld -2064(%rdx), %xmm19, %xmm25

// CHECK: vpmulld 508(%rdx){1to4}, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x10,0x40,0x4a,0x7f]
          vpmulld 508(%rdx){1to4}, %xmm19, %xmm25

// CHECK: vpmulld 512(%rdx){1to4}, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x10,0x40,0x8a,0x00,0x02,0x00,0x00]
          vpmulld 512(%rdx){1to4}, %xmm19, %xmm25

// CHECK: vpmulld -512(%rdx){1to4}, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x10,0x40,0x4a,0x80]
          vpmulld -512(%rdx){1to4}, %xmm19, %xmm25

// CHECK: vpmulld -516(%rdx){1to4}, %xmm19, %xmm25
// CHECK:  encoding: [0x62,0x62,0x65,0x10,0x40,0x8a,0xfc,0xfd,0xff,0xff]
          vpmulld -516(%rdx){1to4}, %xmm19, %xmm25

// CHECK: vpmulld %ymm26, %ymm26, %ymm23
// CHECK:  encoding: [0x62,0x82,0x2d,0x20,0x40,0xfa]
          vpmulld %ymm26, %ymm26, %ymm23

// CHECK: vpmulld %ymm26, %ymm26, %ymm23 {%k2}
// CHECK:  encoding: [0x62,0x82,0x2d,0x22,0x40,0xfa]
          vpmulld %ymm26, %ymm26, %ymm23 {%k2}

// CHECK: vpmulld %ymm26, %ymm26, %ymm23 {%k2} {z}
// CHECK:  encoding: [0x62,0x82,0x2d,0xa2,0x40,0xfa]
          vpmulld %ymm26, %ymm26, %ymm23 {%k2} {z}

// CHECK: vpmulld (%rcx), %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x40,0x39]
          vpmulld (%rcx), %ymm26, %ymm23

// CHECK: vpmulld 291(%rax,%r14,8), %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xa2,0x2d,0x20,0x40,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpmulld 291(%rax,%r14,8), %ymm26, %ymm23

// CHECK: vpmulld (%rcx){1to8}, %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x40,0x39]
          vpmulld (%rcx){1to8}, %ymm26, %ymm23

// CHECK: vpmulld 4064(%rdx), %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x40,0x7a,0x7f]
          vpmulld 4064(%rdx), %ymm26, %ymm23

// CHECK: vpmulld 4096(%rdx), %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x40,0xba,0x00,0x10,0x00,0x00]
          vpmulld 4096(%rdx), %ymm26, %ymm23

// CHECK: vpmulld -4096(%rdx), %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x40,0x7a,0x80]
          vpmulld -4096(%rdx), %ymm26, %ymm23

// CHECK: vpmulld -4128(%rdx), %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x20,0x40,0xba,0xe0,0xef,0xff,0xff]
          vpmulld -4128(%rdx), %ymm26, %ymm23

// CHECK: vpmulld 508(%rdx){1to8}, %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x40,0x7a,0x7f]
          vpmulld 508(%rdx){1to8}, %ymm26, %ymm23

// CHECK: vpmulld 512(%rdx){1to8}, %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x40,0xba,0x00,0x02,0x00,0x00]
          vpmulld 512(%rdx){1to8}, %ymm26, %ymm23

// CHECK: vpmulld -512(%rdx){1to8}, %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x40,0x7a,0x80]
          vpmulld -512(%rdx){1to8}, %ymm26, %ymm23

// CHECK: vpmulld -516(%rdx){1to8}, %ymm26, %ymm23
// CHECK:  encoding: [0x62,0xe2,0x2d,0x30,0x40,0xba,0xfc,0xfd,0xff,0xff]
          vpmulld -516(%rdx){1to8}, %ymm26, %ymm23

// CHECK: vpord  %xmm28, %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x01,0x15,0x00,0xeb,0xe4]
          vpord  %xmm28, %xmm29, %xmm28

// CHECK: vpord  %xmm28, %xmm29, %xmm28 {%k2}
// CHECK:  encoding: [0x62,0x01,0x15,0x02,0xeb,0xe4]
          vpord  %xmm28, %xmm29, %xmm28 {%k2}

// CHECK: vpord  %xmm28, %xmm29, %xmm28 {%k2} {z}
// CHECK:  encoding: [0x62,0x01,0x15,0x82,0xeb,0xe4]
          vpord  %xmm28, %xmm29, %xmm28 {%k2} {z}

// CHECK: vpord  (%rcx), %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xeb,0x21]
          vpord  (%rcx), %xmm29, %xmm28

// CHECK: vpord  291(%rax,%r14,8), %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x21,0x15,0x00,0xeb,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpord  291(%rax,%r14,8), %xmm29, %xmm28

// CHECK: vpord  (%rcx){1to4}, %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x10,0xeb,0x21]
          vpord  (%rcx){1to4}, %xmm29, %xmm28

// CHECK: vpord  2032(%rdx), %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xeb,0x62,0x7f]
          vpord  2032(%rdx), %xmm29, %xmm28

// CHECK: vpord  2048(%rdx), %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xeb,0xa2,0x00,0x08,0x00,0x00]
          vpord  2048(%rdx), %xmm29, %xmm28

// CHECK: vpord  -2048(%rdx), %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xeb,0x62,0x80]
          vpord  -2048(%rdx), %xmm29, %xmm28

// CHECK: vpord  -2064(%rdx), %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x00,0xeb,0xa2,0xf0,0xf7,0xff,0xff]
          vpord  -2064(%rdx), %xmm29, %xmm28

// CHECK: vpord  508(%rdx){1to4}, %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x10,0xeb,0x62,0x7f]
          vpord  508(%rdx){1to4}, %xmm29, %xmm28

// CHECK: vpord  512(%rdx){1to4}, %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x10,0xeb,0xa2,0x00,0x02,0x00,0x00]
          vpord  512(%rdx){1to4}, %xmm29, %xmm28

// CHECK: vpord  -512(%rdx){1to4}, %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x10,0xeb,0x62,0x80]
          vpord  -512(%rdx){1to4}, %xmm29, %xmm28

// CHECK: vpord  -516(%rdx){1to4}, %xmm29, %xmm28
// CHECK:  encoding: [0x62,0x61,0x15,0x10,0xeb,0xa2,0xfc,0xfd,0xff,0xff]
          vpord  -516(%rdx){1to4}, %xmm29, %xmm28

// CHECK: vpord  %ymm22, %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xa1,0x35,0x20,0xeb,0xee]
          vpord  %ymm22, %ymm25, %ymm21

// CHECK: vpord  %ymm22, %ymm25, %ymm21 {%k6}
// CHECK:  encoding: [0x62,0xa1,0x35,0x26,0xeb,0xee]
          vpord  %ymm22, %ymm25, %ymm21 {%k6}

// CHECK: vpord  %ymm22, %ymm25, %ymm21 {%k6} {z}
// CHECK:  encoding: [0x62,0xa1,0x35,0xa6,0xeb,0xee]
          vpord  %ymm22, %ymm25, %ymm21 {%k6} {z}

// CHECK: vpord  (%rcx), %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x20,0xeb,0x29]
          vpord  (%rcx), %ymm25, %ymm21

// CHECK: vpord  291(%rax,%r14,8), %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xa1,0x35,0x20,0xeb,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpord  291(%rax,%r14,8), %ymm25, %ymm21

// CHECK: vpord  (%rcx){1to8}, %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x30,0xeb,0x29]
          vpord  (%rcx){1to8}, %ymm25, %ymm21

// CHECK: vpord  4064(%rdx), %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x20,0xeb,0x6a,0x7f]
          vpord  4064(%rdx), %ymm25, %ymm21

// CHECK: vpord  4096(%rdx), %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x20,0xeb,0xaa,0x00,0x10,0x00,0x00]
          vpord  4096(%rdx), %ymm25, %ymm21

// CHECK: vpord  -4096(%rdx), %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x20,0xeb,0x6a,0x80]
          vpord  -4096(%rdx), %ymm25, %ymm21

// CHECK: vpord  -4128(%rdx), %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x20,0xeb,0xaa,0xe0,0xef,0xff,0xff]
          vpord  -4128(%rdx), %ymm25, %ymm21

// CHECK: vpord  508(%rdx){1to8}, %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x30,0xeb,0x6a,0x7f]
          vpord  508(%rdx){1to8}, %ymm25, %ymm21

// CHECK: vpord  512(%rdx){1to8}, %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x30,0xeb,0xaa,0x00,0x02,0x00,0x00]
          vpord  512(%rdx){1to8}, %ymm25, %ymm21

// CHECK: vpord  -512(%rdx){1to8}, %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x30,0xeb,0x6a,0x80]
          vpord  -512(%rdx){1to8}, %ymm25, %ymm21

// CHECK: vpord  -516(%rdx){1to8}, %ymm25, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x35,0x30,0xeb,0xaa,0xfc,0xfd,0xff,0xff]
          vpord  -516(%rdx){1to8}, %ymm25, %ymm21

// CHECK: vporq  %xmm20, %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xa1,0x9d,0x00,0xeb,0xec]
          vporq  %xmm20, %xmm28, %xmm21

// CHECK: vporq  %xmm20, %xmm28, %xmm21 {%k7}
// CHECK:  encoding: [0x62,0xa1,0x9d,0x07,0xeb,0xec]
          vporq  %xmm20, %xmm28, %xmm21 {%k7}

// CHECK: vporq  %xmm20, %xmm28, %xmm21 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0x9d,0x87,0xeb,0xec]
          vporq  %xmm20, %xmm28, %xmm21 {%k7} {z}

// CHECK: vporq  (%rcx), %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xeb,0x29]
          vporq  (%rcx), %xmm28, %xmm21

// CHECK: vporq  291(%rax,%r14,8), %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xa1,0x9d,0x00,0xeb,0xac,0xf0,0x23,0x01,0x00,0x00]
          vporq  291(%rax,%r14,8), %xmm28, %xmm21

// CHECK: vporq  (%rcx){1to2}, %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xeb,0x29]
          vporq  (%rcx){1to2}, %xmm28, %xmm21

// CHECK: vporq  2032(%rdx), %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xeb,0x6a,0x7f]
          vporq  2032(%rdx), %xmm28, %xmm21

// CHECK: vporq  2048(%rdx), %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xeb,0xaa,0x00,0x08,0x00,0x00]
          vporq  2048(%rdx), %xmm28, %xmm21

// CHECK: vporq  -2048(%rdx), %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xeb,0x6a,0x80]
          vporq  -2048(%rdx), %xmm28, %xmm21

// CHECK: vporq  -2064(%rdx), %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x00,0xeb,0xaa,0xf0,0xf7,0xff,0xff]
          vporq  -2064(%rdx), %xmm28, %xmm21

// CHECK: vporq  1016(%rdx){1to2}, %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xeb,0x6a,0x7f]
          vporq  1016(%rdx){1to2}, %xmm28, %xmm21

// CHECK: vporq  1024(%rdx){1to2}, %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xeb,0xaa,0x00,0x04,0x00,0x00]
          vporq  1024(%rdx){1to2}, %xmm28, %xmm21

// CHECK: vporq  -1024(%rdx){1to2}, %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xeb,0x6a,0x80]
          vporq  -1024(%rdx){1to2}, %xmm28, %xmm21

// CHECK: vporq  -1032(%rdx){1to2}, %xmm28, %xmm21
// CHECK:  encoding: [0x62,0xe1,0x9d,0x10,0xeb,0xaa,0xf8,0xfb,0xff,0xff]
          vporq  -1032(%rdx){1to2}, %xmm28, %xmm21

// CHECK: vporq  %ymm24, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x01,0xe5,0x20,0xeb,0xe0]
          vporq  %ymm24, %ymm19, %ymm28

// CHECK: vporq  %ymm24, %ymm19, %ymm28 {%k4}
// CHECK:  encoding: [0x62,0x01,0xe5,0x24,0xeb,0xe0]
          vporq  %ymm24, %ymm19, %ymm28 {%k4}

// CHECK: vporq  %ymm24, %ymm19, %ymm28 {%k4} {z}
// CHECK:  encoding: [0x62,0x01,0xe5,0xa4,0xeb,0xe0]
          vporq  %ymm24, %ymm19, %ymm28 {%k4} {z}

// CHECK: vporq  (%rcx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0xeb,0x21]
          vporq  (%rcx), %ymm19, %ymm28

// CHECK: vporq  291(%rax,%r14,8), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x21,0xe5,0x20,0xeb,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vporq  291(%rax,%r14,8), %ymm19, %ymm28

// CHECK: vporq  (%rcx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0xeb,0x21]
          vporq  (%rcx){1to4}, %ymm19, %ymm28

// CHECK: vporq  4064(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0xeb,0x62,0x7f]
          vporq  4064(%rdx), %ymm19, %ymm28

// CHECK: vporq  4096(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0xeb,0xa2,0x00,0x10,0x00,0x00]
          vporq  4096(%rdx), %ymm19, %ymm28

// CHECK: vporq  -4096(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0xeb,0x62,0x80]
          vporq  -4096(%rdx), %ymm19, %ymm28

// CHECK: vporq  -4128(%rdx), %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x20,0xeb,0xa2,0xe0,0xef,0xff,0xff]
          vporq  -4128(%rdx), %ymm19, %ymm28

// CHECK: vporq  1016(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0xeb,0x62,0x7f]
          vporq  1016(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vporq  1024(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0xeb,0xa2,0x00,0x04,0x00,0x00]
          vporq  1024(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vporq  -1024(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0xeb,0x62,0x80]
          vporq  -1024(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vporq  -1032(%rdx){1to4}, %ymm19, %ymm28
// CHECK:  encoding: [0x62,0x61,0xe5,0x30,0xeb,0xa2,0xf8,0xfb,0xff,0xff]
          vporq  -1032(%rdx){1to4}, %ymm19, %ymm28

// CHECK: vpsubd %xmm26, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0x81,0x6d,0x00,0xfa,0xda]
          vpsubd %xmm26, %xmm18, %xmm19

// CHECK: vpsubd %xmm26, %xmm18, %xmm19 {%k2}
// CHECK:  encoding: [0x62,0x81,0x6d,0x02,0xfa,0xda]
          vpsubd %xmm26, %xmm18, %xmm19 {%k2}

// CHECK: vpsubd %xmm26, %xmm18, %xmm19 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x6d,0x82,0xfa,0xda]
          vpsubd %xmm26, %xmm18, %xmm19 {%k2} {z}

// CHECK: vpsubd (%rcx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x00,0xfa,0x19]
          vpsubd (%rcx), %xmm18, %xmm19

// CHECK: vpsubd 291(%rax,%r14,8), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xa1,0x6d,0x00,0xfa,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vpsubd 291(%rax,%r14,8), %xmm18, %xmm19

// CHECK: vpsubd (%rcx){1to4}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x10,0xfa,0x19]
          vpsubd (%rcx){1to4}, %xmm18, %xmm19

// CHECK: vpsubd 2032(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x00,0xfa,0x5a,0x7f]
          vpsubd 2032(%rdx), %xmm18, %xmm19

// CHECK: vpsubd 2048(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x00,0xfa,0x9a,0x00,0x08,0x00,0x00]
          vpsubd 2048(%rdx), %xmm18, %xmm19

// CHECK: vpsubd -2048(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x00,0xfa,0x5a,0x80]
          vpsubd -2048(%rdx), %xmm18, %xmm19

// CHECK: vpsubd -2064(%rdx), %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x00,0xfa,0x9a,0xf0,0xf7,0xff,0xff]
          vpsubd -2064(%rdx), %xmm18, %xmm19

// CHECK: vpsubd 508(%rdx){1to4}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x10,0xfa,0x5a,0x7f]
          vpsubd 508(%rdx){1to4}, %xmm18, %xmm19

// CHECK: vpsubd 512(%rdx){1to4}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x10,0xfa,0x9a,0x00,0x02,0x00,0x00]
          vpsubd 512(%rdx){1to4}, %xmm18, %xmm19

// CHECK: vpsubd -512(%rdx){1to4}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x10,0xfa,0x5a,0x80]
          vpsubd -512(%rdx){1to4}, %xmm18, %xmm19

// CHECK: vpsubd -516(%rdx){1to4}, %xmm18, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x6d,0x10,0xfa,0x9a,0xfc,0xfd,0xff,0xff]
          vpsubd -516(%rdx){1to4}, %xmm18, %xmm19

// CHECK: vpsubd %ymm21, %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x21,0x2d,0x20,0xfa,0xc5]
          vpsubd %ymm21, %ymm26, %ymm24

// CHECK: vpsubd %ymm21, %ymm26, %ymm24 {%k1}
// CHECK:  encoding: [0x62,0x21,0x2d,0x21,0xfa,0xc5]
          vpsubd %ymm21, %ymm26, %ymm24 {%k1}

// CHECK: vpsubd %ymm21, %ymm26, %ymm24 {%k1} {z}
// CHECK:  encoding: [0x62,0x21,0x2d,0xa1,0xfa,0xc5]
          vpsubd %ymm21, %ymm26, %ymm24 {%k1} {z}

// CHECK: vpsubd (%rcx), %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xfa,0x01]
          vpsubd (%rcx), %ymm26, %ymm24

// CHECK: vpsubd 291(%rax,%r14,8), %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x21,0x2d,0x20,0xfa,0x84,0xf0,0x23,0x01,0x00,0x00]
          vpsubd 291(%rax,%r14,8), %ymm26, %ymm24

// CHECK: vpsubd (%rcx){1to8}, %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x30,0xfa,0x01]
          vpsubd (%rcx){1to8}, %ymm26, %ymm24

// CHECK: vpsubd 4064(%rdx), %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xfa,0x42,0x7f]
          vpsubd 4064(%rdx), %ymm26, %ymm24

// CHECK: vpsubd 4096(%rdx), %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xfa,0x82,0x00,0x10,0x00,0x00]
          vpsubd 4096(%rdx), %ymm26, %ymm24

// CHECK: vpsubd -4096(%rdx), %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xfa,0x42,0x80]
          vpsubd -4096(%rdx), %ymm26, %ymm24

// CHECK: vpsubd -4128(%rdx), %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x20,0xfa,0x82,0xe0,0xef,0xff,0xff]
          vpsubd -4128(%rdx), %ymm26, %ymm24

// CHECK: vpsubd 508(%rdx){1to8}, %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x30,0xfa,0x42,0x7f]
          vpsubd 508(%rdx){1to8}, %ymm26, %ymm24

// CHECK: vpsubd 512(%rdx){1to8}, %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x30,0xfa,0x82,0x00,0x02,0x00,0x00]
          vpsubd 512(%rdx){1to8}, %ymm26, %ymm24

// CHECK: vpsubd -512(%rdx){1to8}, %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x30,0xfa,0x42,0x80]
          vpsubd -512(%rdx){1to8}, %ymm26, %ymm24

// CHECK: vpsubd -516(%rdx){1to8}, %ymm26, %ymm24
// CHECK:  encoding: [0x62,0x61,0x2d,0x30,0xfa,0x82,0xfc,0xfd,0xff,0xff]
          vpsubd -516(%rdx){1to8}, %ymm26, %ymm24

// CHECK: vpsubq %xmm27, %xmm27, %xmm20
// CHECK:  encoding: [0x62,0x81,0xa5,0x00,0xfb,0xe3]
          vpsubq %xmm27, %xmm27, %xmm20

// CHECK: vpsubq %xmm27, %xmm27, %xmm20 {%k2}
// CHECK:  encoding: [0x62,0x81,0xa5,0x02,0xfb,0xe3]
          vpsubq %xmm27, %xmm27, %xmm20 {%k2}

// CHECK: vpsubq %xmm27, %xmm27, %xmm20 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0xa5,0x82,0xfb,0xe3]
          vpsubq %xmm27, %xmm27, %xmm20 {%k2} {z}

// CHECK: vpsubq (%rcx), %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0xfb,0x21]
          vpsubq (%rcx), %xmm27, %xmm20

// CHECK: vpsubq 291(%rax,%r14,8), %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xa1,0xa5,0x00,0xfb,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vpsubq 291(%rax,%r14,8), %xmm27, %xmm20

// CHECK: vpsubq (%rcx){1to2}, %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0xfb,0x21]
          vpsubq (%rcx){1to2}, %xmm27, %xmm20

// CHECK: vpsubq 2032(%rdx), %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0xfb,0x62,0x7f]
          vpsubq 2032(%rdx), %xmm27, %xmm20

// CHECK: vpsubq 2048(%rdx), %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0xfb,0xa2,0x00,0x08,0x00,0x00]
          vpsubq 2048(%rdx), %xmm27, %xmm20

// CHECK: vpsubq -2048(%rdx), %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0xfb,0x62,0x80]
          vpsubq -2048(%rdx), %xmm27, %xmm20

// CHECK: vpsubq -2064(%rdx), %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x00,0xfb,0xa2,0xf0,0xf7,0xff,0xff]
          vpsubq -2064(%rdx), %xmm27, %xmm20

// CHECK: vpsubq 1016(%rdx){1to2}, %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0xfb,0x62,0x7f]
          vpsubq 1016(%rdx){1to2}, %xmm27, %xmm20

// CHECK: vpsubq 1024(%rdx){1to2}, %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0xfb,0xa2,0x00,0x04,0x00,0x00]
          vpsubq 1024(%rdx){1to2}, %xmm27, %xmm20

// CHECK: vpsubq -1024(%rdx){1to2}, %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0xfb,0x62,0x80]
          vpsubq -1024(%rdx){1to2}, %xmm27, %xmm20

// CHECK: vpsubq -1032(%rdx){1to2}, %xmm27, %xmm20
// CHECK:  encoding: [0x62,0xe1,0xa5,0x10,0xfb,0xa2,0xf8,0xfb,0xff,0xff]
          vpsubq -1032(%rdx){1to2}, %xmm27, %xmm20

// CHECK: vpsubq %ymm28, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x01,0xdd,0x20,0xfb,0xec]
          vpsubq %ymm28, %ymm20, %ymm29

// CHECK: vpsubq %ymm28, %ymm20, %ymm29 {%k5}
// CHECK:  encoding: [0x62,0x01,0xdd,0x25,0xfb,0xec]
          vpsubq %ymm28, %ymm20, %ymm29 {%k5}

// CHECK: vpsubq %ymm28, %ymm20, %ymm29 {%k5} {z}
// CHECK:  encoding: [0x62,0x01,0xdd,0xa5,0xfb,0xec]
          vpsubq %ymm28, %ymm20, %ymm29 {%k5} {z}

// CHECK: vpsubq (%rcx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xfb,0x29]
          vpsubq (%rcx), %ymm20, %ymm29

// CHECK: vpsubq 291(%rax,%r14,8), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x21,0xdd,0x20,0xfb,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpsubq 291(%rax,%r14,8), %ymm20, %ymm29

// CHECK: vpsubq (%rcx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xfb,0x29]
          vpsubq (%rcx){1to4}, %ymm20, %ymm29

// CHECK: vpsubq 4064(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xfb,0x6a,0x7f]
          vpsubq 4064(%rdx), %ymm20, %ymm29

// CHECK: vpsubq 4096(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xfb,0xaa,0x00,0x10,0x00,0x00]
          vpsubq 4096(%rdx), %ymm20, %ymm29

// CHECK: vpsubq -4096(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xfb,0x6a,0x80]
          vpsubq -4096(%rdx), %ymm20, %ymm29

// CHECK: vpsubq -4128(%rdx), %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x20,0xfb,0xaa,0xe0,0xef,0xff,0xff]
          vpsubq -4128(%rdx), %ymm20, %ymm29

// CHECK: vpsubq 1016(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xfb,0x6a,0x7f]
          vpsubq 1016(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpsubq 1024(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xfb,0xaa,0x00,0x04,0x00,0x00]
          vpsubq 1024(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpsubq -1024(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xfb,0x6a,0x80]
          vpsubq -1024(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpsubq -1032(%rdx){1to4}, %ymm20, %ymm29
// CHECK:  encoding: [0x62,0x61,0xdd,0x30,0xfb,0xaa,0xf8,0xfb,0xff,0xff]
          vpsubq -1032(%rdx){1to4}, %ymm20, %ymm29

// CHECK: vpxord %xmm25, %xmm17, %xmm23
// CHECK:  encoding: [0x62,0x81,0x75,0x00,0xef,0xf9]
          vpxord %xmm25, %xmm17, %xmm23

// CHECK: vpxord %xmm25, %xmm17, %xmm23 {%k3}
// CHECK:  encoding: [0x62,0x81,0x75,0x03,0xef,0xf9]
          vpxord %xmm25, %xmm17, %xmm23 {%k3}

// CHECK: vpxord %xmm25, %xmm17, %xmm23 {%k3} {z}
// CHECK:  encoding: [0x62,0x81,0x75,0x83,0xef,0xf9]
          vpxord %xmm25, %xmm17, %xmm23 {%k3} {z}

// CHECK: vpxord (%rcx), %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xef,0x39]
          vpxord (%rcx), %xmm17, %xmm23

// CHECK: vpxord 291(%rax,%r14,8), %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xa1,0x75,0x00,0xef,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vpxord 291(%rax,%r14,8), %xmm17, %xmm23

// CHECK: vpxord (%rcx){1to4}, %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x10,0xef,0x39]
          vpxord (%rcx){1to4}, %xmm17, %xmm23

// CHECK: vpxord 2032(%rdx), %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xef,0x7a,0x7f]
          vpxord 2032(%rdx), %xmm17, %xmm23

// CHECK: vpxord 2048(%rdx), %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xef,0xba,0x00,0x08,0x00,0x00]
          vpxord 2048(%rdx), %xmm17, %xmm23

// CHECK: vpxord -2048(%rdx), %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xef,0x7a,0x80]
          vpxord -2048(%rdx), %xmm17, %xmm23

// CHECK: vpxord -2064(%rdx), %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x00,0xef,0xba,0xf0,0xf7,0xff,0xff]
          vpxord -2064(%rdx), %xmm17, %xmm23

// CHECK: vpxord 508(%rdx){1to4}, %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x10,0xef,0x7a,0x7f]
          vpxord 508(%rdx){1to4}, %xmm17, %xmm23

// CHECK: vpxord 512(%rdx){1to4}, %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x10,0xef,0xba,0x00,0x02,0x00,0x00]
          vpxord 512(%rdx){1to4}, %xmm17, %xmm23

// CHECK: vpxord -512(%rdx){1to4}, %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x10,0xef,0x7a,0x80]
          vpxord -512(%rdx){1to4}, %xmm17, %xmm23

// CHECK: vpxord -516(%rdx){1to4}, %xmm17, %xmm23
// CHECK:  encoding: [0x62,0xe1,0x75,0x10,0xef,0xba,0xfc,0xfd,0xff,0xff]
          vpxord -516(%rdx){1to4}, %xmm17, %xmm23

// CHECK: vpxord %ymm22, %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xa1,0x15,0x20,0xef,0xf6]
          vpxord %ymm22, %ymm29, %ymm22

// CHECK: vpxord %ymm22, %ymm29, %ymm22 {%k4}
// CHECK:  encoding: [0x62,0xa1,0x15,0x24,0xef,0xf6]
          vpxord %ymm22, %ymm29, %ymm22 {%k4}

// CHECK: vpxord %ymm22, %ymm29, %ymm22 {%k4} {z}
// CHECK:  encoding: [0x62,0xa1,0x15,0xa4,0xef,0xf6]
          vpxord %ymm22, %ymm29, %ymm22 {%k4} {z}

// CHECK: vpxord (%rcx), %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xef,0x31]
          vpxord (%rcx), %ymm29, %ymm22

// CHECK: vpxord 291(%rax,%r14,8), %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xa1,0x15,0x20,0xef,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vpxord 291(%rax,%r14,8), %ymm29, %ymm22

// CHECK: vpxord (%rcx){1to8}, %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x30,0xef,0x31]
          vpxord (%rcx){1to8}, %ymm29, %ymm22

// CHECK: vpxord 4064(%rdx), %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xef,0x72,0x7f]
          vpxord 4064(%rdx), %ymm29, %ymm22

// CHECK: vpxord 4096(%rdx), %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xef,0xb2,0x00,0x10,0x00,0x00]
          vpxord 4096(%rdx), %ymm29, %ymm22

// CHECK: vpxord -4096(%rdx), %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xef,0x72,0x80]
          vpxord -4096(%rdx), %ymm29, %ymm22

// CHECK: vpxord -4128(%rdx), %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x20,0xef,0xb2,0xe0,0xef,0xff,0xff]
          vpxord -4128(%rdx), %ymm29, %ymm22

// CHECK: vpxord 508(%rdx){1to8}, %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x30,0xef,0x72,0x7f]
          vpxord 508(%rdx){1to8}, %ymm29, %ymm22

// CHECK: vpxord 512(%rdx){1to8}, %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x30,0xef,0xb2,0x00,0x02,0x00,0x00]
          vpxord 512(%rdx){1to8}, %ymm29, %ymm22

// CHECK: vpxord -512(%rdx){1to8}, %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x30,0xef,0x72,0x80]
          vpxord -512(%rdx){1to8}, %ymm29, %ymm22

// CHECK: vpxord -516(%rdx){1to8}, %ymm29, %ymm22
// CHECK:  encoding: [0x62,0xe1,0x15,0x30,0xef,0xb2,0xfc,0xfd,0xff,0xff]
          vpxord -516(%rdx){1to8}, %ymm29, %ymm22

// CHECK: vpxorq %xmm18, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x21,0xf5,0x00,0xef,0xd2]
          vpxorq %xmm18, %xmm17, %xmm26

// CHECK: vpxorq %xmm18, %xmm17, %xmm26 {%k2}
// CHECK:  encoding: [0x62,0x21,0xf5,0x02,0xef,0xd2]
          vpxorq %xmm18, %xmm17, %xmm26 {%k2}

// CHECK: vpxorq %xmm18, %xmm17, %xmm26 {%k2} {z}
// CHECK:  encoding: [0x62,0x21,0xf5,0x82,0xef,0xd2]
          vpxorq %xmm18, %xmm17, %xmm26 {%k2} {z}

// CHECK: vpxorq (%rcx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xef,0x11]
          vpxorq (%rcx), %xmm17, %xmm26

// CHECK: vpxorq 291(%rax,%r14,8), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x21,0xf5,0x00,0xef,0x94,0xf0,0x23,0x01,0x00,0x00]
          vpxorq 291(%rax,%r14,8), %xmm17, %xmm26

// CHECK: vpxorq (%rcx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xef,0x11]
          vpxorq (%rcx){1to2}, %xmm17, %xmm26

// CHECK: vpxorq 2032(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xef,0x52,0x7f]
          vpxorq 2032(%rdx), %xmm17, %xmm26

// CHECK: vpxorq 2048(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xef,0x92,0x00,0x08,0x00,0x00]
          vpxorq 2048(%rdx), %xmm17, %xmm26

// CHECK: vpxorq -2048(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xef,0x52,0x80]
          vpxorq -2048(%rdx), %xmm17, %xmm26

// CHECK: vpxorq -2064(%rdx), %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x00,0xef,0x92,0xf0,0xf7,0xff,0xff]
          vpxorq -2064(%rdx), %xmm17, %xmm26

// CHECK: vpxorq 1016(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xef,0x52,0x7f]
          vpxorq 1016(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpxorq 1024(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xef,0x92,0x00,0x04,0x00,0x00]
          vpxorq 1024(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpxorq -1024(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xef,0x52,0x80]
          vpxorq -1024(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpxorq -1032(%rdx){1to2}, %xmm17, %xmm26
// CHECK:  encoding: [0x62,0x61,0xf5,0x10,0xef,0x92,0xf8,0xfb,0xff,0xff]
          vpxorq -1032(%rdx){1to2}, %xmm17, %xmm26

// CHECK: vpxorq %ymm19, %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xa1,0xed,0x20,0xef,0xeb]
          vpxorq %ymm19, %ymm18, %ymm21

// CHECK: vpxorq %ymm19, %ymm18, %ymm21 {%k7}
// CHECK:  encoding: [0x62,0xa1,0xed,0x27,0xef,0xeb]
          vpxorq %ymm19, %ymm18, %ymm21 {%k7}

// CHECK: vpxorq %ymm19, %ymm18, %ymm21 {%k7} {z}
// CHECK:  encoding: [0x62,0xa1,0xed,0xa7,0xef,0xeb]
          vpxorq %ymm19, %ymm18, %ymm21 {%k7} {z}

// CHECK: vpxorq (%rcx), %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0xef,0x29]
          vpxorq (%rcx), %ymm18, %ymm21

// CHECK: vpxorq 291(%rax,%r14,8), %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xa1,0xed,0x20,0xef,0xac,0xf0,0x23,0x01,0x00,0x00]
          vpxorq 291(%rax,%r14,8), %ymm18, %ymm21

// CHECK: vpxorq (%rcx){1to4}, %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0xef,0x29]
          vpxorq (%rcx){1to4}, %ymm18, %ymm21

// CHECK: vpxorq 4064(%rdx), %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0xef,0x6a,0x7f]
          vpxorq 4064(%rdx), %ymm18, %ymm21

// CHECK: vpxorq 4096(%rdx), %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0xef,0xaa,0x00,0x10,0x00,0x00]
          vpxorq 4096(%rdx), %ymm18, %ymm21

// CHECK: vpxorq -4096(%rdx), %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0xef,0x6a,0x80]
          vpxorq -4096(%rdx), %ymm18, %ymm21

// CHECK: vpxorq -4128(%rdx), %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x20,0xef,0xaa,0xe0,0xef,0xff,0xff]
          vpxorq -4128(%rdx), %ymm18, %ymm21

// CHECK: vpxorq 1016(%rdx){1to4}, %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0xef,0x6a,0x7f]
          vpxorq 1016(%rdx){1to4}, %ymm18, %ymm21

// CHECK: vpxorq 1024(%rdx){1to4}, %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0xef,0xaa,0x00,0x04,0x00,0x00]
          vpxorq 1024(%rdx){1to4}, %ymm18, %ymm21

// CHECK: vpxorq -1024(%rdx){1to4}, %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0xef,0x6a,0x80]
          vpxorq -1024(%rdx){1to4}, %ymm18, %ymm21

// CHECK: vpxorq -1032(%rdx){1to4}, %ymm18, %ymm21
// CHECK:  encoding: [0x62,0xe1,0xed,0x30,0xef,0xaa,0xf8,0xfb,0xff,0xff]
          vpxorq -1032(%rdx){1to4}, %ymm18, %ymm21

// CHECK: vrcp14pd %xmm29, %xmm18
// CHECK:  encoding: [0x62,0x82,0xfd,0x08,0x4c,0xd5]
          vrcp14pd %xmm29, %xmm18

// CHECK: vrcp14pd %xmm29, %xmm18 {%k4}
// CHECK:  encoding: [0x62,0x82,0xfd,0x0c,0x4c,0xd5]
          vrcp14pd %xmm29, %xmm18 {%k4}

// CHECK: vrcp14pd %xmm29, %xmm18 {%k4} {z}
// CHECK:  encoding: [0x62,0x82,0xfd,0x8c,0x4c,0xd5]
          vrcp14pd %xmm29, %xmm18 {%k4} {z}

// CHECK: vrcp14pd (%rcx), %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4c,0x11]
          vrcp14pd (%rcx), %xmm18

// CHECK: vrcp14pd 291(%rax,%r14,8), %xmm18
// CHECK:  encoding: [0x62,0xa2,0xfd,0x08,0x4c,0x94,0xf0,0x23,0x01,0x00,0x00]
          vrcp14pd 291(%rax,%r14,8), %xmm18

// CHECK: vrcp14pd (%rcx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4c,0x11]
          vrcp14pd (%rcx){1to2}, %xmm18

// CHECK: vrcp14pd 2032(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4c,0x52,0x7f]
          vrcp14pd 2032(%rdx), %xmm18

// CHECK: vrcp14pd 2048(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4c,0x92,0x00,0x08,0x00,0x00]
          vrcp14pd 2048(%rdx), %xmm18

// CHECK: vrcp14pd -2048(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4c,0x52,0x80]
          vrcp14pd -2048(%rdx), %xmm18

// CHECK: vrcp14pd -2064(%rdx), %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4c,0x92,0xf0,0xf7,0xff,0xff]
          vrcp14pd -2064(%rdx), %xmm18

// CHECK: vrcp14pd 1016(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4c,0x52,0x7f]
          vrcp14pd 1016(%rdx){1to2}, %xmm18

// CHECK: vrcp14pd 1024(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4c,0x92,0x00,0x04,0x00,0x00]
          vrcp14pd 1024(%rdx){1to2}, %xmm18

// CHECK: vrcp14pd -1024(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4c,0x52,0x80]
          vrcp14pd -1024(%rdx){1to2}, %xmm18

// CHECK: vrcp14pd -1032(%rdx){1to2}, %xmm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4c,0x92,0xf8,0xfb,0xff,0xff]
          vrcp14pd -1032(%rdx){1to2}, %xmm18

// CHECK: vrcp14pd %ymm29, %ymm17
// CHECK:  encoding: [0x62,0x82,0xfd,0x28,0x4c,0xcd]
          vrcp14pd %ymm29, %ymm17

// CHECK: vrcp14pd %ymm29, %ymm17 {%k4}
// CHECK:  encoding: [0x62,0x82,0xfd,0x2c,0x4c,0xcd]
          vrcp14pd %ymm29, %ymm17 {%k4}

// CHECK: vrcp14pd %ymm29, %ymm17 {%k4} {z}
// CHECK:  encoding: [0x62,0x82,0xfd,0xac,0x4c,0xcd]
          vrcp14pd %ymm29, %ymm17 {%k4} {z}

// CHECK: vrcp14pd (%rcx), %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4c,0x09]
          vrcp14pd (%rcx), %ymm17

// CHECK: vrcp14pd 291(%rax,%r14,8), %ymm17
// CHECK:  encoding: [0x62,0xa2,0xfd,0x28,0x4c,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vrcp14pd 291(%rax,%r14,8), %ymm17

// CHECK: vrcp14pd (%rcx){1to4}, %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4c,0x09]
          vrcp14pd (%rcx){1to4}, %ymm17

// CHECK: vrcp14pd 4064(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4c,0x4a,0x7f]
          vrcp14pd 4064(%rdx), %ymm17

// CHECK: vrcp14pd 4096(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4c,0x8a,0x00,0x10,0x00,0x00]
          vrcp14pd 4096(%rdx), %ymm17

// CHECK: vrcp14pd -4096(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4c,0x4a,0x80]
          vrcp14pd -4096(%rdx), %ymm17

// CHECK: vrcp14pd -4128(%rdx), %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4c,0x8a,0xe0,0xef,0xff,0xff]
          vrcp14pd -4128(%rdx), %ymm17

// CHECK: vrcp14pd 1016(%rdx){1to4}, %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4c,0x4a,0x7f]
          vrcp14pd 1016(%rdx){1to4}, %ymm17

// CHECK: vrcp14pd 1024(%rdx){1to4}, %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4c,0x8a,0x00,0x04,0x00,0x00]
          vrcp14pd 1024(%rdx){1to4}, %ymm17

// CHECK: vrcp14pd -1024(%rdx){1to4}, %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4c,0x4a,0x80]
          vrcp14pd -1024(%rdx){1to4}, %ymm17

// CHECK: vrcp14pd -1032(%rdx){1to4}, %ymm17
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4c,0x8a,0xf8,0xfb,0xff,0xff]
          vrcp14pd -1032(%rdx){1to4}, %ymm17

// CHECK: vrcp14ps %xmm28, %xmm27
// CHECK:  encoding: [0x62,0x02,0x7d,0x08,0x4c,0xdc]
          vrcp14ps %xmm28, %xmm27

// CHECK: vrcp14ps %xmm28, %xmm27 {%k4}
// CHECK:  encoding: [0x62,0x02,0x7d,0x0c,0x4c,0xdc]
          vrcp14ps %xmm28, %xmm27 {%k4}

// CHECK: vrcp14ps %xmm28, %xmm27 {%k4} {z}
// CHECK:  encoding: [0x62,0x02,0x7d,0x8c,0x4c,0xdc]
          vrcp14ps %xmm28, %xmm27 {%k4} {z}

// CHECK: vrcp14ps (%rcx), %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x4c,0x19]
          vrcp14ps (%rcx), %xmm27

// CHECK: vrcp14ps 291(%rax,%r14,8), %xmm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x08,0x4c,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vrcp14ps 291(%rax,%r14,8), %xmm27

// CHECK: vrcp14ps (%rcx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x18,0x4c,0x19]
          vrcp14ps (%rcx){1to4}, %xmm27

// CHECK: vrcp14ps 2032(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x4c,0x5a,0x7f]
          vrcp14ps 2032(%rdx), %xmm27

// CHECK: vrcp14ps 2048(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x4c,0x9a,0x00,0x08,0x00,0x00]
          vrcp14ps 2048(%rdx), %xmm27

// CHECK: vrcp14ps -2048(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x4c,0x5a,0x80]
          vrcp14ps -2048(%rdx), %xmm27

// CHECK: vrcp14ps -2064(%rdx), %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x08,0x4c,0x9a,0xf0,0xf7,0xff,0xff]
          vrcp14ps -2064(%rdx), %xmm27

// CHECK: vrcp14ps 508(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x18,0x4c,0x5a,0x7f]
          vrcp14ps 508(%rdx){1to4}, %xmm27

// CHECK: vrcp14ps 512(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x18,0x4c,0x9a,0x00,0x02,0x00,0x00]
          vrcp14ps 512(%rdx){1to4}, %xmm27

// CHECK: vrcp14ps -512(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x18,0x4c,0x5a,0x80]
          vrcp14ps -512(%rdx){1to4}, %xmm27

// CHECK: vrcp14ps -516(%rdx){1to4}, %xmm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x18,0x4c,0x9a,0xfc,0xfd,0xff,0xff]
          vrcp14ps -516(%rdx){1to4}, %xmm27

// CHECK: vrcp14ps %ymm21, %ymm29
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x4c,0xed]
          vrcp14ps %ymm21, %ymm29

// CHECK: vrcp14ps %ymm21, %ymm29 {%k7}
// CHECK:  encoding: [0x62,0x22,0x7d,0x2f,0x4c,0xed]
          vrcp14ps %ymm21, %ymm29 {%k7}

// CHECK: vrcp14ps %ymm21, %ymm29 {%k7} {z}
// CHECK:  encoding: [0x62,0x22,0x7d,0xaf,0x4c,0xed]
          vrcp14ps %ymm21, %ymm29 {%k7} {z}

// CHECK: vrcp14ps (%rcx), %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4c,0x29]
          vrcp14ps (%rcx), %ymm29

// CHECK: vrcp14ps 291(%rax,%r14,8), %ymm29
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x4c,0xac,0xf0,0x23,0x01,0x00,0x00]
          vrcp14ps 291(%rax,%r14,8), %ymm29

// CHECK: vrcp14ps (%rcx){1to8}, %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4c,0x29]
          vrcp14ps (%rcx){1to8}, %ymm29

// CHECK: vrcp14ps 4064(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4c,0x6a,0x7f]
          vrcp14ps 4064(%rdx), %ymm29

// CHECK: vrcp14ps 4096(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4c,0xaa,0x00,0x10,0x00,0x00]
          vrcp14ps 4096(%rdx), %ymm29

// CHECK: vrcp14ps -4096(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4c,0x6a,0x80]
          vrcp14ps -4096(%rdx), %ymm29

// CHECK: vrcp14ps -4128(%rdx), %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4c,0xaa,0xe0,0xef,0xff,0xff]
          vrcp14ps -4128(%rdx), %ymm29

// CHECK: vrcp14ps 508(%rdx){1to8}, %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4c,0x6a,0x7f]
          vrcp14ps 508(%rdx){1to8}, %ymm29

// CHECK: vrcp14ps 512(%rdx){1to8}, %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4c,0xaa,0x00,0x02,0x00,0x00]
          vrcp14ps 512(%rdx){1to8}, %ymm29

// CHECK: vrcp14ps -512(%rdx){1to8}, %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4c,0x6a,0x80]
          vrcp14ps -512(%rdx){1to8}, %ymm29

// CHECK: vrcp14ps -516(%rdx){1to8}, %ymm29
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4c,0xaa,0xfc,0xfd,0xff,0xff]
          vrcp14ps -516(%rdx){1to8}, %ymm29

// CHECK: vrsqrt14pd %xmm28, %xmm21
// CHECK:  encoding: [0x62,0x82,0xfd,0x08,0x4e,0xec]
          vrsqrt14pd %xmm28, %xmm21

// CHECK: vrsqrt14pd %xmm28, %xmm21 {%k1}
// CHECK:  encoding: [0x62,0x82,0xfd,0x09,0x4e,0xec]
          vrsqrt14pd %xmm28, %xmm21 {%k1}

// CHECK: vrsqrt14pd %xmm28, %xmm21 {%k1} {z}
// CHECK:  encoding: [0x62,0x82,0xfd,0x89,0x4e,0xec]
          vrsqrt14pd %xmm28, %xmm21 {%k1} {z}

// CHECK: vrsqrt14pd (%rcx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4e,0x29]
          vrsqrt14pd (%rcx), %xmm21

// CHECK: vrsqrt14pd 291(%rax,%r14,8), %xmm21
// CHECK:  encoding: [0x62,0xa2,0xfd,0x08,0x4e,0xac,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14pd 291(%rax,%r14,8), %xmm21

// CHECK: vrsqrt14pd (%rcx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4e,0x29]
          vrsqrt14pd (%rcx){1to2}, %xmm21

// CHECK: vrsqrt14pd 2032(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4e,0x6a,0x7f]
          vrsqrt14pd 2032(%rdx), %xmm21

// CHECK: vrsqrt14pd 2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4e,0xaa,0x00,0x08,0x00,0x00]
          vrsqrt14pd 2048(%rdx), %xmm21

// CHECK: vrsqrt14pd -2048(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4e,0x6a,0x80]
          vrsqrt14pd -2048(%rdx), %xmm21

// CHECK: vrsqrt14pd -2064(%rdx), %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x08,0x4e,0xaa,0xf0,0xf7,0xff,0xff]
          vrsqrt14pd -2064(%rdx), %xmm21

// CHECK: vrsqrt14pd 1016(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4e,0x6a,0x7f]
          vrsqrt14pd 1016(%rdx){1to2}, %xmm21

// CHECK: vrsqrt14pd 1024(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4e,0xaa,0x00,0x04,0x00,0x00]
          vrsqrt14pd 1024(%rdx){1to2}, %xmm21

// CHECK: vrsqrt14pd -1024(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4e,0x6a,0x80]
          vrsqrt14pd -1024(%rdx){1to2}, %xmm21

// CHECK: vrsqrt14pd -1032(%rdx){1to2}, %xmm21
// CHECK:  encoding: [0x62,0xe2,0xfd,0x18,0x4e,0xaa,0xf8,0xfb,0xff,0xff]
          vrsqrt14pd -1032(%rdx){1to2}, %xmm21

// CHECK: vrsqrt14pd %ymm19, %ymm18
// CHECK:  encoding: [0x62,0xa2,0xfd,0x28,0x4e,0xd3]
          vrsqrt14pd %ymm19, %ymm18

// CHECK: vrsqrt14pd %ymm19, %ymm18 {%k4}
// CHECK:  encoding: [0x62,0xa2,0xfd,0x2c,0x4e,0xd3]
          vrsqrt14pd %ymm19, %ymm18 {%k4}

// CHECK: vrsqrt14pd %ymm19, %ymm18 {%k4} {z}
// CHECK:  encoding: [0x62,0xa2,0xfd,0xac,0x4e,0xd3]
          vrsqrt14pd %ymm19, %ymm18 {%k4} {z}

// CHECK: vrsqrt14pd (%rcx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4e,0x11]
          vrsqrt14pd (%rcx), %ymm18

// CHECK: vrsqrt14pd 291(%rax,%r14,8), %ymm18
// CHECK:  encoding: [0x62,0xa2,0xfd,0x28,0x4e,0x94,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14pd 291(%rax,%r14,8), %ymm18

// CHECK: vrsqrt14pd (%rcx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4e,0x11]
          vrsqrt14pd (%rcx){1to4}, %ymm18

// CHECK: vrsqrt14pd 4064(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4e,0x52,0x7f]
          vrsqrt14pd 4064(%rdx), %ymm18

// CHECK: vrsqrt14pd 4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4e,0x92,0x00,0x10,0x00,0x00]
          vrsqrt14pd 4096(%rdx), %ymm18

// CHECK: vrsqrt14pd -4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4e,0x52,0x80]
          vrsqrt14pd -4096(%rdx), %ymm18

// CHECK: vrsqrt14pd -4128(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x28,0x4e,0x92,0xe0,0xef,0xff,0xff]
          vrsqrt14pd -4128(%rdx), %ymm18

// CHECK: vrsqrt14pd 1016(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4e,0x52,0x7f]
          vrsqrt14pd 1016(%rdx){1to4}, %ymm18

// CHECK: vrsqrt14pd 1024(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4e,0x92,0x00,0x04,0x00,0x00]
          vrsqrt14pd 1024(%rdx){1to4}, %ymm18

// CHECK: vrsqrt14pd -1024(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4e,0x52,0x80]
          vrsqrt14pd -1024(%rdx){1to4}, %ymm18

// CHECK: vrsqrt14pd -1032(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe2,0xfd,0x38,0x4e,0x92,0xf8,0xfb,0xff,0xff]
          vrsqrt14pd -1032(%rdx){1to4}, %ymm18

// CHECK: vrsqrt14ps %xmm20, %xmm19
// CHECK:  encoding: [0x62,0xa2,0x7d,0x08,0x4e,0xdc]
          vrsqrt14ps %xmm20, %xmm19

// CHECK: vrsqrt14ps %xmm20, %xmm19 {%k7}
// CHECK:  encoding: [0x62,0xa2,0x7d,0x0f,0x4e,0xdc]
          vrsqrt14ps %xmm20, %xmm19 {%k7}

// CHECK: vrsqrt14ps %xmm20, %xmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0xa2,0x7d,0x8f,0x4e,0xdc]
          vrsqrt14ps %xmm20, %xmm19 {%k7} {z}

// CHECK: vrsqrt14ps (%rcx), %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x4e,0x19]
          vrsqrt14ps (%rcx), %xmm19

// CHECK: vrsqrt14ps 291(%rax,%r14,8), %xmm19
// CHECK:  encoding: [0x62,0xa2,0x7d,0x08,0x4e,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14ps 291(%rax,%r14,8), %xmm19

// CHECK: vrsqrt14ps (%rcx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x18,0x4e,0x19]
          vrsqrt14ps (%rcx){1to4}, %xmm19

// CHECK: vrsqrt14ps 2032(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x4e,0x5a,0x7f]
          vrsqrt14ps 2032(%rdx), %xmm19

// CHECK: vrsqrt14ps 2048(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x4e,0x9a,0x00,0x08,0x00,0x00]
          vrsqrt14ps 2048(%rdx), %xmm19

// CHECK: vrsqrt14ps -2048(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x4e,0x5a,0x80]
          vrsqrt14ps -2048(%rdx), %xmm19

// CHECK: vrsqrt14ps -2064(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x08,0x4e,0x9a,0xf0,0xf7,0xff,0xff]
          vrsqrt14ps -2064(%rdx), %xmm19

// CHECK: vrsqrt14ps 508(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x18,0x4e,0x5a,0x7f]
          vrsqrt14ps 508(%rdx){1to4}, %xmm19

// CHECK: vrsqrt14ps 512(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x18,0x4e,0x9a,0x00,0x02,0x00,0x00]
          vrsqrt14ps 512(%rdx){1to4}, %xmm19

// CHECK: vrsqrt14ps -512(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x18,0x4e,0x5a,0x80]
          vrsqrt14ps -512(%rdx){1to4}, %xmm19

// CHECK: vrsqrt14ps -516(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe2,0x7d,0x18,0x4e,0x9a,0xfc,0xfd,0xff,0xff]
          vrsqrt14ps -516(%rdx){1to4}, %xmm19

// CHECK: vrsqrt14ps %ymm18, %ymm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x4e,0xda]
          vrsqrt14ps %ymm18, %ymm27

// CHECK: vrsqrt14ps %ymm18, %ymm27 {%k7}
// CHECK:  encoding: [0x62,0x22,0x7d,0x2f,0x4e,0xda]
          vrsqrt14ps %ymm18, %ymm27 {%k7}

// CHECK: vrsqrt14ps %ymm18, %ymm27 {%k7} {z}
// CHECK:  encoding: [0x62,0x22,0x7d,0xaf,0x4e,0xda]
          vrsqrt14ps %ymm18, %ymm27 {%k7} {z}

// CHECK: vrsqrt14ps (%rcx), %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4e,0x19]
          vrsqrt14ps (%rcx), %ymm27

// CHECK: vrsqrt14ps 291(%rax,%r14,8), %ymm27
// CHECK:  encoding: [0x62,0x22,0x7d,0x28,0x4e,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vrsqrt14ps 291(%rax,%r14,8), %ymm27

// CHECK: vrsqrt14ps (%rcx){1to8}, %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4e,0x19]
          vrsqrt14ps (%rcx){1to8}, %ymm27

// CHECK: vrsqrt14ps 4064(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4e,0x5a,0x7f]
          vrsqrt14ps 4064(%rdx), %ymm27

// CHECK: vrsqrt14ps 4096(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4e,0x9a,0x00,0x10,0x00,0x00]
          vrsqrt14ps 4096(%rdx), %ymm27

// CHECK: vrsqrt14ps -4096(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4e,0x5a,0x80]
          vrsqrt14ps -4096(%rdx), %ymm27

// CHECK: vrsqrt14ps -4128(%rdx), %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x28,0x4e,0x9a,0xe0,0xef,0xff,0xff]
          vrsqrt14ps -4128(%rdx), %ymm27

// CHECK: vrsqrt14ps 508(%rdx){1to8}, %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4e,0x5a,0x7f]
          vrsqrt14ps 508(%rdx){1to8}, %ymm27

// CHECK: vrsqrt14ps 512(%rdx){1to8}, %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4e,0x9a,0x00,0x02,0x00,0x00]
          vrsqrt14ps 512(%rdx){1to8}, %ymm27

// CHECK: vrsqrt14ps -512(%rdx){1to8}, %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4e,0x5a,0x80]
          vrsqrt14ps -512(%rdx){1to8}, %ymm27

// CHECK: vrsqrt14ps -516(%rdx){1to8}, %ymm27
// CHECK:  encoding: [0x62,0x62,0x7d,0x38,0x4e,0x9a,0xfc,0xfd,0xff,0xff]
          vrsqrt14ps -516(%rdx){1to8}, %ymm27

// CHECK: vsqrtpd %xmm26, %xmm29
// CHECK:  encoding: [0x62,0x01,0xfd,0x08,0x51,0xea]
          vsqrtpd %xmm26, %xmm29

// CHECK: vsqrtpd %xmm26, %xmm29 {%k3}
// CHECK:  encoding: [0x62,0x01,0xfd,0x0b,0x51,0xea]
          vsqrtpd %xmm26, %xmm29 {%k3}

// CHECK: vsqrtpd %xmm26, %xmm29 {%k3} {z}
// CHECK:  encoding: [0x62,0x01,0xfd,0x8b,0x51,0xea]
          vsqrtpd %xmm26, %xmm29 {%k3} {z}

// CHECK: vsqrtpd (%rcx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x51,0x29]
          vsqrtpd (%rcx), %xmm29

// CHECK: vsqrtpd 291(%rax,%r14,8), %xmm29
// CHECK:  encoding: [0x62,0x21,0xfd,0x08,0x51,0xac,0xf0,0x23,0x01,0x00,0x00]
          vsqrtpd 291(%rax,%r14,8), %xmm29

// CHECK: vsqrtpd (%rcx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x51,0x29]
          vsqrtpd (%rcx){1to2}, %xmm29

// CHECK: vsqrtpd 2032(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x51,0x6a,0x7f]
          vsqrtpd 2032(%rdx), %xmm29

// CHECK: vsqrtpd 2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x51,0xaa,0x00,0x08,0x00,0x00]
          vsqrtpd 2048(%rdx), %xmm29

// CHECK: vsqrtpd -2048(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x51,0x6a,0x80]
          vsqrtpd -2048(%rdx), %xmm29

// CHECK: vsqrtpd -2064(%rdx), %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x08,0x51,0xaa,0xf0,0xf7,0xff,0xff]
          vsqrtpd -2064(%rdx), %xmm29

// CHECK: vsqrtpd 1016(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x51,0x6a,0x7f]
          vsqrtpd 1016(%rdx){1to2}, %xmm29

// CHECK: vsqrtpd 1024(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x51,0xaa,0x00,0x04,0x00,0x00]
          vsqrtpd 1024(%rdx){1to2}, %xmm29

// CHECK: vsqrtpd -1024(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x51,0x6a,0x80]
          vsqrtpd -1024(%rdx){1to2}, %xmm29

// CHECK: vsqrtpd -1032(%rdx){1to2}, %xmm29
// CHECK:  encoding: [0x62,0x61,0xfd,0x18,0x51,0xaa,0xf8,0xfb,0xff,0xff]
          vsqrtpd -1032(%rdx){1to2}, %xmm29

// CHECK: vsqrtpd %ymm20, %ymm18
// CHECK:  encoding: [0x62,0xa1,0xfd,0x28,0x51,0xd4]
          vsqrtpd %ymm20, %ymm18

// CHECK: vsqrtpd %ymm20, %ymm18 {%k3}
// CHECK:  encoding: [0x62,0xa1,0xfd,0x2b,0x51,0xd4]
          vsqrtpd %ymm20, %ymm18 {%k3}

// CHECK: vsqrtpd %ymm20, %ymm18 {%k3} {z}
// CHECK:  encoding: [0x62,0xa1,0xfd,0xab,0x51,0xd4]
          vsqrtpd %ymm20, %ymm18 {%k3} {z}

// CHECK: vsqrtpd (%rcx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x51,0x11]
          vsqrtpd (%rcx), %ymm18

// CHECK: vsqrtpd 291(%rax,%r14,8), %ymm18
// CHECK:  encoding: [0x62,0xa1,0xfd,0x28,0x51,0x94,0xf0,0x23,0x01,0x00,0x00]
          vsqrtpd 291(%rax,%r14,8), %ymm18

// CHECK: vsqrtpd (%rcx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x51,0x11]
          vsqrtpd (%rcx){1to4}, %ymm18

// CHECK: vsqrtpd 4064(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x51,0x52,0x7f]
          vsqrtpd 4064(%rdx), %ymm18

// CHECK: vsqrtpd 4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x51,0x92,0x00,0x10,0x00,0x00]
          vsqrtpd 4096(%rdx), %ymm18

// CHECK: vsqrtpd -4096(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x51,0x52,0x80]
          vsqrtpd -4096(%rdx), %ymm18

// CHECK: vsqrtpd -4128(%rdx), %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x51,0x92,0xe0,0xef,0xff,0xff]
          vsqrtpd -4128(%rdx), %ymm18

// CHECK: vsqrtpd 1016(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x51,0x52,0x7f]
          vsqrtpd 1016(%rdx){1to4}, %ymm18

// CHECK: vsqrtpd 1024(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x51,0x92,0x00,0x04,0x00,0x00]
          vsqrtpd 1024(%rdx){1to4}, %ymm18

// CHECK: vsqrtpd -1024(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x51,0x52,0x80]
          vsqrtpd -1024(%rdx){1to4}, %ymm18

// CHECK: vsqrtpd -1032(%rdx){1to4}, %ymm18
// CHECK:  encoding: [0x62,0xe1,0xfd,0x38,0x51,0x92,0xf8,0xfb,0xff,0xff]
          vsqrtpd -1032(%rdx){1to4}, %ymm18

// CHECK: vsqrtps %xmm28, %xmm19
// CHECK:  encoding: [0x62,0x81,0x7c,0x08,0x51,0xdc]
          vsqrtps %xmm28, %xmm19

// CHECK: vsqrtps %xmm28, %xmm19 {%k7}
// CHECK:  encoding: [0x62,0x81,0x7c,0x0f,0x51,0xdc]
          vsqrtps %xmm28, %xmm19 {%k7}

// CHECK: vsqrtps %xmm28, %xmm19 {%k7} {z}
// CHECK:  encoding: [0x62,0x81,0x7c,0x8f,0x51,0xdc]
          vsqrtps %xmm28, %xmm19 {%k7} {z}

// CHECK: vsqrtps (%rcx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x51,0x19]
          vsqrtps (%rcx), %xmm19

// CHECK: vsqrtps 291(%rax,%r14,8), %xmm19
// CHECK:  encoding: [0x62,0xa1,0x7c,0x08,0x51,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vsqrtps 291(%rax,%r14,8), %xmm19

// CHECK: vsqrtps (%rcx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x18,0x51,0x19]
          vsqrtps (%rcx){1to4}, %xmm19

// CHECK: vsqrtps 2032(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x51,0x5a,0x7f]
          vsqrtps 2032(%rdx), %xmm19

// CHECK: vsqrtps 2048(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x51,0x9a,0x00,0x08,0x00,0x00]
          vsqrtps 2048(%rdx), %xmm19

// CHECK: vsqrtps -2048(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x51,0x5a,0x80]
          vsqrtps -2048(%rdx), %xmm19

// CHECK: vsqrtps -2064(%rdx), %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x08,0x51,0x9a,0xf0,0xf7,0xff,0xff]
          vsqrtps -2064(%rdx), %xmm19

// CHECK: vsqrtps 508(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x18,0x51,0x5a,0x7f]
          vsqrtps 508(%rdx){1to4}, %xmm19

// CHECK: vsqrtps 512(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x18,0x51,0x9a,0x00,0x02,0x00,0x00]
          vsqrtps 512(%rdx){1to4}, %xmm19

// CHECK: vsqrtps -512(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x18,0x51,0x5a,0x80]
          vsqrtps -512(%rdx){1to4}, %xmm19

// CHECK: vsqrtps -516(%rdx){1to4}, %xmm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x18,0x51,0x9a,0xfc,0xfd,0xff,0xff]
          vsqrtps -516(%rdx){1to4}, %xmm19

// CHECK: vsqrtps %ymm25, %ymm19
// CHECK:  encoding: [0x62,0x81,0x7c,0x28,0x51,0xd9]
          vsqrtps %ymm25, %ymm19

// CHECK: vsqrtps %ymm25, %ymm19 {%k2}
// CHECK:  encoding: [0x62,0x81,0x7c,0x2a,0x51,0xd9]
          vsqrtps %ymm25, %ymm19 {%k2}

// CHECK: vsqrtps %ymm25, %ymm19 {%k2} {z}
// CHECK:  encoding: [0x62,0x81,0x7c,0xaa,0x51,0xd9]
          vsqrtps %ymm25, %ymm19 {%k2} {z}

// CHECK: vsqrtps (%rcx), %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x51,0x19]
          vsqrtps (%rcx), %ymm19

// CHECK: vsqrtps 291(%rax,%r14,8), %ymm19
// CHECK:  encoding: [0x62,0xa1,0x7c,0x28,0x51,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vsqrtps 291(%rax,%r14,8), %ymm19

// CHECK: vsqrtps (%rcx){1to8}, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x38,0x51,0x19]
          vsqrtps (%rcx){1to8}, %ymm19

// CHECK: vsqrtps 4064(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x51,0x5a,0x7f]
          vsqrtps 4064(%rdx), %ymm19

// CHECK: vsqrtps 4096(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x51,0x9a,0x00,0x10,0x00,0x00]
          vsqrtps 4096(%rdx), %ymm19

// CHECK: vsqrtps -4096(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x51,0x5a,0x80]
          vsqrtps -4096(%rdx), %ymm19

// CHECK: vsqrtps -4128(%rdx), %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x51,0x9a,0xe0,0xef,0xff,0xff]
          vsqrtps -4128(%rdx), %ymm19

// CHECK: vsqrtps 508(%rdx){1to8}, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x38,0x51,0x5a,0x7f]
          vsqrtps 508(%rdx){1to8}, %ymm19

// CHECK: vsqrtps 512(%rdx){1to8}, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x38,0x51,0x9a,0x00,0x02,0x00,0x00]
          vsqrtps 512(%rdx){1to8}, %ymm19

// CHECK: vsqrtps -512(%rdx){1to8}, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x38,0x51,0x5a,0x80]
          vsqrtps -512(%rdx){1to8}, %ymm19

// CHECK: vsqrtps -516(%rdx){1to8}, %ymm19
// CHECK:  encoding: [0x62,0xe1,0x7c,0x38,0x51,0x9a,0xfc,0xfd,0xff,0xff]
          vsqrtps -516(%rdx){1to8}, %ymm19

// CHECK: vsubpd %xmm18, %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x21,0xbd,0x00,0x5c,0xe2]
          vsubpd %xmm18, %xmm24, %xmm28

// CHECK: vsubpd %xmm18, %xmm24, %xmm28 {%k3}
// CHECK:  encoding: [0x62,0x21,0xbd,0x03,0x5c,0xe2]
          vsubpd %xmm18, %xmm24, %xmm28 {%k3}

// CHECK: vsubpd %xmm18, %xmm24, %xmm28 {%k3} {z}
// CHECK:  encoding: [0x62,0x21,0xbd,0x83,0x5c,0xe2]
          vsubpd %xmm18, %xmm24, %xmm28 {%k3} {z}

// CHECK: vsubpd (%rcx), %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x00,0x5c,0x21]
          vsubpd (%rcx), %xmm24, %xmm28

// CHECK: vsubpd 291(%rax,%r14,8), %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x21,0xbd,0x00,0x5c,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vsubpd 291(%rax,%r14,8), %xmm24, %xmm28

// CHECK: vsubpd (%rcx){1to2}, %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x10,0x5c,0x21]
          vsubpd (%rcx){1to2}, %xmm24, %xmm28

// CHECK: vsubpd 2032(%rdx), %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x00,0x5c,0x62,0x7f]
          vsubpd 2032(%rdx), %xmm24, %xmm28

// CHECK: vsubpd 2048(%rdx), %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x00,0x5c,0xa2,0x00,0x08,0x00,0x00]
          vsubpd 2048(%rdx), %xmm24, %xmm28

// CHECK: vsubpd -2048(%rdx), %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x00,0x5c,0x62,0x80]
          vsubpd -2048(%rdx), %xmm24, %xmm28

// CHECK: vsubpd -2064(%rdx), %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x00,0x5c,0xa2,0xf0,0xf7,0xff,0xff]
          vsubpd -2064(%rdx), %xmm24, %xmm28

// CHECK: vsubpd 1016(%rdx){1to2}, %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x10,0x5c,0x62,0x7f]
          vsubpd 1016(%rdx){1to2}, %xmm24, %xmm28

// CHECK: vsubpd 1024(%rdx){1to2}, %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x10,0x5c,0xa2,0x00,0x04,0x00,0x00]
          vsubpd 1024(%rdx){1to2}, %xmm24, %xmm28

// CHECK: vsubpd -1024(%rdx){1to2}, %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x10,0x5c,0x62,0x80]
          vsubpd -1024(%rdx){1to2}, %xmm24, %xmm28

// CHECK: vsubpd -1032(%rdx){1to2}, %xmm24, %xmm28
// CHECK:  encoding: [0x62,0x61,0xbd,0x10,0x5c,0xa2,0xf8,0xfb,0xff,0xff]
          vsubpd -1032(%rdx){1to2}, %xmm24, %xmm28

// CHECK: vsubpd %ymm25, %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x01,0x9d,0x20,0x5c,0xf1]
          vsubpd %ymm25, %ymm28, %ymm30

// CHECK: vsubpd %ymm25, %ymm28, %ymm30 {%k7}
// CHECK:  encoding: [0x62,0x01,0x9d,0x27,0x5c,0xf1]
          vsubpd %ymm25, %ymm28, %ymm30 {%k7}

// CHECK: vsubpd %ymm25, %ymm28, %ymm30 {%k7} {z}
// CHECK:  encoding: [0x62,0x01,0x9d,0xa7,0x5c,0xf1]
          vsubpd %ymm25, %ymm28, %ymm30 {%k7} {z}

// CHECK: vsubpd (%rcx), %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x20,0x5c,0x31]
          vsubpd (%rcx), %ymm28, %ymm30

// CHECK: vsubpd 291(%rax,%r14,8), %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x21,0x9d,0x20,0x5c,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vsubpd 291(%rax,%r14,8), %ymm28, %ymm30

// CHECK: vsubpd (%rcx){1to4}, %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x30,0x5c,0x31]
          vsubpd (%rcx){1to4}, %ymm28, %ymm30

// CHECK: vsubpd 4064(%rdx), %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x20,0x5c,0x72,0x7f]
          vsubpd 4064(%rdx), %ymm28, %ymm30

// CHECK: vsubpd 4096(%rdx), %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x20,0x5c,0xb2,0x00,0x10,0x00,0x00]
          vsubpd 4096(%rdx), %ymm28, %ymm30

// CHECK: vsubpd -4096(%rdx), %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x20,0x5c,0x72,0x80]
          vsubpd -4096(%rdx), %ymm28, %ymm30

// CHECK: vsubpd -4128(%rdx), %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x20,0x5c,0xb2,0xe0,0xef,0xff,0xff]
          vsubpd -4128(%rdx), %ymm28, %ymm30

// CHECK: vsubpd 1016(%rdx){1to4}, %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x30,0x5c,0x72,0x7f]
          vsubpd 1016(%rdx){1to4}, %ymm28, %ymm30

// CHECK: vsubpd 1024(%rdx){1to4}, %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x30,0x5c,0xb2,0x00,0x04,0x00,0x00]
          vsubpd 1024(%rdx){1to4}, %ymm28, %ymm30

// CHECK: vsubpd -1024(%rdx){1to4}, %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x30,0x5c,0x72,0x80]
          vsubpd -1024(%rdx){1to4}, %ymm28, %ymm30

// CHECK: vsubpd -1032(%rdx){1to4}, %ymm28, %ymm30
// CHECK:  encoding: [0x62,0x61,0x9d,0x30,0x5c,0xb2,0xf8,0xfb,0xff,0xff]
          vsubpd -1032(%rdx){1to4}, %ymm28, %ymm30

// CHECK: vsubps %xmm25, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0x81,0x14,0x00,0x5c,0xe1]
          vsubps %xmm25, %xmm29, %xmm20

// CHECK: vsubps %xmm25, %xmm29, %xmm20 {%k3}
// CHECK:  encoding: [0x62,0x81,0x14,0x03,0x5c,0xe1]
          vsubps %xmm25, %xmm29, %xmm20 {%k3}

// CHECK: vsubps %xmm25, %xmm29, %xmm20 {%k3} {z}
// CHECK:  encoding: [0x62,0x81,0x14,0x83,0x5c,0xe1]
          vsubps %xmm25, %xmm29, %xmm20 {%k3} {z}

// CHECK: vsubps (%rcx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x00,0x5c,0x21]
          vsubps (%rcx), %xmm29, %xmm20

// CHECK: vsubps 291(%rax,%r14,8), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xa1,0x14,0x00,0x5c,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vsubps 291(%rax,%r14,8), %xmm29, %xmm20

// CHECK: vsubps (%rcx){1to4}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x10,0x5c,0x21]
          vsubps (%rcx){1to4}, %xmm29, %xmm20

// CHECK: vsubps 2032(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x00,0x5c,0x62,0x7f]
          vsubps 2032(%rdx), %xmm29, %xmm20

// CHECK: vsubps 2048(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x00,0x5c,0xa2,0x00,0x08,0x00,0x00]
          vsubps 2048(%rdx), %xmm29, %xmm20

// CHECK: vsubps -2048(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x00,0x5c,0x62,0x80]
          vsubps -2048(%rdx), %xmm29, %xmm20

// CHECK: vsubps -2064(%rdx), %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x00,0x5c,0xa2,0xf0,0xf7,0xff,0xff]
          vsubps -2064(%rdx), %xmm29, %xmm20

// CHECK: vsubps 508(%rdx){1to4}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x10,0x5c,0x62,0x7f]
          vsubps 508(%rdx){1to4}, %xmm29, %xmm20

// CHECK: vsubps 512(%rdx){1to4}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x10,0x5c,0xa2,0x00,0x02,0x00,0x00]
          vsubps 512(%rdx){1to4}, %xmm29, %xmm20

// CHECK: vsubps -512(%rdx){1to4}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x10,0x5c,0x62,0x80]
          vsubps -512(%rdx){1to4}, %xmm29, %xmm20

// CHECK: vsubps -516(%rdx){1to4}, %xmm29, %xmm20
// CHECK:  encoding: [0x62,0xe1,0x14,0x10,0x5c,0xa2,0xfc,0xfd,0xff,0xff]
          vsubps -516(%rdx){1to4}, %xmm29, %xmm20

// CHECK: vsubps %ymm22, %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xa1,0x54,0x20,0x5c,0xee]
          vsubps %ymm22, %ymm21, %ymm21

// CHECK: vsubps %ymm22, %ymm21, %ymm21 {%k4}
// CHECK:  encoding: [0x62,0xa1,0x54,0x24,0x5c,0xee]
          vsubps %ymm22, %ymm21, %ymm21 {%k4}

// CHECK: vsubps %ymm22, %ymm21, %ymm21 {%k4} {z}
// CHECK:  encoding: [0x62,0xa1,0x54,0xa4,0x5c,0xee]
          vsubps %ymm22, %ymm21, %ymm21 {%k4} {z}

// CHECK: vsubps (%rcx), %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x20,0x5c,0x29]
          vsubps (%rcx), %ymm21, %ymm21

// CHECK: vsubps 291(%rax,%r14,8), %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xa1,0x54,0x20,0x5c,0xac,0xf0,0x23,0x01,0x00,0x00]
          vsubps 291(%rax,%r14,8), %ymm21, %ymm21

// CHECK: vsubps (%rcx){1to8}, %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x30,0x5c,0x29]
          vsubps (%rcx){1to8}, %ymm21, %ymm21

// CHECK: vsubps 4064(%rdx), %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x20,0x5c,0x6a,0x7f]
          vsubps 4064(%rdx), %ymm21, %ymm21

// CHECK: vsubps 4096(%rdx), %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x20,0x5c,0xaa,0x00,0x10,0x00,0x00]
          vsubps 4096(%rdx), %ymm21, %ymm21

// CHECK: vsubps -4096(%rdx), %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x20,0x5c,0x6a,0x80]
          vsubps -4096(%rdx), %ymm21, %ymm21

// CHECK: vsubps -4128(%rdx), %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x20,0x5c,0xaa,0xe0,0xef,0xff,0xff]
          vsubps -4128(%rdx), %ymm21, %ymm21

// CHECK: vsubps 508(%rdx){1to8}, %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x30,0x5c,0x6a,0x7f]
          vsubps 508(%rdx){1to8}, %ymm21, %ymm21

// CHECK: vsubps 512(%rdx){1to8}, %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x30,0x5c,0xaa,0x00,0x02,0x00,0x00]
          vsubps 512(%rdx){1to8}, %ymm21, %ymm21

// CHECK: vsubps -512(%rdx){1to8}, %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x30,0x5c,0x6a,0x80]
          vsubps -512(%rdx){1to8}, %ymm21, %ymm21

// CHECK: vsubps -516(%rdx){1to8}, %ymm21, %ymm21
// CHECK:  encoding: [0x62,0xe1,0x54,0x30,0x5c,0xaa,0xfc,0xfd,0xff,0xff]
          vsubps -516(%rdx){1to8}, %ymm21, %ymm21

// CHECK: vmovapd %xmm22, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x29,0x31]
          vmovapd %xmm22, (%rcx)

// CHECK: vmovapd %xmm22, (%rcx) {%k2}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x0a,0x29,0x31]
          vmovapd %xmm22, (%rcx) {%k2}

// CHECK: vmovapd %xmm22, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x29,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovapd %xmm22, 291(%rax,%r14,8)

// CHECK: vmovapd %xmm22, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x29,0x72,0x7f]
          vmovapd %xmm22, 2032(%rdx)

// CHECK: vmovapd %xmm22, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x29,0xb2,0x00,0x08,0x00,0x00]
          vmovapd %xmm22, 2048(%rdx)

// CHECK: vmovapd %xmm22, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x29,0x72,0x80]
          vmovapd %xmm22, -2048(%rdx)

// CHECK: vmovapd %xmm22, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x29,0xb2,0xf0,0xf7,0xff,0xff]
          vmovapd %xmm22, -2064(%rdx)

// CHECK: vmovapd %ymm17, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x29,0x09]
          vmovapd %ymm17, (%rcx)

// CHECK: vmovapd %ymm17, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x2e,0x29,0x09]
          vmovapd %ymm17, (%rcx) {%k6}

// CHECK: vmovapd %ymm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x28,0x29,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovapd %ymm17, 291(%rax,%r14,8)

// CHECK: vmovapd %ymm17, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x29,0x4a,0x7f]
          vmovapd %ymm17, 4064(%rdx)

// CHECK: vmovapd %ymm17, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x29,0x8a,0x00,0x10,0x00,0x00]
          vmovapd %ymm17, 4096(%rdx)

// CHECK: vmovapd %ymm17, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x29,0x4a,0x80]
          vmovapd %ymm17, -4096(%rdx)

// CHECK: vmovapd %ymm17, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x28,0x29,0x8a,0xe0,0xef,0xff,0xff]
          vmovapd %ymm17, -4128(%rdx)

// CHECK: vmovaps %xmm29, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x29,0x29]
          vmovaps %xmm29, (%rcx)

// CHECK: vmovaps %xmm29, (%rcx) {%k5}
// CHECK:  encoding: [0x62,0x61,0x7c,0x0d,0x29,0x29]
          vmovaps %xmm29, (%rcx) {%k5}

// CHECK: vmovaps %xmm29, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7c,0x08,0x29,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovaps %xmm29, 291(%rax,%r14,8)

// CHECK: vmovaps %xmm29, 2032(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x29,0x6a,0x7f]
          vmovaps %xmm29, 2032(%rdx)

// CHECK: vmovaps %xmm29, 2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x29,0xaa,0x00,0x08,0x00,0x00]
          vmovaps %xmm29, 2048(%rdx)

// CHECK: vmovaps %xmm29, -2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x29,0x6a,0x80]
          vmovaps %xmm29, -2048(%rdx)

// CHECK: vmovaps %xmm29, -2064(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x29,0xaa,0xf0,0xf7,0xff,0xff]
          vmovaps %xmm29, -2064(%rdx)

// CHECK: vmovaps %ymm28, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x29,0x21]
          vmovaps %ymm28, (%rcx)

// CHECK: vmovaps %ymm28, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0x61,0x7c,0x2e,0x29,0x21]
          vmovaps %ymm28, (%rcx) {%k6}

// CHECK: vmovaps %ymm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7c,0x28,0x29,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovaps %ymm28, 291(%rax,%r14,8)

// CHECK: vmovaps %ymm28, 4064(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x29,0x62,0x7f]
          vmovaps %ymm28, 4064(%rdx)

// CHECK: vmovaps %ymm28, 4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x29,0xa2,0x00,0x10,0x00,0x00]
          vmovaps %ymm28, 4096(%rdx)

// CHECK: vmovaps %ymm28, -4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x29,0x62,0x80]
          vmovaps %ymm28, -4096(%rdx)

// CHECK: vmovaps %ymm28, -4128(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x28,0x29,0xa2,0xe0,0xef,0xff,0xff]
          vmovaps %ymm28, -4128(%rdx)

// CHECK: vmovdqa32 %xmm24, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x7f,0x01]
          vmovdqa32 %xmm24, (%rcx)

// CHECK: vmovdqa32 %xmm24, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0x61,0x7d,0x0f,0x7f,0x01]
          vmovdqa32 %xmm24, (%rcx) {%k7}

// CHECK: vmovdqa32 %xmm24, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7d,0x08,0x7f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 %xmm24, 291(%rax,%r14,8)

// CHECK: vmovdqa32 %xmm24, 2032(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x7f,0x42,0x7f]
          vmovdqa32 %xmm24, 2032(%rdx)

// CHECK: vmovdqa32 %xmm24, 2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x7f,0x82,0x00,0x08,0x00,0x00]
          vmovdqa32 %xmm24, 2048(%rdx)

// CHECK: vmovdqa32 %xmm24, -2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x7f,0x42,0x80]
          vmovdqa32 %xmm24, -2048(%rdx)

// CHECK: vmovdqa32 %xmm24, -2064(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x08,0x7f,0x82,0xf0,0xf7,0xff,0xff]
          vmovdqa32 %xmm24, -2064(%rdx)

// CHECK: vmovdqa32 %ymm29, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7f,0x29]
          vmovdqa32 %ymm29, (%rcx)

// CHECK: vmovdqa32 %ymm29, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0x61,0x7d,0x2f,0x7f,0x29]
          vmovdqa32 %ymm29, (%rcx) {%k7}

// CHECK: vmovdqa32 %ymm29, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7d,0x28,0x7f,0xac,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa32 %ymm29, 291(%rax,%r14,8)

// CHECK: vmovdqa32 %ymm29, 4064(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7f,0x6a,0x7f]
          vmovdqa32 %ymm29, 4064(%rdx)

// CHECK: vmovdqa32 %ymm29, 4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7f,0xaa,0x00,0x10,0x00,0x00]
          vmovdqa32 %ymm29, 4096(%rdx)

// CHECK: vmovdqa32 %ymm29, -4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7f,0x6a,0x80]
          vmovdqa32 %ymm29, -4096(%rdx)

// CHECK: vmovdqa32 %ymm29, -4128(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7d,0x28,0x7f,0xaa,0xe0,0xef,0xff,0xff]
          vmovdqa32 %ymm29, -4128(%rdx)

// CHECK: vmovdqa64 %xmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x7f,0x09]
          vmovdqa64 %xmm17, (%rcx)

// CHECK: vmovdqa64 %xmm17, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x0f,0x7f,0x09]
          vmovdqa64 %xmm17, (%rcx) {%k7}

// CHECK: vmovdqa64 %xmm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x7f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 %xmm17, 291(%rax,%r14,8)

// CHECK: vmovdqa64 %xmm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x7f,0x4a,0x7f]
          vmovdqa64 %xmm17, 2032(%rdx)

// CHECK: vmovdqa64 %xmm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x7f,0x8a,0x00,0x08,0x00,0x00]
          vmovdqa64 %xmm17, 2048(%rdx)

// CHECK: vmovdqa64 %xmm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x7f,0x4a,0x80]
          vmovdqa64 %xmm17, -2048(%rdx)

// CHECK: vmovdqa64 %xmm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x7f,0x8a,0xf0,0xf7,0xff,0xff]
          vmovdqa64 %xmm17, -2064(%rdx)

// CHECK: vmovdqa64 %ymm24, (%rcx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7f,0x01]
          vmovdqa64 %ymm24, (%rcx)

// CHECK: vmovdqa64 %ymm24, (%rcx) {%k2}
// CHECK:  encoding: [0x62,0x61,0xfd,0x2a,0x7f,0x01]
          vmovdqa64 %ymm24, (%rcx) {%k2}

// CHECK: vmovdqa64 %ymm24, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0xfd,0x28,0x7f,0x84,0xf0,0x23,0x01,0x00,0x00]
          vmovdqa64 %ymm24, 291(%rax,%r14,8)

// CHECK: vmovdqa64 %ymm24, 4064(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7f,0x42,0x7f]
          vmovdqa64 %ymm24, 4064(%rdx)

// CHECK: vmovdqa64 %ymm24, 4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7f,0x82,0x00,0x10,0x00,0x00]
          vmovdqa64 %ymm24, 4096(%rdx)

// CHECK: vmovdqa64 %ymm24, -4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7f,0x42,0x80]
          vmovdqa64 %ymm24, -4096(%rdx)

// CHECK: vmovdqa64 %ymm24, -4128(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x7f,0x82,0xe0,0xef,0xff,0xff]
          vmovdqa64 %ymm24, -4128(%rdx)

// CHECK: vmovdqu32 %xmm17, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x08,0x7f,0x09]
          vmovdqu32 %xmm17, (%rcx)

// CHECK: vmovdqu32 %xmm17, (%rcx) {%k4}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x0c,0x7f,0x09]
          vmovdqu32 %xmm17, (%rcx) {%k4}

// CHECK: vmovdqu32 %xmm17, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7e,0x08,0x7f,0x8c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 %xmm17, 291(%rax,%r14,8)

// CHECK: vmovdqu32 %xmm17, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x08,0x7f,0x4a,0x7f]
          vmovdqu32 %xmm17, 2032(%rdx)

// CHECK: vmovdqu32 %xmm17, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x08,0x7f,0x8a,0x00,0x08,0x00,0x00]
          vmovdqu32 %xmm17, 2048(%rdx)

// CHECK: vmovdqu32 %xmm17, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x08,0x7f,0x4a,0x80]
          vmovdqu32 %xmm17, -2048(%rdx)

// CHECK: vmovdqu32 %xmm17, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x08,0x7f,0x8a,0xf0,0xf7,0xff,0xff]
          vmovdqu32 %xmm17, -2064(%rdx)

// CHECK: vmovdqu32 %ymm20, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x7f,0x21]
          vmovdqu32 %ymm20, (%rcx)

// CHECK: vmovdqu32 %ymm20, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0xe1,0x7e,0x29,0x7f,0x21]
          vmovdqu32 %ymm20, (%rcx) {%k1}

// CHECK: vmovdqu32 %ymm20, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7e,0x28,0x7f,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu32 %ymm20, 291(%rax,%r14,8)

// CHECK: vmovdqu32 %ymm20, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x7f,0x62,0x7f]
          vmovdqu32 %ymm20, 4064(%rdx)

// CHECK: vmovdqu32 %ymm20, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x7f,0xa2,0x00,0x10,0x00,0x00]
          vmovdqu32 %ymm20, 4096(%rdx)

// CHECK: vmovdqu32 %ymm20, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x7f,0x62,0x80]
          vmovdqu32 %ymm20, -4096(%rdx)

// CHECK: vmovdqu32 %ymm20, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7e,0x28,0x7f,0xa2,0xe0,0xef,0xff,0xff]
          vmovdqu32 %ymm20, -4128(%rdx)

// CHECK: vmovdqu64 %xmm20, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7f,0x21]
          vmovdqu64 %xmm20, (%rcx)

// CHECK: vmovdqu64 %xmm20, (%rcx) {%k6}
// CHECK:  encoding: [0x62,0xe1,0xfe,0x0e,0x7f,0x21]
          vmovdqu64 %xmm20, (%rcx) {%k6}

// CHECK: vmovdqu64 %xmm20, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfe,0x08,0x7f,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 %xmm20, 291(%rax,%r14,8)

// CHECK: vmovdqu64 %xmm20, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7f,0x62,0x7f]
          vmovdqu64 %xmm20, 2032(%rdx)

// CHECK: vmovdqu64 %xmm20, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7f,0xa2,0x00,0x08,0x00,0x00]
          vmovdqu64 %xmm20, 2048(%rdx)

// CHECK: vmovdqu64 %xmm20, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7f,0x62,0x80]
          vmovdqu64 %xmm20, -2048(%rdx)

// CHECK: vmovdqu64 %xmm20, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x08,0x7f,0xa2,0xf0,0xf7,0xff,0xff]
          vmovdqu64 %xmm20, -2064(%rdx)

// CHECK: vmovdqu64 %ymm19, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0x7f,0x19]
          vmovdqu64 %ymm19, (%rcx)

// CHECK: vmovdqu64 %ymm19, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0xe1,0xfe,0x2f,0x7f,0x19]
          vmovdqu64 %ymm19, (%rcx) {%k7}

// CHECK: vmovdqu64 %ymm19, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfe,0x28,0x7f,0x9c,0xf0,0x23,0x01,0x00,0x00]
          vmovdqu64 %ymm19, 291(%rax,%r14,8)

// CHECK: vmovdqu64 %ymm19, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0x7f,0x5a,0x7f]
          vmovdqu64 %ymm19, 4064(%rdx)

// CHECK: vmovdqu64 %ymm19, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0x7f,0x9a,0x00,0x10,0x00,0x00]
          vmovdqu64 %ymm19, 4096(%rdx)

// CHECK: vmovdqu64 %ymm19, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0x7f,0x5a,0x80]
          vmovdqu64 %ymm19, -4096(%rdx)

// CHECK: vmovdqu64 %ymm19, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfe,0x28,0x7f,0x9a,0xe0,0xef,0xff,0xff]
          vmovdqu64 %ymm19, -4128(%rdx)

// CHECK: vmovupd %xmm22, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x11,0x31]
          vmovupd %xmm22, (%rcx)

// CHECK: vmovupd %xmm22, (%rcx) {%k7}
// CHECK:  encoding: [0x62,0xe1,0xfd,0x0f,0x11,0x31]
          vmovupd %xmm22, (%rcx) {%k7}

// CHECK: vmovupd %xmm22, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0xfd,0x08,0x11,0xb4,0xf0,0x23,0x01,0x00,0x00]
          vmovupd %xmm22, 291(%rax,%r14,8)

// CHECK: vmovupd %xmm22, 2032(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x11,0x72,0x7f]
          vmovupd %xmm22, 2032(%rdx)

// CHECK: vmovupd %xmm22, 2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x11,0xb2,0x00,0x08,0x00,0x00]
          vmovupd %xmm22, 2048(%rdx)

// CHECK: vmovupd %xmm22, -2048(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x11,0x72,0x80]
          vmovupd %xmm22, -2048(%rdx)

// CHECK: vmovupd %xmm22, -2064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0xfd,0x08,0x11,0xb2,0xf0,0xf7,0xff,0xff]
          vmovupd %xmm22, -2064(%rdx)

// CHECK: vmovupd %ymm28, (%rcx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x11,0x21]
          vmovupd %ymm28, (%rcx)

// CHECK: vmovupd %ymm28, (%rcx) {%k1}
// CHECK:  encoding: [0x62,0x61,0xfd,0x29,0x11,0x21]
          vmovupd %ymm28, (%rcx) {%k1}

// CHECK: vmovupd %ymm28, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0xfd,0x28,0x11,0xa4,0xf0,0x23,0x01,0x00,0x00]
          vmovupd %ymm28, 291(%rax,%r14,8)

// CHECK: vmovupd %ymm28, 4064(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x11,0x62,0x7f]
          vmovupd %ymm28, 4064(%rdx)

// CHECK: vmovupd %ymm28, 4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x11,0xa2,0x00,0x10,0x00,0x00]
          vmovupd %ymm28, 4096(%rdx)

// CHECK: vmovupd %ymm28, -4096(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x11,0x62,0x80]
          vmovupd %ymm28, -4096(%rdx)

// CHECK: vmovupd %ymm28, -4128(%rdx)
// CHECK:  encoding: [0x62,0x61,0xfd,0x28,0x11,0xa2,0xe0,0xef,0xff,0xff]
          vmovupd %ymm28, -4128(%rdx)

// CHECK: vmovups %xmm26, (%rcx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x11,0x11]
          vmovups %xmm26, (%rcx)

// CHECK: vmovups %xmm26, (%rcx) {%k5}
// CHECK:  encoding: [0x62,0x61,0x7c,0x0d,0x11,0x11]
          vmovups %xmm26, (%rcx) {%k5}

// CHECK: vmovups %xmm26, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0x21,0x7c,0x08,0x11,0x94,0xf0,0x23,0x01,0x00,0x00]
          vmovups %xmm26, 291(%rax,%r14,8)

// CHECK: vmovups %xmm26, 2032(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x11,0x52,0x7f]
          vmovups %xmm26, 2032(%rdx)

// CHECK: vmovups %xmm26, 2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x11,0x92,0x00,0x08,0x00,0x00]
          vmovups %xmm26, 2048(%rdx)

// CHECK: vmovups %xmm26, -2048(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x11,0x52,0x80]
          vmovups %xmm26, -2048(%rdx)

// CHECK: vmovups %xmm26, -2064(%rdx)
// CHECK:  encoding: [0x62,0x61,0x7c,0x08,0x11,0x92,0xf0,0xf7,0xff,0xff]
          vmovups %xmm26, -2064(%rdx)

// CHECK: vmovups %ymm23, (%rcx)
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x11,0x39]
          vmovups %ymm23, (%rcx)

// CHECK: vmovups %ymm23, (%rcx) {%k3}
// CHECK:  encoding: [0x62,0xe1,0x7c,0x2b,0x11,0x39]
          vmovups %ymm23, (%rcx) {%k3}

// CHECK: vmovups %ymm23, 291(%rax,%r14,8)
// CHECK:  encoding: [0x62,0xa1,0x7c,0x28,0x11,0xbc,0xf0,0x23,0x01,0x00,0x00]
          vmovups %ymm23, 291(%rax,%r14,8)

// CHECK: vmovups %ymm23, 4064(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x11,0x7a,0x7f]
          vmovups %ymm23, 4064(%rdx)

// CHECK: vmovups %ymm23, 4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x11,0xba,0x00,0x10,0x00,0x00]
          vmovups %ymm23, 4096(%rdx)

// CHECK: vmovups %ymm23, -4096(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x11,0x7a,0x80]
          vmovups %ymm23, -4096(%rdx)

// CHECK: vmovups %ymm23, -4128(%rdx)
// CHECK:  encoding: [0x62,0xe1,0x7c,0x28,0x11,0xba,0xe0,0xef,0xff,0xff]
          vmovups %ymm23, -4128(%rdx)
