/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef PMLPARSER_H_INCLUDED
#define PMLPARSER_H_INCLUDED

#include <string>
#include <vector>

#include <boost/scoped_ptr.hpp>
#include <boost/unordered_map.hpp>

#include "PDXParser.h"

class WPXDocumentInterface;
class WPXInputStream;

namespace libebook
{

struct PMLHeader;

class PMLParser : public PDXParser
{
public:
  typedef boost::unordered_map<std::string, std::vector<unsigned char> > ImageMap_t;

public:
  explicit PMLParser(WPXInputStream *input, WPXDocumentInterface *document = 0);
  virtual ~PMLParser();

  virtual bool isFormatSupported(unsigned type, unsigned creator);

  virtual void readAppInfoRecord(WPXInputStream *record);
  virtual void readSortInfoRecord(WPXInputStream *record);
  virtual void readIndexRecord(WPXInputStream *record);
  virtual void readDataRecord(WPXInputStream *record, bool last = false);

  virtual void readDataRecords();

private:
  void readText();
  void readImages();
  void readImage(WPXInputStream *record, bool verified = false);

  void openDocument();
  void closeDocument();

private:
  boost::scoped_ptr<PMLHeader> m_header;
  ImageMap_t m_imageMap;
};

} // namespace libebook

#endif // PMLPARSER_H_INCLUDED
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
