/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */


//

#include <pthread.h>
#include <string.h>            // for memcmp() et al
#include <stdlib.h>


#include "pkcs11types.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "tok_spec_struct.h"
#include "trace.h"


// Permutation of 0..255 constructed from the digits of pi. It gives a
// "random" nonlinear byte substitution operation.
//
static CK_BYTE S[256] = {
   41,  46,  67, 201, 162, 216, 124,   1,  61,  54,  84, 161, 236, 240,   6,
   19,  98, 167,   5, 243, 192, 199, 115, 140, 152, 147,  43, 217, 188,
   76, 130, 202,  30, 155,  87,  60, 253, 212, 224,  22, 103,  66, 111,  24,
  138,  23, 229,  18, 190,  78, 196, 214, 218, 158, 222,  73, 160, 251,
  245, 142, 187,  47, 238, 122, 169, 104, 121, 145,  21, 178,   7,  63,
  148, 194,  16, 137,  11,  34,  95,  33, 128, 127,  93, 154,  90, 144,  50,
   39,  53,  62, 204, 231, 191, 247, 151,   3, 255,  25,  48, 179,  72, 165,
  181, 209, 215,  94, 146,  42, 172,  86, 170, 198,  79, 184,  56, 210,
  150, 164, 125, 182, 118, 252, 107, 226, 156, 116,   4, 241,  69, 157,
  112,  89, 100, 113, 135,  32, 134,  91, 207, 101, 230,  45, 168,   2,  27,
   96,  37, 173, 174, 176, 185, 246,  28,  70,  97, 105,  52,  64, 126,  15,
   85,  71, 163,  35, 221,  81, 175,  58, 195,  92, 249, 206, 186, 197,
  234,  38,  44,  83,  13, 110, 133,  40, 132,   9, 211, 223, 205, 244,  65,
  129,  77,  82, 106, 220,  55, 200, 108, 193, 171, 250,  36, 225, 123,
    8,  12, 189, 177,  74, 120, 136, 149, 139, 227,  99, 232, 109, 233,
  203, 213, 254,  59,   0,  29,  57, 242, 239, 183,  14, 102,  88, 208, 228,
  166, 119, 114, 248, 235, 117,  75,  10,  49,  68,  80, 180, 143, 237,
   31,  26, 219, 153, 141,  51, 159,  17, 131,  20
};

static CK_BYTE *padding[] = {
  (CK_BYTE *)"",
  (CK_BYTE *)"\x01",
  (CK_BYTE *)"\x02\x02",
  (CK_BYTE *)"\x03\x03\x03",
  (CK_BYTE *)"\x04\x04\x04\x04",
  (CK_BYTE *)"\x05\x05\x05\x05\x05",
  (CK_BYTE *)"\x06\x06\x06\x06\x06\x06",
  (CK_BYTE *)"\x07\x07\x07\x07\x07\x07\x07",
  (CK_BYTE *)"\x08\x08\x08\x08\x08\x08\x08\x08",
  (CK_BYTE *)"\x09\x09\x09\x09\x09\x09\x09\x09\x09",
  (CK_BYTE *)"\x0a\x0a\x0a\x0a\x0a\x0a\x0a\x0a\x0a\x0a",
  (CK_BYTE *)"\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b\x0b",
  (CK_BYTE *)"\x0c\x0c\x0c\x0c\x0c\x0c\x0c\x0c\x0c\x0c\x0c\x0c",
  (CK_BYTE *)"\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d",
  (CK_BYTE *)"\x0e\x0e\x0e\x0e\x0e\x0e\x0e\x0e\x0e\x0e\x0e\x0e\x0e\x0e",
  (CK_BYTE *)"\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f",
  (CK_BYTE *)"\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10\x10"
};



//
//
CK_RV
md2_hash( SESSION         * sess,
          CK_BBOOL          length_only,
          DIGEST_CONTEXT  * ctx,
          CK_BYTE         * in_data,
          CK_ULONG          in_data_len,
          CK_BYTE         * out_data,
          CK_ULONG        * out_data_len )
{
   CK_RV     rc;


   if (!sess || !ctx || !out_data_len){
      TRACE_ERROR("%s received bad argument(s)\n", __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }

   if (length_only == TRUE) {
      *out_data_len = MD2_HASH_SIZE;
      return CKR_OK;
   }

   rc = md2_hash_update( sess, ctx, in_data, in_data_len );
   if (rc != CKR_OK){
      TRACE_DEVEL("md2_hash_update failed.\n");
      return CKR_FUNCTION_FAILED;
   }
   return md2_hash_final( sess,      FALSE,
                          ctx,
                          out_data,  out_data_len );
}


//
//
CK_RV
md2_hash_update( SESSION         * sess,
                 DIGEST_CONTEXT  * ctx,
                 CK_BYTE         * in_data,
                 CK_ULONG          in_data_len )
{
   if (!sess || !ctx || !in_data){
      TRACE_ERROR("%s received bad argument(s)\n", __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
   return ckm_md2_update( (MD2_CONTEXT *)ctx->context,
                          in_data, in_data_len );
}


//
//
CK_RV
md2_hash_final( SESSION         * sess,
                CK_BYTE           length_only,
                DIGEST_CONTEXT  * ctx,
                CK_BYTE         * out_data,
                CK_ULONG        * out_data_len )
{
   CK_RV      rc;

   if (!sess || !ctx || !out_data_len){
      TRACE_ERROR("%s received bad argument(s)\n", __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
   if (length_only == TRUE) {
      *out_data_len = MD2_HASH_SIZE;
      return CKR_OK;
   }

   rc = ckm_md2_final( (MD2_CONTEXT *)ctx->context,
                       out_data, MD2_HASH_SIZE );

   if (rc == CKR_OK) {
      *out_data_len = MD2_HASH_SIZE;
      return rc;
   }

   return rc;
}


// this routine gets called for two mechanisms actually:
//    CKM_MD2_HMAC
//    CKM_MD2_HMAC_GENERAL
//
CK_RV
md2_hmac_sign( SESSION              * sess,
               CK_BBOOL               length_only,
               SIGN_VERIFY_CONTEXT  * ctx,
               CK_BYTE              * in_data,
               CK_ULONG               in_data_len,
               CK_BYTE              * out_data,
               CK_ULONG             * out_data_len )
{
   OBJECT          * key_obj = NULL;
   CK_ATTRIBUTE       * attr    = NULL;
   CK_BYTE           hash[MD2_HASH_SIZE];
   DIGEST_CONTEXT    digest_ctx;
   CK_MECHANISM      digest_mech;
   CK_BYTE           k_ipad[MD2_BLOCK_SIZE];
   CK_BYTE           k_opad[MD2_BLOCK_SIZE];
   CK_ULONG          key_bytes, hash_len, hmac_len;
   CK_ULONG          i;
   CK_RV             rc;


   if (!sess || !ctx || !out_data_len){
      TRACE_ERROR("%s received bad argument(s)\n", __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }

   if (ctx->mech.mechanism == CKM_MD2_HMAC_GENERAL) {
      hmac_len = *(CK_ULONG *)ctx->mech.pParameter;

      if (hmac_len == 0)
      {
         *out_data_len = 0;
         return CKR_OK;
      }
   }
   else
      hmac_len = MD2_HASH_SIZE;


   if (length_only == TRUE) {
      *out_data_len = hmac_len;
      return CKR_OK;
   }

   memset( &digest_ctx, 0x0, sizeof(DIGEST_CONTEXT) );

   rc = object_mgr_find_in_map1( ctx->key, &key_obj );
   if (rc != CKR_OK){
      TRACE_ERROR("Failed to acquire key from specified handle");
      if (rc == CKR_OBJECT_HANDLE_INVALID)
	 return CKR_KEY_HANDLE_INVALID;
      else
         return rc;
   }
   rc = template_attribute_find( key_obj->template, CKA_VALUE, &attr );
   if (rc == FALSE){
      TRACE_ERROR("Could not find CKA_VALUE in the template\n");
      return CKR_FUNCTION_FAILED;
   }
   else
      key_bytes = attr->ulValueLen;


   // build (K XOR ipad), (K XOR opad)
   //
   if (key_bytes > MD2_BLOCK_SIZE)
   {
      digest_mech.mechanism      = CKM_MD2;
      digest_mech.ulParameterLen = 0;
      digest_mech.pParameter     = NULL;

      rc = digest_mgr_init( sess, &digest_ctx, &digest_mech );
      if (rc != CKR_OK){
	 TRACE_DEVEL("Digest Mgr Init failed.\n");
         return rc;
      }
      hash_len = sizeof(hash);
      rc = digest_mgr_digest( sess, FALSE, &digest_ctx,
                              attr->pValue, attr->ulValueLen,
                              hash,  &hash_len );
      if (rc != CKR_OK){
	 TRACE_DEVEL("Digest Mgr Digest failed.\n");
         return rc;
      }
      memset( &digest_ctx, 0x0, sizeof(DIGEST_CONTEXT) );

      for (i = 0; i < hash_len; i++)
      {
         k_ipad[i] = hash[i] ^ 0x36;
         k_opad[i] = hash[i] ^ 0x5C;
      }

      memset( &k_ipad[i], 0x36, MD2_BLOCK_SIZE - i);
      memset( &k_opad[i], 0x5C, MD2_BLOCK_SIZE - i);
   }
   else
   {
      CK_BYTE *key = (CK_BYTE *)attr + sizeof(CK_ATTRIBUTE);

      for (i = 0; i < key_bytes; i++)
      {
         k_ipad[i] = key[i] ^ 0x36;
         k_opad[i] = key[i] ^ 0x5C;
      }

      memset( &k_ipad[i], 0x36, MD2_BLOCK_SIZE - key_bytes );
      memset( &k_opad[i], 0x5C, MD2_BLOCK_SIZE - key_bytes );
   }

   digest_mech.mechanism      = CKM_MD2;
   digest_mech.ulParameterLen = 0;
   digest_mech.pParameter     = NULL;


   // inner hash
   //
   rc = digest_mgr_init( sess, &digest_ctx, &digest_mech );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Init failed.\n");
      return rc;
   }
   rc = digest_mgr_digest_update( sess, &digest_ctx, k_ipad, MD2_BLOCK_SIZE );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Update failed.\n");
      return rc;
   }
   rc = digest_mgr_digest_update( sess, &digest_ctx, in_data, in_data_len );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Update failed.\n");
      return rc;
   }
   hash_len = sizeof(hash);
   rc = digest_mgr_digest_final( sess, FALSE, &digest_ctx, hash, &hash_len );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Final failed.\n");
      return rc;
   }
   memset( &digest_ctx, 0x0, sizeof(DIGEST_CONTEXT) );


   // outer hash
   //
   rc = digest_mgr_init( sess, &digest_ctx, &digest_mech );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Init failed.\n");
      return rc;
   }
   rc = digest_mgr_digest_update( sess, &digest_ctx, k_opad, MD2_BLOCK_SIZE );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Update failed.\n");
      return rc;
   }
   rc = digest_mgr_digest_update( sess, &digest_ctx, hash, hash_len );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Update failed.\n");
      return rc;
   }
   hash_len = sizeof(hash);
   rc = digest_mgr_digest_final( sess, FALSE, &digest_ctx, hash, &hash_len );
   if (rc != CKR_OK){
      TRACE_DEVEL("Digest Mgr Final failed.\n");
      return rc;
   }
   memcpy( out_data, hash, hmac_len );
   *out_data_len = hmac_len;

   return CKR_OK;
}


//
//
CK_RV
md2_hmac_verify( SESSION              * sess,
                 SIGN_VERIFY_CONTEXT  * ctx,
                 CK_BYTE              * in_data,
                 CK_ULONG               in_data_len,
                 CK_BYTE              * signature,
                 CK_ULONG               sig_len )
{
   CK_BYTE              hmac[MD2_HASH_SIZE];
   SIGN_VERIFY_CONTEXT  hmac_ctx;
   CK_ULONG             hmac_len, len;
   CK_RV                rc;

   if (!sess || !ctx || !in_data || !signature){
      TRACE_ERROR("%s received bad argument(s)\n", __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
   if (ctx->mech.mechanism == CKM_MD2_HMAC_GENERAL)
      hmac_len = *(CK_ULONG *)ctx->mech.pParameter;
   else
      hmac_len = MD2_HASH_SIZE;

   memset( &hmac_ctx, 0, sizeof(SIGN_VERIFY_CONTEXT) );

   rc = sign_mgr_init( sess, &hmac_ctx, &ctx->mech, FALSE, ctx->key );
   if (rc != CKR_OK){
      TRACE_DEVEL("Sign Mgr Init failed.\n");
      return rc;
   }
   len = sizeof(hmac);
   rc = sign_mgr_sign( sess, FALSE, &hmac_ctx,
                       in_data, in_data_len,
                       hmac,   &len );
   if (rc != CKR_OK){
      TRACE_DEVEL("Sign Mgr Sign failed.\n");
      return rc;
   }
   if ((len != hmac_len) || (len != sig_len)){
      TRACE_ERROR("%s\n", ock_err(ERR_SIGNATURE_LEN_RANGE));
      return CKR_SIGNATURE_LEN_RANGE;
   }
   if (memcmp(hmac, signature, hmac_len) != 0){
      TRACE_ERROR("%s\n", ock_err(ERR_SIGNATURE_INVALID));
      return CKR_SIGNATURE_INVALID;
   }
   return CKR_OK;
}


//
// CKM routines
//


// MD2 block update operation. Continues an MD2 message-digest
//   operation, processing another message block, and updating the
//   context.
//
CK_RV
ckm_md2_update( MD2_CONTEXT  * context,
                CK_BYTE      * input,
                CK_ULONG       inputLen )
{
   CK_ULONG i, index, partLen;

   // Update number of bytes mod 16
   //
   index = context->count;
   context->count = (index + inputLen) & 0xf;

   partLen = 16 - index;

   // Process any complete 16-byte blocks
   //
   if (inputLen >= partLen)
   {
      memcpy( (CK_BYTE *)&context->buffer[index], (CK_BYTE *)input, partLen );
      ckm_md2_transform( context->state, context->checksum, context->buffer );

      for (i = partLen; i + 15 < inputLen; i += 16)
         ckm_md2_transform( context->state, context->checksum, &input[i] );

      index = 0;
   }
   else
      i = 0;

   // Buffer remaining input
   //
   memcpy( (CK_BYTE *)&context->buffer[index], (CK_BYTE *)&input[i], inputLen-i );

   return CKR_OK;
}


// MD2 finalization. Ends an MD2 message-digest operation, writing the
//   message digest and zeroizing the context.
//
CK_RV
ckm_md2_final( MD2_CONTEXT  * context,
               CK_BYTE      * out_data,
               CK_ULONG       out_data_len )
{
   CK_ULONG index, padLen;

   if (!context || !out_data || (out_data_len < MD2_HASH_SIZE)){
      TRACE_ERROR("%s received bad argument(s)\n", __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
   // Pad input to 16-byte multiple (1 - 16 pad bytes)
   //
   index = context->count;
   padLen = 16 - index;
   ckm_md2_update( context, padding[padLen], padLen );

   // Add checksum
   //
   ckm_md2_update( context, context->checksum, 16 );

   // Store state in digest
   //
   memcpy( (CK_BYTE *)out_data, (CK_BYTE *)context->state, 16 );

   return CKR_OK;
}


// MD2 basic transformation. Transforms state and updates checksum
//   based on block.
//
void
ckm_md2_transform( CK_BYTE  * state,
                   CK_BYTE  * checksum,
                   CK_BYTE  * block )
{
   CK_ULONG i, j, t;
   CK_BYTE  x[48];

   // Form encryption block from state, block, state ^ block.
   //
   memcpy( (CK_BYTE *)x,    (CK_BYTE *)state, 16 );
   memcpy( (CK_BYTE *)x+16, (CK_BYTE *)block, 16 );

   for (i = 0; i < 16; i++)
      x[i+32] = state[i] ^ block[i];

   // Encrypt block (18 rounds).
   //
   t = 0;
   for (i = 0; i < 18; i++) {
      for (j = 0; j < 48; j++)
         t = x[j] ^= S[t];
      t = (t + i) & 0xff;
   }

   // Save new state
   //
   memcpy( (CK_BYTE *)state, (CK_BYTE *)x, 16 );

   // Update checksum.
   //
   t = checksum[15];
   for (i = 0; i < 16; i++)
      t = checksum[i] ^= S[block[i] ^ t];

}

