#include "windows.h"
#include "stdafx.h"
#include "resource.h"
#include <hash_map>
#include "GrClient.h"
#include "ITextSource.h"
#include "SimpleTextSrc.h"
#include "IGrEngine.h"
#include "IGrJustifier.h"
#include "SegmentAux.h"
#include "Font.h"
#include "WinFont.h"
#include "Segment.h"
#include "SegmentPainter.h"
#include "WinSegmentPainter.h"

// for clipboard
#include <objidl.h>

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// The main windows class name

// keep this data between events
// note that dc should not be kept between events
LOGFONT g_lf;
unsigned short g_szFaceName[32];
int g_lfHeight;
bool g_fBold;
bool g_fItalic;

SimpleTextSrc * g_pgrtext;

Segment * g_pgrseg;
int g_cchSeg;  // how many characters fit in the segment

int g_ichwAnchor;	// insertion point index or anchor
int g_ichwEnd;		// end of range; == g_ichwAnchor if no range
bool g_bAssocPrev;

unsigned short g_szString[256];

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
void				GrInitialize(void);
//void				GrfxInit(HDC hdc, GrGraphics &grfx);
void				ResetStringAndSegment();

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	GrInitialize();
	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_SIMPLEEDIT, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_SIMPLEEDIT);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//  FUNCTION: MyRegisterClass()
//  PURPOSE: Registers the window class.
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_SIMPLEEDIT);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCTSTR)IDC_SIMPLEEDIT;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;
	WINDOWPLACEMENT wp;

	hInst = hInstance; // Store instance handle in our global variable

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
		return FALSE;
	}

	// put window in a convenient place on screen
	wp.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(hWnd, &wp); // fill in members not expicilty set below
	wp.rcNormalPosition.left = MulDiv(GetSystemMetrics(SM_CXSCREEN), 1, 4);
	wp.rcNormalPosition.right = MulDiv(GetSystemMetrics(SM_CXSCREEN), 3, 4);
	wp.rcNormalPosition.top = MulDiv(GetSystemMetrics(SM_CYSCREEN), 1, 4);
	wp.rcNormalPosition.bottom = MulDiv(GetSystemMetrics(SM_CYSCREEN), 3, 4);
	SetWindowPlacement(hWnd, &wp);

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	TCHAR szSimple[MAX_LOADSTRING];
	LoadString(hInst, IDS_SIMPLE, szSimple, MAX_LOADSTRING);

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_ABOUT:
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
					break;
				case IDM_EXIT:
					DestroyWindow(hWnd);
					break;
				default:
					return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;

		case WM_PAINT:
			{
			hdc = BeginPaint(hWnd, &ps);

			HFONT hfont = CreateFontIndirect(&g_lf);
			HFONT hfontOld = (HFONT)::SelectObject(hdc, hfont);
			// delete hfontOld??
			WinFont font(hdc);

			if (g_pgrseg == NULL)
            {
				// Create the segment.
				LayoutEnvironment layout;		// use all the defaults...
				layout.setDumbFallback(true);	// except that we want it to try its best, no matter what
				g_pgrseg = new RangeSegment(&font, g_pgrtext, &layout);
				g_pgrseg->advanceWidth();
				if (g_pgrseg == NULL)
					::MessageBox(hWnd, "Could not create segment.", "Error", MB_OK | MB_ICONEXCLAMATION);
			}
			
			WinSegmentPainter painter(g_pgrseg, hdc);
			painter.paint();

			if (g_ichwAnchor == g_ichwEnd)
			{
				painter.drawInsertionPoint(g_ichwAnchor, g_bAssocPrev, true, false);
			}
			else
			{
				float fontHeight = font.height();
				if (g_ichwAnchor >= g_ichwEnd) // todo: is this needed?
					painter.drawSelectionRange(g_ichwEnd, g_ichwAnchor,
						0, fontHeight, true);
				else
					painter.drawSelectionRange(g_ichwAnchor, g_ichwEnd,
						0, fontHeight, true);
			}

			//if (g_pgrseg)
			//	delete g_pgrseg;
			//g_pgrseg = NULL;
			
			EndPaint(hWnd, &ps); //cleans up dc
			break;
			}

		case WM_KEYDOWN:
			{
			hdc = GetDC(hWnd);
			HFONT hfont = CreateFontIndirect(&g_lf);
			HFONT hfontOld = (HFONT)::SelectObject(hdc, hfont);
			// delete hfontOld??
			WinFont font(hdc);
			WinSegmentPainter painter(g_pgrseg, hdc);

			SHORT shiftstate;
			shiftstate = GetKeyState(VK_SHIFT);
			bool bShift = (bool) (shiftstate & 0x8000);
			shiftstate = GetKeyState(VK_CONTROL);
			bool bCtl = (bool) (shiftstate & 0x8000);

			switch(wParam)
			{
				bool bRight;
				bool bInThisSeg;

				case VK_LEFT: // left & right arrow keys
				case VK_RIGHT:
					bRight = (wParam == VK_RIGHT);
					bInThisSeg = true;
					if (!bCtl) // no control key: visual movement
					{
						if (bShift)
						{
							bool bAssocPrev = (g_ichwAnchor == g_ichwEnd) ?
								bRight :
								(g_ichwEnd < g_ichwAnchor);
							g_ichwEnd = painter.extendSelectionPosition(g_ichwEnd, g_ichwEnd != 0,
								bAssocPrev, g_ichwAnchor, bRight, &bInThisSeg);
						}
						else
							g_ichwEnd = painter.arrowKeyPosition(g_ichwEnd, &g_bAssocPrev,
								bRight, &bInThisSeg);
					}
					else // control key: logical movement
					{
						int ichwMax = g_pgrtext->getLength();
						do {
							if (bRight)
							{
								if (g_ichwEnd == ichwMax)
									break;
								g_ichwEnd++;
							}
							else
							{
								if (g_ichwEnd == 0)
									break;
								g_ichwEnd--;
							}
						} while (painter.isValidInsertionPoint(g_ichwEnd) != kipvrOK);
						if (g_ichwEnd == 0)
							g_bAssocPrev = false;
						else if (g_ichwEnd == ichwMax)
							g_bAssocPrev = true;
					}

					if (!bShift)
						g_ichwAnchor = g_ichwEnd; // insertion point, not range

					InvalidateRect(hWnd, NULL, true);
					break;
				default:
					break;
			}

			ReleaseDC(hWnd, hdc);
			break;
			}
		case WM_CHAR:
			{
			SHORT shiftstate;
			shiftstate = GetKeyState(VK_SHIFT);
			bool bShift = (bool) (shiftstate & 0x8000);
			shiftstate = GetKeyState(VK_CONTROL);
			bool bCtl = (bool) (shiftstate & 0x8000);

			if (bCtl && wParam == 16) // CTRL-p
			{
				IDataObject * pdobj;
				::OleGetClipboard(&pdobj);
				pdobj->AddRef();

				// if there is a UNICODE string stored in the clipboard, paste it in.
				FORMATETC format;
				STGMEDIUM medium;
				format.cfFormat = CF_UNICODETEXT;
				format.ptd = NULL;
				format.dwAspect = DVASPECT_CONTENT;
				format.lindex = -1;
				format.tymed = TYMED_HGLOBAL;
				HRESULT hr = pdobj->GetData(&format, &medium);
				if (hr == S_OK)
				{
					if (medium.tymed == TYMED_HGLOBAL && medium.hGlobal)
					{
						// Convert the global memory string to a TsString without any formatting.
						const OLECHAR * pwszClip = (const OLECHAR *)::GlobalLock(medium.hGlobal);
						int cchw = wcslen(pwszClip);
						std::fill_n(g_szString, 255 , 0);
						if (cchw > 255)
							std::copy(pwszClip, pwszClip + 255, g_szString);
						else
							wcscpy(g_szString, pwszClip);
						::GlobalUnlock(medium.hGlobal);

						ResetStringAndSegment();
						g_ichwAnchor = 0;
						g_ichwEnd = 0;
						InvalidateRect(hWnd, NULL, true);
					}
					ReleaseStgMedium(&medium);
				}
				else
					::MessageBox(hWnd, "Paste operation failed.", "Error", MB_OK | MB_ICONEXCLAMATION);
				pdobj->Release();
			}
			else if (bCtl && wParam == 6) // CTRL-f
			{
				//HDC hdc;
				CHOOSEFONT cf;
				static LOGFONT lf;
				LPCSTR lpstr = lf.lfFaceName;
				Platform_UnicodeToANSI(g_szFaceName, -1, lf.lfFaceName, 32);
				lf.lfHeight = g_lfHeight;
				lf.lfWeight = (g_fBold) ? 700 : 400;
				lf.lfItalic = g_fItalic;

				// Initialize CHOOSEFONT
				ZeroMemory(&cf, sizeof(CHOOSEFONT));
				cf.lStructSize = sizeof(CHOOSEFONT);
				cf.hwndOwner = hWnd;
				cf.lpLogFont = &lf;
				cf.Flags = CF_SCREENFONTS | CF_TTONLY | CF_INITTOLOGFONTSTRUCT ;

				if (ChooseFont(&cf) == TRUE)
				{
					g_lf = lf;
					Platform_AnsiToUnicode(lf.lfFaceName, -1, g_szFaceName, 32);
					g_lfHeight = abs(lf.lfHeight);
					g_fBold = (lf.lfWeight >= 550);
					g_fItalic = (lf.lfItalic == TRUE);
					ResetStringAndSegment();
					InvalidateRect(hWnd, NULL, true);
				}
			}
			else if (bCtl)
			{
				::MessageBox(hWnd, "The following options are available:\n   CTRL-p to paste\n   CTRL-f to choose font",
					"SimpleEdit", MB_OK | MB_ICONEXCLAMATION);
			}

			break;
			}

		case WM_LBUTTONDOWN: // left mouse button
			{
			hdc = GetDC(hWnd);
			HFONT hfont = CreateFontIndirect(&g_lf);
			HFONT hfontOld = (HFONT)::SelectObject(hdc, hfont);
			// delete hfontOld??
			WinFont font(hdc);
			WinSegmentPainter painter(g_pgrseg, hdc);

			SHORT shiftstate;
			shiftstate = GetKeyState(VK_SHIFT);
			bool bShift = (bool) (shiftstate & 0x8000);

			POINT pt;
			pt.x = lParam & 0x0000FFFF;
			pt.y = lParam >> 16;

			painter.pointToChar(pt, &g_ichwEnd, &g_bAssocPrev);

			if (!bShift)
				g_ichwAnchor = g_ichwEnd;

			InvalidateRect(hWnd, NULL, true);
			ReleaseDC(hWnd, hdc);
			break;
			}

		case WM_DESTROY:
			delete g_pgrseg;
			delete g_pgrtext;
			PostQuitMessage(0);
			break;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

void GrInitialize (void)
{
	OLECHAR * sz = L"Hello World!";
	wcscpy(g_szString, sz);
	g_szString[wcslen(sz)] = 0;

	g_lfHeight = 24;
	memset(&g_lf, '\0', sizeof(LOGFONT));
	g_lf.lfCharSet = DEFAULT_CHARSET;
	g_lf.lfHeight = g_lfHeight;
	g_lf.lfWeight = 400;
	g_lf.lfItalic = FALSE;
	strcpy(g_lf.lfFaceName, "SILDoulos PigLatinDemo");

	wcscpy(g_szFaceName, L"SILDoulos PigLatinDemo");

	g_pgrtext = new SimpleTextSrc(g_szString);

	g_pgrseg = NULL;
	g_cchSeg = -1;

	g_ichwAnchor = 0;
	g_ichwEnd = 0;
	g_bAssocPrev = false;

	return;
}

//void GrfxInit(HDC hdc, GrGraphics &grfx)
//{
//	if (grfx.Initialize(hdc) != kresOk)
//		MessageBox(NULL, "GrGraphics didn't initialize", "", MB_OK);
//
//	// Why is this code needed?
//	//HFONT hFont;
//	//g_lf.lfHeight = -MulDiv(12, GetDeviceCaps(hdc, LOGPIXELSY), 72);
//	//hFont = CreateFontIndirect(&g_lf);
//	//grfx.SetFont(hFont);
//
//	grfx.SetupGraphics(&g_lgchrp);
//}

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
	return FALSE;
}

void ResetStringAndSegment()
{
	if (g_pgrseg)
		delete g_pgrseg;
	g_pgrseg = NULL;
	if (g_pgrtext)
		delete g_pgrtext;
	g_pgrtext = new SimpleTextSrc(g_szString);
}
