########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Wednesday 08 September 2010 12:11:39 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/Adt/Macro/AutodockVsCSF.py,v 1.2 2010/09/08 19:38:57 jren Exp $
#
# $Id: AutodockVsCSF.py,v 1.2 2010/09/08 19:38:57 jren Exp $
#

from NetworkEditor.macros import MacroNode
class AutodockVsCSF(MacroNode):
    """
    Runs Autodock Virtual Screening on several remote servers with CSF meta scheduler

    Inputs:
    port 1: LigandDB object containing info about the ligand library
    port 2: autogrid_result object containing info about autogrid results
    port 3: DPF template object
   
    Outputs:
    port 1: string containing URL to autodock virtual screening results
    """

    def __init__(self, constrkw={}, name='AutodockVsCSF', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        from WebServices.VisionInterface.WSNodes import wslib
        from Vision.StandardNodes import stdlib
        net.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")
        from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
        try:
            addOpalServerAsCategory("http://oolitevm.calit2.optiputer.net/opal2", replace=False)
        except:
            pass
        try:
            addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
        except:
            pass

    def afterAddingToNetwork(self):
        masterNet = self.macroNetwork
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        from WebServices.VisionInterface.WSNodes import wslib
        from Vision.StandardNodes import stdlib
        ## building macro network ##
        AutodockVsCSF_0 = self
        from traceback import print_exc
        from WebServices.VisionInterface.WSNodes import wslib
        from Vision.StandardNodes import stdlib
        masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")
        from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
        try:
            addOpalServerAsCategory("http://oolitevm.calit2.optiputer.net/opal2", replace=False)
        except:
            pass
        try:
            addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
        except:
            pass
        try:
            ## saving node input Ports ##
            input_Ports_1 = self.macroNetwork.ipNode
            apply(input_Ports_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_1=None

        try:
            ## saving node output Ports ##
            output_Ports_2 = self.macroNetwork.opNode
            apply(output_Ports_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
            output_Ports_2.move(183, 363)
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_2=None

        try:
            ## saving node PrepareADVSInputs ##
            from Vision.StandardNodes import Generic
            PrepareADVSInputs_3 = Generic(constrkw={}, name='PrepareADVSInputs', library=stdlib)
            self.macroNetwork.addNode(PrepareADVSInputs_3,217,76)
            apply(PrepareADVSInputs_3.addInputPort, (), {'singleConnection': True, 'name': 'ligands', 'cast': True, 'datatype': 'LigandDB', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'rect', 'color': '#FFCCFF', 'originalDatatype': 'None'})
            apply(PrepareADVSInputs_3.addInputPort, (), {'singleConnection': True, 'name': 'autogrid_results', 'cast': True, 'datatype': 'autogrid_results', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'triangle', 'color': '#FF33CC', 'originalDatatype': 'None'})
            apply(PrepareADVSInputs_3.addInputPort, (), {'singleConnection': True, 'name': 'dpf_template_obj', 'cast': True, 'datatype': 'dpf_template', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'triangle', 'color': '#9933FF', 'originalDatatype': 'None'})
            apply(PrepareADVSInputs_3.addOutputPort, (), {'name': 'filter_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_3.addOutputPort, (), {'name': 'ligand_lib', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_3.addOutputPort, (), {'name': 'dpf_template_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_3.addOutputPort, (), {'name': 'autogrid_res_url', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_3.addOutputPort, (), {'name': 'autogrid_res_local', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            code = """def doit(self, ligands, autogrid_results, dpf_template_obj):
        dpf = dpf_template_obj.fullpath

        if not(os.path.exists(dpf)):
            print "ERROR: DPF template " + dpf + " does not exist!"
            return '''stop'''
    
        filter_file = ligands.filter_file
        
        if autogrid_results.type == '''url''':
            autogrid_result_url = autogrid_results.path
            autogrid_result_local = ""
        else:
            autogrid_result_url = ""
            autogrid_result_local = autogrid_results.path
        
        ligand_lib = ligands.loc
        
	pass

        self.outputData(filter_file=filter_file, ligand_lib=ligand_lib, dpf_template_file=dpf, autogrid_res_url=autogrid_result_url, autogrid_res_local=autogrid_result_local)

## to ouput data on port filter_file use
## self.outputData(filter_file=data)
## to ouput data on port ligand_lib use
## self.outputData(ligand_lib=data)
## to ouput data on port dpf_template_file use
## self.outputData(dpf_template_file=data)
## to ouput data on port autogrid_res_url use
## self.outputData(autogrid_res_url=data)
## to ouput data on port autogrid_res_local use
## self.outputData(autogrid_res_local=data)









"""
            PrepareADVSInputs_3.configure(function=code)
            apply(PrepareADVSInputs_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore Generic named PrepareADVSInputs in network self.macroNetwork"
            print_exc()
            PrepareADVSInputs_3=None

        try:
            ## saving node autodock_kryptonite_nbcr_net ##
            from NetworkEditor.items import FunctionNode
            autodock_kryptonite_nbcr_net_4 = FunctionNode(functionOrString='autodock_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'ga_run': '', 'lib': '', 'filter_file_url': '', 'ga_num_evals': '', 'filter_file': '', 'sched': 'SGE', 'urllib': '', 'ga_num_generations': '', 'dpf': '', 'u': '', 'utar': '', 'userlib': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}, constrkw={'functionOrString': "'autodock_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'ga_run': '', 'lib': '', 'filter_file_url': '', 'ga_num_evals': '', 'filter_file': '', 'sched': 'SGE', 'urllib': '', 'ga_num_generations': '', 'dpf': '', 'u': '', 'utar': '', 'userlib': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}}, name='autodock_kryptonite_nbcr_net', library=wslib)
            self.macroNetwork.addNode(autodock_kryptonite_nbcr_net_4,217,132)
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['ga_run'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['lib'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['filter_file_url'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['ga_num_evals'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['filter_file'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['sched'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['urllib'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['ga_num_generations'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['dpf'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['u'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['utar'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['userlib'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['ga_pop_size'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['localRun'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['email'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['execPath'].configure, (), {'defaultValue': None})
            autodock_kryptonite_nbcr_net_4.inputPortByName['ga_run'].widget.set(r"", run=False)
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['lib'].widget.configure, (), {'choices': ('sample', 'NCIDS_SC', 'NCI_DS1', 'NCI_DS2', 'human_metabolome', 'chembridge_building_blocks', 'drugbank_nutraceutics', 'drugbank_smallmol', 'fda_approved')})
            autodock_kryptonite_nbcr_net_4.inputPortByName['lib'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['filter_file_url'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['ga_num_evals'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['filter_file'].rebindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['filter_file'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['filter_file'].unbindWidget()
            apply(autodock_kryptonite_nbcr_net_4.inputPortByName['sched'].widget.configure, (), {'choices': ('SGE', 'CSF')})
            autodock_kryptonite_nbcr_net_4.inputPortByName['sched'].widget.set(r"CSF", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['urllib'].rebindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['urllib'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['urllib'].unbindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['ga_num_generations'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['dpf'].rebindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['dpf'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['dpf'].unbindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['u'].rebindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['u'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['u'].unbindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['utar'].rebindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['utar'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['utar'].unbindWidget()
            autodock_kryptonite_nbcr_net_4.inputPortByName['userlib'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['ga_pop_size'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['localRun'].widget.set(0, run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['email'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_4.inputPortByName['execPath'].widget.set(r"", run=False)
            apply(autodock_kryptonite_nbcr_net_4.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore FunctionNode named autodock_kryptonite_nbcr_net in network self.macroNetwork"
            print_exc()
            autodock_kryptonite_nbcr_net_4=None

        try:
            ## saving node GetMainURLFromList ##
            from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
            GetMainURLFromList_5 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
            self.macroNetwork.addNode(GetMainURLFromList_5,217,188)
            apply(GetMainURLFromList_5.inputPortByName['urls'].configure, (), {'defaultValue': None})
            apply(GetMainURLFromList_5.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore GetMainURLFromListNode named GetMainURLFromList in network self.macroNetwork"
            print_exc()
            GetMainURLFromList_5=None

        try:
            ## saving node GetMainURLFromList ##
            from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
            GetMainURLFromList_7 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
            self.macroNetwork.addNode(GetMainURLFromList_7,201,301)
            apply(GetMainURLFromList_7.inputPortByName['urls'].configure, (), {'defaultValue': None})
            apply(GetMainURLFromList_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore GetMainURLFromListNode named GetMainURLFromList in network self.macroNetwork"
            print_exc()
            GetMainURLFromList_7=None

        try:
            ## saving node AutodockSlice_oolitevm_calit2_optiputer_net ##
            from NetworkEditor.items import FunctionNode
            AutodockSlice_oolitevm_calit2_optiputer_net_8 = FunctionNode(functionOrString='AutodockSlice_oolitevm_calit2_optiputer_net', host="http://oolitevm.calit2.optiputer.net/opal2", namedArgs={'execPath': '', 'localRun': False, 'divisor': '', 'lib': '', 'input_url': ''}, constrkw={'functionOrString': "'AutodockSlice_oolitevm_calit2_optiputer_net'", 'host': '"http://oolitevm.calit2.optiputer.net/opal2"', 'namedArgs': {'execPath': '', 'localRun': False, 'divisor': '', 'lib': '', 'input_url': ''}}, name='AutodockSlice_oolitevm_calit2_optiputer_net', library=wslib)
            self.macroNetwork.addNode(AutodockSlice_oolitevm_calit2_optiputer_net_8,200,240)
            apply(AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['execPath'].configure, (), {'defaultValue': None})
            apply(AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['localRun'].configure, (), {'defaultValue': None})
            apply(AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['divisor'].configure, (), {'defaultValue': None})
            apply(AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['lib'].configure, (), {'defaultValue': None})
            apply(AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['input_url'].configure, (), {'defaultValue': None})
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['execPath'].widget.set(r"", run=False)
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['localRun'].widget.set(0, run=False)
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['divisor'].widget.set(r"", run=False)
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['lib'].rebindWidget()
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['lib'].widget.set(r"", run=False)
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['lib'].unbindWidget()
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['input_url'].rebindWidget()
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['input_url'].widget.set(r"", run=False)
            AutodockSlice_oolitevm_calit2_optiputer_net_8.inputPortByName['input_url'].unbindWidget()
            apply(AutodockSlice_oolitevm_calit2_optiputer_net_8.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore FunctionNode named AutodockSlice_oolitevm_calit2_optiputer_net in network self.macroNetwork"
            print_exc()
            AutodockSlice_oolitevm_calit2_optiputer_net_8=None

        #self.macroNetwork.run()
        self.macroNetwork.freeze()

        ## saving connections for network AutodockVsCSF ##
        if autodock_kryptonite_nbcr_net_4 is not None and GetMainURLFromList_5 is not None:
            try:
                self.macroNetwork.connectNodes(
                    autodock_kryptonite_nbcr_net_4, GetMainURLFromList_5, "result", "urls", blocking=True
                    , splitratio=[0.36974288957131424, 0.63465596053596318])
            except:
                print "WARNING: failed to restore connection between autodock_kryptonite_nbcr_net_4 and GetMainURLFromList_5 in network self.macroNetwork"
        if PrepareADVSInputs_3 is not None and autodock_kryptonite_nbcr_net_4 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_3, autodock_kryptonite_nbcr_net_4, "filter_file", "filter_file", blocking=True
                    , splitratio=[0.33230642287344903, 0.65770700108889613])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_3 and autodock_kryptonite_nbcr_net_4 in network self.macroNetwork"
        if PrepareADVSInputs_3 is not None and autodock_kryptonite_nbcr_net_4 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_3, autodock_kryptonite_nbcr_net_4, "ligand_lib", "urllib", blocking=True
                    , splitratio=[0.50680104599665787, 0.51414170500293577])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_3 and autodock_kryptonite_nbcr_net_4 in network self.macroNetwork"
        if PrepareADVSInputs_3 is not None and autodock_kryptonite_nbcr_net_4 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_3, autodock_kryptonite_nbcr_net_4, "dpf_template_file", "dpf", blocking=True
                    , splitratio=[0.51615646597598808, 0.25661305528484007])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_3 and autodock_kryptonite_nbcr_net_4 in network self.macroNetwork"
        if PrepareADVSInputs_3 is not None and autodock_kryptonite_nbcr_net_4 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_3, autodock_kryptonite_nbcr_net_4, "autogrid_res_url", "u", blocking=True
                    , splitratio=[0.5760732944947704, 0.2032376887917188])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_3 and autodock_kryptonite_nbcr_net_4 in network self.macroNetwork"
        if PrepareADVSInputs_3 is not None and autodock_kryptonite_nbcr_net_4 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_3, autodock_kryptonite_nbcr_net_4, "autogrid_res_local", "utar", blocking=True
                    , splitratio=[0.52802808938949819, 0.66978534572736881])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_3 and autodock_kryptonite_nbcr_net_4 in network self.macroNetwork"
        input_Ports_1 = self.macroNetwork.ipNode
        if input_Ports_1 is not None and PrepareADVSInputs_3 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_1, PrepareADVSInputs_3, "new", "ligands", blocking=True
                    , splitratio=[0.23314258225660414, 0.72184112037432979])
            except:
                print "WARNING: failed to restore connection between input_Ports_1 and PrepareADVSInputs_3 in network self.macroNetwork"
        if input_Ports_1 is not None and PrepareADVSInputs_3 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_1, PrepareADVSInputs_3, "new", "autogrid_results", blocking=True
                    , splitratio=[0.56916626620432731, 0.43089669830392019])
            except:
                print "WARNING: failed to restore connection between input_Ports_1 and PrepareADVSInputs_3 in network self.macroNetwork"
        if input_Ports_1 is not None and PrepareADVSInputs_3 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_1, PrepareADVSInputs_3, "new", "dpf_template_obj", blocking=True
                    , splitratio=[0.26502286453989665, 0.3911248444502638])
            except:
                print "WARNING: failed to restore connection between input_Ports_1 and PrepareADVSInputs_3 in network self.macroNetwork"
        output_Ports_2 = self.macroNetwork.opNode
        if GetMainURLFromList_7 is not None and output_Ports_2 is not None:
            try:
                self.macroNetwork.connectNodes(
                    GetMainURLFromList_7, output_Ports_2, "newurl", "new", blocking=True
                    , splitratio=[0.2408747073082603, 0.22897876889044461])
            except:
                print "WARNING: failed to restore connection between GetMainURLFromList_7 and output_Ports_2 in network self.macroNetwork"
        if PrepareADVSInputs_3 is not None and AutodockSlice_oolitevm_calit2_optiputer_net_8 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_3, AutodockSlice_oolitevm_calit2_optiputer_net_8, "ligand_lib", "lib", blocking=True
                    , splitratio=[0.36439875698533941, 0.58443612376117082])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_3 and AutodockSlice_oolitevm_calit2_optiputer_net_8 in network self.macroNetwork"
        if GetMainURLFromList_5 is not None and AutodockSlice_oolitevm_calit2_optiputer_net_8 is not None:
            try:
                self.macroNetwork.connectNodes(
                    GetMainURLFromList_5, AutodockSlice_oolitevm_calit2_optiputer_net_8, "newurl", "input_url", blocking=True
                    , splitratio=[0.32808833199778697, 0.69237553555389719])
            except:
                print "WARNING: failed to restore connection between GetMainURLFromList_5 and AutodockSlice_oolitevm_calit2_optiputer_net_8 in network self.macroNetwork"
        if AutodockSlice_oolitevm_calit2_optiputer_net_8 is not None and GetMainURLFromList_7 is not None:
            try:
                self.macroNetwork.connectNodes(
                    AutodockSlice_oolitevm_calit2_optiputer_net_8, GetMainURLFromList_7, "result", "urls", blocking=True
                    , splitratio=[0.69930142895840763, 0.2984777644803871])
            except:
                print "WARNING: failed to restore connection between AutodockSlice_oolitevm_calit2_optiputer_net_8 and GetMainURLFromList_7 in network self.macroNetwork"
        self.macroNetwork.runOnNewData.value = True

        ## modifying MacroInputNode dynamic ports
        input_Ports_1 = self.macroNetwork.ipNode
        input_Ports_1.outputPorts[1].configure(name='PrepareADVSInputs_ligands')
        input_Ports_1.outputPorts[2].configure(name='PrepareADVSInputs_autogrid_results')
        input_Ports_1.outputPorts[3].configure(name='PrepareADVSInputs_dpf_template_obj')

        ## modifying MacroOutputNode dynamic ports
        output_Ports_2 = self.macroNetwork.opNode
        output_Ports_2.inputPorts[1].configure(singleConnection='auto')
        output_Ports_2.inputPorts[1].configure(name='GetMainURLFromList_newurl')
        ## configure MacroNode input ports
        AutodockVsCSF_0.inputPorts[0].configure(name='PrepareADVSInputs_ligands')
        AutodockVsCSF_0.inputPorts[0].configure(datatype='LigandDB')
        AutodockVsCSF_0.inputPorts[1].configure(name='PrepareADVSInputs_autogrid_results')
        AutodockVsCSF_0.inputPorts[1].configure(datatype='autogrid_results')
        AutodockVsCSF_0.inputPorts[2].configure(name='PrepareADVSInputs_dpf_template_obj')
        AutodockVsCSF_0.inputPorts[2].configure(datatype='dpf_template')
        ## configure MacroNode output ports
        AutodockVsCSF_0.outputPorts[0].configure(name='GetMainURLFromList_newurl')
        AutodockVsCSF_0.outputPorts[0].configure(datatype='string')

        AutodockVsCSF_0.shrink()

        ## reset modifications ##
        AutodockVsCSF_0.resetTags()
        AutodockVsCSF_0.buildOriginalList()
