/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorContext;
import com.google.gwt.editor.client.EditorDriver;
import com.google.gwt.editor.client.EditorVisitor;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateMap
implements Iterable<AbstractEditorDelegate<?, ?>> {
    public static final KeyMethod IDENTITY = new KeyMethod(){

        public Object key(Object object) {
            return object;
        }
    };
    private final Map<Object, List<AbstractEditorDelegate<?, ?>>> map = new HashMap();
    private final Map<String, List<AbstractEditorDelegate<?, ?>>> delegatesByPath = new HashMap();
    private final Map<String, List<Editor<?>>> editorsByPath = new HashMap();
    private final KeyMethod keyMethod;

    public static DelegateMap of(EditorDriver<?> driver, KeyMethod key) {
        final DelegateMap toReturn = new DelegateMap(key);
        driver.accept(new EditorVisitor(){

            @Override
            public <T> void endVisit(EditorContext<T> ctx) {
                toReturn.put(ctx.getAbsolutePath(), ctx.getEditor());
                AbstractEditorDelegate delegate = (AbstractEditorDelegate)ctx.getEditorDelegate();
                if (delegate != null) {
                    toReturn.put(delegate.getObject(), delegate);
                }
            }
        });
        return toReturn;
    }

    DelegateMap(KeyMethod key) {
        this.keyMethod = key;
    }

    public List<AbstractEditorDelegate<?, ?>> get(Object object) {
        Object key = this.keyMethod.key(object);
        return key == null ? null : this.map.get(key);
    }

    public List<AbstractEditorDelegate<?, ?>> getDelegatesByPath(String path) {
        return this.delegatesByPath.get(path);
    }

    public List<Editor<?>> getEditorByPath(String path) {
        return this.editorsByPath.get(path);
    }

    public List<AbstractEditorDelegate<?, ?>> getRaw(Object key) {
        return this.map.get(key);
    }

    @Override
    public Iterator<AbstractEditorDelegate<?, ?>> iterator() {
        return new MapIterator(this);
    }

    <K, V> void add(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }

    <T> void put(String path, Editor<T> editor) {
        this.add(this.editorsByPath, path, editor);
    }

    <T> void put(T object, AbstractEditorDelegate<T, ?> delegate) {
        this.add(this.delegatesByPath, delegate.getPath(), delegate);
        Object key = this.keyMethod.key(object);
        if (key == null) {
            return;
        }
        this.add(this.map, key, delegate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator
    implements Iterator<AbstractEditorDelegate<?, ?>> {
        private AbstractEditorDelegate<?, ?> next;
        private Iterator<AbstractEditorDelegate<?, ?>> list;
        private Iterator<List<AbstractEditorDelegate<?, ?>>> values;

        public MapIterator(DelegateMap map) {
            this.values = map.map.values().iterator();
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public AbstractEditorDelegate<?, ?> next() {
            AbstractEditorDelegate<?, ?> toReturn = this.next;
            if (this.list != null && this.list.hasNext()) {
                this.next = this.list.next();
            } else {
                this.next = null;
                while (this.values.hasNext()) {
                    this.list = this.values.next().iterator();
                    if (!this.list.hasNext()) continue;
                    this.next = this.list.next();
                    break;
                }
            }
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface KeyMethod {
        public Object key(Object var1);
    }
}

