/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FieldSetElement;
import com.google.gwt.dom.client.LegendElement;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptionPanel
extends Composite
implements HasWidgets.ForIsWidget {
    private static CaptionPanelImpl impl = (CaptionPanelImpl)GWT.create(CaptionPanelImpl.class);
    private LegendElement legend;

    public CaptionPanel() {
        this("", false);
    }

    public CaptionPanel(SafeHtml caption) {
        this(caption.asString(), true);
    }

    public CaptionPanel(String captionText) {
        this(captionText, false);
    }

    public CaptionPanel(String caption, boolean asHTML) {
        FieldSetElement fieldSet = Document.get().createFieldSetElement();
        this.initWidget(new SimplePanel(fieldSet));
        this.legend = Document.get().createLegendElement();
        fieldSet.appendChild(this.legend);
        if (asHTML) {
            this.setCaptionHTML(caption);
        } else {
            this.setCaptionText(caption);
        }
    }

    @Override
    public void add(Widget w) {
        ((SimplePanel)this.getWidget()).add(w);
    }

    @Override
    public void add(IsWidget w) {
        this.add(CaptionPanel.asWidgetOrNull(w));
    }

    @Override
    public void clear() {
        ((SimplePanel)this.getWidget()).clear();
    }

    public String getCaptionHTML() {
        String html = this.legend.getInnerHTML();
        assert (html != null);
        return html;
    }

    public String getCaptionText() {
        String text = this.legend.getInnerText();
        assert (text != null);
        return text;
    }

    public Widget getContentWidget() {
        return ((SimplePanel)this.getWidget()).getWidget();
    }

    @Override
    public Iterator<Widget> iterator() {
        return ((SimplePanel)this.getWidget()).iterator();
    }

    @Override
    public boolean remove(Widget w) {
        return ((SimplePanel)this.getWidget()).remove(w);
    }

    @Override
    public boolean remove(IsWidget w) {
        return this.remove(CaptionPanel.asWidgetOrNull(w));
    }

    public void setCaptionHTML(String html) {
        assert (html != null);
        impl.setCaption(FieldSetElement.as(this.getElement()), this.legend, html, true);
    }

    public void setCaptionHTML(SafeHtml html) {
        this.setCaptionHTML(html.asString());
    }

    public void setCaptionText(String text) {
        assert (text != null);
        impl.setCaption(FieldSetElement.as(this.getElement()), this.legend, text, false);
    }

    public void setContentWidget(Widget w) {
        ((SimplePanel)this.getWidget()).setWidget(w);
    }

    public static class CaptionPanelImplSafari
    extends CaptionPanelImpl {
        public void setCaption(FieldSetElement fieldset, Element legend, SafeHtml caption) {
            this.setCaption(fieldset, legend, caption.asString(), true);
        }

        public void setCaption(final FieldSetElement fieldset, Element legend, String caption, boolean asHTML) {
            fieldset.getStyle().setProperty("visibility", "hidden");
            super.setCaption(fieldset, legend, caption, asHTML);
            DeferredCommand.addCommand(new Command(){

                public void execute() {
                    fieldset.getStyle().setProperty("visibility", "");
                }
            });
        }
    }

    public static class CaptionPanelImplMozilla
    extends CaptionPanelImpl {
        public void setCaption(FieldSetElement fieldset, Element legend, SafeHtml caption) {
            this.setCaption(fieldset, legend, caption.asString(), true);
        }

        public void setCaption(FieldSetElement fieldset, Element legend, String caption, boolean asHTML) {
            fieldset.getStyle().setProperty("display", "none");
            super.setCaption(fieldset, legend, caption, asHTML);
            fieldset.getStyle().setProperty("display", "");
        }
    }

    public static class CaptionPanelImpl {
        public void setCaption(FieldSetElement fieldset, Element legend, SafeHtml caption) {
            this.setCaption(fieldset, legend, caption.asString(), true);
        }

        public void setCaption(FieldSetElement fieldset, Element legend, String caption, boolean asHTML) {
            assert (caption != null);
            if (asHTML) {
                legend.setInnerHTML(caption);
            } else {
                legend.setInnerText(caption);
            }
            if (!"".equals(caption)) {
                fieldset.insertBefore(legend, fieldset.getFirstChild());
            } else if (legend.getParentNode() != null) {
                fieldset.removeChild(legend);
            }
        }
    }
}

