/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ak" locale.
 */
public class LocalizedNamesImpl_ak extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "GH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AM",
        "AC",
        "IE",
        "IS",
        "AF",
        "ZA",
        "CF",
        "AR",
        "GB",
        "AL",
        "US",
        "AS",
        "VI",
        "KR",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AW",
        "AX",
        "AZ",
        "BB",
        "BS",
        "BD",
        "BH",
        "BZ",
        "BL",
        "BO",
        "BA",
        "BR",
        "VG",
        "IO",
        "BN",
        "BI",
        "BT",
        "BV",
        "BF",
        "BG",
        "BW",
        "BY",
        "BE",
        "BM",
        "BJ",
        "CC",
        "CP",
        "CX",
        "DG",
        "DM",
        "DO",
        "DK",
        "EA",
        "EH",
        "KP",
        "EU",
        "FJ",
        "FI",
        "FO",
        "GF",
        "FR",
        "PF",
        "FK",
        "GH",
        "GA",
        "GM",
        "GY",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GR",
        "GL",
        "GD",
        "GS",
        "GU",
        "GP",
        "GT",
        "DE",
        "JM",
        "JP",
        "GI",
        "DJ",
        "JO",
        "GE",
        "HU",
        "HT",
        "HK",
        "HM",
        "HN",
        "IC",
        "EC",
        "IM",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "ET",
        "JE",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KY",
        "CV",
        "KI",
        "CO",
        "CG",
        "CD",
        "CK",
        "HR",
        "CU",
        "KW",
        "TD",
        "CN",
        "CL",
        "CZ",
        "KM",
        "CR",
        "KE",
        "KG",
        "CI",
        "LR",
        "LU",
        "LA",
        "LV",
        "LI",
        "LY",
        "LT",
        "LB",
        "LS",
        "MG",
        "FM",
        "MW",
        "MV",
        "MY",
        "ML",
        "MS",
        "MH",
        "MK",
        "MQ",
        "YT",
        "ME",
        "MF",
        "MM",
        "MO",
        "MA",
        "MZ",
        "MD",
        "MT",
        "MC",
        "MN",
        "MU",
        "MR",
        "MX",
        "NG",
        "NA",
        "NR",
        "NI",
        "NE",
        "EG",
        "NU",
        "MP",
        "NF",
        "NO",
        "NL",
        "AN",
        "NP",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PR",
        "PT",
        "QO",
        "RE",
        "RO",
        "RS",
        "RW",
        "RU",
        "CY",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SG",
        "SY",
        "SJ",
        "SK",
        "SI",
        "SB",
        "SO",
        "ES",
        "LK",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "CS",
        "TA",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TC",
        "TV",
        "TM",
        "TR",
        "UG",
        "UA",
        "UM",
        "AE",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "UY",
        "YE",
        "ZM",
        "ZW",
        "NZ",
        "DZ",
        "AU",
        "AT",
        "SV",
        "ER",
        "EE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andora");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua ne Baabuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AL", "Albenia");
    namesMap.put("AM", "Aamenia");
    namesMap.put("AN", "Nɛdɛland Antelez");
    namesMap.put("AR", "Agyɛntina");
    namesMap.put("AS", "Amɛrika Samoa");
    namesMap.put("AT", "Ɔstria");
    namesMap.put("AU", "Ɔstrelia");
    namesMap.put("AZ", "Azebaegyan");
    namesMap.put("BA", "Bosnia ne Hɛzegovina");
    namesMap.put("BB", "Baabados");
    namesMap.put("BD", "Bangladɛhye");
    namesMap.put("BE", "Bɛlgyium");
    namesMap.put("BF", "Bɔkina Faso");
    namesMap.put("BG", "Bɔlgeria");
    namesMap.put("BH", "Baren");
    namesMap.put("BJ", "Bɛnin");
    namesMap.put("BM", "Bɛmuda");
    namesMap.put("BN", "Brunae");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Butan");
    namesMap.put("BW", "Bɔtswana");
    namesMap.put("BY", "Bɛlarus");
    namesMap.put("BZ", "Beliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Kongo (Zair)");
    namesMap.put("CF", "Afrika Finimfin Man");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Swetzaland");
    namesMap.put("CI", "La Côte d'Ivoire");
    namesMap.put("CK", "Kook Nsupɔw");
    namesMap.put("CL", "Kyili");
    namesMap.put("CM", "Kamɛrun");
    namesMap.put("CN", "Kyaena");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CR", "Kɔsta Rika");
    namesMap.put("CS", "Sɛɛbea ne Mɔntenɛgro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kepvɛdfo Islands");
    namesMap.put("CY", "Saeprɔs");
    namesMap.put("CZ", "Kyɛk Kurokɛse");
    namesMap.put("DE", "Gyaaman");
    namesMap.put("DJ", "Gyibuti");
    namesMap.put("DK", "Dɛnmak");
    namesMap.put("DM", "Dɔmeneka");
    namesMap.put("DO", "Dɔmeneka Kurokɛse");
    namesMap.put("DZ", "Ɔlgyeria");
    namesMap.put("EC", "Ikuwadɔ");
    namesMap.put("EE", "Ɛstonia");
    namesMap.put("EG", "Nisrim");
    namesMap.put("ER", "Ɛritrea");
    namesMap.put("ET", "Ithiopia");
    namesMap.put("FJ", "Figyi");
    namesMap.put("FK", "Fɔlkman Aeland");
    namesMap.put("FM", "Maekronehyia");
    namesMap.put("FR", "Frɛnkyeman");
    namesMap.put("GA", "Gabɔn");
    namesMap.put("GB", "Ahendiman Nkabom");
    namesMap.put("GE", "Gyɔgyea");
    namesMap.put("GF", "Frɛnkye Gayana");
    namesMap.put("GH", "Gaana");
    namesMap.put("GI", "Gyebralta");
    namesMap.put("GL", "Greenman");
    namesMap.put("GN", "Gini");
    namesMap.put("GP", "Guwadelup");
    namesMap.put("GQ", "Gini Ikuweta");
    namesMap.put("GR", "Greekman");
    namesMap.put("GT", "Guwatemala");
    namesMap.put("GW", "Gini Bisaw");
    namesMap.put("GY", "Gayana");
    namesMap.put("HN", "Hɔnduras");
    namesMap.put("HR", "Krowehyia");
    namesMap.put("HT", "Heiti");
    namesMap.put("HU", "Hangari");
    namesMap.put("ID", "Indɔnehyia");
    namesMap.put("IE", "Aereland");
    namesMap.put("IO", "Britenfo Hɔn Man Wɔ India Po No Mu");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Aesland");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Gyameka");
    namesMap.put("JO", "Gyɔdan");
    namesMap.put("JP", "Gyapan");
    namesMap.put("KE", "Kɛnya");
    namesMap.put("KG", "Kɛɛgestan");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KM", "Kɔmɔrɔs");
    namesMap.put("KN", "Saint Kitts ne Nɛves");
    namesMap.put("KP", "Etifi Koria");
    namesMap.put("KR", "Anaafo Koria");
    namesMap.put("KW", "Kuwete");
    namesMap.put("KY", "Kemanfo Islands");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LB", "Lɛbanɔn");
    namesMap.put("LI", "Lektenstaen");
    namesMap.put("LR", "Laeberia");
    namesMap.put("LS", "Lɛsutu");
    namesMap.put("LT", "Lituwenia");
    namesMap.put("LU", "Laksembɛg");
    namesMap.put("MA", "Moroko");
    namesMap.put("MC", "Mɔnako");
    namesMap.put("MD", "Mɔldova");
    namesMap.put("MG", "Madagaska");
    namesMap.put("MK", "Masedonia");
    namesMap.put("MM", "Miyanma");
    namesMap.put("MN", "Mɔngolia");
    namesMap.put("MQ", "Matinik");
    namesMap.put("MR", "Mɔretenia");
    namesMap.put("MS", "Mantserat");
    namesMap.put("MT", "Mɔlta");
    namesMap.put("MU", "Mɔrehyeɔs");
    namesMap.put("MX", "Mɛksiko");
    namesMap.put("MY", "Malehyia");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NC", "Kaledonia Foforo");
    namesMap.put("NE", "Nigyɛ");
    namesMap.put("NF", "Nɔfolk Aeland");
    namesMap.put("NG", "Naegyeria");
    namesMap.put("NI", "Nekaraguwa");
    namesMap.put("NL", "Nɛdɛland");
    namesMap.put("NO", "Nɔɔwe");
    namesMap.put("NP", "Nɛpɔl");
    namesMap.put("NR", "Naworu");
    namesMap.put("NU", "Niyu");
    namesMap.put("NZ", "Ziland Foforo");
    namesMap.put("PF", "Frɛnkye Pɔlenehyia");
    namesMap.put("PG", "Papua Guinea Foforo");
    namesMap.put("PM", "Saint Pierre ne Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Puɛto Riko");
    namesMap.put("PS", "Palestaen West Bank ne Gaza");
    namesMap.put("PT", "Pɔtugal");
    namesMap.put("QA", "Kata");
    namesMap.put("RE", "Reyuniɔn");
    namesMap.put("RO", "Romenia");
    namesMap.put("RU", "Rɔhyea");
    namesMap.put("SC", "Seyhyɛl");
    namesMap.put("SG", "Singapɔ");
    namesMap.put("SI", "Slovinia");
    namesMap.put("SV", "Ɛl Salvadɔ");
    namesMap.put("SY", "Siria");
    namesMap.put("TC", "Turks ne Caicos Islands");
    namesMap.put("TD", "Kyad");
    namesMap.put("TH", "Taeland");
    namesMap.put("TL", "Timɔ Boka");
    namesMap.put("TM", "Tɛkmɛnistan");
    namesMap.put("TN", "Tunihyia");
    namesMap.put("TR", "Tɛɛki");
    namesMap.put("TT", "Trinidad ne Tobago");
    namesMap.put("UA", "Ukren");
    namesMap.put("US", "Amɛrika");
    namesMap.put("UY", "Yurugwae");
    namesMap.put("UZ", "Uzbɛkistan");
    namesMap.put("VA", "Vatican Man");
    namesMap.put("VC", "Saint Vincent ne Grenadines");
    namesMap.put("VG", "Britainfo Virgin Islands");
    namesMap.put("VI", "Amɛrika Virgin Islands");
    namesMap.put("VN", "Viɛtnam");
    namesMap.put("WF", "Wallis ne Futuna");
    namesMap.put("YE", "Yɛmen");
    namesMap.put("YT", "Mayɔte");
    namesMap.put("ZA", "Afrika Anaafo");
    namesMap.put("ZW", "Zembabwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andora",
        "AF": "Afganistan",
        "AG": "Antigua ne Baabuda",
        "AI": "Anguila",
        "AL": "Albenia",
        "AM": "Aamenia",
        "AN": "Nɛdɛland Antelez",
        "AR": "Agyɛntina",
        "AS": "Amɛrika Samoa",
        "AT": "Ɔstria",
        "AU": "Ɔstrelia",
        "AZ": "Azebaegyan",
        "BA": "Bosnia ne Hɛzegovina",
        "BB": "Baabados",
        "BD": "Bangladɛhye",
        "BE": "Bɛlgyium",
        "BF": "Bɔkina Faso",
        "BG": "Bɔlgeria",
        "BH": "Baren",
        "BJ": "Bɛnin",
        "BM": "Bɛmuda",
        "BN": "Brunae",
        "BS": "Bahama",
        "BT": "Butan",
        "BW": "Bɔtswana",
        "BY": "Bɛlarus",
        "BZ": "Beliz",
        "CA": "Kanada",
        "CD": "Kongo (Zair)",
        "CF": "Afrika Finimfin Man",
        "CG": "Kongo",
        "CH": "Swetzaland",
        "CI": "La Côte d'Ivoire",
        "CK": "Kook Nsupɔw",
        "CL": "Kyili",
        "CM": "Kamɛrun",
        "CN": "Kyaena",
        "CO": "Kolombia",
        "CR": "Kɔsta Rika",
        "CS": "Sɛɛbea ne Mɔntenɛgro",
        "CU": "Kuba",
        "CV": "Kepvɛdfo Islands",
        "CY": "Saeprɔs",
        "CZ": "Kyɛk Kurokɛse",
        "DE": "Gyaaman",
        "DJ": "Gyibuti",
        "DK": "Dɛnmak",
        "DM": "Dɔmeneka",
        "DO": "Dɔmeneka Kurokɛse",
        "DZ": "Ɔlgyeria",
        "EC": "Ikuwadɔ",
        "EE": "Ɛstonia",
        "EG": "Nisrim",
        "ER": "Ɛritrea",
        "ET": "Ithiopia",
        "FJ": "Figyi",
        "FK": "Fɔlkman Aeland",
        "FM": "Maekronehyia",
        "FR": "Frɛnkyeman",
        "GA": "Gabɔn",
        "GB": "Ahendiman Nkabom",
        "GE": "Gyɔgyea",
        "GF": "Frɛnkye Gayana",
        "GH": "Gaana",
        "GI": "Gyebralta",
        "GL": "Greenman",
        "GN": "Gini",
        "GP": "Guwadelup",
        "GQ": "Gini Ikuweta",
        "GR": "Greekman",
        "GT": "Guwatemala",
        "GW": "Gini Bisaw",
        "GY": "Gayana",
        "HN": "Hɔnduras",
        "HR": "Krowehyia",
        "HT": "Heiti",
        "HU": "Hangari",
        "ID": "Indɔnehyia",
        "IE": "Aereland",
        "IO": "Britenfo Hɔn Man Wɔ India Po No Mu",
        "IQ": "Irak",
        "IS": "Aesland",
        "IT": "Itali",
        "JM": "Gyameka",
        "JO": "Gyɔdan",
        "JP": "Gyapan",
        "KE": "Kɛnya",
        "KG": "Kɛɛgestan",
        "KH": "Kambodia",
        "KM": "Kɔmɔrɔs",
        "KN": "Saint Kitts ne Nɛves",
        "KP": "Etifi Koria",
        "KR": "Anaafo Koria",
        "KW": "Kuwete",
        "KY": "Kemanfo Islands",
        "KZ": "Kazakstan",
        "LB": "Lɛbanɔn",
        "LI": "Lektenstaen",
        "LR": "Laeberia",
        "LS": "Lɛsutu",
        "LT": "Lituwenia",
        "LU": "Laksembɛg",
        "MA": "Moroko",
        "MC": "Mɔnako",
        "MD": "Mɔldova",
        "MG": "Madagaska",
        "MK": "Masedonia",
        "MM": "Miyanma",
        "MN": "Mɔngolia",
        "MQ": "Matinik",
        "MR": "Mɔretenia",
        "MS": "Mantserat",
        "MT": "Mɔlta",
        "MU": "Mɔrehyeɔs",
        "MX": "Mɛksiko",
        "MY": "Malehyia",
        "MZ": "Mozambik",
        "NC": "Kaledonia Foforo",
        "NE": "Nigyɛ",
        "NF": "Nɔfolk Aeland",
        "NG": "Naegyeria",
        "NI": "Nekaraguwa",
        "NL": "Nɛdɛland",
        "NO": "Nɔɔwe",
        "NP": "Nɛpɔl",
        "NR": "Naworu",
        "NU": "Niyu",
        "NZ": "Ziland Foforo",
        "PF": "Frɛnkye Pɔlenehyia",
        "PG": "Papua Guinea Foforo",
        "PM": "Saint Pierre ne Miquelon",
        "PN": "Pitcairn",
        "PR": "Puɛto Riko",
        "PS": "Palestaen West Bank ne Gaza",
        "PT": "Pɔtugal",
        "QA": "Kata",
        "RE": "Reyuniɔn",
        "RO": "Romenia",
        "RU": "Rɔhyea",
        "SC": "Seyhyɛl",
        "SG": "Singapɔ",
        "SI": "Slovinia",
        "SV": "Ɛl Salvadɔ",
        "SY": "Siria",
        "TC": "Turks ne Caicos Islands",
        "TD": "Kyad",
        "TH": "Taeland",
        "TL": "Timɔ Boka",
        "TM": "Tɛkmɛnistan",
        "TN": "Tunihyia",
        "TR": "Tɛɛki",
        "TT": "Trinidad ne Tobago",
        "UA": "Ukren",
        "US": "Amɛrika",
        "UY": "Yurugwae",
        "UZ": "Uzbɛkistan",
        "VA": "Vatican Man",
        "VC": "Saint Vincent ne Grenadines",
        "VG": "Britainfo Virgin Islands",
        "VI": "Amɛrika Virgin Islands",
        "VN": "Viɛtnam",
        "WF": "Wallis ne Futuna",
        "YE": "Yɛmen",
        "YT": "Mayɔte",
        "ZA": "Afrika Anaafo",
        "ZW": "Zembabwe"
    };
  }-*/;
}
