/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_CacheMemory.h"

CMPIObjectPath* CPU_OpenDRIM_CacheMemory_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_CacheMemory& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_CacheMemory_classnames[0], OpenDRIM_CacheMemory_NAMESPACE);

	if (!instance.SystemCreationClassName_isNULL)
		op.addKey("SystemCreationClassName", instance.SystemCreationClassName);

	if (!instance.SystemName_isNULL)
		op.addKey("SystemName", instance.SystemName);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.DeviceID_isNULL)
		op.addKey("DeviceID", instance.DeviceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* CPU_OpenDRIM_CacheMemory_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_CacheMemory& instance) {
	_E_;
	Objectpath op(broker, CPU_OpenDRIM_CacheMemory_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.PowerManagementSupported_isNULL)
		ci.setProperty("PowerManagementSupported", instance.PowerManagementSupported);

	if (!instance.PowerManagementCapabilities_isNULL)
		ci.setProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities);

	if (!instance.Availability_isNULL)
		ci.setProperty("Availability", instance.Availability);

	if (!instance.StatusInfo_isNULL)
		ci.setProperty("StatusInfo", instance.StatusInfo);

	if (!instance.LastErrorCode_isNULL)
		ci.setProperty("LastErrorCode", instance.LastErrorCode);

	if (!instance.ErrorDescription_isNULL)
		ci.setProperty("ErrorDescription", instance.ErrorDescription);

	if (!instance.ErrorCleared_isNULL)
		ci.setProperty("ErrorCleared", instance.ErrorCleared);

	if (!instance.OtherIdentifyingInfo_isNULL)
		ci.setProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo);

	if (!instance.PowerOnHours_isNULL)
		ci.setProperty("PowerOnHours", instance.PowerOnHours);

	if (!instance.TotalPowerOnHours_isNULL)
		ci.setProperty("TotalPowerOnHours", instance.TotalPowerOnHours);

	if (!instance.IdentifyingDescriptions_isNULL)
		ci.setProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions);

	if (!instance.AdditionalAvailability_isNULL)
		ci.setProperty("AdditionalAvailability", instance.AdditionalAvailability);

	if (!instance.MaxQuiesceTime_isNULL)
		ci.setProperty("MaxQuiesceTime", instance.MaxQuiesceTime);

	if (!instance.LocationIndicator_isNULL)
		ci.setProperty("LocationIndicator", instance.LocationIndicator);

	if (!instance.DataOrganization_isNULL)
		ci.setProperty("DataOrganization", instance.DataOrganization);

	if (!instance.Purpose_isNULL)
		ci.setProperty("Purpose", instance.Purpose);

	if (!instance.Access_isNULL)
		ci.setProperty("Access", instance.Access);

	if (!instance.BlockSize_isNULL)
		ci.setProperty("BlockSize", instance.BlockSize);

	if (!instance.NumberOfBlocks_isNULL)
		ci.setProperty("NumberOfBlocks", instance.NumberOfBlocks);

	if (!instance.ConsumableBlocks_isNULL)
		ci.setProperty("ConsumableBlocks", instance.ConsumableBlocks);

	if (!instance.IsBasedOnUnderlyingRedundancy_isNULL)
		ci.setProperty("IsBasedOnUnderlyingRedundancy", instance.IsBasedOnUnderlyingRedundancy);

	if (!instance.SequentialAccess_isNULL)
		ci.setProperty("SequentialAccess", instance.SequentialAccess);

	if (!instance.ExtentStatus_isNULL)
		ci.setProperty("ExtentStatus", instance.ExtentStatus);

	if (!instance.NoSinglePointOfFailure_isNULL)
		ci.setProperty("NoSinglePointOfFailure", instance.NoSinglePointOfFailure);

	if (!instance.DataRedundancy_isNULL)
		ci.setProperty("DataRedundancy", instance.DataRedundancy);

	if (!instance.PackageRedundancy_isNULL)
		ci.setProperty("PackageRedundancy", instance.PackageRedundancy);

	if (!instance.DeltaReservation_isNULL)
		ci.setProperty("DeltaReservation", instance.DeltaReservation);

	if (!instance.Primordial_isNULL)
		ci.setProperty("Primordial", instance.Primordial);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.NameFormat_isNULL)
		ci.setProperty("NameFormat", instance.NameFormat);

	if (!instance.NameNamespace_isNULL)
		ci.setProperty("NameNamespace", instance.NameNamespace);

	if (!instance.OtherNameNamespace_isNULL)
		ci.setProperty("OtherNameNamespace", instance.OtherNameNamespace);

	if (!instance.OtherNameFormat_isNULL)
		ci.setProperty("OtherNameFormat", instance.OtherNameFormat);

	if (!instance.Usage_isNULL)
		ci.setProperty("Usage", instance.Usage);

	if (!instance.OtherUsageDescription_isNULL)
		ci.setProperty("OtherUsageDescription", instance.OtherUsageDescription);

	if (!instance.ClientSettableUsage_isNULL)
		ci.setProperty("ClientSettableUsage", instance.ClientSettableUsage);

	if (!instance.Volatile_isNULL)
		ci.setProperty("Volatile", instance.Volatile);

	if (!instance.ErrorMethodology_isNULL)
		ci.setProperty("ErrorMethodology", instance.ErrorMethodology);

	if (!instance.StartingAddress_isNULL)
		ci.setProperty("StartingAddress", instance.StartingAddress);

	if (!instance.EndingAddress_isNULL)
		ci.setProperty("EndingAddress", instance.EndingAddress);

	if (!instance.ErrorInfo_isNULL)
		ci.setProperty("ErrorInfo", instance.ErrorInfo);

	if (!instance.OtherErrorDescription_isNULL)
		ci.setProperty("OtherErrorDescription", instance.OtherErrorDescription);

	if (!instance.CorrectableError_isNULL)
		ci.setProperty("CorrectableError", instance.CorrectableError);

	if (!instance.ErrorTime_isNULL)
		ci.setPropertyDatetime("ErrorTime", instance.ErrorTime);

	if (!instance.ErrorAccess_isNULL)
		ci.setProperty("ErrorAccess", instance.ErrorAccess);

	if (!instance.ErrorTransferSize_isNULL)
		ci.setProperty("ErrorTransferSize", instance.ErrorTransferSize);

	if (!instance.ErrorData_isNULL)
		ci.setProperty("ErrorData", instance.ErrorData);

	if (!instance.ErrorDataOrder_isNULL)
		ci.setProperty("ErrorDataOrder", instance.ErrorDataOrder);

	if (!instance.ErrorAddress_isNULL)
		ci.setProperty("ErrorAddress", instance.ErrorAddress);

	if (!instance.SystemLevelAddress_isNULL)
		ci.setProperty("SystemLevelAddress", instance.SystemLevelAddress);

	if (!instance.ErrorResolution_isNULL)
		ci.setProperty("ErrorResolution", instance.ErrorResolution);

	if (!instance.AdditionalErrorData_isNULL)
		ci.setProperty("AdditionalErrorData", instance.AdditionalErrorData);

	_L_;
	return ci.getHdl();
}

void CPU_OpenDRIM_CacheMemory_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_CacheMemory& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("DeviceID", instance.DeviceID) == OK)
		instance.DeviceID_isNULL = false;

	if (op.getKey("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (op.getKey("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	_L_;
}

void CPU_OpenDRIM_CacheMemory_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_CacheMemory& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("SystemCreationClassName", instance.SystemCreationClassName) == OK)
		instance.SystemCreationClassName_isNULL = false;

	if (inst.getProperty("SystemName", instance.SystemName) == OK)
		instance.SystemName_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("DeviceID", instance.DeviceID) == OK)
		instance.DeviceID_isNULL = false;

	if (inst.getProperty("PowerManagementSupported", instance.PowerManagementSupported) == OK)
		instance.PowerManagementSupported_isNULL = false;

	if (inst.getProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities) == OK)
		instance.PowerManagementCapabilities_isNULL = false;

	if (inst.getProperty("Availability", instance.Availability) == OK)
		instance.Availability_isNULL = false;

	if (inst.getProperty("StatusInfo", instance.StatusInfo) == OK)
		instance.StatusInfo_isNULL = false;

	if (inst.getProperty("LastErrorCode", instance.LastErrorCode) == OK)
		instance.LastErrorCode_isNULL = false;

	if (inst.getProperty("ErrorDescription", instance.ErrorDescription) == OK)
		instance.ErrorDescription_isNULL = false;

	if (inst.getProperty("ErrorCleared", instance.ErrorCleared) == OK)
		instance.ErrorCleared_isNULL = false;

	if (inst.getProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo) == OK)
		instance.OtherIdentifyingInfo_isNULL = false;

	if (inst.getProperty("PowerOnHours", instance.PowerOnHours) == OK)
		instance.PowerOnHours_isNULL = false;

	if (inst.getProperty("TotalPowerOnHours", instance.TotalPowerOnHours) == OK)
		instance.TotalPowerOnHours_isNULL = false;

	if (inst.getProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions) == OK)
		instance.IdentifyingDescriptions_isNULL = false;

	if (inst.getProperty("AdditionalAvailability", instance.AdditionalAvailability) == OK)
		instance.AdditionalAvailability_isNULL = false;

	if (inst.getProperty("MaxQuiesceTime", instance.MaxQuiesceTime) == OK)
		instance.MaxQuiesceTime_isNULL = false;

	if (inst.getProperty("LocationIndicator", instance.LocationIndicator) == OK)
		instance.LocationIndicator_isNULL = false;

	if (inst.getProperty("DataOrganization", instance.DataOrganization) == OK)
		instance.DataOrganization_isNULL = false;

	if (inst.getProperty("Purpose", instance.Purpose) == OK)
		instance.Purpose_isNULL = false;

	if (inst.getProperty("Access", instance.Access) == OK)
		instance.Access_isNULL = false;

	if (inst.getProperty("BlockSize", instance.BlockSize) == OK)
		instance.BlockSize_isNULL = false;

	if (inst.getProperty("NumberOfBlocks", instance.NumberOfBlocks) == OK)
		instance.NumberOfBlocks_isNULL = false;

	if (inst.getProperty("ConsumableBlocks", instance.ConsumableBlocks) == OK)
		instance.ConsumableBlocks_isNULL = false;

	if (inst.getProperty("IsBasedOnUnderlyingRedundancy", instance.IsBasedOnUnderlyingRedundancy) == OK)
		instance.IsBasedOnUnderlyingRedundancy_isNULL = false;

	if (inst.getProperty("SequentialAccess", instance.SequentialAccess) == OK)
		instance.SequentialAccess_isNULL = false;

	if (inst.getProperty("ExtentStatus", instance.ExtentStatus) == OK)
		instance.ExtentStatus_isNULL = false;

	if (inst.getProperty("NoSinglePointOfFailure", instance.NoSinglePointOfFailure) == OK)
		instance.NoSinglePointOfFailure_isNULL = false;

	if (inst.getProperty("DataRedundancy", instance.DataRedundancy) == OK)
		instance.DataRedundancy_isNULL = false;

	if (inst.getProperty("PackageRedundancy", instance.PackageRedundancy) == OK)
		instance.PackageRedundancy_isNULL = false;

	if (inst.getProperty("DeltaReservation", instance.DeltaReservation) == OK)
		instance.DeltaReservation_isNULL = false;

	if (inst.getProperty("Primordial", instance.Primordial) == OK)
		instance.Primordial_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("NameFormat", instance.NameFormat) == OK)
		instance.NameFormat_isNULL = false;

	if (inst.getProperty("NameNamespace", instance.NameNamespace) == OK)
		instance.NameNamespace_isNULL = false;

	if (inst.getProperty("OtherNameNamespace", instance.OtherNameNamespace) == OK)
		instance.OtherNameNamespace_isNULL = false;

	if (inst.getProperty("OtherNameFormat", instance.OtherNameFormat) == OK)
		instance.OtherNameFormat_isNULL = false;

	if (inst.getProperty("Usage", instance.Usage) == OK)
		instance.Usage_isNULL = false;

	if (inst.getProperty("OtherUsageDescription", instance.OtherUsageDescription) == OK)
		instance.OtherUsageDescription_isNULL = false;

	if (inst.getProperty("ClientSettableUsage", instance.ClientSettableUsage) == OK)
		instance.ClientSettableUsage_isNULL = false;

	if (inst.getProperty("Volatile", instance.Volatile) == OK)
		instance.Volatile_isNULL = false;

	if (inst.getProperty("ErrorMethodology", instance.ErrorMethodology) == OK)
		instance.ErrorMethodology_isNULL = false;

	if (inst.getProperty("StartingAddress", instance.StartingAddress) == OK)
		instance.StartingAddress_isNULL = false;

	if (inst.getProperty("EndingAddress", instance.EndingAddress) == OK)
		instance.EndingAddress_isNULL = false;

	if (inst.getProperty("ErrorInfo", instance.ErrorInfo) == OK)
		instance.ErrorInfo_isNULL = false;

	if (inst.getProperty("OtherErrorDescription", instance.OtherErrorDescription) == OK)
		instance.OtherErrorDescription_isNULL = false;

	if (inst.getProperty("CorrectableError", instance.CorrectableError) == OK)
		instance.CorrectableError_isNULL = false;

	if (inst.getPropertyDatetime("ErrorTime", instance.ErrorTime) == OK)
		instance.ErrorTime_isNULL = false;

	if (inst.getProperty("ErrorAccess", instance.ErrorAccess) == OK)
		instance.ErrorAccess_isNULL = false;

	if (inst.getProperty("ErrorTransferSize", instance.ErrorTransferSize) == OK)
		instance.ErrorTransferSize_isNULL = false;

	if (inst.getProperty("ErrorData", instance.ErrorData) == OK)
		instance.ErrorData_isNULL = false;

	if (inst.getProperty("ErrorDataOrder", instance.ErrorDataOrder) == OK)
		instance.ErrorDataOrder_isNULL = false;

	if (inst.getProperty("ErrorAddress", instance.ErrorAddress) == OK)
		instance.ErrorAddress_isNULL = false;

	if (inst.getProperty("SystemLevelAddress", instance.SystemLevelAddress) == OK)
		instance.SystemLevelAddress_isNULL = false;

	if (inst.getProperty("ErrorResolution", instance.ErrorResolution) == OK)
		instance.ErrorResolution_isNULL = false;

	if (inst.getProperty("AdditionalErrorData", instance.AdditionalErrorData) == OK)
		instance.AdditionalErrorData_isNULL = false;

	_L_;
}

void CPU_OpenDRIM_CacheMemory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_CacheMemory_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}			

	_L_;
}

void CPU_OpenDRIM_CacheMemory_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_CacheMemory_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
void CPU_OpenDRIM_CacheMemory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_CacheMemory_SetPowerState_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short PowerState;
	data = in->ft->getArg(in, "PowerState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, PowerState);	
		args.setPowerState(PowerState);
	}			

	string Time;
	data = in->ft->getArg(in, "Time", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, Time);	
		args.setTime(Time);
	}			

	_L_;
}

void CPU_OpenDRIM_CacheMemory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_CacheMemory_EnableDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Enabled;
	data = in->ft->getArg(in, "Enabled", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Enabled);	
		args.setEnabled(Enabled);
	}			

	_L_;
}

void CPU_OpenDRIM_CacheMemory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_CacheMemory_OnlineDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Online;
	data = in->ft->getArg(in, "Online", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Online);	
		args.setOnline(Online);
	}			

	_L_;
}

void CPU_OpenDRIM_CacheMemory_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_CacheMemory_QuiesceDevice_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	bool Quiesce;
	data = in->ft->getArg(in, "Quiesce", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, Quiesce);	
		args.setQuiesce(Quiesce);
	}			

	_L_;
}

