/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_PHYSICALASSETCAPABILITIESTOPHYSICALELEMENTACCESS_H_
#define OPENDRIM_PHYSICALASSETCAPABILITIESTOPHYSICALELEMENTACCESS_H_

#include "PhysicalAsset_Common.h"

#include "OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement.h"
#include "assocOpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement.h"

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_load(const CMPIBroker* broker, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_unload(string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement& instance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement& newInstance, const OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement& oldInstance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement>& OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement>& OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement_populate(OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement& instance, string& errorMessage);

#endif /*OPENDRIM_PHYSICALASSETCAPABILITIESTOPHYSICALELEMENTACCESS_H_*/
