#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Return to Mysterious Island
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250803.4

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='return-to-mysterious-island-1'
GAME_NAME='Return to Mysterious Island'

ARCHIVE_BASE_FR_0_NAME='setup_return_to_mysterious_island_1.03_lang_fix_(french)_(64086).exe'
ARCHIVE_BASE_FR_0_MD5='57c1c94d9b9433eeeba1fb524e720d82'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='1166500'
ARCHIVE_BASE_FR_0_VERSION='1.03-gog64086'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/return_to_mysterious_island'

ARCHIVE_BASE_US_0_NAME='setup_return_to_mysterious_island_1.03_lang_fix_(64086).exe'
ARCHIVE_BASE_US_0_MD5='ddf2151a68bf9abc31ec93246e517b39'
ARCHIVE_BASE_US_0_TYPE='innosetup'
ARCHIVE_BASE_US_0_SIZE='1166430'
ARCHIVE_BASE_US_0_VERSION='1.03-gog64086'
ARCHIVE_BASE_US_0_URL='https://www.gog.com/game/return_to_mysterious_island'

ARCHIVE_BASE_MULTILANG_0_NAME='setup_return_to_mysterious_island_2.1.0.17.exe'
ARCHIVE_BASE_MULTILANG_0_MD5='d31567796e419eb0c295bf978aa1d434'
ARCHIVE_BASE_MULTILANG_0_TYPE='innosetup'
ARCHIVE_BASE_MULTILANG_0_SIZE='1500000'
ARCHIVE_BASE_MULTILANG_0_VERSION='1.0-gog2.1.0.17'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_MULTILANG='app'
CONTENT_GAME_BIN_FILES='
cpuinf32.dll
ddraw.dll
ijl15.dll
spr.dll
game.exe'
CONTENT_GAME_L10N_FILES='
datas/loc
datas/cd?/loc_??_*'
CONTENT_GAME0_L10N_RELATIVE_PATH='__support/app'
CONTENT_GAME0_L10N_FILES='
config.ini'
CONTENT_GAME_L10N_FR_FILES='
datas/loc/fr
datas/cd?/loc_fr_*'
CONTENT_GAME_L10N_GE_FILES='
datas/loc/ge
datas/cd?/loc_ge_*'
CONTENT_GAME_L10N_IT_FILES='
datas/loc/it
datas/cd?/loc_it_*'
CONTENT_GAME_L10N_SP_FILES='
datas/loc/sp
datas/cd?/loc_sp_*'
CONTENT_GAME_L10N_RU_FILES='
datas/loc/ru
datas/cd?/loc_ru_*'
CONTENT_GAME_L10N_US_FILES='
datas/loc/us
datas/cd?/loc_us_*'
CONTENT_GAME_DATA_FILES='
datas'

USER_PERSISTENT_DIRECTORIES='
users'

APP_MAIN_EXE='game.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'
PACKAGES_LIST_MULTILANG='
PKG_BIN
PKG_L10N_FR
PKG_L10N_GE
PKG_L10N_IT
PKG_L10N_SP
PKG_L10N_RU
PKG_L10N_US
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'
## Easier upgrades from pre-20240825.1 packages
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}"'
retour-sur-lile-mysterieuse
retour-sur-lile-mysterieuse-1'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
## Single localisation installers
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_ID_US="${PKG_L10N_BASE_ID}-us"
## Multi-languages installers
PKG_L10N_FR_ID="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_GE_ID="${PKG_L10N_BASE_ID}-ge"
PKG_L10N_IT_ID="${PKG_L10N_BASE_ID}-it"
PKG_L10N_SP_ID="${PKG_L10N_BASE_ID}-sp"
PKG_L10N_RU_ID="${PKG_L10N_BASE_ID}-ru"
PKG_L10N_US_ID="${PKG_L10N_BASE_ID}-us"
## Single localisation installers
PKG_L10N_DESCRIPTION_FR='French localization'
PKG_L10N_DESCRIPTION_US='English localization'
## Multi-languages installers
PKG_L10N_FR_DESCRIPTION='French localization'
PKG_L10N_GE_DESCRIPTION='German localization'
PKG_L10N_IT_DESCRIPTION='Italian localization'
PKG_L10N_SP_DESCRIPTION='Spanish localization'
PKG_L10N_RU_DESCRIPTION='Russian localization'
PKG_L10N_US_DESCRIPTION='English localization'
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
## Easier upgrades from pre-20240825.1 packages
PKG_L10N_PROVIDES="${PKG_L10N_PROVIDES:-}"'
retour-sur-lile-mysterieuse-l10n
retour-sur-lile-mysterieuse-1-l10n'
PKG_L10N_FR_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_GE_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_IT_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_SP_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_RU_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_US_PROVIDES="$PKG_L10N_PROVIDES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20240825.1 packages
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}"'
retour-sur-lile-mysterieuse-data
retour-sur-lile-mysterieuse-1-data'

# dos2unix is required to edit INI configuration files.

REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
dos2unix"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

## Fix game install path in configuration.
case "$(current_archive)" in
	('ARCHIVE_BASE_MULTILANG_'*)
		ini_file="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/config.ini"
	;;
	(*)
		ini_file="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/__support/app/config.ini"
	;;
esac
ini_field='PATH'
# shellcheck disable=SC1003
ini_value='C:\\'"$(game_id)"'\\datas'
sed_expression="s/^${ini_field}=.*/${ini_field}=${ini_value}/"
dos2unix --quiet "$ini_file"
sed --in-place --expression="$sed_expression" "$ini_file"
unix2dos --quiet "$ini_file"

## Fix language setting for French localisation.
case "$(current_archive)" in
	('ARCHIVE_BASE_FR_'*)
		ini_file="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/__support/app/config.ini"
		ini_field='LOC'
		# shellcheck disable=SC1003
		ini_value='FR'
		sed_expression="s/^${ini_field}=.*/${ini_field}=${ini_value}/"
		dos2unix --quiet "$ini_file"
		sed --in-place --expression="$sed_expression" "$ini_file"
		unix2dos --quiet "$ini_file"
	;;
esac

# Include game data.

## Include configuration file in localisation packages.
case "$(current_archive)" in
	('ARCHIVE_BASE_MULTILANG_'*)
		config_file='config.ini'
		config_directory_source="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
		ini_field='LOC'
		dos2unix --quiet "${config_directory_source}/${config_file}"
		for lang in \
			'FR' \
			'GE' \
			'IT' \
			'RU' \
			'SP' \
			'US'
		do
			config_directory_destination="$(package_path "PKG_L10N_${lang}")$(path_game_data)"
			ini_value="$lang"
			sed_expression="s/^${ini_field}=.*/${ini_field}=${ini_value}/"
			mkdir --parents "$config_directory_destination"
			sed --expression="$sed_expression" \
				"${config_directory_source}/${config_file}" \
				> "${config_directory_destination}/${config_file}"
			unix2dos --quiet "${config_directory_destination}/${config_file}"
		done
	;;
esac
content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
case "$(current_archive)" in
	('ARCHIVE_BASE_MULTILANG_'*)
		case "$(messages_language)" in
			('fr')
				message='version %s :'
				lang_fr='française'
				lang_ge='allemande'
				lang_it='italienne'
				lang_sp='espagnole'
				lang_ru='russe'
				lang_us='anglaise'
			;;
			('en'|*)
				message='%s version:'
				lang_fr='French'
				lang_ge='German'
				lang_it='Italian'
				lang_sp='Spanish'
				lang_ru='Russian'
				lang_us='English'
			;;
		esac
		printf '\n'
		printf "$message" "$lang_fr"
		print_instructions 'PKG_BIN' 'PKG_L10N_FR' 'PKG_DATA'
		printf "$message" "$lang_ge"
		print_instructions 'PKG_BIN' 'PKG_L10N_GE' 'PKG_DATA'
		printf "$message" "$lang_it"
		print_instructions 'PKG_BIN' 'PKG_L10N_IT' 'PKG_DATA'
		printf "$message" "$lang_sp"
		print_instructions 'PKG_BIN' 'PKG_L10N_SP' 'PKG_DATA'
		printf "$message" "$lang_ru"
		print_instructions 'PKG_BIN' 'PKG_L10N_RU' 'PKG_DATA'
		printf "$message" "$lang_us"
		print_instructions 'PKG_BIN' 'PKG_L10N_US' 'PKG_DATA'
	;;
	(*)
		print_instructions
	;;
esac

# Clean up

working_directory_cleanup

exit 0
