#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Good Snowman is Hard to Build
# send your bug reports to contact@dotslashplay.it
###

script_version=20250228.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='a-good-snowman-is-hard-to-build'
GAME_NAME='A Good Snowman is Hard to Build'

ARCHIVE_BASE_ITCH_0_NAME='snowman-linux.tar.gz'
ARCHIVE_BASE_ITCH_0_MD5='3136269cf9d5d81483705c433660b7ab'
ARCHIVE_BASE_ITCH_0_SIZE='206249'
ARCHIVE_BASE_ITCH_0_VERSION='1.0-itch.2025.02.26'
ARCHIVE_BASE_ITCH_0_URL='https://draknek.itch.io/a-good-snowman'

## This DRM-free installer is no longer available for sale from humblebundle.com.
ARCHIVE_BASE_HUMBLE_0_NAME='snowman-linux-1.0.8.tar.gz'
ARCHIVE_BASE_HUMBLE_0_MD5='4461dfdcaba9e8793e3044b458b0e301'
ARCHIVE_BASE_HUMBLE_0_SIZE='120000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0.8-humble160421'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='a-good-snowman-is-hard-to-build_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='8d595a7758ae8cd6dbc441ab79579fb4'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/a-good-snowman-is-hard-to-build/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
24x24
32x32
40x40
48x48
64x64
96x96
128x128
256x256
512x512
768x768'

CONTENT_PATH_DEFAULT_ITCH='.'
CONTENT_PATH_DEFAULT_HUMBLE='snowman'
CONTENT_LIBS_FILES='
lime-legacy.ndll
regexp.dso
std.dso
zlib.dso'
CONTENT_LIBS_BIN64_RELATIVE_PATH='bin64'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH='bin32'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_FILES"
CONTENT_GAME_BIN64_FILES='
bin64/Snowman'
CONTENT_GAME_BIN32_FILES='
bin32/Snowman'
CONTENT_GAME_DATA_FILES='
atlases
crashdumper
fonts
libraries
music
resources
sounds
spritesheets
manifest
strings'

APP_MAIN_EXE_BIN64='bin64/Snowman'
APP_MAIN_EXE_BIN32='bin32/Snowman'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN32_ARCH='32'
PKG_BIN64_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6'
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default
## The game engine looks for lime-legacy.ndll in a hardcoded path
ln --symbolic \
	"$(path_libraries)/lime-legacy.ndll" \
	"$(package_path 'PKG_BIN64')$(path_game_data)"
ln --symbolic \
	"$(path_libraries)/lime-legacy.ndll" \
	"$(package_path 'PKG_BIN32')$(path_game_data)"

# Write launchers

## Force the use of system-provided SDL
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
