#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dracula: Love Kills
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250307.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='dracula-love-kills'
GAME_NAME='Dracula: Love Kills'

ARCHIVE_BASE_EN_0_NAME='setup_dracula_love_kills_1.0_(31713).exe'
ARCHIVE_BASE_EN_0_MD5='df1dc685677ed169914c9a1d96f47e32'
ARCHIVE_BASE_EN_0_SIZE='467145'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog31713'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/dracula_love_kills'

ARCHIVE_BASE_FR_0_NAME='setup_dracula_love_kills_1.0_(french)_(31713).exe'
ARCHIVE_BASE_FR_0_MD5='7f7d9011c141b5658d2d09ccdb43b45a'
ARCHIVE_BASE_FR_0_SIZE='467193'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog31713'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/dracula_love_kills'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
d3dx9_42.dll
msvcr71.dll
dracula_love_kills.exe'
CONTENT_GAME_L10N_FILES='
game.ini
000/game.pak
000/sounds.pak'
CONTENT_GAME_L10N_FILES_EN="$CONTENT_GAME_L10N_FILES
000/en.pak
000/sounds_en.pak
000/logo_en.pak"
CONTENT_GAME_L10N_FILES_FR="$CONTENT_GAME_L10N_FILES
000/fr.pak
000/sounds_fr.pak"
CONTENT_GAME_DATA_FILES='
branding
cursor
shaders.0050
user.ini
data.txt
000/movie.pak
000/texture.pak'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Frogwares/Dracula. Love Kills'

APP_MAIN_EXE='dracula_love_kills.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
