#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (species packs):
# - Plantoids
# - Humanoids
# - Lithoids
# - Necroids
# - Aquatics
# - Toxoids
###

script_version=20240127.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_PLANTOID='plantoid'
EXPANSION_NAME_PLANTOID='Plantoids Species Pack'

EXPANSION_ID_HUMANOIDS='humanoids'
EXPANSION_NAME_HUMANOIDS='Humanoids Species Pack'

EXPANSION_ID_LITHOIDS='lithoids'
EXPANSION_NAME_LITHOIDS='Lithoids Species Pack'

EXPANSION_ID_NECROIDS='necroids'
EXPANSION_NAME_NECROIDS='Necroids Species Pack'

EXPANSION_ID_AQUATICS='aquatics'
EXPANSION_NAME_AQUATICS='Aquatics Species Pack'

EXPANSION_ID_TOXOIDS='toxoids'
EXPANSION_NAME_TOXOIDS='Toxoids Species Pack'

# Archives

## Plantoids

ARCHIVE_BASE_PLANTOID_49_NAME='stellaris_plantoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_PLANTOID_49_MD5='fc70ea7215520e885c61d072463b9be4'
ARCHIVE_BASE_PLANTOID_49_SIZE='837'
ARCHIVE_BASE_PLANTOID_49_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_PLANTOID_49_URL='https://www.gog.com/game/stellaris_plantoids_species_pack'

ARCHIVE_BASE_PLANTOID_48_NAME='stellaris_plantoids_species_pack_3_10_4_69706.sh'
ARCHIVE_BASE_PLANTOID_48_MD5='f95d0360d70f2c241ff8577c12145663'
ARCHIVE_BASE_PLANTOID_48_SIZE='837'
ARCHIVE_BASE_PLANTOID_48_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_PLANTOID_47_NAME='stellaris_plantoids_species_pack_3_10_3_69539.sh'
ARCHIVE_BASE_PLANTOID_47_MD5='8df08ad91b367aee5a963564fa09d387'
ARCHIVE_BASE_PLANTOID_47_SIZE='1156'
ARCHIVE_BASE_PLANTOID_47_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_PLANTOID_46_NAME='stellaris_plantoids_species_pack_3_10_2_69346.sh'
ARCHIVE_BASE_PLANTOID_46_MD5='838cf84e76f3dc9782874c6c32a2eb73'
ARCHIVE_BASE_PLANTOID_46_SIZE='1156'
ARCHIVE_BASE_PLANTOID_46_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_PLANTOID_45_NAME='stellaris_plantoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_PLANTOID_45_MD5='f46acc22db074dabbfffdc552fe10ab3'
ARCHIVE_BASE_PLANTOID_45_SIZE='1156'
ARCHIVE_BASE_PLANTOID_45_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_PLANTOID_44_NAME='stellaris_plantoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_PLANTOID_44_MD5='a6bde010ae32ebc8b7827d54dd873f29'
ARCHIVE_BASE_PLANTOID_44_SIZE='1156'
ARCHIVE_BASE_PLANTOID_44_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_PLANTOID_43_NAME='stellaris_plantoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_PLANTOID_43_MD5='f38e8c826f876f52cea68b69f85ca079'
ARCHIVE_BASE_PLANTOID_43_SIZE='1156'
ARCHIVE_BASE_PLANTOID_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_PLANTOID_40_NAME='stellaris_plantoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_PLANTOID_40_MD5='c64fed3a260b17bdb07e439dc20304c7'
ARCHIVE_BASE_PLANTOID_40_SIZE='1200'
ARCHIVE_BASE_PLANTOID_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_PLANTOID_39_NAME='stellaris_plantoids_species_pack_3_8_3_1_64953.sh'
ARCHIVE_BASE_PLANTOID_39_MD5='7b0cec949d962b027bc7bd108d79eeaf'
ARCHIVE_BASE_PLANTOID_39_SIZE='1200'
ARCHIVE_BASE_PLANTOID_39_VERSION='3.8.3.1-gog64953'

ARCHIVE_BASE_PLANTOID_36_NAME='stellaris_plantoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_PLANTOID_36_MD5='5a2a9101e09cddc83e29c802b33639ed'
ARCHIVE_BASE_PLANTOID_36_SIZE='1200'
ARCHIVE_BASE_PLANTOID_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_PLANTOID_33_NAME='stellaris_plantoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_PLANTOID_33_MD5='298bdd7c0f717f90c2045d0c9a68c1c9'
ARCHIVE_BASE_PLANTOID_33_SIZE='1200'
ARCHIVE_BASE_PLANTOID_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_PLANTOID_31_NAME='stellaris_plantoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_PLANTOID_31_MD5='fabc6b9d5580dac6a456da962a765709'
ARCHIVE_BASE_PLANTOID_31_SIZE='1200'
ARCHIVE_BASE_PLANTOID_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_PLANTOID_29_NAME='stellaris_plantoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_PLANTOID_29_MD5='b2b5023834509b4a5c2a12bb345380a1'
ARCHIVE_BASE_PLANTOID_29_SIZE='1200'
ARCHIVE_BASE_PLANTOID_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_PLANTOID_25_NAME='stellaris_plantoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_PLANTOID_25_MD5='b8ea82b781639c7031ea53d4e155c5d1'
ARCHIVE_BASE_PLANTOID_25_SIZE='1200'
ARCHIVE_BASE_PLANTOID_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_PLANTOID_21_NAME='stellaris_plantoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_PLANTOID_21_MD5='260d8bc704b93f307d31807efbb5568f'
ARCHIVE_BASE_PLANTOID_21_SIZE='1200'
ARCHIVE_BASE_PLANTOID_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_PLANTOID_20_NAME='stellaris_plantoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_PLANTOID_20_MD5='fb947af6a98e45645b482a484bd6d42e'
ARCHIVE_BASE_PLANTOID_20_SIZE='1200'
ARCHIVE_BASE_PLANTOID_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_PLANTOID_19_NAME='stellaris_plantoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_PLANTOID_19_MD5='d1dc616e45d6d035ed3414687228f95a'
ARCHIVE_BASE_PLANTOID_19_SIZE='1200'
ARCHIVE_BASE_PLANTOID_19_VERSION='3.0.3-gog47193'

## Humanoids

ARCHIVE_BASE_HUMANOIDS_49_NAME='stellaris_humanoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_HUMANOIDS_49_MD5='515dd7f2ae1c68fe53a589f77b7af19c'
ARCHIVE_BASE_HUMANOIDS_49_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_49_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_HUMANOIDS_49_URL='https://www.gog.com/game/stellaris_humanoids_species_pack'

ARCHIVE_BASE_HUMANOIDS_48_NAME='stellaris_humanoids_species_pack_3_10_4_69706.sh'
ARCHIVE_BASE_HUMANOIDS_48_MD5='3c9e030365d288f26f8d3f6dbb3d9625'
ARCHIVE_BASE_HUMANOIDS_48_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_48_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_HUMANOIDS_47_NAME='stellaris_humanoids_species_pack_3_10_3_69539.sh'
ARCHIVE_BASE_HUMANOIDS_47_MD5='2a7a49e7029dad68580992dc7fcc5030'
ARCHIVE_BASE_HUMANOIDS_47_SIZE='116632'
ARCHIVE_BASE_HUMANOIDS_47_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_HUMANOIDS_46_NAME='stellaris_humanoids_species_pack_3_10_2_69346.sh'
ARCHIVE_BASE_HUMANOIDS_46_MD5='59ef453ddcc80b9fcddc07bdfbfaa4dd'
ARCHIVE_BASE_HUMANOIDS_46_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_46_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_HUMANOIDS_45_NAME='stellaris_humanoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_HUMANOIDS_45_MD5='ec7e9435a832ba018b188834412be163'
ARCHIVE_BASE_HUMANOIDS_45_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_45_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_HUMANOIDS_44_NAME='stellaris_humanoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_HUMANOIDS_44_MD5='3c81b11d1da6888915d7fcd4ceb3c51b'
ARCHIVE_BASE_HUMANOIDS_44_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_44_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_HUMANOIDS_43_NAME='stellaris_humanoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_HUMANOIDS_43_MD5='d970689331dfae6ad559b4dd8d146080'
ARCHIVE_BASE_HUMANOIDS_43_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_HUMANOIDS_40_NAME='stellaris_humanoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_HUMANOIDS_40_MD5='435cdbbe3a8affded29b3b6f9d36125a'
ARCHIVE_BASE_HUMANOIDS_40_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_HUMANOIDS_36_NAME='stellaris_humanoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_HUMANOIDS_36_MD5='de7661496eba8a9d125b44f3075a71b7'
ARCHIVE_BASE_HUMANOIDS_36_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_HUMANOIDS_33_NAME='stellaris_humanoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_HUMANOIDS_33_MD5='5124b47dce3c7a7282087e521920fee9'
ARCHIVE_BASE_HUMANOIDS_33_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_HUMANOIDS_31_NAME='stellaris_humanoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_HUMANOIDS_31_MD5='9f92e8b6853b26bc31da38b5a0991a37'
ARCHIVE_BASE_HUMANOIDS_31_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_HUMANOIDS_29_NAME='stellaris_humanoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_HUMANOIDS_29_MD5='5fcd93a54b01f93bae743d49bf61860b'
ARCHIVE_BASE_HUMANOIDS_29_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_HUMANOIDS_25_NAME='stellaris_humanoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_HUMANOIDS_25_MD5='b7ccaa9303516274f7945882bd6a2d2f'
ARCHIVE_BASE_HUMANOIDS_25_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_HUMANOIDS_21_NAME='stellaris_humanoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_HUMANOIDS_21_MD5='d56625b5ce55405530929bea32852f54'
ARCHIVE_BASE_HUMANOIDS_21_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_HUMANOIDS_20_NAME='stellaris_humanoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_HUMANOIDS_20_MD5='974908ceeb80ade57dfa00c957604d06'
ARCHIVE_BASE_HUMANOIDS_20_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_HUMANOIDS_19_NAME='stellaris_humanoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_HUMANOIDS_19_MD5='9dc8511383a7c36c54660d6d77d61117'
ARCHIVE_BASE_HUMANOIDS_19_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_19_VERSION='3.0.3-gog47193'

## Lithoids

ARCHIVE_BASE_LITHOIDS_37_NAME='stellaris_lithoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_LITHOIDS_37_MD5='96caaa7c76349f34823372cc7f9dc769'
ARCHIVE_BASE_LITHOIDS_37_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_37_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_LITHOIDS_37_URL='https://www.gog.com/game/stellaris_lithoids_species_pack'

ARCHIVE_BASE_LITHOIDS_36_NAME='stellaris_lithoids_species_pack_3_10_4_69706.sh'
ARCHIVE_BASE_LITHOIDS_36_MD5='b2bd55d83b031d26cad001cd34ede628'
ARCHIVE_BASE_LITHOIDS_36_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_36_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_LITHOIDS_35_NAME='stellaris_lithoids_species_pack_3_10_3_69539.sh'
ARCHIVE_BASE_LITHOIDS_35_MD5='eb77bfefd574709e2d5d68a3cee305bd'
ARCHIVE_BASE_LITHOIDS_35_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_35_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_LITHOIDS_34_NAME='stellaris_lithoids_species_pack_3_10_2_69346.sh'
ARCHIVE_BASE_LITHOIDS_34_MD5='f10dcb66e8e1de829d5b93654af83c34'
ARCHIVE_BASE_LITHOIDS_34_SIZE='52928'
ARCHIVE_BASE_LITHOIDS_34_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_LITHOIDS_33_NAME='stellaris_lithoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_LITHOIDS_33_MD5='95a043b540c05e66d5aa6444cde39a78'
ARCHIVE_BASE_LITHOIDS_33_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_33_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_LITHOIDS_32_NAME='stellaris_lithoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_LITHOIDS_32_MD5='7b67f6a6bed2c9a78cf23ede66fa4a9d'
ARCHIVE_BASE_LITHOIDS_32_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_32_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_LITHOIDS_31_NAME='stellaris_lithoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_LITHOIDS_31_MD5='baecdaa00168fe891ff419b71334f313'
ARCHIVE_BASE_LITHOIDS_31_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_LITHOIDS_28_NAME='stellaris_lithoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_LITHOIDS_28_MD5='65723d6948a9380c1397b280f9bc20f4'
ARCHIVE_BASE_LITHOIDS_28_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_LITHOIDS_24_NAME='stellaris_lithoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_LITHOIDS_24_MD5='bfc5632131852032fda229260aa179d6'
ARCHIVE_BASE_LITHOIDS_24_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_LITHOIDS_21_NAME='stellaris_lithoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_LITHOIDS_21_MD5='0adc3e342f420e26a04b256595eee248'
ARCHIVE_BASE_LITHOIDS_21_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_LITHOIDS_19_NAME='stellaris_lithoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_LITHOIDS_19_MD5='30bac0aa5302f556fb13511df2e8194b'
ARCHIVE_BASE_LITHOIDS_19_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_LITHOIDS_17_NAME='stellaris_lithoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_LITHOIDS_17_MD5='54fb17af3ed8b442074c83cf2b818693'
ARCHIVE_BASE_LITHOIDS_17_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_LITHOIDS_13_NAME='stellaris_lithoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_LITHOIDS_13_MD5='cde1e9ed0deaeff8850242e4157783be'
ARCHIVE_BASE_LITHOIDS_13_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_LITHOIDS_9_NAME='stellaris_lithoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_LITHOIDS_9_MD5='ed5aca5df6d72a84f0572200e1d432fe'
ARCHIVE_BASE_LITHOIDS_9_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_LITHOIDS_8_NAME='stellaris_lithoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_LITHOIDS_8_MD5='c935a54a2e9ac78d195440d7ca1391f9'
ARCHIVE_BASE_LITHOIDS_8_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_LITHOIDS_7_NAME='stellaris_lithoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_LITHOIDS_7_MD5='44a8e1008468825af82ec138be388fe9'
ARCHIVE_BASE_LITHOIDS_7_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_7_VERSION='3.0.3-gog47193'

## Necroids

ARCHIVE_BASE_NECROIDS_22_NAME='stellaris_necroids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_NECROIDS_22_MD5='5549b1dfec82af2de64537ed751a1920'
ARCHIVE_BASE_NECROIDS_22_SIZE='49209'
ARCHIVE_BASE_NECROIDS_22_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_NECROIDS_22_URL='https://www.gog.com/game/stellaris_necroids_species_pack'

ARCHIVE_BASE_NECROIDS_21_NAME='stellaris_necroids_species_pack_3_10_4_69706.sh'
ARCHIVE_BASE_NECROIDS_21_MD5='4d085fb00b919e41b674e545b5249df3'
ARCHIVE_BASE_NECROIDS_21_SIZE='49209'
ARCHIVE_BASE_NECROIDS_21_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_NECROIDS_20_NAME='stellaris_necroids_species_pack_3_10_3_69539.sh'
ARCHIVE_BASE_NECROIDS_20_MD5='2964d6e9254f558fe50c48a4b8109a05'
ARCHIVE_BASE_NECROIDS_20_SIZE='49524'
ARCHIVE_BASE_NECROIDS_20_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_NECROIDS_19_NAME='stellaris_necroids_species_pack_3_10_2_69346.sh'
ARCHIVE_BASE_NECROIDS_19_MD5='911ef2256a0e267c194bfca7d0ec2216'
ARCHIVE_BASE_NECROIDS_19_SIZE='49528'
ARCHIVE_BASE_NECROIDS_19_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_NECROIDS_18_NAME='stellaris_necroids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_NECROIDS_18_MD5='a9478a35f71b02a14de72bda03692b34'
ARCHIVE_BASE_NECROIDS_18_SIZE='49524'
ARCHIVE_BASE_NECROIDS_18_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_NECROIDS_17_NAME='stellaris_necroids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_NECROIDS_17_MD5='3949c02f1d073b1174ae274a9a3998ff'
ARCHIVE_BASE_NECROIDS_17_SIZE='49524'
ARCHIVE_BASE_NECROIDS_17_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_NECROIDS_16_NAME='stellaris_necroids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_NECROIDS_16_MD5='8afbc28fb3af625dd145381e44fe7bde'
ARCHIVE_BASE_NECROIDS_16_SIZE='49524'
ARCHIVE_BASE_NECROIDS_16_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_NECROIDS_13_NAME='stellaris_necroids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_NECROIDS_13_MD5='2614b147a120b97e0d5e4f0a24719f82'
ARCHIVE_BASE_NECROIDS_13_SIZE='50000'
ARCHIVE_BASE_NECROIDS_13_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_NECROIDS_9_NAME='stellaris_necroids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_NECROIDS_9_MD5='631269beefca458e901a727af53e09d0'
ARCHIVE_BASE_NECROIDS_9_SIZE='50000'
ARCHIVE_BASE_NECROIDS_9_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_NECROIDS_6_NAME='stellaris_necroids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_NECROIDS_6_MD5='13605c18c7d483b3c8abeff2d60c65f7'
ARCHIVE_BASE_NECROIDS_6_SIZE='50000'
ARCHIVE_BASE_NECROIDS_6_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_NECROIDS_4_NAME='stellaris_necroids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_NECROIDS_4_MD5='23faec896d52d6f2773e19838f365113'
ARCHIVE_BASE_NECROIDS_4_SIZE='50000'
ARCHIVE_BASE_NECROIDS_4_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_NECROIDS_2_NAME='stellaris_necroids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_NECROIDS_2_MD5='e64ecf03e49671cedf3e164709a5837a'
ARCHIVE_BASE_NECROIDS_2_SIZE='50000'
ARCHIVE_BASE_NECROIDS_2_VERSION='3.4.5-gog56913'

## Aquatics

ARCHIVE_BASE_AQUATICS_20_NAME='stellaris_aquatics_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_AQUATICS_20_MD5='335d95744fa5467cad87e276fb8d6997'
ARCHIVE_BASE_AQUATICS_20_SIZE='120876'
ARCHIVE_BASE_AQUATICS_20_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_AQUATICS_20_URL='https://www.gog.com/game/stellaris_aquatics_species_pack'

ARCHIVE_BASE_AQUATICS_19_NAME='stellaris_aquatics_species_pack_3_10_4_69706.sh'
ARCHIVE_BASE_AQUATICS_19_MD5='2fdb60088aa8acb3900a6efa98c55b07'
ARCHIVE_BASE_AQUATICS_19_SIZE='120876'
ARCHIVE_BASE_AQUATICS_19_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_AQUATICS_18_NAME='stellaris_aquatics_species_pack_3_10_3_69539.sh'
ARCHIVE_BASE_AQUATICS_18_MD5='2f446801a28f11c448bdcad3c2ac9e17'
ARCHIVE_BASE_AQUATICS_18_SIZE='121452'
ARCHIVE_BASE_AQUATICS_18_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_AQUATICS_17_NAME='stellaris_aquatics_species_pack_3_10_2_69346.sh'
ARCHIVE_BASE_AQUATICS_17_MD5='d90720ccd040de1dd649ea43f7f74d1a'
ARCHIVE_BASE_AQUATICS_17_SIZE='121448'
ARCHIVE_BASE_AQUATICS_17_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_AQUATICS_16_NAME='stellaris_aquatics_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_AQUATICS_16_MD5='b542b48d85eba5667315557aca340278'
ARCHIVE_BASE_AQUATICS_16_SIZE='121448'
ARCHIVE_BASE_AQUATICS_16_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_AQUATICS_15_NAME='stellaris_aquatics_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_AQUATICS_15_MD5='bf594d37a181e555dcfcbe772e45a650'
ARCHIVE_BASE_AQUATICS_15_SIZE='121448'
ARCHIVE_BASE_AQUATICS_15_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_AQUATICS_14_NAME='stellaris_aquatics_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_AQUATICS_14_MD5='39294019e3f068916fea06f68e35b1ee'
ARCHIVE_BASE_AQUATICS_14_SIZE='121448'
ARCHIVE_BASE_AQUATICS_14_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_AQUATICS_11_NAME='stellaris_aquatics_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_AQUATICS_11_MD5='34a45daa4a4d1bf204dc9798917692b5'
ARCHIVE_BASE_AQUATICS_11_SIZE='130000'
ARCHIVE_BASE_AQUATICS_11_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_AQUATICS_7_NAME='stellaris_aquatics_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_AQUATICS_7_MD5='f825b3f150a7d936b04b3f5bd35d9f5b'
ARCHIVE_BASE_AQUATICS_7_SIZE='130000'
ARCHIVE_BASE_AQUATICS_7_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_AQUATICS_4_NAME='stellaris_aquatics_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_AQUATICS_4_MD5='5cfdb2861b8c3de9c83798799b477ad6'
ARCHIVE_BASE_AQUATICS_4_SIZE='130000'
ARCHIVE_BASE_AQUATICS_4_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_AQUATICS_2_NAME='stellaris_aquatics_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_AQUATICS_2_MD5='7e3210b2d64b851907a97ed3455ad035'
ARCHIVE_BASE_AQUATICS_2_SIZE='130000'
ARCHIVE_BASE_AQUATICS_2_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_AQUATICS_0_NAME='stellaris_aquatics_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_AQUATICS_0_MD5='0d6fe86d3ec24b114742a333b8de4a3b'
ARCHIVE_BASE_AQUATICS_0_SIZE='130000'
ARCHIVE_BASE_AQUATICS_0_VERSION='3.4.5-gog56913'

## Toxoids

ARCHIVE_BASE_TOXOIDS_13_NAME='stellaris_toxoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_TOXOIDS_13_MD5='ee41aba19af2f2f91bbe3c156bf614f5'
ARCHIVE_BASE_TOXOIDS_13_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_13_VERSION='3.10.4-gog70670'
ARCHIVE_BASE_TOXOIDS_13_URL='https://www.gog.com/game/stellaris_toxoids_species_pack'

ARCHIVE_BASE_TOXOIDS_12_NAME='stellaris_toxoids_species_pack_3_10_4_69706.sh'
ARCHIVE_BASE_TOXOIDS_12_MD5='89360920313849a557d4237be4c21dae'
ARCHIVE_BASE_TOXOIDS_12_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_12_VERSION='3.10.4-gog69706'

ARCHIVE_BASE_TOXOIDS_11_NAME='stellaris_toxoids_species_pack_3_10_3_69539.sh'
ARCHIVE_BASE_TOXOIDS_11_MD5='c9c63f397711deb35babe3cb51620723'
ARCHIVE_BASE_TOXOIDS_11_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_11_VERSION='3.10.3-gog69539'

ARCHIVE_BASE_TOXOIDS_10_NAME='stellaris_toxoids_species_pack_3_10_2_69346.sh'
ARCHIVE_BASE_TOXOIDS_10_MD5='9d31ec6ee301e4b8753cc105fd6e33dc'
ARCHIVE_BASE_TOXOIDS_10_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_10_VERSION='3.10.2-gog69346'

ARCHIVE_BASE_TOXOIDS_9_NAME='stellaris_toxoids_species_pack_3_10_1_69202.sh'
ARCHIVE_BASE_TOXOIDS_9_MD5='ff0eea40c4c5a3d94a137236ce5c6d9e'
ARCHIVE_BASE_TOXOIDS_9_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_9_VERSION='3.10.1-gog69202'

ARCHIVE_BASE_TOXOIDS_8_NAME='stellaris_toxoids_species_pack_3_10_0_2_68987.sh'
ARCHIVE_BASE_TOXOIDS_8_MD5='64c56e55ccfd2fb146425982b8d8e852'
ARCHIVE_BASE_TOXOIDS_8_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_8_VERSION='3.10.0.2-gog68987'

ARCHIVE_BASE_TOXOIDS_7_NAME='stellaris_toxoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_TOXOIDS_7_MD5='69ee5d18ffe310c64ee61934ec64aa1f'
ARCHIVE_BASE_TOXOIDS_7_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_7_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_TOXOIDS_4_NAME='stellaris_toxoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_TOXOIDS_4_MD5='90926bd74621bf180a074d4721b594f9'
ARCHIVE_BASE_TOXOIDS_4_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_4_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_TOXOIDS_0_NAME='stellaris_toxoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_TOXOIDS_0_MD5='e6af2b93063b67bc78d6a44c70caee1c'
ARCHIVE_BASE_TOXOIDS_0_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_0_VERSION='3.7.4-gog63489'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
