#!/bin/sh

# The first argument may have comment lines, and has a "p" line.  The
# second argument does not; it is typically generated by ./run.sh.

if [ $# -ne 2 ] ; then \
    echo "Usage:  $0 takes two arguments." ; \
    echo "        $0 cnf_in cnf_out" ; \
fi

export outfile=cnf_diff.out

grep -v '^[cp]' "$1" | diff -w "$2" - > $outfile

diff_status=$?

if [ -s "$outfile"  ] ; then \
    echo "The following command produced output:" ; \
    echo "grep -v" '^[cp]' "$1" "|" "diff -w $2 -" ; \
    echo "See file cnf_diff.out ."
    exit 1 ; \
elif [ $diff_status -ne 0 ] ; then \
    echo "The following command produced a non-zero exit status:" ; \
    echo "grep -v" '^[cp]' "$1" "|" "diff -w $2 -" ; \
    exit 1 ; \
else \
    echo "Success: CNF files $1 and $2 agree." ; \
fi
