/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:38:45 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder.ortholog;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class MatchPanel_ESTest extends MatchPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0, mSPcrunchDocumentEntry0, false);
      MatchPanel matchPanel0 = new MatchPanel((Feature) null, genbankDocumentEntry0);
      assertTrue(matchPanel0.isEmpty());
      
      matchPanel0.setEmpty(false);
      boolean boolean0 = matchPanel0.isEmpty();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      // Undeclared exception!
      try { 
        MatchPanel.isMatchTag((Qualifier) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      // Undeclared exception!
      try { 
        MatchPanel.isMatchTag((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        MatchPanel.isClusterTag((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MatchPanel matchPanel0 = new MatchPanel((Feature) null, (DocumentEntry) null);
      matchPanel0.getGeneNameList(true);
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      boolean boolean0 = MatchPanel.isMatchTag("|YZ");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0, mSPcrunchDocumentEntry0, false);
      MatchPanel matchPanel0 = new MatchPanel((Feature) null, genbankDocumentEntry0);
      boolean boolean0 = matchPanel0.isEmpty();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((Feature) null, genbankDocumentEntry0);
      matchPanel0.getMatchQualifiers();
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      boolean boolean0 = MatchPanel.isClusterTag("orthologous_to");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      boolean boolean0 = MatchPanel.isClusterTag("T)}:D");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      boolean boolean0 = MatchPanel.isMatchTag("paralogous_to");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Feature feature0 = new Feature(genbankStreamFeature0);
      MatchPanel matchPanel0 = new MatchPanel(feature0, (DocumentEntry) null);
      matchPanel0.updateFromFeature(feature0);
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      String string0 = MatchPanel.getDescription();
      assertEquals("Ortholog/Paralog/Similarity", string0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MatchPanel matchPanel0 = new MatchPanel((Feature) null, (DocumentEntry) null);
      matchPanel0.getGeneNameList();
      assertTrue(matchPanel0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      MatchPanel matchPanel0 = new MatchPanel((Feature) null, (DocumentEntry) null);
      QualifierVector qualifierVector0 = new QualifierVector();
      // Undeclared exception!
      try { 
        matchPanel0.updateFromQualifiers(qualifierVector0, (Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("|YZ", "|YZ");
      boolean boolean0 = MatchPanel.isMatchTag(qualifier0);
      assertFalse(boolean0);
  }
}
