//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/ColorMapSceneAdaptor.h
//! @brief     Defines class ColorMapSceneAdaptor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_COLORMAPSCENEADAPTOR_H
#define BORNAGAIN_GUI_VIEW_MASK_COLORMAPSCENEADAPTOR_H

#include "GUI/View/Mask/ISceneAdaptor.h"

class ColorMap;

//! Performs conversion of MaskItems coordinates between ColorMap and GraphicsScene.

class ColorMapSceneAdaptor : public ISceneAdaptor {
    Q_OBJECT
public:
    ColorMapSceneAdaptor();

    qreal toSceneX(qreal mask_x) const override;
    qreal toSceneY(qreal mask_y) const override;
    qreal fromSceneX(qreal scene_x) const override;
    qreal fromSceneY(qreal scene_y) const override;

    void setColorMapPlot(ColorMap* plot);

    bool eventFilter(QObject* object, QEvent* event) override;

    //! Returns ColorMapPlot axes rectangle (at current zoom level) in scene coordinates
    const QRectF& viewportRectangle() const override;

private:
    ColorMap* m_plot;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_COLORMAPSCENEADAPTOR_H
