/*
 * Copyright (C) 2021 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/test/common/test_macros/test.h"

#include "opencl/test/unit_test/mocks/mock_cl_device.h"
#include "opencl/test/unit_test/mocks/mock_kernel.h"

using namespace NEO;

using KernelTestPvcAndLater = ::testing::Test;
using isAtLeastPvc = IsAtLeastGfxCore<IGFX_XE_HPC_CORE>;
HWTEST2_F(KernelTestPvcAndLater, givenPolicyWhenSetKernelThreadArbitrationPolicyThenExpectedClValueIsReturned, isAtLeastPvc) {
    auto device = std::make_unique<MockClDevice>(MockDevice::createWithNewExecutionEnvironment<MockDevice>(defaultHwInfo.get()));
    MockKernelWithInternals kernel(*device);

    EXPECT_EQ(CL_SUCCESS, kernel.mockKernel->setKernelThreadArbitrationPolicy(CL_KERNEL_EXEC_INFO_THREAD_ARBITRATION_POLICY_STALL_BASED_ROUND_ROBIN_INTEL));
}
