; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
;
; RUN: igc_opt --igc-scalarize --opaque-pointers -S < %s | FileCheck %s
; REQUIRES: llvm-14-plus
; ------------------------------------------------
; ScalarizeFunction
; ------------------------------------------------
; The pass should break vector operation into many scalar operations
; ------------------------------------------------

define <2 x i32> @basic(i1 %switch, <2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i32> @basic(
; CHECK-SAME: i1 [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR4:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR3:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT1:%.*]] = phi i32 [ [[SRC1_SCALAR]], %[[FIRST]] ], [ [[SRC2_SCALAR]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT2:%.*]] = phi i32 [ [[SRC1_SCALAR3]], %[[FIRST]] ], [ [[SRC2_SCALAR4]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[RESULT1]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT5:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT2]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT5]]
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <2 x i32> [ %src1, %first], [ %src2, %second]
  ret <2 x i32> %result
}

define <2 x i32> @should_preserve_metadata(i1 %switch, <2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i32> @should_preserve_metadata(
; CHECK-SAME: i1 [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR4:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR3:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT1:%.*]] = phi i32 [ [[SRC1_SCALAR]], %[[FIRST]] ], [ [[SRC2_SCALAR]], %[[SECOND]] ], !any_metadata [[META0:![0-9]+]]
; CHECK-NEXT:    [[RESULT2:%.*]] = phi i32 [ [[SRC1_SCALAR3]], %[[FIRST]] ], [ [[SRC2_SCALAR4]], %[[SECOND]] ], !any_metadata [[META0]]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[RESULT1]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT5:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT2]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT5]]
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <2 x i32> [ %src1, %first], [ %src2, %second], !any_metadata !{i32 0}
  ret <2 x i32> %result
}

define <2 x float> @should_work_with_different_value_type(i1 %switch, <2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define <2 x float> @should_work_with_different_value_type(
; CHECK-SAME: i1 [[SWITCH:%.*]], <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x float> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR4:%.*]] = extractelement <2 x float> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x float> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR3:%.*]] = extractelement <2 x float> [[SRC1]], i32 1
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT1:%.*]] = phi float [ [[SRC1_SCALAR]], %[[FIRST]] ], [ [[SRC2_SCALAR]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT2:%.*]] = phi float [ [[SRC1_SCALAR3]], %[[FIRST]] ], [ [[SRC2_SCALAR4]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x float> undef, float [[RESULT1]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT5:%.*]] = insertelement <2 x float> [[RESULT_ASSEMBLED_VECT]], float [[RESULT2]], i32 1
; CHECK-NEXT:    ret <2 x float> [[RESULT_ASSEMBLED_VECT5]]
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <2 x float> [ %src1, %first], [ %src2, %second]
  ret <2 x float> %result
}

define <2 x float> @should_work_with_fast_math_flags(i1 %switch, <2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define <2 x float> @should_work_with_fast_math_flags(
; CHECK-SAME: i1 [[SWITCH:%.*]], <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x float> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR4:%.*]] = extractelement <2 x float> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x float> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR3:%.*]] = extractelement <2 x float> [[SRC1]], i32 1
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT1:%.*]] = phi fast float [ [[SRC1_SCALAR]], %[[FIRST]] ], [ [[SRC2_SCALAR]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT2:%.*]] = phi fast float [ [[SRC1_SCALAR3]], %[[FIRST]] ], [ [[SRC2_SCALAR4]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x float> undef, float [[RESULT1]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT5:%.*]] = insertelement <2 x float> [[RESULT_ASSEMBLED_VECT]], float [[RESULT2]], i32 1
; CHECK-NEXT:    ret <2 x float> [[RESULT_ASSEMBLED_VECT5]]
;
  entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi fast <2 x float> [ %src1, %first], [ %src2, %second]
  ret <2 x float> %result
}

define <16 x i32> @should_work_with_larger_vector_size(i1 %switch, <16 x i32> %src1, <16 x i32> %src2) {
; CHECK-LABEL: define <16 x i32> @should_work_with_larger_vector_size(
; CHECK-SAME: i1 [[SWITCH:%.*]], <16 x i32> [[SRC1:%.*]], <16 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <16 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR32:%.*]] = extractelement <16 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC2_SCALAR33:%.*]] = extractelement <16 x i32> [[SRC2]], i32 2
; CHECK-NEXT:    [[SRC2_SCALAR34:%.*]] = extractelement <16 x i32> [[SRC2]], i32 3
; CHECK-NEXT:    [[SRC2_SCALAR35:%.*]] = extractelement <16 x i32> [[SRC2]], i32 4
; CHECK-NEXT:    [[SRC2_SCALAR36:%.*]] = extractelement <16 x i32> [[SRC2]], i32 5
; CHECK-NEXT:    [[SRC2_SCALAR37:%.*]] = extractelement <16 x i32> [[SRC2]], i32 6
; CHECK-NEXT:    [[SRC2_SCALAR38:%.*]] = extractelement <16 x i32> [[SRC2]], i32 7
; CHECK-NEXT:    [[SRC2_SCALAR39:%.*]] = extractelement <16 x i32> [[SRC2]], i32 8
; CHECK-NEXT:    [[SRC2_SCALAR40:%.*]] = extractelement <16 x i32> [[SRC2]], i32 9
; CHECK-NEXT:    [[SRC2_SCALAR41:%.*]] = extractelement <16 x i32> [[SRC2]], i32 10
; CHECK-NEXT:    [[SRC2_SCALAR42:%.*]] = extractelement <16 x i32> [[SRC2]], i32 11
; CHECK-NEXT:    [[SRC2_SCALAR43:%.*]] = extractelement <16 x i32> [[SRC2]], i32 12
; CHECK-NEXT:    [[SRC2_SCALAR44:%.*]] = extractelement <16 x i32> [[SRC2]], i32 13
; CHECK-NEXT:    [[SRC2_SCALAR45:%.*]] = extractelement <16 x i32> [[SRC2]], i32 14
; CHECK-NEXT:    [[SRC2_SCALAR46:%.*]] = extractelement <16 x i32> [[SRC2]], i32 15
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <16 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR17:%.*]] = extractelement <16 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR18:%.*]] = extractelement <16 x i32> [[SRC1]], i32 2
; CHECK-NEXT:    [[SRC1_SCALAR19:%.*]] = extractelement <16 x i32> [[SRC1]], i32 3
; CHECK-NEXT:    [[SRC1_SCALAR20:%.*]] = extractelement <16 x i32> [[SRC1]], i32 4
; CHECK-NEXT:    [[SRC1_SCALAR21:%.*]] = extractelement <16 x i32> [[SRC1]], i32 5
; CHECK-NEXT:    [[SRC1_SCALAR22:%.*]] = extractelement <16 x i32> [[SRC1]], i32 6
; CHECK-NEXT:    [[SRC1_SCALAR23:%.*]] = extractelement <16 x i32> [[SRC1]], i32 7
; CHECK-NEXT:    [[SRC1_SCALAR24:%.*]] = extractelement <16 x i32> [[SRC1]], i32 8
; CHECK-NEXT:    [[SRC1_SCALAR25:%.*]] = extractelement <16 x i32> [[SRC1]], i32 9
; CHECK-NEXT:    [[SRC1_SCALAR26:%.*]] = extractelement <16 x i32> [[SRC1]], i32 10
; CHECK-NEXT:    [[SRC1_SCALAR27:%.*]] = extractelement <16 x i32> [[SRC1]], i32 11
; CHECK-NEXT:    [[SRC1_SCALAR28:%.*]] = extractelement <16 x i32> [[SRC1]], i32 12
; CHECK-NEXT:    [[SRC1_SCALAR29:%.*]] = extractelement <16 x i32> [[SRC1]], i32 13
; CHECK-NEXT:    [[SRC1_SCALAR30:%.*]] = extractelement <16 x i32> [[SRC1]], i32 14
; CHECK-NEXT:    [[SRC1_SCALAR31:%.*]] = extractelement <16 x i32> [[SRC1]], i32 15
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT1:%.*]] = phi i32 [ [[SRC1_SCALAR]], %[[FIRST]] ], [ [[SRC2_SCALAR]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT2:%.*]] = phi i32 [ [[SRC1_SCALAR17]], %[[FIRST]] ], [ [[SRC2_SCALAR32]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT3:%.*]] = phi i32 [ [[SRC1_SCALAR18]], %[[FIRST]] ], [ [[SRC2_SCALAR33]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT4:%.*]] = phi i32 [ [[SRC1_SCALAR19]], %[[FIRST]] ], [ [[SRC2_SCALAR34]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT5:%.*]] = phi i32 [ [[SRC1_SCALAR20]], %[[FIRST]] ], [ [[SRC2_SCALAR35]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT6:%.*]] = phi i32 [ [[SRC1_SCALAR21]], %[[FIRST]] ], [ [[SRC2_SCALAR36]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT7:%.*]] = phi i32 [ [[SRC1_SCALAR22]], %[[FIRST]] ], [ [[SRC2_SCALAR37]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT8:%.*]] = phi i32 [ [[SRC1_SCALAR23]], %[[FIRST]] ], [ [[SRC2_SCALAR38]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT9:%.*]] = phi i32 [ [[SRC1_SCALAR24]], %[[FIRST]] ], [ [[SRC2_SCALAR39]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT10:%.*]] = phi i32 [ [[SRC1_SCALAR25]], %[[FIRST]] ], [ [[SRC2_SCALAR40]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT11:%.*]] = phi i32 [ [[SRC1_SCALAR26]], %[[FIRST]] ], [ [[SRC2_SCALAR41]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT12:%.*]] = phi i32 [ [[SRC1_SCALAR27]], %[[FIRST]] ], [ [[SRC2_SCALAR42]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT13:%.*]] = phi i32 [ [[SRC1_SCALAR28]], %[[FIRST]] ], [ [[SRC2_SCALAR43]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT14:%.*]] = phi i32 [ [[SRC1_SCALAR29]], %[[FIRST]] ], [ [[SRC2_SCALAR44]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT15:%.*]] = phi i32 [ [[SRC1_SCALAR30]], %[[FIRST]] ], [ [[SRC2_SCALAR45]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT16:%.*]] = phi i32 [ [[SRC1_SCALAR31]], %[[FIRST]] ], [ [[SRC2_SCALAR46]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <16 x i32> undef, i32 [[RESULT1]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT47:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT2]], i32 1
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT48:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT47]], i32 [[RESULT3]], i32 2
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT49:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT48]], i32 [[RESULT4]], i32 3
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT50:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT49]], i32 [[RESULT5]], i32 4
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT51:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT50]], i32 [[RESULT6]], i32 5
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT52:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT51]], i32 [[RESULT7]], i32 6
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT53:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT52]], i32 [[RESULT8]], i32 7
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT54:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT53]], i32 [[RESULT9]], i32 8
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT55:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT54]], i32 [[RESULT10]], i32 9
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT56:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT55]], i32 [[RESULT11]], i32 10
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT57:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT56]], i32 [[RESULT12]], i32 11
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT58:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT57]], i32 [[RESULT13]], i32 12
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT59:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT58]], i32 [[RESULT14]], i32 13
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT60:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT59]], i32 [[RESULT15]], i32 14
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT61:%.*]] = insertelement <16 x i32> [[RESULT_ASSEMBLED_VECT60]], i32 [[RESULT16]], i32 15
; CHECK-NEXT:    ret <16 x i32> [[RESULT_ASSEMBLED_VECT61]]
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <16 x i32> [ %src1, %first], [ %src2, %second]
  ret <16 x i32> %result
}

define <2 x i32> @should_work_with_constant_value(i1 %switch, <2 x i32> %src1) {
; CHECK-LABEL: define <2 x i32> @should_work_with_constant_value(
; CHECK-SAME: i1 [[SWITCH:%.*]], <2 x i32> [[SRC1:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR3:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT1:%.*]] = phi i32 [ [[SRC1_SCALAR]], %[[FIRST]] ], [ 2, %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT2:%.*]] = phi i32 [ [[SRC1_SCALAR3]], %[[FIRST]] ], [ 4, %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT:%.*]] = insertelement <2 x i32> undef, i32 [[RESULT1]], i32 0
; CHECK-NEXT:    [[RESULT_ASSEMBLED_VECT4:%.*]] = insertelement <2 x i32> [[RESULT_ASSEMBLED_VECT]], i32 [[RESULT2]], i32 1
; CHECK-NEXT:    ret <2 x i32> [[RESULT_ASSEMBLED_VECT4]]
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <2 x i32> [ %src1, %first], [ <i32 2, i32 4>, %second]
  ret <2 x i32> %result
}


define <8 x i32> @should_not_scalarize(i1 %switch, <8 x i32> %src1) {
; CHECK-LABEL: define <8 x i32> @should_not_scalarize(
; CHECK-SAME: i1 [[SWITCH:%.*]], <8 x i32> [[SRC1:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = call <8 x i32> @llvm.genx.GenISA.vmeSendIME2(<8 x i32> [[SRC1]], i32 1, i32 2, i32 3, i32 0)
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT:%.*]] = phi <8 x i32> [ [[SRC1]], %[[FIRST]] ], [ [[SHOULD_NOT_SCALARIZE_ME]], %[[SECOND]] ]
; CHECK-NEXT:    ret <8 x i32> [[RESULT]]
;
entry:
  %should_not_scalarize_me = call <8 x i32> @llvm.genx.GenISA.vmeSendIME2(<8 x i32> %src1, i32 1, i32 2, i32 3, i32 0)
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <8 x i32> [ %src1, %first], [ %should_not_scalarize_me, %second]
  ret <8 x i32> %result
}

define <4 x i32> @should_not_scalarize_2(i1 %switch, <4 x i32> %src1) {
; CHECK-LABEL: define <4 x i32> @should_not_scalarize_2(
; CHECK-SAME: i1 [[SWITCH:%.*]], <4 x i32> [[SRC1:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = call <4 x i32> @llvm.genx.GenISA.vmeSendFBR2(<4 x i32> [[SRC1]], i32 1, i32 2, i32 3)
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT:%.*]] = phi <4 x i32> [ [[SRC1]], %[[FIRST]] ], [ [[SHOULD_NOT_SCALARIZE_ME]], %[[SECOND]] ]
; CHECK-NEXT:    ret <4 x i32> [[RESULT]]
;
entry:
  %should_not_scalarize_me = call <4 x i32> @llvm.genx.GenISA.vmeSendFBR2(<4 x i32> %src1, i32 1, i32 2, i32 3)
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <4 x i32> [ %src1, %first], [ %should_not_scalarize_me, %second]
  ret <4 x i32> %result
}

define <4 x i32> @should_not_scalarize_3(i1 %switch, <4 x i32> %src1) {
; CHECK-LABEL: define <4 x i32> @should_not_scalarize_3(
; CHECK-SAME: i1 [[SWITCH:%.*]], <4 x i32> [[SRC1:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = call <4 x i32> @llvm.genx.GenISA.vmeSendSIC2(<4 x i32> [[SRC1]], i32 1, i32 2, i32 3)
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT:%.*]] = phi <4 x i32> [ [[SRC1]], %[[FIRST]] ], [ [[SHOULD_NOT_SCALARIZE_ME]], %[[SECOND]] ]
; CHECK-NEXT:    ret <4 x i32> [[RESULT]]
;
entry:
  %should_not_scalarize_me = call <4 x i32> @llvm.genx.GenISA.vmeSendSIC2(<4 x i32> %src1, i32 1, i32 2, i32 3)
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %result = phi <4 x i32> [ %src1, %first], [ %should_not_scalarize_me, %second]
  ret <4 x i32> %result
}

define <8 x float> @should_not_scalarize_4(i1 %switch, <8 x float> %src1, <8 x float> %src2) {
; CHECK-LABEL: define <8 x float> @should_not_scalarize_4(
; CHECK-SAME: i1 [[SWITCH:%.*]], <8 x float> [[SRC1:%.*]], <8 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = load <8 x i16>, ptr @vector.8x.i16, align 16
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i32>, ptr @vector.8x.i32, align 32
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = phi <8 x float> [ [[SRC1]], %[[FIRST]] ], [ [[SRC2]], %[[SECOND]] ]
; CHECK-NEXT:    [[RETURN:%.*]] = call <8 x float> @llvm.genx.GenISA.sub.group.dpas.v8f32.v8f32.v8i16.v8i32(<8 x float> [[SHOULD_NOT_SCALARIZE_ME]], <8 x i16> [[TMP0]], <8 x i32> [[TMP1]], i32 11, i32 11, i32 8, i32 8, i1 false)
; CHECK-NEXT:    ret <8 x float> [[RETURN]]
;
entry:
  %0 = load <8 x i16>, ptr @vector.8x.i16
  %1 = load <8 x i32>, ptr @vector.8x.i32

  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %should_not_scalarize_me = phi <8 x float> [ %src1, %first], [ %src2, %second]
  %return = call <8 x float> @llvm.genx.GenISA.sub.group.dpas.v8f32.v8f32.v8i16.v8i32(<8 x float> %should_not_scalarize_me, <8 x i16> %0, <8 x i32> %1, i32 11, i32 11, i32 8, i32 8, i1 false)
  ret <8 x float> %return
}

define i32 @should_not_scalarize_5(i1 %switch, <8 x i32> %src1, <8 x i32> %src2) {
; CHECK-LABEL: define i32 @should_not_scalarize_5(
; CHECK-SAME: i1 [[SWITCH:%.*]], <8 x i32> [[SRC1:%.*]], <8 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = load <8 x i32>, ptr @vector.8x.i32, align 32
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = phi <8 x i32> [ [[SRC1]], %[[FIRST]] ], [ [[SRC2]], %[[SECOND]] ]
; CHECK-NEXT:    [[RETURN:%.*]] = call i32 @llvm.genx.GenISA.dpas.v8i32(<8 x i32> [[SHOULD_NOT_SCALARIZE_ME]], <8 x i32> [[TMP0]], <8 x i32> [[TMP0]], i32 7, i32 7, i32 8, i32 1, i1 false)
; CHECK-NEXT:    ret i32 [[RETURN]]
;
entry:
  %0 = load <8 x i32>, ptr @vector.8x.i32

  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %should_not_scalarize_me = phi <8 x i32> [ %src1, %first], [ %src2, %second]
  %return = call i32 @llvm.genx.GenISA.dpas.v8i32(<8 x i32> %should_not_scalarize_me, <8 x i32> %0, <8 x i32> %0, i32 7, i32 7, i32 8, i32 1, i1 false)
  ret i32 %return
}

define spir_kernel void @should_not_scalarize_6(i1 %switch, ptr addrspace(1) %src1, ptr addrspace(1) %src2) {
; CHECK-LABEL: define spir_kernel void @should_not_scalarize_6(
; CHECK-SAME: i1 [[SWITCH:%.*]], ptr addrspace(1) [[SRC1:%.*]], ptr addrspace(1) [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = phi ptr addrspace(1) [ [[SRC1]], %[[FIRST]] ], [ [[SRC2]], %[[SECOND]] ]
; CHECK-NEXT:    call void @llvm.genx.GenISA.simdBlockWrite.v2i32.p1v2i32(ptr addrspace(1) [[SHOULD_NOT_SCALARIZE_ME]], <2 x i32> <i32 2, i32 4>)
; CHECK-NEXT:    ret void
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %should_not_scalarize_me = phi ptr addrspace(1) [ %src1, %first], [ %src2, %second]
  call void @llvm.genx.GenISA.simdBlockWrite.v2i32.p1v2i32(ptr addrspace(1) %should_not_scalarize_me, <2 x i32> <i32 2, i32 4>)
  ret void
}

define spir_kernel void @should_not_scalarize_7(i1 %switch, <2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define spir_kernel void @should_not_scalarize_7(
; CHECK-SAME: i1 [[SWITCH:%.*]], <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = alloca i8, align 1, addrspace(2490368)
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = phi <2 x float> [ [[SRC1]], %[[FIRST]] ], [ [[SRC2]], %[[SECOND]] ]
; CHECK-NEXT:    call void @llvm.genx.GenISA.simdBlockWriteBindless.p2490368i8.v2f32.i32(ptr addrspace(2490368) [[TMP0]], <2 x float> [[SHOULD_NOT_SCALARIZE_ME]], i32 0)
; CHECK-NEXT:    ret void
;
entry:
  %0 = alloca i8, addrspace(2490368)
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %should_not_scalarize_me = phi <2 x float> [ %src1, %first], [ %src2, %second]
  call void @llvm.genx.GenISA.simdBlockWriteBindless.p2490368i8.v2f32.i32(ptr addrspace(2490368) %0, <2 x float> %should_not_scalarize_me, i32 0)
  ret void
}

define spir_kernel void @should_not_scalarize_8(i1 %switch, <16 x i16> %src1, <16 x i16> %src2) {
; CHECK-LABEL: define spir_kernel void @should_not_scalarize_8(
; CHECK-SAME: i1 [[SWITCH:%.*]], <16 x i16> [[SRC1:%.*]], <16 x i16> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = phi <16 x i16> [ [[SRC1]], %[[FIRST]] ], [ [[SRC2]], %[[SECOND]] ]
; CHECK-NEXT:    call void @llvm.genx.GenISA.simdMediaBlockWrite.v16i16(i32 1, i32 1, i32 1, i32 1, <16 x i16> [[SHOULD_NOT_SCALARIZE_ME]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %should_not_scalarize_me = phi <16 x i16> [ %src1, %first], [ %src2, %second]
  call void @llvm.genx.GenISA.simdMediaBlockWrite.v16i16(i32 1, i32 1, i32 1, i32 1, <16 x i16> %should_not_scalarize_me)
  ret void
}

define spir_kernel void @should_not_scalarize_9(i1 %switch, <8 x i32> %src1, <8 x i32> %src2) {
; CHECK-LABEL: define spir_kernel void @should_not_scalarize_9(
; CHECK-SAME: i1 [[SWITCH:%.*]], <8 x i32> [[SRC1:%.*]], <8 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = phi <8 x i32> [ [[SRC1]], %[[FIRST]] ], [ [[SRC2]], %[[SECOND]] ]
; CHECK-NEXT:    call void @llvm.genx.GenISA.LSC2DBlockWrite.p0i32(i64 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i1 false, i1 true, i32 11, <8 x i32> [[SHOULD_NOT_SCALARIZE_ME]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %should_not_scalarize_me = phi <8 x i32> [ %src1, %first], [ %src2, %second]
  call void @llvm.genx.GenISA.LSC2DBlockWrite.p0i32(i64 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i1 false, i1 true, i32 11, <8 x i32> %should_not_scalarize_me)
  ret void
}

define spir_kernel void @should_not_scalarize_10(i1 %switch, <16 x i16> %src1, <16 x i16> %src2) {
; CHECK-LABEL: define spir_kernel void @should_not_scalarize_10(
; CHECK-SAME: i1 [[SWITCH:%.*]], <16 x i16> [[SRC1:%.*]], <16 x i16> [[SRC2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[SHOULD_NOT_SCALARIZE_ME:%.*]] = phi <16 x i16> [ [[SRC1]], %[[FIRST]] ], [ [[SRC2]], %[[SECOND]] ]
; CHECK-NEXT:    call void @llvm.genx.GenISA.LSC2DBlockWriteAddrPayload.p0i32.v16i16(ptr [[TMP0]], i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0, <16 x i16> [[SHOULD_NOT_SCALARIZE_ME]])
; CHECK-NEXT:    ret void
;
entry:
  %0 = alloca i32
  br i1 %switch, label %first, label %second
first:
  br label %exit
second:
  br label %exit
exit:
  %should_not_scalarize_me = phi <16 x i16> [ %src1, %first], [ %src2, %second]
  call void @llvm.genx.GenISA.LSC2DBlockWriteAddrPayload.p0i32.v16i16(ptr %0, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0, <16 x i16> %should_not_scalarize_me)
  ret void
}

define spir_kernel void @should_work_with_nested_phi(i1 %switch) {
; CHECK-LABEL: define spir_kernel void @should_work_with_nested_phi(
; CHECK-SAME: i1 [[SWITCH:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[VECTINT:%.*]] = add <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>, zeroinitializer
; CHECK-NEXT:    [[VECTINT_SCALAR:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 0
; CHECK-NEXT:    [[VECTINT_SCALAR9:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 1
; CHECK-NEXT:    [[VECTINT_SCALAR10:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 2
; CHECK-NEXT:    [[VECTINT_SCALAR11:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 3
; CHECK-NEXT:    [[VECTINT_SCALAR12:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 4
; CHECK-NEXT:    [[VECTINT_SCALAR13:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 5
; CHECK-NEXT:    [[VECTINT_SCALAR14:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 6
; CHECK-NEXT:    [[VECTINT_SCALAR15:%.*]] = extractelement <8 x i32> [[VECTINT]], i32 7
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST:.*]], label %[[SECOND:.*]]
; CHECK:       [[PROXY:.*]]:
; CHECK-NEXT:    br i1 [[SWITCH]], label %[[FIRST]], label %[[SECOND]]
; CHECK:       [[FIRST]]:
; CHECK-NEXT:    [[RESULT11:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT12:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR9]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT13:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR10]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT14:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR11]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT15:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR12]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT16:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR13]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT17:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR14]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT18:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR15]], %[[ENTRY]] ]
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[SECOND]]:
; CHECK-NEXT:    [[RESULT224:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT225:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR9]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT226:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR10]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT227:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR11]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT228:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR12]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT229:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR13]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT230:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR14]], %[[ENTRY]] ]
; CHECK-NEXT:    [[RESULT231:%.*]] = phi i32 [ 0, %[[PROXY]] ], [ [[VECTINT_SCALAR15]], %[[ENTRY]] ]
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RESULT316:%.*]] = phi i32 [ [[RESULT11]], %[[FIRST]] ], [ [[RESULT224]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT317:%.*]] = phi i32 [ [[RESULT12]], %[[FIRST]] ], [ [[RESULT225]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT318:%.*]] = phi i32 [ [[RESULT13]], %[[FIRST]] ], [ [[RESULT226]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT319:%.*]] = phi i32 [ [[RESULT14]], %[[FIRST]] ], [ [[RESULT227]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT320:%.*]] = phi i32 [ [[RESULT15]], %[[FIRST]] ], [ [[RESULT228]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT321:%.*]] = phi i32 [ [[RESULT16]], %[[FIRST]] ], [ [[RESULT229]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT322:%.*]] = phi i32 [ [[RESULT17]], %[[FIRST]] ], [ [[RESULT230]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT323:%.*]] = phi i32 [ [[RESULT18]], %[[FIRST]] ], [ [[RESULT231]], %[[SECOND]] ]
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT:%.*]] = insertelement <8 x i32> undef, i32 [[RESULT316]], i32 0
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT32:%.*]] = insertelement <8 x i32> [[RESULT3_ASSEMBLED_VECT]], i32 [[RESULT317]], i32 1
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT33:%.*]] = insertelement <8 x i32> [[RESULT3_ASSEMBLED_VECT32]], i32 [[RESULT318]], i32 2
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT34:%.*]] = insertelement <8 x i32> [[RESULT3_ASSEMBLED_VECT33]], i32 [[RESULT319]], i32 3
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT35:%.*]] = insertelement <8 x i32> [[RESULT3_ASSEMBLED_VECT34]], i32 [[RESULT320]], i32 4
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT36:%.*]] = insertelement <8 x i32> [[RESULT3_ASSEMBLED_VECT35]], i32 [[RESULT321]], i32 5
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT37:%.*]] = insertelement <8 x i32> [[RESULT3_ASSEMBLED_VECT36]], i32 [[RESULT322]], i32 6
; CHECK-NEXT:    [[RESULT3_ASSEMBLED_VECT38:%.*]] = insertelement <8 x i32> [[RESULT3_ASSEMBLED_VECT37]], i32 [[RESULT323]], i32 7
; CHECK-NEXT:    [[NEWDATA:%.*]] = call <8 x i32> @do_math_v8i32_v8i32(<8 x i32> [[RESULT3_ASSEMBLED_VECT38]])
; CHECK-NEXT:    ret void
;
entry:
  %vectint = add <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>, zeroinitializer
  br i1 %switch, label %first, label %second
proxy:
  br i1 %switch, label %first, label %second
first:
  %result1 = phi <8 x i32> [ zeroinitializer, %proxy ], [ %vectint, %entry]
  br label %exit
second:
  %result2 = phi <8 x i32> [ zeroinitializer, %proxy ], [ %vectint, %entry]
  br label %exit
exit:
  %result3 = phi <8 x i32> [ %result1, %first], [ %result2, %second]
  %newdata = call <8 x i32> @do_math_v8i32_v8i32(<8 x i32> %result3)
  ret void
}

@vector.8x.float = global <8 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>
@vector.8x.i16 = global <8 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
@vector.8x.i32 = global <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>

declare <8 x i32> @llvm.genx.GenISA.vmeSendIME2(<8 x i32>, i32, i32, i32, i32)
declare <4 x i32> @llvm.genx.GenISA.vmeSendFBR2(<4 x i32>, i32, i32, i32)
declare <4 x i32> @llvm.genx.GenISA.vmeSendSIC2(<4 x i32>, i32, i32, i32)
declare <8 x float> @llvm.genx.GenISA.sub.group.dpas.v8f32.v8f32.v8i16.v8i32(<8 x float>, <8 x i16>, <8 x i32>, i32, i32, i32, i32, i1)
declare i32 @llvm.genx.GenISA.dpas.v8i32(<8 x i32>, <8 x i32>, <8 x i32>, i32, i32, i32, i32, i1)
declare void @llvm.genx.GenISA.simdBlockWrite.v2i32.p1v2i32(ptr addrspace(1), <2 x i32>)
declare void @llvm.genx.GenISA.simdBlockWriteBindless.p2490368i8.v2f32.i32(ptr addrspace(2490368), <2 x float>, i32)
declare void @llvm.genx.GenISA.simdMediaBlockWrite.v16i16(i32, i32, i32, i32, <16 x i16>)
declare void @llvm.genx.GenISA.LSC2DBlockWrite.p0i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32, <8 x i32>)
declare void @llvm.genx.GenISA.LSC2DBlockWriteAddrPayload.p0i32.v16i16(ptr, i32, i32, i32, i32, i32, i32, i1, i1, i32, <16 x i16>)
declare spir_func <8 x i32> @do_math_v8i32_v8i32(<8 x i32>) #1

; CHECK: [[META0]] = !{i32 0}