#include <alberta.h>

/*---8<---------------------------------------------------------------------*/
/*---   graphical output of mesh, discrete solution, estimate, and error ---*/
/*--------------------------------------------------------------------->8---*/

#if !HAVE_LIBGLTOOLS
/*---8<---------------------------------------------------------------------*/
/*---   simple GL graphics ...                                           ---*/
/*---   nothing will be done in 3d                                       ---*/
/*--------------------------------------------------------------------->8---*/

void graphics(MESH *mesh, DOF_REAL_VEC *u_h, REAL (*get_est)(EL *el),
	      REAL (*u)(const REAL_D x))
{
  FUNCNAME("graphics");
  static int first = true;
  static GRAPH_WINDOW win_est=nil, win_val=nil, win_mesh=nil, win_err=nil;
  static DOF_REAL_VEC   *u_diff = nil;
  int    refine = 0;

  if (first)
  {
    int size[4] = {};
    char   geom[128] = "500x500+0+0";
    GET_PARAMETER(1,"graphic windows","%d %d %d %d",size,size+1,size+2,size+3);

    if (size[0] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[0], size[0], 0, 0); 
      win_val = graph_open_window("ALBERTA values", geom, nil, mesh);
    }
    if (size[1] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[0], size[0], size[0], 0); 
      win_est = graph_open_window("ALBERTA estimate", geom, nil, mesh);
    }
    if (size[2] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[2], size[2], size[0]+size[1], 0); 
      win_mesh = graph_open_window("ALBERTA mesh", geom, nil, mesh);
    }
    if (size[3] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[3], size[3], 0, size[0]); 
      win_err = graph_open_window("ALBERTA error (u_h-u)", geom, nil, mesh);
    }
    first = false;
  }

  if (mesh && win_mesh)
  {
    graph_clear_window(win_mesh, rgb_white);
    graph_mesh(win_mesh, mesh, rgb_black, 2);
  }
  if (u_h && win_val)
  {
    graph_clear_window(win_val, rgb_white);
    refine = u_h->fe_space->bas_fcts->degree;
    if (refine<2) refine=0;
    graph_drv(win_val, u_h, 0.0, 0.0, refine);
  }

  if (get_est && win_est)
  {
    graph_clear_window(win_est, rgb_white);
    graph_mesh(win_est, mesh, rgb_blue, 0);
    graph_el_est(win_est, mesh, get_est, 0.0, 0.0); 
  }

  if(u && u_h && win_err) {
    if(!u_diff)
      u_diff = get_dof_real_vec("u_h - u", u_h->fe_space);

    interpol(u, u_diff);
    dof_xpay(-1.0, u_h, u_diff);
    graph_drv(win_err, u_diff, 0.0, 0.0, refine);
  }

  WAIT;

  return;
}

void graphics_d(MESH *mesh, DOF_REAL_D_VEC *u_h, REAL (*get_est)(EL *el),
		const REAL *(*u)(const REAL_D val, REAL_D x))
{
  FUNCNAME("graphics_d");
  static int first = true;
  static GRAPH_WINDOW win_est=nil, win_val=nil, win_mesh=nil, win_err=nil;
  static DOF_REAL_D_VEC   *u_diff = nil;
  int    refine;

  if (first)
  {
    int size[4] = {};
    char   geom[128] = "500x500+0+0";
    GET_PARAMETER(1,"graphic windows","%d %d %d %d",size,size+1,size+2,size+3);

    if (size[0] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[0], size[0], 0, 0); 
      win_val = graph_open_window("ALBERTA values", geom, nil, mesh);
    }
    if (size[1] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[0], size[0], size[0], 0); 
      win_est = graph_open_window("ALBERTA estimate", geom, nil, mesh);
    }
    if (size[2] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[2], size[2], size[0]+size[1], 0); 
      win_mesh = graph_open_window("ALBERTA mesh", geom, nil, mesh);
    }
    if (size[3] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[3], size[3], 0, size[0]); 
      win_err = graph_open_window("ALBERTA error ||u_h-u||", geom, nil, mesh);
    }
    first = false;
  }

  if (mesh && win_mesh)
  {
    graph_clear_window(win_mesh, rgb_white);
    graph_mesh(win_mesh, mesh, rgb_black, 2);
  }
  if (u_h && win_val)
  {
    graph_clear_window(win_val, rgb_white);
    refine = u_h->fe_space->bas_fcts->degree;
    if (refine<2) refine=0;
    graph_drv_d(win_val, u_h, 0.0, 0.0, refine);
  }

  if (get_est && win_est)
  {
    graph_clear_window(win_est, rgb_white);
    graph_mesh(win_est, mesh, rgb_blue, 0);
    graph_el_est(win_est, mesh, get_est, 0.0, 0.0); 
  }

  if(u && u_h && win_err) {
    if(!u_diff)
      u_diff = get_dof_real_d_vec("u_h - u", u_h->fe_space);

    interpol_d(u, u_diff);
    dof_xpay_d(-1.0, u_h, u_diff);
    graph_drv_d(win_err, u_diff, 0.0, 0.0, refine);
  }

  WAIT;

  return;
}
#else

void graphics(MESH *mesh, DOF_REAL_VEC *u_h, REAL (*get_est)(EL *el),
	      REAL (*u)(const REAL_D x))
{
  FUNCNAME("graphics");
  static int first = true;
  static GLTOOLS_WINDOW  win_est=nil, win_val=nil, win_mesh=nil, win_err=nil;
  static DOF_REAL_VEC   *u_diff = nil;
  static REAL  min, max;

  if (first)
  {
    int size[4] = {};
    char   geom[128] = "500x500+0+0";
    GET_PARAMETER(1,"graphic windows","%d %d %d %d",size,size+1,size+2,size+3);

    GET_PARAMETER(1, "gltools range", "%e %e", &min, &max);

    if (size[0] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[0], size[0], 0, 0); 
      win_val = open_gltools_window("ALBERTA values", geom, nil, mesh, true);
    }

    if (size[1] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[1], size[1], size[0], 0); 
      win_est = open_gltools_window("ALBERTA estimate", geom, nil, mesh, true);
    }

    if (size[2] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[2], size[2], size[0]+size[1], 0); 
      win_mesh = open_gltools_window("ALBERTA mesh", geom, nil, mesh, true);
    }

    if (size[3] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[3], size[3], 0, size[0]); 
      win_err=open_gltools_window("ALBERTA error (u_h-u)",geom,nil,mesh,true);
    }
    first = false;
  }


  if (mesh && win_mesh) {
    gltools_mesh(win_mesh, mesh, 0);
  }


  if (u_h && win_val) {
    gltools_drv(win_val, u_h, min, max);
  }

  if (get_est && win_est ) {
    gltools_est(win_est, mesh, get_est, 0.0, -1.0);
  }

  if(u && u_h && win_err) {
    if(!u_diff)
      u_diff = get_dof_real_vec("u_h - u", u_h->fe_space);

    interpol(u, u_diff);
    dof_xpay(-1.0, u_h, u_diff);
    gltools_drv(win_err, u_diff, 0.0, -1.0);
  }

  return;
}

void graphics_d(MESH *mesh, DOF_REAL_D_VEC *u_h, REAL (*get_est)(EL *el),
		const REAL *(*u)(const REAL_D val, REAL_D x))
{
  FUNCNAME("graphics_d");
  static int first = true;
  static GLTOOLS_WINDOW   win_est=nil, win_val=nil, win_mesh=nil, win_err=nil;
  static DOF_REAL_D_VEC   *u_diff = nil;
  static REAL  min, max;

  if (first)
  {
    int size[4] = {};
    char   geom[128] = "500x500+0+0";
    GET_PARAMETER(1,"graphic windows","%d %d %d %d",size,size+1,size+2,size+3);

    GET_PARAMETER(1, "gltools range", "%e %e", &min, &max);

    if (size[0] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[0], size[0], 0, 0); 
      win_val = open_gltools_window("ALBERTA values", geom, nil, mesh, true);
    }

    if (size[1] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[1], size[1], size[0], 0); 
      win_est = open_gltools_window("ALBERTA estimate", geom, nil, mesh, true);
    }

    if (size[2] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[2], size[2], size[0]+size[1], 0); 
      win_mesh = open_gltools_window("ALBERTA mesh", geom, nil, mesh, true);
    }

    if (size[3] > 0)
    {
      sprintf(geom, "%dx%d+%d+%d", size[3], size[3], 0, size[0]); 
      win_err=open_gltools_window("ALBERTA error ||u_h-u||",
				   geom, nil, mesh, true);
    }
    first = false;
  }


  if (mesh && win_mesh)
    gltools_mesh(win_mesh, mesh, 0);

  if (u_h && win_val)
    gltools_drv_d(win_val, u_h, min, max);

  if (get_est && win_est)
    gltools_est(win_est, mesh, get_est, 0.0, -1.0);

  if(u && u_h && win_err) {
    if(!u_diff)
      u_diff = get_dof_real_d_vec("u_h - u", u_h->fe_space);

    interpol_d(u, u_diff);
    dof_xpay_d(-1.0, u_h, u_diff);
    gltools_drv_d(win_err, u_diff, 0.0, -1.0);
  }

  return;
}
#endif
