------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2006-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;              use Ada.Text_IO;
with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with GNATCOLL.Email.Parser;    use GNATCOLL.Email, GNATCOLL.Email.Parser;
with GNATCOLL.Email.Mailboxes; use GNATCOLL.Email.Mailboxes;
with GNATCOLL.Email.Utils;     use GNATCOLL.Email.Utils;
with GNATCOLL.VFS;             use GNATCOLL.VFS;

procedure Test_Email is
   Box : Mbox;
   Stored : Stored_Mailbox;
   Iter   : Stored_Mailbox_Cursor;
   M      : Message;
   HI     : Header_Iterator;
   H      : Header;
   Addr   : Address_Set.Set;
begin
   Open (Box, Filename => Create (+"comment"));
   Store (Stored, Box, Factory  => Parse_No_Payload'Access);

   Iter := Stored_Mailbox_Cursor (First (Stored));
   while Has_Element (Iter) loop
      Get_Message (Iter, Box, M);

      HI := M.Get_Headers ("CC");
      while Next (HI, H) loop
         Addr := Get_Addresses (H.Get_Value);

         for A of Addr loop
            Put_Line ("Addr='" & To_String (A.Real_Name) & "' <"
               & To_String (A.Address) & ">");
         end loop;
      end loop;

      Next (Iter, Stored);
   end loop;
end Test_Email;
