use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'V5sendmail';
my $samplepath = sprintf("./set-of-emails/private/email-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->maketest;
my $isexpected = [
    { 'n' => '01001', 'r' => qr/userunknown/    },
    { 'n' => '01002', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01003', 'r' => qr/hostunknown/    },
    { 'n' => '01004', 'r' => qr/hostunknown/    },
    { 'n' => '01005', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01006', 'r' => qr/hostunknown/    },
    { 'n' => '01007', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01008', 'r' => qr/hostunknown/    },
    { 'n' => '01009', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01010', 'r' => qr/hostunknown/    },
    { 'n' => '01011', 'r' => qr/hostunknown/    },
    { 'n' => '01012', 'r' => qr/userunknown/    },
    { 'n' => '01013', 'r' => qr/userunknown/    },
    { 'n' => '01014', 'r' => qr/hostunknown/    },
    { 'n' => '01015', 'r' => qr/hostunknown/    },
    { 'n' => '01016', 'r' => qr/hostunknown/    },
    { 'n' => '01017', 'r' => qr/userunknown/    },
    { 'n' => '01018', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01019', 'r' => qr/filtered/       },
    { 'n' => '01020', 'r' => qr/userunknown/    },
    { 'n' => '01021', 'r' => qr/hostunknown/    },
    { 'n' => '01022', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01023', 'r' => qr/hostunknown/    },
    { 'n' => '01024', 'r' => qr/hostunknown/    },
    { 'n' => '01025', 'r' => qr/hostunknown/    },
    { 'n' => '01026', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01027', 'r' => qr/hostunknown/    },
    { 'n' => '01028', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01029', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01030', 'r' => qr/hostunknown/    },
    { 'n' => '01031', 'r' => qr/hostunknown/    },
    { 'n' => '01032', 'r' => qr/userunknown/    },
    { 'n' => '01033', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01034', 'r' => qr/hostunknown/    },
    { 'n' => '01035', 'r' => qr/hostunknown/    },
    { 'n' => '01036', 'r' => qr/userunknown/    },
    { 'n' => '01037', 'r' => qr/hostunknown/    },
    { 'n' => '01038', 'r' => qr/userunknown/    },
    { 'n' => '01039', 'r' => qr/hostunknown/    },
    { 'n' => '01040', 'r' => qr/hostunknown/    },
    { 'n' => '01041', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01042', 'r' => qr/hostunknown/    },
    { 'n' => '01043', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01044', 'r' => qr/hostunknown/    },
    { 'n' => '01045', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01046', 'r' => qr/hostunknown/    },
    { 'n' => '01047', 'r' => qr/hostunknown/    },
    { 'n' => '01048', 'r' => qr/hostunknown/    },
    { 'n' => '01049', 'r' => qr/userunknown/    },
    { 'n' => '01050', 'r' => qr/(?:hostunknown|onhold)/ },
    { 'n' => '01051', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01052', 'r' => qr/(?:blocked|hostunknown|userunknown)/ },
    { 'n' => '01053', 'r' => qr/userunknown/    },
    { 'n' => '01054', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01055', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01056', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01057', 'r' => qr/hostunknown/    },
    { 'n' => '01058', 'r' => qr/userunknown/    },
    { 'n' => '01059', 'r' => qr/hostunknown/    },
    { 'n' => '01060', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01061', 'r' => qr/userunknown/    },
    { 'n' => '01062', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01063', 'r' => qr/hostunknown/    },
    { 'n' => '01064', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01065', 'r' => qr/hostunknown/    },
    { 'n' => '01066', 'r' => qr/(?:userunknown|norelaying)/ },
    { 'n' => '01067', 'r' => qr/hostunknown/    },
    { 'n' => '01068', 'r' => qr/hostunknown/    },
    { 'n' => '01069', 'r' => qr/filtered/       },
    { 'n' => '01070', 'r' => qr/hostunknown/    },
    { 'n' => '01071', 'r' => qr/hostunknown/    },
    { 'n' => '01072', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01073', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01074', 'r' => qr/(?:systemerror|userunknown)/ },
    { 'n' => '01075', 'r' => qr/hostunknown/    },
    { 'n' => '01076', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01077', 'r' => qr/hostunknown/    },
    { 'n' => '01078', 'r' => qr/hostunknown/    },
    { 'n' => '01079', 'r' => qr/hostunknown/    },
    { 'n' => '01080', 'r' => qr/hostunknown/    },
    { 'n' => '01081', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01082', 'r' => qr/userunknown/    },
    { 'n' => '01083', 'r' => qr/hostunknown/    },
    { 'n' => '01084', 'r' => qr/hostunknown/    },
    { 'n' => '01085', 'r' => qr/hostunknown/    },
    { 'n' => '01086', 'r' => qr/hostunknown/    },
    { 'n' => '01087', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01088', 'r' => qr/hostunknown/    },
    { 'n' => '01089', 'r' => qr/hostunknown/    },
    { 'n' => '01090', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01091', 'r' => qr/hostunknown/    },
    { 'n' => '01092', 'r' => qr/hostunknown/    },
    { 'n' => '01093', 'r' => qr/hostunknown/    },
    { 'n' => '01094', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01095', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01096', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01097', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01098', 'r' => qr/userunknown/    },
    { 'n' => '01099', 'r' => qr/(?:hostunknown|userunknown|blocked)/ },
    { 'n' => '01100', 'r' => qr/userunknown/    },
    { 'n' => '01101', 'r' => qr/hostunknown/    },
    { 'n' => '01102', 'r' => qr/hostunknown/    },
    { 'n' => '01103', 'r' => qr/hostunknown/    },
    { 'n' => '01104', 'r' => qr/userunknown/    },
    { 'n' => '01105', 'r' => qr/hostunknown/    },
    { 'n' => '01106', 'r' => qr/userunknown/    },
    { 'n' => '01107', 'r' => qr/userunknown/    },
    { 'n' => '01108', 'r' => qr/hostunknown/    },
    { 'n' => '01109', 'r' => qr/hostunknown/    },
    { 'n' => '01110', 'r' => qr/hostunknown/    },
    { 'n' => '01111', 'r' => qr/userunknown/    },
    { 'n' => '01112', 'r' => qr/userunknown/    },
    { 'n' => '01113', 'r' => qr/blocked/        },
    { 'n' => '01114', 'r' => qr/hostunknown/    },
    { 'n' => '01115', 'r' => qr/networkerror/   },
    { 'n' => '01116', 'r' => qr/hostunknown/    },
    { 'n' => '01117', 'r' => qr/blocked/        },
    { 'n' => '01118', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01119', 'r' => qr/expired/        },
    { 'n' => '01120', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01121', 'r' => qr/hostunknown/    },
    { 'n' => '01122', 'r' => qr/blocked/        },
    { 'n' => '01123', 'r' => qr/hostunknown/    },
    { 'n' => '01124', 'r' => qr/expired/        },
    { 'n' => '01125', 'r' => qr/expired/        },
    { 'n' => '01126', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01127', 'r' => qr/expired/        },
    { 'n' => '01128', 'r' => qr/norelaying/     },
    { 'n' => '01129', 'r' => qr/hostunknown/    },
    { 'n' => '01130', 'r' => qr/expired/        },
    { 'n' => '01131', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01132', 'r' => qr/filtered/       },
    { 'n' => '01133', 'r' => qr/hostunknown/    },
    { 'n' => '01134', 'r' => qr/expired/        },
    { 'n' => '01135', 'r' => qr/hostunknown/    },
    { 'n' => '01136', 'r' => qr/hostunknown/    },
    { 'n' => '01137', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01138', 'r' => qr/userunknown/    },
    { 'n' => '01139', 'r' => qr/(?:userunknown|hostunknown)/ },
    { 'n' => '01140', 'r' => qr/(?:hostunknown|userunknown)/ },
    { 'n' => '01141', 'r' => qr/hostunknown/    },
    { 'n' => '01142', 'r' => qr/(?:systemerror|userunknown)/ },
    { 'n' => '01143', 'r' => qr/hostunknown/    },
    { 'n' => '01144', 'r' => qr/(?:hostunknown|userunknown)/ },
];

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

