//
// C++ Implementation: CGlobalEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CGlobalEdit.hpp"

CGlobalEditDlg::CGlobalEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CGlobalEditDlg::~CGlobalEditDlg() {
}

void CGlobalEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CGlobalEditDlg::slotGetData(FolderListItem *i)
{
    ui.sscene->setText(i->GetValue("sscene",i));
    point=i;

    qWarning( "CGlobalEditDlg::slotGetData(): Geht !" );
}

void CGlobalEditDlg::slotEditData()
{
    if(point != NULL){
        point->SetValue("sscene",ui.sscene->text());
        point->updategl();
    }
    qWarning( "CGlobalEditDlg::slotEditData(): Geht !" );
}
