/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "friendsutils.h"
#include "friendsdispatcher.h"
#include "streammodel.h"
#include "plugin.h"

#include <QDebug>
#include <QQmlComponent>


void FriendsPlugin::registerTypes(const char *uri)
{
    Q_ASSERT(uri == QLatin1String("Friends"));

    qDebug() << Q_FUNC_INFO << uri;

    g_type_init ();

    qmlRegisterType<FriendsUtilsQml>(uri, 0, 2, "FriendsUtils");
    qmlRegisterType<FriendsDispatcherQml>(uri, 0, 2, "FriendsDispatcher");
    qmlRegisterType<StreamModel>(uri, 0, 2, "StreamModel");
}

