//
// Copyright 2021 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: atr_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // CURRENT_CONFIG_REG : 0x0 (atr_controller.v)
  // OPTION_REG         : 0x4 (atr_controller.v)
  // SW_CONFIG_REG      : 0x8 (atr_controller.v)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group ATR_REGISTERS
//===============================================================================

  // Enumerated type ATR_OPTIONS
  localparam ATR_OPTIONS_SIZE = 3;
  localparam SW_DEFINED   = 'h0;  // ATR_OPTIONS:SW_DEFINED
  localparam CLASSIC_ATR  = 'h1;  // ATR_OPTIONS:CLASSIC_ATR
  localparam FPGA_STATE   = 'h2;  // ATR_OPTIONS:FPGA_STATE

  // CURRENT_CONFIG_REG Register (from atr_controller.v)
  localparam CURRENT_CONFIG_REG = 'h0; // Register Offset
  localparam CURRENT_CONFIG_REG_SIZE = 32;  // register width in bits
  localparam CURRENT_CONFIG_REG_MASK = 32'hFFFFFFFF;
  localparam CURRENT_RF0_CONFIG_SIZE = 8;  //CURRENT_CONFIG_REG:CURRENT_RF0_CONFIG
  localparam CURRENT_RF0_CONFIG_MSB  = 7;  //CURRENT_CONFIG_REG:CURRENT_RF0_CONFIG
  localparam CURRENT_RF0_CONFIG      = 0;  //CURRENT_CONFIG_REG:CURRENT_RF0_CONFIG
  localparam CURRENT_RF1_CONFIG_SIZE =  8;  //CURRENT_CONFIG_REG:CURRENT_RF1_CONFIG
  localparam CURRENT_RF1_CONFIG_MSB  = 15;  //CURRENT_CONFIG_REG:CURRENT_RF1_CONFIG
  localparam CURRENT_RF1_CONFIG      =  8;  //CURRENT_CONFIG_REG:CURRENT_RF1_CONFIG
  localparam CURRENT_RF0_DSA_CONFIG_SIZE =  8;  //CURRENT_CONFIG_REG:CURRENT_RF0_DSA_CONFIG
  localparam CURRENT_RF0_DSA_CONFIG_MSB  = 23;  //CURRENT_CONFIG_REG:CURRENT_RF0_DSA_CONFIG
  localparam CURRENT_RF0_DSA_CONFIG      = 16;  //CURRENT_CONFIG_REG:CURRENT_RF0_DSA_CONFIG
  localparam CURRENT_RF1_DSA_CONFIG_SIZE =  8;  //CURRENT_CONFIG_REG:CURRENT_RF1_DSA_CONFIG
  localparam CURRENT_RF1_DSA_CONFIG_MSB  = 31;  //CURRENT_CONFIG_REG:CURRENT_RF1_DSA_CONFIG
  localparam CURRENT_RF1_DSA_CONFIG      = 24;  //CURRENT_CONFIG_REG:CURRENT_RF1_DSA_CONFIG

  // OPTION_REG Register (from atr_controller.v)
  localparam OPTION_REG = 'h4; // Register Offset
  localparam OPTION_REG_SIZE = 32;  // register width in bits
  localparam OPTION_REG_MASK = 32'h3030303;
  localparam RF0_OPTION_SIZE = 2;  //OPTION_REG:RF0_OPTION
  localparam RF0_OPTION_MSB  = 1;  //OPTION_REG:RF0_OPTION
  localparam RF0_OPTION      = 0;  //OPTION_REG:RF0_OPTION
  localparam RF1_OPTION_SIZE = 2;  //OPTION_REG:RF1_OPTION
  localparam RF1_OPTION_MSB  = 9;  //OPTION_REG:RF1_OPTION
  localparam RF1_OPTION      = 8;  //OPTION_REG:RF1_OPTION
  localparam RF0_DSA_OPTION_SIZE =  2;  //OPTION_REG:RF0_DSA_OPTION
  localparam RF0_DSA_OPTION_MSB  = 17;  //OPTION_REG:RF0_DSA_OPTION
  localparam RF0_DSA_OPTION      = 16;  //OPTION_REG:RF0_DSA_OPTION
  localparam RF1_DSA_OPTION_SIZE =  2;  //OPTION_REG:RF1_DSA_OPTION
  localparam RF1_DSA_OPTION_MSB  = 25;  //OPTION_REG:RF1_DSA_OPTION
  localparam RF1_DSA_OPTION      = 24;  //OPTION_REG:RF1_DSA_OPTION

  // SW_CONFIG_REG Register (from atr_controller.v)
  localparam SW_CONFIG_REG = 'h8; // Register Offset
  localparam SW_CONFIG_REG_SIZE = 32;  // register width in bits
  localparam SW_CONFIG_REG_MASK = 32'hFFFFFFFF;
  localparam SW_RF0_CONFIG_SIZE = 8;  //SW_CONFIG_REG:SW_RF0_CONFIG
  localparam SW_RF0_CONFIG_MSB  = 7;  //SW_CONFIG_REG:SW_RF0_CONFIG
  localparam SW_RF0_CONFIG      = 0;  //SW_CONFIG_REG:SW_RF0_CONFIG
  localparam SW_RF1_CONFIG_SIZE =  8;  //SW_CONFIG_REG:SW_RF1_CONFIG
  localparam SW_RF1_CONFIG_MSB  = 15;  //SW_CONFIG_REG:SW_RF1_CONFIG
  localparam SW_RF1_CONFIG      =  8;  //SW_CONFIG_REG:SW_RF1_CONFIG
  localparam SW_RF0_DSA_CONFIG_SIZE =  8;  //SW_CONFIG_REG:SW_RF0_DSA_CONFIG
  localparam SW_RF0_DSA_CONFIG_MSB  = 23;  //SW_CONFIG_REG:SW_RF0_DSA_CONFIG
  localparam SW_RF0_DSA_CONFIG      = 16;  //SW_CONFIG_REG:SW_RF0_DSA_CONFIG
  localparam SW_RF1_DSA_CONFIG_SIZE =  8;  //SW_CONFIG_REG:SW_RF1_DSA_CONFIG
  localparam SW_RF1_DSA_CONFIG_MSB  = 31;  //SW_CONFIG_REG:SW_RF1_DSA_CONFIG
  localparam SW_RF1_DSA_CONFIG      = 24;  //SW_CONFIG_REG:SW_RF1_DSA_CONFIG
