/*
 * Copyright (C) 2020 KylinSoft Co., Ltd.
 *
 * Authors:
 *  Kobe Lee    xiangli@ubuntukylin.com/kobe24_lixiang@126.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __PROCESS_H
#define __PROCESS_H

#include <cassert>
#include <QDebug>
#include "kylinsystemnethogs.h"
#include "connection.h"

void check_all_procs ();

class ConnList
{
public:
    ConnList (Connection * m_val, ConnList * m_next)
    {
        assert (m_val != NULL);
        val = m_val; next = m_next;
    }
    ~ConnList ()
    {
        /* does not delete its value, to allow a connection to
         * remove itself from the global connlist in its destructor */
    }
    Connection * getVal ()
    {
        return val;
    }
    void setNext (ConnList * m_next)
    {
        next = m_next;
    }
    ConnList * getNext ()
    {
        return next;
    }
private:
    Connection * val;
    ConnList * next;
};

class Process
{
public:
    /* the process makes a copy of the name. the device name needs to be stable. */
    Process (const unsigned long m_inode, const char * m_devicename, const char * m_name = NULL)
        : inode (m_inode)
    {
        //std::cout << "ARN: Process created with dev " << m_devicename << std::endl;
        if (DEBUG)
            std::cout << "PROC: Process created at " << this << std::endl;

        if (m_name == NULL)
            name = NULL;
        else
            name = strdup(m_name);

        devicename = m_devicename;
        connections = NULL;
        pid = 0;
        uid = 0;
    }
    void check () {
        assert (pid >= 0);
    }

    ~Process ()
    {
        free (name);
        if (DEBUG)
            std::cout << "PROC: Process deleted at " << this << std::endl;

//        if(unknowntcp)
//        {
//            delete unknowntcp;
//        }
    }
    int getLastPacket ();

    char * name;
    const char * devicename;
    int pid;

    ConnList * connections;
    uid_t getUid()
    {
        return uid;
    }

    void setUid(uid_t m_uid)
    {
        uid = m_uid;
    }

    unsigned long getInode()
    {
        return inode;
    }
private:
    const unsigned long inode;
    uid_t uid;
};

class ProcList
{
public:
    ProcList (Process * m_val, ProcList * m_next)
    {
        assert (m_val != NULL);
        val = m_val; next = m_next;
    }
    int size ();
    Process * getVal () { return val; }
    ProcList * getNext () { return next; }
    ProcList * next;
    ~ProcList()
    {/*
        if(processes)
        {
            delete processes;
        }*/
    }
private:
    Process * val;
};

Process * getProcess (Connection * connection, const char * devicename = NULL);

void process_init ();

void process_delete();

void refreshconninode ();

void procclean ();

#endif
