import sys
import os

def get_test_folders(path):
    import os
    if not os.path.exists(path):
        raise Exception("Invalid path: does not exist")
    return [os.path.join(path,folder) for folder in os.listdir(path) if os.path.isdir(os.path.join(path,folder)) and folder.endswith('_test')]

def launch_test(path):
    import os
    if not os.path.exists(path):
        raise Exception("Invalid path for test: " + path)
    import subprocess
    subprocess.check_call(['xdg-open'])

def detect_chrome_exec():
    import gio
    return gio.app_info_get_default_for_uri_scheme('http').get_executable()

chrome_exec = detect_chrome_exec()
if not "chrome" in chrome_exec or not "chromium" in chrome_exec:
    # TODO fix this w/ proper parameters/flags
    print "Only work with chrome as the default browser"
    sys.exit(1)

# add 
test_folders = get_test_folders(os.getcwd())
for test_folder in test_folders:
    import subprocess
    print subprocess.check_output ([chrome_exec, '--load-extension="' + test_folder + '"'])

