/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       Credentials.h
//
//  Contents:   definitions to retrieve AMT credentials
//
//----------------------------------------------------------------------------

#ifndef _CREDENTIALS_H
#define _CREDENTIALS_H

#include <string>

struct Credentials {
  Credentials(const std::string &user, const std::string &pass,
	      const std::string &cert, const std::string &_cainfo = "",
	      const std::string &_capath = "", const std::string &_sslkey = "") :
    username(user), password(pass), certificate(cert), cainfo(_cainfo), capath(_capath), sslkey(_sslkey){}
  Credentials() {}

  std::string username;
  std::string password;
  std::string certificate;
  std::string cainfo;
  std::string capath;
  std::string sslkey;
};

struct CredentialsRegInfo {
  CredentialsRegInfo(const std::string &base,
		     const std::string &key,
		     const std::string &user,
		     const std::string &pass,
		     const std::string &cert,
		     const std::string &cainfo,
		     const std::string &capath,
		     const std::string &sslKey);

  std::string regBase;
  std::string regKey;
  std::string regUser;
  std::string regPass;
  std::string regCert;
  std::string regCainfo;
  std::string regCapath;
  std::string regSSLkey;
};

Credentials* RetrieveCredentials(const CredentialsRegInfo &credRegInfo);
std::string	 RetrieveCertificate(const CredentialsRegInfo &credRegInfo);
bool StoreCredentials(Credentials *cred, const CredentialsRegInfo &credRegInfo);

#endif // _CREDENTIALS_H
