/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CCODE_COMPILER (vala_ccode_compiler_get_type ())
#define VALA_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler))
#define VALA_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))
#define VALA_IS_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMPILER))
#define VALA_IS_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMPILER))
#define VALA_CCODE_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))

typedef struct _ValaCCodeCompiler ValaCCodeCompiler;
typedef struct _ValaCCodeCompilerClass ValaCCodeCompilerClass;
typedef struct _ValaCCodeCompilerPrivate ValaCCodeCompilerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaCCodeCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeCompilerPrivate * priv;
};

struct _ValaCCodeCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeCompiler *self);
};

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

gpointer vala_ccode_compiler_ref (gpointer instance);
void vala_ccode_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_compiler (GValue* value, gpointer v_object);
void vala_value_take_ccode_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_compiler (const GValue* value);
GType vala_ccode_compiler_get_type (void) G_GNUC_CONST;
enum  {
	VALA_CCODE_COMPILER_DUMMY_PROPERTY
};
ValaCCodeCompiler* vala_ccode_compiler_new (void);
ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type);
static gboolean vala_ccode_compiler_package_exists (const gchar* package_name);
void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1);
static void vala_ccode_compiler_finalize (ValaCCodeCompiler* obj);


ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type) {
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler* vala_ccode_compiler_new (void) {
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


static gboolean vala_ccode_compiler_package_exists (const gchar* package_name) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* pc;
	gint exit_status = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (package_name != NULL, FALSE);
	_tmp0_ = package_name;
	_tmp1_ = g_strconcat ("pkg-config --exists ", _tmp0_, NULL);
	pc = _tmp1_;
	{
		gint _tmp2_ = 0;
		g_spawn_command_line_sync (pc, NULL, NULL, &_tmp2_, &_inner_error_);
		exit_status = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = 0 == exit_status;
		_g_free0 (pc);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		vala_report_error (NULL, _tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally1:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1) {
	gboolean use_pkgconfig;
	gchar* _tmp0_;
	gchar* pc;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ValaCodeContext* _tmp6_;
	ValaProfile _tmp7_;
	ValaProfile _tmp8_;
	gchar* _tmp34_;
	gchar* pkgflags;
	gboolean _tmp35_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* cmdline;
	ValaCodeContext* _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	ValaCodeContext* _tmp53_;
	gboolean _tmp54_;
	gboolean _tmp55_;
	ValaCodeContext* _tmp93_;
	ValaList* _tmp94_ = NULL;
	ValaList* source_files;
	ValaCodeContext* _tmp118_;
	ValaList* _tmp119_ = NULL;
	ValaList* c_source_files;
	const gchar* _tmp138_;
	const gchar* _tmp139_;
	gchar* _tmp140_ = NULL;
	gchar* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	gchar* _tmp144_;
	gchar** _tmp145_;
	gint _tmp145__length1;
	ValaCodeContext* _tmp154_;
	gboolean _tmp155_;
	gboolean _tmp156_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	use_pkgconfig = FALSE;
	_tmp0_ = g_strdup ("pkg-config --cflags");
	pc = _tmp0_;
	_tmp1_ = context;
	_tmp2_ = vala_code_context_get_compile_only (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = pc;
		_tmp5_ = g_strconcat (_tmp4_, " --libs", NULL);
		_g_free0 (pc);
		pc = _tmp5_;
	}
	_tmp6_ = context;
	_tmp7_ = vala_code_context_get_profile (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == VALA_PROFILE_GOBJECT) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		ValaCodeContext* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		use_pkgconfig = TRUE;
		_tmp9_ = pc;
		_tmp10_ = g_strconcat (_tmp9_, " gobject-2.0", NULL);
		_g_free0 (pc);
		pc = _tmp10_;
		_tmp11_ = context;
		_tmp12_ = vala_code_context_get_thread (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = pc;
			_tmp15_ = g_strconcat (_tmp14_, " gthread-2.0", NULL);
			_g_free0 (pc);
			pc = _tmp15_;
		}
	}
	{
		ValaCodeContext* _tmp16_;
		ValaList* _tmp17_ = NULL;
		ValaList* _pkg_list;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _pkg_size;
		gint _pkg_index;
		_tmp16_ = context;
		_tmp17_ = vala_code_context_get_packages (_tmp16_);
		_pkg_list = _tmp17_;
		_tmp18_ = _pkg_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_pkg_size = _tmp20_;
		_pkg_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			ValaList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_ = NULL;
			gchar* pkg;
			const gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp21_ = _pkg_index;
			_pkg_index = _tmp21_ + 1;
			_tmp22_ = _pkg_index;
			_tmp23_ = _pkg_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _pkg_list;
			_tmp25_ = _pkg_index;
			_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
			pkg = (gchar*) _tmp26_;
			_tmp27_ = pkg;
			_tmp28_ = vala_ccode_compiler_package_exists (_tmp27_);
			if (_tmp28_) {
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				use_pkgconfig = TRUE;
				_tmp29_ = pc;
				_tmp30_ = pkg;
				_tmp31_ = g_strconcat (" ", _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
				_g_free0 (pc);
				pc = _tmp33_;
				_g_free0 (_tmp32_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp34_ = g_strdup ("");
	pkgflags = _tmp34_;
	_tmp35_ = use_pkgconfig;
	if (_tmp35_) {
		{
			gint exit_status = 0;
			const gchar* _tmp36_;
			gchar* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gint _tmp39_;
			_tmp36_ = pc;
			g_spawn_command_line_sync (_tmp36_, &_tmp37_, NULL, &_tmp38_, &_inner_error_);
			_g_free0 (pkgflags);
			pkgflags = _tmp37_;
			exit_status = _tmp38_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch2_g_spawn_error;
				}
				_g_free0 (pkgflags);
				_g_free0 (pc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp39_ = exit_status;
			if (_tmp39_ != 0) {
				gint _tmp40_;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_;
				_tmp40_ = exit_status;
				_tmp41_ = g_strdup_printf ("pkg-config exited with status %d", _tmp40_);
				_tmp42_ = _tmp41_;
				vala_report_error (NULL, _tmp42_);
				_g_free0 (_tmp42_);
				_g_free0 (pkgflags);
				_g_free0 (pc);
				return;
			}
		}
		goto __finally2;
		__catch2_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp43_;
			const gchar* _tmp44_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp43_ = e;
			_tmp44_ = _tmp43_->message;
			vala_report_error (NULL, _tmp44_);
			_g_error_free0 (e);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp45_ = cc_command;
	if (_tmp45_ == NULL) {
		cc_command = "cc";
	}
	_tmp46_ = cc_command;
	_tmp47_ = g_strdup (_tmp46_);
	cmdline = _tmp47_;
	_tmp48_ = context;
	_tmp49_ = vala_code_context_get_debug (_tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_) {
		const gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp51_ = cmdline;
		_tmp52_ = g_strconcat (_tmp51_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp52_;
	}
	_tmp53_ = context;
	_tmp54_ = vala_code_context_get_compile_only (_tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_) {
		const gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp56_ = cmdline;
		_tmp57_ = g_strconcat (_tmp56_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp57_;
	} else {
		ValaCodeContext* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		_tmp58_ = context;
		_tmp59_ = vala_code_context_get_output (_tmp58_);
		_tmp60_ = _tmp59_;
		if (_tmp60_ != NULL) {
			ValaCodeContext* _tmp61_;
			const gchar* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* output;
			gboolean _tmp65_ = FALSE;
			gboolean _tmp66_ = FALSE;
			ValaCodeContext* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gboolean _tmp73_;
			gboolean _tmp78_;
			const gchar* _tmp86_;
			const gchar* _tmp87_;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			_tmp61_ = context;
			_tmp62_ = vala_code_context_get_output (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strdup (_tmp63_);
			output = _tmp64_;
			_tmp67_ = context;
			_tmp68_ = vala_code_context_get_directory (_tmp67_);
			_tmp69_ = _tmp68_;
			if (_tmp69_ != NULL) {
				ValaCodeContext* _tmp70_;
				const gchar* _tmp71_;
				const gchar* _tmp72_;
				_tmp70_ = context;
				_tmp71_ = vala_code_context_get_directory (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp66_ = g_strcmp0 (_tmp72_, "") != 0;
			} else {
				_tmp66_ = FALSE;
			}
			_tmp73_ = _tmp66_;
			if (_tmp73_) {
				ValaCodeContext* _tmp74_;
				const gchar* _tmp75_;
				const gchar* _tmp76_;
				gboolean _tmp77_ = FALSE;
				_tmp74_ = context;
				_tmp75_ = vala_code_context_get_output (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_path_is_absolute (_tmp76_);
				_tmp65_ = !_tmp77_;
			} else {
				_tmp65_ = FALSE;
			}
			_tmp78_ = _tmp65_;
			if (_tmp78_) {
				ValaCodeContext* _tmp79_;
				const gchar* _tmp80_;
				const gchar* _tmp81_;
				ValaCodeContext* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				gchar* _tmp85_ = NULL;
				_tmp79_ = context;
				_tmp80_ = vala_code_context_get_directory (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = context;
				_tmp83_ = vala_code_context_get_output (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strdup_printf ("%s%c%s", _tmp81_, (gint) G_DIR_SEPARATOR, _tmp84_);
				_g_free0 (output);
				output = _tmp85_;
			}
			_tmp86_ = cmdline;
			_tmp87_ = output;
			_tmp88_ = g_shell_quote (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = g_strconcat (" -o ", _tmp89_, NULL);
			_tmp91_ = _tmp90_;
			_tmp92_ = g_strconcat (_tmp86_, _tmp91_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp92_;
			_g_free0 (_tmp91_);
			_g_free0 (_tmp89_);
			_g_free0 (output);
		}
	}
	_tmp93_ = context;
	_tmp94_ = vala_code_context_get_source_files (_tmp93_);
	source_files = _tmp94_;
	{
		ValaList* _tmp95_;
		ValaList* _tmp96_;
		ValaList* _file_list;
		ValaList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		gint _file_size;
		gint _file_index;
		_tmp95_ = source_files;
		_tmp96_ = _vala_iterable_ref0 (_tmp95_);
		_file_list = _tmp96_;
		_tmp97_ = _file_list;
		_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
		_tmp99_ = _tmp98_;
		_file_size = _tmp99_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			ValaList* _tmp103_;
			gint _tmp104_;
			gpointer _tmp105_ = NULL;
			ValaSourceFile* file;
			ValaSourceFile* _tmp106_;
			ValaSourceFileType _tmp107_;
			ValaSourceFileType _tmp108_;
			_tmp100_ = _file_index;
			_file_index = _tmp100_ + 1;
			_tmp101_ = _file_index;
			_tmp102_ = _file_size;
			if (!(_tmp101_ < _tmp102_)) {
				break;
			}
			_tmp103_ = _file_list;
			_tmp104_ = _file_index;
			_tmp105_ = vala_list_get (_tmp103_, _tmp104_);
			file = (ValaSourceFile*) _tmp105_;
			_tmp106_ = file;
			_tmp107_ = vala_source_file_get_file_type (_tmp106_);
			_tmp108_ = _tmp107_;
			if (_tmp108_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp109_;
				ValaSourceFile* _tmp110_;
				gchar* _tmp111_ = NULL;
				gchar* _tmp112_;
				gchar* _tmp113_ = NULL;
				gchar* _tmp114_;
				gchar* _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				_tmp109_ = cmdline;
				_tmp110_ = file;
				_tmp111_ = vala_source_file_get_csource_filename (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = g_shell_quote (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = g_strconcat (" ", _tmp114_, NULL);
				_tmp116_ = _tmp115_;
				_tmp117_ = g_strconcat (_tmp109_, _tmp116_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp117_;
				_g_free0 (_tmp116_);
				_g_free0 (_tmp114_);
				_g_free0 (_tmp112_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp118_ = context;
	_tmp119_ = vala_code_context_get_c_source_files (_tmp118_);
	c_source_files = _tmp119_;
	{
		ValaList* _tmp120_;
		ValaList* _tmp121_;
		ValaList* _file_list;
		ValaList* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _file_size;
		gint _file_index;
		_tmp120_ = c_source_files;
		_tmp121_ = _vala_iterable_ref0 (_tmp120_);
		_file_list = _tmp121_;
		_tmp122_ = _file_list;
		_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
		_tmp124_ = _tmp123_;
		_file_size = _tmp124_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_ = NULL;
			gchar* file;
			const gchar* _tmp131_;
			const gchar* _tmp132_;
			gchar* _tmp133_ = NULL;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			_tmp125_ = _file_index;
			_file_index = _tmp125_ + 1;
			_tmp126_ = _file_index;
			_tmp127_ = _file_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _file_list;
			_tmp129_ = _file_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			file = (gchar*) _tmp130_;
			_tmp131_ = cmdline;
			_tmp132_ = file;
			_tmp133_ = g_shell_quote (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strconcat (" ", _tmp134_, NULL);
			_tmp136_ = _tmp135_;
			_tmp137_ = g_strconcat (_tmp131_, _tmp136_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp137_;
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp138_ = cmdline;
	_tmp139_ = pkgflags;
	_tmp140_ = string_strip (_tmp139_);
	_tmp141_ = _tmp140_;
	_tmp142_ = g_strconcat (" ", _tmp141_, NULL);
	_tmp143_ = _tmp142_;
	_tmp144_ = g_strconcat (_tmp138_, _tmp143_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp144_;
	_g_free0 (_tmp143_);
	_g_free0 (_tmp141_);
	_tmp145_ = cc_options;
	_tmp145__length1 = cc_options_length1;
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = _tmp145_;
		cc_option_collection_length1 = _tmp145__length1;
		for (cc_option_it = 0; cc_option_it < _tmp145__length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp146_;
			gchar* cc_option = NULL;
			_tmp146_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp146_;
			{
				const gchar* _tmp147_;
				const gchar* _tmp148_;
				gchar* _tmp149_ = NULL;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				_tmp147_ = cmdline;
				_tmp148_ = cc_option;
				_tmp149_ = g_shell_quote (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = g_strconcat (" ", _tmp150_, NULL);
				_tmp152_ = _tmp151_;
				_tmp153_ = g_strconcat (_tmp147_, _tmp152_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp153_;
				_g_free0 (_tmp152_);
				_g_free0 (_tmp150_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp154_ = context;
	_tmp155_ = vala_code_context_get_verbose_mode (_tmp154_);
	_tmp156_ = _tmp155_;
	if (_tmp156_) {
		FILE* _tmp157_;
		const gchar* _tmp158_;
		_tmp157_ = stdout;
		_tmp158_ = cmdline;
		fprintf (_tmp157_, "%s\n", _tmp158_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp159_;
		gint _tmp160_ = 0;
		gint _tmp161_;
		_tmp159_ = cmdline;
		g_spawn_command_line_sync (_tmp159_, NULL, NULL, &_tmp160_, &_inner_error_);
		exit_status = _tmp160_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp161_ = exit_status;
		if (_tmp161_ != 0) {
			gint _tmp162_;
			gchar* _tmp163_ = NULL;
			gchar* _tmp164_;
			_tmp162_ = exit_status;
			_tmp163_ = g_strdup_printf ("cc exited with status %d", _tmp162_);
			_tmp164_ = _tmp163_;
			vala_report_error (NULL, _tmp164_);
			_g_free0 (_tmp164_);
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp165_;
		const gchar* _tmp166_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp165_ = e;
		_tmp166_ = _tmp165_->message;
		vala_report_error (NULL, _tmp166_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaList* _tmp167_;
		ValaList* _tmp168_;
		ValaList* _file_list;
		ValaList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gint _file_size;
		gint _file_index;
		_tmp167_ = source_files;
		_tmp168_ = _vala_iterable_ref0 (_tmp167_);
		_file_list = _tmp168_;
		_tmp169_ = _file_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_file_size = _tmp171_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			ValaList* _tmp175_;
			gint _tmp176_;
			gpointer _tmp177_ = NULL;
			ValaSourceFile* file;
			ValaSourceFile* _tmp178_;
			ValaSourceFileType _tmp179_;
			ValaSourceFileType _tmp180_;
			_tmp172_ = _file_index;
			_file_index = _tmp172_ + 1;
			_tmp173_ = _file_index;
			_tmp174_ = _file_size;
			if (!(_tmp173_ < _tmp174_)) {
				break;
			}
			_tmp175_ = _file_list;
			_tmp176_ = _file_index;
			_tmp177_ = vala_list_get (_tmp175_, _tmp176_);
			file = (ValaSourceFile*) _tmp177_;
			_tmp178_ = file;
			_tmp179_ = vala_source_file_get_file_type (_tmp178_);
			_tmp180_ = _tmp179_;
			if (_tmp180_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaCodeContext* _tmp181_;
				gboolean _tmp182_;
				gboolean _tmp183_;
				_tmp181_ = context;
				_tmp182_ = vala_code_context_get_save_csources (_tmp181_);
				_tmp183_ = _tmp182_;
				if (!_tmp183_) {
					ValaSourceFile* _tmp184_;
					gchar* _tmp185_ = NULL;
					gchar* _tmp186_;
					_tmp184_ = file;
					_tmp185_ = vala_source_file_get_csource_filename (_tmp184_);
					_tmp186_ = _tmp185_;
					g_unlink (_tmp186_);
					_g_free0 (_tmp186_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void vala_value_ccode_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_ccode_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_ccode_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_ccode_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_ccode_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_ccode_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCCodeCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_ccode_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void vala_value_take_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass) {
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_COMPILER_CLASS (klass)->finalize = vala_ccode_compiler_finalize;
}


static void vala_ccode_compiler_instance_init (ValaCCodeCompiler * self) {
	self->ref_count = 1;
}


static void vala_ccode_compiler_finalize (ValaCCodeCompiler* obj) {
	ValaCCodeCompiler * self;
	self = VALA_CCODE_COMPILER (obj);
}


/**
 * Interface to the C compiler.
 */
GType vala_ccode_compiler_get_type (void) {
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer vala_ccode_compiler_ref (gpointer instance) {
	ValaCCodeCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_ccode_compiler_unref (gpointer instance) {
	ValaCCodeCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



