/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef FORMS_H
#define FORMS_H

#include <vdk/application.h>
#include <vdk/dlist.h>
#include <vdk/vdktypes.h>
#include <vdk/rawobj.h>
#include <vdk/vdkprops.h>
#include <vdk/vdkutils.h>
#include <vdk/vdkstring.h>
#include <vdk/vdkobj.h>
class VDKObject;

class VDKColor;
class VDKForm;
class VDKFont;
class VDKBox;
class VDKRawPixmap;

typedef VDKList<VDKForm> ChildList;
typedef VDKListiterator<VDKForm> ChildListIterator;

typedef VDKList<VDKObject> ObjectList;
typedef VDKListiterator<VDKObject> ObjectListIterator;


/*!
  \class VDKForm
  \brief VDKForm widgets, generally the outermost widget container.

  This class provides a common interface with GTK+ windows that are 
  here called "Forms". VDKForm provides common functionalities for all
  derived classes.

  <center>
  \htmlonly
  <img align=center src="vdkform.gif"><br>
  \endhtmlonly
  </center>
 */

class VDKForm : public VDKObject
{

 private:
  /*!
    copy and assignement prohibited
  */
  VDKForm(VDKForm& ):VDKObject( NULL) {}
  /*!
    copy and assignement prohibited
  */
  VDKForm& operator=(VDKForm& ) { return *this; }
protected:
  /*!
    \internal
  */
  void SignalsConnect();
  /*!
    owner application address
  */
  VDKApplication* app;
  /*!
    child and child garbage list
  */
  ChildList childs,childsGarbage;
  /*!
    underlaying gtk+ window
  */
  GtkWidget *window;
  /*!
    default inner box
  */
  VDKBox* box;
  /*!
    modal flag
  */
  bool isModal;
  /*!
    never showed flag
  */
  bool never_showed;
  /*
    position storage
  */
  VDKPoint _oldPos;
  /*!
    size storage
  */
  VDKPoint _oldSize;
  /*!
    counts how many modal childs we have
    should be always max 1
  */
  int modalCount;
  /*
    \internal
  */
  static int ConfigureEvent(GtkWidget* ,
			     GdkEventConfigure* ev,
			     gpointer gp);
  /*
    \internal
  */
  static gboolean WindowStateEvent (GtkWidget  *widget, GdkEventWindowState *event);
  /*
    \internal
  */
  static int DestroyEvent (GtkWidget*, gpointer gp);
  /*
    \internal
  */
  static int DeleteEvent(GtkWidget* , GdkEvent* , gpointer gp);
  /*
    \internal
  */
  static int ExposeEvent(GtkWidget* ,
			  GdkEventExpose* ev, gpointer gp);
  /*
    \internal
  */
  static void RealizeSignal(GtkWidget* , gpointer gp);
  /*
    \internal
  */
  static int MapEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  /*
    \internal
  */
  static int UnmapEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  /*
    \internal
  */
  static int FocusInEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  /*
    \internal
  */
  static int FocusOutEvent(GtkWidget* , GdkEvent* ev ,gpointer gp);
  /*
    \internal
  */
  static void SizeAllocateSignal(GtkWidget      *widget,
			    GtkAllocation  *allocation,
			    gpointer gp);
public:
  /*
    properties
  */
  VDKReadWriteValueProp<VDKForm,bool> Visible;
  VDKReadWriteValueProp<VDKForm,VDKString> Title;
  VDKReadWriteValueProp<VDKForm,VDKPoint> Position;
  VDKReadWriteValueProp<VDKForm,bool> Iconized;
  VDKReadWriteValueProp<VDKForm,VDKRawPixmap*> BackgroundPixmap;
  VDKReadWriteValueProp<VDKForm,VDKObject*> FocusWidget;

  /*
    constructors
  */
  /*!
    constructor, makes a main form, application child
    \param app the application that owns the form
    \param title
    \param mode as inner box should be, either vertical (v_box)
    or horizontal (h_box)
    \param display display type can be one of the following:
    - GTK_WINDOW_TOPLEVEL
    - GTK_WINDOW_DIALOG
    - GTK_WINDOW_POPUP
    behavio_ vdksdl_form_hur depends on window manager
  */
  VDKForm(VDKApplication* app,
	  char* title = (char*) NULL,
	  int mode = v_box,
	  GtkWindowType display = GTK_WINDOW_TOPLEVEL);
  /*!
    constructor, makes a child form
    \param owner the form that owns the child form
    \param title
    \param mode as inner box should be, either vertical (v_box)
    or horizontal (h_box)
    \param display display type can be one of the following:
    - GTK_WINDOW_TOPLEVEL
    - GTK_WINDOW_DIALOG
    - GTK_WINDOW_POPUP
    behaviour depends on window manager
  */
  VDKForm(VDKForm* owner,
	  char* title = (char*) NULL,
	  int mode = v_box,
	  GtkWindowType display = GTK_WINDOW_TOPLEVEL);
  /*!
    \internal
  */
  VDKForm(VDKApplication* app,
	  GtkWidget* wid,
	  char* title = (char*) NULL);

#if HAVE_GNOME
  /*!
    \internal
  */
VDKForm(VDKForm* owner,
	 GtkWidget* wid,
	 char* title = (char*) NULL);
#endif
/*!
  Destructor
 */
 virtual ~VDKForm();
 /*!
   Explicitely destroy a form.
 */
 bool                     Destroy();
 /*!
   \internal
 */
 virtual int              isA() { return form_class; }
 /*!
   return inner box
 */
 VDKBox*                   Box() { return box; }
 /*!
   Shows form.
   \param pos indicates initial form position, can be one of the
   following:
   - GTK_WIN_POS_NONE
   - GTK_WIN_POS_CENTER
   - GTK_WIN_POS_MOUSE
   - GTK_WIN_POS_CENTER_ALWAYS
 */
 virtual void              Show(GtkWindowPosition pos = GTK_WIN_POS_NONE);
 /*!
   Hides form
 */
 virtual void              Hide();
 /*!
   Shows a form in modal behaviour
   \param pos indicates initial form position, can be one of the
   following:
   - GTK_WIN_POS_NONE
   - GTK_WIN_POS_CENTER
   - GTK_WIN_POS_MOUSE
   - GTK_WIN_POS_CENTER_ALWAYS
 */
 virtual void              ShowModal(GtkWindowPosition pos = GTK_WIN_POS_NONE);
 /*!
   Return if a showed window is modal or not
 */
 bool                      IsModal() { return isModal; }
 /*!
   Add an object to the form.
   Tip: <obj> will be actually added to inner box
   same as form->Box()->Add();
   \param obj the object to be added
   \param justify where the object wil be added, can be:
   - l_justify packed to end (appended)
   - r_justify packed to start (prepended)
   \param expand if true objet will expand from container center
   \param fill if true object will fill all available space
   \param padding how many pixels are left around object
 */
 virtual void Add(VDKObject* obj, int justify = l_justify,
		  int expand = TRUE, int fill = TRUE ,
		  int padding = 1);
 /*!
   \internal
 */
 void              AddChild(VDKForm* child);
 /*!
   Return form owner
   Tip: returns NULL id <this> is main form
  */
 VDKForm*                 Owner() { return owner; }
 /*!
   \internal
 */
 void                       RemoveChild(VDKForm* child);
 /*!
   Placeholder for subclasses.
   User should override this returning a false (don't close)
   or true (close) value.
 */
 virtual bool               CanClose(void);
 /*!
   Closes the form, if form is main application form
   it quits application as well. Call CanClose()
   before, if it returns true closes the form otherwise
   form won't be closed.
 */
 virtual void               Close(void);

 // this makes a VDKForm an abstract class
 /*!
   Must be overridden by subclasses, in this
   method user fills form with useful widgets
 */
 virtual void               Setup(void) = 0;

 void                       SetTitle(VDKString title)
   { gtk_window_set_title(GTK_WINDOW(window),(char*) title); }

 VDKString                  GetTitle(void)
   {
     VDKString title = Title;
     return VDKString(title);
   }

 GtkWidget*                  Window() { return window; }

 VDKApplication*             Application() { return app; }

 void                        CloseChilds(void);

 void                        CollectGarbage();

 ObjectList& Objects(void) { return items; }

 ChildList&                  Childs(void) { return childs; }
 ChildList&                  ChildsGarbage(void)
   { return childsGarbage; }
 /*!
   Raises form
 */
 void                 Raise();
 /*!
   Lower form
 */
 void                 Lower();

 void                 SetVisible(bool flag)
   {
     if(flag) Show();
     else Hide();
   }
 bool                        GetVisible()
   { return GTK_WIDGET_VISIBLE(window); };
 /*
  */
 void SetIcon(VDKRawPixmap*);
 void SetIconName(char* name);
 void SetPosition(VDKPoint p);
 VDKPoint GetPosition();
 //
 void SetDefaultSize(VDKPoint p);
 void SetFormSize(VDKPoint p)
   { if(window) gdk_window_resize(window->window,p.X(),p.Y()); }
 bool GetIconized();
 void SetIconized(bool flag);
 void SetBackgroundPixmap(VDKRawPixmap* pix);
 void SetFocusWidget(VDKObject* focuswidget);
 /*
event response (place holders for subclasses)
*/
 static void  ButtonPressEvent(GtkWidget* ,
			       GdkEventButton* ev,
			       gpointer gp);

 virtual void OnExpose( VDKForm* sender, GdkRectangle area);
 virtual void OnChildClosing(VDKForm* child);
 virtual void OnShow(VDKForm* sender);
 virtual void OnRealize(VDKForm* sender);
 virtual void OnConfigure(VDKForm* sender);
 virtual void OnMove(VDKForm* sender);
 virtual void OnResize(VDKForm* sender, VDKPoint& size);
 virtual void OnIconize(VDKForm* sender);
 virtual void OnRestore(VDKForm* sender);
 virtual void OnFormActivate(VDKForm* sender, bool in_out);
/*
  Answers to a MS Windows-like message.
  Not very useful, just added  to facilitate
  porting my neural lib from MS Windows to VDK.
  Casual user should override in his own forms.
  */
 virtual int
     WindozeMessage(int /*msg*/,
		    unsigned int /*wParam*/,
		    long unsigned int /*lParam*/)
     {
	 return 0;
     }
};

#endif



