/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#if HAVE_GNOME
#ifndef _vdkb_date_edit_h
#define _vdkb_date_edit_h
#include <vdk/vdk.h>
#include <vdkb2/vdkb_object.h>
#include <vdkb2/vdkb_widpopmenu.h>
#include <vdk/vdkgnomededit.h>

class VDKBGuiForm;
class VDKBParser;

class VDKBGnomeDateEdit:
public VDKGnomeDateEdit, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKBObjectInspector* inspector;
  // specific to this widget
  VDKCheckButton* showtime,*format24;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner,
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBGnomeDateEdit(char* name,VDKForm* owner);
  virtual ~VDKBGnomeDateEdit() {}
  //
  virtual int Type() { return vdkbclass_date_edit; }
  virtual char* VDKName() { return "VDKGnomeDateEdit"; }
  virtual int isA() { return vdkbclass_date_edit; }
  void PopMenu() { popmenu->Popup(); }
  VDKBWidgetPopMenu* WidgetPopmenu() { return popmenu; }
  // designer
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool OnSetShowTime(VDKObject*);
  bool OnSetFormat24(VDKObject*);
  //
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);

  DECLARE_SIGNAL_LIST(VDKBGnomeDateEdit);
  DECLARE_EVENT_LIST(VDKBGnomeDateEdit);
};
#endif
#endif

