/* Corrupt a file in controllable ways, to test vdmfec. */

#include "defs.h"
#include "util.h"

char Usage[] = "usage: %s -o<offset> -n<nbytes> file\n";
#define USAGE() msg(Usage, Progname)

long Offset;
int Nbytes;

void doit(char *);

int main(int argc, char **argv)
{
	int c;

	Progname = *argv;

	/* Parse option arguments. */

	while ((c = getopt(argc, argv, "o:n:")) != EOF) {
		switch (c) {

		case 'o':
			Offset = atoik(optarg);
			break;

		case 'n':
			Nbytes = atoik(optarg);
			break;

		default:
			USAGE();
			exit(1);
		}
	}
	argc -= optind;
	argv += optind;

	if (argc != 1) {
		USAGE();
		exit(1);
	}

	doit(argv[0]);

	return 0;
}

void doit(char *name)
{
	u_char *block;
	FILE *file, *random;

	block = new_array(u_char, Nbytes);
	file = fileopen(name, "r+");
	fseek(file, Offset, SEEK_SET);
	random = fileopen("/dev/urandom", "r");
	fread(block, 1, Nbytes, random);
	fwrite(block, 1, Nbytes, file);
	fclose(file);
	fclose(random);
}
