/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.Tokenizer;
import com.sun.appserv.management.util.misc.TokenizerException;
import com.sun.appserv.management.util.misc.TokenizerInternal;
import com.sun.appserv.management.util.misc.TokenizerParams;
import java.util.ArrayList;
import java.util.List;

public final class TokenizerImpl
implements Tokenizer {
    final String[] mTokens;
    private static final char QUOTE_CHAR = '\"';

    public TokenizerImpl(String input) throws TokenizerException {
        this(input, new TokenizerParams());
    }

    public TokenizerImpl(String input, TokenizerParams params) throws TokenizerException {
        TokenizerInternal worker = new TokenizerInternal(input, params);
        List<Object> allTokens = worker.parseTokens();
        if (params.mMultipleDelimsCountAsOne) {
            allTokens = TokenizerImpl.removeMultipleDelims(allTokens);
        }
        this.mTokens = TokenizerImpl.interpretTokenList(allTokens);
    }

    static final List<Object> removeMultipleDelims(List<Object> list) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        boolean lastWasDelim = false;
        for (Object value : list) {
            if (value instanceof String) {
                resultList.add(value);
                lastWasDelim = false;
                continue;
            }
            if (lastWasDelim) continue;
            resultList.add(value);
            lastWasDelim = true;
        }
        return resultList;
    }

    static String[] interpretTokenList(List<Object> list) {
        ArrayList<String> resultList = new ArrayList<String>();
        boolean lastWasDelim = true;
        for (Object value : list) {
            if (value instanceof String) {
                resultList.add((String)value);
                lastWasDelim = false;
                continue;
            }
            if (lastWasDelim) {
                resultList.add("");
                continue;
            }
            lastWasDelim = true;
        }
        if (lastWasDelim && list.size() != 0) {
            resultList.add("");
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    @Override
    public String[] getTokens() {
        return this.mTokens;
    }
}

