/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.hanim;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

public abstract class HAnimObject {
    private static final float ZEROEPS = 1.0E-4f;
    protected String name;
    protected ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private static Vector3f tempVec = new Vector3f();
    private static AxisAngle4f tempAxis = new AxisAngle4f();
    private static Matrix4f tempMtx1 = new Matrix4f();
    private static Matrix4f tempMtx2 = new Matrix4f();
    private static Matrix4f tempMtx3 = new Matrix4f();

    protected HAnimObject() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    private static boolean floatEq(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.0f) {
            f3 *= -1.0f;
        }
        return f3 < 1.0E-4f;
    }

    protected static void updateMatrix(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, Matrix4f matrix4f) {
        HAnimObject.tempVec.x = -fArray[0];
        HAnimObject.tempVec.y = -fArray[1];
        HAnimObject.tempVec.z = -fArray[2];
        tempMtx3.setIdentity();
        tempMtx3.setTranslation(tempVec);
        float f = 1.0f;
        if (HAnimObject.floatEq(fArray3[0], fArray3[1]) && HAnimObject.floatEq(fArray3[0], fArray3[2])) {
            f = fArray3[0];
            tempMtx1.set(f);
        } else {
            HAnimObject.tempAxis.x = fArray4[0];
            HAnimObject.tempAxis.y = fArray4[1];
            HAnimObject.tempAxis.z = fArray4[2];
            HAnimObject.tempAxis.angle = -fArray4[3];
            double d = 1.0 / Math.sqrt(HAnimObject.tempAxis.x * HAnimObject.tempAxis.x + HAnimObject.tempAxis.y * HAnimObject.tempAxis.y + HAnimObject.tempAxis.z * HAnimObject.tempAxis.z);
            HAnimObject.tempAxis.x = (float)((double)HAnimObject.tempAxis.x * d);
            HAnimObject.tempAxis.y = (float)((double)HAnimObject.tempAxis.y * d);
            HAnimObject.tempAxis.z = (float)((double)HAnimObject.tempAxis.z * d);
            tempMtx1.set(tempAxis);
            tempMtx2.mul(tempMtx1, tempMtx3);
            tempMtx1.setIdentity();
            HAnimObject.tempMtx1.m00 = fArray3[0];
            HAnimObject.tempMtx1.m11 = fArray3[1];
            HAnimObject.tempMtx1.m22 = fArray3[2];
            tempMtx3.mul(tempMtx1, tempMtx2);
            HAnimObject.tempAxis.x = fArray4[0];
            HAnimObject.tempAxis.y = fArray4[1];
            HAnimObject.tempAxis.z = fArray4[2];
            HAnimObject.tempAxis.angle = fArray4[3];
            tempMtx1.set(tempAxis);
        }
        tempMtx2.mul(tempMtx1, tempMtx3);
        float f2 = fArray2[0] * fArray2[0] + fArray2[1] * fArray2[1] + fArray2[2] * fArray2[2];
        if (f2 < 1.0E-4f) {
            HAnimObject.tempAxis.x = 0.0f;
            HAnimObject.tempAxis.y = 0.0f;
            HAnimObject.tempAxis.z = 1.0f;
            HAnimObject.tempAxis.angle = 0.0f;
        } else {
            if ((double)f2 > 1.01 || (double)f2 < 0.99) {
                float f3 = (float)(1.0 / Math.sqrt(f2));
                HAnimObject.tempAxis.x = fArray2[0] * f3;
                HAnimObject.tempAxis.y = fArray2[1] * f3;
                HAnimObject.tempAxis.z = fArray2[2] * f3;
            } else {
                HAnimObject.tempAxis.x = fArray2[0];
                HAnimObject.tempAxis.y = fArray2[1];
                HAnimObject.tempAxis.z = fArray2[2];
            }
            HAnimObject.tempAxis.angle = fArray2[3];
        }
        tempMtx1.set(tempAxis);
        tempMtx3.mul(tempMtx1, tempMtx2);
        HAnimObject.tempVec.x = fArray[0];
        HAnimObject.tempVec.y = fArray[1];
        HAnimObject.tempVec.z = fArray[2];
        tempMtx1.setIdentity();
        tempMtx1.setTranslation(tempVec);
        tempMtx2.mul(tempMtx1, tempMtx3);
        HAnimObject.tempVec.x = fArray5[0];
        HAnimObject.tempVec.y = fArray5[1];
        HAnimObject.tempVec.z = fArray5[2];
        tempMtx1.setIdentity();
        tempMtx1.setTranslation(tempVec);
        matrix4f.mul(tempMtx1, tempMtx2);
    }
}

