<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

function wi_wizard_title()
{
    global $title;

    $html = 'WebIssues Server ' . VERSION;

    if ( !empty( $title ) )
        $html .= ' - ' . htmlspecialchars( $title );

    return $html;
}

function wi_wizard_pages()
{
    global $page_titles, $page, $result;

    $html = '';
    $found = false;

    foreach ( $page_titles as $id => $title ) {
        if ( $id == $page ) {
            $class = $result ? 'current' : 'error';
            $found = true;
        } else {
            $class = $found ? 'pending' : 'done';
        }
        $html .= "<li class=\"$class\">$title</li>";
    }

    return $html;
}

function wi_wizard_buttons()
{
    global $page, $result;

    if ( !empty( $page ) ) {
        if ( $result )
            return "<input type=\"submit\" value=\"Continue\" />";
        else
            return "<input type=\"submit\" value=\"Retry\" />";
    }

    return '';
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
  <title><?php echo wi_wizard_title(); ?></title>
  <style type="text/css">
  <!--
body { font: 13px/150% 'Trebuchet MS', 'Lucida Grande', Verdana, Sans-Serif; color: #494949; background: #eee; margin: 0px; padding: 15px 0px; }
table { width: 100%; border-collapse: collapse; }
th { font-weight: bold; font-size: 130%; text-align: left; padding: 15px 15px; color: white; background: #46b; border-top: solid 1px white; border-bottom: solid 1px white; }
td { vertical-align: top; }
td.pages { background: #444c55; width: 120px; border: solid 1px white; padding: 20px 10px 10px 10px; }
td.pages ul { margin: 0px; padding: 0px 0px 0px 20px; }
td.pages li { margin: 0px 0px 5px 0px; }
li.current, li.error { font-weight: bold; }
li.done { color: #0f0; }
li.current { color: #fff; }
li.error { color: #f00; }
li.pending { color: #aaa; }
td.main { background: #fff; width: 620px; height: 300px; padding: 20px 10px 10px 20px; }
td.main p { margin: 0px 0px 10px 0px; }
td.buttons { background: #fff; height: 50px; text-align: right; vertical-align: bottom; padding: 10px; }
td.buttons input { font: 13px/100% 'Trebuchet MS', 'Lucida Grande', Verdana, Sans-Serif; color: #000; background: #ccc; border: outset 1px #ccc; padding: 2px 10px; }
  -->
  </style>
</head>
<body>
  <form method="POST" action="<?php echo SCRIPT; ?>">
    <input type="hidden" name="action" value="<?php echo $page; ?>" />
    <table>
      <tr>
        <th></th>
        <th colspan="2"><?php echo wi_wizard_title(); ?></th>
        <th></th>
      </tr>
      <tr>
        <td></td>
        <td rowspan="2" class="pages">
          <ul>
            <?php echo wi_wizard_pages(); ?>
          </ul>
        </td>
        <td class="main">
          <?php echo $body; ?>
        </td>
        <td></td>
      </tr>
      <tr>
        <td></td>
        <td class="buttons">
          <?php echo wi_wizard_buttons(); ?>
        </td>
        <td></td>
      </tr>
    </table>
  </form>
</body>
</html>
