/**
 * Disk.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente un disque defini par l'inegalite 
 * <code>(x - x0)^2 + (y - y0)^2 <= r^2</code> avec <code>x0, y0, r</code> reels. 
 *
 * @author Nicolae
 */
public class Disk extends DefaultSet {

	private double x;
	private double y;
	private double r2;
	
	/**
	 * Cache le constructor standard.
	 */
	private Disk() {}
		
	/**
	 * Constructor qui initialise les coefficients.
	 *
	 * @param a coefficient.
	 * @param b coefficient.
	 * @param c coefficient.
	 */
	public Disk(double x0, double y0, double r) {
		x = x0;
		y = y0;
		r2 = r * r;
	}
	
	/* (non-Javadoc)
	 * @see maths.DefaultSet#contains(double, double)
	 */
	public boolean contains(double re, double im) {
		double dx = re - x;
		double dy = im - y;
		
		return dx * dx + dy * dy <= r2;
	}

}
