// SPDX-License-Identifier: GPL-2.0
//
// Copyright (c) 2020 BayLibre, SAS.
// Author: Jerome Brunet <jbrunet@baylibre.com>

#include <linux/bitfield.h>
#include <sound/pcm_params.h>
#include <sound/soc.h>
#include <sound/soc-dai.h>

#include <dt-bindings/sound/meson-aiu.h>
#include "aiu.h"
#include "meson-codec-glue.h"

#define CTRL_DIN_EN			15
#define CTRL_CLK_INV			BIT(14)
#define CTRL_LRCLK_INV			BIT(13)
#define CTRL_I2S_IN_BCLK_SRC		BIT(11)
#define CTRL_DIN_LRCLK_SRC_SHIFT	6
#define CTRL_DIN_LRCLK_SRC		(0x3 << CTRL_DIN_LRCLK_SRC_SHIFT)
#define CTRL_BCLK_MCLK_SRC		GENMASK(5, 4)
#define CTRL_DIN_SKEW			GENMASK(3, 2)
#define CTRL_I2S_OUT_LANE_SRC		0

#define AIU_ACODEC_OUT_CHMAX		2

static const char * const aiu_acodec_ctrl_mux_texts[] = {
	"DISABLED", "I2S", "PCM",
};

static int aiu_acodec_ctrl_mux_put_enum(struct snd_kcontrol *kcontrol,
					struct snd_ctl_elem_value *ucontrol)
{
	struct snd_soc_component *component =
		snd_soc_dapm_kcontrol_component(kcontrol);
	struct snd_soc_dapm_context *dapm =
		snd_soc_dapm_kcontrol_dapm(kcontrol);
	struct soc_enum *e = (struct soc_enum *)kcontrol->private_value;
	unsigned int mux, changed;

	mux = snd_soc_enum_item_to_val(e, ucontrol->value.enumerated.item[0]);
	changed = snd_soc_component_test_bits(component, e->reg,
					      CTRL_DIN_LRCLK_SRC,
					      FIELD_PREP(CTRL_DIN_LRCLK_SRC,
							 mux));

	if (!changed)
		return 0;

	/* Force disconnect of the mux while updating */
	snd_soc_dapm_mux_update_power(dapm, kcontrol, 0, NULL, NULL);

	snd_soc_component_update_bits(component, e->reg,
				      CTRL_DIN_LRCLK_SRC |
				      CTRL_BCLK_MCLK_SRC,
				      FIELD_PREP(CTRL_DIN_LRCLK_SRC, mux) |
				      FIELD_PREP(CTRL_BCLK_MCLK_SRC, mux));

	snd_soc_dapm_mux_update_power(dapm, kcontrol, mux, e, NULL);

	return 0;
}

static SOC_ENUM_SINGLE_DECL(aiu_acodec_ctrl_mux_enum, AIU_ACODEC_CTRL,
			    CTRL_DIN_LRCLK_SRC_SHIFT,
			    aiu_acodec_ctrl_mux_texts);

static const struct snd_kcontrol_new aiu_acodec_ctrl_mux =
	SOC_DAPM_ENUM_EXT("ACodec Source", aiu_acodec_ct