<?php
/**
 * Include necessary files
 *
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @package Zoph
 * @author Jason Geiger
 * @author Jeroen Roos
 */
use db\exception as databaseException;
use web\redirect;

try {
    require_once "autoload.inc.php";
    require_once "exception.inc.php";
    require_once "config.inc.php";
    if (!defined("CLI")) {
        require_once "requirements.inc.php";
    }
} catch (configurationException $e) {
    settings::$php_loc = dirname($_SERVER['SCRIPT_FILENAME']);
    redirect::redirect("install.php", "Run install script");
} catch (databaseException $e) {
    settings::$php_loc = dirname($_SERVER['SCRIPT_FILENAME']);
    redirect::redirect("install.php", "Run install script");
}

require_once "variables.inc.php";
require_once "auth.inc.php";

?>
